<?php
/**
 * Theme functions and definitions.
 *
 * For additional information on potential customization options,
 * read the developers' documentation:
 *
 * https://developers.elementor.com/docs/hello-elementor-theme/
 *
 * @package HelloElementorChild
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_ELEMENTOR_CHILD_VERSION', '2.0.0' );

/**
 * Load child theme scripts & styles.
 *
 * @return void
 */
function hello_elementor_child_scripts_styles() {

	wp_enqueue_style(
		'hello-elementor-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		[
			'hello-elementor-theme-style',
		],
		HELLO_ELEMENTOR_CHILD_VERSION
	);

}
add_action( 'wp_enqueue_scripts', 'hello_elementor_child_scripts_styles', 20 );


function register_home_sales_cpt() {

    $labels = array(
        'name'               => 'Home Sales',
        'singular_name'      => 'Home Sale',
        'menu_name'          => 'Home Sales',
        'add_new'            => 'Add New',
        'add_new_item'       => 'Add New Home Sale',
        'edit_item'          => 'Edit Home Sale',
        'new_item'           => 'New Home Sale',
        'view_item'          => 'View Home Sale',
        'search_items'       => 'Search Home Sales',
        'not_found'          => 'No Home Sales Found',
        'not_found_in_trash' => 'No Home Sales Found in Trash',
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'menu_icon'          => 'dashicons-admin-home',
        'supports'           => array('title', 'editor', 'thumbnail'),
        'has_archive'        => true,
        'rewrite'            => array('slug' => 'home-sales'),
        'show_in_rest'       => true,
    );

    register_post_type('home_sales', $args);
}
add_action('init', 'register_home_sales_cpt');

function register_home_sales_category() {

    $labels = array(
        'name'              => 'Home Sales Categories',
        'singular_name'     => 'Home Sales Category',
        'search_items'      => 'Search Categories',
        'all_items'         => 'All Categories',
        'parent_item'       => 'Parent Category',
        'parent_item_colon' => 'Parent Category:',
        'edit_item'         => 'Edit Category',
        'update_item'       => 'Update Category',
        'add_new_item'      => 'Add New Category',
        'new_item_name'     => 'New Category Name',
        'menu_name'         => 'Categories',
    );

    $args = array(
        'hierarchical'      => true, // Works like default post categories
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'home-sales-category'),
        'show_in_rest'      => true,
    );

    register_taxonomy('home_sales_category', array('home_sales'), $args);
}
add_action('init', 'register_home_sales_category');
