<?php
/**
 * Class to add a "Customizer Tab" for 'customize_product' product type
 * with repeater fields using select boxes populated from get_option().
 * Includes JS for conditional display.
 */
class WC_Customize_Product_Tab {

    /**
     * Fields for the repeater.
     */
    private $fields = [
        'badge_shapes'      => 'Badge Shape',
        'badge_sizes'       => 'Size',
        'badge_thicknesses' => 'Thickness',
        'badge_finishes'    => 'Finish',
        'badge_colors'      => 'Color',
        'badge_corners'     => 'Corners',
        'badge_backings'    => 'Backing',
        'backing_price'     => 'Backing Price', // New field!
        'badge_sku'       => 'Badge SKU' // New field!
    ];

    /**
     * Constructor.
     */
    public function __construct() {
        add_filter( 'woocommerce_product_data_tabs', [ $this, 'add_custom_product_data_tab' ] );
        add_action( 'woocommerce_product_data_panels', [ $this, 'custom_product_data_tab_content' ] );
        add_action( 'woocommerce_process_product_meta_customize_product', [ $this, 'save_custom_product_data' ] );
        add_action( 'admin_footer', [ $this, 'custom_js_for_tab_visibility' ] );
        add_action( 'add_meta_boxes', [ $this,'ptp_add_custom_metabox' ]);
        add_action( 'wp_ajax_generate_customizer_options', [ $this,'generate_customizer_options_callback' ]);
        add_action('save_post', [ $this,'ptp_save_metabox_data']);
        add_action('admin_enqueue_scripts', [ $this,'ptp_enqueue_admin_scripts']);

        add_action('add_meta_boxes', [$this, 'add_image_meta_box']);
        add_action('save_post', [$this, 'save_meta_box_data']);
        add_action('admin_enqueue_scripts', [$this, 'enqueue_media_uploader']);
    }

     public function add_image_meta_box() {
        add_meta_box(
            'badge_shape_images',
            __('Badge Shape Images', 'your-textdomain'),
            [$this, 'render_meta_box'],
            'product', // Replace with your custom post type if needed
            'side',
            'default'
        );
    }

     public function render_meta_box($post) {
        $oval_id = get_post_meta($post->ID, '_badge_shape_oval_image_id', true);
        $rect_id = get_post_meta($post->ID, '_badge_shape_rectangle_image_id', true);

        $oval_url = $oval_id ? wp_get_attachment_image_url($oval_id, 'thumbnail') : '';
        $rect_url = $rect_id ? wp_get_attachment_image_url($rect_id, 'thumbnail') : '';

        wp_nonce_field('badge_shape_images_nonce_action', 'badge_shape_images_nonce');

        ?>
        <p><strong>Oval Image</strong></p>
        <img id="oval_preview" src="<?php echo esc_url($oval_url); ?>" style="max-width:100%; margin-bottom:5px;" />
        <input type="hidden" id="badge_shape_oval_image_id" name="badge_shape_oval_image_id" value="<?php echo esc_attr($oval_id); ?>" />
        <button type="button" class="button upload-image" data-target="#badge_shape_oval_image_id" data-preview="#oval_preview">Upload Oval</button>

        <p><strong>Rectangle Image</strong></p>
        <img id="rect_preview" src="<?php echo esc_url($rect_url); ?>" style="max-width:100%; margin-bottom:5px;" />
        <input type="hidden" id="badge_shape_rectangle_image_id" name="badge_shape_rectangle_image_id" value="<?php echo esc_attr($rect_id); ?>" />
        <button type="button" class="button upload-image" data-target="#badge_shape_rectangle_image_id" data-preview="#rect_preview">Upload Rectangle</button>

        <script>
        jQuery(document).ready(function($) {
            $('.upload-image').on('click', function(e) {
                e.preventDefault();
                let targetInput = $(this).data('target');
                let previewImg = $(this).data('preview');
                let frame = wp.media({ title: 'Select Image', multiple: false, library: { type: 'image' } });

                frame.on('select', function() {
                    let attachment = frame.state().get('selection').first().toJSON();
                    $(targetInput).val(attachment.id);
                    $(previewImg).attr('src', attachment.url);
                });

                frame.open();
            });
        });
        </script>
        <?php
    }

    public function save_meta_box_data($post_id) {
        if (!isset($_POST['badge_shape_images_nonce']) ||
            !wp_verify_nonce($_POST['badge_shape_images_nonce'], 'badge_shape_images_nonce_action')) {
            return;
        }

        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

        if (isset($_POST['badge_shape_oval_image_id'])) {
            update_post_meta($post_id, '_badge_shape_oval_image_id', intval($_POST['badge_shape_oval_image_id']));
        }

        if (isset($_POST['badge_shape_rectangle_image_id'])) {
            update_post_meta($post_id, '_badge_shape_rectangle_image_id', intval($_POST['badge_shape_rectangle_image_id']));
        }
    }

    public function enqueue_media_uploader() {
        if (is_admin()) {
            wp_enqueue_media();
        }
    }


    function ptp_enqueue_admin_scripts($hook) {
        global $post;
        if ($hook == 'post-new.php' || $hook == 'post.php') {
            if ('product' === $post->post_type) {
                wp_enqueue_script('ptp-admin-js', CBC_PLUGIN_URL . 'js/ptp-admin.js', ['jquery'], false, true);
                wp_enqueue_style('ptp-admin-css', CBC_PLUGIN_URL . 'css/ptp-admin.css');
            }
        }
    }

    function ptp_add_custom_metabox() {
        add_meta_box(
            'ptp_product_tier_pricing',
            'Product Tier Pricing',
            array($this,'ptp_render_metabox'),
            'product',
            'normal',
            'default'
        );
    }

        function ptp_save_metabox_data($post_id) {
            if (!isset($_POST['ptp_nonce']) || !wp_verify_nonce($_POST['ptp_nonce'], 'ptp_save_metabox')) {
                return;
            }

            if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
                return;
            }

            if (!current_user_can('edit_post', $post_id)) {
                return;
            }

            if (isset($_POST['product_custom_options'])) {
                $options_data = $_POST['product_custom_options'];
                update_post_meta($post_id, 'product_custom_options', $options_data);
            }
        }

    function ptp_render_metabox($post) {
        // Retrieve saved volume pricing data
        $options_data = get_post_meta($post->ID, 'product_custom_options', true);
        if (!is_array($options_data)) $options_data = [];

        // Fetch SKUs from _custom_repeater_data
        $repeater_data = get_post_meta($post->ID, '_custom_repeater_data', true);
        $skus = [];
        if (is_array($repeater_data)) {
            foreach ($repeater_data as $entry) {
                if (isset($entry['badge_sku']) && !in_array($entry['badge_sku'], $skus)) {
                    $skus[] = $entry['badge_sku'];
                }
            }
        }

    ?>
<div id="ptp-metabox">
    <?php if (!empty($skus)) : ?>
    <?php foreach ($skus as $index => $sku) : ?>
    <div class="sku-block">
        <label>SKU: <input type="text" name="product_custom_options[<?php echo $index; ?>][sku]"
                value="<?php echo esc_attr($sku); ?>" readonly /></label>

        <div class="volume-pricing-entries">
            <?php
                        // Find existing data for this SKU
                        $existing_entry = null;
                        foreach ($options_data as $saved_entry) {
                            if (isset($saved_entry['sku']) && $saved_entry['sku'] === $sku) {
                                $existing_entry = $saved_entry;
                                break;
                            }
                        }

                        $entry_index = 1;
                        if ($existing_entry) :
                            while (isset($existing_entry["qty{$entry_index}"]) && isset($existing_entry["price{$entry_index}"])) :
                        ?>
            <div class="volume-pricing-entry">
                <input type="text" name="product_custom_options[<?php echo $index; ?>][qty<?php echo $entry_index; ?>]"
                    value="<?php echo esc_attr($existing_entry["qty{$entry_index}"]); ?>"
                    placeholder="Quantity Range (e.g., 1-4)" />
                <input type="text"
                    name="product_custom_options[<?php echo $index; ?>][price<?php echo $entry_index; ?>]"
                    value="<?php echo esc_attr($existing_entry["price{$entry_index}"]); ?>" placeholder="Price" />
                <button class="remove-entry">Remove</button>
            </div>
            <?php
                                $entry_index++;
                            endwhile;
                        else :
                        ?>
            <div class="volume-pricing-entry">
                <input type="text" name="product_custom_options[<?php echo $index; ?>][qty1]"
                    placeholder="Quantity Range (e.g., 1-4)" />
                <input type="text" name="product_custom_options[<?php echo $index; ?>][price1]" placeholder="Price" />
                <button class="remove-entry">Remove</button>
            </div>
            <?php endif; ?>
        </div>
        <button class="add-entry">Add More</button>
        <hr />
    </div>
    <?php endforeach; ?>
    <?php else : ?>
    <p>No SKUs found in the <code>_custom_repeater_data</code> field.</p>
    <?php endif; ?>
</div>

<?php wp_nonce_field('ptp_save_metabox', 'ptp_nonce'); ?>
<?php
}


    function generate_customizer_options_callback() {
            // Verify nonce
           // check_ajax_referer( 'customizer_options_nonce', 'security' );

            // (Optional) Get the post ID if needed
           echo  $post_id = isset( $_POST['post_id'] ) ? intval( $_POST['post_id'] ) : 0;

            // Example: Generate some dynamic options
          
            wp_die(); // Required to end AJAX properly
    }

    function add_customizer_options_metabox() {
            add_meta_box(
                'customizer_options_metabox',           // Metabox ID
                __( 'Customizer Options', 'your-textdomain' ), // Title
                array($this,'render_customizer_options_metabox'),    // Callback
                'product',                              // Post type
                'normal',                               // Context
                'default'                               // Priority
            );
    }

    function render_customizer_options_metabox( $post ) {?>

<p>
    <label for="customizer_enable"><?php esc_html_e( 'Enable Customizer?', 'your-textdomain' ); ?></label>
    <input type="checkbox" id="customizer_enable" name="customizer_options[enable]" value="1"
        <?php checked( ! empty( $customizer_data['enable'] ), true ); ?> />
</p>


<button type="button" id="generate_options_button" class="button" data-post="<?php echo get_the_ID();?>">
    <?php esc_html_e( 'Generate Options', 'your-textdomain' ); ?>
</button>

<div id="generated-options" style="margin-top: 10px;"></div>



<?php }


    /**
     * Add "Customizer Tab" for customize_product type.
     */
    public function add_custom_product_data_tab( $tabs ) {
        $tabs['customizer_tab'] = [
            'label'    => __( 'Customizer Tab', 'woocommerce' ),
            'target'   => 'customizer_product_data',
            'class'    => [],
            'priority' => 60,
        ];

        return $tabs;
    }

    /**
     * Content of the "Customizer Tab".
     */
    public function custom_product_data_tab_content() {
        global $post;
       
        $repeater_data = get_post_meta( $post->ID, '_custom_repeater_data', true );
        if ( empty( $repeater_data ) || ! is_array( $repeater_data ) ) {
            $repeater_data = [ [] ]; // One row by default
        }
        // echo "data";
        // echo "<pre>";
        // print_r($repeater_data);
        // echo "</pre>";
        // die;


        ?>
<div id="customizer_product_data" class="panel woocommerce_options_panel hidden" style="display: none;">
    <div class="options_group">
        <p><?php esc_html_e( 'Add badge configurations below:', 'woocommerce' ); ?></p>

        <div id="custom_repeater_template" style="display: none;">
            <div class="custom_repeater_row" style="margin-bottom: 20px; border: 1px solid #ccc; padding: 10px;">
                <?php foreach ( $this->fields as $field_key => $field_label ) : ?>
                <p class="form-field">
                    <label for="__INDEX___<?php echo esc_attr( $field_key ); ?>">
                        <?php echo esc_html( $field_label ); ?>
                    </label>

                    <?php if ( $field_key === 'backing_price'  || $field_key ==='badge_sku' ) : ?>
                    <input type="text" name="custom_repeater_data[__INDEX__][<?php echo esc_attr( $field_key ); ?>]"
                        id="__INDEX___<?php echo esc_attr( $field_key ); ?>" placeholder="" style="width: 100%;" />
                    <?php if ( $field_key === 'backing_price'):?>
                    <span class="description"><?php esc_html_e( '0.00 means included.', 'woocommerce' ); ?></span>
                    <?php endif;?>
                    <?php else : ?>
                    <?php
                            // Determine if this field should be multiselect
                            $is_multiselect = in_array( $field_key, [ 'badge_colors', 'badge_corners' ] );
                            $multiple = $is_multiselect ? 'multiple' : '';
                            $css_class = $is_multiselect ? 'select2-field' : 'select2-field_no';
                            $name_attr = $is_multiselect
                                ? "custom_repeater_data[__INDEX__][{$field_key}][]"
                                : "custom_repeater_data[__INDEX__][{$field_key}]";

                            $field_options = get_option( $field_key, [] );
                            ?>
                    <select class="<?php echo $css_class;?>" name="<?php echo esc_attr( $name_attr ); ?>"
                        id="__INDEX___<?php echo esc_attr( $field_key ); ?>" <?php echo $multiple; ?>
                        style="width: 100%;">
                        <?php
                                // Single select fields get the "Select" option
                                if ( ! $is_multiselect ) {
                                    echo '<option value="">Select</option>';
                                }

                                if ( ! empty( $field_options ) && is_array( $field_options ) ) :
                                    foreach ( $field_options as $option_value => $option_label ) :
                                        if ( $field_key === 'badge_colors' && isset( $option_label['name'], $option_label['code'] ) ) {
                                            echo '<option value="' . esc_attr( $option_label['code'] ) . '">' . esc_html( $option_label['name'] ) . '</option>';
                                        } else {
                                            $option_val = is_array( $option_label ) ? $option_label['name'] : $option_label;
                                            echo '<option value="' . esc_attr( $option_val ) . '">' . esc_html( $option_val ) . '</option>';
                                        }
                                    endforeach;
                                endif;
                                ?>
                    </select>
                    <?php endif; ?>
                </p>
                <?php endforeach; ?>

                <button type="button" class="button remove_row"><?php esc_html_e( 'Remove', 'woocommerce' ); ?></button>
            </div>

        </div>



        <div id="custom_repeater_wrapper">

            <?php foreach ( $repeater_data as $index => $row ) : ?>
            <div class="custom_repeater_row" style="margin-bottom: 20px; border: 1px solid #ccc; padding: 10px;">
                <?php foreach ( $this->fields as $field_key => $field_label ) : ?>
                <?php
                $field_value = isset( $row[ $field_key ] ) ? (array) $row[ $field_key ] : [];
                $field_options = get_option( $field_key, [] );
            ?>
                <p class="form-field">
                    <label for="<?php echo esc_attr( $field_key . '_' . $index ); ?>">
                        <?php echo esc_html( $field_label ); ?>
                    </label>

                    <?php if ( $field_key === 'backing_price'  || $field_key ==='badge_sku'  ) : ?>
                    <input type="text"
                        name="custom_repeater_data[<?php echo esc_attr( $index ); ?>][<?php echo esc_attr( $field_key ); ?>]"
                        id="<?php echo esc_attr( $field_key . '_' . $index ); ?>"
                        value="<?php echo esc_attr( implode( ', ', $field_value ) ); ?>" placeholder=""
                        style="width: 100%;" />
                    <?php if ( $field_key === 'backing_price'):?>
                    <span class="description"><?php esc_html_e( '0.00 means included.', 'woocommerce' ); ?></span>
                    <?php endif;?>
                    <?php else : ?>
                    <?php
                        // Determine if it's a multiselect field
                        $is_multiselect = in_array( $field_key, [ 'badge_colors', 'badge_corners' ] );
                        $multiple = $is_multiselect ? 'multiple' : '';
                        $multiple = $is_multiselect ? 'multiple' : '';
                        $css_class = $is_multiselect ? 'select2-field' : 'select2-field_no';
                        $name_attr = $is_multiselect
                            ? "custom_repeater_data[{$index}][{$field_key}][]"
                            : "custom_repeater_data[{$index}][{$field_key}]";
                    ?>
                    <select class="<?php echo $css_class;?>" name="<?php echo esc_attr( $name_attr ); ?>"
                        id="<?php echo esc_attr( $field_key . '_' . $index ); ?>" <?php echo $multiple; ?>
                        style="width: 100%;">
                        <?php
                        // Default option for single select
                        if ( ! $is_multiselect ) {
                            echo '<option value="">Select</option>';
                        }

                        if ( ! empty( $field_options ) && is_array( $field_options ) ) :
                            foreach ( $field_options as $option_value => $option_label ) :
                                if ( $field_key === 'badge_colors' && isset( $option_label['name'], $option_label['code'] ) ) {
                                    $selected = in_array( $option_label['code'], $field_value ) ? 'selected' : '';
                                    echo '<option value="' . esc_attr( $option_label['code'] ) . '" ' . $selected . '>' . esc_html( $option_label['name'] ) . '</option>';
                                } else {
                                    // Determine selected for single or multiselect
                                    $option_val = is_array( $option_label ) ? $option_label['name'] : $option_label;
                                    $selected = in_array( $option_val, $field_value ) ? 'selected' : '';
                                    echo '<option value="' . esc_attr( $option_val ) . '" ' . $selected . '>' . esc_html( $option_val ) . '</option>';
                                }
                            endforeach;
                        endif;
                        ?>
                    </select>
                    <?php endif; ?>
                </p>
                <?php endforeach; ?>

                <button type="button" class="button remove_row"><?php esc_html_e( 'Remove', 'woocommerce' ); ?></button>
            </div>
            <?php endforeach; ?>

        </div>

        <p>
            <button type="button" class="button" id="add_row"><?php esc_html_e( 'Add Row', 'woocommerce' ); ?></button>
        </p>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    function reIndexRows() {
        $('#custom_repeater_wrapper .custom_repeater_row').each(function(index) {
            $(this).find('select, input').each(function() {
                var name = $(this).attr('name');
                if (name) {
                    // Only replace __INDEX__ or numeric index
                    //var newName = name.replace(/__INDEX__|\[\d+\]/, '[' + index + ']');
                    var newName = name.replace(/__INDEX__|\d+/, index);
                    // alert(newName);
                    $(this).attr('name', newName);
                }

                var id = $(this).attr('id');
                if (id) {
                    // Replace __INDEX__ or trailing _0, _1, etc.
                    var newId = id.replace(/__INDEX__|_\d+$/, '_' + index);
                    $(this).attr('id', newId);
                }
            });
        });
    }

    $('#add_row').on('click', function() {
        var newRow = $('#custom_repeater_template .custom_repeater_row').clone();
        $('#custom_repeater_wrapper').append(newRow);

        // $('.select2-field').select2({
        //     placeholder: 'Select an option',
        //     allowClear: true,
        //     width: '100%'
        // });

        // Initialize Select2 for new selects
        newRow.find('.select2-field').select2({
            placeholder: 'Select options',
            allowClear: true,
            width: '100%'
        });

        reIndexRows();
    });

    // Remove row
    $('#custom_repeater_wrapper').on('click', '.remove_row', function() {
        $(this).closest('.custom_repeater_row').remove();
        reIndexRows();
    });

    // Initialize Select2 for existing rows
    $('#customizer_product_data #custom_repeater_wrapper .select2-field').select2({
        placeholder: 'Select options',
        allowClear: true,
        width: '100%'
    });
});
</script>
<?php
    }

    /**
     * Save the repeater data.
     */
    public function save_custom_product_data( $post_id ) {

      
        // if ( isset( $_POST['custom_repeater_data'] ) && is_array( $_POST['custom_repeater_data'] ) ) {
        //         $cleaned_data = [];
        //         foreach ( $_POST['custom_repeater_data'] as $row ) {
        //             $cleaned_row = [];
        //             foreach ( $this->fields as $field_key => $field_label ) {
        //                 if ( isset( $row[ $field_key ] ) ) {
        //                     $value = $row[ $field_key ];
        //                     $cleaned_row[ $field_key ] = is_array( $value )
        //                         ? $value
        //                         : $value;
        //                 } else {
        //                     $cleaned_row[ $field_key ] = '';
        //                 }
        //             }
        //             $cleaned_data[] = $cleaned_row;
        //         }
        //         update_post_meta( $post_id, '_custom_repeater_data', $cleaned_data );
        // }

        if ( isset( $_POST['custom_repeater_data'] ) && is_array( $_POST['custom_repeater_data'] ) ) {
            $cleaned_data = [];

            foreach ( $_POST['custom_repeater_data'] as $row ) {
                $cleaned_row = [];

                // Check if row has any non-empty value
                $has_data = false;

                foreach ( $this->fields as $field_key => $field_label ) {
                    if ( isset( $row[ $field_key ] ) ) {
                        $value = $row[ $field_key ];

                        // If value is an array (like multiselect), remove empty items
                        if ( is_array( $value ) ) {
                            $value = array_filter( $value ); // Remove empty values
                        }

                        // Check if field has non-empty value
                        if ( ! empty( $value ) ) {
                            $has_data = true;
                        }

                        $cleaned_row[ $field_key ] = $value;
                    } else {
                        $cleaned_row[ $field_key ] = '';
                    }
                }

                // Only add this row if it has any data
                if ( $has_data ) {
                    $cleaned_data[] = $cleaned_row;
                }
            }

            update_post_meta( $post_id, '_custom_repeater_data', $cleaned_data );
        }

        

       // update_post_meta($post_id, '_custom_repeater_data',  $_POST['custom_repeater_data'] );


    }

    /**
     * JS to show/hide the "Customizer Tab" based on product type.
     */
    public function custom_js_for_tab_visibility() {
        $screen = get_current_screen();
        if ( 'product' !== $screen->post_type ) {
            return;
        }
        ?>
<!-- <script>
jQuery(function($) {
    function toggleCustomizerTab() {
        var productType = $('#product-type').val();
        if (productType === 'customize_product') {
            $('.custom_tab, .customizer_tab').show();
            $('#customizer_product_data').show();
        } else {
            $('.custom_tab, .customizer_tab').hide();
            $('#customizer_product_data').hide();
        }
    }

    toggleCustomizerTab();
    $('#product-type').on('change', toggleCustomizerTab);
});
</script> -->
<?php
    }
}

// Initialize.
new WC_Customize_Product_Tab();