jQuery(function ($) {

    class CustomBadgeUI {

        constructor() {

            this.bindEvents();

            this.initColorPickers();

        }



        bindEvents() {

            $(document).on('click', '.cbc-add-btn', this.handleAdd.bind(this));

            $(document).on('click', '.cbc-remove', this.handleRemove.bind(this));

            $(document).on('click', '#generate_options_button', this.handleGenerateProductOptions.bind(this));

        }



        initColorPickers(context = document) {

            $(context).find('.cbc-color-picker').spectrum({

                preferredFormat: "hex",

                showInput: true,

                allowEmpty: false

            });

        }



        handleAdd(e) {

            const $button = $(e.currentTarget);

            const field = $button.data('field');

            const $form = $button.closest('form');

            const $container = $form.find('.cbc-repeater');



            let html = '';



            if (field === 'badge_colors') {

                html = `

                    <div class="cbc-group">

                        <input type="text" name="color_name[]" placeholder="Color Name">

                        <input type="text" class="cbc-color-picker" name="color_code[]" value="#000000">

                        <button type="button" class="button cbc-remove">Remove</button>

                    </div>`;

            } else {

                html = `

                    <div class="cbc-group">

                        <input type="text" name="values[]" value="">

                        <button type="button" class="button cbc-remove">Remove</button>

                    </div>`;

            }



            const $newGroup = $(html);

            $container.append($newGroup);

            this.initColorPickers($newGroup); // initialize picker in new group

        }



        handleRemove(e) {

            $(e.currentTarget).closest('.cbc-group').remove();

        }

        handleGenerateProductOptions(e){
            $('#generated-options').html('<em>Loading options...</em>');
            // Make the AJAX call
            var post_id=$('#post_ID').val();
            alert(post_id);
            $.ajax({
                url: customizer_ajax_obj.ajaxurl, // WordPress built-in AJAX handler URL
                type: 'POST',
                dataType: 'html', // Or 'json' if you want to send structured data
                data: {
                    action: 'generate_customizer_options',
                    post_id: $('#post_ID').val(), // Send the current product ID if needed
                    security: customizer_options_ajax.security // Send nonce for security
                },
                success: function(response) {
                    // Show the generated HTML
                    $('#generated-options').html(response);
                },
                error: function(xhr, status, error) {
                    $('#generated-options').html('<span style="color:red;">Error: ' + error + '</span>');
                }
            });

        }

    }



    new CustomBadgeUI();

});

