<?php

/**

 * Plugin Name: Custom Badge Creator

 * Description: Manage badge attributes like shape, size, thickness, etc. with separate forms.

 * Version: 1.0

 * Author: Fortmindz 

 */



if (!defined('ABSPATH')) exit;

if (!defined('PTP_PLUGIN_URL')) {
    define('CBC_PLUGIN_URL', plugin_dir_url(__FILE__));
}

class CustomBadgeCreator {

    private $fields = [

        'badge_type' => 'Badge Type',

        'badge_shapes' => 'Badge Shape',

        'badge_sizes' => 'Size',

        'badge_thicknesses' => 'Thickness',

        'badge_finishes' => 'Finish',

        'badge_colors' => 'Color',

        'badge_corners' => 'Corners',

        'badge_backings' => 'Backing'

    ];



    public function __construct() {

        add_action('admin_menu', [$this, 'add_settings_page']);

        add_action('admin_enqueue_scripts', [$this, 'admin_scripts']);

        add_action('admin_post_save_badge_fields', [$this, 'handle_form_submission']);

        add_action('admin_enqueue_scripts', [$this, 'admin_scripts']);

        add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), [ $this, 'add_settings_link' ] );

        add_action('admin_init', [$this, 'register_google_fonts_setting']);


    }

     // Register Google Fonts API setting
    public function register_google_fonts_setting() {
            register_setting('badge_plugin_settings_group', 'badge_google_fonts_api_key');

            add_settings_section(
                'badge_plugin_api_section',
                'Google Fonts API Settings',
                null,
                'my-plugin-settings'
            );

            add_settings_field(
                'google_fonts_api_key',
                'Google Fonts API Key',
                [$this, 'google_fonts_api_key_field_callback'],
                'my-plugin-settings',
                'badge_plugin_api_section'
            );
    }

    // Field input callback
    public function google_fonts_api_key_field_callback() {
        $value = esc_attr(get_option('badge_google_fonts_api_key', ''));
        echo '<input type="text" name="badge_google_fonts_api_key" value="' . $value . '" style="width: 400px;" />';
    }

    // Render default settings page

    // Render Google Fonts API settings page
    public function render_google_fonts_page() {
        ?>
            <div class="wrap">
                <h1>Google Fonts Settings</h1>
                <form method="post" action="options.php">
                    <?php
                    settings_fields('badge_plugin_settings_group');
                    do_settings_sections('my-plugin-settings');
                    submit_button();
                    ?>
                </form>
            </div>
        <?php
        }
    


     public function add_settings_link( $links ) {
        $settings_link = '<a href="options-general.php?page=custom-badge-creator">Settings</a>';
        array_unshift( $links, $settings_link );
        return $links;
    }



    public function add_settings_page_old() {

        add_options_page(

            'Custom Badge Creator',

            'Badge Creator',

            'manage_options',

            'custom-badge-creator',

            [$this, 'render_settings_page']

        );

    }

    public function add_settings_page() {
    // Main menu: Custom Badge Creator
        add_menu_page(
            'Custom Badge Creator',            // Page title
            'Badge Creator',                   // Menu title
            'manage_options',                  // Capability
            'custom-badge-creator',            // Menu slug
            [$this, 'render_settings_page'],   // Callback function
            'dashicons-art',                   // Icon (you can change this)
            25                                 // Position in menu
        );

        // Submenu: Google Fonts
        add_submenu_page(
            'custom-badge-creator',            // Parent slug
            'Google Fonts Settings',           // Page title
            'Google Fonts',                    // Menu title
            'manage_options',                  // Capability
            'google-fonts-settings',           // Submenu slug
            [$this, 'render_google_fonts_page'] // Callback function
        );
    }


    




    public function admin_scripts($hook) {

       // if ($hook !== 'settings_page_custom-badge-creator') return;



        wp_enqueue_style(

        'cbc-admin-style',

            plugin_dir_url(__FILE__) . 'css/cbc-admin.css',

            [],

            time()

        );



        wp_enqueue_script('jquery');

        wp_enqueue_script('spectrum', 'https://cdnjs.cloudflare.com/ajax/libs/spectrum/1.8.1/spectrum.min.js', ['jquery'], '1.8.1', true);

        wp_enqueue_style('spectrum-css', 'https://cdnjs.cloudflare.com/ajax/libs/spectrum/1.8.1/spectrum.min.css');

        wp_enqueue_script(

            'cbc-admin-script',

            plugin_dir_url(__FILE__) . 'js/cbc-admin.js',

            ['jquery'],

            time(),

            true

        );

        wp_localize_script(
            'cbc-admin-script', // script handle
            'customizer_ajax_obj', // JavaScript object
            array(
                'ajaxurl' => admin_url('admin-ajax.php'),
                'nonce'   => wp_create_nonce('customizer_ajax_nonce')
            )
        );

    }



    public function handle_form_submission() {

        if (!current_user_can('manage_options')) wp_die('Unauthorized');



        $field = ($_POST['field_type']);



        if ($field === 'badge_colors') {

            $names = $_POST['color_name'] ?? [];

            $hexes = $_POST['color_code'] ?? [];

            $colors = [];



            foreach ($names as $i => $name) {

                if (!empty($name) && !empty($hexes[$i])) {

                    $colors[] = [

                        'name' => ($name),

                        'code' => ($hexes[$i])

                    ];

                }

            }

            update_option($field, $colors);

        } else {            

            // $values = array_map('stripslashes', $_POST['values'] ?? []);

                // 

                $badgeShapes = [];
                $values = array_values(array_map('stripslashes', $_POST['values'] ?? []));
                foreach ($values as $shape) {
                    $key = strtolower($shape); // 'Rectangle' → 'rectangle'
                    $badgeShapes[$key] = $shape;
                }

                update_option($field, $badgeShapes);

        }

        wp_redirect(admin_url('options-general.php?page=custom-badge-creator&updated=' . $field));

        exit;

    }



    public function render_settings_page() {

        ?>

<div class="wrap">

    <h1>Custom Badge Creator</h1>
    <h2>Global Settings</h2>



    <?php foreach ($this->fields as $key => $label): ?>

    <div class="cbc-box" style="border:1px solid #ccc; padding:15px; margin-bottom:20px;">

        <h2><?= esc_html($label) ?></h2>

        <form method="post" action="<?= admin_url('admin-post.php') ?>">

            <input type="hidden" name="action" value="save_badge_fields">

            <input type="hidden" name="field_type" value="<?= esc_attr($key) ?>">

            <div class="cbc-repeater">

                <?php if ($key === 'badge_colors'):

                                $items = get_option($key, []);

                                foreach ($items as $color): ?>

                <div class="cbc-group">

                    <input type="text" name="color_name[]" placeholder="Color Name"
                        value="<?= esc_attr($color['name']) ?>">

                    <input type="text" class="cbc-color-picker" name="color_code[]"
                        value="<?= esc_attr($color['code']) ?>">

                    <button type="button" class="button cbc-remove">Remove</button>

                </div>

                <?php endforeach;

                            else:

                                $items = get_option($key, []);

                                foreach ($items as $item): ?>

                <div class="cbc-group">

                    <input type="text" name="values[]" value="<?= esc_attr($item) ?>">

                    <button type="button" class="button cbc-remove">Remove</button>

                </div>

                <?php endforeach;

                            endif; ?>

            </div>



            <button type="button" class="button cbc-add-btn" data-field="<?= esc_attr($key) ?>">+ Add
                <?= esc_html($label) ?></button>

            <p><button type="submit" class="button button-primary">Save <?= esc_html($label) ?></button></p>

        </form>

    </div>

    <?php endforeach; ?>

</div>

<?php

    }

}



new CustomBadgeCreator();

add_action( 'plugins_loaded', function() {

    if ( class_exists( 'WooCommerce' ) ) {
        // Load the custom product class early
        require_once plugin_dir_path( __FILE__ ) . 'inc/class-cbc-product-custom.php'; 
        // Load the product type logic
        require_once plugin_dir_path( __FILE__ ) . 'inc/class-badge-product-type.php';
        new CBC_Badge_Product_Type();
        require_once plugin_dir_path( __FILE__ ) . 'inc/class_product_tab.php';
        require_once plugin_dir_path( __FILE__ ) . 'inc/class-cbc-product-display.php';
        require_once plugin_dir_path( __FILE__ ) . 'inc/class-cbc-order-metabox.php';      
        require_once plugin_dir_path( __FILE__ ) . 'inc/class-cbc_image_uploader.php';      
        require_once plugin_dir_path( __FILE__ ) . 'inc/class-google-form-select.php';      

    }

});