<?php

/**
 * Product Customizer Data Display Class
 */
class Product_Customizer_Display
{

    /**
     * Initialize hooks
     */
    public function __construct()
    {
        // Hook into WooCommerce product page
        add_action('woocommerce_after_main_content', array($this, 'display_customizer_data'), 20);
        add_action('wp_enqueue_scripts', array($this, 'enqueue_frontend_scripts'));
        add_action('wp_ajax_custom_badge_add_to_cart', array($this, 'custom_badge_add_to_cart'));
        add_action('wp_ajax_nopriv_custom_badge_add_to_cart', array($this, 'custom_badge_add_to_cart'));
        add_filter('woocommerce_get_item_data', array($this, 'add_custom_badge_data'), 10, 2);
        add_action('woocommerce_add_order_item_meta', array($this, 'add_custom_badge_data_to_order'), 10, 3);
        //add_filter('woocommerce_order_item_name', array($this, 'add_custom_badge_data_to_email'), 10, 2);
        add_action('woocommerce_before_calculate_totals', array($this, 'set_custom_price'));
        add_action('wp_ajax_get_min_price_by_sku', array($this, 'get_min_price_ajax_handler'));
        add_action('wp_ajax_nopriv_get_min_price_by_sku', array($this, 'get_min_price_ajax_handler'));
        add_action('wp_ajax_get_price_by_quantity', array($this, 'get_price_by_quantity_ajax_handler'));
        add_action('wp_ajax_nopriv_get_price_by_quantity', array($this, 'get_price_by_quantity_ajax_handler'));
        add_filter('woocommerce_cart_item_thumbnail', array($this, 'custom_cart_item_image'), 10, 3);
        add_action('woocommerce_single_product_summary', array($this, 'show_custom_button_for_customize_product'), 30);
        add_filter('woocommerce_email_attachments', array($this, 'add_custom_email_attachments_from_item_meta'), 10, 3);
        add_filter('woocommerce_order_item_display_meta_value', array($this, 'custom_order_item_meta_html_output'), 10, 4);
    }



    function custom_order_item_meta_html_output($meta_value, $meta, $item)
    {
        // Only modify if the meta value contains a <a> or <img> (i.e. custom HTML you've inserted)
        if (strpos($meta_value, '<a') !== false || strpos($meta_value, '<img') !== false) {
            // Optional: sanitize or add logic to target only specific meta keys
            $meta_key_slug = sanitize_title($meta->key);
            $unique_id = 'order-item-meta-' . $meta_key_slug . '-' . $item->get_id();

            // Wrap the value in a div or span with your custom class and id
            return '<div class="custom-order-meta ' . esc_attr($meta_key_slug) . '" id="' . esc_attr($unique_id) . '">' . $meta_value . '</div>';
        }

        return $meta_value;
    }

    function show_custom_button_for_customize_product()
    {
        global $product;

        // Check if product is of type "customize_product"
        if ($product && $product->get_type() === 'customize_product') {
            echo '<div class="customize-btn-wrap" style="margin-bottom: 15px;">';
            echo '<button type="button" id="scroll_btn" class="green-btn anchor" href="#hiddenform">Customize Now</button>';
            echo '</div>';
        }
    }

    public function add_custom_email_attachments_from_item_meta($attachments, $email_id, $order)
    {
        // Only add attachments for specific email types, e.g., customer invoice or completed order
        if (! in_array($email_id, ['customer_completed_order', 'customer_processing_order', 'new_order'])) {
            return $attachments;
        }

        if (! is_a($order, 'WC_Order')) {
            return $attachments;
        }

        foreach ($order->get_items() as $item) {
            // Replace 'custom_attachment_path' with your actual order item meta key
            $attachment_id = wc_get_order_item_meta($item->get_id(), '_custom_canvas_image_id', true);
            $original_image_id = wc_get_order_item_meta($item->get_id(), '_original_image_id', true);
            $file_upload_id = wc_get_order_item_meta($item->get_id(), '_file_upload_id', true);

            if ($attachment_id) {
                $file_path = get_attached_file($attachment_id);
                if (file_exists($file_path)) {
                    $attachments[] = $file_path;
                }
            }

            if ($original_image_id) {
                $original_file_path = get_attached_file($original_image_id);
                if (file_exists($original_file_path)) {
                    $attachments[] = $original_file_path;
                }
            }

            if ($file_upload_id) {
                $upload_file_path = get_attached_file($file_upload_id);
                if (file_exists($upload_file_path)) {
                    $attachments[] = $upload_file_path;
                }
            }
        }

        return $attachments;
    }

    public function custom_cart_item_image($thumbnail, $cart_item, $cart_item_key)
    {
        // Check if your custom attribute is set in the cart item
        if (isset($cart_item['custom_canvas_image_id'])) {
            $image_url = wp_get_attachment_url($values['custom_canvas_image_id']);
            $custom_image_url = wp_get_attachment_image_url($cart_item['custom_canvas_image_id'], 'full');
            if ($custom_image_url) {
                $thumbnail = '<img src="' . esc_url($custom_image_url) . '" alt="' . esc_attr($cart_item['data']->get_name()) . '" class="custom-cart-item-image" />';
            }
        }

        return $thumbnail;
    }

    public function get_price_by_quantity_ajax_handler()
    {
        $product_id = isset($_POST['product_id']) ? intval($_POST['product_id']) : 0;
        $sku = isset($_POST['sku']) ? sanitize_text_field($_POST['sku']) : '';
        $quantity = isset($_POST['quantity']) ? intval($_POST['quantity']) : 1;
        $product_tier_price = get_post_meta($product_id, 'product_custom_options', true);
        $backingPrice = isset($_POST['backingPrice']) ? sanitize_text_field($_POST['backingPrice']) : '';
        // Find the matched product by SKU
        $matchedItem = null;
        foreach ($product_tier_price as $item) {
            if ($item['sku'] === $sku) {
                $matchedItem = $item;
                break;
            }
        }

        if ($matchedItem) {
            // Build quantity breaks dynamically
            $quantityBreaks = [];
            foreach ($matchedItem as $key => $value) {
                if (preg_match('/^qty(\d+)$/', $key, $matches)) {
                    $index = $matches[1];
                    $qtyKey = 'qty' . $index;
                    $priceKey = 'price' . $index;
                    if (isset($matchedItem[$priceKey])) {
                        $quantityBreaks[] = [
                            'quantity' => intval($matchedItem[$qtyKey]),
                            'price' => floatval($matchedItem[$priceKey])
                        ];
                    }
                }
            }

            // Sort breaks by quantity ascending
            usort($quantityBreaks, function ($a, $b) {
                return $a['quantity'] - $b['quantity'];
            });

            // Find the best price for the quantity
            $bestPrice = null;
            foreach ($quantityBreaks as $break) {
                if ($quantity >= $break['quantity']) {
                    $bestPrice = $break['price'];
                }
            }

            if ($bestPrice !== null) {
                if ($backingPrice) {
                    $bestPrice += floatval($backingPrice);
                }

                $total_price = $bestPrice * $quantity;

                wp_send_json_success([
                    'sku' => $sku,
                    'product_id' => $product_id,
                    'price' => wc_price($bestPrice),
                    'price_wo_curr' => ($bestPrice),
                    'total_price' => wc_price($total_price),
                    'total_price_wo_curr' => ($total_price),
                ]);
            }
        }

        wp_send_json_error('Price not found');
        wp_die();
    }

    public function get_min_price_ajax_handler()
    {
        // Get product ID and SKU from AJAX request
        $product_id = isset($_POST['product_id']) ? intval($_POST['product_id']) : 0;
        $sku = isset($_POST['sku']) ? sanitize_text_field($_POST['sku']) : '';
        $backingPrice = isset($_POST['backingPrice']) ? sanitize_text_field($_POST['backingPrice']) : '';
        // Filter for matching SKU and product_id (if needed)            
        $product_tier_price = get_post_meta($product_id, 'product_custom_options', true);
        $matchedItem = null;
        foreach ($product_tier_price as $item) {
            if ($item['sku'] === $sku) {
                $matchedItem = $item;
                break;
            }
        }

        if ($matchedItem) {
            $minPrice = null;
            if (isset($matchedItem['qty1']) && $matchedItem['qty1'] == 1 && isset($matchedItem['price1'])) {
                $minPrice = $matchedItem['price1'];
                if ($backingPrice) {
                    $minPrice += floatval($backingPrice);
                }
            }


            if ($minPrice !== null) {
                wp_send_json_success([
                    'sku' => $sku,
                    'product_id' => $product_id,
                    'price' => wc_price($minPrice),
                    'total_price' => wc_price($minPrice),
                    'price_wo_curr' => ($minPrice),

                ]);
            }
        }

        wp_send_json_error('No price found for this product.');
        wp_die();
    }

    public function set_custom_price($cart)
    {
        if (is_admin() && !defined('DOING_AJAX')) return;
        foreach ($cart->get_cart() as $cart_item) {
            if (isset($cart_item['custom_price'])) {
                $cart_item['data']->set_price($cart_item['custom_price']);
            }
        }
    }


    /**
     * Save custom data to order item meta
     */
    public function add_custom_badge_data_to_order($item_id, $values, $cart_item_key)
    {
        $fields = array(
            'shapes'                => 'Shape',
            'sizes'                 => 'Size',
            'thicknesses'           => 'Thickness',
            'finishes'              => 'Finish',
            'colors'                => 'Color',
            'corners'               => 'Corner',
            'backings'              => 'Backing',
            'custom_canvas_image_id' => 'Badge Preview',
            'original_image_id'     => 'Uploaded Image',
            'file_upload_id'        => 'Uploaded File',
            'custom_text'           => 'Badge text',
            'custom_text_size'      => 'Badge text Size',
            'custom_text_color'     => 'Badge Text Color',
            'custom_text_font'      => 'Badge Text Font',
            'sample_time'           => time()
        );

        foreach ($fields as $key => $label) {
            if ($key === 'custom_canvas_image_id') {
                $image_url = wp_get_attachment_url($values['custom_canvas_image_id']);
                wc_add_order_item_meta($item_id, '_custom_canvas_image_id', $values['custom_canvas_image_id']);
                wc_add_order_item_meta($item_id, $label, '<img src="' . esc_url($image_url) . '" alt="Badge Preview" style="max-width:100px;">');
            } elseif ($key === 'original_image_id') {
                $org_image_url = wp_get_attachment_url($values['original_image_id']);
                wc_add_order_item_meta($item_id, '_original_image_id', $values['original_image_id']);
                wc_add_order_item_meta($item_id, $label, '<img src="' . esc_url($org_image_url) . '" alt="Uploaded Image" style="max-width:100px;">');
            } elseif ($key === 'file_upload_id') {
                $uploaded_file_url = wp_get_attachment_url($values['file_upload_id']);
                wc_add_order_item_meta($item_id, '_file_upload_id', $values['file_upload_id']);
                wc_add_order_item_meta($item_id, $label, '<a href="' . esc_url($uploaded_file_url) . '" download class="cart_download_btn green-btn-small"><i class="fas fa-file-excel"></i></a>');
            } else {
                if (!empty($values[$key])) {
                    wc_add_order_item_meta($item_id, $label, $values[$key]);
                }
            }
        }
    }

    /**
     * Display custom data in order emails
     */
    public function add_custom_badge_data_to_email($item_name, $item)
    {
        $meta_data = $item->get_formatted_meta_data('');

        if (!empty($meta_data)) {
            $item_name .= '<br>';
            foreach ($meta_data as $meta) {
                $item_name .= '<small>' . esc_html($meta->display_key) . ': ' . esc_html($meta->display_value) . '</small><br>';
            }
        }

        return $item_name;
    }

    public function add_custom_badge_data($item_data, $cart_item)
    {
        $fields = array(
            'shapes'                => 'Shape',
            'sizes'                 => 'Size',
            'thicknesses'           => 'Thickness',
            'finishes'              => 'Finish',
            'colors'                => 'Color',
            'corners'               => 'Corner',
            'backings'              => 'Backing',
            'original_image_id'     => 'original_image_id',
            'file_upload_id'        => 'file_upload_id',
            'custom_text'           => 'Badge text',
            'custom_text_size'      => 'Badge text Size',
            'custom_text_color'     => 'Badge Text Color',
            'custom_text_font'      => 'Badge Text Font',
            // 'custom_canvas_image_id' => 'custom_canvas_image_id',   
            // 'custom_sku'            => 'Custom SKU',
            'sample_time' => time()
        );

        foreach ($fields as $field_key => $field_label) {
            if (!empty($cart_item[$field_key])) {
                $item_data[] = array(
                    'name'  => $field_label,
                    'value' => ($cart_item[$field_key])
                );
            }
        }

        if (!empty($cart_item['custom_canvas_image_id'])) {
            $image_url = wp_get_attachment_url($cart_item['custom_canvas_image_id']);
            $item_data[] = array(
                'name' => 'Badge Preview',
                'value' => '<img src="' . esc_url($image_url) . '" alt="Badge Preview" style="max-width:60px;">'
            );
        }

        if (!empty($cart_item['original_image_id'])) {
            $image_url = wp_get_attachment_url($cart_item['original_image_id']);
            $item_data[] = array(
                'name' => 'Uploaded Image',
                'value' => '<img src="' . esc_url($image_url) . '" alt="uploaded Image" style="max-width:60px;">'
            );
        }

        if (!empty($cart_item['file_upload_id'])) {
            $file_url = wp_get_attachment_url($cart_item['file_upload_id']);
            $item_data[] = array(
                'name'  => 'Uploaded File',
                'value' => '<a href="' . esc_url($file_url) . '" download class="cart_download_btn green-btn-small"><i class="far fa-file-excel fa-2x"></i></a>'
            );
        }

        return $item_data;
    }

    public function custom_badge_add_to_cart()
    {

        if (!isset($_POST)) {
            wp_send_json_error(['message' => 'No data provided.']);
        }


        if (!empty($_FILES['original_image']['name'])) {
            require_once ABSPATH . 'wp-admin/includes/file.php';
            $upload = wp_handle_upload($_FILES['original_image'], ['test_form' => false]);
            if (!isset($upload['error'])) {
                $file_path = $upload['file'];
                $attachment = [
                    'post_mime_type' => $upload['type'],
                    'post_title'     => sanitize_file_name($upload['file']),
                    'post_content'   => '',
                    'post_status'    => 'inherit'
                ];
                $attach_id = wp_insert_attachment($attachment, $file_path);
                require_once ABSPATH . 'wp-admin/includes/image.php';
                $attach_data = wp_generate_attachment_metadata($attach_id, $file_path);
                wp_update_attachment_metadata($attach_id, $attach_data);

                $original_image_id = $attach_id;
                // $result['original_image_url'] = wp_get_attachment_url($attach_id);
            }
        }

        if (!empty($_FILES['upload_file']['name'])) {
            require_once ABSPATH . 'wp-admin/includes/file.php';
            $upload = wp_handle_upload($_FILES['upload_file'], ['test_form' => false]);
            if (!isset($upload['error'])) {
                $file_path = $upload['file'];
                $attachment = [
                    'post_mime_type' => $upload['type'],
                    'post_title'     => sanitize_file_name($upload['file']),
                    'post_content'   => '',
                    'post_status'    => 'inherit'
                ];
                $attach_id_file = wp_insert_attachment($attachment, $file_path);

                $attach_data = wp_generate_attachment_metadata($attach_id_file, $file_path);
                wp_update_attachment_metadata($attach_id_file, $attach_data);
                $file_upload_id = $attach_id_file;
                // $result['original_image_url'] = wp_get_attachment_url($attach_id);
            }
        }
        $data = $_POST;
        // Basic validation
        if (empty($data['product_id'])) {
            wp_send_json_error(['message' => 'No product ID provided.']);
        }

        $product_id = intval($data['product_id']);
        $product_price = floatval($data['product_price']);
        $badge_qty = isset($data['badge_qty']) && intval($data['badge_qty']) > 0 ? intval($data['badge_qty']) : 1;

        // Save canvas image to Media Library
        $canvas_image_id = null;
        if (!empty($data['canvas_data'])) {
            $base64 = str_replace('data:image/png;base64,', '', $data['canvas_data']);
            $decoded = base64_decode($base64);
            $upload_dir = wp_upload_dir();
            $filename = 'badge-preview-' . time() . '.png';
            $file_path = $upload_dir['path'] . '/' . $filename;
            file_put_contents($file_path, $decoded);
            $attachment = array(
                'post_mime_type' => 'image/png',
                'post_title'     => sanitize_file_name($filename),
                'post_content'   => '',
                'post_status'    => 'inherit'
            );

            $attach_id = wp_insert_attachment($attachment, $file_path);
            require_once(ABSPATH . 'wp-admin/includes/image.php');
            $attach_data = wp_generate_attachment_metadata($attach_id, $file_path);
            wp_update_attachment_metadata($attach_id, $attach_data);
            $canvas_image_id = $attach_id;
        }

        // Add product to cart with custom fields
        $cart_item_data = array(
            'shapes'      => $data['shapes'],
            'sizes'       => stripslashes_deep($data['sizes']),
            'thicknesses' => $data['thicknesses'],
            'finishes'    => $data['finishes'],
            'colors'      => $data['colors'],
            'corners'     => $data['corners'],
            'backings'    => $data['backings'],
            'custom_sku'  => $data['custom_sku'],
            'custom_canvas_image_id' => $canvas_image_id,
            'custom_price'      => $product_price,
            'file_upload_id'    => $file_upload_id,
            'original_image_id' => $original_image_id,
            'custom_text'       => isset($data['custom_text']) ? sanitize_text_field($data['custom_text']) : '',
            'custom_text_size'  => isset($data['custom_text_size']) ? sanitize_text_field($data['custom_text_size']) . ' px' : '',
            'custom_text_color' => isset($data['custom_text_color']) ? sanitize_text_field($data['custom_text_color']) : '',
            'custom_text_font'  => isset($data['custom_text_font']) ? sanitize_text_field($data['custom_text_font']) : '',

        );
        $logger = wc_get_logger();
        // Create a unique context or use a common one
        $context = array('source' => 'custom_data_logger');
        $logger->info('Custom data: ' . json_encode($cart_item_data), $context);

        WC()->cart->add_to_cart($product_id, $badge_qty, 0, array(), $cart_item_data);

        wp_send_json_success(['message' => 'Product added to cart.', 'media_id' => $canvas_image_id]);
    }

    /**
     * Display customizer data on product page
     */
    public function display_customizer_data()
    {
        global $post;
        $badge_colors = get_option('badge_colors', true);
        $product_id = get_the_ID();
        $product = wc_get_product($product_id);
        if ($product && $product->get_type() === 'customize_product') {
            $customizer_data = get_post_meta($product_id, '_custom_repeater_data', true);
            $product_tier_price = get_post_meta($product_id, 'product_custom_options', true);
            $badge_image_map = get_post_meta($product_id, '_badge_image_map', true);
            // echo "<pre>";                        
            // print_r($badge_image_map);
            // echo "</pre>";
            if ($badge_image_map) {
                echo "<div id='badgeImage' class='d-none'>";
                echo json_encode($badge_image_map);
                echo "</div>";
            }

            if ($product_tier_price) {
                echo "<div id='badgePrice' class='d-none'>";
                echo json_encode($product_tier_price);
                echo "</div>";
            }

            if ($customizer_data) {
                echo "<div id='badgeData' class='d-none'>";
                echo json_encode($customizer_data);
                echo "</div>";
            }

            if ($badge_colors) {
                echo "<div id='badge_colors' class='d-none'>";
                echo json_encode($badge_colors);
                echo "</div>";
            }

?>
            <img id="custom-rotate-icon" src="<?php echo CBC_PLUGIN_URL; ?>/images/rotate_icon.png" style="display:none;" />
            <form id="multiStepForm" enctype="multipart/form-data" method="post">
                <section class="hiddenform" id="hiddenform"
                    style="">
                    <div class="hiddenform-inner">
                        <div class="container">
                            <div class="shadowdiv">
                                <div class="form-column">
                                    <div id="badgeTabsContainer"></div>
                                </div>
                                <div class="badge-preview-column mt-5">
                                    <div class="canvasSec"
                                        style="position: relative; border: 1px solid #ccc; display: inline-block;">
                                        <canvas id="badgeCanvas" width="" height="" style="border: 1px solid #000;"></canvas>

                                        <!-- Width label (bottom center) -->
                                        <!-- <div
                                                        style="position: absolute; bottom: -20px; left: 50%; transform: translateX(-50%); font-size: 12px;">
                                                        Width: <span id="canvasWidth"></span>
                                                    </div> -->
                                        <!-- <div
                                                        >
                                                        Width: <span id="canvasWidth"></span>
                                                    </div> -->

                                        <!-- Height label (right center, rotated) -->
                                        <!-- <div
                                                        style="position: absolute; top: 50%; right: -30px; transform: translateY(-50%) rotate(90deg); font-size: 12px;">
                                                        Height: <span id="canvasHeight"></span>
                                                    </div> -->
                                        <div id="canvasControls" style="display:none; z-index:10;">
                                            <!-- <button type="button" id="resizeImageBtn"><i
                                                                            class="fa-solid fa-up-right-and-down-left-from-center"></i> </button> -->

                                            <button type="button" id="deleteImageBtn"> <i class="fa-solid fa-trash"></i></button>
                                        </div>

                                    </div>

                                </div>
                                <div class="selected-column" id="selected-column" style="display:none;">
                                    <div class="select-inner">
                                        <ul></ul>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="hiddenform-price-qn d-none" id="show_when_sku">
                        <div class="container">
                            <div class="hiddenform-price-qn-row">
                                <div class="quantity">
                                    <label>Select the quantity</label>
                                    <div class="qbtn">
                                        <button type="button" class="quantity-btn minus-btn"
                                            aria-label="Decrease quantity">-</button>
                                        <input type="number" name="quantity" id="productQuantity" value="1" min="1" max="999">
                                        <button type="button" class="quantity-btn plus-btn"
                                            aria-label="Increase quantity">+</button>
                                    </div>
                                </div>


                                <div class="File_upload">
                                    <div class="fup-top">
                                        <label for="upload_file" class="file-upload-button">Browse</label>
                                        <input type="file" name="upload_file" id="upload_file" class="file-upload"
                                            accept=".csv, application/vnd.ms-excel, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet">
                                        <p class="file-upload-instruction">Upload File (.csv, .xlsx)</p>
                                    </div>
                                    <span id="file-name" class="file-name-display">No file chosen</span>
                                </div>



                                <div class="pricing">
                                    <h4>Price: <span id="cal_price"></span></h4>
                                    <h4>Total Price: <span id="total_cal_price"></span></h4>


                                    <div class="buttons">

                                        <div id="customBadgeForm" class="">
                                            <input type="hidden" name="org_image" value="" id="org_image">
                                            <input type="hidden" name="product_id" value="<?php echo get_the_ID(); ?>"
                                                id="product_id">
                                            <input type="hidden" name="product_price" value="0" id="product_price">
                                            <input type="hidden" name="shapes" id="badge_shape_input">
                                            <input type="hidden" name="sizes" id="badge_size_input">
                                            <input type="hidden" name="badge_qty" id="badge_qty" value="1">
                                            <input type="hidden" name="thicknesses" id="badge_thickness_input">
                                            <input type="hidden" name="finishes" id="badge_finish_input">
                                            <input type="hidden" name="colors" id="badge_color_input">
                                            <input type="hidden" name="corners" id="badge_corner_input">
                                            <input type="hidden" name="backings" id="badge_backing_input">
                                            <input type="hidden" name="custom_sku" id="badge_custom_sku">
                                            <!-- Hidden fields for text -->
                                            <input type="hidden" name="custom_text" id="badge_custom_text">
                                            <input type="hidden" name="custom_text_size" id="badge_custom_text_size">
                                            <input type="hidden" name="custom_text_color" id="badge_custom_text_color">
                                            <input type="hidden" name="custom_text_font" id="badge_custom_text_font">
                                            <button type="submit" class="green-btn">Add to Cart</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </form>


<?php }
    }

    public function enqueue_frontend_scripts()
    {
        // Load only on single product pages of 'customize_product' type
        // CSS
        wp_enqueue_style(
            'product-customizer-css',
            CBC_PLUGIN_URL . 'css/front-end.css',
            array(),
            time()
        );

        // JavaScript
        wp_enqueue_script(
            'fabric-js',
            'https://cdnjs.cloudflare.com/ajax/libs/fabric.js/5.3.0/fabric.min.js',
            array('jquery'),
            time(),
            true
        );

        $currency_code = get_woocommerce_currency(); // e.g., 'USD'
        $currency_symbol = get_woocommerce_currency_symbol($currency_code); // e.g., '$'

        wp_enqueue_script('front-end.js', CBC_PLUGIN_URL . 'js/front-end.js', ['jquery'], wp_rand(1000, 9999), true);
        wp_localize_script('front-end.js', 'productCustomizerData', [
            'pluginUrl' => CBC_PLUGIN_URL,
            'ajaxUrl'   => admin_url('admin-ajax.php'),
            'nonce'     => wp_create_nonce('customizer_nonce'),
            'assetsUrl' => plugin_dir_url(__FILE__) . 'assets/',
            'currencySymbol' => $currency_symbol,
            'currencyCode' => $currency_code
        ]);

        // Load jQuery Confirm CSS
        wp_enqueue_style('jquery-confirm-css', 'https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.css');

        // Load jQuery Confirm JS
        wp_enqueue_script('jquery-confirm-js', 'https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.js', array('jquery'), null, true);

        if (!is_product()) return;
        global $post;
        if (!$post || get_post_type($post) !== 'product') return;
        $oval_id  = get_post_meta($post->ID, '_badge_shape_oval_image_id', true);
        $rect_id  = get_post_meta($post->ID, '_badge_shape_rectangle_image_id', true);

        // Exit if neither image exists
        if (!$oval_id && !$rect_id) return;

        $oval_url = $oval_id ? wp_get_attachment_url($oval_id) : '';
        $rect_url = $rect_id ? wp_get_attachment_url($rect_id) : '';

        // Register & enqueue your frontend script (replace with actual file if needed)

        // Localize the image URLs
        wp_localize_script('jquery-confirm-js', 'badgeShapeImages', [
            'oval'     => esc_url($oval_url),
            'rectangle' => esc_url($rect_url)
        ]);
    }
}

// Initialize the customizer display
new Product_Customizer_Display();
