<?php 

    class class_google_form_select {

        private $option_key = 'selected_google_fonts_api_key_list';
        private $api_key_option = 'badge_google_fonts_api_key';
        public function __construct() {
            add_action('admin_menu', [$this, 'add_settings_page']);
            add_action('admin_init', [$this, 'register_settings']);
            add_action('wp_enqueue_scripts', [$this, 'enqueue_selected_google_fonts']);
            add_action('wp_enqueue_scripts', [$this, 'enqueue_fonts_js']);
        }

        public function enqueue_fonts_js() {
            $selected_fonts = get_option('selected_google_fonts_api_key_list', []);

            // Format font names for CSS usage (e.g., "Open Sans" => "Open+Sans")
            // $formatted_fonts = array_map(function($font) {
            //     return str_replace(' ', ' ', $font);
            // }, $selected_fonts);

            // Register your JS file (replace 'your-plugin-script.js' with actual)
            wp_register_script(
                'custom-badge-creator',
                CBC_PLUGIN_URL . '/js/frontend_new.js',
                ['jquery'],
                time(),
                true
            );

            // Localize selected fonts
            wp_localize_script('custom-badge-creator', 'CBCFonts', [
                'fonts' => $selected_fonts
            ]);

            wp_enqueue_script('custom-badge-creator');
        }


        public function enqueue_selected_google_fonts() {
            $selected_fonts = get_option('selected_google_fonts_api_key_list', []);

            if (!empty($selected_fonts) && is_array($selected_fonts)) {
                // Format for Google Fonts URL
                $families = array_map(function ($font) {
                    return str_replace(' ', '+', $font) . ':wght@400;700';
                }, $selected_fonts);

                $fonts_url = 'https://fonts.googleapis.com/css2?family=' . implode('&family=', $families) . '&display=swap';

                wp_enqueue_style('badge-google-fonts', $fonts_url, [], null);
            }
        }


        public function add_settings_page() {
            add_submenu_page(
                'custom-badge-creator',
                'Google Fonts List',
                'Fonts List',
                'manage_options',
                'google-fonts-list',
                [$this, 'render_fonts_page']
            );
        }

        public function register_settings() {
            register_setting('google_fonts_list_group', $this->option_key);
        }

        private function get_fonts_list() {
            $api_key = get_option('badge_plugin_google_fonts_api_key',true);
            if (empty($api_key)) return [];

            $transient_key = 'google_fonts_cache_' . md5($api_key);
            $fonts_data = get_transient($transient_key);

            if (!$fonts_data) {
                $response = wp_remote_get("https://www.googleapis.com/webfonts/v1/webfonts?key=" . esc_attr($api_key));
                if (is_wp_error($response)) return [];

                $body = wp_remote_retrieve_body($response);
                $fonts_data = json_decode($body, true);

                if (isset($fonts_data['items'])) {
                    set_transient($transient_key, $fonts_data, DAY_IN_SECONDS);
                } else {
                    return [];
                }
            }

            return $fonts_data['items'] ?? [];
        }

      public function render_fonts_page() {
    $selected_fonts = get_option($this->option_key, []);
    $fonts = $this->get_fonts_list();
    ?>
    <div class="wrap">
        <h1>Select Google Fonts</h1>
        <form method="post" action="options.php">
            <?php settings_fields('google_fonts_list_group'); ?>
            <table class="form-table">
                <tr>
                    <th scope="row">Google Fonts</th>
                    <td>
                        <select id="google-fonts-select" name="<?php echo $this->option_key; ?>[]" multiple="multiple" style="width: 100%;">
                            <?php foreach ($fonts as $font): ?>
                                <option value="<?php echo esc_attr($font['family']); ?>"
                                    <?php selected(in_array($font['family'], (array) $selected_fonts), true); ?>>
                                    <?php echo esc_html($font['family']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>
            </table>
            <?php submit_button('Save Selected Fonts'); ?>
        </form>
    </div>

    <!-- Load Select2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        jQuery(document).ready(function($) {
            $('#google-fonts-select').select2({
                placeholder: 'Select Google Fonts',
                allowClear: true,
                width: 'resolve'
            });
        });
    </script>
    <?php
}

}
new class_google_form_select();