jQuery(document).ready(function($) {

    const data = JSON.parse($('#badgeData').html());
    // Extract unique options for each step
    const shapes = [...new Set(data.map(item => item.badge_shapes))];
    const sizes = [...new Set(data.map(item => item.badge_sizes))];
    const thicknesses = [...new Set(data.map(item => item.badge_thicknesses))];
    const finishes = [...new Set(data.map(item => item.badge_finishes))];
    const colors = [...new Set(data.flatMap(item => item.badge_colors))];
    const corners = [...new Set(data.flatMap(item => item.badge_corners))];
    const backings = [...new Set(data.map(item => item.badge_backings))];

    const container = $('<div>', { class: 'formouterrow' });

    // Progress bar
    const progressInner = $('<div>', { class: 'progress-inner' }).append(
        $('<div>', { class: 'step-indicator active', text: 'Badge Shape' }),
        $('<div>', { class: 'step-indicator', text: 'Upload your image' }),
        $('<div>', { class: 'step-indicator', text: 'Size' }),
        $('<div>', { class: 'step-indicator', text: 'Thickness' }),
        $('<div>', { class: 'step-indicator', text: 'Finish' }),
        $('<div>', { class: 'step-indicator', text: 'Color' }),
        $('<div>', { class: 'step-indicator', text: 'Corners' }),
        $('<div>', { class: 'step-indicator', text: 'Backing' })
    );
    container.append(progressInner);

    // Helper to generate radio options
    // function createRadioOptions(name, options) {
    //     return $('<div>', { class: 'radio-checkbox-inner elem-2' }).append(
    //         options.map(opt => $('<label>').append(
    //             $('<span>', { text: opt }),
    //             $('<input>', { type: 'radio', name: name, value: opt }),
    //             $('<span>')
    //         ))
    //     );
    // }

    function createRadioOptions(name, options, className = 'radio-checkbox-inner elem-2') {
          return $('<div>', { class: className }).append(
            options.map((opt, index) => {
              // Skip empty or null options
              if (!opt || opt.trim() === '') return '';

              const id = name + (index + 1);
              return $('<label>', { for: id }).append(
                $('<input>', { type: 'radio', name: name, value: opt, id: id }),
                $('<span>', { text: opt })
              );
            })
          );
    }



    function createRadioOptionsWithImages(name, options, assetUrl, extension = 'svg') {
        return $('<div>', { class: 'radio-checkbox-inner elem-2' }).append(
            options.map(opt => {
                const imageSrc = `${assetUrl}/${opt}.${extension}`;
                return $('<label>').append(
                    $('<img>', { src: imageSrc, alt: opt, width: 50 }),
                    $('<input>', { type: 'radio', name: name, value: opt }),
                    $('<span>') // for custom styling if needed
                );
            })
        );
    }

    // Step 1: Badge Shape
    const step1 = $('<div>', { class: 'step active' }).append(
        $('<div>', { class: 'innerstep' }).append(
            createRadioOptionsWithImages('badge_shape', shapes,productCustomizerData.pluginUrl+'images'),
            $('<div>', { class: 'buttons singlebtn' }).append(
                $('<button>', { type: 'button', class: 'next green-btn', html: 'Next' })
            )
        )
    );

    // Step 2: Upload image & Fabric.js canvas
 
    const step2 = $('<div>', { class: 'step' }).append(
        $('<div>', { class: 'innerstep' }).append(
            $('<label>', { text: 'Upload your image:' }),
            $('<input>', { type: 'file', class: 'badge-upload' }),            
            $('<div>', { class: 'buttons' }).append(
                $('<button>', { type: 'button', class: 'prev green-btn', html: 'Prev' }),
                $('<button>', { type: 'button', class: 'next green-btn', html: 'Next' })
            )
        )
    );

    // Step 3: Size
    const step3 = $('<div>', { class: 'step' }).append(
        $('<div>', { class: 'innerstep' }).append(
            createRadioOptions('badge_size', sizes,'radio-checkbox-inner radiobx'),
            $('<div>', { class: 'buttons' }).append(
                 $('<button>', { type: 'button', class: 'prev green-btn', html: 'Prev' }),
                 $('<button>', { type: 'button', class: 'next green-btn', html: 'Next' })
            )
        )
    );

    // Step 4: Thickness
    const step4 = $('<div>', { class: 'step' }).append(
        $('<div>', { class: 'innerstep' }).append(
            createRadioOptions('badge_thickness', thicknesses,'radio-checkbox-inner radiobx'),
            $('<div>', { class: 'buttons' }).append(
                $('<button>', { type: 'button', class: 'prev green-btn', html: 'Prev' }),
                $('<button>', { type: 'button', class: 'next green-btn', html: 'Next' })
            )
        )
    );

    // Step 5: Finish
    const step5 = $('<div>', { class: 'step' }).append(
        $('<div>', { class: 'innerstep' }).append(
            createRadioOptions('badge_finish', finishes,'radio-checkbox-inner radiobx'),
            $('<div>', { class: 'buttons' }).append(
                 $('<button>', { type: 'button', class: 'prev green-btn', html: 'Prev' }),
                 $('<button>', { type: 'button', class: 'next green-btn', html: 'Next' })
            )
        )
    );

    // Step 6: Colors (use color boxes)
    const colorBoxes = colors.map(color =>
        $('<label>').append(
            $('<div>', { class: 'color-box', style: 'background-color:'+color+'; width:30px; height:30px; display:inline-block; margin:3px;' }),
            $('<input>', { type: 'radio', name: 'badge_color', value: color }),
            $('<span>')
        )
    );
    const step6 = $('<div>', { class: 'step' }).append(
        $('<div>', { class: 'innerstep' }).append(
            $('<div>', { class: 'radio-checkbox-inner radiobx colorbx' }).append(colorBoxes),
            $('<div>', { class: 'buttons' }).append(
                 $('<button>', { type: 'button', class: 'prev green-btn', html: 'Prev' }),
                 $('<button>', { type: 'button', class: 'next green-btn', html: 'Next' })
            )
        )
    );

    // Step 7: Corners
    const step7 = $('<div>', { class: 'step' }).append(
        $('<div>', { class: 'innerstep' }).append(
            createRadioOptions('badge_corners', corners,'radio-checkbox-inner radiobx'),
            $('<div>', { class: 'buttons ' }).append(
                $('<button>', { type: 'button', class: 'prev green-btn', html: 'Prev' }),
                $('<button>', { type: 'button', class: 'next green-btn', html: 'Next' })
            )
        )
    );

    // Step 8: Backing
    const step8 = $('<div>', { class: 'step' }).append(
      $('<div>', { class: 'innerstep' }).append(
        createRadioOptions('badge_backing', backings, 'radio-checkbox-inner radiobx'),
        $('<div>', { class: 'buttons' }).append(
          $('<button>', { type: 'button', class: 'prev green-btn', html: 'Prev' }),        
        ),
         $('<div>', { class: 'buttons' }).append(          
          $('<button>', { type: 'button', class: 'downloadCanvas download-btn', html: 'Download' })
        )
      )
    );


    container.append(step1, step2, step3, step4, step5, step6, step7, step8);
    $('#badgeTabsContainer').append(container);

    // Next buttons
    $(document).on('click', '.next', function(){
        const formRow = $(this).closest('.formouterrow');
        const activeStep = formRow.find('.step.active');
        const nextStep = activeStep.next('.step');

        if (nextStep.length) {
            activeStep.removeClass('active');
            nextStep.addClass('active');

            const indicators = formRow.find('.step-indicator');
            const nextIndex = nextStep.index() - 1;
            indicators.removeClass('active').eq(nextIndex).addClass('active');
        }
    });

    // Previous buttons
    $(document).on('click', '.prev', function(){
        const formRow = $(this).closest('.formouterrow');
        const activeStep = formRow.find('.step.active');
        const prevStep = activeStep.prev('.step');

        if (prevStep.length) {
            activeStep.removeClass('active');
            prevStep.addClass('active');

            const indicators = formRow.find('.step-indicator');
            const prevIndex = prevStep.index() - 1;
            indicators.removeClass('active').eq(prevIndex).addClass('active');
        }
    });


    const canvas = new fabric.Canvas('badgeCanvas');
    let userImage = null;

    // Create the initial badge shape
    let badgeShape;

    let assetUrl_2=productCustomizerData.pluginUrl+'images';

    function updateSelectedColumn(assetUrl=productCustomizerData.pluginUrl+'images') {
        //alert(assetUrl)
        const selectedData = {
            badgeShape: $('input[name="badge_shape"]:checked').val(),
            uploadedImage: $('.uploaded-image-preview').attr('src') || '', // Example image preview
            size: $('input[name="badge_size"]:checked').val(),
            thickness: $('input[name="badge_thickness"]:checked').val(),
            finish: $('input[name="badge_finish"]:checked').val(),
            color: $('input[name="badge_color"]:checked').val(),
            corners: $('input[name="badge_corners"]:checked').val(),
            backing: $('input[name="badge_backing"]:checked').val()
        };

        const $selectedColumn = $('#selected-column .select-inner ul');
        $selectedColumn.empty();

        // Badge Shape
        if (selectedData.badgeShape) {
            const shapeImageSrc = `${assetUrl}/${selectedData.badgeShape}.svg`;
            $selectedColumn.append(
                $('<li>').append(
                    'Badge Shape: ',
                    $('<img>', { src: shapeImageSrc, alt: selectedData.badgeShape })
                )
            );
        }

        // Uploaded Image
        if (selectedData.uploadedImage) {
            $selectedColumn.append(
                $('<li>').append(
                    'Uploaded Image: ',
                    $('<img>', { src: selectedData.uploadedImage, alt: 'Uploaded Image' })
                )
            );
        }

        // Size
        if (selectedData.size) {
            $selectedColumn.append(
                $('<li>').append(
                    'Size: ',
                    $('<span>', { text: selectedData.size })
                )
            );
        }

        // Add other fields similarly...
        if (selectedData.thickness) {
            $selectedColumn.append(
                $('<li>').append(
                    'Thickness: ',
                    $('<span>', { text: selectedData.thickness })
                )
            );
        }

        if (selectedData.finish) {
            $selectedColumn.append(
                $('<li>').append(
                    'Finish: ',
                    $('<span>', { text: selectedData.finish })
                )
            );
        }

        if (selectedData.color) {
            $selectedColumn.append(
                $('<li>').append(
                    'Color: ',
                    $('<span>', { text: selectedData.color })
                )
            );
        }

        if (selectedData.corners) {
            $selectedColumn.append(
                $('<li>').append(
                    'Corners: ',
                    $('<span>', { text: selectedData.corners })
                )
            );
        }

        if (selectedData.backing) {
            $selectedColumn.append(
                $('<li>').append(
                    'Backing: ',
                    $('<span>', { text: selectedData.backing })
                )
            );
        }
    }


  function parseInches(str) {
    str = str.trim();
    if (str.includes(' ')) {
      const [whole, fraction] = str.split(' ');
      const [numerator, denominator] = fraction.split('/');
      return parseFloat(whole) + (parseFloat(numerator) / parseFloat(denominator));
    } else if (str.includes('/')) {
      const [numerator, denominator] = str.split('/');
      return parseFloat(numerator) / parseFloat(denominator);
    } else {
      return parseFloat(str);
    }
  }



function setDefaultShapeAndSize() {
  // Parse the JSON
  const data = JSON.parse($('#badgeData').html());
  // Get the first badge object from the array
  const firstBadge = data[0];
  if (!firstBadge) return; // No data to process
  console.log("badge_shapes: " + firstBadge.badge_shapes);
  // Set the default shape
  if (firstBadge.badge_shapes) {
  //  $('#badgeShapes').val(firstBadge.badge_shapes).trigger('change');
    $('input[name="badge_shape"]').filter('[value="' + firstBadge.badge_shapes + '"]').prop('checked', true).trigger('change');
  }

  console.log("badge_sizes: " + firstBadge.badge_sizes);

  // Set the default size
  if (firstBadge.badge_sizes) {
    $('#badge_size1').prop('checked', true).trigger('change');
   // //$('input[name="badge_size"]').filter('[value="' + firstBadge.badge_sizes + '"]').prop('checked', true).trigger('change');
  }
}

 $(document).on('click', '.downloadCanvas', function() {
      const dataURL = canvas.toDataURL({
        format: 'png',
        quality: 1
      });
      const link = document.createElement('a');
      link.href = dataURL;
      link.download = 'badge.png';
      document.body.appendChild(link);
      link.click();
      document.body.removeChild(link);
});

 jQuery('#customBadgeForm').on('submit', function(e) {
  e.preventDefault();

  const formData = jQuery(this).serializeArray();
  // Include canvas data
  const canvasData = canvas.toDataURL();
  formData.push({ name: 'canvas_data', value: canvasData });
  jQuery.ajax({
    url: wc_add_to_cart_params.ajax_url,
    type: 'POST',
    data: {
      action: 'custom_badge_add_to_cart',
      data: formData
    },
    success: function(response) {
      if (response.success) {
        // Use jsConfirm
        $.confirm({
          title: 'Success!',
          content: 'Added to cart!',
          type: 'green',
          buttons: {
            ok: {
              text: 'OK',
              btnClass: 'btn-green',
              action: function() {
                // Redirect to the cart page
                window.location.href = wc_add_to_cart_params.cart_url;
              }
            }
          }
        });
      } else {
        $.alert({
          title: 'Error!',
          content: 'Something went wrong!',
          type: 'red'
        });
      }
    }
  });
});


function updateBadgePreview() {
  // Get selected values
  const shape = $('input[name="badge_shape"]:checked').val();
  const color = $('input[name="badge_color"]:checked').val() || '#fff';
  const corner = $('input[name="badge_corners"]:checked').val();
  const size = $('input[name="badge_size"]:checked').val();

  // Default inches
  let first = 1, second = 1;
  if (size) {
    const sizeParts = size.split('x').map(part => parseInches(part.replace(/["']/g, '').trim()));
   // alert('size'+size);
   // alert('sizeParts'+sizeParts);
    if (sizeParts.length === 2) {
      first = sizeParts[0];
      second = sizeParts[1];
    }
  }

  // Determine bigger and smaller
  let widthIn, heightIn;
  if (first >= second) {
    widthIn = first;
    heightIn = second;
  } else {
    widthIn = second;
    heightIn = first;
  }

  const pixelPerInch = 100;
  const canvasWidthPx = widthIn * pixelPerInch;
  const canvasHeightPx = heightIn * pixelPerInch;

  // Update canvas element size
  const canvasEl = document.getElementById('badgeCanvas');
  canvasEl.width = canvasWidthPx;
  canvasEl.height = canvasHeightPx;

  // Update canvas container size (if needed)
  $('.canvasSec').css({
    width: canvasWidthPx + 'px',
    height: canvasHeightPx + 'px'
  });

  // Update spans
  $('#canvasWidth').text(widthIn + '"');
  $('#canvasHeight').text(heightIn + '"');

  // !! IMPORTANT: Reset canvas (re-create)
  canvas.setWidth(canvasWidthPx);
  canvas.setHeight(canvasHeightPx);
  canvas.clear(); // Clear existing shapes

  // If no shape selected, skip
  if (!shape) return;

  // Create new shape
  let shapeObj;
  if (shape === 'Rectangle') {
    shapeObj = new fabric.Rect({
      left: 0,
      top: 0,
      width: canvasWidthPx,
      height: canvasHeightPx,
      fill: color,
      rx: corner === 'Rounded' ? 20 : 0,
      ry: corner === 'Rounded' ? 20 : 0
    });
  } else {
    shapeObj = new fabric.Ellipse({
      left: 0,
      top: 0,
      rx: canvasWidthPx / 2,
      ry: canvasHeightPx / 2,
      fill: color
    });
  }
  canvas.add(shapeObj);

  // Add image if present
  // if (userImage) {
  //   userImage.scaleToWidth(canvasWidthPx);
  //   userImage.scaleToHeight(canvasHeightPx);
  //   userImage.left = 0;
  //   userImage.top = 0;
  //   canvas.add(userImage);
  //   canvas.bringToFront(userImage);
  // }

      $('#badge_shape_input').val($('input[name="badge_shape"]:checked').val());
      $('#badge_size_input').val($('input[name="badge_size"]:checked').val());
      $('#badge_thickness_input').val($('input[name="badge_thickness"]:checked').val());
      $('#badge_finish_input').val($('input[name="badge_finish"]:checked').val());
      $('#badge_color_input').val($('input[name="badge_color"]:checked').val());
      $('#badge_corner_input').val($('input[name="badge_corners"]:checked').val());
      $('#badge_backing_input').val($('input[name="badge_backing"]:checked').val());

    if (userImage) {
        canvas.add(userImage);
        canvas.bringToFront(userImage);
    }

    canvas.renderAll();
}


    // Image upload
    // $(document).on('change', '.badge-upload', function(e){
    //     const file = e.target.files[0];
    //     if (file) {
    //         const reader = new FileReader();
    //         reader.onload = function(f){
    //             fabric.Image.fromURL(f.target.result, function(img){
    //                 img.scaleToWidth(150);
    //                 img.scaleToHeight(150);
    //                 img.left = 75;
    //                 img.top = 0;
    //                 img.hasControls = true;
    //                 userImage = img;

    //                 updateBadgePreview();
    //             });
    //         };
    //         reader.readAsDataURL(file);
    //     }
    // });

    $(document).on('change', '.badge-upload', function(e) {
        const file = e.target.files[0];
          if (file) {
            const reader = new FileReader();
            reader.onload = function(f) {
              fabric.Image.fromURL(f.target.result, function(img) {
                // Get canvas size
                const canvasWidth = canvas.getWidth();
                const canvasHeight = canvas.getHeight();

                // Scale image to fit the canvas
                img.scaleToWidth(canvasWidth);
                img.scaleToHeight(canvasHeight);

                // Center the image
                img.left = 0;
                img.top = 0;

                // Allow user to resize/move the image
                img.hasControls = true;

                userImage = img;

                updateBadgePreview();
              });
            };
            reader.readAsDataURL(file);
          }
    });


    // When the user changes any option, update preview
    $(document).on('change', 'input[type="radio"]', function(){
        updateBadgePreview();
        $('#selected-column').show();
        updateSelectedColumn();
    });

    setDefaultShapeAndSize();

    // Initialize preview
    updateBadgePreview();
    updateSelectedColumn();
});

// jQuery('#customBadgeForm').on('submit', function(e) {
//   e.preventDefault();

//   const formData = jQuery(this).serialize();

//   jQuery.post(wc_add_to_cart_params.ajax_url, {
//   action: 'custom_badge_add_to_cart',
//     data: formData
//     }, function(response) {
//       if (response.success) {
//         alert('Added to cart!');
//         // Optionally update the cart UI here
//       } else {
//         alert('Something went wrong!');
//       }
//     });  
// });

