jQuery(document).ready(function($) {
    // Add More for Quantity-Price within SKU block
    $('#ptp-metabox').on('click', '.add-entry', function(e) {
        e.preventDefault();
        let $skuBlock = $(this).closest('.sku-block');
        let $entriesContainer = $skuBlock.find('.volume-pricing-entries');
        let skuIndex = $('.sku-block').index($skuBlock);
        let nextIndex = $entriesContainer.find('.volume-pricing-entry').length + 1;

        let newEntry = `
            <div class="volume-pricing-entry">
                <input type="text" name="product_custom_options[${skuIndex}][qty${nextIndex}]" placeholder="Quantity Range (e.g., 1-4)" />
                <input type="text" name="product_custom_options[${skuIndex}][price${nextIndex}]" placeholder="Price" />
                <button class="remove-entry">Remove</button>
            </div>
        `;
        $entriesContainer.append(newEntry);
    });

    // Remove Entry
    $('#ptp-metabox').on('click', '.remove-entry', function(e) {
        e.preventDefault();
        $(this).closest('.volume-pricing-entry').remove();
    });

    // Add SKU block
    $('#add-sku-block').click(function(e) {
        e.preventDefault();
        let skuIndex = $('.sku-block').length;
        let newBlock = `
            <div class="sku-block">
                <label>SKU: <input type="text" name="product_custom_options[${skuIndex}][sku]" /></label>
                <div class="volume-pricing-entries">
                    <div class="volume-pricing-entry">
                        <input type="text" name="product_custom_options[${skuIndex}][qty1]" placeholder="Quantity Range (e.g., 1-4)" />
                        <input type="text" name="product_custom_options[${skuIndex}][price1]" placeholder="Price" />
                        <button class="remove-entry">Remove</button>
                    </div>
                </div>
                <button class="add-entry">Add More</button>
                <hr />
            </div>
        `;
        $('#ptp-metabox').append(newBlock);
    });
});
