<?php
/**
* Template Name: About
*
*/

get_header();

?>


<section class="inner-banner">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h1><?php echo get_the_title(); ?></h1>
                <ul>
                    <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                    <li><?php echo get_the_title(); ?></li>
                </ul>
            </div>
        </div>
    </div>
</section>

<section class="about-sec1">
    <div class="container">

        <div class="row align-items-lg-center mb-40">
            <div class="col-lg-6 col-md-6">
                <?php echo get_field('our_story_content'); ?>
            </div>
            <div class="col-lg-6 col-md-6">
                <?php 
                    $image_1 = get_field('our_story_image'); 
                    $image_1_alt = ($image_1['alt']) ? ($image_1['alt']) : ($image['title']);
                ?>

                <img src="<?php echo esc_url($image_1['url']); ?>" alt="<?php echo $image_1_alt; ?>" class="main-img">
            </div>
        </div>


        <div class="row align-items-lg-center mb-40">
            <div class="col-lg-6 col-md-6">
                <?php 
                    $image_2 = get_field('the_sustainable_image'); 
                    $image_2_alt = ($image_2['alt']) ? ($image_2['alt']) : ($image_2['title']);
                ?>

                <img src="<?php echo esc_url($image_2['url']); ?>" alt="<?php echo $image_2_alt; ?>" class="main-img">
            </div>
            <div class="col-lg-6 col-md-6">
                <?php echo get_field('the_sustainable_content'); ?>
            </div>
        </div>

    </div>
</section>

<section class="about-sec2">
    <div class="container">
        <div class="row">

            <?php if(have_rows('box')) : ?>
            <?php while(have_rows('box')) : the_row(); ?>
            <div class="col-lg-3 col-md-6">
                <div class="cart-wraper">
                    <?php 
                        $image = get_sub_field('icon'); 
                        $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                    ?>

                    <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>">

                    <?php echo get_sub_field('content'); ?>
                </div>
            </div>
            <?php endwhile; endif; ?>

        </div>
    </div>
</section>



<?php
get_footer();
?>
