<?php
/**
* Template Name: Contact
*
*/

get_header();

?>


<section class="inner-banner">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h1><?php echo get_the_title(); ?></h1>
                <ul>
                    <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                    <li><?php echo get_the_title(); ?></li>
                </ul>
            </div>
        </div>
    </div>
</section>

<section class="contact-sec1">
    <div class="container">
        <div class="row">

            <?php if(have_rows('contact_details')) : ?>
            <?php while(have_rows('contact_details')) : the_row(); ?>

            <div class="col-lg-6 col-md-6">
                <div class="c-details-cart">
                    <div class="text-wraper">

                        <?php 
                            $image = get_sub_field('icon'); 
                            $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                        ?>
                        <span><img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>"></span>

                        <h5><?php echo get_sub_field('title'); ?></h5>
                    </div>
                    <p><?php echo get_sub_field('info'); ?></p>

                    <?php 
                        $button = get_sub_field('contact_no_email'); 
                        if( $button ): 
                            $link_url = $button['url'];
                            $link_title = $button['title']; 
                            $link_target = $button['target'] ? $button['target'] : '_self'; 
                    ?>
                    <a href="<?php echo esc_url(  $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                    <?php endif; ?>
                </div>
            </div>

            <?php endwhile; endif; ?>

        </div>
    </div>
</section>

<section class="contact-sec2">
    <div class="container">
        <div class="row align-items-lg-center">
            <div class="col-lg-6 col-md-6">

                <?php echo get_field('left_side_content'); ?>
                
                <?php echo do_shortcode('[contact-form-7 id="416f78e" title="Contact Page Form"]'); ?>
                
            </div>

            <div class="col-lg-6 col-md-6">
                <?php 
                    $image = get_field('form_image'); 
                    $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                ?>

                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>" class="right-img">
            </div>
        </div>
    </div>
</section>



<?php
get_footer();
?>
