<?php
/**
* Template Name: Home
*
*/
get_header();

?>
<section class="home-banner">
    <div class="bnr-slid owl-carousel owl-theme">

        <?php if(have_rows('banner_slider')) : ?>
        <?php while(have_rows('banner_slider')) : the_row(); ?>
        <div class="item">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 col-md-7">

                        <?php echo get_sub_field('slider_content'); ?>

                        <div class="btn-wraper">

                            <?php 
                                $button_1 = get_sub_field('button_1'); 
                                if( $button_1 ): 
                                    $link_url = $button_1['url'];
                                    $link_title = $button_1['title']; 
                                    $link_target = $button_1['target'] ? $button_1['target'] : '_self'; 
                            ?>
                            <a href="<?php echo esc_url(  $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>" class="green-btn"><?php echo esc_html( $link_title ); ?></a>
                            <?php endif; ?>


                            <?php 
                                $button_2 = get_sub_field('button_2'); 
                                if( $button_2 ): 
                                    $link_url = $button_2['url'];
                                    $link_title = $button_2['title']; 
                                    $link_target = $button_2['target'] ? $button_2['target'] : '_self'; 
                            ?>
                            <a href="<?php echo esc_url(  $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>" class="border-btn"><?php echo esc_html( $link_title ); ?></a>
                            <?php endif; ?>
                            
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-5 ms-auto">
                        <?php 
                            $image = get_sub_field('image'); 
                            $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                        ?>

                        <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>" class="rignt-img">
                    </div>
                </div>
            </div>
        </div>
        <?php endwhile; endif; ?>

    </div>
</section>

<section class="home-sec2">
    <div class="container">
        <div class="row">

            <?php if(have_rows('section_2_box')) : ?>
            <?php $i = 1; while(have_rows('section_2_box')) : the_row(); ?>

            <div class="col-lg-6 col-md-6">
                <div class="cart-item">
                    <?php echo get_sub_field('content'); ?>
                    <?php 
                        $button = get_sub_field('button'); 
                        if( $button ): 
                            $link_url = $button['url'];
                            $link_title = $button['title']; 
                            $link_target = $button['target'] ? $button['target'] : '_self'; 
                    ?>
                    <a href="<?php echo esc_url(  $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>" class="green-btn"><?php echo esc_html( $link_title ); ?></a>
                    <?php endif; ?>

                    <?php 
                        $image = get_sub_field('image'); 
                        $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                    ?>

                    <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>" class="hm-cart<?php echo $i; ?>-img">
                    <span class="circle"></span>
                </div>
            </div>

            <?php $i++; endwhile; endif; ?>

        </div>
    </div>
</section>

<?php //get_template_part( 'template-parts/product', 'part_old' );?>
<?php get_template_part( 'template-parts/product', 'part' );?>



<?php
get_footer();
?>
