<?php
/**
* Template Name: Reset password
*
*/

get_header();


if ( isset( $_GET['cusresetpass'] ) && ( isset( $_GET['cusfrp_action'] ) && $_GET['cusfrp_action'] == 'rp' ) ) {

	$key = sanitize_text_field( $_GET['key'] );

	$user_email = sanitize_text_field( $_GET['uid'] );

	$userdata = get_user_by( "email", $user_email  );

	$login = $userdata ? $userdata->user_login : '';

	$user = check_password_reset_key( $key, $login );


?>


<section class="inner-banner">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h1><?php echo get_the_title(); ?></h1>
                <ul>
                    <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                    <li><?php echo get_the_title(); ?></li>
                </ul>
            </div>
        </div>
    </div>
</section>

<section class="loginAndsignup-sec">
    <div class="container">
        <div class="row align-items-lg-center">
            <div class="col-lg-6 col-md-7">
                <h2>Reset Your Password</h2>

                <div class="form-wraper">

                    <form method="POST" action="" id="reset_form" name="reset-form">
                        <input class="form-control" type="hidden" id="id" name="userid" value="<?php echo $userdata->ID; ?>">


                        <label for="">New Password</label>
                        <div class="password-wraper">
                            <input type="password" name="password" id="password" placeholder="**********************">
                            <i class="toggle-password fa fa-fw fa-eye-slash"></i>
                        </div>

                        <label for="">Confirm Password</label>
                        <div class="password-wraper">
                            <input type="password" name="re_password" id="re_password" placeholder="**********************">
                            <i class="toggle-password fa fa-fw fa-eye-slash"></i>
                        </div>

                        <input type="submit" id="resetbtn" value="Submit" class="green-btn">

                    </form>

                    <div id="succ_msg" style="color:#9FCC3B;margin-bottom: 20px;"></div>
                    <div id="error_msg" style="color:Red;margin-bottom: 20px;"></div>

                </div>
            </div>
            <div class="col-lg-6 col-md-5">
                <?php 
                    $image = get_field('login_page_image', 'option'); 
                    $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                ?>

                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>" class="login-img">
            </div>
        </div>
    </div>
</section>





<?php
}else{
    ?>

<section class="">
<div class="content">
        <div class="container">
            <div class="row">
<div class="col-md-12">

<h2>Something Went Wrong </h2>
</div>

            </div></div></div>
</section>

<?php
    

}
?>


<!-- <script>
    document.getElementById('btnToggle').addEventListener('click', function() {
        var passwordInput = document.getElementById('password');
        var eyeIcon = document.getElementById('eyeIcon');

        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            eyeIcon.classList.remove('fa-eye-slash');
            eyeIcon.classList.add('fa-eye');
        } else {
            passwordInput.type = 'password';
            eyeIcon.classList.remove('fa-eye');
            eyeIcon.classList.add('fa-eye-slash');
        }
    });

    document.getElementById('btnToggle2').addEventListener('click', function() {
        var passwordInput = document.getElementById('re_password');
        var eyeIcon = document.getElementById('eyeIcon2');

        if (passwordInput.type === 're_password') {
            passwordInput.type = 'text';
            eyeIcon.classList.remove('fa-eye-slash');
            eyeIcon.classList.add('fa-eye');
        } else {
            passwordInput.type = 're_password';
            eyeIcon.classList.remove('fa-eye');
            eyeIcon.classList.add('fa-eye-slash');
        }
    });
</script> -->


<?php
get_footer();
?>


<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.js"></script>

<script>
jQuery("#reset_form").validate({

rules: {
    password: {
        required: true,
        minlength: 8
    },
    re_password: {
        equalTo: "#password"
    }
},
messages: {
    password: {
                    required: "Password is required",
                    minlength: "Password must be at least 8 characters long"
                },
    re_password:  'Confirm Password does not match',
},
submitHandler: function(form) {

    
    var redirecturl =  '<?php echo get_site_url(); ?>/log-in';
    var pass = jQuery('#password').val();
    var repass = jQuery('#re_password').val();
    var id = jQuery('#id').val();
    jQuery.ajax({
        type: "POST",
        url: "<?php echo admin_url('admin-ajax.php'); ?>",
        // dataType: "json",
        data:  {
	        action: "reset_npassword",
            uid: id, 
	        pass: pass,
	        repass: repass
	    },

        beforeSend: function() {
             jQuery('#succ_msg').html('Please Wait...').show();
            
          },
        success: function(data) {
            console.log(data);
          if(data == false){
            jQuery("#error_msg").html('Something Went wrong..').show();
           
          }else{
            jQuery("#succ_msg").html('Password changed Successfully.').show();
            window.location.href = redirecturl;

            
          }
            
            
        },
        error: function(data) {
            console.log('An error occurred.');
            console.log(data);
        },
    });

}
});

</script>
