<?php
/**
 * Template name: Signup
 */


 if(is_user_logged_in()){ 
	
	$user = wp_get_current_user();

    
    $redirecturl = site_url('/');
	   wp_safe_redirect($redirecturl);

	
}

get_header();
?>


<section class="inner-banner">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h1><?php echo get_the_title(); ?></h1>
                <ul>
                    <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                    <li><?php echo get_the_title(); ?></li>
                </ul>
            </div>
        </div>
    </div>
</section>


<section class="loginAndsignup-sec">
    <div class="container">
        <div class="row align-items-lg-center">
            <div class="col-lg-6 col-md-7">
                <h2>Create Account</h2>
                <div class="form-wraper">

                    <form action="#" action="" enctype="multipart/form-data" id="CustomerRegForm">

                        <label for="">Full Name</label>
                        <input type="text" name="fullName" id="fullName" placeholder="John smith">

                        <label for="">Email</label>
                        <input type="email" name="cemail" id="cemail" placeholder="Johnsmith@gmail.com">

                        <label for="">Create Password</label>
                        <div class="password-wraper last_p">
                            <input type="password" name="cpw" id="cpw" placeholder="**********************">
                            <i class="toggle-password fa fa-fw fa-eye-slash"></i>
                        </div>

                        <label for="">Confirm Password</label>
                        <div class="password-wraper">
                            <input type="password" name="crpw" id="crpw" placeholder="**********************">
                            <i class="toggle-password fa fa-fw fa-eye-slash"></i>
                        </div>
                        <input type="submit" value="Sign Up" class="green-btn">

                    </form>

                    <div id="succ_msg" style="color:#9FCC3B;margin-bottom: 20px;"></div>
                    <div id="error_msg" style="color:Red;margin-bottom: 20px;"></div>

                    <p>Already have an account? <a href="<?php echo get_site_url(); ?>/log-in">Log In</a></p>
                </div>
            </div>
            <div class="col-lg-6 col-md-5">
                <?php 
                    $image = get_field('signup_page_image', 'option'); 
                    $image_alt = ($image['alt']) ? ($image['alt']) : ($image['title']);
                ?>

                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo $image_alt; ?>" class="signup-img">
            </div>
        </div>
    </div>
</section>



<?php
get_footer(); ?>

<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.js"></script>

<script>
	
jQuery(document).ready(function($) {
    $("#CustomerRegForm").validate({
        rules: {
            fullName: { required: true },
            cemail: { required: true, email: true },
            cpw: { required: true, minlength: 8 },
            crpw: { equalTo: "#cpw" }
        },
        messages: {
            fullName: { required: "Full Name is required" },
            cemail: { required: "Email is required", email: "Enter a valid email address" },
            cpw: { required: "Password is required", minlength: "Password must be at least 8 characters long" },
            crpw: { equalTo: "Confirm Password does not match" }
        },
        submitHandler: function(form, event) {
            event.preventDefault();
            var formData = new FormData(form);

            // Check if the email already exists
            $.ajax({
                url: "<?php echo admin_url('admin-ajax.php'); ?>",
                type: "POST",
                data: {
                    action: 'check_email_exists',
                    email: $('#cemail').val()
                },
                success: function(response) {
                    if (response.message == "exists") {
                        alert("Email already exists!");
                    } else {
                        // Proceed to create account
                        formData.append('action', 'create_your_subscriber_account');
                        $.ajax({
                            type: "POST",
                            url: "<?php echo admin_url('admin-ajax.php'); ?>",
                            data: formData,
                            processData: false,
                            contentType: false,
                            beforeSend: function() {
                                $('#succ_msg').html('Please wait...').show();
                            },
                            success: function(data) {
                                if (data.success) {
                                    $('#succ_msg').html('Account created successfully! Redirecting...').show();
                                    window.location.href = "<?php echo get_site_url(); ?>"; // Redirect to home
                                } else {
                                    $('#error_msg').html('Something went wrong.').show();
                                }
                            },
                            error: function() {
                                console.log('Error occurred during registration.');
                            }
                        });
                    }
                }
            });
        }
    });
});	
	
	
</script>

