<?php
defined( 'ABSPATH' ) || exit;

//do_action( 'woocommerce_account_navigation' ); // You can move this if you want custom nav placement
?>

<div class="container my-4">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-md-3 mb-3">
            <div class="list-group">
                <?php foreach ( wc_get_account_menu_items() as $endpoint => $label ) : ?>
                    <a 
                        href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>" 
                        class="list-group-item list-group-item-action <?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
                        <?php echo esc_html( $label ); ?>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Main content -->
        <div class="col-md-9">
            <div class="card">
                <div class="card-body">
                    <?php
                    /**
                     * My Account content.
                     *
                     * @since 2.6.0
                     */
                    do_action( 'woocommerce_account_content' );
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
