<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php wp_title( '|', true, 'right' ); ?></title>
    <link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/assets/images/fav.svg">
    
    <?php wp_head(); ?>
</head>

<body>
<header>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-2 col-md-3 col-5">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="logo"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/logo-header.svg" alt=""></a>
            </div>

            <div class="col-lg-6 col-md-1">
                <div id="navigation">
                    <nav>
                    	<?php //wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class'=>'header-menu', 'container' => '' ) ); ?>
                        <ul class="header-menu">
                            <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
                            <li>
                                <a href="#?">Platform <img src="<?php echo get_template_directory_uri(); ?>/assets/images/arow-down.svg" alt=""></a>
                                <ul class="dropdown">
                                    <li><a href="#?">Overview</a></li>
                                    <li><a href="#?">Investment Product</a></li>
                                    <li><a href="#?">Risk & Compliance</a></li>
                                    <li><a href="#?">Reporting</a></li>
                                </ul>
                            </li>
                            <li>
                                <a href="#?">About <img src="<?php echo get_template_directory_uri(); ?>/assets/images/arow-down.svg" alt=""></a>
                                <ul class="dropdown">
                                    <li><a href="#?">Our Story</a></li>
                                    <li><a href="#?">Careers</a></li>
                                    <li><a href="#?">Contact Us</a></li>
                                </ul>
                            </li>
                            <li><a href="#?">Resources</a></li>
                            <li class="for-mobile"><a href="#?">Request a Demo</a></li>
                        </ul>
                    </nav>
                </div>
            </div>

            <div class="col-lg-4 col-md-8 col-6">
                <div class="btn-wrap">
                    <a href="#?" class="white-btn">Log In</a>
                    <a href="#?" class="blue-btn">Request a Demo</a>
                </div>
            </div>
        </div>
    </div>
</header>