<?php

if ( ! isset( $content_width ) )
	$content_width = 604;

function admin_bar(){

  if(is_user_logged_in()){
    add_filter( 'show_admin_bar', '__return_true' , 1000 );
  }
}
add_action('init', 'admin_bar' );

function moneyfund_setup() {

	register_nav_menu( 'primary', __( 'Primary Menu', 'moneyfund' ) );
    register_nav_menu( 'header', __( 'Header Menu', 'moneyfund' ) );
    register_nav_menu( 'footer', __( 'Footer Menu', 'moneyfund' ) );
	register_nav_menu( 'privacy', __( 'privacy Menu', 'moneyfund' ) );


 	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
    add_image_size( 'team', 356, 341, true );





	//set_post_thumbnail_size( 604, 270, true );
}
add_action( 'after_setup_theme', 'moneyfund_setup' );



function moneyfund_wp_title( $title, $sep ) {
	global $paged, $page;
	if ( is_feed() )
		return $title;
	$title .= get_bloginfo( 'name', 'display' );
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title = "$title $sep $site_description";
	if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() )
		$title = "$title $sep " . sprintf( __( 'Page %s', 'moneyfund_wp_title' ), max( $paged, $page ) );
	return $title;
}
add_filter( 'wp_title', 'moneyfund_wp_title', 10, 2 );



function moneyfund_scripts_styles() {
  /*wp_enqueue_style( 'moneyfund-style', get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'moneyfund-style', get_stylesheet_uri(), array(), '2025-05-29' );*/
  wp_enqueue_style( 'moneyfund-style', get_stylesheet_uri(), array(), '2025-05-29' );


	$theme_uri = get_template_directory_uri();

    // Styles
    wp_enqueue_style('bootstrap', $theme_uri . '/assets/css/bootstrap.min.css');
    wp_enqueue_style('owl-carousel', $theme_uri . '/assets/css/owl.carousel.min.css');
    wp_enqueue_style('owl-theme', $theme_uri . '/assets/css/owl.theme.default.css');
    wp_enqueue_style('slimnav', $theme_uri . '/assets/css/slimNav_sk78.css');
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css', array(), null);
    wp_enqueue_style('main-style', $theme_uri . '/assets/css/style.css');
    wp_enqueue_style('responsive', $theme_uri . '/assets/css/responsive.css');

    // Scripts
    wp_enqueue_script('jquery'); // WordPress includes jQuery already

    wp_enqueue_script('bootstrap', $theme_uri . '/assets/js/bootstrap.min.js', array('jquery'), null, true);
    wp_enqueue_script('slimnav', $theme_uri . '/assets/js/jquery.slimNav_sk78.min.js', array('jquery'), null, true);
    wp_enqueue_script('owl-carousel', $theme_uri . '/assets/js/owl.carousel.js', array('jquery'), null, true);
    wp_enqueue_script('custom-script', $theme_uri . '/assets/js/script.js', array('jquery'), null, true);
	
}
add_action( 'wp_enqueue_scripts', 'moneyfund_scripts_styles' );




function custom_excerpt_length($length) {
    return 30;
}
add_filter('excerpt_length', 'custom_excerpt_length');


/*
add_filter('wpcf7_autop_or_not', '__return_false');

add_filter('wpcf7_form_elements', function($content) {
    $content = preg_replace('/<(span).*?class="\s*(?:.*\s)?wpcf7-form-control-wrap(?:\s[^"]+)?\s*"[^\>]*>(.*)<\/\1>/i', '\2', $content);

    return $content;
});*/



//Upload SVG images
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {
    $filetype = wp_check_filetype( $filename, $mimes );
    return [
        'ext'             => $filetype['ext'],
        'type'            => $filetype['type'],
        'proper_filename' => $data['proper_filename']
    ];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  
  function fix_svg() {
    echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
  }
  add_action( 'admin_head', 'fix_svg' );


/*Create Properties Post*/
add_action( 'init', 'register_property' );
function register_property() {
    register_post_type( 'property',
        array(
            'labels' => array(
                'name' => _x( 'Property', 'property' ),
                'singular_name' => _x( 'Property', 'property' ),
                'add_new' => 'Add New Property',
                'add_new_item' => 'Add New Property',
                'all_items'    =>  _x( 'All Property', 'property' ),
                'edit_item' => 'Edit Property',
                'new_item' => 'New Property',
                'view_item' => 'View Property',
                'search_items' => 'Search Property',
                'not_found' =>  'Nothing Found',
                'not_found_in_trash' => 'Nothing found in the Trash',
                'parent_item_colon' => ''
            ),
            'public' => true,
            'publicly_queryable' => true,
            'show_ui' => true,
            'query_var' => true,
            'show_in_rest' => true,
            'exclude_from_search' => false,
            'menu_icon' => 'dashicons-insert',
            'rewrite' => true,
            'capability_type' => 'post',
            'hierarchical' => false,
            'menu_position' => null,
            'supports' => array( 'title', 'editor', 'thumbnail' )
        )
    );
}


add_action( 'init', 'create_propertytax_nonhierarchical_taxonomy', 0 );
  
function create_propertytax_nonhierarchical_taxonomy() {
    //Category
    $labels = array(
        'name' => _x( 'Categories', 'taxonomy general name' ),
        'singular_name' => _x( 'Category', 'taxonomy singular name' ),
        'search_items' =>  __( 'Search Categories' ),
        'popular_items' => __( 'Popular Categories' ),
        'all_items' => __( 'All Categories' ),
        'parent_item' => null,
        'parent_item_colon' => null,
        'edit_item' => __( 'Edit Category' ), 
        'update_item' => __( 'Update Category' ),
        'add_new_item' => __( 'Add New Category' ),
        'new_item_name' => __( 'New Category Name' ),
        'separate_items_with_commas' => __( 'Separate categories with commas' ),
        'add_or_remove_items' => __( 'Add or remove categories' ),
        'choose_from_most_used' => __( 'Choose from the most used categories' ),
        'menu_name' => __( 'Categories' ),
      ); 
      
    // Now register the non-hierarchical taxonomy like tag
      
      register_taxonomy('property-categoty','property',array(
        'hierarchical' => true,
        'labels' => $labels,
        'show_ui' => true,
        'show_in_rest' => true,
        //'show_admin_column' => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var' => true,
        'rewrite' => array( 'slug' => 'property-categoty' ),
      ));

    

       //Type
      $type = array(
        'name' => _x( 'Types', 'taxonomy general name' ),
        'singular_name' => _x( 'Type', 'taxonomy singular name' ),
        'search_items' =>  __( 'Search Types' ),
        'popular_items' => __( 'Popular Types' ),
        'all_items' => __( 'All Types' ),
        'parent_item' => null,
        'parent_item_colon' => null,
        'edit_item' => __( 'Edit Type' ), 
        'update_item' => __( 'Update Type' ),
        'add_new_item' => __( 'Add New Type' ),
        'new_item_name' => __( 'New Type Name' ),
        'separate_items_with_commas' => __( 'Separate types with commas' ),
        'add_or_remove_items' => __( 'Add or remove types' ),
        'choose_from_most_used' => __( 'Choose from the most used types' ),
        'menu_name' => __( 'Types' ),
      ); 
      
    // Now register the non-hierarchical taxonomy like tag
      
      register_taxonomy('type','property',array(
        'hierarchical' => true,
        'labels' => $type,
        'show_ui' => true,
        'show_in_rest' => true,
        'show_admin_column' => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var' => true,
        'rewrite' => array( 'slug' => 'type' ),
      ));

      
      //Country
      $region = array(
        'name' => _x( 'County', 'taxonomy general name' ),
        'singular_name' => _x( 'County', 'taxonomy singular name' ),
        'search_items' =>  __( 'Search County' ),
        'popular_items' => __( 'Popular County' ),
        'all_items' => __( 'All County' ),
        'parent_item' => null,
        'parent_item_colon' => null,
        'edit_item' => __( 'Edit County' ), 
        'update_item' => __( 'Update County' ),
        'add_new_item' => __( 'Add New County' ),
        'new_item_name' => __( 'New County Name' ),
        'separate_items_with_commas' => __( 'Separate types with commas' ),
        'add_or_remove_items' => __( 'Add or remove County' ),
        'choose_from_most_used' => __( 'Choose from the most used County' ),
        'menu_name' => __( 'County' ),
      ); 
      
    // Now register the non-hierarchical taxonomy like tag
      
      register_taxonomy('region','property',array(
        'hierarchical' => true,
        'labels' => $region,
        'show_ui' => true,
        'show_in_rest' => true,
        //'show_admin_column' => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var' => true,
        'rewrite' => array( 'slug' => 'region' ),
      ));


      

      $yearnew = array(
          'name' => _x('Property Year', 'taxonomy general name'),
          'singular_name' => _x('Property Year', 'taxonomy singular name'),
          'search_items' => __('Search Property Year'),
          'all_items' => __('All Property Years'),
          'edit_item' => __('Edit Property Year'), 
          'update_item' => __('Update Property Year'),
          'add_new_item' => __('Add New Property Year'),
          'new_item_name' => __('New Property Year Name'),
          'menu_name' => __('Property Year'),
      );

      register_taxonomy('property_year', 'property', array(
          'hierarchical' => true,
          'labels' => $yearnew,
          'show_ui' => true,
          'show_in_rest' => true,
          'show_admin_column' => true,
          'query_var' => true,
          'rewrite' => array('slug' => 'property-year'),
      ));

      //Status
      $status = array(
        'name' => _x( 'Status', 'taxonomy general name' ),
        'singular_name' => _x( 'Status', 'taxonomy singular name' ),
        'search_items' =>  __( 'Search Status' ),
        'popular_items' => __( 'Popular Status' ),
        'all_items' => __( 'All Status' ),
        'parent_item' => null,
        'parent_item_colon' => null,
        'edit_item' => __( 'Edit Status' ), 
        'update_item' => __( 'Update Status' ),
        'add_new_item' => __( 'Add New Status' ),
        'new_item_name' => __( 'New Status Name' ),
        'separate_items_with_commas' => __( 'Separate types with commas' ),
        'add_or_remove_items' => __( 'Add or remove Status' ),
        'choose_from_most_used' => __( 'Choose from the most used Status' ),
        'menu_name' => __( 'Status' ),
      ); 
      
    // Now register the non-hierarchical taxonomy like tag
      
      register_taxonomy('status','property',array(
        'hierarchical' => true,
        'labels' => $status,
        'show_ui' => true,
        'show_in_rest' => true,
        'show_admin_column' => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var' => true,
        'rewrite' => array( 'slug' => 'status' ),
      ));


      //City
      $city = array(
        'name' => _x( 'City', 'taxonomy general name' ),
        'singular_name' => _x( 'City', 'taxonomy singular name' ),
        'search_items' =>  __( 'Search City' ),
        'popular_items' => __( 'Popular City' ),
        'all_items' => __( 'All City' ),
        'parent_item' => null,
        'parent_item_colon' => null,
        'edit_item' => __( 'Edit City' ), 
        'update_item' => __( 'Update City' ),
        'add_new_item' => __( 'Add New City' ),
        'new_item_name' => __( 'New City Name' ),
        'separate_items_with_commas' => __( 'Separate types with commas' ),
        'add_or_remove_items' => __( 'Add or remove City' ),
        'choose_from_most_used' => __( 'Choose from the most used City' ),
        'menu_name' => __( 'City' ),
      ); 
      
    // Now register the non-hierarchical taxonomy like tag
      
      register_taxonomy('city','property',array(
        'hierarchical' => true,
        'labels' => $city,
        'show_ui' => true,
        'show_in_rest' => true,
        //'show_admin_column' => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var' => true,
        'rewrite' => array( 'slug' => 'city' ),
      ));

}



add_action('save_post', function ($post_id) {
    // Prevent running on autosave or revisions
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (wp_is_post_revision($post_id)) return;

    // Ensure it's a 'property' post type
    if (get_post_type($post_id) !== 'property') return;

    // Get serialized meta data from 'location'
    $location = get_post_meta($post_id, 'location', true);

    // If 'location' meta exists and contains an address, extract it
    if (!empty($location) && is_array($location) && !empty($location['address'])) {
        // Save the extracted address as a separate meta field
        update_post_meta($post_id, 'location_address', sanitize_text_field($location['address']));
    }
});

function update_existing_location_address() {
    $args = array(
        'post_type'      => 'property',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $post_id = get_the_ID();

            // Get serialized meta data from 'location'
            $location = get_post_meta($post_id, 'location', true);

            // If valid data exists, update location_address
            if (!empty($location) && is_array($location) && !empty($location['address'])) {
                update_post_meta($post_id, 'location_address', sanitize_text_field($location['address']));
            }
        }
        wp_reset_postdata();
    }
}

// Run this function ONCE by visiting the URL: https://yourwebsite.com/?update_location_address=1
if (isset($_GET['update_location_address'])) {
    update_existing_location_address();
    //echo "Location addresses updated!";
    exit;
}

