<?php

if ( ! isset( $content_width ) )
	$content_width = 604;

function admin_bar(){

  if(is_user_logged_in()){
    add_filter( 'show_admin_bar', '__return_true' , 1000 );
  }
}
add_action('init', 'admin_bar' );

function smtheme_setup() {

	register_nav_menu( 'primary', __( 'Primary Menu', 'smtheme' ) );
    register_nav_menu( 'footer', __( 'Footer Menu', 'smtheme' ) );
	register_nav_menu( 'legal1', __( 'Legal 1 Menu', 'smtheme' ) );
    register_nav_menu( 'legal2', __( 'Legal 2 Menu', 'smtheme' ) );


 	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
    add_image_size( 'team', 356, 341, true );





	//set_post_thumbnail_size( 604, 270, true );
}
add_action( 'after_setup_theme', 'smtheme_setup' );



function smtheme_wp_title( $title, $sep ) {
	global $paged, $page;
	if ( is_feed() )
		return $title;
	$title .= get_bloginfo( 'name', 'display' );
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title = "$title $sep $site_description";
	if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() )
		$title = "$title $sep " . sprintf( __( 'Page %s', 'smtheme_wp_title' ), max( $paged, $page ) );
	return $title;
}
add_filter( 'wp_title', 'smtheme_wp_title', 10, 2 );



function smtheme_scripts_styles() {
  wp_enqueue_style( 'smtheme-style', get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'smtheme-style', get_stylesheet_uri(), array(), '2025-08-27' );
	
}
add_action( 'wp_enqueue_scripts', 'smtheme_scripts_styles' );

function custom_enqueue_assets() {

    // CSS files
    wp_enqueue_style( 'font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css', array(), '6.4.2' );
    wp_enqueue_style( 'bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css', array(), '5.2.3' );
    wp_enqueue_style( 'fancybox-css', 'https://cdn.jsdelivr.net/npm/@fancyapps/ui@6.0/dist/fancybox/fancybox.css', array(), '6.0' );
    wp_enqueue_style( 'stellarnav', get_stylesheet_directory_uri() . '/css/stellarnav.css', array(), '1.0' );
    wp_enqueue_style( 'custom-style', get_stylesheet_directory_uri() . '/css/style.css', array(), '1.0' );
    wp_enqueue_style( 'responsive-style', get_stylesheet_directory_uri() . '/css/responsive.css', array(), '1.0' );

    // JS files
    wp_enqueue_script( 'jquery' ); // Default WP jQuery
    wp_enqueue_script( 'jquery-migrate', 'https://cdnjs.cloudflare.com/ajax/libs/jquery-migrate/3.4.1/jquery-migrate.min.js', array('jquery'), '3.4.1', true );
    wp_enqueue_script( 'bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js', array('jquery'), '5.2.3', true );
    wp_enqueue_script( 'isotope', 'https://unpkg.com/isotope-layout@3/dist/isotope.pkgd.min.js', array('jquery'), '3.0', true );
    wp_enqueue_script( 'fancybox-js', 'https://cdn.jsdelivr.net/npm/@fancyapps/ui@6.0/dist/fancybox/fancybox.umd.js', array('jquery'), '6.0', true );
    wp_enqueue_script( 'stellernav-js', get_stylesheet_directory_uri() . '/js/stellernav.js', array('jquery'), '1.0', true );
    wp_enqueue_script( 'equalheight-js', get_stylesheet_directory_uri() . '/js/equalheight.js', array('jquery'), '1.0', true );
    wp_enqueue_script( 'app-js', get_stylesheet_directory_uri() . '/js/app.js', array('jquery'), '1.0', true );

}
add_action( 'wp_enqueue_scripts', 'custom_enqueue_assets' );




function custom_excerpt_length($length) {
    return 30;
}
add_filter('excerpt_length', 'custom_excerpt_length');




//Upload SVG images
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {
    $filetype = wp_check_filetype( $filename, $mimes );
    return [
        'ext'             => $filetype['ext'],
        'type'            => $filetype['type'],
        'proper_filename' => $data['proper_filename']
    ];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  
  function fix_svg() {
    echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
  }
  add_action( 'admin_head', 'fix_svg' );

// Remove <p> and <br/> from Contact Form 7
add_filter('wpcf7_autop_or_not', '__return_false');


//--------------------Load More functionality for gallery portion-----------------------------

// Enqueue front-end JS
add_action('wp_enqueue_scripts', function () {
    wp_enqueue_script(
        'gallery-load-more',
        get_stylesheet_directory_uri() . '/js/gallery-load-more.js',
        array('jquery'),
        '1.0',
        true
    );

    wp_localize_script('gallery-load-more', 'gallery_ajax', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce'    => wp_create_nonce('gallery_load_more'),
        'per_page' => 6, // keep in sync with template
    ));
});

// AJAX: load more gallery items
add_action('wp_ajax_load_more_gallery', 'theme_load_more_gallery');
add_action('wp_ajax_nopriv_load_more_gallery', 'theme_load_more_gallery');

function theme_load_more_gallery() {
    check_ajax_referer('gallery_load_more', 'nonce');

    $post_id  = isset($_POST['post_id'])  ? absint($_POST['post_id'])  : 0;
    $offset   = isset($_POST['offset'])   ? absint($_POST['offset'])   : 0;
    $per_page = isset($_POST['per_page']) ? absint($_POST['per_page']) : 6;

    if ( ! $post_id ) {
        wp_send_json_error(array('message' => 'Missing post_id'));
    }

    $rows = get_field('gallery_items', $post_id);
    if ( empty($rows) || !is_array($rows) ) {
        wp_send_json_error(array('message' => 'No items'));
    }

    $slice = array_slice($rows, $offset, $per_page);

    ob_start();
    foreach ($slice as $row) {
        $image          = isset($row['gallery_image']) ? $row['gallery_image'] : null;
        $category       = isset($row['gallery_category']) ? $row['gallery_category'] : '';
        $cat_class      = sanitize_title($category);
        $gallery_column = isset($row['gallery_column']) ? $row['gallery_column'] : '';
        $column_class   = ($gallery_column === 'Col-2') ? 'col-md-6 col-sm-12' : 'col-md-3 col-sm-6';

        if ($image && is_array($image)) {
            $url = esc_url($image['url']);
            $alt = esc_attr(!empty($image['alt']) ? $image['alt'] : 'Gallery image');

            echo '<div class="'.esc_attr($column_class).' grid-item '.esc_attr($cat_class).'">
                    <div class="eachGallary">
                        <a data-fancybox="gallery" data-src="'.$url.'">
                            <img src="'.$url.'" alt="'.$alt.'">
                        </a>
                    </div>
                  </div>';
        }
    }
    $html = ob_get_clean();

    $next_offset = $offset + count($slice);
    $has_more    = $next_offset < count($rows);

    wp_send_json_success(array(
        'html'        => $html,
        'next_offset' => $next_offset,
        'has_more'    => $has_more,
    ));
}





