jQuery(document).ready(function() {
    function wrapContactNavigation() {
        if (jQuery(window).width() <= 991) {
            if (!jQuery(".contact-navigation-wrapper").length) {
                jQuery(".contact, .navigation").wrapAll(
                    '<div class="contact-navigation-wrapper"></div>'
                );
            }
        } else {
            // unwrap if needed when going back to large screen
            if (jQuery(".contact-navigation-wrapper").length) {
                jQuery(".contact, .navigation").unwrap();
            }
        }
    }

    // Run on page load
    wrapContactNavigation();

    // Run on window resize
    jQuery(window).on("resize", function() {
        wrapContactNavigation();
    });
    //-------------------------------------------------------//
    // StellarNav Js
    //-------------------------------------------------------//
    jQuery(".stellarnav").stellarNav({
        breakpoint: 991,
        position: "right",
    });

    //-------------------------------------------------------//
    // StellarNav Js End
    //-------------------------------------------------------//

    //-------------------------------------------------------//
    // Faq on HomePage
    //-------------------------------------------------------//
    jQuery(".faq_box .acc_trigger:first").addClass("active").next().show();

    jQuery(".faq_box").each(function() {
        jQuery(this)
            .find(".faq_item > .acc_trigger")
            .bind("click", function() {
                const $faqGroup = jQuery(this).closest(".faq_group");

                // Close all other FAQ groups
                jQuery(".faq_group")
                    .not($faqGroup)
                    .find(".faq_item > .acc_trigger")
                    .removeClass("active");
                jQuery(".faq_group")
                    .not($faqGroup)
                    .find(".faq_item > .acc_container")
                    .slideUp(300);

                // Toggle the clicked FAQ within its own group
                if (jQuery(this).hasClass("active")) {
                    jQuery(this).removeClass("active").next(".acc_container").slideUp(300);
                } else {
                    $faqGroup.find(".faq_item > .acc_trigger").removeClass("active");
                    $faqGroup.find(".faq_item > .acc_container").slideUp(300);
                    jQuery(this).addClass("active").next(".acc_container").slideDown(300);
                }
                return false;
            });
    });

    //-------------------------------------------------------//
    // Faq on HomePage End
    //-------------------------------------------------------//

    //-------------------------------------------------------//
    // Back to Top
    //-------------------------------------------------------//

    // Show/hide button smoothly
    window.addEventListener("scroll", function() {
        const btn = document.querySelector(".backtoptop");
        if (window.scrollY > 300) {
            btn.classList.add("show");
        } else {
            btn.classList.remove("show");
        }
    });

    // Scroll to top smoothly
    document.querySelector(".backtoptop").addEventListener("click", function(e) {
        e.preventDefault();
        window.scrollTo({
            top: 0,
            behavior: "smooth",
        });
    });

    //-------------------------------------------------------//
    // Back to Top
    //-------------------------------------------------------//

    // Init Isotope
    var $grid = jQuery(".grid").isotope({
        itemSelector: ".grid-item",
        layoutMode: "masonry",
        percentPosition: true,
        masonry: {
            columnWidth: ".grid-item", // match the item width
        },
    });

    // Filter items on button click
    jQuery(".filter-buttons").on("click", ".filter-button", function() {
        var filterValue = jQuery(this).attr("data-filter");
        $grid.isotope({ filter: filterValue });

        // Change active class
        jQuery(".filter-buttons .filter-button").removeClass("is-checked");
        jQuery(this).addClass("is-checked");
    });





});

//-------------------------------------------------------//
// Equal height
//-------------------------------------------------------//

jQuery(function() {
    jQuery(".bannerslider .swiper-slide").matchHeight();
    jQuery(".payloadbx").matchHeight();
    jQuery("section.serSec1 .serItem").matchHeight();
});

//-------------------------------------------------------//
// Equal height end
//-------------------------------------------------------//

Fancybox.bind("[data-fancybox]", {
    Carousel: {
        Thumbs: false,
        Toolbar: {
            display: {
                left: [],
                middle: [],
                right: ["close"],
            },
        },
        Zoomable: {
            Panzoom: {
                maxScale: "cover",
                panMode: "mousemove",
                mouseMoveFactor: 1.1,
            },
        },
    },
});



function setSubmitHeight() {
    var emailHeight = jQuery(".mainft .ft-top .ft-row .ftbx .emailcontainer input[type=email]").outerHeight();
    jQuery(".mainft .ft-top .ft-row .ftbx .emailcontainer input[type=submit]").css("height", emailHeight + "px");
}

setSubmitHeight(); // run on load

jQuery(window).on("resize", function() {
    setSubmitHeight(); // run on resize
});