jQuery(function ($) {
  var $btn = $('#load_more');
  if (!$btn.length) return;

  var $container = $('#gallery-container');
  var postId = $container.data('postid');
  var perPage = parseInt(gallery_ajax.per_page, 10) || 6;

  $btn.on('click', function (e) {
    e.preventDefault();

    var offset = parseInt($btn.attr('data-offset') || 0, 10);

    $btn.prop('disabled', true).addClass('is-loading').text('Loading…');

    $.post(gallery_ajax.ajax_url, {
      action: 'load_more_gallery',
      nonce: gallery_ajax.nonce,
      post_id: postId,
      offset: offset,
      per_page: perPage
    })
      .done(function (resp) {
        if (!resp || !resp.success || !resp.data || !resp.data.html) {
          $btn.hide();
          return;
        }

        var $items = $(resp.data.html);

        // If using Isotope, append via Isotope
        var iso = $container.data('isotope');
        if (iso && typeof $container.isotope === 'function') {
          $container.append($items).isotope('appended', $items).isotope('layout');
        } else {
          $container.append($items);
        }

        // Re-bind Fancybox if present
        if (window.Fancybox && typeof Fancybox.bind === 'function') {
          Fancybox.bind('[data-fancybox="gallery"]', {});
        } else if ($.fancybox) {
          $('[data-fancybox="gallery"]').fancybox();
        }

        // Update offset & button state
        $btn.attr('data-offset', resp.data.next_offset);

        if (!resp.data.has_more) {
          $btn.hide();
        } else {
          $btn.prop('disabled', false).removeClass('is-loading').text('Load More');
        }
      })
      .fail(function () {
        $btn.prop('disabled', false).removeClass('is-loading').text('Load More');
        alert('Could not load more items.');
      });
  });
});
