<?php /* Template Name: About */
get_header();
 ?>

<!-- ! Main ! -->
<section class="innerBanner">
    <?php $commonbannerimg = get_field('banner_image');
    if (!empty($commonbannerimg)) {
        $alt_text = !empty($commonbannerimg['alt']) ? $commonbannerimg['alt'] : $commonbannerimg['title']; ?>
        <img src="<?php echo esc_url($commonbannerimg['url']); ?>" class="banner-img" alt="<?php echo esc_attr($alt_text); ?>">
    <?php } else { ?>
        <img class="banner-img" src="<?php echo get_template_directory_uri(); ?>/images/inner_banner_abt.png" alt="banner-img">
    <?php } ?>
    <div class="bannerTxt aos-init aos-animate" data-aos="fade-up">
        <div class="container">
            <div class="row">
                <div class="col-md-8 m-auto">
                    <h1><?php the_title(); ?></h1>
                    <div class="breadCrumb">
                        <ul>
                            <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                            <li><?php the_title(); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php if(get_field('building_structure_heading') || get_field('building_structure_content')){ ?>
<section class="about-us otherPg1 sectiondefaultspacing">
    <div class="container">
        <div class="row align-items-md-center">
            <div class="col-md-6">
                <div class="text ">
                    <?php if(get_field('building_structure_heading')){ ?>
                    <h2 class="otherAdjust"><?php echo get_field('building_structure_heading'); ?></h2><?php } ?>
                    <?php if(get_field('building_structure_content')){ ?>
                    <p><?php echo get_field('building_structure_content'); ?></p><?php } ?>
                    <?php $contbutn = get_field('building_structure_contact_link');
                        if ($contbutn):
                            $link_url = $contbutn['url'];
                            $link_title = $contbutn['title'];
                            $link_target = $contbutn['target'] ? $contbutn['target'] : '_self'; ?>
                    <a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="btn"><?php echo esc_html($link_title); ?></a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-6">
                <?php $abtusimage = get_field('building_structure_image');
                if (!empty($abtusimage)) {
                    $alt_text = !empty($abtusimage['alt']) ? $abtusimage['alt'] : $abtusimage['title']; ?>
                <div class="img">
                    <img src="<?php echo esc_url($abtusimage['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                </div><?php } ?>
            </div>
        </div>
    </div>
</section>
<?php } ?>
<?php $i = 1;
$misvislist = get_field('abt_mission_vision_repeater');
if ($misvislist) { ?>
<section class="abtSec2">
    <div class="container">
        <div class="row">
            <?php foreach ($misvislist as $misvislistitem) { ?>
            <div class="col-md-6 <?php if($i==1){ echo 'bg_txt'; } else { echo 'otherPadding'; } ?>">
                <div class="grp_txt_mid">
                    <h3><?php echo $misvislistitem['abt_mission_vision_text']; ?></h3>
                    <p><?php echo $misvislistitem['abt_mission_vision_content']; ?></p>
                </div>
            </div>
            <?php $i++; } ?>
        </div>
    </div>
</section>
<?php } ?>
<section class="abtSec3 sectiondefaultspacing pb-0">
    <?php $newhouseimg = get_field('about_new_house_image');
    if (!empty($newhouseimg)) {
        $alt_text = !empty($newhouseimg['alt']) ? $newhouseimg['alt'] : $newhouseimg['title']; ?>
    <img src="<?php echo esc_url($newhouseimg['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>" class="new_house">
    <?php } ?>
    <div class="container">
        <div class="heading_adjust">
            <?php if(get_field('about_section_home_owner_title',7)){ ?>
             <h2><?php echo get_field('about_section_home_owner_title',7); ?></h2><?php } ?>
             <?php if(get_field('about_section_home_owner_content',7)){ ?>
             <p><?php echo get_field('about_section_home_owner_content',7); ?></p><?php } ?>
        </div>
        <div class="iconsrow">
            <?php $abtmodal = get_field('about_modal_list',7);
                    if ($abtmodal) {
                        foreach ($abtmodal as $index => $abtmodalitem){ 
                                 // Get the image (assumed to be ACF image field stored as array)
                            $modalicon = $abtmodalitem['about_modal_icon']; // assuming 'icon_image' is your image field
                                if (!empty($modalicon)) {
                                $alt_text = !empty($modalicon['alt']) ? $modalicon['alt'] : $modalicon['title'];
                                $modal_id = 'details-modal-' . $index; // Unique ID for each modal ?>
            <div class="icons" data-bs-toggle="modal" data-bs-target="#<?php echo esc_attr($modal_id); ?>">
                <div class="iconsinner">
                    <img src="<?php echo esc_url($modalicon['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                </div>
                <h6><?php echo $abtmodalitem['about_modal_icon_text']; ?></h6>
            </div>
            <div class="modal fade details-modal" id="<?php echo esc_attr($modal_id); ?>" tabindex="-1">
                <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-body">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                <h4 class="modal-title" id="exampleModalLabel"><?php echo $abtmodalitem['about_modal_heading']; ?></h4>
                                <p><?php echo $abtmodalitem['about_modal_content']; ?></p>
                            </div>
                        </div>
                    </div>
            </div>
            <?php } } } ?>
        </div>
    </div>
</section>

<section class="gettouch sectiondefaultspacing">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-md-5">
                <div class="text">
                    <?php if(get_field('contact_section_heading',7)){ ?>
                    <h2><?php echo get_field('contact_section_heading',7); ?></h2><?php } ?>
                    <?php if(get_field('contact_section_subheading',7)){ ?>
                    <p><?php echo get_field('contact_section_subheading',7); ?></p><?php } ?>

                    <div class="contacts">
                        <?php $phoneno = get_field('phone_number','option');
                        $tel_number = preg_replace('/\D/', '', $phoneno);
                        if($phoneno){ ?>
                        <div class="contacts-inner">
                            <div class="icon">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/phone-icon.png" alt="Phone Icon">
                            </div>
                            <div class="ic-text">
                                <h6>Call Us</h6>
                                <p>
                                    <a href="tel:<?php echo $tel_number; ?>"><?php echo $phoneno; ?></a>
                                </p>
                            </div>
                        </div><?php } ?>
                        <?php if(get_field('email','option')) { ?>
                        <div class="contacts-inner">
                            <div class="icon">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/mail-icon.png" alt="Email Icon">
                            </div>
                            <div class="ic-text">
                                <h6>Email Us</h6>
                                <p><a href="mailto:<?php echo get_field('email','option'); ?>"><?php echo get_field('email','option'); ?></a>
                                </p>
                            </div>
                        </div><?php } ?>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="formarea">
                    <h3>Contact Us</h3>
                    <?php echo do_shortcode('[contact-form-7 id="eee4220" title="Home Contact Form"]'); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ! Main end ! -->

<?php get_footer(); ?>