<?php /* Template Name: Home */
get_header();
 ?>

<!-- ! Main ! -->
<section class="banner">
	<?php $bannerimg = get_field('home_banner_image');
            if (!empty($bannerimg)) {
                $alt_text = !empty($bannerimg['alt']) ? $bannerimg['alt'] : $bannerimg['title']; ?>
    <img src="<?php echo esc_url($bannerimg['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
    <?php } ?>
    <div class="bannertext">
        <div class="container">
            <div class="row justify-content-end">
                <div class="col-md-6">
                    <div class="bannertext-inner">
                    	<?php if(get_field('home_banner_heading')){ ?>
                        <h1><?php echo get_field('home_banner_heading'); ?></h1><?php } ?>
                        <?php if(get_field('home_banner_content')){ ?>
                        <p><?php echo get_field('home_banner_content'); ?></p><?php } ?>
                        <div class="btnsec">
                        	<?php $buttonone = get_field('home_banner_button_1');
                        if ($buttonone):
                            $link_url = $buttonone['url'];
                            $link_title = $buttonone['title'];
                            $link_target = $buttonone['target'] ? $buttonone['target'] : '_self'; ?>
                            <a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="btn"><?php echo esc_html($link_title); ?></a>
                        	<?php endif; ?>
                        	<?php $buttonsecond = get_field('home_banner_button_2');
                        if ($buttonsecond):
                            $link_url = $buttonsecond['url'];
                            $link_title = $buttonsecond['title'];
                            $link_target = $buttonsecond['target'] ? $buttonsecond['target'] : '_self'; ?>
                            <a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="btn withborder"><?php echo esc_html($link_title); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php if(get_field('short_process_heading') || get_field('short_process_step')){ ?>
<section class="shortprocess sectiondefaultspacing">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-lg-7 col-md-6">
            	<?php $processimg = get_field('short_process_image');
            if (!empty($processimg)) {
                $alt_text = !empty($processimg['alt']) ? $processimg['alt'] : $processimg['title']; ?>
                <div class="img">
                    <img src="<?php echo esc_url($processimg['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                </div><?php } ?>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="text">
                    <?php if(get_field('short_process_heading')){ ?>
                    <h2><?php echo get_field('short_process_heading'); ?></h2>
                	<?php } ?>
                    <ul>
                    	<?php $processstep = get_field('short_process_step');
                        if ($processstep) {
                            foreach ($processstep as $processsitem) { ?>
                        <li>
                            <h6><?php echo $processsitem['short_process_step_title']; ?></h6>
                            <h4><?php echo $processsitem['short_process_step_content']; ?></h4>
                        </li>
                    <?php } } ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<?php } ?>
<section class="about-us sectiondefaultspacing">
    <div class="container">
        <div class="row align-items-end">
            <div class="col-md-6">
                <div class="text">
                	<?php if(get_field('about_section_heading')){ ?>
                    <h2><?php echo get_field('about_section_heading'); ?></h2><?php } ?>
                    <div class="storymissonrow">
                    	<?php $storymission = get_field('about_feature_list');
                        if ($storymission) {
                            foreach ($storymission as $storymissionitem) { ?>
                        <div class="storymissoninner">
                            <h4><?php echo $storymissionitem['about_feature_heading']; ?></h4>
                            <p><?php echo $storymissionitem['about_feature_text']; ?></p>
                        </div>
                    <?php } } ?>
                    </div>
                    <div class="homeownership">
                    	<?php if(get_field('about_section_home_owner_title')){ ?>
                        <h4><?php echo get_field('about_section_home_owner_title'); ?></h4><?php } ?>
                        <?php if(get_field('about_section_home_owner_content')){ ?>
                        <p><?php echo get_field('about_section_home_owner_content'); ?></p><?php } ?>
                    </div>
                    <div class="iconsrow">
                    	<?php $abtmodal = get_field('about_modal_list');
                        if ($abtmodal) {
                            foreach ($abtmodal as $index => $abtmodalitem){ 
                            	 // Get the image (assumed to be ACF image field stored as array)
                                $modalicon = $abtmodalitem['about_modal_icon']; // assuming 'icon_image' is your image field
                                if (!empty($modalicon)) {
                                    $alt_text = !empty($modalicon['alt']) ? $modalicon['alt'] : $modalicon['title'];
                                    $modal_id = 'details-modal-' . $index; // Unique ID for each modal ?>
                        <div class="icons" data-bs-toggle="modal" data-bs-target="#<?php echo esc_attr($modal_id); ?>">
                            <div class="iconsinner">
                                <img src="<?php echo esc_url($modalicon['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                            </div>
                            <h6><?php echo $abtmodalitem['about_modal_icon_text']; ?></h6>
                        </div>

                        <div class="modal fade details-modal" id="<?php echo esc_attr($modal_id); ?>" tabindex="-1">
					        <div class="modal-dialog modal-dialog-centered">
					            <div class="modal-content">
					                <div class="modal-body">
					                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					                    <h4 class="modal-title" id="exampleModalLabel"><?php echo $abtmodalitem['about_modal_heading']; ?></h4>
					                    <p><?php echo $abtmodalitem['about_modal_content']; ?></p>
					                </div>
					            </div>
					        </div>
    					</div>
                    	<?php } } } ?>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
            	<?php $homeownerimg = get_field('about_section_image');
            if (!empty($homeownerimg)) {
                $alt_text = !empty($homeownerimg['alt']) ? $homeownerimg['alt'] : $homeownerimg['title']; ?>
                <div class="img">
                    <img src="<?php echo esc_url($homeownerimg['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                </div>
            <?php } ?>
            </div>
        </div>
    </div>
</section>

<section class="gettouch sectiondefaultspacing">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-md-5">
                <div class="text">
                	<?php if(get_field('contact_section_heading')){ ?>
                    <h2><?php echo get_field('contact_section_heading'); ?></h2><?php } ?>
                    <?php if(get_field('contact_section_subheading')){ ?>
                    <p><?php echo get_field('contact_section_subheading'); ?></p><?php } ?>

                    <div class="contacts">
                    	<?php $phoneno = get_field('phone_number','option');
                    	$tel_number = preg_replace('/\D/', '', $phoneno);
                    	if($phoneno){ ?>
                        <div class="contacts-inner">
                            <div class="icon">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/phone-icon.png" alt="Phone Icon">
                            </div>
                            <div class="ic-text">
                                <h6>Call Us</h6>
                                <p>
                                    <a href="tel:<?php echo $tel_number; ?>"><?php echo $phoneno; ?></a>
                                </p>
                            </div>
                        </div><?php } ?>
                        <?php if(get_field('email','option')) { ?>
                        <div class="contacts-inner">
                            <div class="icon">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/mail-icon.png" alt="Email Icon">
                            </div>
                            <div class="ic-text">
                                <h6>Email Us</h6>
                                <p><a href="mailto:<?php echo get_field('email','option'); ?>"><?php echo get_field('email','option'); ?></a></p>
                            </div>
                        </div>
                    <?php } ?>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="formarea">
                    <h3>Contact Us</h3>
                    <?php echo do_shortcode('[contact-form-7 id="eee4220" title="Home Contact Form"]'); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ! Main end ! -->


<?php get_footer(); ?>