<?php /* Template Name: Our Work */
get_header();
 ?>

<!-- ! Main ! -->
<section class="innerBanner">
   <?php $commonbannerimg = get_field('banner_image');
    if (!empty($commonbannerimg)) {
        $alt_text = !empty($commonbannerimg['alt']) ? $commonbannerimg['alt'] : $commonbannerimg['title']; ?>
        <img src="<?php echo esc_url($commonbannerimg['url']); ?>" class="banner-img" alt="<?php echo esc_attr($alt_text); ?>">
    <?php } else { ?>
        <img class="banner-img" src="<?php echo get_template_directory_uri(); ?>/images/inner_banner_abt.png" alt="banner-img">
    <?php } ?>
    <div class="bannerTxt aos-init aos-animate" data-aos="fade-up">
        <div class="container">
            <div class="row">
                <div class="col-md-8 m-auto">
                    <h1><?php the_title(); ?></h1>
                    <div class="breadCrumb">
                        <ul>
                            <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                            <li><?php the_title(); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php if(get_field('our_work_content') || get_field('our_work_image')){ ?>
<section class="about-us otherPg1 hw_wrk_sec1 sectiondefaultspacing pb-0">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="text">
                    <?php if(get_field('our_work_heading')){ ?>
                    <h2 class="otherAdjust"><?php echo get_field('our_work_heading'); ?></h2><?php } ?>
                    <?php if(get_field('our_work_content')){ ?>
                    <p><?php echo get_field('our_work_content'); ?></p><?php } ?>
                    <?php $buttonone = get_field('home_banner_button_1',7);
                        if ($buttonone):
                            $link_url = $buttonone['url'];
                            $link_title = $buttonone['title'];
                            $link_target = $buttonone['target'] ? $buttonone['target'] : '_self'; ?>
                            <a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="btn"><?php echo esc_html($link_title); ?></a>
                            <?php endif; ?>
                </div>
            </div>
            <div class="col-md-6">
                <?php $ourwkimg = get_field('our_work_image');
                if (!empty($ourwkimg)) {
                    $alt_text = !empty($ourwkimg['alt']) ? $ourwkimg['alt'] : $ourwkimg['title']; ?>
                <div class="img">
                    <img src="<?php echo esc_url($ourwkimg['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                </div><?php } ?>
            </div>
        </div>
    </div>
</section>
<?php } ?>
<!-- to be commented until client send pictures -->
<!-- <?php if( have_rows('gallery_items') ): ?>
<section class="ourWrkSec2 sectiondefaultspacing">
    <div class="container">
        <div class="headingAdjustFlex">
            <?php $gallery_heading = get_field('gallery_heading'); ?>
            <h2><?php echo $gallery_heading ? esc_html($gallery_heading) : 'Gallery'; ?></h2>

            <?php
            // Collect unique categories
            $categories = array();
            while( have_rows('gallery_items') ): the_row();
                $category = get_sub_field('gallery_category');
                if( $category && !in_array($category, $categories) ){
                    $categories[] = $category;
                }
            endwhile;
            reset_rows();
            ?>
            <div class="filter-buttons">
                <a href="#?" class="filter-button is-checked" data-filter="*">All</a>
                <?php foreach( $categories as $cat ): ?>
                    <a href="#?" class="filter-button" data-filter=".<?php echo esc_attr( sanitize_title($cat) ); ?>">
                        <?php echo esc_html($cat); ?>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="row grid" id="gallery-container">
            <?php
            $count = 0;
            $limit = 6; // Show only 6 items initially
            while( have_rows('gallery_items') ): the_row();
                if( $count >= $limit ) break;
                $image = get_sub_field('gallery_image');
                $category = get_sub_field('gallery_category');
                $cat_class = sanitize_title($category);
                $gallery_column = get_sub_field('gallery_column');
                $column_class = ($gallery_column == 'Col-2') ? 'col-md-6 col-sm-12' : 'col-md-3 col-sm-6'; ?>
                
                <div class="<?php echo esc_attr($column_class); ?> grid-item <?php echo esc_attr($cat_class); ?>">
                    <div class="eachGallary">
                        <a data-fancybox="gallery" data-src="<?php echo esc_url($image['url']); ?>">
                            <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>">
                        </a>
                    </div>
                </div>
            <?php $count++; endwhile; ?>
        </div>

        <?php if( $count < count(get_field('gallery_items')) ): ?>
            <div class="bottom_btn">
                <a href="#?" class="btn" id="load_more" data-offset="<?php echo esc_attr($count); ?>">Load More</a>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php endif; ?> -->



<?php
$rows = get_field('gallery_items'); // array of all repeater rows
$per_page = 6;                      // items per click
$total    = is_array($rows) ? count($rows) : 0;

// Collect unique categories
$categories = [];
if ($rows) {
    foreach ($rows as $r) {
        $c = isset($r['gallery_category']) ? $r['gallery_category'] : '';
        if ($c && !in_array($c, $categories, true)) $categories[] = $c;
    }
}
?>

<?php if ( $rows ) : ?>
<section class="ourWrkSec2 sectiondefaultspacing">
    <div class="container">
        <div class="headingAdjustFlex">
            <?php $gallery_heading = get_field('gallery_heading'); ?>
            <h2><?php echo $gallery_heading ? esc_html($gallery_heading) : 'Gallery'; ?></h2>

            <div class="filter-buttons">
                <a href="#?" class="filter-button is-checked" data-filter="*">All</a>
                <?php foreach ( $categories as $cat ): ?>
                    <a href="#?" class="filter-button" data-filter=".<?php echo esc_attr( sanitize_title($cat) ); ?>">
                        <?php echo esc_html($cat); ?>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="row grid" id="gallery-container" data-postid="<?php echo esc_attr( get_the_ID() ); ?>">
            <?php
            // Initial slice
            foreach ( array_slice($rows, 0, $per_page) as $row ):
                $image          = isset($row['gallery_image']) ? $row['gallery_image'] : null;
                $category       = isset($row['gallery_category']) ? $row['gallery_category'] : '';
                $cat_class      = sanitize_title($category);
                $gallery_column = isset($row['gallery_column']) ? $row['gallery_column'] : '';
                $column_class   = ($gallery_column === 'Col-2') ? 'col-md-6 col-sm-12' : 'col-md-3 col-sm-6';

                if ( $image && is_array($image) ):
                    $url = esc_url($image['url']);
                    $alt = esc_attr( !empty($image['alt']) ? $image['alt'] : 'Gallery image' );
            ?>
                <div class="<?php echo esc_attr($column_class); ?> grid-item <?php echo esc_attr($cat_class); ?>">
                    <div class="eachGallary">
                        <a data-fancybox="gallery" data-src="<?php echo $url; ?>">
                            <img src="<?php echo $url; ?>" alt="<?php echo $alt; ?>">
                        </a>
                    </div>
                </div>
            <?php
                endif;
            endforeach;
            ?>
        </div>

        <?php if ( $total > $per_page ) : ?>
            <div class="bottom_btn">
                <a href="#?" class="btn" id="load_more" data-offset="<?php echo esc_attr($per_page); ?>">Load More</a>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php endif; ?>


<!-- to be commented until client send pictures -->

<section class="gettouch sectiondefaultspacing">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-md-5">
                <div class="text">
                    <?php if(get_field('contact_section_heading',7)){ ?>
                    <h2><?php echo get_field('contact_section_heading',7); ?></h2><?php } ?>
                    <?php if(get_field('contact_section_subheading',7)){ ?>
                    <p><?php echo get_field('contact_section_subheading',7); ?></p><?php } ?>

                    <div class="contacts">
                        <?php $phoneno = get_field('phone_number','option');
                        $tel_number = preg_replace('/\D/', '', $phoneno);
                        if($phoneno){ ?>
                        <div class="contacts-inner">
                            <div class="icon">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/phone-icon.png" alt="">
                            </div>
                            <div class="ic-text">
                                <h6>Call Us</h6>
                                <p>
                                   <a href="tel:<?php echo $tel_number; ?>"><?php echo $phoneno; ?></a>
                                </p>
                            </div>
                        </div><?php } ?>
                        <?php if(get_field('email','option')) { ?>
                        <div class="contacts-inner">
                            <div class="icon">
                                <img src="<?php echo get_template_directory_uri(); ?>/images/mail-icon.png" alt="">
                            </div>
                            <div class="ic-text">
                                <h6>Email Us</h6>
                                <p><a href="mailto:<?php echo get_field('email','option'); ?>"><?php echo get_field('email','option'); ?></a></p>
                            </div>
                        </div><?php } ?>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="formarea">
                    <h3>Contact Us</h3>
                    <?php echo do_shortcode('[contact-form-7 id="eee4220" title="Home Contact Form"]'); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ! Main end ! -->

<?php get_footer(); ?>