/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-09-10 13:12:42 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wpvv_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=3997 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=18345 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=2143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_redirection_404` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext NOT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `agent` varchar(255) DEFAULT NULL,
  `referrer` varchar(255) DEFAULT NULL,
  `http_code` int(11) unsigned NOT NULL DEFAULT 0,
  `request_method` varchar(10) DEFAULT NULL,
  `request_data` mediumtext DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `referrer` (`referrer`(191)),
  KEY `ip` (`ip`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_redirection_groups` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `tracking` int(11) NOT NULL DEFAULT 1,
  `module_id` int(11) unsigned NOT NULL DEFAULT 0,
  `status` enum('enabled','disabled') NOT NULL DEFAULT 'enabled',
  `position` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `module_id` (`module_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_redirection_items` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `url` mediumtext NOT NULL,
  `match_url` varchar(2000) DEFAULT NULL,
  `match_data` text DEFAULT NULL,
  `regex` int(11) unsigned NOT NULL DEFAULT 0,
  `position` int(11) unsigned NOT NULL DEFAULT 0,
  `last_count` int(10) unsigned NOT NULL DEFAULT 0,
  `last_access` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `group_id` int(11) NOT NULL DEFAULT 0,
  `status` enum('enabled','disabled') NOT NULL DEFAULT 'enabled',
  `action_type` varchar(20) NOT NULL,
  `action_code` int(11) unsigned NOT NULL,
  `action_data` mediumtext DEFAULT NULL,
  `match_type` varchar(20) NOT NULL,
  `title` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `status` (`status`),
  KEY `regex` (`regex`),
  KEY `group_idpos` (`group_id`,`position`),
  KEY `group` (`group_id`),
  KEY `match_url` (`match_url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_redirection_logs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext NOT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `sent_to` mediumtext DEFAULT NULL,
  `agent` mediumtext DEFAULT NULL,
  `referrer` mediumtext DEFAULT NULL,
  `http_code` int(11) unsigned NOT NULL DEFAULT 0,
  `request_method` varchar(10) DEFAULT NULL,
  `request_data` mediumtext DEFAULT NULL,
  `redirect_by` varchar(50) DEFAULT NULL,
  `redirection_id` int(11) unsigned DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `redirection_id` (`redirection_id`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=117 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext DEFAULT NULL,
  `permalink_hash` varchar(40) DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) NOT NULL,
  `object_sub_type` varchar(32) DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `breadcrumb_title` text DEFAULT NULL,
  `post_status` varchar(20) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext DEFAULT NULL,
  `primary_focus_keyword` varchar(191) DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text DEFAULT NULL,
  `twitter_image` longtext DEFAULT NULL,
  `twitter_description` longtext DEFAULT NULL,
  `twitter_image_id` varchar(191) DEFAULT NULL,
  `twitter_image_source` text DEFAULT NULL,
  `open_graph_title` text DEFAULT NULL,
  `open_graph_description` longtext DEFAULT NULL,
  `open_graph_image` longtext DEFAULT NULL,
  `open_graph_image_id` varchar(191) DEFAULT NULL,
  `open_graph_image_source` text DEFAULT NULL,
  `open_graph_image_meta` mediumtext DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `schema_page_type` varchar(64) DEFAULT NULL,
  `schema_article_type` varchar(64) DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT 1,
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wpvv_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpvv_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=356 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wpvv_comments */
INSERT INTO `wpvv_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2025-08-14 07:06:05", "2025-08-14 07:06:05", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.", "0", "post-trashed", "", "comment", "0", "0");

/* INSERT TABLE DATA: wpvv_duplicator_packages */
INSERT INTO `wpvv_duplicator_packages` VALUES("1", "20250910_mpacs", "c4745ddedcfdd7853358_20250910131231", "20", "2025-09-10 13:12:42", "michael-marshall", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-09-10 13:12:31\";s:7:\"Version\";s:8:\"1.5.13.2\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:8:\"10.11.14\";s:10:\"VersionPHP\";s:6:\"8.1.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:14:\"20250910_mpacs\";s:4:\"Hash\";s:35:\"c4745ddedcfdd7853358_20250910131231\";s:8:\"NameHash\";s:50:\"20250910_mpacs_c4745ddedcfdd7853358_20250910131231\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:60:\"20250910_mpacs_c4745ddedcfdd7853358_20250910131231_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.7\";s:6:\"WPUser\";s:16:\"michael-marshall\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:62:\"20250910_mpacs_c4745ddedcfdd7853358_20250910131231_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:36:\"/home2/apgcjfqb/public_html/wp-mpacs\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1911;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:10448;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-09-10 13:12:31\";s:7:\"Version\";s:8:\"1.5.13.2\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:8:\"10.11.14\";s:10:\"VersionPHP\";s:6:\"8.1.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:14:\"20250910_mpacs\";s:4:\"Hash\";s:35:\"c4745ddedcfdd7853358_20250910131231\";s:8:\"NameHash\";s:50:\"20250910_mpacs_c4745ddedcfdd7853358_20250910131231\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:68:\"20250910_mpacs_c4745ddedcfdd7853358_20250910131231_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:50:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:63:\"20250910_mpacs_c4745ddedcfdd7853358_20250910131231_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:132:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/backups-dup-lite/tmp/20250910_mpacs_c4745ddedcfdd7853358_20250910131231_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:45:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-admin\";i:1;s:48:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-includes\";i:2;s:57:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:36:\"/home2/apgcjfqb/public_html/wp-mpacs\";i:1;s:36:\"/home2/apgcjfqb/public_html/wp-mpacs\";i:2;s:47:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content\";i:3;s:55:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/uploads\";i:4;s:55:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins\";i:5;s:58:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/mu-plugins\";i:6;s:54:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:68:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wpvv_options */
INSERT INTO `wpvv_options` VALUES("1", "cron", "a:16:{i:1757513165;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1757531165;a:3:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757531204;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757570842;a:1:{s:27:\"acf_update_site_health_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1757574365;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757574404;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757574406;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757574489;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1757574528;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757577346;a:0:{}i:1757585969;a:1:{s:22:\"redirection_log_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757587833;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757660765;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1757944800;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1758141512;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wpvv_options` VALUES("2", "siteurl", "https://fm-connect1.fortmindz.in/wp-mpacs", "on");
INSERT INTO `wpvv_options` VALUES("3", "home", "https://fm-connect1.fortmindz.in/wp-mpacs", "on");
INSERT INTO `wpvv_options` VALUES("4", "blogname", "MPACS", "on");
INSERT INTO `wpvv_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wpvv_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wpvv_options` VALUES("7", "admin_email", "support@mpacstherapy.com", "on");
INSERT INTO `wpvv_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wpvv_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wpvv_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wpvv_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wpvv_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wpvv_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wpvv_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wpvv_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wpvv_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wpvv_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wpvv_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wpvv_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wpvv_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wpvv_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wpvv_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wpvv_options` VALUES("23", "posts_per_page", "9", "on");
INSERT INTO `wpvv_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wpvv_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wpvv_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wpvv_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wpvv_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wpvv_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wpvv_options` VALUES("30", "rewrite_rules", "a:133:{s:22:\"meet-our-clinicians/?$\";s:24:\"index.php?post_type=team\";s:39:\"meet-our-clinicians/page/([0-9]{1,})/?$\";s:42:\"index.php?post_type=team&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"podcast/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"podcast/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"podcast/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"podcast/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"podcast/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"podcast/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"podcast/(.+?)/embed/?$\";s:40:\"index.php?podcast=$matches[1]&embed=true\";s:26:\"podcast/(.+?)/trackback/?$\";s:34:\"index.php?podcast=$matches[1]&tb=1\";s:34:\"podcast/(.+?)/page/?([0-9]{1,})/?$\";s:47:\"index.php?podcast=$matches[1]&paged=$matches[2]\";s:41:\"podcast/(.+?)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?podcast=$matches[1]&cpage=$matches[2]\";s:30:\"podcast/(.+?)(?:/([0-9]+))?/?$\";s:46:\"index.php?podcast=$matches[1]&page=$matches[2]\";s:30:\"team/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"team/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"team/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"team/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"team/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"team/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:19:\"team/(.+?)/embed/?$\";s:37:\"index.php?team=$matches[1]&embed=true\";s:23:\"team/(.+?)/trackback/?$\";s:31:\"index.php?team=$matches[1]&tb=1\";s:31:\"team/(.+?)/page/?([0-9]{1,})/?$\";s:44:\"index.php?team=$matches[1]&paged=$matches[2]\";s:38:\"team/(.+?)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?team=$matches[1]&cpage=$matches[2]\";s:27:\"team/(.+?)(?:/([0-9]+))?/?$\";s:43:\"index.php?team=$matches[1]&page=$matches[2]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=8&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `wpvv_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wpvv_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wpvv_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wpvv_options` VALUES("34", "active_plugins", "a:9:{i:0;s:34:\"advanced-custom-fields-pro/acf.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:31:\"elementor-pro/elementor-pro.php\";i:4;s:23:\"elementor/elementor.php\";i:5;s:21:\"megamenu/megamenu.php\";i:6;s:27:\"redirection/redirection.php\";i:7;s:27:\"svg-support/svg-support.php\";i:8;s:24:\"wordpress-seo/wp-seo.php\";}", "on");
INSERT INTO `wpvv_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wpvv_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `wpvv_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wpvv_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wpvv_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wpvv_options` VALUES("40", "recently_edited", "a:4:{i:0;s:90:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins/advanced-custom-fields-pro/acf.php\";i:1;s:93:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/themes/hello-theme-child-master/functions.php\";i:2;s:89:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/themes/hello-theme-child-master/style.css\";i:3;s:0:\"\";}", "off");
INSERT INTO `wpvv_options` VALUES("41", "template", "hello-elementor", "on");
INSERT INTO `wpvv_options` VALUES("42", "stylesheet", "hello-theme-child-master", "on");
INSERT INTO `wpvv_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wpvv_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wpvv_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wpvv_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wpvv_options` VALUES("47", "db_version", "60421", "on");
INSERT INTO `wpvv_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wpvv_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wpvv_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wpvv_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wpvv_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wpvv_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wpvv_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wpvv_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wpvv_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wpvv_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wpvv_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wpvv_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wpvv_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wpvv_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wpvv_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wpvv_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wpvv_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wpvv_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wpvv_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wpvv_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wpvv_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wpvv_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wpvv_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wpvv_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wpvv_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wpvv_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wpvv_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wpvv_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wpvv_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wpvv_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("80", "uninstall_plugins", "a:7:{s:21:\"backuply/backuply.php\";s:21:\"backuply_deactivation\";s:23:\"loginizer/loginizer.php\";s:22:\"loginizer_deactivation\";s:19:\"siteseo/siteseo.php\";s:27:\"\\SiteSEO\\Install::uninstall\";s:27:\"speedycache/speedycache.php\";s:31:\"\\SpeedyCache\\Install::uninstall\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";s:27:\"redirection/redirection.php\";a:2:{i:0;s:17:\"Redirection_Admin\";i:1;s:16:\"plugin_uninstall\";}}", "off");
INSERT INTO `wpvv_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wpvv_options` VALUES("82", "page_for_posts", "678", "on");
INSERT INTO `wpvv_options` VALUES("83", "page_on_front", "8", "on");
INSERT INTO `wpvv_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wpvv_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wpvv_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wpvv_options` VALUES("87", "site_icon", "20", "on");
INSERT INTO `wpvv_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wpvv_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wpvv_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wpvv_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wpvv_options` VALUES("92", "admin_email_lifespan", "1770707165", "on");
INSERT INTO `wpvv_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wpvv_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wpvv_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wpvv_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wpvv_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wpvv_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wpvv_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wpvv_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wpvv_options` VALUES("101", "initial_db_version", "60421", "on");
INSERT INTO `wpvv_options` VALUES("102", "wpvv_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:70:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:14:\"siteseo_manage\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "on");
INSERT INTO `wpvv_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wpvv_options` VALUES("104", "user_count", "1", "off");
INSERT INTO `wpvv_options` VALUES("105", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("106", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:9:\"mega-menu\";a:3:{i:0;s:19:\"elementor-library-2\";i:1;s:13:\"custom_html-2\";i:2;s:13:\"custom_html-3\";}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wpvv_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("120", "widget_custom_html", "a:3:{i:2;a:5:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:30:\"[elementor-template id=\"1471\"]\";s:17:\"mega_menu_columns\";i:6;s:24:\"mega_menu_parent_menu_id\";i:819;s:15:\"mega_menu_order\";a:1:{i:819;i:2;}}i:3;a:5:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:30:\"[elementor-template id=\"1557\"]\";s:17:\"mega_menu_columns\";i:6;s:24:\"mega_menu_parent_menu_id\";i:15;s:15:\"mega_menu_order\";a:1:{i:15;i:5;}}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("121", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wpvv_options` VALUES("122", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1755155483;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wpvv_options` VALUES("123", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.8.2\";s:5:\"files\";a:536:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:26:\"post-content/style-rtl.css\";i:309;s:30:\"post-content/style-rtl.min.css\";i:310;s:22:\"post-content/style.css\";i:311;s:26:\"post-content/style.min.css\";i:312;s:23:\"post-date/style-rtl.css\";i:313;s:27:\"post-date/style-rtl.min.css\";i:314;s:19:\"post-date/style.css\";i:315;s:23:\"post-date/style.min.css\";i:316;s:27:\"post-excerpt/editor-rtl.css\";i:317;s:31:\"post-excerpt/editor-rtl.min.css\";i:318;s:23:\"post-excerpt/editor.css\";i:319;s:27:\"post-excerpt/editor.min.css\";i:320;s:26:\"post-excerpt/style-rtl.css\";i:321;s:30:\"post-excerpt/style-rtl.min.css\";i:322;s:22:\"post-excerpt/style.css\";i:323;s:26:\"post-excerpt/style.min.css\";i:324;s:34:\"post-featured-image/editor-rtl.css\";i:325;s:38:\"post-featured-image/editor-rtl.min.css\";i:326;s:30:\"post-featured-image/editor.css\";i:327;s:34:\"post-featured-image/editor.min.css\";i:328;s:33:\"post-featured-image/style-rtl.css\";i:329;s:37:\"post-featured-image/style-rtl.min.css\";i:330;s:29:\"post-featured-image/style.css\";i:331;s:33:\"post-featured-image/style.min.css\";i:332;s:34:\"post-navigation-link/style-rtl.css\";i:333;s:38:\"post-navigation-link/style-rtl.min.css\";i:334;s:30:\"post-navigation-link/style.css\";i:335;s:34:\"post-navigation-link/style.min.css\";i:336;s:27:\"post-template/style-rtl.css\";i:337;s:31:\"post-template/style-rtl.min.css\";i:338;s:23:\"post-template/style.css\";i:339;s:27:\"post-template/style.min.css\";i:340;s:24:\"post-terms/style-rtl.css\";i:341;s:28:\"post-terms/style-rtl.min.css\";i:342;s:20:\"post-terms/style.css\";i:343;s:24:\"post-terms/style.min.css\";i:344;s:24:\"post-title/style-rtl.css\";i:345;s:28:\"post-title/style-rtl.min.css\";i:346;s:20:\"post-title/style.css\";i:347;s:24:\"post-title/style.min.css\";i:348;s:26:\"preformatted/style-rtl.css\";i:349;s:30:\"preformatted/style-rtl.min.css\";i:350;s:22:\"preformatted/style.css\";i:351;s:26:\"preformatted/style.min.css\";i:352;s:24:\"pullquote/editor-rtl.css\";i:353;s:28:\"pullquote/editor-rtl.min.css\";i:354;s:20:\"pullquote/editor.css\";i:355;s:24:\"pullquote/editor.min.css\";i:356;s:23:\"pullquote/style-rtl.css\";i:357;s:27:\"pullquote/style-rtl.min.css\";i:358;s:19:\"pullquote/style.css\";i:359;s:23:\"pullquote/style.min.css\";i:360;s:23:\"pullquote/theme-rtl.css\";i:361;s:27:\"pullquote/theme-rtl.min.css\";i:362;s:19:\"pullquote/theme.css\";i:363;s:23:\"pullquote/theme.min.css\";i:364;s:39:\"query-pagination-numbers/editor-rtl.css\";i:365;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:366;s:35:\"query-pagination-numbers/editor.css\";i:367;s:39:\"query-pagination-numbers/editor.min.css\";i:368;s:31:\"query-pagination/editor-rtl.css\";i:369;s:35:\"query-pagination/editor-rtl.min.css\";i:370;s:27:\"query-pagination/editor.css\";i:371;s:31:\"query-pagination/editor.min.css\";i:372;s:30:\"query-pagination/style-rtl.css\";i:373;s:34:\"query-pagination/style-rtl.min.css\";i:374;s:26:\"query-pagination/style.css\";i:375;s:30:\"query-pagination/style.min.css\";i:376;s:25:\"query-title/style-rtl.css\";i:377;s:29:\"query-title/style-rtl.min.css\";i:378;s:21:\"query-title/style.css\";i:379;s:25:\"query-title/style.min.css\";i:380;s:25:\"query-total/style-rtl.css\";i:381;s:29:\"query-total/style-rtl.min.css\";i:382;s:21:\"query-total/style.css\";i:383;s:25:\"query-total/style.min.css\";i:384;s:20:\"query/editor-rtl.css\";i:385;s:24:\"query/editor-rtl.min.css\";i:386;s:16:\"query/editor.css\";i:387;s:20:\"query/editor.min.css\";i:388;s:19:\"quote/style-rtl.css\";i:389;s:23:\"quote/style-rtl.min.css\";i:390;s:15:\"quote/style.css\";i:391;s:19:\"quote/style.min.css\";i:392;s:19:\"quote/theme-rtl.css\";i:393;s:23:\"quote/theme-rtl.min.css\";i:394;s:15:\"quote/theme.css\";i:395;s:19:\"quote/theme.min.css\";i:396;s:23:\"read-more/style-rtl.css\";i:397;s:27:\"read-more/style-rtl.min.css\";i:398;s:19:\"read-more/style.css\";i:399;s:23:\"read-more/style.min.css\";i:400;s:18:\"rss/editor-rtl.css\";i:401;s:22:\"rss/editor-rtl.min.css\";i:402;s:14:\"rss/editor.css\";i:403;s:18:\"rss/editor.min.css\";i:404;s:17:\"rss/style-rtl.css\";i:405;s:21:\"rss/style-rtl.min.css\";i:406;s:13:\"rss/style.css\";i:407;s:17:\"rss/style.min.css\";i:408;s:21:\"search/editor-rtl.css\";i:409;s:25:\"search/editor-rtl.min.css\";i:410;s:17:\"search/editor.css\";i:411;s:21:\"search/editor.min.css\";i:412;s:20:\"search/style-rtl.css\";i:413;s:24:\"search/style-rtl.min.css\";i:414;s:16:\"search/style.css\";i:415;s:20:\"search/style.min.css\";i:416;s:20:\"search/theme-rtl.css\";i:417;s:24:\"search/theme-rtl.min.css\";i:418;s:16:\"search/theme.css\";i:419;s:20:\"search/theme.min.css\";i:420;s:24:\"separator/editor-rtl.css\";i:421;s:28:\"separator/editor-rtl.min.css\";i:422;s:20:\"separator/editor.css\";i:423;s:24:\"separator/editor.min.css\";i:424;s:23:\"separator/style-rtl.css\";i:425;s:27:\"separator/style-rtl.min.css\";i:426;s:19:\"separator/style.css\";i:427;s:23:\"separator/style.min.css\";i:428;s:23:\"separator/theme-rtl.css\";i:429;s:27:\"separator/theme-rtl.min.css\";i:430;s:19:\"separator/theme.css\";i:431;s:23:\"separator/theme.min.css\";i:432;s:24:\"shortcode/editor-rtl.css\";i:433;s:28:\"shortcode/editor-rtl.min.css\";i:434;s:20:\"shortcode/editor.css\";i:435;s:24:\"shortcode/editor.min.css\";i:436;s:24:\"site-logo/editor-rtl.css\";i:437;s:28:\"site-logo/editor-rtl.min.css\";i:438;s:20:\"site-logo/editor.css\";i:439;s:24:\"site-logo/editor.min.css\";i:440;s:23:\"site-logo/style-rtl.css\";i:441;s:27:\"site-logo/style-rtl.min.css\";i:442;s:19:\"site-logo/style.css\";i:443;s:23:\"site-logo/style.min.css\";i:444;s:27:\"site-tagline/editor-rtl.css\";i:445;s:31:\"site-tagline/editor-rtl.min.css\";i:446;s:23:\"site-tagline/editor.css\";i:447;s:27:\"site-tagline/editor.min.css\";i:448;s:26:\"site-tagline/style-rtl.css\";i:449;s:30:\"site-tagline/style-rtl.min.css\";i:450;s:22:\"site-tagline/style.css\";i:451;s:26:\"site-tagline/style.min.css\";i:452;s:25:\"site-title/editor-rtl.css\";i:453;s:29:\"site-title/editor-rtl.min.css\";i:454;s:21:\"site-title/editor.css\";i:455;s:25:\"site-title/editor.min.css\";i:456;s:24:\"site-title/style-rtl.css\";i:457;s:28:\"site-title/style-rtl.min.css\";i:458;s:20:\"site-title/style.css\";i:459;s:24:\"site-title/style.min.css\";i:460;s:26:\"social-link/editor-rtl.css\";i:461;s:30:\"social-link/editor-rtl.min.css\";i:462;s:22:\"social-link/editor.css\";i:463;s:26:\"social-link/editor.min.css\";i:464;s:27:\"social-links/editor-rtl.css\";i:465;s:31:\"social-links/editor-rtl.min.css\";i:466;s:23:\"social-links/editor.css\";i:467;s:27:\"social-links/editor.min.css\";i:468;s:26:\"social-links/style-rtl.css\";i:469;s:30:\"social-links/style-rtl.min.css\";i:470;s:22:\"social-links/style.css\";i:471;s:26:\"social-links/style.min.css\";i:472;s:21:\"spacer/editor-rtl.css\";i:473;s:25:\"spacer/editor-rtl.min.css\";i:474;s:17:\"spacer/editor.css\";i:475;s:21:\"spacer/editor.min.css\";i:476;s:20:\"spacer/style-rtl.css\";i:477;s:24:\"spacer/style-rtl.min.css\";i:478;s:16:\"spacer/style.css\";i:479;s:20:\"spacer/style.min.css\";i:480;s:20:\"table/editor-rtl.css\";i:481;s:24:\"table/editor-rtl.min.css\";i:482;s:16:\"table/editor.css\";i:483;s:20:\"table/editor.min.css\";i:484;s:19:\"table/style-rtl.css\";i:485;s:23:\"table/style-rtl.min.css\";i:486;s:15:\"table/style.css\";i:487;s:19:\"table/style.min.css\";i:488;s:19:\"table/theme-rtl.css\";i:489;s:23:\"table/theme-rtl.min.css\";i:490;s:15:\"table/theme.css\";i:491;s:19:\"table/theme.min.css\";i:492;s:24:\"tag-cloud/editor-rtl.css\";i:493;s:28:\"tag-cloud/editor-rtl.min.css\";i:494;s:20:\"tag-cloud/editor.css\";i:495;s:24:\"tag-cloud/editor.min.css\";i:496;s:23:\"tag-cloud/style-rtl.css\";i:497;s:27:\"tag-cloud/style-rtl.min.css\";i:498;s:19:\"tag-cloud/style.css\";i:499;s:23:\"tag-cloud/style.min.css\";i:500;s:28:\"template-part/editor-rtl.css\";i:501;s:32:\"template-part/editor-rtl.min.css\";i:502;s:24:\"template-part/editor.css\";i:503;s:28:\"template-part/editor.min.css\";i:504;s:27:\"template-part/theme-rtl.css\";i:505;s:31:\"template-part/theme-rtl.min.css\";i:506;s:23:\"template-part/theme.css\";i:507;s:27:\"template-part/theme.min.css\";i:508;s:30:\"term-description/style-rtl.css\";i:509;s:34:\"term-description/style-rtl.min.css\";i:510;s:26:\"term-description/style.css\";i:511;s:30:\"term-description/style.min.css\";i:512;s:27:\"text-columns/editor-rtl.css\";i:513;s:31:\"text-columns/editor-rtl.min.css\";i:514;s:23:\"text-columns/editor.css\";i:515;s:27:\"text-columns/editor.min.css\";i:516;s:26:\"text-columns/style-rtl.css\";i:517;s:30:\"text-columns/style-rtl.min.css\";i:518;s:22:\"text-columns/style.css\";i:519;s:26:\"text-columns/style.min.css\";i:520;s:19:\"verse/style-rtl.css\";i:521;s:23:\"verse/style-rtl.min.css\";i:522;s:15:\"verse/style.css\";i:523;s:19:\"verse/style.min.css\";i:524;s:20:\"video/editor-rtl.css\";i:525;s:24:\"video/editor-rtl.min.css\";i:526;s:16:\"video/editor.css\";i:527;s:20:\"video/editor.min.css\";i:528;s:19:\"video/style-rtl.css\";i:529;s:23:\"video/style-rtl.min.css\";i:530;s:15:\"video/style.css\";i:531;s:19:\"video/style.min.css\";i:532;s:19:\"video/theme-rtl.css\";i:533;s:23:\"video/theme-rtl.min.css\";i:534;s:15:\"video/theme.css\";i:535;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wpvv_options` VALUES("130", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"1a7f8946efbf284a4c14585980ade540\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wpvv_options` VALUES("131", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.8.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.8.2-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.2\";s:7:\"version\";s:5:\"6.8.2\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1757509874;s:15:\"version_checked\";s:5:\"6.8.2\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wpvv_options` VALUES("140", "loginizer_softwp_upgrade", "1755155169", "auto");
INSERT INTO `wpvv_options` VALUES("148", "gosmtp_version", "1.1.4", "auto");
INSERT INTO `wpvv_options` VALUES("151", "pagelayer_version", "2.0.3", "auto");
INSERT INTO `wpvv_options` VALUES("152", "pagelayer_options", "a:0:{}", "auto");
INSERT INTO `wpvv_options` VALUES("158", "pagelayer_promo_time", "1755241604", "auto");
INSERT INTO `wpvv_options` VALUES("164", "backuply_license_notice", "1755155204", "auto");
INSERT INTO `wpvv_options` VALUES("171", "can_compress_scripts", "0", "on");
INSERT INTO `wpvv_options` VALUES("184", "_site_transient_wp_plugin_dependencies_plugin_data", "a:1:{s:9:\"elementor\";a:35:{s:4:\"name\";s:63:\"Elementor Website Builder &#8211; More Than Just a Page Builder\";s:4:\"slug\";s:9:\"elementor\";s:7:\"version\";s:6:\"3.31.5\";s:6:\"author\";s:64:\"<a href=\"https://profiles.wordpress.org/elemntor/\">Elementor</a>\";s:14:\"author_profile\";s:40:\"https://profiles.wordpress.org/elemntor/\";s:12:\"contributors\";a:1:{s:8:\"elemntor\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/elemntor/\";s:6:\"avatar\";s:120:\"https://secure.gravatar.com/avatar/7d70f15d78757f876d1847a8f87dd93e1d9c168264b4aeeaf72058656690d05b?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:9:\"Elementor\";}}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:90;s:7:\"ratings\";a:5:{i:5;i:6048;i:4;i:219;i:3;i:107;i:2;i:105;i:1;i:623;}s:11:\"num_ratings\";i:7102;s:11:\"support_url\";s:47:\"https://wordpress.org/support/plugin/elementor/\";s:15:\"support_threads\";i:114;s:24:\"support_threads_resolved\";i:92;s:15:\"active_installs\";i:10000000;s:12:\"last_updated\";s:21:\"2025-09-09 1:57pm GMT\";s:5:\"added\";s:10:\"2016-05-30\";s:8:\"homepage\";s:87:\"https://elementor.com/?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash\";s:8:\"sections\";a:6:{s:11:\"description\";s:25581:\"<p><iframe loading=\"lazy\" title=\"Elementor - The Leading Platform for Web Creators\" width=\"750\" height=\"422\" src=\"https://www.youtube.com/embed/le72grP_Q6k?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe></p>\n<h4>THE #1 NO CODE DRAG &amp; DROP WORDPRESS WEBSITE BUILDER POWERING OVER 18M WEBSITES WORLDWIDE, NOW WITH AI.</h4>\n<p>Elementor, the leading WordPress website creation platform, empowers you to build professional, pixel-perfect websites seamlessly.</p>\n<p>Unlock all features with <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-pro-features/\" rel=\"nofollow ugc\">Elementor Pro</a>.</p>\n<p>Need fast and secure cloud hosting for your Elementor site? Try out <strong><a href=\"https://elemn.to/repo-hosting\" rel=\"nofollow ugc\">Elementor Hosting</a></strong> Powered by Google Cloud &amp; Cloudflare. 4.9/5 TrustPilot score.</p>\n<h3>🌟 Create Professional Stunning Websites</h3>\n<ul>\n<li><strong><a href=\"https://go.elementor.com/feature-page-editor/\" rel=\"nofollow ugc\">Intuitive Drag &amp; Drop Builder</a></strong>: Build any website with our no-code, drag-and-drop Editor. Achieve design precision with full control over layout and style.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-feature-page/\" rel=\"nofollow ugc\">Pixel-Perfect Design Tools</a></strong>: Upload SVGs, apply masks, gradients, box shadows, headline effects, shape dividers, and use built-in CSS controls for advanced customization.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-library-full-website-kit/\" rel=\"nofollow ugc\">Template Library</a></strong>: Apply complete website kits for instant setups, or choose from a vast library of single pages, blocks, and pop-up templates.</li>\n<li><strong><a href=\"https://go.elementor.com/feature-page-editor/\" rel=\"nofollow ugc\">Advanced Widgets</a></strong>: Access over 40 FREE widgets, including heading, image, text editor, video, button, gallery, carousels, and more.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-ai/\" rel=\"nofollow ugc\">AI Capabilities</a></strong>: Revolutionize your design and content creation process with native AI integration. Instantly create sections, text, code, and images.</li>\n</ul>\n<h4>🗝️ Key features:</h4>\n<ul>\n<li><strong><a href=\"https://go.elementor.com/feature-page-global-settings/\" rel=\"nofollow ugc\">Design System</a></strong>: Use Elementor&#8217;s Design System for consistent colors, typography, and design elements, ensuring a cohesive, professional look.</li>\n<li><strong><a href=\"https://go.elementor.com/feature-page-responsive-design/\" rel=\"nofollow ugc\">Responsive Design</a></strong>: Optimize your design for every device with custom breakpoints, ensuring a seamless desktop, tablet, and mobile experience.</li>\n<li><strong>Mask Shapes</strong>: Turning any element, like an image or video, into whatever shape you desire to create standout designs.</li>\n<li><strong>CSS Transform</strong>: Use CSS Transform to rotate, scale, and skew elements, adding dynamic styling to your site.</li>\n<li><strong>Entrance Animations</strong>: Add entrance animations to elements to create engaging and interactive user experiences.</li>\n<li><strong><a href=\"https://elementor.com/features/#SaveBackup\" rel=\"nofollow ugc\">Revision History</a></strong>: Elementor&#8217;s Revision History feature enables users to track and revert to previous versions of their designs, providing peace of mind and flexibility during the creative process.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-developers-developers-website/\" rel=\"nofollow ugc\">Developer-Friendly</a></strong>: Equipped with extensive documentation, API, developer tools, and custom code areas, Elementor offers a conducive environment for developers to extend its capabilities and create custom solutions.</li>\n<li><strong>Floating Buttons</strong>: Enhance user interaction with customizable, floating action buttons that stay in view as users scroll.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-industry-leading-theme-builder/\" rel=\"nofollow ugc\">Theme Builder</a> [Pro]</strong>: Design every part of your site—headers, footers, posts, and archives—for complete control over appearance.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-popup-builder/\" rel=\"nofollow ugc\">Popup Builder</a> [Pro]</strong>: Create eye-catching popups with Elementor&#8217;s Popup Builder, equipped with advanced targeting and triggering options to optimize user engagement and conversions.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-professional-form-builder-and-submission-log/\" rel=\"nofollow ugc\">Forms</a> [Pro]</strong>: Design and integrate custom forms, utilizing advanced features and integrations to capture and manage submissions effectively.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-woocommerce-builder/\" rel=\"nofollow ugc\">WooCommerce Builder</a> [Pro]</strong>: Integrate Elementor with WooCommerce to design custom product pages, shop layouts, archives, carts, checkout pages, my account, and more, enhancing your store&#8217;s visual appeal and functionality.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-dynamic-content/\" rel=\"nofollow ugc\">Dynamic Content</a> [Pro]</strong>: Leverage dynamic content capabilities to create personalized and interactive web experiences by connecting your designs to various data sources.</li>\n<li><strong><a href=\"https://go.elementor.com/features-page-notes/\" rel=\"nofollow ugc\">Notes</a> [Pro]</strong>: Enhance team collaboration by using Elementor&#8217;s Notes feature to leave feedback and comments directly on the design interface.</li>\n<li><strong>Custom Code [Pro]</strong>: Insert custom code to extend the functionality of your site, offering flexibility for advanced customizations.</li>\n<li><strong>Custom CSS [Pro]</strong>: Apply Custom CSS to fine-tune the styling of elements, ensuring precise control over the design aspects.</li>\n<li><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-pro-features-motion-effects/\" rel=\"nofollow ugc\">Motion Effects</a> [Pro]</strong>: Add advanced motion effects to elements for a more dynamic and engaging user experience.</li>\n<li><strong>Custom Fonts &amp; Icons [Pro]</strong>: Upload and use custom fonts and icons to match your brand&#8217;s identity.</li>\n</ul>\n<h4>😍 Elementor FREE widgets</h4>\n<p>Unlock the potential of Elementor with our comprehensive suite of free widgets and tools, designed to empower your website creation process and elevate your design capabilities:</p>\n<ul>\n<li><strong>Heading</strong>. Add eye-catching headlines.</li>\n<li><strong>Image</strong>. Control the size, opacity and more.</li>\n<li><strong>Text Editor</strong>. Just like the WordPress editor.</li>\n<li><strong>Video</strong>. Add YouTube, Vimeo, Dailymotion or self-hosted videos.</li>\n<li><strong>Button</strong>. Create interactive buttons.</li>\n<li><strong>Link in Bio</strong>. Build link in bio components to promote your business / services.</li>\n<li><strong>Image Box</strong>. A box with image, headline and text.</li>\n<li><strong>Testimonials</strong>. Customer testimonials.</li>\n<li><strong>Icon</strong>. Place one or more of 600+ icons available.</li>\n<li><strong>Icon Box</strong>. An icon, headline, and text with one widget.</li>\n<li><strong>Social Icons</strong>. Link to your social pages with the Facebook/X (formerly Twitter) icons.</li>\n<li><strong>Image Gallery</strong>. Display your images in a grid.</li>\n<li><strong>Image Carousel</strong>. Create rotating carousels or sliders for chosen images.</li>\n<li><strong>Icon List</strong>. Use any icon to create a bullet list.</li>\n<li><strong>Counter</strong>. Show numbers in an escalating manner.</li>\n<li><strong>Progress Bar</strong>. Include an escalating progress bar.</li>\n<li><strong>Nested Tabs</strong>. Display content in vertical or horizontal tabs.</li>\n<li><strong>Nested Accordion</strong>. Display any type of content in collapsible sections.</li>\n<li><strong>Toggle</strong>. Use the Toggle to hide or display content, like FAQ.</li>\n<li><strong>Rating</strong>. Display how many stars (or another icon) other visitors gave.</li>\n<li><strong>Alert</strong>. Include a colored alert box to draw visitor’s attention.</li>\n<li><strong>HTML</strong>. Insert code into the page.</li>\n<li><strong>Shortcode</strong>. Insert shortcodes from any plugin into the page.</li>\n<li><strong>Menu Anchor</strong>. Link any menu to this anchor.</li>\n<li><strong>Read More</strong>. Set the Read More cut-off for the excerpt in archive pages.</li>\n<li><strong>Sidebar</strong>. Add sidebars onto the page.</li>\n<li><strong>Google Maps</strong>. Embed maps into the page.</li>\n<li><strong>SoundCloud</strong>. Add SoundCloud audio bits.</li>\n<li><strong>Divider</strong>. Separate content with a designed divider.</li>\n<li><strong>Spacer</strong>. Add space between elements.</li>\n<li><strong>Text Path</strong>. Attach your text to a path.</li>\n<li><strong>And counting&#8230;</strong></li>\n</ul>\n<h3>🚀 Enhance Your Website</h3>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-performance-performance-page/\" rel=\"nofollow ugc\">High-Performing Websites</a></strong>: Website performance impacts your visitor’s experience and search result ranking. Elementor, in partnership with Google Chrome, continuously enhances performance without compromising design.</p>\n<p><strong>Key features include:</strong></p>\n<ul>\n<li><strong>Reduced DOM Output</strong>: Streamlined HTML structure for faster rendering.</li>\n<li><strong>Improved Media File Loading</strong>: Optimized loading of images, videos, and other media assets.</li>\n<li><strong>Reduced CSS and JS Files</strong>: Minimized and concatenated stylesheets and scripts for quicker loading times.</li>\n<li><strong>Lazy Loading</strong>: Deferred loading of non-critical resources to improve initial page load speed.</li>\n<li><strong>Faster Font Loading</strong>: Efficient delivery of web fonts to enhance text rendering speed.</li>\n<li><strong>Optimized Front-End Asset Loading</strong>: Efficient loading of assets like JavaScript and CSS to minimize render-blocking.</li>\n<li><strong>Element Caching</strong>: Cache frequently accessed design elements to reduce server response time and enhance overall performance.</li>\n</ul>\n<h3>🔥 Elementor Pro Features</h3>\n<p>Create unparalleled websites while saving time, money and resources with <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/\" rel=\"nofollow ugc\">Elementor Pro</a>’s full website builder. Get access to 100+ professional widgets, features, and tools.</p>\n<p><strong>Pro Design Widgets:</strong></p>\n<ol>\n<li><strong>Posts</strong>: Display your blog posts with customizable layouts and styles.</li>\n<li><strong>Share Buttons</strong>: Allow visitors to easily share your content on various social media platforms.</li>\n<li><strong>Portfolio</strong>: Showcase your work or projects with stunning portfolio layouts.</li>\n<li><strong>Slides</strong>: Create dynamic slideshows with custom animations and transitions.</li>\n<li><strong>Form</strong>: Design and customize advanced forms for user interaction and data collection.</li>\n<li><strong>Login</strong>: Add a login form or user registration module to your website.</li>\n<li><strong>Nav Menu</strong>: Customize and style your website&#8217;s navigation menu for better user experience.</li>\n<li><strong>Animated Headline</strong>: Create attention-grabbing headlines with animated effects.</li>\n<li><strong>Price Table</strong>: Display pricing plans or packages in a structured and visually appealing format.</li>\n<li><strong>Price List</strong>: Showcase a list of prices or services with customizable styling options.</li>\n<li><strong>Gallery</strong>: Create beautiful image galleries with various layout options and lightbox support.</li>\n<li><strong>Flip Box</strong>: Add interactive flip animations to highlight content or features.</li>\n<li><strong>Call to Action</strong>: Encourage user interaction and conversions with compelling call-to-action sections.</li>\n<li><strong>Media Carousel</strong>: Showcase a carousel of media files such as images or videos.</li>\n<li><strong>Testimonial Carousel</strong>: Display client testimonials in a carousel format for social proof.</li>\n<li><strong>Nested Carousel</strong>: Create nested carousels for more complex content organization.</li>\n<li><strong>Loop Carousel</strong>: Display content in a looped carousel for continuous viewing.</li>\n<li><strong>Table Of Content</strong>: Generate a table of contents for longer articles or guides to improve navigation.</li>\n<li><strong>Countdown</strong>: Add countdown timers to create urgency for promotions or events.</li>\n<li><strong>Facebook Page</strong>: Embed your Facebook page feed or content onto your website.</li>\n<li><strong>Blockquote</strong>: Highlight quotes or testimonials with stylish formatting options.</li>\n<li><strong>Template</strong>: Save and reuse design templates for consistent branding and layout.</li>\n<li><strong>Reviews</strong>: Showcase customer reviews and ratings to build trust and credibility.</li>\n<li><strong>Facebook Button</strong>: Add buttons to promote interactions with your Facebook page or content.</li>\n<li><strong>Facebook Embed</strong>: Embed Facebook posts or content onto your website.</li>\n<li><strong>Facebook Comments</strong>: Enable Facebook comments on your website&#8217;s pages or posts.</li>\n<li><strong>PayPal Button</strong>: Integrate PayPal buttons for easy online payments.</li>\n<li><strong>Stripe Button</strong>: Integrate Stripe payment buttons to facilitate secure online transactions.</li>\n<li><strong>Lottie Widget</strong>: Add Lottie animations to enhance visual appeal and engagement.</li>\n<li><strong>Code Highlight</strong>: Display code snippets with syntax highlighting for better readability.</li>\n<li><strong>Video Playlist</strong>: Create and customize playlists for video content on your website.</li>\n<li><strong>Mega Menu</strong>: Customize advanced menus for better navigation and displaying complex content.</li>\n<li><strong>Off Canvas</strong>: Create off-canvas areas that slide in to show extra info or menus without cluttering the main layout.</li>\n</ol>\n<p><strong>Pro Theme Widgets:</strong></p>\n<p>Build and customize all the key parts of your website including headers, footers, 404 page, global archives, and more</p>\n<ol>\n<li><strong>Post Title</strong>: Customize the title of individual blog posts or pages.</li>\n<li><strong>Post Excerpt</strong>: Display a brief summary or teaser of your blog posts.</li>\n<li><strong>Post Content</strong>: Customize the main content area of your blog posts or pages.</li>\n<li><strong>Featured Image</strong>: Set and customize featured images for blog posts or pages.</li>\n<li><strong>Author Box</strong>: Display author information and bios on blog posts.</li>\n<li><strong>Post Comments</strong>: Customize the appearance and functionality of comments sections on your website.</li>\n<li><strong>Post Navigation</strong>: Add navigation links to adjacent posts for easy browsing.</li>\n<li><strong>Post Info</strong>: Display additional information about blog posts, such as author and date.</li>\n<li><strong>Site Logo</strong>: Upload and customize your website&#8217;s logo for branding purposes.</li>\n<li><strong>Site Title</strong>: Customize the title of your website.</li>\n<li><strong>Page Title</strong>: Customize the title of individual pages.</li>\n<li><strong>Search Bar</strong>: Add a search bar to allow users to search your website&#8217;s content.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation.</li>\n<li><strong>Sitemap</strong>: Generate a sitemap for better search engine indexing and user navigation.</li>\n<li><strong>Loop Grid</strong>: Design and customize grid layouts for blog post archives or product listings.</li>\n</ol>\n<p><strong>Pro WooCommerce Widgets:</strong></p>\n<p>Design and customize a complete online shopping experience across your entire website.</p>\n<ol>\n<li><strong>Product</strong>: Display individual products with customizable layouts and styles.</li>\n<li><strong>Breadcrumbs</strong>: Display hierarchical navigation paths for better user navigation within your store.</li>\n<li><strong>Product Title</strong>: Customize the title of individual products.</li>\n<li><strong>Product Images</strong>: Set and customize images for product listings.</li>\n<li><strong>Product Price</strong>: Display the price of individual products.</li>\n<li><strong>Add To Cart</strong>: Add customizable add to cart buttons for easy purchasing.</li>\n<li><strong>Product Rating</strong>: Display ratings and reviews for products.</li>\n<li><strong>Product Stock</strong>: Display stock availability for products.</li>\n<li><strong>Product Meta</strong>: Display additional information about products, such as SKU and categories.</li>\n<li><strong>Product Content</strong>: Customize the main content area of product descriptions.</li>\n<li><strong>Short Description</strong>: Display brief summaries or teasers of products.</li>\n<li><strong>Product Data Tabs</strong>: Organize product information into tabbed sections for better organization.</li>\n<li><strong>Additional Information</strong>: Display additional details about products, such as dimensions and weight.</li>\n<li><strong>Product Related</strong>: Showcase related products to encourage additional purchases.</li>\n<li><strong>Upsells</strong>: Promote upsell products to increase average order value.</li>\n<li><strong>Products</strong>: Display a grid or list of products with customizable settings.</li>\n<li><strong>Custom Add To Cart</strong>: Customize the add to cart button for specific products.</li>\n<li><strong>WooCommerce Pages</strong>: Design and customize WooCommerce-specific pages, such as the cart and checkout pages.</li>\n<li><strong>Product Categories</strong>: Display product categories for easy navigation within your store.</li>\n<li><strong>Menu Cart</strong>: Display a cart icon in your navigation menu for easy access to the shopping cart.</li>\n<li><strong>Cart</strong>: Customize the appearance and functionality of the shopping cart page.</li>\n<li><strong>Checkout</strong>: Customize the appearance and functionality of the checkout page.</li>\n<li><strong>My Account</strong>: Customize the appearance and functionality of the customer account area.</li>\n<li><strong>Purchase Summary</strong>: Display a summary of purchases during the checkout process.</li>\n<li><strong>WooCommerce Notices</strong>: Customize the appearance and functionality of WooCommerce notices, such as order confirmation messages.</li>\n</ol>\n<p>Build professional websites with <strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-pro-elementor-pro/\" rel=\"nofollow ugc\">Elementor Pro</a></strong>!</p>\n<h4>🔒 SECURITY AND COMPLIANCE</h4>\n<p>Elementor places a paramount focus on security, evident through our acquisition of industry certifications such as ISO/IEC 27001, ISO/IEC 27017, ISO/IEC 27018, ISO/IEC 27701, and SOC 2 Type II. These certifications underscore our commitment to implementing robust security measures, and highlight our dedication to adhering to recognized industry standards.</p>\n<p>We encourage ethical security research through our <a href=\"https://go.elementor.com/wp-repo-description-tab-bug-crowd-bug-bounty-program/\" rel=\"nofollow ugc\">Bug Bounty program</a>. We collaborate with leading bug bounty services to provide opportunities for researchers to report vulnerabilities in our services. Our bounty programs include a triage team available 24/7/365.</p>\n<p>For more information: <a href=\"https://go.elementor.com/trust-center/\" rel=\"nofollow ugc\">Trust Center</a>.</p>\n<h4>♿ Accessibility Best Practices</h4>\n<p>Elementor offers accessibility tools and enhancements to help you provide a better experience for all users. Including HTML 5 semantic, full keyboard navigation menu, ongoing improvement of features, widget, and more.</p>\n<h4>🌐 Translated to 63+ languages, includes RTL support</h4>\n<p>Elementor supports multiple languages, typographies, and RTL, with editor translations in <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/\" rel=\"nofollow ugc\">over 63 languages</a>.</p>\n<p>It’s also compatible with WPML, Polylang, TranslatePress, Weglot, and more. To contribute, add a new language via translate.wordpress.org. See our guide on <a href=\"https://go.elementor.com/wp-repo-description-tab-help-center-translate/\" rel=\"nofollow ugc\">how to translate and localize the plugin</a>.</p>\n<h4>⏩ Use of 3rd Party Services</h4>\n<p>To improve the user experience, Elementor may use the following 3rd party services if the required feature is enabled:</p>\n<ul>\n<li>Google Fonts – are loaded to add additional fonts to your website. Google’s <a href=\"https://policies.google.com/terms\" rel=\"nofollow ugc\">TOS</a> and <a href=\"https://policies.google.com/privacy\" rel=\"nofollow ugc\">Privacy Policy</a></li>\n<li>Some Elementor features require loading assets from Elementor.com. These assets are not used for tracking unless explicitly mentioned, requiring your approval and manual opt-in. Learn more in our <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-plugin-terms/\" rel=\"nofollow ugc\">TOS</a> and <a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-plugin-privacy/\" rel=\"nofollow ugc\">Privacy Policy</a>.</li>\n</ul>\n<h4>📧 Related Products by Elementor</h4>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-io/\" rel=\"nofollow ugc\">Image Optimizer</a></strong>: Superior image compression for faster, high-quality website performance.</p>\n<p><strong><a href=\"https://go.elementor.com/wp-repo-description-tab-elementor-sm/\" rel=\"nofollow ugc\">Site Mailer</a></strong>: Reliable email management without SMTP plugins, keeping your communications streamlined and efficient.</p>\n<h4>📣 See What Our Users Have to Say</h4>\n<blockquote>\n<p>“Elementor is hands down the best page builder out there” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/elementor-is-hands-down-the-best-page-builder-out-there/\" rel=\"ugc\">Graphicvision1</a></em></p>\n<p>“An incredibly user-friendly plugin” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/a-wonderful-experience/\" rel=\"ugc\">Hyeyoga</a></em></p>\n<p>“Easily, my most used WP plugin” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/easily-my-most-used-wp-plugin/\" rel=\"ugc\">Xander Venske</a></em></p>\n<p>“I upgraded to the Pro version and just love this plugin!” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/love-elementor-17/\" rel=\"ugc\">Andybarn56</a></em></p>\n<p>“Excellent product with great tech support” – ★★★★★ <em><a href=\"https://wordpress.org/support/topic/excellent-product-with-great-tech-support/\" rel=\"ugc\">Martywilsonnj</a></em></p>\n</blockquote>\n<p><em><a href=\"https://wordpress.org/support/plugin/elementor/reviews/?filter=5\" rel=\"ugc\">More testimonials</a></em></p>\n<h4>🌍 Join a Global Community</h4>\n<p>Join a global community that helps each other achieve their goals.</p>\n<ul>\n<li><a href=\"https://elemn.to/discord\" rel=\"nofollow ugc\">Discord Community</a> – Topic and language-specific channels, plus Ella, an amazing AI helper, ready to assist you.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-facebook-group/\" rel=\"nofollow ugc\">Facebook Community</a> &#8211; Over 150K+ members, offering support, advice, feedback, and tutorials.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-github-repo/\" rel=\"nofollow ugc\">GitHub Community</a> &#8211; Get information about releases, request features, or report a bug.</li>\n<li><a href=\"https://go.elementor.com/wp-repo-description-tab-addons-dozens-of-elementor-addons/\" rel=\"nofollow ugc\">Elementor Addons, Themes, and Kits</a> Themes and Kits – created specifically for Elementor.</li>\n<li>Learn valuable insights and techniques from our <a href=\"https://go.elementor.com/wp-repo-description-tab-youtube-channel/\" rel=\"nofollow ugc\">YouTube Channel</a>.</li>\n<li>Access our <a href=\"https://go.elementor.com/wp-repo-description-tab-academy-elementor-academy/\" rel=\"nofollow ugc\">Academy</a> and <a href=\"https://go.elementor.com/wp-repo-description-tab-help-center-help-center/\" rel=\"nofollow ugc\">Help Center</a> &#8211; Find guides, tutorials, and resources to answer your questions and boost creativity.</li>\n<li>Show your support by <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-review/\" rel=\"nofollow ugc\">rating us on WordPress</a>. Your feedback fuels our growth! 🤗</li>\n<li>If you have questions or need support, visit the <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-forum/\" rel=\"nofollow ugc\">Plugin&#8217;s Forum</a>. Elementor Pro users can get 24/7 premium support,  &hellip;</li>\n</ul>\n\";s:12:\"installation\";s:1461:\"<h4>Minimum Requirements</h4>\n<ul>\n<li>WordPress 6.5 or greater</li>\n<li>PHP version 7.4 or greater</li>\n<li>MySQL version 5.0 or greater</li>\n</ul>\n<h4>Recommended Requirements</h4>\n<ul>\n<li>PHP version 8.1 or greater</li>\n<li>MySQL version 5.6 or greater</li>\n<li>WordPress Memory limit of 64 MB or greater (128 MB or higher is preferred)</li>\n</ul>\n<p><iframe loading=\"lazy\" title=\"Installing Elementor on WordPress\" width=\"750\" height=\"422\" src=\"https://www.youtube.com/embed/9EZ159ryFNs?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe></p>\n<h4>Installation</h4>\n<ol>\n<li>Install using the WordPress built-in Plugin installer, or Extract the zip file and drop the contents in the <code>wp-content/plugins/</code> directory of your WordPress installation.</li>\n<li>Activate the plugin through the &#8216;Plugins&#8217; menu in WordPress.</li>\n<li>Go to Pages &gt; Add New</li>\n<li>Press the &#8216;Edit with Elementor&#8217; button.</li>\n<li>Now you can drag and drop widgets from the left panel onto the content area, as well as add new sections and columns that make up the page structure.</li>\n</ol>\n<p>For documentation and tutorials visit our <a href=\"https://elementor.com/help/?utm_source=wp-repo&amp;utm_medium=link&amp;utm_campaign=readme\" rel=\"nofollow ugc\">Knowledge Base</a>.</p>\n\";s:3:\"faq\";s:4862:\"\n<dt id=\'how%20do%20i%20install%20elementor%3F\'>\nHow do I install Elementor?\n</h4>\n<p>\n<p>To install the free version of Elementor, follow the steps below:<br />\nFrom your WordPress dashboard -&gt; Go to Plugins -&gt; Click on &#8216;Add new&#8217;-&gt; In the Search field, enter Elementor and choose Elementor website builder.<br />\nPress install -&gt; After installation, click Activate.</p>\n</p>\n<dt id=\'does%20elementor%20work%20with%20all%20the%20themes%3F\'>\nDoes Elementor work with all the themes?\n</h4>\n<p>\n<p>Elementor works all the themes that respect the coding standards of WordPress set by its Codex. It is recommended to use Elementor&#8217;s <a href=\"https://go.elementor.com/wp-repo-description-tab-hello-theme-hello-theme/\" rel=\"nofollow ugc\">Hello Theme</a>, a lightweight blank canvas, to enjoy full flexibility when using Elementor, and optimize your experience.</p>\n</p>\n<dt id=\'is%20elementor%20compatible%20with%20gutenberg%3F\'>\nIs Elementor compatible with Gutenberg?\n</h4>\n<p>\n<p>Elementor and Gutenberg work seamlessly together. As a user, you can easily decide which editor to use at every point while editing your site.</p>\n</p>\n<dt id=\'can%20i%20create%20an%20online%20store%3F\'>\nCan I create an online store?\n</h4>\n<p>\n<p>Yes, with the Elementor Pro WooCommerce Builder you can customize every page of your store to create an amazing customer experience that drives sales.</p>\n</p>\n<dt id=\'does%20it%20work%20with%20other%20wordpress%20plugins%3F\'>\nDoes it work with other WordPress plugins?\n</h4>\n<p>\n<p>It works with almost all the plugins. If you experience an incompatibility issue, please report it to us and to the plugin that conflicts with Elementor.</p>\n</p>\n<dt id=\'do%20i%20need%20to%20know%20how%20to%20code%3F\'>\nDo I need to know how to code?\n</h4>\n<p>\n<p>No! Elementor provides you with all the widgets and features that you need to build a professional website without using code.</p>\n</p>\n<dt id=\'do%20i%20need%20to%20know%20how%20to%20design%3F\'>\nDo I need to know how to design?\n</h4>\n<p>\n<p>No, you can choose between professionally designed kits and templates that fit toevery industry and have all you need to create your own professional website.</p>\n</p>\n<dt id=\'will%20elementor%20slow%20down%20my%20website%3F\'>\nWill Elementor slow down my website?\n</h4>\n<p>\n<p>As Elementor prioritizes speed and performance, you enjoy better and faster performance with each new version of Elementor. When testing the same page layout on older versions you can see a significant performance improvement, from a score of 82 in Google PageSpeed Insight in version 3.1, to a score of 95 i in version 3.5.</p>\n</p>\n<dt id=\'is%20my%20site%20secure%20with%20elementor%3F\'>\nIs my site secure with Elementor?\n</h4>\n<p>\n<p>The security of your website is extremely important to us and we take proactive measures to assure that your websites are secure. Elementor is ISO 27001 certified, and has a dedicated team of security professionals that implements industry best-practices for maximum security and compliance, 24/7.</p>\n<p>There is also a managed security Bug Bounty program, utilizing the community power by enabling 24/7/365 crowdsourced vulnerability detection.</p>\n</p>\n<dt id=\'can%20i%20buy%20templates%20separately%3F\'>\nCan I buy templates separately?\n</h4>\n<p>\n<p>Of course, you can use any template that supports Elementor.</p>\n</p>\n<dt id=\'is%20elementor%20compatible%20with%20post%20and%20custom%20post%20types%3F\'>\nIs Elementor compatible with Post and Custom Post Types?\n</h4>\n<p>\n<p>Of course! You can set which post types will enable Elementor in the settings page.</p>\n</p>\n<dt id=\'what%20is%20the%20difference%20between%20elementor%27s%20free%20plugin%20and%20elementor%20pro\'>\nWhat is the difference between Elementor&#8217;s free Plugin and Elementor Pro\n</h4>\n<p>\n<p>Elementor’s Free version allows you to explore our revolutionary drag &amp; drop live editor, basic widgets and templates. Elementor Pro (Essential, Advanced, Expert, Studio, and Agency) empowers you with more professional tools that speed up your workflow, give you access to human-powered support, help you build more advanced content, and convert visitors. See full comparison here.</p>\n</p>\n<dt id=\'how%20can%20i%20become%20a%20contributor\'>\nHow can I become a Contributor\n</h4>\n<p>\n<p>If you want to contribute, go to our <a href=\"https://github.com/elementor/elementor\" rel=\"nofollow ugc\">Elementor GitHub Repository</a> and see where you can help.<br />\nYou can also add a new language via <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate/\" rel=\"nofollow ugc\">translate.wordpress.org</a>. We’ve built a short guide explaining <a href=\"https://go.elementor.com/wp-repo-description-tab-wordpress-plugin-translate-faq/\" rel=\"nofollow ugc\">how to translate and localize the plugin</a>.</p>\n</p>\n\n\";s:9:\"changelog\";s:4682:\"<h4>3.31.5 &#8211; 2025-09-09</h4>\n<ul>\n<li>Fix: Fatal error occurs for non-admin users when editing a page</li>\n</ul>\n<h4>3.31.4 &#8211; 2025-09-08</h4>\n<ul>\n<li>Tweak: Enabled external applications to open AI modals via API</li>\n</ul>\n<h4>3.31.3 &#8211; 2025-08-27</h4>\n<ul>\n<li>Tweak: Disabled indication popover on repeater items – Editor V4</li>\n<li>Tweak: Enforced numeric keys in <code>promotionWidgets</code> and ensured consistent Pro widget injection</li>\n<li>Fix: Floating Bar disappears from the frontend after activating Elementor Pro</li>\n</ul>\n<h4>3.31.2 &#8211; 2025-08-11</h4>\n<ul>\n<li>Tweak: Improved permissions functionality in Class Management &#8211; Editor V4</li>\n<li>Fix: Page failed to save on certain hosting providers due to blocked requests – Editor V4 (<a href=\"https://github.com/elementor/elementor/issues/31992\" rel=\"nofollow ugc\">#31992</a>)</li>\n<li>Fix: Renaming a class causes it to lose applied styles – Editor V4</li>\n<li>Fix: Inherited values not working as expected with custom units in responsive modes – Editor V4</li>\n<li>Fix: Visual Choose control not displaying properly in Firefox for Shape Divider</li>\n<li>Fix: Icon alignment not working in Icon Box widget</li>\n</ul>\n<h4>3.31.1 &#8211; 2025-08-06</h4>\n<ul>\n<li>Tweak: Updated <code>form-data</code> package version</li>\n<li>Fix: Custom order field disappeared when set to 0 or cleared &#8211; Editor V4</li>\n</ul>\n<h4>3.31.0 &#8211; 2025-08-05</h4>\n<ul>\n<li>New: Introducing Variables &#8211; define reusable color and font values to ensure consistent and scalable design across your site &#8211; Editor V4</li>\n<li>New: Introducing Inherited Values &#8211; style properties now indicate when values are inherited from Classes or Base styles &#8211; Editor V4</li>\n<li>New: Introducing Filters &#8211; add visual effects like blur, brightness, and contrast with full design control &#8211; Editor V4</li>\n<li>New: Introducing Backdrop Filters &#8211; apply visual effects behind elements for layered design &#8211; Editor V4</li>\n<li>New: Introducing Divider &#8211; a modular layout element for visual separation &#8211; Editor V4</li>\n<li>New: Class Usage Overview – gain insights into class usage directly from the Class Manager &#8211; Editor V4</li>\n<li>New: Class Locator &#8211; locate all elements using a specific class across your design &#8211; Editor V4</li>\n<li>Tweak: Removed background videos from the accessibility tree to improve screen reader behavior (<a href=\"https://github.com/elementor/elementor/issues/23880\" rel=\"nofollow ugc\">#23880</a>)</li>\n<li>Tweak: Search by Class name &#8211; quickly locate existing classes in the Class Manager &#8211; Editor V4</li>\n<li>Tweak: Improved style detection across breakpoints when using Classes &#8211; Editor V4</li>\n<li>Tweak: Added Custom option to Object Position in Size section &#8211; Editor V4</li>\n<li>Tweak: Added ID control in YouTube element &#8211; Editor V4</li>\n<li>Tweak: Added Opacity control &#8211; set element transparency &#8211; Editor V4</li>\n<li>Tweak: Display Base Style indication &#8211; clearly shows when Base styles are applied to an element &#8211; Editor V4</li>\n<li>Tweak: Improved drag and drop behavior into Flexbox and Div Blocks inside the Canvas &#8211; Editor V4</li>\n<li>Tweak: Replaced select control with a visual choice control in Shape Dividers</li>\n<li>Tweak: Replaced SASS mixins and functions with native CSS logical properties</li>\n<li>Tweak: Added support for <code>lh</code> and <code>rlh</code> CSS units in Typography Line Height control</li>\n<li>Tweak: Added responsive capabilities to Custom Mask</li>\n<li>Tweak: Activated &#8220;Element Caching&#8221; experiment for all sites</li>\n<li>Tweak: Updated Icon List widget to use CSS logical properties</li>\n<li>Tweak: Updated Star Rating widget to use CSS logical properties</li>\n<li>Tweak: Updated Alert widget to use CSS logical properties</li>\n<li>Tweak: Updated Accordion widget to use CSS logical properties</li>\n<li>Tweak: Updated Toggle widget to use CSS logical properties</li>\n<li>Tweak: Updated Icon Box widget to use CSS logical properties</li>\n<li>Tweak: Updated Menu Anchor widget to use CSS logical properties</li>\n<li>Tweak: Updated Tabs widget to use CSS logical properties</li>\n<li>Tweak: Updated Testimonial widget to use CSS logical properties</li>\n<li>Tweak: Updated Text Editor widget to use CSS logical properties</li>\n<li>Tweak: Updated Paragraph Spacing in Site Settings Typography to use CSS logical properties</li>\n<li>Tweak: Optimized CSS output for Masks</li>\n</ul>\n<p><a href=\"https://go.elementor.com/full-changelog/\" rel=\"nofollow ugc\">See changelog for all versions.</a></p>\n\";s:11:\"screenshots\";s:3148:\"<ol><li><a href=\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\" alt=\"&lt;strong&gt;Visual Drag and Drop Editor&lt;/strong&gt; - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.\"></a><p><strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\" alt=\"&lt;strong&gt;Full Design System&lt;/strong&gt; - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.\"></a><p><strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\" alt=\"&lt;strong&gt;Responsive Design&lt;/strong&gt; Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.\"></a><p><strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\" alt=\"&lt;strong&gt;Kits and Templates&lt;/strong&gt; - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.\"></a><p><strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\" alt=\"&lt;strong&gt;Nested Elements&lt;/strong&gt; Leverage Elementor&#039;s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.\"></a><p><strong>Nested Elements</strong> Leverage Elementor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.</p></li><li><a href=\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\"><img src=\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\" alt=\"&lt;strong&gt;Motion Effects&lt;/strong&gt; - Add entrance animations and transitions to any element in your website to captivate visitors.\"></a><p><strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.</p></li></ol>\";s:7:\"reviews\";s:19443:\"<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Elementor Pro es bueno, pero aún puede mejorar</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"3 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"3\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/mexiweb/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/d82d0f33e648c3dc3e0accfb29f3faee5f5ebbf2062e6a0f815f18a92e2a8623?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/d82d0f33e648c3dc3e0accfb29f3faee5f5ebbf2062e6a0f815f18a92e2a8623?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/mexiweb/\" class=\"reviewer-name\">Luis Eduardo Lopez Pacheco <small>(mexiweb)</small></a> on <span class=\"review-date\">September 3, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:quote {\"className\":\"is-style-plain\"} -->\n<blockquote class=\"wp-block-quote\"></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p><strong>Mi experiencia con Elementor Pro ha sido positiva en general, pero considero que todavía tiene bastante margen de mejora.</strong> Aspectos que pueden mejorar</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li><strong>Listado de íconos:</strong> Sería muy útil poder asignar un color distinto a cada ícono de manera individual, en lugar de aplicar un solo color global.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Página de producto individual:</strong> La capacidad de diseño es limitada y muy básica, apenas se pueden hacer personalizaciones.</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>Funciones que podrían agregar</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul><!-- wp:list-item -->\n<li><strong>Filtros avanzados en WooCommerce:</strong> Que los clientes puedan filtrar productos por color, talla, marca, precio, etc.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Barra de inventario en tiempo real:</strong> Una visualización que muestre cómo aumenta o disminuye el stock de cada producto.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Opciones avanzadas para clientes/usuarios:</strong> Sería excelente poder ocultar pestañas o menús del panel de WordPress (como plugins, apariencia, ajustes, etc.) para limitar lo que los clientes pueden ver o modificar.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Personalización de login y registro en WooCommerce:</strong> Sería genial poder diseñar y personalizar la página de inicio de sesión y registro para que los clientes tengan una experiencia más atractiva y profesional al acceder al sitio.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><strong>Más plantillas en Flexbox:</strong> Especialmente en nichos específicos (ejemplo: abogados, médicos, consultores).</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>En conclusión, Elementor Pro es una herramienta muy buena, pero con estas mejoras sería muchísimo más completa y versátil.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">best editor on earth</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/froden17/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/5f69ec7b2e9749df1ac70b35fa09a0c7d6fa9c2cb99498f300c82ed54b165599?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/5f69ec7b2e9749df1ac70b35fa09a0c7d6fa9c2cb99498f300c82ed54b165599?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/froden17/\" class=\"reviewer-name\">froden17</a> on <span class=\"review-date\">September 1, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>best editor on earth !<br /> <br />(except the ai)</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">nice</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/ayush0007/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/1f8908d6f0df9eab9f75e9ca94dc0a6f1983ff3ab3221de41f215a17d20064cd?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/1f8908d6f0df9eab9f75e9ca94dc0a6f1983ff3ab3221de41f215a17d20064cd?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/ayush0007/\" class=\"reviewer-name\">ayush0007</a> on <span class=\"review-date\">September 1, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p><a href=\"http://www.foodchow.com\">very good ym</a></p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">expensive hijack and burned out tech</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"1 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"1\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/pekkie85/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/82491b55785b39164a17a08bb83fbc55a71eedd439f6f602a563a3ea7d695d52?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/82491b55785b39164a17a08bb83fbc55a71eedd439f6f602a563a3ea7d695d52?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/pekkie85/\" class=\"reviewer-name\">pekkie85</a> on <span class=\"review-date\">September 1, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:list {\"ordered\":true} -->\n<ol><!-- wp:list-item -->\n<li>had to rebuild the whole site. <br />its not an addon or an expansion. its a hijack.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>utter waste of money; very heavy, outdated and slow. modern coding practices load much faster and it shows in ure PageSpeed Insights. SEO gets <em>[ expletive deleted, use your words ]</em>.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>horrible tiered support. a dev\'s worst nightmare. 4, 5 times being refferred EACH time you need support. Its organised, i give them that,but so inefficient, timeconsuming and therefore frustrating, and slow.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>most tutorials are outdated. its a joke. deepseek helped me through setup, cuz their own documentation is extensive, but outdated.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li><em>[ Word deleted, next time you may be banned. Don\'t repeat that. ]</em> coding approach. when Elementor hijacks Woo, you have to reset the endpoints, but they dont tell you this, so your order process breaks, putting you out of business. after 24hrs of tiered support you learn that the PRO install hijacked ure endpoints.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>have to make new product layouts for most individual products, as , when you make a template, you have to assign it to a product... in the end you have as many templates as you have products. <em>[ Again, word deleted do not use that word. ]</em> waste of time.</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item -->\n<li>when you try the free, they blackmail you into the pro with disabled features such as \"customise checkout\", which turned out, didnt customise <em>[ expletive deleted, again use your words ]</em>. not typography, not colors, not text fields ( its in the API now)<br />And when you finally stupid enough to go Pro, the whole blackmail starts again for other , pay-extra? features. its been a very costly, dissapointing, -almost deadly to my website- experience.</li>\n<!-- /wp:list-item --></ol>\n<!-- /wp:list --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Promising but shaking</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"2 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"2\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span><span class=\"star dashicons dashicons-star-empty\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/aplaignaud/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/8692212128a76c6add97994dbecac63cd07c32a43c244e6b007ea76ea85683df?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/8692212128a76c6add97994dbecac63cd07c32a43c244e6b007ea76ea85683df?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/aplaignaud/\" class=\"reviewer-name\">aplaignaud</a> on <span class=\"review-date\">August 31, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Interesting builder, much possibly overtaken by the WP editor some day.<br />Needs paid plugins on plugins to be rather complete.<br />Many strange behaviors, you may break your site at any moment.<br />Support, even for fully paid licence, is NOT responding.<br />I don\'t understand the hype around it.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Perfect for Beginners Who Want Quick Results</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/asifhossain1/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/bb899542b0895e2f90d7bd23fdca3850a96b1e6204541dc826a0abe070733743?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/bb899542b0895e2f90d7bd23fdca3850a96b1e6204541dc826a0abe070733743?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/asifhossain1/\" class=\"reviewer-name\">Asif Hossain <small>(asifhossain1)</small></a> on <span class=\"review-date\">August 29, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I love how simple Elementor makes designing a site, even if you have zero experience. The interface is smooth and intuitive, so you can see your ideas come to life instantly. The free version works fine for basics but the best features are locked behind the Pro plan.</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Excellent website builder</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/elmehdibousstani/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/b9c3b49c2442bb23767ad90b6c08984ebc75da5c15142efb65fee5e3f35a094b?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/b9c3b49c2442bb23767ad90b6c08984ebc75da5c15142efb65fee5e3f35a094b?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/elmehdibousstani/\" class=\"reviewer-name\">elmehdibousstani</a> on <span class=\"review-date\">August 27, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>Excellent website builder</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">The absolute best</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/idco1425/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/6b207578282ca788e13570e261404c019531a4f94618d28de79023a80b60764f?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/6b207578282ca788e13570e261404c019531a4f94618d28de79023a80b60764f?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/idco1425/\" class=\"reviewer-name\">idco1425</a> on <span class=\"review-date\">August 26, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I used to use Divi yrs ago, then i found elementor and never looked back. My entire business runs on this incredible plugin. Thanks to a fantastic team</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">I like it</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/pedrogarcia197722/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/013ba8fcbe97d007293d61bf34137edfa998189d6b37252f111e2cbd397079dd?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/013ba8fcbe97d007293d61bf34137edfa998189d6b37252f111e2cbd397079dd?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/pedrogarcia197722/\" class=\"reviewer-name\">pedrogarcia197722</a> on <span class=\"review-date\">August 26, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>One of the best wordpress builder</p>\n<!-- /wp:paragraph --></div>\n</div>\n<div class=\"review\">\n	<div class=\"review-head\">\n		<div class=\"reviewer-info\">\n			<div class=\"review-title-section\">\n				<h4 class=\"review-title\">Facing the white screen issue.</h4>\n				<div class=\"star-rating\">\n				<div class=\"wporg-ratings\" aria-label=\"5 out of 5 stars\" data-title-template=\"%s out of 5 stars\" data-rating=\"5\" style=\"color:#ffb900;\"><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span><span class=\"star dashicons dashicons-star-filled\"></span></div>				</div>\n			</div>\n			<p class=\"reviewer\">\n				By <a href=\"https://profiles.wordpress.org/rahulbasu/\"><img alt=\'\' src=\'https://secure.gravatar.com/avatar/381db4c00d90a714ed769f33ea873e2674e140b0edc6907dd4ad321759109d63?s=16&#038;d=monsterid&#038;r=g\' srcset=\'https://secure.gravatar.com/avatar/381db4c00d90a714ed769f33ea873e2674e140b0edc6907dd4ad321759109d63?s=32&#038;d=monsterid&#038;r=g 2x\' class=\'avatar avatar-16 photo\' height=\'16\' width=\'16\' loading=\'lazy\' decoding=\'async\'/></a><a href=\"https://profiles.wordpress.org/rahulbasu/\" class=\"reviewer-name\">Rahul Basu <small>(rahulbasu)</small></a> on <span class=\"review-date\">August 25, 2025</span>			</p>\n		</div>\n	</div>\n	<div class=\"review-body\"><!-- wp:paragraph -->\n<p>I’ve built my entire blog from scratch with Elementor and love how it lets me customize every detail without touching any code. But sometimes, when I try editing an existing page, it just crashes i.e., the screen stays white forever and I feel helpless :(<br />Does anyone else run into this weird issue?</p>\n<!-- /wp:paragraph --></div>\n</div>\n\";}s:17:\"short_description\";s:145:\"The Elementor Website Builder has it all: drag and drop page builder, pixel perfect design, mobile responsive editing, and more. Get started now!\";s:13:\"download_link\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.5.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-1.gif?rev=3005087\";s:7:\"caption\";s:144:\"<strong>Visual Drag and Drop Editor</strong> - Design your website layouts and place any element anywhere on the page for pixel-perfect designs.\";}i:2;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-2.gif?rev=3005087\";s:7:\"caption\";s:185:\"<strong>Full Design System</strong> - Enjoy a professional workflow and ensure consistency across your site. Define your settings, use them globally, and instantly adjust them any time.\";}i:3;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-3.gif?rev=3005087\";s:7:\"caption\";s:170:\"<strong>Responsive Design</strong> Fully edit your website and customize the behavior on desktop, tablet, &amp; mobile to optimize the visitor experience on every device.\";}i:4;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-4.gif?rev=3005087\";s:7:\"caption\";s:193:\"<strong>Kits and Templates</strong> - Jumpstart your web creation process or get inspired with professionally-designed templates or full website kits available for your immediate customization.\";}i:5;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-5.gif?rev=3005087\";s:7:\"caption\";s:190:\"<strong>Nested Elements</strong> Leverage Elementor\'s Nested widgets to place any widget inside the content area of another widget - like Tabs, and Accordion for complete design flexibility.\";}i:6;a:2:{s:3:\"src\";s:62:\"https://ps.w.org/elementor/assets/screenshot-6.gif?rev=3005087\";s:7:\"caption\";s:127:\"<strong>Motion Effects</strong> - Add entrance animations and transitions to any element in your website to captivate visitors.\";}}s:4:\"tags\";a:5:{s:13:\"drag-and-drop\";s:13:\"drag-and-drop\";s:6:\"editor\";s:6:\"editor\";s:9:\"elementor\";s:9:\"elementor\";s:12:\"landing-page\";s:12:\"landing page\";s:12:\"page-builder\";s:12:\"page builder\";}s:8:\"versions\";a:360:{s:5:\"3.0.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.0.zip\";s:5:\"3.0.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.1.zip\";s:6:\"3.0.10\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.10.zip\";s:6:\"3.0.11\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.11.zip\";s:6:\"3.0.12\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.12.zip\";s:6:\"3.0.13\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.13.zip\";s:6:\"3.0.14\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.14.zip\";s:6:\"3.0.15\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.15.zip\";s:6:\"3.0.16\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.0.16.zip\";s:5:\"3.0.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.2.zip\";s:5:\"3.0.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.3.zip\";s:5:\"3.0.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.4.zip\";s:5:\"3.0.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.5.zip\";s:5:\"3.0.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.6.zip\";s:5:\"3.0.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.7.zip\";s:5:\"3.0.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.8.zip\";s:7:\"3.0.8.1\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.0.8.1.zip\";s:5:\"3.0.9\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.9.zip\";s:5:\"3.1.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.0.zip\";s:11:\"3.1.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta1.zip\";s:11:\"3.1.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta2.zip\";s:11:\"3.1.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta3.zip\";s:11:\"3.1.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-beta4.zip\";s:10:\"3.1.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev1.zip\";s:10:\"3.1.0-dev2\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev2.zip\";s:10:\"3.1.0-dev3\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.1.0-dev3.zip\";s:5:\"3.1.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.1.zip\";s:5:\"3.1.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.2.zip\";s:5:\"3.1.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.3.zip\";s:5:\"3.1.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.1.4.zip\";s:6:\"3.10.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.0.zip\";s:11:\"3.10.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.10.0-dev1.zip\";s:6:\"3.10.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.1.zip\";s:6:\"3.10.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.10.2.zip\";s:6:\"3.11.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.0.zip\";s:12:\"3.11.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta1.zip\";s:12:\"3.11.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta2.zip\";s:12:\"3.11.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-beta3.zip\";s:11:\"3.11.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev1.zip\";s:11:\"3.11.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev2.zip\";s:11:\"3.11.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.11.0-dev3.zip\";s:6:\"3.11.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.1.zip\";s:6:\"3.11.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.2.zip\";s:6:\"3.11.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.3.zip\";s:6:\"3.11.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.4.zip\";s:6:\"3.11.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.11.5.zip\";s:6:\"3.12.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.0.zip\";s:6:\"3.12.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.1.zip\";s:6:\"3.12.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.12.2.zip\";s:6:\"3.13.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.0.zip\";s:12:\"3.13.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta1.zip\";s:12:\"3.13.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta2.zip\";s:12:\"3.13.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-beta3.zip\";s:11:\"3.13.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev3.zip\";s:11:\"3.13.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.13.0-dev4.zip\";s:6:\"3.13.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.1.zip\";s:6:\"3.13.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.2.zip\";s:6:\"3.13.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.3.zip\";s:6:\"3.13.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.13.4.zip\";s:6:\"3.14.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.14.0.zip\";s:12:\"3.14.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta1.zip\";s:12:\"3.14.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta2.zip\";s:12:\"3.14.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta3.zip\";s:12:\"3.14.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta4.zip\";s:12:\"3.14.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.14.0-beta5.zip\";s:6:\"3.14.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.14.1.zip\";s:6:\"3.15.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.0.zip\";s:6:\"3.15.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.1.zip\";s:6:\"3.15.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.2.zip\";s:6:\"3.15.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.15.3.zip\";s:6:\"3.16.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.0.zip\";s:12:\"3.16.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta3.zip\";s:12:\"3.16.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-beta4.zip\";s:11:\"3.16.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev1.zip\";s:11:\"3.16.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.16.0-dev2.zip\";s:6:\"3.16.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.1.zip\";s:6:\"3.16.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.2.zip\";s:6:\"3.16.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.3.zip\";s:6:\"3.16.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.4.zip\";s:6:\"3.16.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.5.zip\";s:6:\"3.16.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.16.6.zip\";s:6:\"3.17.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.0.zip\";s:11:\"3.17.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev2.zip\";s:11:\"3.17.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev3.zip\";s:11:\"3.17.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.17.0-dev4.zip\";s:6:\"3.17.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.1.zip\";s:6:\"3.17.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.2.zip\";s:6:\"3.17.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.17.3.zip\";s:6:\"3.18.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.0.zip\";s:12:\"3.18.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta1.zip\";s:12:\"3.18.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta2.zip\";s:12:\"3.18.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta3.zip\";s:12:\"3.18.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-beta4.zip\";s:11:\"3.18.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.18.0-dev1.zip\";s:6:\"3.18.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.1.zip\";s:6:\"3.18.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.2.zip\";s:6:\"3.18.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.18.3.zip\";s:6:\"3.19.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.0.zip\";s:12:\"3.19.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta1.zip\";s:12:\"3.19.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta2.zip\";s:12:\"3.19.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta3.zip\";s:12:\"3.19.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta4.zip\";s:12:\"3.19.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta5.zip\";s:12:\"3.19.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-beta6.zip\";s:11:\"3.19.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev1.zip\";s:11:\"3.19.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev2.zip\";s:11:\"3.19.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev3.zip\";s:11:\"3.19.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev4.zip\";s:11:\"3.19.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev5.zip\";s:11:\"3.19.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.19.0-dev6.zip\";s:6:\"3.19.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.1.zip\";s:6:\"3.19.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.2.zip\";s:6:\"3.19.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.3.zip\";s:6:\"3.19.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.19.4.zip\";s:5:\"3.2.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.0.zip\";s:5:\"3.2.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.1.zip\";s:5:\"3.2.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.2.zip\";s:5:\"3.2.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.3.zip\";s:5:\"3.2.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.4.zip\";s:5:\"3.2.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.2.5.zip\";s:6:\"3.20.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.0.zip\";s:12:\"3.20.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta1.zip\";s:12:\"3.20.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta2.zip\";s:12:\"3.20.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta3.zip\";s:12:\"3.20.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-beta4.zip\";s:11:\"3.20.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev1.zip\";s:11:\"3.20.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev2.zip\";s:11:\"3.20.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev3.zip\";s:11:\"3.20.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.20.0-dev4.zip\";s:6:\"3.20.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.1.zip\";s:6:\"3.20.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.2.zip\";s:6:\"3.20.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.3.zip\";s:6:\"3.20.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.20.4.zip\";s:6:\"3.21.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.0.zip\";s:12:\"3.21.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta1.zip\";s:12:\"3.21.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta2.zip\";s:12:\"3.21.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-beta3.zip\";s:11:\"3.21.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev1.zip\";s:11:\"3.21.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev2.zip\";s:11:\"3.21.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.21.0-dev3.zip\";s:6:\"3.21.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.1.zip\";s:6:\"3.21.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.2.zip\";s:6:\"3.21.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.3.zip\";s:6:\"3.21.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.4.zip\";s:6:\"3.21.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.5.zip\";s:6:\"3.21.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.6.zip\";s:6:\"3.21.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.7.zip\";s:6:\"3.21.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.21.8.zip\";s:6:\"3.22.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.0.zip\";s:12:\"3.22.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta1.zip\";s:12:\"3.22.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta2.zip\";s:12:\"3.22.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta3.zip\";s:12:\"3.22.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta4.zip\";s:12:\"3.22.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta5.zip\";s:12:\"3.22.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-beta6.zip\";s:11:\"3.22.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev1.zip\";s:11:\"3.22.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev2.zip\";s:11:\"3.22.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev3.zip\";s:11:\"3.22.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev4.zip\";s:11:\"3.22.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev5.zip\";s:11:\"3.22.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.22.0-dev6.zip\";s:6:\"3.22.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.1.zip\";s:6:\"3.22.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.2.zip\";s:6:\"3.22.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.22.3.zip\";s:6:\"3.23.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.0.zip\";s:12:\"3.23.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta1.zip\";s:12:\"3.23.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta2.zip\";s:12:\"3.23.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta3.zip\";s:12:\"3.23.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta4.zip\";s:12:\"3.23.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta5.zip\";s:12:\"3.23.0-beta6\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-beta6.zip\";s:11:\"3.23.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev1.zip\";s:11:\"3.23.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev2.zip\";s:11:\"3.23.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev3.zip\";s:11:\"3.23.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev4.zip\";s:11:\"3.23.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev5.zip\";s:11:\"3.23.0-dev6\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.23.0-dev6.zip\";s:6:\"3.23.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.1.zip\";s:6:\"3.23.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.2.zip\";s:6:\"3.23.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.3.zip\";s:6:\"3.23.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.23.4.zip\";s:6:\"3.24.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.0.zip\";s:12:\"3.24.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta1.zip\";s:12:\"3.24.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta2.zip\";s:12:\"3.24.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-beta3.zip\";s:11:\"3.24.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev1.zip\";s:11:\"3.24.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev2.zip\";s:11:\"3.24.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.24.0-dev3.zip\";s:6:\"3.24.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.1.zip\";s:6:\"3.24.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.2.zip\";s:6:\"3.24.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.3.zip\";s:6:\"3.24.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.4.zip\";s:6:\"3.24.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.5.zip\";s:6:\"3.24.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.6.zip\";s:6:\"3.24.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.7.zip\";s:6:\"3.24.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.24.8.zip\";s:6:\"3.25.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.0.zip\";s:12:\"3.25.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta1.zip\";s:12:\"3.25.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta2.zip\";s:12:\"3.25.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-beta3.zip\";s:11:\"3.25.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev1.zip\";s:11:\"3.25.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev2.zip\";s:11:\"3.25.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.25.0-dev3.zip\";s:6:\"3.25.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.1.zip\";s:7:\"3.25.10\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.25.10.zip\";s:7:\"3.25.11\";s:60:\"https://downloads.wordpress.org/plugin/elementor.3.25.11.zip\";s:6:\"3.25.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.2.zip\";s:6:\"3.25.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.3.zip\";s:6:\"3.25.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.4.zip\";s:6:\"3.25.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.5.zip\";s:6:\"3.25.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.6.zip\";s:6:\"3.25.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.7.zip\";s:6:\"3.25.8\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.8.zip\";s:6:\"3.25.9\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.25.9.zip\";s:6:\"3.26.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.0.zip\";s:12:\"3.26.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta1.zip\";s:12:\"3.26.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta2.zip\";s:12:\"3.26.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta3.zip\";s:12:\"3.26.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta4.zip\";s:12:\"3.26.0-beta5\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-beta5.zip\";s:11:\"3.26.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev1.zip\";s:11:\"3.26.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev2.zip\";s:11:\"3.26.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev3.zip\";s:11:\"3.26.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev4.zip\";s:11:\"3.26.0-dev5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.26.0-dev5.zip\";s:6:\"3.26.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.1.zip\";s:6:\"3.26.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.2.zip\";s:6:\"3.26.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.3.zip\";s:6:\"3.26.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.4.zip\";s:6:\"3.26.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.26.5.zip\";s:6:\"3.27.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.0.zip\";s:12:\"3.27.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta1.zip\";s:12:\"3.27.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-beta2.zip\";s:11:\"3.27.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev1.zip\";s:11:\"3.27.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.27.0-dev2.zip\";s:6:\"3.27.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.1.zip\";s:6:\"3.27.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.2.zip\";s:6:\"3.27.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.3.zip\";s:6:\"3.27.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.4.zip\";s:6:\"3.27.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.5.zip\";s:6:\"3.27.6\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.6.zip\";s:6:\"3.27.7\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.27.7.zip\";s:6:\"3.28.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.0.zip\";s:12:\"3.28.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta1.zip\";s:12:\"3.28.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta2.zip\";s:12:\"3.28.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-beta3.zip\";s:11:\"3.28.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev1.zip\";s:11:\"3.28.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev2.zip\";s:11:\"3.28.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.28.0-dev3.zip\";s:6:\"3.28.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.1.zip\";s:6:\"3.28.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.2.zip\";s:6:\"3.28.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.3.zip\";s:6:\"3.28.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.4.zip\";s:6:\"3.29.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.0.zip\";s:12:\"3.29.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta1.zip\";s:12:\"3.29.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta2.zip\";s:12:\"3.29.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta3.zip\";s:12:\"3.29.0-beta4\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-beta4.zip\";s:11:\"3.29.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev1.zip\";s:11:\"3.29.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev2.zip\";s:11:\"3.29.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev3.zip\";s:11:\"3.29.0-dev4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.29.0-dev4.zip\";s:6:\"3.29.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.1.zip\";s:6:\"3.29.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.2.zip\";s:5:\"3.3.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.3.0.zip\";s:5:\"3.3.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.3.1.zip\";s:6:\"3.30.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.0.zip\";s:12:\"3.30.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta1.zip\";s:12:\"3.30.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta2.zip\";s:12:\"3.30.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-beta3.zip\";s:11:\"3.30.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev1.zip\";s:11:\"3.30.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev2.zip\";s:11:\"3.30.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.30.0-dev3.zip\";s:6:\"3.30.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.1.zip\";s:6:\"3.30.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.2.zip\";s:6:\"3.30.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.3.zip\";s:6:\"3.30.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.4.zip\";s:6:\"3.31.0\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.0.zip\";s:12:\"3.31.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta1.zip\";s:12:\"3.31.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-beta2.zip\";s:11:\"3.31.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev1.zip\";s:11:\"3.31.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.31.0-dev2.zip\";s:6:\"3.31.1\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.1.zip\";s:6:\"3.31.2\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.2.zip\";s:6:\"3.31.3\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.3.zip\";s:6:\"3.31.4\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.4.zip\";s:6:\"3.31.5\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.31.5.zip\";s:12:\"3.32.0-beta1\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta1.zip\";s:12:\"3.32.0-beta2\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta2.zip\";s:12:\"3.32.0-beta3\";s:65:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-beta3.zip\";s:11:\"3.32.0-dev1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev1.zip\";s:11:\"3.32.0-dev2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev2.zip\";s:11:\"3.32.0-dev3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.32.0-dev3.zip\";s:5:\"3.4.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.0.zip\";s:10:\"3.4.0-dev7\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev7.zip\";s:10:\"3.4.0-dev8\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev8.zip\";s:10:\"3.4.0-dev9\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.4.0-dev9.zip\";s:5:\"3.4.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.1.zip\";s:5:\"3.4.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.2.zip\";s:5:\"3.4.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.3.zip\";s:5:\"3.4.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.4.zip\";s:5:\"3.4.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.5.zip\";s:5:\"3.4.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.6.zip\";s:5:\"3.4.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.7.zip\";s:5:\"3.4.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.4.8.zip\";s:5:\"3.5.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.0.zip\";s:11:\"3.5.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta1.zip\";s:11:\"3.5.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta2.zip\";s:11:\"3.5.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta3.zip\";s:11:\"3.5.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta4.zip\";s:11:\"3.5.0-beta5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta5.zip\";s:11:\"3.5.0-beta7\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta7.zip\";s:11:\"3.5.0-beta8\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-beta8.zip\";s:10:\"3.5.0-dev8\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev8.zip\";s:10:\"3.5.0-dev9\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.5.0-dev9.zip\";s:5:\"3.5.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.1.zip\";s:5:\"3.5.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.2.zip\";s:5:\"3.5.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.3.zip\";s:5:\"3.5.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.4.zip\";s:5:\"3.5.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.5.zip\";s:5:\"3.5.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.5.6.zip\";s:5:\"3.6.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:11:\"3.6.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta1.zip\";s:11:\"3.6.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta2.zip\";s:11:\"3.6.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta3.zip\";s:11:\"3.6.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta4.zip\";s:11:\"3.6.0-beta5\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-beta5.zip\";s:10:\"3.6.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev1.zip\";s:11:\"3.6.0-dev10\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.6.0-dev10.zip\";s:5:\"3.6.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.1.zip\";s:5:\"3.6.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.2.zip\";s:5:\"3.6.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.3.zip\";s:5:\"3.6.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.4.zip\";s:5:\"3.6.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.5.zip\";s:5:\"3.6.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.6.zip\";s:5:\"3.6.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.7.zip\";s:5:\"3.6.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.8.zip\";s:5:\"3.7.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.0.zip\";s:11:\"3.7.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta1.zip\";s:11:\"3.7.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta2.zip\";s:11:\"3.7.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta3.zip\";s:11:\"3.7.0-beta4\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-beta4.zip\";s:10:\"3.7.0-dev1\";s:63:\"https://downloads.wordpress.org/plugin/elementor.3.7.0-dev1.zip\";s:5:\"3.7.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.1.zip\";s:5:\"3.7.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.2.zip\";s:5:\"3.7.3\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.3.zip\";s:5:\"3.7.4\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.4.zip\";s:5:\"3.7.5\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.5.zip\";s:5:\"3.7.6\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.6.zip\";s:5:\"3.7.7\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.7.zip\";s:5:\"3.7.8\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.7.8.zip\";s:5:\"3.8.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.8.0.zip\";s:11:\"3.8.0-beta1\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta1.zip\";s:11:\"3.8.0-beta2\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta2.zip\";s:11:\"3.8.0-beta3\";s:64:\"https://downloads.wordpress.org/plugin/elementor.3.8.0-beta3.zip\";s:5:\"3.8.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.8.1.zip\";s:5:\"3.9.0\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.0.zip\";s:5:\"3.9.1\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.1.zip\";s:5:\"3.9.2\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.9.2.zip\";s:5:\"trunk\";s:52:\"https://downloads.wordpress.org/plugin/elementor.zip\";}s:14:\"business_model\";s:10:\"commercial\";s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:94:\"https://elementor.com/support/?utm_source=wp-repo&utm_medium=link&utm_campaign=premium-support\";s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";s:4:\"high\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";}s:5:\"icons\";a:2:{s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";}s:12:\"preview_link\";s:0:\"\";s:4:\"Name\";s:63:\"Elementor Website Builder &#8211; More Than Just a Page Builder\";}}", "off");
INSERT INTO `wpvv_options` VALUES("185", "recently_activated", "a:1:{s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";i:1757509827;}", "off");
INSERT INTO `wpvv_options` VALUES("188", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wpvv_options` VALUES("196", "elementor_active_kit", "6", "auto");
INSERT INTO `wpvv_options` VALUES("197", "elementor_font_display", "swap", "auto");
INSERT INTO `wpvv_options` VALUES("200", "elementor_landing_pages_activation", "0", "auto");
INSERT INTO `wpvv_options` VALUES("201", "elementor_checklist", "{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":true,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header_pro\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":false}", "auto");
INSERT INTO `wpvv_options` VALUES("202", "elementor_version", "3.31.5", "auto");
INSERT INTO `wpvv_options` VALUES("203", "elementor_install_history", "a:2:{s:6:\"3.31.2\";i:1755155328;s:6:\"3.31.5\";i:1757508902;}", "auto");
INSERT INTO `wpvv_options` VALUES("204", "elementor_events_db_version", "1.0.0", "off");
INSERT INTO `wpvv_options` VALUES("206", "elementor_onboarded", "1", "auto");
INSERT INTO `wpvv_options` VALUES("207", "_elementor_installed_time", "1755155334", "auto");
INSERT INTO `wpvv_options` VALUES("208", "elementor_connect_site_key", "0f542a45206242c57d010cfb80f2477f", "auto");
INSERT INTO `wpvv_options` VALUES("209", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wpvv_options` VALUES("210", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:100:\"Introducing Elementor 3.30: new Editor V4 capabilities, full Website Templates in the cloud, & more!\";s:7:\"excerpt\";s:361:\"Elementor 3.30 is here and it includes upgrades that accelerate your workflow, bring you a step closer to the full power of Editor V4, and help you deliver beautiful, accessible websites faster than ever. From advanced styling tools and smarter editing to full Website Templates in the cloud, this release enhances both the way you design and the way you scale.\";s:7:\"created\";i:1751974442;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-330-v4-alpha-website-templates/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wpvv_options` VALUES("220", "current_theme", "Hello Elementor Child", "auto");
INSERT INTO `wpvv_options` VALUES("221", "theme_mods_hello-theme-child-master", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:6:\"menu-1\";i:3;s:6:\"menu-2\";i:0;}s:18:\"custom_css_post_id\";i:27;s:11:\"custom_logo\";i:19;}", "on");
INSERT INTO `wpvv_options` VALUES("222", "theme_switched", "", "auto");
INSERT INTO `wpvv_options` VALUES("223", "hello_theme_version", "3.4.4", "auto");
INSERT INTO `wpvv_options` VALUES("228", "_hello-elementor_notifications", "a:2:{s:7:\"timeout\";i:1757527436;s:5:\"value\";s:7532:\"[{\"id\":\"hello-theme-3.4.4\",\"title\":\"3.4.4 - 2025-06-08\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Improve Header\\/Footer edit access from theme Home<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.3\",\"title\":\"3.4.3 - 2025-05-26\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Fix: Settings page empty after 3.4.0 in translated sites<\\/li>\\n\\t\\t\\t\\t<li>Fix: PHP 8.4 deprecation notice<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.2\",\"title\":\"3.4.2 - 2025-05-19\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Set Home links font weight to regular<\\/li>\\n  \\t\\t        <li>Tweak: Dart SASS 3.0.0 - resolve scss deprecated warnings<\\/li>\\n    \\t\\t    <li>Fix: Settings page empty after 3.4.0<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.0\",\"title\":\"3.4.0 - 2025-05-05\",\"description\":\"\\n            <ul>\\n                <li>New: Added Theme Home<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update theme settings page style<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update tested up to version 6.8<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.3.0\",\"title\":\"3.3.0 - 2025-01-21\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Added changelog link in theme settings<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n  \\t\\t        <li>Tweak: Update autoprefixer to latest versions<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.1\",\"title\":\"3.2.1 - 2024-12-16\",\"description\":\"\\n            <ul>\\n                <li>\\n                    Fix: Gutenberg editor expanded disproportionately after adding support for <code>theme.json<\\/code>\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/430\\\" target=\\\"_blank\\\">#430<\\/a>)\\n                <\\/li>\\n                <li>Fix: Use CSS logical properties in the theme<\\/li>\\n                <li>Fix: Add ARIA attributes to header nav menu<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.0\",\"title\":\"3.2.0 - 2024-12-15\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Convert classic to hybrid theme with block-editor support<\\/li>\\n                <li>Tweak: Added new design options to header\\/footer<\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.7<\\/code><\\/li>\\n                <li>\\n                    Fix: Minify JS files\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/419\\\" target=\\\"_blank\\\">#419<\\/a>)\\n                <\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.1\",\"title\":\"3.1.1 - 2024-07-30\",\"description\":\"\\n            <ul>\\n                <li>Fix: Use consistent <code>&lt;h2&gt;<\\/code> for comments title and comment form<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.0\",\"title\":\"3.1.0 - 2024-06-19\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Update <code>Requires PHP 7.4<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.5<\\/code><\\/li>\\n                <li>Tweak: Add the ability to style the brand layout<\\/li>\\n                <li>Tweak: Remove deprecated Elementor code<\\/li>\\n                <li>Tweak: Restore default focus styling inside the theme<\\/li>\\n                <li>Tweak: Add <code>aria-label<\\/code> attribute to various <code>&lt;nav&gt;<\\/code> elements<\\/li>\\n                <li>Tweak: Improve mobile menu keyboard accessibility<\\/li>\\n                <li>Tweak: Semantic mobile menu toggle button<\\/li>\\n                <li>Fix: The header renders redundant <code>&lt;p&gt;<\\/code> when tagline is empty<\\/li>\\n                <li>Fix: Single post renders redundant wrapping <code>&lt;div&gt;<\\/code> when it has no tags<\\/li>\\n                <li>Fix: Remove redundant wrapping <code>&lt;div&gt;<\\/code> from <code>wp_nav_menu()<\\/code> output<\\/li>\\n                <li>Fix: Wrap page <code>&lt;h1&gt;<\\/code> with <code>&lt;div&gt;<\\/code>, not <code>&lt;header&gt;<\\/code><\\/li>\\n                <li>Fix: Use consistent <code>&lt;h3&gt;<\\/code> for comments title and comment form<\\/li>\\n                <li>Fix: Remove heading tags from dynamic header\\/footer<\\/li>\\n                <li>\\n                    Fix: Mobile Menu hamburger is not visible for logged-out users in some cases\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/369\\\" target=\\\"_blank\\\">#369<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove duplicate ID attributes in the header mobile menu<\\/li>\\n                <li>\\n                    Fix: Remove redundant table styles\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/311\\\" target=\\\"_blank\\\">#311<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove redundant space below Site Logo in the header\\/footer<\\/li>\\n                <li>Fix: Remove redundant CSS from dynamic header\\/footer layout<\\/li>\\n                <li>\\n                    Fix: Separate post tags in single post\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/304\\\" target=\\\"_blank\\\">#304<\\/a>)\\n                <\\/li>\\n                <li>Fix: Display <code>the_tags()<\\/code> after <code>wp_link_pages()<\\/code><\\/li>\\n                <li>Fix: Remove page break navigation from archives when using <code>&lt;!--nextpage--&gt;<\\/code><\\/li>\\n                <li>Fix: Style posts pagination component layout<\\/li>\\n                <li>Fix: Add RTL support to pagination arrows in archive pages<\\/li>\\n                <li>\\n                    Fix: Update pagination prev\\/next labels and positions\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/404\\\" target=\\\"_blank\\\">#404<\\/a>)\\n                <\\/li>\\n                <li>Fix: Check if Elementor is loaded when using dynamic header & footer<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.2\",\"title\":\"3.0.2 - 2024-05-28\",\"description\":\"\\n            <ul>\\n                <li>Internal: Version bump release to refresh WordPress repository<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.1\",\"title\":\"3.0.1 - 2024-01-24\",\"description\":\"\\n            <ul>\\n                <li>Fix: Harden security for admin notice dismiss button<\\/li>\\n                <li>Fix: Add <code>alt<\\/code> attribute to all the images in the dashboard<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.0\",\"title\":\"3.0.0 - 2023-12-26\",\"description\":\"\\n            <ul>\\n                <li>New: Option to disable cross-site header & footer<\\/li>\\n                <li>Tweak: Update <code>Requires PHP 7.3<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.4<\\/code><\\/li>\\n                <li>Tweak: Move cross-site header & footer styles to a separate CSS file<\\/li>\\n                <li>Tweak: Don\'t load <code>header-footer.min.css<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Don\'t load <code>hello-frontend.min.js<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in the frontend<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in WordPress admin<\\/li>\\n                <li>Tweak: Remove unused JS code from the frontend<\\/li>\\n                <li>Tweak: Remove unused CSS code from the editor<\\/li>\\n                <li>Tweak: Remove unnecessary <code>role<\\/code> attributes from HTML landmark elements<\\/li>\\n                <li>Tweak: Link from Elementor Site Settings to Hello Theme Settings<\\/li>\\n                <li>Fix: Dynamic script version for better caching<\\/li>\\n            <\\/ul>\"}]\";}", "off");
INSERT INTO `wpvv_options` VALUES("231", "bodhi_svgs_settings", "a:3:{s:22:\"sanitize_svg_front_end\";s:2:\"on\";s:8:\"restrict\";a:1:{i:0;s:13:\"administrator\";}s:24:\"sanitize_on_upload_roles\";a:0:{}}", "auto");
INSERT INTO `wpvv_options` VALUES("232", "bodhi_svgs_plugin_version", "2.5.14", "auto");
INSERT INTO `wpvv_options` VALUES("239", "_elementor_local_google_fonts", "a:5:{s:6:\"roboto\";a:2:{s:3:\"url\";s:98:\"https://fm-connect1.fortmindz.in/wp-mpacs/wp-content/uploads/elementor/google-fonts/css/roboto.css\";s:7:\"version\";i:1755155587;}s:10:\"robotoslab\";a:2:{s:3:\"url\";s:102:\"https://fm-connect1.fortmindz.in/wp-mpacs/wp-content/uploads/elementor/google-fonts/css/robotoslab.css\";s:7:\"version\";i:1755155599;}s:7:\"manrope\";a:2:{s:3:\"url\";s:99:\"https://fm-connect1.fortmindz.in/wp-mpacs/wp-content/uploads/elementor/google-fonts/css/manrope.css\";s:7:\"version\";i:1755156396;}s:7:\"poppins\";a:2:{s:3:\"url\";s:99:\"https://fm-connect1.fortmindz.in/wp-mpacs/wp-content/uploads/elementor/google-fonts/css/poppins.css\";s:7:\"version\";i:1755157831;}s:10:\"montserrat\";a:2:{s:3:\"url\";s:102:\"https://fm-connect1.fortmindz.in/wp-mpacs/wp-content/uploads/elementor/google-fonts/css/montserrat.css\";s:7:\"version\";i:1755523593;}}", "auto");
INSERT INTO `wpvv_options` VALUES("244", "elementor_pro_version", "3.31.2", "auto");
INSERT INTO `wpvv_options` VALUES("245", "elementor_pro_install_history", "a:2:{s:6:\"3.26.3\";i:1755155658;s:6:\"3.31.2\";i:1755511753;}", "auto");
INSERT INTO `wpvv_options` VALUES("246", "widget_elementor-library", "a:2:{i:2;a:1:{s:24:\"mega_menu_is_grid_widget\";s:4:\"true\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("247", "_elementor_pro_installed_time", "1755155658", "auto");
INSERT INTO `wpvv_options` VALUES("248", "elementor_submissions_db_version", "5", "auto");
INSERT INTO `wpvv_options` VALUES("249", "elementor_allow_tracking", "yes", "auto");
INSERT INTO `wpvv_options` VALUES("250", "elementor_allow_tracking_last_update", "1755155683", "auto");
INSERT INTO `wpvv_options` VALUES("251", "elementor_tracker_last_send", "1757150501", "auto");
INSERT INTO `wpvv_options` VALUES("256", "elementor_pro_license_key", "ecp-5jp0qJaIFwWD0OAm7W1d1753860118OUjCknOwoIsk", "auto");
INSERT INTO `wpvv_options` VALUES("257", "_elementor_pro_license_v2_data_fallback", "a:2:{s:7:\"timeout\";i:1757569980;s:5:\"value\";s:2814:\"{\"expires\":\"2026-07-30 00:00:00\",\"subscription_id\":\"A-S02182668\",\"status\":\"ACTIVE\",\"recurring\":true,\"features\":[\"template_access_level_20\",\"kit_access_level_20\",\"activity-log\",\"breadcrumbs\",\"form\",\"posts\",\"template\",\"countdown\",\"slides\",\"price-list\",\"portfolio\",\"flip-box\",\"price-table\",\"login\",\"share-buttons\",\"theme-post-content\",\"theme-post-title\",\"nav-menu\",\"blockquote\",\"media-carousel\",\"animated-headline\",\"facebook-comments\",\"facebook-embed\",\"facebook-page\",\"facebook-button\",\"testimonial-carousel\",\"post-navigation\",\"search-form\",\"post-comments\",\"author-box\",\"call-to-action\",\"post-info\",\"theme-site-logo\",\"theme-site-title\",\"theme-archive-title\",\"theme-post-excerpt\",\"theme-post-featured-image\",\"archive-posts\",\"theme-page-title\",\"sitemap\",\"reviews\",\"table-of-contents\",\"lottie\",\"code-highlight\",\"hotspot\",\"video-playlist\",\"progress-tracker\",\"section-effects\",\"sticky\",\"scroll-snap\",\"page-transitions\",\"mega-menu\",\"nested-carousel\",\"loop-grid\",\"loop-carousel\",\"theme-builder\",\"elementor_icons\",\"elementor_custom_fonts\",\"dynamic-tags\",\"taxonomy-filter\",\"email\",\"email2\",\"mailpoet\",\"mailpoet3\",\"redirect\",\"header\",\"footer\",\"single-post\",\"single-page\",\"archive\",\"search-results\",\"error-404\",\"loop-item\",\"font-awesome-pro\",\"typekit\",\"gallery\",\"off-canvas\",\"link-in-bio-var-2\",\"link-in-bio-var-3\",\"link-in-bio-var-4\",\"link-in-bio-var-5\",\"link-in-bio-var-6\",\"link-in-bio-var-7\",\"search\",\"size-variable\",\"element-manager-permissions\",\"akismet\",\"display-conditions\",\"woocommerce-products\",\"wc-products\",\"woocommerce-product-add-to-cart\",\"wc-elements\",\"wc-categories\",\"woocommerce-product-price\",\"woocommerce-product-title\",\"woocommerce-product-images\",\"woocommerce-product-upsell\",\"woocommerce-product-short-description\",\"woocommerce-product-meta\",\"woocommerce-product-stock\",\"woocommerce-product-rating\",\"wc-add-to-cart\",\"dynamic-tags-wc\",\"woocommerce-product-data-tabs\",\"woocommerce-product-related\",\"woocommerce-breadcrumb\",\"wc-archive-products\",\"woocommerce-archive-products\",\"woocommerce-product-additional-information\",\"woocommerce-menu-cart\",\"woocommerce-product-content\",\"woocommerce-archive-description\",\"paypal-button\",\"woocommerce-checkout-page\",\"woocommerce-cart\",\"woocommerce-my-account\",\"woocommerce-purchase-summary\",\"woocommerce-notices\",\"settings-woocommerce-pages\",\"settings-woocommerce-notices\",\"popup\",\"custom-css\",\"global-css\",\"custom_code\",\"custom-attributes\",\"form-submissions\",\"form-integrations\",\"dynamic-tags-acf\",\"dynamic-tags-pods\",\"dynamic-tags-toolset\",\"editor_comments\",\"stripe-button\",\"role-manager\",\"global-widget\",\"activecampaign\",\"cf7db\",\"convertkit\",\"discord\",\"drip\",\"getresponse\",\"mailchimp\",\"mailerlite\",\"slack\",\"webhook\",\"product-single\",\"product-archive\",\"wc-single-elements\",\"atomic-custom-attributes\"],\"tier\":\"expert\",\"generation\":\"empty\",\"activated\":true,\"success\":true}\";}", "off");
INSERT INTO `wpvv_options` VALUES("258", "_elementor_pro_license_v2_data", "a:2:{s:7:\"timeout\";i:1757526780;s:5:\"value\";s:2814:\"{\"expires\":\"2026-07-30 00:00:00\",\"subscription_id\":\"A-S02182668\",\"status\":\"ACTIVE\",\"recurring\":true,\"features\":[\"template_access_level_20\",\"kit_access_level_20\",\"activity-log\",\"breadcrumbs\",\"form\",\"posts\",\"template\",\"countdown\",\"slides\",\"price-list\",\"portfolio\",\"flip-box\",\"price-table\",\"login\",\"share-buttons\",\"theme-post-content\",\"theme-post-title\",\"nav-menu\",\"blockquote\",\"media-carousel\",\"animated-headline\",\"facebook-comments\",\"facebook-embed\",\"facebook-page\",\"facebook-button\",\"testimonial-carousel\",\"post-navigation\",\"search-form\",\"post-comments\",\"author-box\",\"call-to-action\",\"post-info\",\"theme-site-logo\",\"theme-site-title\",\"theme-archive-title\",\"theme-post-excerpt\",\"theme-post-featured-image\",\"archive-posts\",\"theme-page-title\",\"sitemap\",\"reviews\",\"table-of-contents\",\"lottie\",\"code-highlight\",\"hotspot\",\"video-playlist\",\"progress-tracker\",\"section-effects\",\"sticky\",\"scroll-snap\",\"page-transitions\",\"mega-menu\",\"nested-carousel\",\"loop-grid\",\"loop-carousel\",\"theme-builder\",\"elementor_icons\",\"elementor_custom_fonts\",\"dynamic-tags\",\"taxonomy-filter\",\"email\",\"email2\",\"mailpoet\",\"mailpoet3\",\"redirect\",\"header\",\"footer\",\"single-post\",\"single-page\",\"archive\",\"search-results\",\"error-404\",\"loop-item\",\"font-awesome-pro\",\"typekit\",\"gallery\",\"off-canvas\",\"link-in-bio-var-2\",\"link-in-bio-var-3\",\"link-in-bio-var-4\",\"link-in-bio-var-5\",\"link-in-bio-var-6\",\"link-in-bio-var-7\",\"search\",\"size-variable\",\"element-manager-permissions\",\"akismet\",\"display-conditions\",\"woocommerce-products\",\"wc-products\",\"woocommerce-product-add-to-cart\",\"wc-elements\",\"wc-categories\",\"woocommerce-product-price\",\"woocommerce-product-title\",\"woocommerce-product-images\",\"woocommerce-product-upsell\",\"woocommerce-product-short-description\",\"woocommerce-product-meta\",\"woocommerce-product-stock\",\"woocommerce-product-rating\",\"wc-add-to-cart\",\"dynamic-tags-wc\",\"woocommerce-product-data-tabs\",\"woocommerce-product-related\",\"woocommerce-breadcrumb\",\"wc-archive-products\",\"woocommerce-archive-products\",\"woocommerce-product-additional-information\",\"woocommerce-menu-cart\",\"woocommerce-product-content\",\"woocommerce-archive-description\",\"paypal-button\",\"woocommerce-checkout-page\",\"woocommerce-cart\",\"woocommerce-my-account\",\"woocommerce-purchase-summary\",\"woocommerce-notices\",\"settings-woocommerce-pages\",\"settings-woocommerce-notices\",\"popup\",\"custom-css\",\"global-css\",\"custom_code\",\"custom-attributes\",\"form-submissions\",\"form-integrations\",\"dynamic-tags-acf\",\"dynamic-tags-pods\",\"dynamic-tags-toolset\",\"editor_comments\",\"stripe-button\",\"role-manager\",\"global-widget\",\"activecampaign\",\"cf7db\",\"convertkit\",\"discord\",\"drip\",\"getresponse\",\"mailchimp\",\"mailerlite\",\"slack\",\"webhook\",\"product-single\",\"product-archive\",\"wc-single-elements\",\"atomic-custom-attributes\"],\"tier\":\"expert\",\"generation\":\"empty\",\"activated\":true,\"success\":true}\";}", "off");
INSERT INTO `wpvv_options` VALUES("259", "elementor_notes_db_version", "5", "auto");
INSERT INTO `wpvv_options` VALUES("260", "_elementor_notifications_data", "a:2:{s:7:\"timeout\";i:1757500392;s:5:\"value\";s:18404:\"[{\"id\":\"variables-3.31\",\"title\":\"Scalable design with Variables\",\"description\":\"Define once, reuse everywhere. Color & Font Variables help you build consistent, scalable design systems that update globally and are perfect for large sites or teams.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-variables.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"host-special-offer\",\"title\":\"Host with Elementor, Get Unified Support for Building & Hosting\",\"description\":\"Advance to Elementor\'s Cloud Hosting powered by Google Cloud and Cloudflare. Use the coupon CLOUDPLUSSPECIAL2025 to get Host Cloud Plus at the price of Host Cloud.\",\"topic\":\"Special offer: Elementor Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/host_coupon.png\",\"chipTags\":[\"Cloud Hosting\"],\"cta\":\"Get it Now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/host-whats-new-host-discount\\/\"},{\"id\":\"filters-3.31\",\"title\":\"Visual effects with Filters and Backdrop Filters\",\"description\":\"Apply multiple Filters like blur, brightness, and contrast. Stack, reorder, and preview in real time without writing a line of code.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-filters.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-assistant\",\"title\":\"New! Fix accessibility issues with Ally Assistant\",\"description\":\"Scan any page for accessibility issues and fix them in one click. From color contrast to missing alt text, Ally Assistant provides guided steps or AI-powered fixes to make your site more inclusive.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-assistant.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Scan for free\",\"ctaLink\":\"http:\\/\\/go.elementor.com\\/acc-assistant-launch-whats-new\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"classes-3.31\",\"title\":\"Smarter Class Manager tools\",\"description\":\"Quickly locate and manage Global Classes with usage counts, a new locator panel, and full class search. Perfect for scaling and refactoring complex design systems.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"send-notification-august\",\"title\":\"All Your Assets, One Library\",\"description\":\"Save time and skip the re-uploads - now you can pull images straight from your WordPress Media Library into Send. Faster, simpler, and built for WordPress.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aug_send.png\",\"chipTags\":[\"Cart abandonment\"],\"cta\":\"Upload Your Assets\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/ML_WN\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-attributes\\/\"},{\"id\":\"classes-3.30\",\"title\":\"Better class control\",\"description\":\"Get popovers with your class name, breakpoint, state and possible conflicts. Plus, the exact class names you define are now reflected in the code, making debugging and working with external tools easier!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/classes-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"tools-3.30\",\"title\":\"Essential Editor tools\",\"description\":\"V4 now includes a long list of essential V3 capabilities, re-engineered to fit the new framework - IDs, custom unit, anchor offset, display none, object fit, clear icons and more!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/tools-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"youtube-3.30\",\"title\":\"YouTube Element\",\"description\":\"The new YouTube Element is purpose-built to support V4 capabilities with faster rendering, better performance, and familiar controls like autoplay, loop, mute, and aspect ratio.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/youtube-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"host-google-cloud\",\"title\":\"Deliver fast, secure websites at scale - free migration included!\",\"description\":\"Host your site on Elementor\\u2019s infrastructure - built for speed, security, and scale. Powered by Google Cloud, with free migration and 24\\/7 expert support.\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/host-google-cloud.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/elementor-host-google-cloud\",\"readMoreText\":\"Read More\"},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates\\/\"},{\"id\":\"classes-3.29\",\"title\":\"Classes: Style Once, Apply Everywhere\",\"description\":\"Create Classes to define styling patterns once and apply them across your entire site with a single click. Add States for stunning hover and focus effects\\u2014no coding needed!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"style-tab-3.29\",\"title\":\"Consistent Styling Everywhere\",\"description\":\"Every V4 element shares the same styling capabilities in the same logical order and location. Plus, we\'ve streamlined from 3 tabs to just 2\\u2014content in one, styling in the other!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-style-tab.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"responsive-3.29\",\"title\":\"Fully Responsive Design\",\"description\":\"With Editor V4, every single style property can be customized per device. Complete creative control for desktop, tablet, and mobile!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-responsive.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"performance-3.29\",\"title\":\"Blazing fast performance\",\"description\":\"In Editor V4, each element uses one clean div instead of multiple nested divs like in the current version\\u2014your sites will load lightning-fast with cleaner code!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-performance.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"migration-host\",\"title\":\"Move to Better Cloud Hosting, Painlessly\",\"description\":\"Migrate your Elementor website for free to a home that\\u2019s perfect for it, in minutes, with a combination of\\u2028advanced automation and free expert support\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/migration-host.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\",\"readMoreText\":\"Learn More\",\"cta\":\"Migrate for free\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"introduction_meta\",\"meta\":\"ai_get_started\"}]],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Start Free Trial\",\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"hello-biz-contact\",\"title\":\"New Contact Widget, Visual Layout Presets & more\",\"description\":\"Hello Biz just got an update! Explore the new Contact Widget, Visual Layout Presets, Form Submissions integration, and fresh new kits.\",\"topic\":\"Hello Biz\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-contact.png\",\"chipTags\":[\"New Features\"],\"link\":\"https:\\/\\/go.elementor.com\\/hello-biz-updates\",\"readMoreText\":\"Learn More\"},{\"id\":\"ai-site-planner-colors\",\"title\":\"Style Your Wireframe, Speed Up Your Store Build\",\"description\":\"Site Planner now lets you style your wireframe with fonts and colors - instantly visualizing your site\\u2019s look and feel. Plus, it predesigns pages for WooCommerce like Cart and Checkout, so you can dive straight into customizations\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/site-planner-colors.png\",\"chipTags\":[\"New Feature\"],\"link\":\"http:\\/\\/www.elementor.com\\/ai-site-planner\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"grid-span-3.27\",\"title\":\"Design Grid layouts that fit your exact vision\",\"description\":\"Advanced column and row span controls give you the power to design Grid Container layouts that fit your exact vision.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/grid-span-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-grid-span-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"local-fonts-3.27\",\"title\":\"Load Google Fonts safer and faster\",\"description\":\"Once enabled, Google Fonts are served directly from your server, streamlining the loading process and enhancing security.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/local-google-fonts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-local-fonts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"video-shorts-3.27\",\"title\":\"Showcase short-form, vertical videos\",\"description\":\"The Video widget now supports YouTube Shorts in a vertical 9:16 ratio, the go-to format for engaging audiences.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/video-shorts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-video-shorts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-loop-off-canvas\\/\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}", "off");
INSERT INTO `wpvv_options` VALUES("263", "_elementor_pro_api_requests_lock", "a:2:{s:16:\"get_license_data\";i:1757483579;s:11:\"get_version\";i:1757509874;}", "auto");
INSERT INTO `wpvv_options` VALUES("264", "elementor_fonts_manager_font_types", "a:0:{}", "auto");
INSERT INTO `wpvv_options` VALUES("265", "elementor_fonts_manager_fonts", "a:0:{}", "auto");
INSERT INTO `wpvv_options` VALUES("266", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1757509878;s:7:\"checked\";a:2:{s:15:\"hello-elementor\";s:5:\"3.4.4\";s:24:\"hello-theme-child-master\";s:5:\"2.0.0\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:1:{s:15:\"hello-elementor\";a:6:{s:5:\"theme\";s:15:\"hello-elementor\";s:11:\"new_version\";s:5:\"3.4.4\";s:3:\"url\";s:45:\"https://wordpress.org/themes/hello-elementor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/hello-elementor.3.4.4.zip\";s:8:\"requires\";s:3:\"6.0\";s:12:\"requires_php\";s:3:\"7.4\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wpvv_options` VALUES("267", "e_editor_counter", "225", "auto");
INSERT INTO `wpvv_options` VALUES("268", "elementor_custom_icon_sets_config", "a:0:{}", "auto");
INSERT INTO `wpvv_options` VALUES("270", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wpvv_options` VALUES("271", "_transient_timeout__elementor_ab_test_plg_site_mailer_submission", "1762932035", "off");
INSERT INTO `wpvv_options` VALUES("272", "_transient__elementor_ab_test_plg_site_mailer_submission", "2", "off");
INSERT INTO `wpvv_options` VALUES("275", "elementor_unfiltered_files_upload", "1", "auto");
INSERT INTO `wpvv_options` VALUES("276", "site_logo", "19", "auto");
INSERT INTO `wpvv_options` VALUES("278", "elementor_pro_theme_builder_conditions", "a:5:{s:18:\"elementor_body_end\";a:2:{i:1183;a:1:{i:0;s:15:\"include/general\";}i:1072;a:1:{i:0;s:15:\"include/general\";}}s:7:\"archive\";a:2:{i:1028;a:1:{i:0;s:28:\"include/archive/team_archive\";}i:713;a:2:{i:0;s:28:\"include/archive/post_archive\";i:1;s:24:\"include/archive/category\";}}s:6:\"single\";a:2:{i:968;a:1:{i:0;s:29:\"include/singular/not_found404\";}i:861;a:1:{i:0;s:21:\"include/singular/post\";}}s:6:\"footer\";a:1:{i:42;a:1:{i:0;s:15:\"include/general\";}}s:6:\"header\";a:1:{i:12;a:1:{i:0;s:15:\"include/general\";}}}", "auto");
INSERT INTO `wpvv_options` VALUES("280", "elementor_library_category_children", "a:0:{}", "auto");
INSERT INTO `wpvv_options` VALUES("281", "elementor_log", "a:22:{s:32:\"f99eb5ed417492ef28b6b3000203a316\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-08-14 07:26:24\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:61:\"Cannot read properties of undefined (reading &#039;get&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-14 07:26:24\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1755156384\";s:7:\"message\";s:51:\"Cannot read properties of undefined (reading \'get\')\";s:3:\"url\";s:105:\"https://fm-connect1.fortmindz.in/wp-mpacs/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.2\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:5:\"22587\";}s:7:\"\0*\0file\";s:105:\"https://fm-connect1.fortmindz.in/wp-mpacs/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.2\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:5:\"22587\";}s:32:\"8c714fac5f337ed34edbecea3ee69a2d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-08-14 10:50:36\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:107:\"Failed to execute &#039;querySelector&#039; on &#039;Document&#039;: &#039;#&#039; is not a valid selector.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:80;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-08-27 11:19:08\";i:1;s:19:\"2025-08-27 11:19:08\";i:2;s:19:\"2025-08-27 11:19:08\";i:3;s:19:\"2025-08-27 11:19:14\";i:4;s:19:\"2025-08-27 11:19:14\";i:5;s:19:\"2025-08-27 11:19:14\";i:6;s:19:\"2025-08-27 11:19:14\";i:7;s:19:\"2025-08-27 11:20:18\";i:8;s:19:\"2025-08-27 11:20:18\";i:9;s:19:\"2025-08-27 11:20:18\";i:10;s:19:\"2025-08-27 11:21:38\";i:11;s:19:\"2025-08-27 11:21:38\";i:12;s:19:\"2025-08-27 11:21:38\";i:13;s:19:\"2025-08-27 11:22:45\";i:14;s:19:\"2025-08-27 11:22:45\";i:15;s:19:\"2025-08-27 11:22:45\";i:16;s:19:\"2025-08-27 11:23:29\";i:17;s:19:\"2025-08-27 11:23:29\";i:18;s:19:\"2025-08-27 11:23:29\";i:19;s:19:\"2025-08-27 11:24:35\";i:20;s:19:\"2025-08-27 11:24:35\";i:21;s:19:\"2025-08-27 11:24:35\";i:22;s:19:\"2025-08-27 11:25:42\";i:23;s:19:\"2025-08-27 11:25:42\";i:24;s:19:\"2025-08-27 11:25:42\";i:25;s:19:\"2025-08-27 12:29:02\";i:26;s:19:\"2025-08-27 12:29:02\";i:27;s:19:\"2025-08-27 12:29:02\";i:28;s:19:\"2025-08-29 11:03:35\";i:29;s:19:\"2025-08-29 11:03:35\";i:30;s:19:\"2025-08-29 11:06:16\";i:31;s:19:\"2025-08-29 11:06:16\";i:32;s:19:\"2025-08-29 11:06:20\";i:33;s:19:\"2025-08-29 11:06:20\";i:34;s:19:\"2025-08-29 11:06:25\";i:35;s:19:\"2025-08-29 11:06:25\";i:36;s:19:\"2025-08-29 11:06:30\";i:37;s:19:\"2025-08-29 11:06:30\";i:38;s:19:\"2025-08-29 11:06:50\";i:39;s:19:\"2025-08-29 11:06:50\";i:40;s:19:\"2025-08-29 11:07:26\";i:41;s:19:\"2025-08-29 11:07:26\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1755168636\";s:7:\"message\";s:77:\"Failed to execute \'querySelector\' on \'Document\': \'#\' is not a valid selector.\";s:3:\"url\";s:105:\"https://fm-connect1.fortmindz.in/wp-mpacs/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.2\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:7:\"1258999\";}s:7:\"\0*\0file\";s:105:\"https://fm-connect1.fortmindz.in/wp-mpacs/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.2\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:7:\"1258999\";}s:32:\"2f39fb534e04447b0d67de08d6fceb5a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-18 10:09:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-18 10:09:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"9b7d9893512c7bee6e7b3a010bdedfcd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-18 10:09:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:48:\"Elementor Pro/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-18 10:09:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:48:\"Elementor Pro/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"3b0adc8fd8ec32ca35c936329e531ac6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-18 10:09:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor Pro/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-18 10:09:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:50:\"Elementor Pro/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"848c63fa0916b5000e5e58f963d8f4b7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-18 10:09:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:70:\"Elementor Pro/Upgrades - _v_3_30_0_post_navigation_inline_icons Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-18 10:09:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:70:\"Elementor Pro/Upgrades - _v_3_30_0_post_navigation_inline_icons Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"3c8247f07bcf0b13b19ec74ce494e681\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-18 10:09:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:72:\"Elementor Pro/Upgrades - _v_3_30_0_post_navigation_inline_icons Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-18 10:09:13\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:72:\"Elementor Pro/Upgrades - _v_3_30_0_post_navigation_inline_icons Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"0ca1748afad9d69e9b8c9436291b67b2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-18 10:09:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.26.3\";s:2:\"to\";s:6:\"3.31.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-18 10:09:13\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.26.3\";s:2:\"to\";s:6:\"3.31.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"4e1c071adc74a0cd8c5a9035db6501a0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-18 10:09:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.26.3\";s:2:\"to\";s:6:\"3.31.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-18 10:09:13\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.26.3\";s:2:\"to\";s:6:\"3.31.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"62a008db21ceb2eae4447678b545942b\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-08-18 10:50:03\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:81:\"hexdec(): Passing null to parameter #1 ($hex_string) of type string is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:211;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-09-01 13:03:59\";i:1;s:19:\"2025-09-01 13:04:43\";i:2;s:19:\"2025-09-01 13:06:34\";i:3;s:19:\"2025-09-01 13:09:50\";i:4;s:19:\"2025-09-01 13:18:05\";i:5;s:19:\"2025-09-02 09:10:15\";i:6;s:19:\"2025-09-02 09:11:02\";i:7;s:19:\"2025-09-02 10:27:33\";i:8;s:19:\"2025-09-02 10:31:20\";i:9;s:19:\"2025-09-02 10:36:00\";i:10;s:19:\"2025-09-02 10:40:03\";i:11;s:19:\"2025-09-02 10:46:51\";i:12;s:19:\"2025-09-02 10:50:47\";i:13;s:19:\"2025-09-02 10:56:16\";i:14;s:19:\"2025-09-02 11:05:58\";i:15;s:19:\"2025-09-02 11:13:35\";i:16;s:19:\"2025-09-02 11:18:55\";i:17;s:19:\"2025-09-02 12:13:27\";i:18;s:19:\"2025-09-02 12:15:09\";i:19;s:19:\"2025-09-08 04:46:28\";i:20;s:19:\"2025-09-08 04:52:46\";i:21;s:19:\"2025-09-08 04:54:50\";i:22;s:19:\"2025-09-09 09:35:34\";i:23;s:19:\"2025-09-09 09:54:11\";i:24;s:19:\"2025-09-09 10:00:06\";i:25;s:19:\"2025-09-09 12:21:39\";i:26;s:19:\"2025-09-09 12:26:21\";i:27;s:19:\"2025-09-09 12:31:29\";i:28;s:19:\"2025-09-09 12:34:52\";i:29;s:19:\"2025-09-09 12:39:10\";i:30;s:19:\"2025-09-09 12:45:06\";i:31;s:19:\"2025-09-09 12:48:34\";i:32;s:19:\"2025-09-09 12:51:46\";i:33;s:19:\"2025-09-10 06:03:58\";i:34;s:19:\"2025-09-10 06:18:51\";i:35;s:19:\"2025-09-10 07:06:07\";i:36;s:19:\"2025-09-10 07:10:53\";i:37;s:19:\"2025-09-10 07:11:35\";i:38;s:19:\"2025-09-10 07:19:30\";i:39;s:19:\"2025-09-10 07:19:57\";i:40;s:19:\"2025-09-10 07:27:14\";i:41;s:19:\"2025-09-10 09:33:12\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:81:\"hexdec(): Passing null to parameter #1 ($hex_string) of type string is deprecated\";s:4:\"file\";s:98:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:4:\"line\";i:230;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:98:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins/elementor/includes/base/controls-stack.php\";s:7:\"\0*\0line\";i:230;}s:32:\"7082d6b66a3c311a45593c856249192d\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-08-21 05:04:36\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:46:\"Undefined array key &quot;condition_type&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:5:{i:0;a:5:{s:4:\"file\";s:127:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins/elementor-pro/core/app/modules/site-editor/data/endpoints/templates.php\";s:4:\"line\";i:150;s:8:\"function\";s:18:\"rest_error_handler\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}i:1;a:3:{s:8:\"function\";s:28:\"normalize_template_json_item\";s:5:\"class\";s:65:\"ElementorPro\\Core\\App\\Modules\\SiteEditor\\Data\\Endpoints\\Templates\";s:4:\"type\";s:2:\"->\";}i:2;a:3:{s:4:\"file\";s:127:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins/elementor-pro/core/app/modules/site-editor/data/endpoints/templates.php\";s:4:\"line\";i:120;s:8:\"function\";s:9:\"array_map\";}i:3;a:5:{s:4:\"file\";s:127:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins/elementor-pro/core/app/modules/site-editor/data/endpoints/templates.php\";s:4:\"line\";i:59;s:8:\"function\";s:24:\"normalize_templates_json\";s:5:\"class\";s:65:\"ElementorPro\\Core\\App\\Modules\\SiteEditor\\Data\\Endpoints\\Templates\";s:4:\"type\";s:2:\"->\";}i:4;a:5:{s:4:\"file\";s:88:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins/elementor/data/base/endpoint.php\";s:4:\"line\";i:156;s:8:\"function\";s:9:\"get_items\";s:5:\"class\";s:65:\"ElementorPro\\Core\\App\\Modules\\SiteEditor\\Data\\Endpoints\\Templates\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:26;s:14:\"\0*\0times_dates\";a:26:{i:0;s:19:\"2025-08-21 05:04:36\";i:1;s:19:\"2025-08-21 06:23:50\";i:2;s:19:\"2025-08-22 05:08:46\";i:3;s:19:\"2025-08-22 05:08:46\";i:4;s:19:\"2025-08-25 05:36:27\";i:5;s:19:\"2025-08-25 05:36:27\";i:6;s:19:\"2025-08-25 06:50:23\";i:7;s:19:\"2025-08-25 06:50:23\";i:8;s:19:\"2025-08-25 07:04:01\";i:9;s:19:\"2025-08-25 07:04:01\";i:10;s:19:\"2025-08-25 07:04:01\";i:11;s:19:\"2025-08-25 09:07:51\";i:12;s:19:\"2025-08-25 09:07:51\";i:13;s:19:\"2025-08-25 09:07:51\";i:14;s:19:\"2025-08-27 11:14:01\";i:15;s:19:\"2025-08-27 11:14:01\";i:16;s:19:\"2025-08-27 11:14:01\";i:17;s:19:\"2025-09-02 10:35:59\";i:18;s:19:\"2025-09-02 10:35:59\";i:19;s:19:\"2025-09-02 10:35:59\";i:20;s:19:\"2025-09-10 07:09:26\";i:21;s:19:\"2025-09-10 07:09:26\";i:22;s:19:\"2025-09-10 07:09:26\";i:23;s:19:\"2025-09-10 07:26:55\";i:24;s:19:\"2025-09-10 07:26:55\";i:25;s:19:\"2025-09-10 07:26:55\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:36:\"Undefined array key \"condition_type\"\";s:4:\"file\";s:127:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins/elementor-pro/core/app/modules/site-editor/data/endpoints/templates.php\";s:4:\"line\";i:150;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:127:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins/elementor-pro/core/app/modules/site-editor/data/endpoints/templates.php\";s:7:\"\0*\0line\";i:150;}s:32:\"7eba2ec85cd008299e3ea5c46e82492f\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-08-21 06:26:43\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:67:\"Cannot read properties of undefined (reading &#039;localized&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:4;s:14:\"\0*\0times_dates\";a:4:{i:0;s:19:\"2025-08-21 06:26:43\";i:1;s:19:\"2025-08-21 06:26:43\";i:2;s:19:\"2025-08-21 06:26:43\";i:3;s:19:\"2025-08-21 06:26:43\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1755757603\";s:7:\"message\";s:57:\"Cannot read properties of undefined (reading \'localized\')\";s:3:\"url\";s:105:\"https://fm-connect1.fortmindz.in/wp-mpacs/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.2\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:7:\"1346085\";}s:7:\"\0*\0file\";s:105:\"https://fm-connect1.fortmindz.in/wp-mpacs/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.2\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:7:\"1346085\";}s:32:\"e6e076c9d7c1040e07469a28b2906569\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-08-22 05:15:11\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:55:\"Cannot read properties of null (reading &#039;id&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-22 05:15:11\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1755839711\";s:7:\"message\";s:45:\"Cannot read properties of null (reading \'id\')\";s:3:\"url\";s:105:\"https://fm-connect1.fortmindz.in/wp-mpacs/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.2\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:7:\"1560294\";}s:7:\"\0*\0file\";s:105:\"https://fm-connect1.fortmindz.in/wp-mpacs/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.2\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:7:\"1560294\";}s:32:\"8b940f8cfd06ce2af827f77dc96fed30\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-08-22 05:44:46\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:46:\"Undefined array key &quot;editor_post_id&quot;\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-22 05:44:46\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:36:\"Undefined array key \"editor_post_id\"\";s:4:\"file\";s:122:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php\";s:4:\"line\";i:183;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:122:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins/elementor-pro/modules/theme-builder/classes/conditions-manager.php\";s:7:\"\0*\0line\";i:183;}s:32:\"074f6a4e80b056424679b03c836a1943\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-08-25 07:50:45\";s:7:\"\0*\0type\";s:7:\"warning\";s:10:\"\0*\0message\";s:21:\"Undefined array key 1\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-08-25 07:50:45\";i:1;s:19:\"2025-08-26 13:24:43\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:7:\"warning\";s:7:\"message\";s:21:\"Undefined array key 1\";s:4:\"file\";s:112:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins/elementor-pro/modules/dynamic-tags/acf/tags/acf-text.php\";s:4:\"line\";i:33;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:112:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins/elementor-pro/modules/dynamic-tags/acf/tags/acf-text.php\";s:7:\"\0*\0line\";i:33;}s:32:\"6a119662ea6b8f1dcdada4ad517448b9\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-08-25 09:10:55\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:184:\"Failed to execute &#039;querySelector&#039; on &#039;Document&#039;: &#039;#elementor-actionactionpopupopensettingseyJpZCI6IjEwNjIiLCJ0b2dnbGUiOmZhbHNlfQ&#039; is not a valid selector.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:8;s:14:\"\0*\0times_dates\";a:8:{i:0;s:19:\"2025-08-25 09:10:55\";i:1;s:19:\"2025-08-25 09:10:55\";i:2;s:19:\"2025-08-25 09:23:40\";i:3;s:19:\"2025-08-25 09:23:40\";i:4;s:19:\"2025-08-25 09:25:47\";i:5;s:19:\"2025-08-25 09:25:47\";i:6;s:19:\"2025-08-25 09:26:25\";i:7;s:19:\"2025-08-25 09:26:25\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1756113055\";s:7:\"message\";s:154:\"Failed to execute \'querySelector\' on \'Document\': \'#elementor-actionactionpopupopensettingseyJpZCI6IjEwNjIiLCJ0b2dnbGUiOmZhbHNlfQ\' is not a valid selector.\";s:3:\"url\";s:105:\"https://fm-connect1.fortmindz.in/wp-mpacs/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.2\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:7:\"1258999\";}s:7:\"\0*\0file\";s:105:\"https://fm-connect1.fortmindz.in/wp-mpacs/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.31.2\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:7:\"1258999\";}s:32:\"4251dba9d8e05283558577a0f241dbd2\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-08-29 10:47:15\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:60:\"ob_end_clean(): Failed to delete buffer. No buffer to delete\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-29 10:47:15\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:60:\"ob_end_clean(): Failed to delete buffer. No buffer to delete\";s:4:\"file\";s:108:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins/elementor/includes/template-library/sources/base.php\";s:4:\"line\";i:537;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:108:\"/home2/apgcjfqb/public_html/wp-mpacs/wp-content/plugins/elementor/includes/template-library/sources/base.php\";s:7:\"\0*\0line\";i:537;}s:32:\"26c148cceae90b22ccca5f1b75f6520a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-10 12:55:01\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-10 12:55:01\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"a4431ae07cf3e0726008ff4d3dd85a7b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-10 12:55:01\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-10 12:55:01\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"3e008d3189006823e099149a426457c3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-10 12:55:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.2\";s:2:\"to\";s:6:\"3.31.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-10 12:55:02\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.2\";s:2:\"to\";s:6:\"3.31.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"2c94dd0b9002d3edc7bf17ac934a5bc2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-10 12:55:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-10 12:55:02\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"9cee257622537c8157cc37671f6ef419\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-10 12:55:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.2\";s:2:\"to\";s:6:\"3.31.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-10 12:55:02\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.2\";s:2:\"to\";s:6:\"3.31.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}}", "off");
INSERT INTO `wpvv_options` VALUES("282", "_elementor_element_cache_unique_id", "008e8fc8f6f0f41f15619bdb17255ce9", "auto");
INSERT INTO `wpvv_options` VALUES("355", "_transient_health-check-site-status-result", "{\"good\":16,\"recommended\":5,\"critical\":2}", "on");
INSERT INTO `wpvv_options` VALUES("393", "_transient_timeout_elementor_image_optimization_campaign", "1758085732", "off");
INSERT INTO `wpvv_options` VALUES("394", "_transient_elementor_image_optimization_campaign", "a:3:{s:6:\"source\";s:23:\"io-editor-image-install\";s:8:\"campaign\";s:6:\"io-plg\";s:6:\"medium\";s:7:\"wp-dash\";}", "off");
INSERT INTO `wpvv_options` VALUES("433", "cool-free-timeline-v", "3.0.5", "auto");
INSERT INTO `wpvv_options` VALUES("434", "cool-timelne-plugin-type", "FREE", "auto");
INSERT INTO `wpvv_options` VALUES("435", "cool-timelne-installDate", "2025-08-18 07:47:26", "auto");
INSERT INTO `wpvv_options` VALUES("436", "cool-timeline-already-rated", "no", "auto");
INSERT INTO `wpvv_options` VALUES("438", "ctl_initial_save_version", "3.0.5", "auto");
INSERT INTO `wpvv_options` VALUES("439", "ctl-install-date", "2025-08-18 07:47:26", "auto");
INSERT INTO `wpvv_options` VALUES("440", "ctl-upgraded", "yes", "auto");
INSERT INTO `wpvv_options` VALUES("441", "cool_timeline_settings", "a:15:{s:15:\"timeline_header\";s:0:\"\";s:22:\"story_content_settings\";s:0:\"\";s:19:\"story_date_settings\";s:0:\"\";s:20:\"first_story_position\";s:5:\"right\";s:16:\"content_bg_color\";s:7:\"#ffffff\";s:19:\"circle_border_color\";s:7:\"#38aab7\";s:10:\"line_color\";s:7:\"#025149\";s:10:\"first_post\";s:7:\"#29b246\";s:11:\"second_post\";s:7:\"#ce792f\";s:13:\"custom_styles\";s:0:\"\";s:13:\"ctl_date_typo\";a:6:{s:11:\"font-family\";s:9:\"Maven Pro\";s:9:\"font-size\";s:2:\"21\";s:11:\"line-height\";s:0:\"\";s:4:\"unit\";s:2:\"px\";s:4:\"type\";s:6:\"google\";s:11:\"font-weight\";s:3:\"700\";}s:15:\"post_title_typo\";a:6:{s:11:\"font-family\";s:9:\"Maven Pro\";s:9:\"font-size\";s:2:\"20\";s:11:\"line-height\";s:0:\"\";s:4:\"unit\";s:2:\"px\";s:4:\"type\";s:6:\"google\";s:11:\"font-weight\";s:3:\"700\";}s:17:\"post_content_typo\";a:5:{s:11:\"font-family\";s:9:\"Maven Pro\";s:9:\"font-size\";s:2:\"16\";s:11:\"line-height\";s:0:\"\";s:4:\"unit\";s:2:\"px\";s:4:\"type\";s:6:\"google\";}s:17:\"advanced-features\";s:0:\"\";s:16:\"timeline_display\";s:0:\"\";}", "auto");
INSERT INTO `wpvv_options` VALUES("444", "cool-plugins-timeline-addon-timeline", "a:4:{s:13:\"cool-timeline\";a:7:{s:4:\"name\";s:48:\"Cool Timeline (Horizontal and Vertical Timeline)\";s:4:\"logo\";s:66:\"https://ps.w.org/cool-timeline/assets/icon-128x128.png?rev=2297699\";s:4:\"slug\";s:13:\"cool-timeline\";s:4:\"desc\";s:111:\"Showcase your story or company history in a precise and elegant way using a powerful and advanced Cool Timeline\";s:7:\"version\";s:5:\"3.0.5\";s:4:\"tags\";s:8:\"timeline\";s:13:\"download_link\";s:62:\"https://downloads.wordpress.org/plugin/cool-timeline.2.4.5.zip\";}s:14:\"timeline-block\";a:7:{s:4:\"name\";s:28:\"Timeline Block For Gutenberg\";s:4:\"logo\";s:67:\"https://ps.w.org/timeline-block/assets/icon-128x128.png?rev=2365707\";s:4:\"slug\";s:14:\"timeline-block\";s:4:\"desc\";s:112:\"Showcase your story or company history,events,process steps and Roadmap in precise and elegant way using&hellip;\";s:7:\"version\";s:5:\"1.7.1\";s:4:\"tags\";s:8:\"timeline\";s:13:\"download_link\";s:63:\"https://downloads.wordpress.org/plugin/timeline-block.1.2.2.zip\";}s:35:\"timeline-widget-addon-for-elementor\";a:7:{s:4:\"name\";s:84:\"Timeline Widget For Elementor (Elementor Timeline, Vertical and Horizontal Timeline)\";s:4:\"logo\";s:88:\"https://ps.w.org/timeline-widget-addon-for-elementor/assets/icon-128x128.png?rev=2772459\";s:4:\"slug\";s:35:\"timeline-widget-addon-for-elementor\";s:4:\"desc\";s:125:\"Elementor timeline widget addon will showcase your company history or life story in a vertical or horizontal timeline layout.\";s:7:\"version\";s:5:\"1.6.6\";s:4:\"tags\";s:8:\"timeline\";s:13:\"download_link\";s:78:\"https://downloads.wordpress.org/plugin/timeline-widget-addon-for-elementor.zip\";}s:24:\"timeline-module-for-divi\";a:7:{s:4:\"name\";s:24:\"Timeline Module for Divi\";s:4:\"logo\";s:77:\"https://ps.w.org/timeline-module-for-divi/assets/icon-128x128.png?rev=3136614\";s:4:\"slug\";s:24:\"timeline-module-for-divi\";s:4:\"desc\";s:111:\"Highlight your company&#039;s history, milestones, and future plans with the advanced Timeline Module for Divi.\";s:7:\"version\";s:5:\"1.0.3\";s:4:\"tags\";s:8:\"timeline\";s:13:\"download_link\";s:73:\"https://downloads.wordpress.org/plugin/timeline-module-for-divi.1.0.1.zip\";}}", "auto");
INSERT INTO `wpvv_options` VALUES("447", "cool-plugins-timeline-addon-timeline-pro", "a:5:{s:17:\"cool-timeline-pro\";a:8:{s:4:\"name\";s:17:\"Cool Timeline Pro\";s:4:\"logo\";s:60:\"https://plugins.coolplugins.net/proimages/20230102090638.png\";s:4:\"desc\";s:197:\"Cool Timeline Pro is an advanced WordPress timeline plugin that showcases your life history timeline or your company’s story timeline in a responsive horizontal or vertical timeline layout.\";s:4:\"slug\";s:17:\"cool-timeline-pro\";s:7:\"buyLink\";s:152:\"https://cooltimeline.com/plugin/cool-timeline-pro/?utm_source=ctl_plugin&#038;utm_medium=inside&#038;utm_campaign=get_pro&#038;utm_content=dashboard_api\";s:7:\"version\";s:6:\"4.8.12\";s:13:\"download_link\";N;s:12:\"incompatible\";s:13:\"cool-timeline\";}s:39:\"timeline-widget-addon-for-elementor-pro\";a:8:{s:4:\"name\";s:37:\"Timeline Widget Pro (Elementor Addon)\";s:4:\"logo\";s:60:\"https://plugins.coolplugins.net/proimages/20230102094335.png\";s:4:\"desc\";s:188:\"Showcase your life story or company history in an elegant horizontal or vertical timeline layout using powerful and advance Elementor Timeline Widget Pro Addon inside your Elementor pages.\";s:4:\"slug\";s:39:\"timeline-widget-addon-for-elementor-pro\";s:7:\"buyLink\";s:165:\"https://cooltimeline.com/plugin/elementor-timeline-widget-pro/?utm_source=twae_plugin&#038;utm_medium=inside&#038;utm_campaign=get_pro&#038;utm_content=dashboard_api\";s:7:\"version\";s:5:\"2.2.0\";s:13:\"download_link\";N;s:12:\"incompatible\";s:35:\"timeline-widget-addon-for-elementor\";}s:20:\"timeline-builder-pro\";a:8:{s:4:\"name\";s:20:\"Timeline Builder Pro\";s:4:\"logo\";s:60:\"https://plugins.coolplugins.net/proimages/20230102094744.png\";s:4:\"desc\";s:237:\"Best timeline plugin to create a small timeline quickly with a few clicks. Timeline Builder Pro provides advanced timeline design options and best for those whose want to create a tiny vertical or horizontal timeline with max 15 stories.\";s:4:\"slug\";s:20:\"timeline-builder-pro\";s:7:\"buyLink\";s:155:\"https://cooltimeline.com/plugin/timeline-builder-pro/?utm_source=tbp_plugin&#038;utm_medium=inside&#038;utm_campaign=get_pro&#038;utm_content=dashboard_api\";s:7:\"version\";s:5:\"1.1.2\";s:13:\"download_link\";N;s:12:\"incompatible\";s:5:\"false\";}s:18:\"timeline-block-pro\";a:8:{s:4:\"name\";s:18:\"Timeline Block Pro\";s:4:\"logo\";s:60:\"https://plugins.coolplugins.net/proimages/20250620095012.png\";s:4:\"desc\";s:51:\"Responsive timeline block Pro for Gutenberg editor.\";s:4:\"slug\";s:18:\"timeline-block-pro\";s:7:\"buyLink\";s:167:\"https://cooltimeline.com/plugin/timeline-block-pro-for-gutenberg/?utm_source=tbg_plugin&#038;utm_medium=inside&#038;utm_campaign=get_pro&#038;utm_content=dashboard_api\";s:7:\"version\";s:5:\"1.1.0\";s:13:\"download_link\";N;s:12:\"incompatible\";s:14:\"timeline-block\";}s:28:\"timeline-module-for-divi-pro\";a:8:{s:4:\"name\";s:29:\"Timeline Module for Divi(Pro)\";s:4:\"logo\";s:60:\"https://plugins.coolplugins.net/proimages/20250620123643.png\";s:4:\"desc\";s:247:\"Timeline Module for Divi is an easy-to-use plugin that helps you create beautiful timelines on your Divi website. Whether you want to show your company’s history, important milestones, or tell a story, this plugin makes it simple and attractive.\";s:4:\"slug\";s:28:\"timeline-module-for-divi-pro\";s:7:\"buyLink\";s:71:\"https://www.elegantthemes.com/marketplace/timeline-module-for-divi-pro/\";s:7:\"version\";s:5:\"1.0.5\";s:13:\"download_link\";N;s:12:\"incompatible\";s:24:\"timeline-module-for-divi\";}}", "auto");
INSERT INTO `wpvv_options` VALUES("448", "cpfm_opt_in_choice_cool-timeline", "no", "auto");
INSERT INTO `wpvv_options` VALUES("449", "ctl-elementor-addon-notice_remove_notice", "yes", "auto");
INSERT INTO `wpvv_options` VALUES("492", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"25.9\";}", "auto");
INSERT INTO `wpvv_options` VALUES("493", "wpseo", "a:115:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";s:5:\"false\";s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:21:\"post_type_made_public\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"25.9\";s:16:\"previous_version\";s:4:\"25.7\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:1;s:22:\"ai_enabled_pre_default\";b:0;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";s:10:\"1755514233\";s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:12:\"/%postname%/\";s:8:\"home_url\";s:41:\"https://fm-connect1.fortmindz.in/wp-mpacs\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:3:{s:22:\"elementor_library_type\";s:22:\"elementor_library_type\";s:26:\"elementor_library_category\";s:26:\"elementor_library_category\";s:19:\"elementor_font_type\";s:19:\"elementor_font_type\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:0:{}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:18:\"first_time_install\";b:1;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";s:10:\"1755514234\";s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:19:\"deny_ccbot_crawling\";b:0;s:29:\"deny_google_extended_crawling\";b:0;s:20:\"deny_gptbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:5:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:18:\"e-floating-buttons\";i:3;s:7:\"podcast\";i:4;s:4:\"team\";}s:28:\"last_known_public_taxonomies\";a:3:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";}s:23:\"last_known_no_unindexed\";a:6:{s:40:\"wpseo_total_unindexed_post_type_archives\";i:1757506338;s:31:\"wpseo_unindexed_post_link_count\";i:1757506338;s:31:\"wpseo_unindexed_term_link_count\";i:1757506338;s:35:\"wpseo_total_unindexed_general_items\";i:1757506338;s:27:\"wpseo_total_unindexed_posts\";i:1756797774;s:27:\"wpseo_total_unindexed_terms\";i:1756797774;}s:14:\"new_post_types\";a:1:{i:4;s:4:\"team\";}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:0;s:44:\"site_kit_configuration_permanently_dismissed\";b:0;s:18:\"site_kit_connected\";b:0;s:37:\"site_kit_tracking_setup_widget_loaded\";s:2:\"no\";s:41:\"site_kit_tracking_first_interaction_stage\";s:0:\"\";s:40:\"site_kit_tracking_last_interaction_stage\";s:0:\"\";s:52:\"site_kit_tracking_setup_widget_temporarily_dismissed\";s:2:\"no\";s:52:\"site_kit_tracking_setup_widget_permanently_dismissed\";s:2:\"no\";s:31:\"google_site_kit_feature_enabled\";b:0;s:25:\"ai_free_sparks_started_on\";s:4:\"null\";s:15:\"enable_llms_txt\";b:0;}", "auto");
INSERT INTO `wpvv_options` VALUES("494", "wpseo_titles", "a:179:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-pipe\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:1:\"/\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:24:\"publishing_principles_id\";i:0;s:25:\"ownership_funding_info_id\";i:0;s:29:\"actionable_feedback_policy_id\";i:0;s:21:\"corrections_policy_id\";i:0;s:16:\"ethics_policy_id\";i:0;s:19:\"diversity_policy_id\";i:0;s:28:\"diversity_staffing_report_id\";i:0;s:15:\"org-description\";s:0:\"\";s:9:\"org-email\";s:0:\"\";s:9:\"org-phone\";s:0:\"\";s:14:\"org-legal-name\";s:0:\"\";s:17:\"org-founding-date\";s:0:\"\";s:20:\"org-number-employees\";s:0:\"\";s:10:\"org-vat-id\";s:0:\"\";s:10:\"org-tax-id\";s:0:\"\";s:7:\"org-iso\";s:0:\"\";s:8:\"org-duns\";s:0:\"\";s:11:\"org-leicode\";s:0:\"\";s:9:\"org-naics\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:24:\"title-e-floating-buttons\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:27:\"metadesc-e-floating-buttons\";s:0:\"\";s:26:\"noindex-e-floating-buttons\";b:0;s:37:\"display-metabox-pt-e-floating-buttons\";b:1;s:37:\"post_types-e-floating-buttons-maintax\";i:0;s:35:\"schema-page-type-e-floating-buttons\";s:7:\"WebPage\";s:38:\"schema-article-type-e-floating-buttons\";s:4:\"None\";s:31:\"social-title-e-floating-buttons\";s:9:\"%%title%%\";s:37:\"social-description-e-floating-buttons\";s:0:\"\";s:35:\"social-image-url-e-floating-buttons\";s:0:\"\";s:34:\"social-image-id-e-floating-buttons\";i:0;s:23:\"title-elementor_library\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-elementor_library\";s:0:\"\";s:25:\"noindex-elementor_library\";b:0;s:36:\"display-metabox-pt-elementor_library\";b:1;s:36:\"post_types-elementor_library-maintax\";i:0;s:34:\"schema-page-type-elementor_library\";s:7:\"WebPage\";s:37:\"schema-article-type-elementor_library\";s:4:\"None\";s:30:\"social-title-elementor_library\";s:9:\"%%title%%\";s:36:\"social-description-elementor_library\";s:0:\"\";s:34:\"social-image-url-elementor_library\";s:0:\"\";s:33:\"social-image-id-elementor_library\";i:0;s:13:\"title-podcast\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-podcast\";s:0:\"\";s:15:\"noindex-podcast\";b:0;s:26:\"display-metabox-pt-podcast\";b:1;s:26:\"post_types-podcast-maintax\";i:0;s:24:\"schema-page-type-podcast\";s:7:\"WebPage\";s:27:\"schema-article-type-podcast\";s:4:\"None\";s:20:\"social-title-podcast\";s:9:\"%%title%%\";s:26:\"social-description-podcast\";s:0:\"\";s:24:\"social-image-url-podcast\";s:0:\"\";s:23:\"social-image-id-podcast\";i:0;s:10:\"title-team\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-team\";s:0:\"\";s:12:\"noindex-team\";b:0;s:23:\"display-metabox-pt-team\";b:1;s:23:\"post_types-team-maintax\";i:0;s:21:\"schema-page-type-team\";s:7:\"WebPage\";s:24:\"schema-article-type-team\";s:4:\"None\";s:17:\"social-title-team\";s:9:\"%%title%%\";s:23:\"social-description-team\";s:0:\"\";s:21:\"social-image-url-team\";s:0:\"\";s:20:\"social-image-id-team\";i:0;s:20:\"title-ptarchive-team\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-ptarchive-team\";s:0:\"\";s:22:\"bctitle-ptarchive-team\";s:0:\"\";s:22:\"noindex-ptarchive-team\";b:0;s:27:\"social-title-ptarchive-team\";s:21:\"%%pt_plural%% Archive\";s:33:\"social-description-ptarchive-team\";s:0:\"\";s:31:\"social-image-url-ptarchive-team\";s:0:\"\";s:30:\"social-image-id-ptarchive-team\";i:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:29:\"open_graph_frontpage_image_id\";i:0;}", "auto");
INSERT INTO `wpvv_options` VALUES("495", "wpseo_social", "a:20:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}s:12:\"mastodon_url\";s:0:\"\";}", "auto");
INSERT INTO `wpvv_options` VALUES("496", "wpseo_llmstxt", "a:7:{s:23:\"llms_txt_selection_mode\";s:4:\"auto\";s:13:\"about_us_page\";i:0;s:12:\"contact_page\";i:0;s:10:\"terms_page\";i:0;s:19:\"privacy_policy_page\";i:0;s:9:\"shop_page\";i:0;s:20:\"other_included_pages\";a:0:{}}", "auto");
INSERT INTO `wpvv_options` VALUES("859", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wpvv_options` VALUES("913", "acf_first_activated_version", "6.5.0", "on");
INSERT INTO `wpvv_options` VALUES("914", "acf_site_health", "{\"version\":\"6.3.3\",\"plugin_type\":\"PRO\",\"activated\":true,\"activated_url\":\"https:\\/\\/fm-connect1.fortmindz.in\\/wp-mpacs\",\"license_type\":\"Agency\",\"license_status\":\"active\",\"subscription_expires\":1783493608,\"wp_version\":\"6.8.2\",\"mysql_version\":\"10.11.14-MariaDB\",\"is_multisite\":false,\"active_theme\":{\"name\":\"Hello Elementor Child\",\"version\":\"2.0.0\",\"theme_uri\":\"https:\\/\\/github.com\\/elementor\\/hello-theme-child\\/\",\"stylesheet\":false},\"parent_theme\":{\"name\":\"Hello Elementor\",\"version\":\"3.4.4\",\"theme_uri\":\"https:\\/\\/elementor.com\\/hello-theme\\/?utm_source=wp-themes&utm_campaign=theme-uri&utm_medium=wp-dash\",\"stylesheet\":false},\"active_plugins\":{\"advanced-custom-fields-pro\\/acf.php\":{\"name\":\"Advanced Custom Fields PRO\",\"version\":\"6.3.3\",\"plugin_uri\":\"https:\\/\\/www.advancedcustomfields.com\"},\"all-in-one-wp-migration\\/all-in-one-wp-migration.php\":{\"name\":\"All-in-One WP Migration and Backup\",\"version\":\"7.97\",\"plugin_uri\":\"https:\\/\\/servmask.com\\/\"},\"classic-editor\\/classic-editor.php\":{\"name\":\"Classic Editor\",\"version\":\"1.6.7\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/classic-editor\\/\"},\"elementor\\/elementor.php\":{\"name\":\"Elementor\",\"version\":\"3.31.2\",\"plugin_uri\":\"https:\\/\\/elementor.com\\/?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash\"},\"elementor-pro\\/elementor-pro.php\":{\"name\":\"Elementor Pro\",\"version\":\"3.31.2\",\"plugin_uri\":\"https:\\/\\/go.elementor.com\\/wp-dash-wp-plugins-author-uri\\/\"},\"megamenu\\/megamenu.php\":{\"name\":\"Max Mega Menu\",\"version\":\"3.6.2\",\"plugin_uri\":\"https:\\/\\/www.megamenu.com\"},\"svg-support\\/svg-support.php\":{\"name\":\"SVG Support\",\"version\":\"2.5.14\",\"plugin_uri\":\"http:\\/\\/wordpress.org\\/plugins\\/svg-support\\/\"},\"wordpress-seo\\/wp-seo.php\":{\"name\":\"Yoast SEO\",\"version\":\"25.7\",\"plugin_uri\":\"https:\\/\\/yoa.st\\/1uj\"}},\"ui_field_groups\":\"2\",\"php_field_groups\":\"0\",\"json_field_groups\":\"0\",\"rest_field_groups\":\"0\",\"number_of_fields_by_type\":{\"text\":6},\"number_of_third_party_fields_by_type\":[],\"post_types_enabled\":true,\"ui_post_types\":\"10\",\"json_post_types\":\"0\",\"ui_taxonomies\":\"6\",\"json_taxonomies\":\"0\",\"ui_options_pages_enabled\":true,\"ui_options_pages\":\"0\",\"json_options_pages\":\"0\",\"php_options_pages\":\"0\",\"rest_api_format\":\"light\",\"registered_acf_blocks\":\"0\",\"blocks_per_api_version\":[],\"blocks_per_acf_block_version\":[],\"blocks_using_post_meta\":\"0\",\"preload_blocks\":true,\"admin_ui_enabled\":true,\"field_type-modal_enabled\":true,\"field_settings_tabs_enabled\":false,\"shortcode_enabled\":false,\"registered_acf_forms\":\"0\",\"json_save_paths\":1,\"json_load_paths\":1,\"event_first_activated\":1755756442,\"event_first_created_post_type\":1755756506,\"event_first_created_field_group\":1755756574,\"last_updated\":1756967101}", "off");
INSERT INTO `wpvv_options` VALUES("916", "acf_version", "6.5.1", "auto");
INSERT INTO `wpvv_options` VALUES("999", "acf_pro_license", "YToyOntzOjM6ImtleSI7czo3MjoiWXpCa01ETmhZak5tTnpabVpXRTRPVFpqTXpkbU5HWTVNek5tWm1JM1pqUXdaRGs0TW1SaU56TmlPR1prWmpCbFltTTVPV1l4IjtzOjM6InVybCI7czo0MToiaHR0cHM6Ly9mbS1jb25uZWN0MS5mb3J0bWluZHouaW4vd3AtbXBhY3MiO30=", "off");
INSERT INTO `wpvv_options` VALUES("1000", "acf_pro_license_status", "a:11:{s:6:\"status\";s:6:\"active\";s:7:\"created\";i:1688652959;s:6:\"expiry\";i:1783493608;s:4:\"name\";s:6:\"Agency\";s:8:\"lifetime\";b:0;s:8:\"refunded\";b:0;s:17:\"view_licenses_url\";s:62:\"https://www.advancedcustomfields.com/my-account/view-licenses/\";s:23:\"manage_subscription_url\";s:73:\"https://www.advancedcustomfields.com/my-account/view-subscription/410680/\";s:9:\"error_msg\";s:0:\"\";s:10:\"next_check\";i:1757570636;s:16:\"legacy_multisite\";b:1;}", "on");
INSERT INTO `wpvv_options` VALUES("1528", "_site_transient_ai1wm_last_check_for_updates", "1757487985", "off");
INSERT INTO `wpvv_options` VALUES("2151", "widget_maxmegamenu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("2152", "widget_maxmegamenu_reusable_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wpvv_options` VALUES("2153", "megamenu_install_date", "1756444234", "auto");
INSERT INTO `wpvv_options` VALUES("2154", "megamenu_version", "3.6.2", "auto");
INSERT INTO `wpvv_options` VALUES("2155", "megamenu_initial_version", "3.6.2", "auto");
INSERT INTO `wpvv_options` VALUES("2156", "megamenu_multisite_share_themes", "false", "auto");
INSERT INTO `wpvv_options` VALUES("2157", "megamenu_settings", "a:4:{s:6:\"prefix\";s:8:\"disabled\";s:12:\"descriptions\";s:7:\"enabled\";s:12:\"second_click\";s:2:\"go\";s:6:\"menu-1\";a:5:{s:7:\"enabled\";s:1:\"1\";s:5:\"event\";s:5:\"hover\";s:6:\"effect\";s:7:\"fade_up\";s:13:\"effect_mobile\";s:11:\"slide_right\";s:5:\"theme\";s:7:\"default\";}}", "auto");
INSERT INTO `wpvv_options` VALUES("2160", "megamenu_css_version", "3.6.2", "auto");
INSERT INTO `wpvv_options` VALUES("2161", "megamenu_css_last_updated", "1756462785", "auto");
INSERT INTO `wpvv_options` VALUES("2183", "category_children", "a:0:{}", "auto");
INSERT INTO `wpvv_options` VALUES("2239", "megamenu_themes", "a:1:{s:7:\"default\";a:229:{s:5:\"title\";s:7:\"Default\";s:8:\"arrow_up\";s:9:\"dash-f142\";s:10:\"arrow_down\";s:9:\"dash-f140\";s:10:\"arrow_left\";s:9:\"dash-f141\";s:11:\"arrow_right\";s:9:\"dash-f139\";s:11:\"line_height\";s:3:\"1.7\";s:7:\"z_index\";s:3:\"999\";s:17:\"shadow_horizontal\";s:3:\"0px\";s:15:\"shadow_vertical\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"5px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_color\";s:15:\"rgba(0,0,0,0.1)\";s:24:\"keyboard_highlight_color\";s:15:\"rgb(16,156,222)\";s:24:\"keyboard_highlight_width\";s:3:\"3px\";s:25:\"keyboard_highlight_offset\";s:4:\"-3px\";s:21:\"menu_item_link_height\";s:4:\"40px\";s:25:\"container_background_from\";s:11:\"transparent\";s:23:\"container_background_to\";s:11:\"transparent\";s:21:\"container_padding_top\";s:3:\"0px\";s:23:\"container_padding_right\";s:3:\"0px\";s:24:\"container_padding_bottom\";s:3:\"0px\";s:22:\"container_padding_left\";s:3:\"0px\";s:32:\"container_border_radius_top_left\";s:3:\"0px\";s:33:\"container_border_radius_top_right\";s:3:\"0px\";s:36:\"container_border_radius_bottom_right\";s:3:\"0px\";s:35:\"container_border_radius_bottom_left\";s:3:\"0px\";s:15:\"menu_item_align\";s:4:\"left\";s:20:\"menu_item_link_color\";s:16:\"rgb(255,255,255)\";s:24:\"menu_item_link_font_size\";s:4:\"14px\";s:19:\"menu_item_link_font\";s:7:\"inherit\";s:29:\"menu_item_link_text_transform\";s:4:\"none\";s:21:\"menu_item_link_weight\";s:6:\"normal\";s:30:\"menu_item_link_text_decoration\";s:4:\"none\";s:25:\"menu_item_link_text_align\";s:4:\"left\";s:26:\"menu_item_link_color_hover\";s:16:\"rgb(255,255,255)\";s:27:\"menu_item_link_weight_hover\";s:6:\"normal\";s:36:\"menu_item_link_text_decoration_hover\";s:4:\"none\";s:25:\"menu_item_background_from\";s:11:\"transparent\";s:23:\"menu_item_background_to\";s:11:\"transparent\";s:31:\"menu_item_background_hover_from\";s:11:\"transparent\";s:29:\"menu_item_background_hover_to\";s:11:\"transparent\";s:17:\"menu_item_spacing\";s:3:\"0px\";s:26:\"menu_item_link_padding_top\";s:3:\"0px\";s:28:\"menu_item_link_padding_right\";s:4:\"10px\";s:29:\"menu_item_link_padding_bottom\";s:3:\"0px\";s:27:\"menu_item_link_padding_left\";s:4:\"10px\";s:22:\"menu_item_border_color\";s:16:\"rgb(255,255,255)\";s:28:\"menu_item_border_color_hover\";s:16:\"rgb(255,255,255)\";s:20:\"menu_item_border_top\";s:3:\"0px\";s:22:\"menu_item_border_right\";s:3:\"0px\";s:23:\"menu_item_border_bottom\";s:3:\"0px\";s:21:\"menu_item_border_left\";s:3:\"0px\";s:37:\"menu_item_link_border_radius_top_left\";s:3:\"0px\";s:38:\"menu_item_link_border_radius_top_right\";s:3:\"0px\";s:41:\"menu_item_link_border_radius_bottom_right\";s:3:\"0px\";s:40:\"menu_item_link_border_radius_bottom_left\";s:3:\"0px\";s:23:\"menu_item_divider_color\";s:21:\"rgba(255,255,255,0.1)\";s:30:\"menu_item_divider_glow_opacity\";s:3:\"0.1\";s:27:\"menu_item_highlight_current\";s:2:\"on\";s:11:\"panel_width\";s:4:\"100%\";s:17:\"panel_inner_width\";s:4:\"100%\";s:21:\"panel_background_from\";s:16:\"rgb(241,241,241)\";s:19:\"panel_background_to\";s:16:\"rgb(241,241,241)\";s:17:\"panel_padding_top\";s:3:\"0px\";s:19:\"panel_padding_right\";s:3:\"0px\";s:20:\"panel_padding_bottom\";s:3:\"0px\";s:18:\"panel_padding_left\";s:3:\"0px\";s:18:\"panel_border_color\";s:16:\"rgb(255,255,255)\";s:16:\"panel_border_top\";s:3:\"0px\";s:18:\"panel_border_right\";s:3:\"0px\";s:19:\"panel_border_bottom\";s:3:\"0px\";s:17:\"panel_border_left\";s:3:\"0px\";s:28:\"panel_border_radius_top_left\";s:3:\"0px\";s:29:\"panel_border_radius_top_right\";s:3:\"0px\";s:32:\"panel_border_radius_bottom_right\";s:3:\"0px\";s:31:\"panel_border_radius_bottom_left\";s:3:\"0px\";s:24:\"panel_widget_padding_top\";s:4:\"15px\";s:26:\"panel_widget_padding_right\";s:4:\"15px\";s:27:\"panel_widget_padding_bottom\";s:4:\"15px\";s:25:\"panel_widget_padding_left\";s:4:\"15px\";s:18:\"panel_header_color\";s:13:\"rgb(85,85,85)\";s:22:\"panel_header_font_size\";s:4:\"16px\";s:17:\"panel_header_font\";s:7:\"inherit\";s:27:\"panel_header_text_transform\";s:9:\"uppercase\";s:24:\"panel_header_font_weight\";s:4:\"bold\";s:28:\"panel_header_text_decoration\";s:4:\"none\";s:23:\"panel_header_text_align\";s:4:\"left\";s:24:\"panel_header_padding_top\";s:3:\"0px\";s:26:\"panel_header_padding_right\";s:3:\"0px\";s:27:\"panel_header_padding_bottom\";s:3:\"5px\";s:25:\"panel_header_padding_left\";s:3:\"0px\";s:23:\"panel_header_margin_top\";s:3:\"0px\";s:25:\"panel_header_margin_right\";s:3:\"0px\";s:26:\"panel_header_margin_bottom\";s:3:\"0px\";s:24:\"panel_header_margin_left\";s:3:\"0px\";s:25:\"panel_header_border_color\";s:11:\"transparent\";s:31:\"panel_header_border_color_hover\";s:11:\"transparent\";s:23:\"panel_header_border_top\";s:3:\"0px\";s:25:\"panel_header_border_right\";s:3:\"0px\";s:26:\"panel_header_border_bottom\";s:3:\"0px\";s:24:\"panel_header_border_left\";s:3:\"0px\";s:16:\"panel_font_color\";s:16:\"rgb(102,102,102)\";s:15:\"panel_font_size\";s:4:\"14px\";s:17:\"panel_font_family\";s:7:\"inherit\";s:29:\"panel_second_level_font_color\";s:13:\"rgb(85,85,85)\";s:28:\"panel_second_level_font_size\";s:4:\"16px\";s:23:\"panel_second_level_font\";s:7:\"inherit\";s:33:\"panel_second_level_text_transform\";s:9:\"uppercase\";s:30:\"panel_second_level_font_weight\";s:4:\"bold\";s:34:\"panel_second_level_text_decoration\";s:4:\"none\";s:29:\"panel_second_level_text_align\";s:4:\"left\";s:35:\"panel_second_level_font_color_hover\";s:13:\"rgb(85,85,85)\";s:36:\"panel_second_level_font_weight_hover\";s:4:\"bold\";s:40:\"panel_second_level_text_decoration_hover\";s:4:\"none\";s:40:\"panel_second_level_background_hover_from\";s:11:\"transparent\";s:38:\"panel_second_level_background_hover_to\";s:11:\"transparent\";s:30:\"panel_second_level_padding_top\";s:3:\"0px\";s:32:\"panel_second_level_padding_right\";s:3:\"0px\";s:33:\"panel_second_level_padding_bottom\";s:3:\"0px\";s:31:\"panel_second_level_padding_left\";s:3:\"0px\";s:29:\"panel_second_level_margin_top\";s:3:\"0px\";s:31:\"panel_second_level_margin_right\";s:3:\"0px\";s:32:\"panel_second_level_margin_bottom\";s:3:\"0px\";s:30:\"panel_second_level_margin_left\";s:3:\"0px\";s:31:\"panel_second_level_border_color\";s:11:\"transparent\";s:37:\"panel_second_level_border_color_hover\";s:11:\"transparent\";s:29:\"panel_second_level_border_top\";s:3:\"0px\";s:31:\"panel_second_level_border_right\";s:3:\"0px\";s:32:\"panel_second_level_border_bottom\";s:3:\"0px\";s:30:\"panel_second_level_border_left\";s:3:\"0px\";s:28:\"panel_third_level_font_color\";s:16:\"rgb(102,102,102)\";s:27:\"panel_third_level_font_size\";s:4:\"14px\";s:22:\"panel_third_level_font\";s:7:\"inherit\";s:32:\"panel_third_level_text_transform\";s:4:\"none\";s:29:\"panel_third_level_font_weight\";s:6:\"normal\";s:33:\"panel_third_level_text_decoration\";s:4:\"none\";s:28:\"panel_third_level_text_align\";s:4:\"left\";s:34:\"panel_third_level_font_color_hover\";s:16:\"rgb(102,102,102)\";s:35:\"panel_third_level_font_weight_hover\";s:6:\"normal\";s:39:\"panel_third_level_text_decoration_hover\";s:4:\"none\";s:39:\"panel_third_level_background_hover_from\";s:11:\"transparent\";s:37:\"panel_third_level_background_hover_to\";s:11:\"transparent\";s:29:\"panel_third_level_padding_top\";s:3:\"0px\";s:31:\"panel_third_level_padding_right\";s:3:\"0px\";s:32:\"panel_third_level_padding_bottom\";s:3:\"0px\";s:30:\"panel_third_level_padding_left\";s:3:\"0px\";s:28:\"panel_third_level_margin_top\";s:3:\"0px\";s:30:\"panel_third_level_margin_right\";s:3:\"0px\";s:31:\"panel_third_level_margin_bottom\";s:3:\"0px\";s:29:\"panel_third_level_margin_left\";s:3:\"0px\";s:30:\"panel_third_level_border_color\";s:11:\"transparent\";s:36:\"panel_third_level_border_color_hover\";s:11:\"transparent\";s:28:\"panel_third_level_border_top\";s:3:\"0px\";s:30:\"panel_third_level_border_right\";s:3:\"0px\";s:31:\"panel_third_level_border_bottom\";s:3:\"0px\";s:29:\"panel_third_level_border_left\";s:3:\"0px\";s:27:\"flyout_menu_background_from\";s:16:\"rgb(241,241,241)\";s:25:\"flyout_menu_background_to\";s:16:\"rgb(241,241,241)\";s:12:\"flyout_width\";s:5:\"250px\";s:18:\"flyout_padding_top\";s:3:\"0px\";s:20:\"flyout_padding_right\";s:3:\"0px\";s:21:\"flyout_padding_bottom\";s:3:\"0px\";s:19:\"flyout_padding_left\";s:3:\"0px\";s:19:\"flyout_border_color\";s:16:\"rgb(255,255,255)\";s:17:\"flyout_border_top\";s:3:\"0px\";s:19:\"flyout_border_right\";s:3:\"0px\";s:20:\"flyout_border_bottom\";s:3:\"0px\";s:18:\"flyout_border_left\";s:3:\"0px\";s:29:\"flyout_border_radius_top_left\";s:3:\"0px\";s:30:\"flyout_border_radius_top_right\";s:3:\"0px\";s:33:\"flyout_border_radius_bottom_right\";s:3:\"0px\";s:32:\"flyout_border_radius_bottom_left\";s:3:\"0px\";s:22:\"flyout_background_from\";s:16:\"rgb(241,241,241)\";s:20:\"flyout_background_to\";s:16:\"rgb(241,241,241)\";s:28:\"flyout_background_hover_from\";s:16:\"rgb(221,221,221)\";s:26:\"flyout_background_hover_to\";s:16:\"rgb(221,221,221)\";s:18:\"flyout_link_height\";s:4:\"35px\";s:23:\"flyout_link_padding_top\";s:3:\"0px\";s:25:\"flyout_link_padding_right\";s:4:\"10px\";s:26:\"flyout_link_padding_bottom\";s:3:\"0px\";s:24:\"flyout_link_padding_left\";s:4:\"10px\";s:17:\"flyout_link_color\";s:16:\"rgb(102,102,102)\";s:16:\"flyout_link_size\";s:4:\"14px\";s:18:\"flyout_link_family\";s:7:\"inherit\";s:26:\"flyout_link_text_transform\";s:4:\"none\";s:18:\"flyout_link_weight\";s:6:\"normal\";s:27:\"flyout_link_text_decoration\";s:4:\"none\";s:23:\"flyout_link_color_hover\";s:16:\"rgb(102,102,102)\";s:24:\"flyout_link_weight_hover\";s:6:\"normal\";s:33:\"flyout_link_text_decoration_hover\";s:4:\"none\";s:30:\"flyout_menu_item_divider_color\";s:21:\"rgba(255,255,255,0.1)\";s:21:\"responsive_breakpoint\";s:5:\"768px\";s:22:\"toggle_background_from\";s:13:\"rgb(34,34,34)\";s:20:\"toggle_background_to\";s:13:\"rgb(34,34,34)\";s:17:\"toggle_bar_height\";s:4:\"40px\";s:33:\"toggle_bar_border_radius_top_left\";s:3:\"2px\";s:34:\"toggle_bar_border_radius_top_right\";s:3:\"2px\";s:37:\"toggle_bar_border_radius_bottom_right\";s:3:\"2px\";s:36:\"toggle_bar_border_radius_bottom_left\";s:3:\"2px\";s:32:\"mobile_menu_force_width_selector\";s:4:\"body\";s:23:\"mobile_menu_item_height\";s:4:\"40px\";s:23:\"mobile_menu_padding_top\";s:3:\"0px\";s:25:\"mobile_menu_padding_right\";s:3:\"0px\";s:26:\"mobile_menu_padding_bottom\";s:3:\"0px\";s:24:\"mobile_menu_padding_left\";s:3:\"0px\";s:22:\"mobile_background_from\";s:13:\"rgb(34,34,34)\";s:20:\"mobile_background_to\";s:13:\"rgb(34,34,34)\";s:38:\"mobile_menu_item_background_hover_from\";s:13:\"rgb(51,51,51)\";s:36:\"mobile_menu_item_background_hover_to\";s:13:\"rgb(51,51,51)\";s:27:\"mobile_menu_item_link_color\";s:16:\"rgb(255,255,255)\";s:31:\"mobile_menu_item_link_font_size\";s:4:\"14px\";s:32:\"mobile_menu_item_link_text_align\";s:4:\"left\";s:33:\"mobile_menu_item_link_color_hover\";s:16:\"rgb(255,255,255)\";s:28:\"mobile_menu_off_canvas_width\";s:5:\"300px\";s:10:\"close_icon\";s:9:\"dash-f158\";s:20:\"close_icon_font_size\";s:4:\"16px\";s:16:\"close_icon_color\";s:16:\"rgb(255,255,255)\";s:16:\"close_icon_label\";s:5:\"Close\";s:14:\"mobile_columns\";s:1:\"1\";s:10:\"custom_css\";s:67:\"/** Push menu onto new line **/ \r\n#{$wrap} { \r\n    clear: both; \r\n}\";s:6:\"shadow\";s:3:\"off\";s:11:\"transitions\";s:3:\"off\";s:6:\"resets\";s:3:\"off\";s:12:\"use_flex_css\";s:3:\"off\";s:17:\"menu_item_divider\";s:3:\"off\";s:24:\"flyout_menu_item_divider\";s:3:\"off\";s:21:\"disable_mobile_toggle\";s:3:\"off\";s:19:\"mobile_menu_overlay\";s:3:\"off\";s:23:\"mobile_menu_force_width\";s:3:\"off\";}}", "auto");
INSERT INTO `wpvv_options` VALUES("2240", "megamenu_themes_last_updated", "default", "auto");
INSERT INTO `wpvv_options` VALUES("2241", "megamenu_toggle_blocks", "a:1:{s:7:\"default\";a:1:{i:0;a:6:{s:4:\"type\";s:20:\"menu_toggle_animated\";s:5:\"align\";s:5:\"right\";s:5:\"style\";s:6:\"slider\";s:10:\"icon_color\";s:16:\"rgb(221,221,221)\";s:10:\"icon_scale\";s:3:\"0.8\";s:10:\"aria_label\";s:11:\"Toggle Menu\";}}}", "auto");
INSERT INTO `wpvv_options` VALUES("2331", "_transient_timeout_megamenu_css", "4910062785", "off");
INSERT INTO `wpvv_options` VALUES("2332", "_transient_megamenu_css", "@charset \"UTF-8\";\n\n/** THIS FILE IS AUTOMATICALLY GENERATED - DO NOT MAKE MANUAL EDITS! **/\n/** Custom CSS should be added to Mega Menu > Menu Themes > Custom Styling **/\n\n.mega-menu-last-modified-1756462785 { content: \'Friday 29th August 2025 10:19:45 UTC\'; }\n\n#mega-menu-wrap-menu-1, #mega-menu-wrap-menu-1 #mega-menu-menu-1, #mega-menu-wrap-menu-1 #mega-menu-menu-1 ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item, #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-row, #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-column, #mega-menu-wrap-menu-1 #mega-menu-menu-1 a.mega-menu-link, #mega-menu-wrap-menu-1 #mega-menu-menu-1 span.mega-menu-badge, #mega-menu-wrap-menu-1 button.mega-close, #mega-menu-wrap-menu-1 button.mega-toggle-standard {\n  transition: none;\n  border-radius: 0;\n  box-shadow: none;\n  background: none;\n  border: 0;\n  bottom: auto;\n  box-sizing: border-box;\n  clip: auto;\n  color: #666;\n  display: block;\n  float: none;\n  font-family: inherit;\n  font-size: 14px;\n  height: auto;\n  left: auto;\n  line-height: 1.7;\n  list-style-type: none;\n  margin: 0;\n  min-height: auto;\n  max-height: none;\n  min-width: auto;\n  max-width: none;\n  opacity: 1;\n  outline: none;\n  overflow: visible;\n  padding: 0;\n  position: relative;\n  pointer-events: auto;\n  right: auto;\n  text-align: left;\n  text-decoration: none;\n  text-indent: 0;\n  text-transform: none;\n  transform: none;\n  top: auto;\n  vertical-align: baseline;\n  visibility: inherit;\n  width: auto;\n  word-wrap: break-word;\n  white-space: normal;\n  -webkit-tap-highlight-color: transparent;\n}\n#mega-menu-wrap-menu-1:before, #mega-menu-wrap-menu-1:after, #mega-menu-wrap-menu-1 #mega-menu-menu-1:before, #mega-menu-wrap-menu-1 #mega-menu-menu-1:after, #mega-menu-wrap-menu-1 #mega-menu-menu-1 ul.mega-sub-menu:before, #mega-menu-wrap-menu-1 #mega-menu-menu-1 ul.mega-sub-menu:after, #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item:before, #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item:after, #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-row:before, #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-row:after, #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-column:before, #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-column:after, #mega-menu-wrap-menu-1 #mega-menu-menu-1 a.mega-menu-link:before, #mega-menu-wrap-menu-1 #mega-menu-menu-1 a.mega-menu-link:after, #mega-menu-wrap-menu-1 #mega-menu-menu-1 span.mega-menu-badge:before, #mega-menu-wrap-menu-1 #mega-menu-menu-1 span.mega-menu-badge:after, #mega-menu-wrap-menu-1 button.mega-close:before, #mega-menu-wrap-menu-1 button.mega-close:after, #mega-menu-wrap-menu-1 button.mega-toggle-standard:before, #mega-menu-wrap-menu-1 button.mega-toggle-standard:after {\n  display: none;\n}\n#mega-menu-wrap-menu-1 {\n  border-radius: 0px;\n}\n@media only screen and (min-width: 769px) {\n  #mega-menu-wrap-menu-1 {\n    background: transparent;\n  }\n}\n#mega-menu-wrap-menu-1.mega-keyboard-navigation .mega-menu-toggle:focus, #mega-menu-wrap-menu-1.mega-keyboard-navigation .mega-toggle-block:focus, #mega-menu-wrap-menu-1.mega-keyboard-navigation .mega-toggle-block a:focus, #mega-menu-wrap-menu-1.mega-keyboard-navigation .mega-toggle-block .mega-search input[type=text]:focus, #mega-menu-wrap-menu-1.mega-keyboard-navigation .mega-toggle-block button.mega-toggle-animated:focus, #mega-menu-wrap-menu-1.mega-keyboard-navigation #mega-menu-menu-1 a:focus, #mega-menu-wrap-menu-1.mega-keyboard-navigation #mega-menu-menu-1 span:focus, #mega-menu-wrap-menu-1.mega-keyboard-navigation #mega-menu-menu-1 input:focus, #mega-menu-wrap-menu-1.mega-keyboard-navigation #mega-menu-menu-1 li.mega-menu-item a.mega-menu-link:focus, #mega-menu-wrap-menu-1.mega-keyboard-navigation #mega-menu-menu-1 form.mega-search-open:has(input[type=text]:focus), #mega-menu-wrap-menu-1.mega-keyboard-navigation #mega-menu-menu-1 + button.mega-close:focus {\n  outline-style: solid;\n  outline-width: 3px;\n  outline-color: #109cde;\n  outline-offset: -3px;\n}\n#mega-menu-wrap-menu-1.mega-keyboard-navigation .mega-toggle-block button.mega-toggle-animated:focus {\n  outline-offset: 2px;\n}\n#mega-menu-wrap-menu-1.mega-keyboard-navigation > li.mega-menu-item > a.mega-menu-link:focus {\n  background: transparent;\n  color: white;\n  font-weight: normal;\n  text-decoration: none;\n  border-color: white;\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1.mega-keyboard-navigation > li.mega-menu-item > a.mega-menu-link:focus {\n    color: white;\n    background: #333;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 {\n  text-align: left;\n  padding: 0px;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 a.mega-menu-link {\n  cursor: pointer;\n  display: inline;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 a.mega-menu-link .mega-description-group {\n  vertical-align: middle;\n  display: inline-block;\n  transition: none;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 a.mega-menu-link .mega-description-group .mega-menu-title, #mega-menu-wrap-menu-1 #mega-menu-menu-1 a.mega-menu-link .mega-description-group .mega-menu-description {\n  transition: none;\n  line-height: 1.5;\n  display: block;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 a.mega-menu-link .mega-description-group .mega-menu-description {\n  font-style: italic;\n  font-size: 0.8em;\n  text-transform: none;\n  font-weight: normal;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu li.mega-menu-item.mega-icon-left.mega-has-description.mega-has-icon > a.mega-menu-link {\n  display: flex;\n  align-items: center;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu li.mega-menu-item.mega-icon-left.mega-has-description.mega-has-icon > a.mega-menu-link:before {\n  flex: 0 0 auto;\n  align-self: flex-start;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-tabbed.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item.mega-icon-left.mega-has-description.mega-has-icon > a.mega-menu-link {\n  display: block;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-icon-top > a.mega-menu-link {\n  display: table-cell;\n  vertical-align: middle;\n  line-height: initial;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-icon-top > a.mega-menu-link:before {\n  display: block;\n  margin: 0 0 6px 0;\n  text-align: center;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-icon-top > a.mega-menu-link > span.mega-title-below {\n  display: inline-block;\n  transition: none;\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-icon-top > a.mega-menu-link {\n    display: block;\n    line-height: 40px;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-icon-top > a.mega-menu-link:before {\n    display: inline-block;\n    margin: 0 6px 0 0;\n    text-align: left;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-icon-right > a.mega-menu-link:before {\n  float: right;\n  margin: 0 0 0 6px;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-animating > ul.mega-sub-menu {\n  pointer-events: none;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-disable-link > a.mega-menu-link, #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu li.mega-disable-link > a.mega-menu-link {\n  cursor: inherit;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item-has-children.mega-disable-link > a.mega-menu-link, #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > li.mega-menu-item-has-children.mega-disable-link > a.mega-menu-link {\n  cursor: pointer;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 p {\n  margin-bottom: 10px;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 input, #mega-menu-wrap-menu-1 #mega-menu-menu-1 img {\n  max-width: 100%;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item > ul.mega-sub-menu {\n  display: block;\n  visibility: hidden;\n  opacity: 1;\n  pointer-events: auto;\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item > ul.mega-sub-menu {\n    display: none;\n    visibility: visible;\n    opacity: 1;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-toggle-on > ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu.mega-menu-item.mega-toggle-on ul.mega-sub-menu {\n    display: block;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu.mega-menu-item.mega-toggle-on li.mega-hide-sub-menu-on-mobile > ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-hide-sub-menu-on-mobile > ul.mega-sub-menu {\n    display: none;\n  }\n}\n@media only screen and (min-width: 769px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"fade\"] li.mega-menu-item > ul.mega-sub-menu {\n    opacity: 0;\n    transition: opacity 200ms ease-in, visibility 200ms ease-in;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"fade\"].mega-no-js li.mega-menu-item:hover > ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"fade\"].mega-no-js li.mega-menu-item:focus > ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"fade\"] li.mega-menu-item.mega-toggle-on > ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"fade\"] li.mega-menu-item.mega-menu-megamenu.mega-toggle-on ul.mega-sub-menu {\n    opacity: 1;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"fade_up\"] li.mega-menu-item.mega-menu-megamenu > ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"fade_up\"] li.mega-menu-item.mega-menu-flyout ul.mega-sub-menu {\n    opacity: 0;\n    transform: translate(0, 10px);\n    transition: opacity 200ms ease-in, transform 200ms ease-in, visibility 200ms ease-in;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"fade_up\"].mega-no-js li.mega-menu-item:hover > ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"fade_up\"].mega-no-js li.mega-menu-item:focus > ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"fade_up\"] li.mega-menu-item.mega-toggle-on > ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"fade_up\"] li.mega-menu-item.mega-menu-megamenu.mega-toggle-on ul.mega-sub-menu {\n    opacity: 1;\n    transform: translate(0, 0);\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"slide_up\"] li.mega-menu-item.mega-menu-megamenu > ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"slide_up\"] li.mega-menu-item.mega-menu-flyout ul.mega-sub-menu {\n    transform: translate(0, 10px);\n    transition: transform 200ms ease-in, visibility 200ms ease-in;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"slide_up\"].mega-no-js li.mega-menu-item:hover > ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"slide_up\"].mega-no-js li.mega-menu-item:focus > ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"slide_up\"] li.mega-menu-item.mega-toggle-on > ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1[data-effect=\"slide_up\"] li.mega-menu-item.mega-menu-megamenu.mega-toggle-on ul.mega-sub-menu {\n    transform: translate(0, 0);\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu li.mega-collapse-children > ul.mega-sub-menu {\n  display: none;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu li.mega-collapse-children.mega-toggle-on > ul.mega-sub-menu {\n  display: block;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1.mega-no-js li.mega-menu-item:hover > ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1.mega-no-js li.mega-menu-item:focus > ul.mega-sub-menu, #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-toggle-on > ul.mega-sub-menu {\n  visibility: visible;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu ul.mega-sub-menu {\n  visibility: inherit;\n  opacity: 1;\n  display: block;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu li.mega-1-columns > ul.mega-sub-menu > li.mega-menu-item {\n  float: left;\n  width: 100%;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu li.mega-2-columns > ul.mega-sub-menu > li.mega-menu-item {\n  float: left;\n  width: 50%;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu li.mega-3-columns > ul.mega-sub-menu > li.mega-menu-item {\n  float: left;\n  width: 33.3333333333%;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu li.mega-4-columns > ul.mega-sub-menu > li.mega-menu-item {\n  float: left;\n  width: 25%;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu li.mega-5-columns > ul.mega-sub-menu > li.mega-menu-item {\n  float: left;\n  width: 20%;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-menu-megamenu ul.mega-sub-menu li.mega-6-columns > ul.mega-sub-menu > li.mega-menu-item {\n  float: left;\n  width: 16.6666666667%;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item a[class^=\"dashicons\"]:before {\n  font-family: dashicons;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item a.mega-menu-link:before {\n  display: inline-block;\n  font: inherit;\n  font-family: dashicons;\n  position: static;\n  margin: 0 6px 0 0px;\n  vertical-align: top;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  color: inherit;\n  background: transparent;\n  height: auto;\n  width: auto;\n  top: auto;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-hide-text a.mega-menu-link:before {\n  margin: 0;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item.mega-hide-text li.mega-menu-item a.mega-menu-link:before {\n  margin: 0 6px 0 0;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-align-bottom-left.mega-toggle-on > a.mega-menu-link {\n  border-radius: 0px;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-align-bottom-right > ul.mega-sub-menu {\n  right: 0;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-align-bottom-right.mega-toggle-on > a.mega-menu-link {\n  border-radius: 0px;\n}\n@media only screen and (min-width: 769px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu.mega-menu-item {\n    position: static;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item {\n  margin: 0 0px 0 0;\n  display: inline-block;\n  height: auto;\n  vertical-align: middle;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-item-align-right {\n  float: right;\n}\n@media only screen and (min-width: 769px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-item-align-right {\n    margin: 0 0 0 0px;\n  }\n}\n@media only screen and (min-width: 769px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-item-align-float-left {\n    float: left;\n  }\n}\n@media only screen and (min-width: 769px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item > a.mega-menu-link:hover, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item > a.mega-menu-link:focus {\n    background: transparent;\n    color: white;\n    font-weight: normal;\n    text-decoration: none;\n    border-color: white;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-toggle-on > a.mega-menu-link {\n  background: transparent;\n  color: white;\n  font-weight: normal;\n  text-decoration: none;\n  border-color: white;\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-toggle-on > a.mega-menu-link {\n    color: white;\n    background: #333;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-current-menu-item > a.mega-menu-link, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-current-menu-ancestor > a.mega-menu-link, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-current-page-ancestor > a.mega-menu-link {\n  background: transparent;\n  color: white;\n  font-weight: normal;\n  text-decoration: none;\n  border-color: white;\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-current-menu-item > a.mega-menu-link, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-current-menu-ancestor > a.mega-menu-link, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-current-page-ancestor > a.mega-menu-link {\n    color: white;\n    background: #333;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item > a.mega-menu-link {\n  line-height: 40px;\n  height: 40px;\n  padding: 0px 10px;\n  vertical-align: baseline;\n  width: auto;\n  display: block;\n  color: white;\n  text-transform: none;\n  text-decoration: none;\n  text-align: left;\n  background: transparent;\n  border: 0;\n  border-radius: 0px;\n  font-family: inherit;\n  font-size: 14px;\n  font-weight: normal;\n  outline: none;\n}\n@media only screen and (min-width: 769px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-multi-line > a.mega-menu-link {\n    line-height: inherit;\n    display: table-cell;\n    vertical-align: middle;\n  }\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-multi-line > a.mega-menu-link br {\n    display: none;\n  }\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item {\n    display: list-item;\n    margin: 0;\n    clear: both;\n    border: 0;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item.mega-item-align-right {\n    float: none;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-item > a.mega-menu-link {\n    border-radius: 0;\n    border: 0;\n    margin: 0;\n    line-height: 40px;\n    height: 40px;\n    padding: 0 10px;\n    background: transparent;\n    text-align: left;\n    color: white;\n    font-size: 14px;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row {\n  width: 100%;\n  float: left;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row .mega-menu-column {\n  float: left;\n  min-height: 1px;\n}\n@media only screen and (min-width: 769px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-1 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-2 {\n    width: 50%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-2 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-3 {\n    width: 33.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-3 {\n    width: 66.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-3 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-4 {\n    width: 25%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-4 {\n    width: 50%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-4 {\n    width: 75%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-4 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-5 {\n    width: 20%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-5 {\n    width: 40%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-5 {\n    width: 60%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-5 {\n    width: 80%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-5 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-6 {\n    width: 16.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-6 {\n    width: 33.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-6 {\n    width: 50%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-6 {\n    width: 66.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-6 {\n    width: 83.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-6-of-6 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-7 {\n    width: 14.2857142857%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-7 {\n    width: 28.5714285714%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-7 {\n    width: 42.8571428571%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-7 {\n    width: 57.1428571429%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-7 {\n    width: 71.4285714286%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-6-of-7 {\n    width: 85.7142857143%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-7-of-7 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-8 {\n    width: 12.5%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-8 {\n    width: 25%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-8 {\n    width: 37.5%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-8 {\n    width: 50%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-8 {\n    width: 62.5%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-6-of-8 {\n    width: 75%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-7-of-8 {\n    width: 87.5%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-8-of-8 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-9 {\n    width: 11.1111111111%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-9 {\n    width: 22.2222222222%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-9 {\n    width: 33.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-9 {\n    width: 44.4444444444%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-9 {\n    width: 55.5555555556%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-6-of-9 {\n    width: 66.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-7-of-9 {\n    width: 77.7777777778%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-8-of-9 {\n    width: 88.8888888889%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-9-of-9 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-10 {\n    width: 10%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-10 {\n    width: 20%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-10 {\n    width: 30%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-10 {\n    width: 40%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-10 {\n    width: 50%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-6-of-10 {\n    width: 60%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-7-of-10 {\n    width: 70%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-8-of-10 {\n    width: 80%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-9-of-10 {\n    width: 90%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-10-of-10 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-11 {\n    width: 9.0909090909%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-11 {\n    width: 18.1818181818%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-11 {\n    width: 27.2727272727%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-11 {\n    width: 36.3636363636%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-11 {\n    width: 45.4545454545%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-6-of-11 {\n    width: 54.5454545455%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-7-of-11 {\n    width: 63.6363636364%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-8-of-11 {\n    width: 72.7272727273%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-9-of-11 {\n    width: 81.8181818182%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-10-of-11 {\n    width: 90.9090909091%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-11-of-11 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-1-of-12 {\n    width: 8.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-2-of-12 {\n    width: 16.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-3-of-12 {\n    width: 25%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-4-of-12 {\n    width: 33.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-5-of-12 {\n    width: 41.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-6-of-12 {\n    width: 50%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-7-of-12 {\n    width: 58.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-8-of-12 {\n    width: 66.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-9-of-12 {\n    width: 75%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-10-of-12 {\n    width: 83.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-11-of-12 {\n    width: 91.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-columns-12-of-12 {\n    width: 100%;\n  }\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row > ul.mega-sub-menu > li.mega-menu-column {\n    width: 100%;\n    clear: both;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-row .mega-menu-column > ul.mega-sub-menu > li.mega-menu-item {\n  padding: 15px;\n  width: 100%;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu {\n  z-index: 999;\n  border-radius: 0px;\n  background: #f1f1f1;\n  border: 0;\n  padding: 0px;\n  position: absolute;\n  width: 100%;\n  max-width: none;\n  left: 0;\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu {\n    float: left;\n    position: static;\n    width: 100%;\n  }\n}\n@media only screen and (min-width: 769px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-1 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-2 {\n    width: 50%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-2 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-3 {\n    width: 33.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-3 {\n    width: 66.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-3 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-4 {\n    width: 25%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-4 {\n    width: 50%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-4 {\n    width: 75%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-4-of-4 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-5 {\n    width: 20%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-5 {\n    width: 40%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-5 {\n    width: 60%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-4-of-5 {\n    width: 80%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-5-of-5 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-6 {\n    width: 16.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-6 {\n    width: 33.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-6 {\n    width: 50%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-4-of-6 {\n    width: 66.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-5-of-6 {\n    width: 83.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-6-of-6 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-7 {\n    width: 14.2857142857%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-7 {\n    width: 28.5714285714%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-7 {\n    width: 42.8571428571%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-4-of-7 {\n    width: 57.1428571429%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-5-of-7 {\n    width: 71.4285714286%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-6-of-7 {\n    width: 85.7142857143%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-7-of-7 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-8 {\n    width: 12.5%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-8 {\n    width: 25%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-8 {\n    width: 37.5%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-4-of-8 {\n    width: 50%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-5-of-8 {\n    width: 62.5%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-6-of-8 {\n    width: 75%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-7-of-8 {\n    width: 87.5%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-8-of-8 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-9 {\n    width: 11.1111111111%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-9 {\n    width: 22.2222222222%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-9 {\n    width: 33.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-4-of-9 {\n    width: 44.4444444444%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-5-of-9 {\n    width: 55.5555555556%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-6-of-9 {\n    width: 66.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-7-of-9 {\n    width: 77.7777777778%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-8-of-9 {\n    width: 88.8888888889%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-9-of-9 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-10 {\n    width: 10%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-10 {\n    width: 20%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-10 {\n    width: 30%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-4-of-10 {\n    width: 40%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-5-of-10 {\n    width: 50%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-6-of-10 {\n    width: 60%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-7-of-10 {\n    width: 70%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-8-of-10 {\n    width: 80%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-9-of-10 {\n    width: 90%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-10-of-10 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-11 {\n    width: 9.0909090909%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-11 {\n    width: 18.1818181818%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-11 {\n    width: 27.2727272727%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-4-of-11 {\n    width: 36.3636363636%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-5-of-11 {\n    width: 45.4545454545%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-6-of-11 {\n    width: 54.5454545455%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-7-of-11 {\n    width: 63.6363636364%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-8-of-11 {\n    width: 72.7272727273%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-9-of-11 {\n    width: 81.8181818182%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-10-of-11 {\n    width: 90.9090909091%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-11-of-11 {\n    width: 100%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-1-of-12 {\n    width: 8.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-2-of-12 {\n    width: 16.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-3-of-12 {\n    width: 25%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-4-of-12 {\n    width: 33.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-5-of-12 {\n    width: 41.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-6-of-12 {\n    width: 50%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-7-of-12 {\n    width: 58.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-8-of-12 {\n    width: 66.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-9-of-12 {\n    width: 75%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-10-of-12 {\n    width: 83.3333333333%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-11-of-12 {\n    width: 91.6666666667%;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-columns-12-of-12 {\n    width: 100%;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu .mega-description-group .mega-menu-description {\n  margin: 5px 0;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item ul.mega-sub-menu {\n  clear: both;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item ul.mega-sub-menu li.mega-menu-item ul.mega-sub-menu {\n  margin-left: 10px;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu ul.mega-sub-menu ul.mega-sub-menu {\n  margin-left: 10px;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column-standard, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item {\n  color: #666;\n  font-family: inherit;\n  font-size: 14px;\n  display: block;\n  float: left;\n  clear: none;\n  padding: 15px;\n  vertical-align: top;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column-standard.mega-menu-clear, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item.mega-menu-clear {\n  clear: left;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column-standard h4.mega-block-title, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item h4.mega-block-title {\n  color: #555;\n  font-family: inherit;\n  font-size: 16px;\n  text-transform: uppercase;\n  text-decoration: none;\n  font-weight: bold;\n  text-align: left;\n  margin: 0px 0px 0px 0px;\n  padding: 0px 0px 5px 0px;\n  vertical-align: top;\n  display: block;\n  visibility: inherit;\n  border: 0;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column-standard h4.mega-block-title:hover, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item h4.mega-block-title:hover {\n  border-color: transparent;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column-standard > a.mega-menu-link, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link {\n  color: #555;\n  /* Mega Menu > Menu Themes > Mega Menus > Second Level Menu Items */\n  font-family: inherit;\n  font-size: 16px;\n  text-transform: uppercase;\n  text-decoration: none;\n  font-weight: bold;\n  text-align: left;\n  margin: 0px 0px 0px 0px;\n  padding: 0px;\n  vertical-align: top;\n  display: block;\n  border: 0;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column-standard > a.mega-menu-link:hover, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover {\n  border-color: transparent;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column-standard > a.mega-menu-link:hover, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column-standard > a.mega-menu-link:focus, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:focus {\n  color: #555;\n  /* Mega Menu > Menu Themes > Mega Menus > Second Level Menu Items (Hover) */\n  font-weight: bold;\n  text-decoration: none;\n  background: transparent;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column-standard > a.mega-menu-link:hover > span.mega-title-below, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column-standard > a.mega-menu-link:focus > span.mega-title-below, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover > span.mega-title-below, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:focus > span.mega-title-below {\n  text-decoration: none;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column-standard li.mega-menu-item > a.mega-menu-link, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link {\n  color: #666;\n  /* Mega Menu > Menu Themes > Mega Menus > Third Level Menu Items */\n  font-family: inherit;\n  font-size: 14px;\n  text-transform: none;\n  text-decoration: none;\n  font-weight: normal;\n  text-align: left;\n  margin: 0px 0px 0px 0px;\n  padding: 0px;\n  vertical-align: top;\n  display: block;\n  border: 0;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column-standard li.mega-menu-item > a.mega-menu-link:hover, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link:hover {\n  border-color: transparent;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column-standard li.mega-menu-item.mega-icon-left.mega-has-description.mega-has-icon > a.mega-menu-link, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item.mega-icon-left.mega-has-description.mega-has-icon > a.mega-menu-link {\n  display: flex;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column-standard li.mega-menu-item > a.mega-menu-link:hover, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column-standard li.mega-menu-item > a.mega-menu-link:focus, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link:hover, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item li.mega-menu-item > a.mega-menu-link:focus {\n  color: #666;\n  /* Mega Menu > Menu Themes > Mega Menus > Third Level Menu Items (Hover) */\n  font-weight: normal;\n  text-decoration: none;\n  background: transparent;\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu {\n    border: 0;\n    padding: 10px;\n    border-radius: 0;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item {\n    width: 100%;\n    clear: both;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu.mega-no-headers > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu.mega-no-headers > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link {\n  color: #666;\n  font-family: inherit;\n  font-size: 14px;\n  text-transform: none;\n  text-decoration: none;\n  font-weight: normal;\n  margin: 0;\n  border: 0;\n  padding: 0px;\n  vertical-align: top;\n  display: block;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu.mega-no-headers > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu.mega-no-headers > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:focus, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu.mega-no-headers > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:hover, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu.mega-no-headers > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item > a.mega-menu-link:focus {\n  color: #666;\n  font-weight: normal;\n  text-decoration: none;\n  background: transparent;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-flyout ul.mega-sub-menu {\n  z-index: 999;\n  position: absolute;\n  width: 250px;\n  max-width: none;\n  padding: 0px;\n  border: 0;\n  background: #f1f1f1;\n  border-radius: 0px;\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-flyout ul.mega-sub-menu {\n    float: left;\n    position: static;\n    width: 100%;\n    padding: 0;\n    border: 0;\n    border-radius: 0;\n  }\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item {\n    clear: both;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link {\n  display: block;\n  background: #f1f1f1;\n  color: #666;\n  font-family: inherit;\n  font-size: 14px;\n  font-weight: normal;\n  padding: 0px 10px;\n  line-height: 35px;\n  text-decoration: none;\n  text-transform: none;\n  vertical-align: baseline;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item:first-child > a.mega-menu-link {\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item:first-child > a.mega-menu-link {\n    border-top-left-radius: 0;\n    border-top-right-radius: 0;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item:last-child > a.mega-menu-link {\n  border-bottom-right-radius: 0px;\n  border-bottom-left-radius: 0px;\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item:last-child > a.mega-menu-link {\n    border-bottom-right-radius: 0;\n    border-bottom-left-radius: 0;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link:hover, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item a.mega-menu-link:focus {\n  background: #ddd;\n  font-weight: normal;\n  text-decoration: none;\n  color: #666;\n}\n@media only screen and (min-width: 769px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item ul.mega-sub-menu {\n    position: absolute;\n    left: 100%;\n    top: 0;\n  }\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item ul.mega-sub-menu a.mega-menu-link {\n    padding-left: 20px;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-flyout ul.mega-sub-menu li.mega-menu-item ul.mega-sub-menu ul.mega-sub-menu a.mega-menu-link {\n    padding-left: 30px;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator {\n  display: inline-block;\n  width: auto;\n  background: transparent;\n  position: relative;\n  pointer-events: auto;\n  left: auto;\n  min-width: auto;\n  font-size: inherit;\n  padding: 0;\n  margin: 0 0 0 6px;\n  height: auto;\n  line-height: inherit;\n  color: inherit;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator:after {\n  content: \"\";\n  font-family: dashicons;\n  font-weight: normal;\n  display: inline-block;\n  margin: 0;\n  vertical-align: top;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  transform: rotate(0);\n  color: inherit;\n  position: relative;\n  background: transparent;\n  height: auto;\n  width: auto;\n  right: auto;\n  line-height: inherit;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item-has-children li.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator {\n  float: right;\n  margin-left: auto;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item-has-children.mega-collapse-children.mega-toggle-on > a.mega-menu-link > span.mega-indicator:after {\n  content: \"\";\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item-has-children > a.mega-menu-link > span.mega-indicator {\n    float: right;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item-has-children.mega-toggle-on > a.mega-menu-link > span.mega-indicator:after {\n    content: \"\";\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item-has-children.mega-hide-sub-menu-on-mobile > a.mega-menu-link > span.mega-indicator {\n    display: none;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-megamenu:not(.mega-menu-tabbed) li.mega-menu-item-has-children:not(.mega-collapse-children) > a.mega-menu-link > span.mega-indicator, #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-item-has-children.mega-hide-arrow > a.mega-menu-link > span.mega-indicator {\n  display: none;\n}\n@media only screen and (min-width: 769px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-flyout li.mega-menu-item a.mega-menu-link > span.mega-indicator:after {\n    content: \"\";\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-flyout.mega-align-bottom-right li.mega-menu-item a.mega-menu-link {\n    text-align: right;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-flyout.mega-align-bottom-right li.mega-menu-item a.mega-menu-link > span.mega-indicator {\n    float: left;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-flyout.mega-align-bottom-right li.mega-menu-item a.mega-menu-link > span.mega-indicator:after {\n    content: \"\";\n    margin: 0 6px 0 0;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-flyout.mega-align-bottom-right li.mega-menu-item a.mega-menu-link:before {\n    float: right;\n    margin: 0 0 0 6px;\n  }\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-menu-flyout.mega-align-bottom-right ul.mega-sub-menu li.mega-menu-item ul.mega-sub-menu {\n    left: -100%;\n    top: 0;\n  }\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 li[class^=\"mega-lang-item\"] > a.mega-menu-link > img {\n  display: inline;\n}\n#mega-menu-wrap-menu-1 #mega-menu-menu-1 a.mega-menu-link > img.wpml-ls-flag, #mega-menu-wrap-menu-1 #mega-menu-menu-1 a.mega-menu-link > img.iclflag {\n  display: inline;\n  margin-right: 8px;\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-hide-on-mobile, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-hide-on-mobile, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item.mega-hide-on-mobile {\n    display: none;\n  }\n}\n@media only screen and (min-width: 769px) {\n  #mega-menu-wrap-menu-1 #mega-menu-menu-1 li.mega-hide-on-desktop, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-hide-on-desktop, #mega-menu-wrap-menu-1 #mega-menu-menu-1 > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item.mega-hide-on-desktop {\n    display: none;\n  }\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle {\n  display: none;\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle ~ button.mega-close {\n  visibility: hidden;\n  opacity: 0;\n  transition: left 200ms ease-in-out, right 200ms ease-in-out, visibility 200ms ease-in-out, opacity 200ms ease-out;\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle ~ button.mega-close {\n  right: auto;\n  left: 0;\n}\n@media only screen and (max-width: 768px) {\n  #mega-menu-wrap-menu-1 .mega-menu-toggle {\n    z-index: 1;\n    cursor: pointer;\n    background: #222;\n    border-radius: 2px;\n    line-height: 40px;\n    height: 40px;\n    text-align: left;\n    user-select: none;\n    outline: none;\n    white-space: nowrap;\n    display: flex;\n    position: relative;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle img {\n    max-width: 100%;\n    padding: 0;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-blocks-left, #mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-blocks-center, #mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-blocks-right {\n    display: flex;\n    flex-basis: 33.33%;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-block {\n    display: flex;\n    height: 100%;\n    outline: 0;\n    align-self: center;\n    flex-shrink: 0;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-blocks-left {\n    flex: 1;\n    justify-content: flex-start;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-blocks-left .mega-toggle-block {\n    margin-left: 6px;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-blocks-left .mega-toggle-block:only-child {\n    margin-right: 6px;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-blocks-center {\n    justify-content: center;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-blocks-center .mega-toggle-block {\n    margin-left: 3px;\n    margin-right: 3px;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-blocks-right {\n    flex: 1;\n    justify-content: flex-end;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-blocks-right .mega-toggle-block {\n    margin-right: 6px;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-blocks-right .mega-toggle-block:only-child {\n    margin-left: 6px;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle + #mega-menu-menu-1 {\n    flex-direction: column;\n    flex-wrap: nowrap;\n    background: #222;\n    padding: 0px;\n    display: none;\n    position: fixed;\n    width: 300px;\n    max-width: 100%;\n    height: 100dvh;\n    max-height: 100dvh;\n    top: 0;\n    box-sizing: border-box;\n    transition: left 200ms ease-in-out, right 200ms ease-in-out, visibility 200ms ease-in-out;\n    overflow-y: auto;\n    overflow-x: hidden;\n    z-index: 9999999999;\n    overscroll-behavior: contain;\n    visibility: hidden;\n    display: flex;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle.mega-menu-open + #mega-menu-menu-1 {\n    display: flex;\n    visibility: visible;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle ~ button.mega-close {\n    display: flex;\n    position: fixed;\n    top: 0;\n    z-index: 99999999999;\n    cursor: pointer;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle ~ button.mega-close:before {\n    display: flex;\n    content: \"\";\n    font-family: dashicons;\n    font-weight: normal;\n    color: white;\n    align-items: center;\n    justify-content: center;\n    width: 40px;\n    height: 40px;\n    font-size: 16px;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle + #mega-menu-menu-1 {\n    left: -300px;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle.mega-menu-open ~ button.mega-close {\n    visibility: visible;\n    opacity: 1;\n    left: calc(min(100vw - 40px, 300px));\n    right: auto;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle.mega-menu-open + #mega-menu-menu-1 {\n    left: 0;\n  }\n  #mega-menu-wrap-menu-1 .mega-menu-toggle.mega-menu-open:after {\n    position: fixed;\n    width: 100%;\n    height: 99999px;\n    content: \"\";\n    top: 0;\n    left: 0;\n    opacity: 0.5;\n    background: black;\n    cursor: pointer;\n    z-index: 9999999998;\n  }\n}\nhtml.mega-menu-menu-1-off-canvas-open {\n  overflow: hidden;\n  height: auto;\n}\nhtml.mega-menu-menu-1-off-canvas-open body {\n  overflow: hidden;\n  height: auto;\n}\nhtml.mega-menu-menu-1-off-canvas-open #wpadminbar {\n  z-index: 0;\n}\n.elementor-sticky__spacer #mega-menu-wrap-menu-1 #mega-menu-menu-1, .elementor-sticky__spacer #mega-menu-wrap-menu-1 #mega-menu-menu-1 .mega-sub-menu {\n  visibility: inherit !important;\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-block-0 {\n  cursor: pointer;\n  /*! \n                * Hamburgers \n                * @description Tasty CSS-animated hamburgers \n                * @author Jonathan Suh @jonsuh \n                * @site https://jonsuh.com/hamburgers \n                * @link https://github.com/jonsuh/hamburgers \n                */\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-block-0 .mega-toggle-animated {\n  padding: 0;\n  display: flex;\n  cursor: pointer;\n  transition-property: opacity, filter;\n  transition-duration: 0.15s;\n  transition-timing-function: linear;\n  font: inherit;\n  color: inherit;\n  text-transform: none;\n  background-color: transparent;\n  border: 0;\n  margin: 0;\n  overflow: visible;\n  transform: scale(0.8);\n  align-self: center;\n  outline: 0;\n  background: none;\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-block-0 .mega-toggle-animated-box {\n  width: 40px;\n  height: 24px;\n  display: inline-block;\n  position: relative;\n  outline: 0;\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-block-0 .mega-toggle-animated-inner {\n  display: block;\n  top: 50%;\n  margin-top: -2px;\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-block-0 .mega-toggle-animated-inner, #mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-block-0 .mega-toggle-animated-inner::before, #mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-block-0 .mega-toggle-animated-inner::after {\n  width: 40px;\n  height: 4px;\n  background-color: #ddd;\n  border-radius: 4px;\n  position: absolute;\n  transition-property: transform;\n  transition-duration: 0.15s;\n  transition-timing-function: ease;\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-block-0 .mega-toggle-animated-inner::before, #mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-block-0 .mega-toggle-animated-inner::after {\n  content: \"\";\n  display: block;\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-block-0 .mega-toggle-animated-inner::before {\n  top: -10px;\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-block-0 .mega-toggle-animated-inner::after {\n  bottom: -10px;\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-block-0 .mega-toggle-animated-slider .mega-toggle-animated-inner {\n  top: 2px;\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-block-0 .mega-toggle-animated-slider .mega-toggle-animated-inner::before {\n  top: 10px;\n  transition-property: transform, opacity;\n  transition-timing-function: ease;\n  transition-duration: 0.15s;\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle .mega-toggle-block-0 .mega-toggle-animated-slider .mega-toggle-animated-inner::after {\n  top: 20px;\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle.mega-menu-open .mega-toggle-block-0 .mega-toggle-animated-slider .mega-toggle-animated-inner {\n  transform: translate3d(0, 10px, 0) rotate(45deg);\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle.mega-menu-open .mega-toggle-block-0 .mega-toggle-animated-slider .mega-toggle-animated-inner::before {\n  transform: rotate(-45deg) translate3d(-5.71429px, -6px, 0);\n  opacity: 0;\n}\n#mega-menu-wrap-menu-1 .mega-menu-toggle.mega-menu-open .mega-toggle-block-0 .mega-toggle-animated-slider .mega-toggle-animated-inner::after {\n  transform: translate3d(0, -20px, 0) rotate(-90deg);\n}\n/** Push menu onto new line **/\n#mega-menu-wrap-menu-1 {\n  clear: both;\n}\n.wp-block {}", "off");
INSERT INTO `wpvv_options` VALUES("3298", "_site_transient_timeout_php_check_7b9fb72b3bf6b27c046e3a9832dfe8e2", "1757661039", "off");
INSERT INTO `wpvv_options` VALUES("3299", "_site_transient_php_check_7b9fb72b3bf6b27c046e3a9832dfe8e2", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wpvv_options` VALUES("3387", "_transient_timeout_elementor_rollback_versions_3.31.2", "1757755304", "off");
INSERT INTO `wpvv_options` VALUES("3388", "_transient_elementor_rollback_versions_3.31.2", "a:30:{i:0;s:6:\"3.31.1\";i:1;s:6:\"3.31.0\";i:2;s:6:\"3.30.4\";i:3;s:6:\"3.30.3\";i:4;s:6:\"3.30.2\";i:5;s:6:\"3.30.1\";i:6;s:6:\"3.30.0\";i:7;s:6:\"3.29.2\";i:8;s:6:\"3.29.1\";i:9;s:6:\"3.29.0\";i:10;s:6:\"3.28.4\";i:11;s:6:\"3.28.3\";i:12;s:6:\"3.28.2\";i:13;s:6:\"3.28.1\";i:14;s:6:\"3.28.0\";i:15;s:6:\"3.27.7\";i:16;s:6:\"3.27.6\";i:17;s:6:\"3.27.5\";i:18;s:6:\"3.27.4\";i:19;s:6:\"3.27.3\";i:20;s:6:\"3.27.2\";i:21;s:6:\"3.27.1\";i:22;s:6:\"3.27.0\";i:23;s:6:\"3.26.5\";i:24;s:6:\"3.26.4\";i:25;s:6:\"3.26.3\";i:26;s:6:\"3.26.2\";i:27;s:6:\"3.26.1\";i:28;s:6:\"3.26.0\";i:29;s:7:\"3.25.11\";}", "off");
INSERT INTO `wpvv_options` VALUES("3493", "_site_transient_timeout_browser_8f694609bddc4903b8e8fee50d783cc1", "1757911235", "off");
INSERT INTO `wpvv_options` VALUES("3494", "_site_transient_browser_8f694609bddc4903b8e8fee50d783cc1", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"139.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wpvv_options` VALUES("3587", "redirection_options", "a:32:{s:7:\"support\";b:0;s:5:\"token\";s:32:\"5cfa1f3ee2d1cef459e2351495283eef\";s:12:\"monitor_post\";i:1;s:13:\"monitor_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:19:\"associated_redirect\";s:0:\"\";s:11:\"auto_target\";s:0:\"\";s:15:\"expire_redirect\";i:7;s:10:\"expire_404\";i:7;s:12:\"log_external\";b:0;s:10:\"log_header\";b:0;s:10:\"track_hits\";b:1;s:7:\"modules\";a:0:{}s:14:\"redirect_cache\";i:1;s:10:\"ip_logging\";i:1;s:10:\"ip_headers\";a:0:{}s:8:\"ip_proxy\";a:0:{}s:13:\"last_group_id\";i:1;s:8:\"rest_api\";i:0;s:5:\"https\";b:0;s:7:\"headers\";a:0:{}s:8:\"database\";s:3:\"4.2\";s:8:\"relocate\";s:0:\"\";s:16:\"preferred_domain\";s:0:\"\";s:7:\"aliases\";a:0:{}s:10:\"permalinks\";a:0:{}s:9:\"cache_key\";i:0;s:13:\"plugin_update\";s:6:\"prompt\";s:13:\"update_notice\";i:0;s:10:\"flag_query\";s:5:\"exact\";s:9:\"flag_case\";b:1;s:13:\"flag_trailing\";b:1;s:10:\"flag_regex\";b:0;}", "auto");
INSERT INTO `wpvv_options` VALUES("3790", "_transient_timeout_acf_plugin_updates", "1757680672", "off");
INSERT INTO `wpvv_options` VALUES("3791", "_transient_acf_plugin_updates", "a:5:{s:7:\"plugins\";a:0:{}s:9:\"no_update\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";a:12:{s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:6:\"plugin\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"new_version\";s:5:\"6.5.1\";s:3:\"url\";s:36:\"https://www.advancedcustomfields.com\";s:6:\"tested\";s:5:\"6.8.2\";s:7:\"package\";s:0:\"\";s:5:\"icons\";a:1:{s:7:\"default\";s:64:\"https://connect.advancedcustomfields.com/assets/icon-256x256.png\";}s:7:\"banners\";a:2:{s:3:\"low\";s:66:\"https://connect.advancedcustomfields.com/assets/banner-772x250.jpg\";s:4:\"high\";s:67:\"https://connect.advancedcustomfields.com/assets/banner-1544x500.jpg\";}s:8:\"requires\";s:3:\"6.0\";s:12:\"requires_php\";s:3:\"7.4\";s:12:\"release_date\";s:8:\"20250910\";s:6:\"reason\";s:10:\"up_to_date\";}}s:10:\"expiration\";i:172800;s:6:\"status\";i:1;s:7:\"checked\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";s:5:\"6.5.1\";}}", "off");
INSERT INTO `wpvv_options` VALUES("3831", "_transient_timeout_elementor_remote_info_api_data_3.31.2", "1757527438", "off");
INSERT INTO `wpvv_options` VALUES("3832", "_transient_elementor_remote_info_api_data_3.31.2", "a:4:{s:9:\"timestamp\";s:10:\"1757483106\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:82:{i:0;a:4:{s:4:\"name\";s:6:\"search\";s:5:\"title\";s:6:\"Search\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-2\";s:5:\"title\";s:7:\"Classic\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:4;a:4:{s:4:\"name\";s:9:\"mega-menu\";s:5:\"title\";s:4:\"Menu\";s:4:\"icon\";s:15:\"eicon-mega-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:5;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-3\";s:5:\"title\";s:8:\"Showcase\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:6;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-4\";s:5:\"title\";s:5:\"Links\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:8;a:4:{s:4:\"name\";s:9:\"loop-grid\";s:5:\"title\";s:9:\"Loop Grid\";s:4:\"icon\";s:18:\"eicon-loop-builder\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:9;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-5\";s:5:\"title\";s:8:\"Services\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:10;a:4:{s:4:\"name\";s:13:\"loop-carousel\";s:5:\"title\";s:13:\"Loop Carousel\";s:4:\"icon\";s:19:\"eicon-carousel-loop\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:11;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-6\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:12;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-7\";s:5:\"title\";s:13:\"Business Card\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:14;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:16;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:19;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:20;a:4:{s:4:\"name\";s:15:\"nested-carousel\";s:5:\"title\";s:8:\"Carousel\";s:4:\"icon\";s:21:\"eicon-nested-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:21;a:4:{s:4:\"name\";s:10:\"off-canvas\";s:5:\"title\";s:10:\"Off-Canvas\";s:4:\"icon\";s:16:\"eicon-off-canvas\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:23;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:24;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:25;a:4:{s:4:\"name\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:4:\"icon\";s:12:\"eicon-lottie\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:7:\"hotspot\";s:5:\"title\";s:7:\"Hotspot\";s:4:\"icon\";s:19:\"eicon-image-hotspot\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:27;a:4:{s:4:\"name\";s:13:\"paypal-button\";s:5:\"title\";s:13:\"PayPal Button\";s:4:\"icon\";s:19:\"eicon-paypal-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:28;a:4:{s:4:\"name\";s:14:\"code-highlight\";s:5:\"title\";s:14:\"Code Highlight\";s:4:\"icon\";s:20:\"eicon-code-highlight\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:29;a:4:{s:4:\"name\";s:14:\"video-playlist\";s:5:\"title\";s:14:\"Video Playlist\";s:4:\"icon\";s:20:\"eicon-video-playlist\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:30;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:31;a:4:{s:4:\"name\";s:13:\"stripe-button\";s:5:\"title\";s:13:\"Stripe Button\";s:4:\"icon\";s:19:\"eicon-stripe-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:32;a:4:{s:4:\"name\";s:16:\"progress-tracker\";s:5:\"title\";s:16:\"Progress Tracker\";s:4:\"icon\";s:22:\"eicon-progress-tracker\";s:10:\"categories\";s:40:\"[\"pro-elements\",\"theme-elements-single\"]\";}i:33;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:34;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:35;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:36;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:37;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:38;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:39;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:40;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:41;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:42;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:43;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:44;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:45;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:46;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:47;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:48;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:49;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:50;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:51;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:52;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:53;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:54;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:55;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:56;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:58;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:59;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:60;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:61;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:62;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:63;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:64;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:65;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:66;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:67;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:68;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:69;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:70;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:71;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:72;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:73;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:74;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:75;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:76;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:77;a:4:{s:4:\"name\";s:25:\"woocommerce-checkout-page\";s:5:\"title\";s:8:\"Checkout\";s:4:\"icon\";s:14:\"eicon-checkout\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:78;a:4:{s:4:\"name\";s:16:\"woocommerce-cart\";s:5:\"title\";s:4:\"Cart\";s:4:\"icon\";s:14:\"eicon-woo-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:79;a:4:{s:4:\"name\";s:22:\"woocommerce-my-account\";s:5:\"title\";s:10:\"My Account\";s:4:\"icon\";s:16:\"eicon-my-account\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:80;a:4:{s:4:\"name\";s:28:\"woocommerce-purchase-summary\";s:5:\"title\";s:16:\"Purchase Summary\";s:4:\"icon\";s:22:\"eicon-purchase-summary\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:81;a:4:{s:4:\"name\";s:19:\"woocommerce-notices\";s:5:\"title\";s:19:\"WooCommerce Notices\";s:4:\"icon\";s:25:\"eicon-woocommerce-notices\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.6.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"6.8.2\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:0:{}}}", "off");
INSERT INTO `wpvv_options` VALUES("3854", "_site_transient_timeout_browser_a3f57bbe21c4e30379228ad7788f224d", "1758092894", "off");
INSERT INTO `wpvv_options` VALUES("3855", "_site_transient_browser_a3f57bbe21c4e30379228ad7788f224d", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"140.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wpvv_options` VALUES("3858", "_site_transient_timeout_community-events-0f0ea38e96a35b6c5bc5dd112d4f1a1a", "1757531317", "off");
INSERT INTO `wpvv_options` VALUES("3859", "_site_transient_community-events-0f0ea38e96a35b6c5bc5dd112d4f1a1a", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"23.106.56.0\";}s:6:\"events\";a:2:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:61:\"Building WordPress Block Themes with Full Site Editing (FSE) \";s:3:\"url\";s:56:\"https://www.meetup.com/wordup-brighton/events/310288404/\";s:6:\"meetup\";s:34:\"WordUp Brighton (WordPress Meetup)\";s:10:\"meetup_url\";s:39:\"https://www.meetup.com/wordup-brighton/\";s:4:\"date\";s:19:\"2025-09-09 17:30:00\";s:8:\"end_date\";s:19:\"2025-09-09 19:30:00\";s:20:\"start_unix_timestamp\";i:1757439000;s:18:\"end_unix_timestamp\";i:1757446200;s:8:\"location\";a:4:{s:8:\"location\";s:24:\"Brighton, United Kingdom\";s:7:\"country\";s:2:\"gb\";s:8:\"latitude\";d:50.82085000000000007958078640513122081756591796875;s:9:\"longitude\";d:-0.141027999999999986702192700249725021421909332275390625;}}i:1;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:25:\"WordCamp Netherlands 2025\";s:3:\"url\";s:38:\"https://netherlands.wordcamp.org/2025/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2025-11-27 09:00:00\";s:8:\"end_date\";s:19:\"2025-11-28 00:00:00\";s:20:\"start_unix_timestamp\";i:1764230400;s:18:\"end_unix_timestamp\";i:1764284400;s:8:\"location\";a:4:{s:8:\"location\";s:11:\"Netherlands\";s:7:\"country\";s:2:\"NL\";s:8:\"latitude\";d:52.0990656000000029735019779764115810394287109375;s:9:\"longitude\";d:4.29753170000000039863152778707444667816162109375;}}}}", "off");
INSERT INTO `wpvv_options` VALUES("3860", "_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3", "1757531318", "off");
INSERT INTO `wpvv_options` VALUES("3861", "_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Sep 2025 18:14:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.9-alpha-60725\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"Portland Welcomes WordCamp US 2025: A Community Gathering\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/news/2025/08/portland-welcomes-wcus-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Aug 2025 03:03:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19074\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:405:\"A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery. WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement. Matt Mullenweg, WordPress Cofounder [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:66040:\"\n\n\n<p>A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery.</p>\n\n\n\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-6c531013 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-pullquote\"><blockquote><p>WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>The WordPress event began with a dedicated Contributor Day and continued with a Showcase Day and two days of sessions filled with talks, panels, workshops, and community celebrations. WordPress Cofounder Matt Mullenweg joined a diverse lineup of speakers, panelists, and workshop leaders who brought fresh perspectives to the open web from across the globe.</p>\n\n\n\n<p>Set against the vibrant backdrop of Portland — with its iconic bridges, coffee culture, and creative energy — the Sponsor Hall buzzed as companies across the WordPress ecosystem demoed new products, shared insights, and connected with attendees. Each day offered opportunities to refuel with local flavors and international favorites, turning mealtimes into lively hubs of networking and idea-sharing.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Global Gathering in Portland</h2>\n\n\n\n<p>WordCamp US is the annual gathering point for the WordPress community — where collaboration, creativity, and innovation intersect. This year in Portland, the event delivered an expansive program that reached every corner of the ecosystem.</p>\n\n\n\n<p>Here’s what attendees experienced:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Engaging Sessions Across Tracks</strong> – Keynotes, presentations, and discussions explored the evolving web and the role of open source in shaping it.</li>\n\n\n\n<li><strong>A Global Speaker Lineup</strong> – Voices from across continents brought local stories and global visions to the stage.</li>\n\n\n\n<li><strong>Wide-Ranging Topics</strong> – From AI in WordPress development to accessibility, design systems, content strategy, education, and case studies of WordPress at scale.</li>\n\n\n\n<li><strong>Hands-On Learning Opportunities</strong> – Workshops provided practical takeaways, empowering attendees to apply new skills immediately.</li>\n\n\n\n<li><strong>A Community Built on Collaboration</strong> – Whether contributing code, exploring business strategies, or sharing creative projects, attendees found space to learn, grow, and celebrate open source together.</li>\n</ul>\n\n\n\n<p>New contributors took their first steps into open source, seasoned developers explored cutting-edge AI integrations, and agencies and product teams shared strategies for scaling WordPress to meet modern needs. Beyond the technical, conversations around inclusivity, sustainability, and education underscored WordPress’s role as a tool for empowerment and positive change.</p>\n\n\n\n<p>In hallways, coffee lines, and evening meetups, attendees found the “hallway track” alive and well, spontaneous moments of connection that often became the most memorable part of the experience. Whether reconnecting with longtime collaborators or meeting someone new, these small interactions reinforced the heart of WordCamp US: a community that thrives on openness, generosity, and shared purpose.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day: Collaboration at the Core</h2>\n\n\n\n<p>The conference opened on Tuesday, August 26, with a vibrant Contributor Day. Nearly 300 contributors filled the space, including more than 120 first-time participants who were onboarded across 19 teams. Developers, designers, translators, marketers, and community organizers worked side by side, representing WordPress expertise.</p>\n\n\n\n<p>Throughout the day, contributors tackled everything from improving accessibility and performance to refining documentation to enhancing translation tools. Beyond technical contributions, teams like Marketing and Community focused on outreach, mentoring, and shaping future-facing initiatives. Remote participants joined via dedicated channels, reinforcing the inclusive nature of WordPress’s global community. By day’s end, the collective energy was clear: WordPress continues to be built by and for everyone.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px;border-radius:2px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d89844&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d89844\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19080\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19080\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d89b3e&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d89b3e\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19081\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19081\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d89df0&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d89df0\" class=\"wp-block-image size-large wp-lightbox-container\"><img decoding=\"async\" width=\"1707\" height=\"2560\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19087\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?fit=683%2C1024&amp;ssl=1\" alt=\"\" class=\"wp-image-19087\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?w=1707&amp;ssl=1 1707w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=200%2C300&amp;ssl=1 200w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=683%2C1024&amp;ssl=1 683w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=768%2C1152&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1024%2C1536&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?resize=1365%2C2048&amp;ssl=1 1365w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8a08e&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8a08e\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19084\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19084\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8a2f7&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8a2f7\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19082\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19082\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8a55c&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8a55c\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19085\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19085\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8a839&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8a839\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19086\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19086\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8ab35&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8ab35\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19090\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19090\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8ae69&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8ae69\" class=\"wp-block-image size-large wp-lightbox-container\"><img loading=\"lazy\" decoding=\"async\" width=\"2560\" height=\"1707\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19089\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?fit=1024%2C683&amp;ssl=1\" alt=\"\" class=\"wp-image-19089\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8b139&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8b139\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19092\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19092\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8b3ff&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8b3ff\" class=\"wp-block-image size-large wp-lightbox-container\"><img loading=\"lazy\" decoding=\"async\" width=\"2560\" height=\"1707\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19088\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?fit=1024%2C683&amp;ssl=1\" alt=\"\" class=\"wp-image-19088\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?w=2560&amp;ssl=1 2560w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8b6af&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8b6af\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19091\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19091\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8b972&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8b972\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19083\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19083\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>The mix of experience in the room made this year especially notable. First-time contributors were paired with seasoned table leads who guided them through their first steps into open source contribution. Longtime contributors reconnected with their teams and advanced ongoing initiatives, while new voices added fresh perspectives and momentum. The spirit of mentorship was woven throughout, ensuring that Contributor Day was productive and welcoming.</p>\n\n\n\n<p>The results spoke for themselves:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Polyglots</strong> translated more than 12,000 strings, expanding WordPress’s accessibility worldwide.</li>\n\n\n\n<li>The <strong>Community team</strong> celebrated the approval of two brand-new local meetups.</li>\n\n\n\n<li>The <strong>Training team</strong> achieved its objective of updating outdated course thumbnails.</li>\n\n\n\n<li>The <strong>Core team</strong> worked through a live bug scrub, with 9 committers and 16 contributors collaborating on improvements.</li>\n\n\n\n<li>The <strong>Documentation team</strong> completed numerous content updates to keep resources fresh and reliable.</li>\n</ul>\n\n\n\n<p>Momentum carried through every table, with participants reporting measurable progress and a renewed sense of shared purpose. Contributor Day once again highlighted the unique power of collaboration in shaping the open web, proving that every contribution matters through code, translations, training, or community building.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Showcase Day: WordPress in Action</h2>\n\n\n\n<p>Wednesday, August 27, was the popular Showcase Day, spotlighting real-world innovation in WordPress. Initially expected to draw about 250 participants, Showcase Day welcomed more than 800 attendees — a powerful sign of how much energy and curiosity the community brought to Portland. The sessions demonstrated how WordPress powers meaningful work across industries from nonprofits to newsrooms, agencies to global enterprises, while staying true to open source values.</p>\n\n\n\n<p>The day opened with a keynote by Amy Sample Ward: <em>The Tech That Comes Next</em>. Drawing from their co-authored book with Afua Bruce, Amy highlighted the inequities embedded in today’s technologies — from dataset bias to accessibility gaps — and challenged attendees to rethink how tools are funded, built, and deployed. Their talk invited technologists, funders, and community leaders to imagine a more equitable digital future, rooted in collaboration and shared responsibility.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US 2025 - Amy Sample Ward &quot;The Tech That Comes Next&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/RKnM75GFZxw?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, <a href=\"https://youtu.be/PGvh7fCOUk0\">Joeleen Kennedy</a> of Human Made shared how Full Site Editing (FSE) shapes the refresh of Wikimedia’s ongoing user experience. Her session <em>Modernizing at Scale</em> detailed how FSE is simplifying workflows, improving accessibility, and making the multilingual platform more sustainable for the long term. Attendees gained a behind-the-scenes look at how one of the world’s largest open knowledge platforms is leveraging WordPress innovation.</p>\n\n\n\n<p><a href=\"https://youtu.be/F4NEPcwGRCI\">Josh Bryant</a> took the stage to explore what happens when Gutenberg leaves the WP-Admin dashboard. His talk, <em>Reimagining WordPress Editing</em>, walked through embedding the block editor into a standalone React application to support Dow Jones’s newsroom workflows. From decoupling Gutenberg to managing custom data stores, the session showcased advanced techniques for scaling editorial tools while maintaining the flexibility of the WordPress ecosystem.</p>\n\n\n\n<p>Hands-on learning was a hallmark of Showcase Day, with Jamie Marsland’s workshop leading participants through building and launching their own professional portfolio sites — no coding required. Attendees left with a fully functioning site, demonstrating WordPress’s continued ability to empower anyone, anywhere, to publish online.</p>\n\n\n\n<p>In the afternoon, Jeffrey Paul’s session <em>Scalable, Ethical AI</em> addressed one of the most pressing topics in today’s digital world: how to integrate AI without sacrificing ownership, privacy, or open standards. Walking participants through practical use cases with ClassifAI and local LLMs, Paul emphasized how WordPress can help content creators harness AI while maintaining autonomy over their data.</p>\n\n\n\n<p>The day closed with a forward-looking community highlight: <a href=\"https://events.wordpress.org/campusconnect/\">WordPress Campus Connect</a>. Panelists <a href=\"https://youtu.be/ARqM9U0ESvo\">Destiny Kanno, Andrés Parra, Javier Montes de Blas, Mauricio Barrantes, and Elineth Morera Campos</a> shared how this initiative brings WordPress into classrooms and universities worldwide. Student Andrés Parra received a scholarship to attend WordCamp. During the panel, Elineth also announced that Fidélitas University will begin offering its students a <a href=\"https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/\">WordPress Credits</a> program starting in October 2025, making it a mandatory addition sometime in 2026, enabling them to contribute directly to WordPress as part of their studies.</p>\n\n\n\n<p>By connecting students and educators with the open web, Campus Connect is building the next generation of contributors and innovators, ensuring that WordPress remains both a learning tool and a pathway to opportunity.</p>\n\n\n\n<p>Taken together, Showcase Day affirmed that WordPress is more than just a CMS — it is a platform for equitable technology, global collaboration, cutting-edge enterprise solutions, and the future of digital education. WordPress has the power to be both a platform and a community tool for education, equity, and innovation.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Presentation Days: Learning, Inspiration, and Connection</h2>\n\n\n\n<p>The first full day of sessions at WordCamp US 2025 opened with warm remarks from the organizing team, who reminded attendees: <em>“The most important thanks goes to all of you. The mix of new energy and veteran experience is what makes WordCamp so special, so thank you for being here.”</em> That spirit of gratitude and community carried throughout the event.</p>\n\n\n\n<p>The Sponsor Hall became a hub of activity, complete with raffles, the return of Career Corner, and even a Voodoo Donut Truck parked outside. Attendees lined up to test their luck at a claw machine stuffed with plush Wapuus, while others sought guidance at the Happiness Bar — a hands-on help desk for WordPress questions big and small. Between these activities, the steady buzz of conversations made it clear: the “hallway track” remained one of WordCamp’s most valuable experiences.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US - Danny Sullivan &quot;How (and why!) Google Search Keeps Evolving&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/ZF_sxLdfTbY?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>The program itself set a high bar. Danny Sullivan’s keynote shed light on how search has evolved to meet the needs of new generations, from 24/7 demand and mobile expectations to short-form video and AI. His session gave attendees a deeper understanding of how search intersects with publishing today and sparked conversations about how WordPress can continue adapting in an era where AI shapes discovery and content.</p>\n\n\n\n<p>From there, the schedule unfolded across multiple tracks. The Core AI panel — featuring <a href=\"https://youtu.be/v_0O6dQ4Q4E\">James LePage, Felix Arntz, and Jeffrey Paul</a> — offered a look into how AI tools are woven into WordPress core. Emphasizing ethics, transparency, and user empowerment, the panel painted a roadmap for how WordPress can adopt new technologies without compromising its open-source values.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19103\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?w=1600&amp;ssl=1 1600w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Hands-on learning played a significant role throughout the conference. Ryan Welcher’s interactive <em>Block Developer Cookbook</em> drew a packed room as participants worked through community-selected code recipes built on the latest WordPress APIs. By the end, attendees left with working examples and practical strategies they could bring back to their projects.</p>\n\n\n\n<p>The program also highlighted diverse technical perspectives. <a href=\"https://youtu.be/vBjNqdacbh4\">Jemima Abu’s</a> session, <em>A PHP Developer’s Guide to ReactJS</em>, bridged the gap between classic and modern web development. At the same time, Adam Gazzaley’s keynote, <em>A New Era of Experiential Medicine – AI and the Brain</em>, invited attendees to consider the human side of technology, exploring how digital tools can advance health and well-being.</p>\n\n\n\n<p>The second day of presentations, Friday, August 29, opened with creativity and imagination. <a href=\"https://youtu.be/O7FPiFpRI3o\">John Maeda’s</a> keynote, <em>Cozy AI Cooking: WordCamp Edition</em>, used the metaphor of a kitchen to demystify AI, blending storytelling with technical insight to show how curiosity and care can guide builders in integrating AI into their work.</p>\n\n\n\n<p>Later in the day, <a href=\"https://youtu.be/ORnJTpjA-4w\">Tammie Lister’s</a> <em>The System is the Strategy</em> illustrated how design systems provide structure and scalability for growing WordPress projects. At the same time, Adam Silverstein’s Unlock Developer Superpowers with AI showcased new ways developers can use emerging tools to speed up workflows and problem-solving.</p>\n\n\n\n<p>Community stories also took center stage. In Creators around a Campfire, Anne McCarthy, Jamie Marsland, Christian Taylor, Mark Szymanski, and Michael Cunningham reflected on how YouTubers and content creators shape the WordPress ecosystem. Their session highlighted the role of storytelling and education in expanding WordPress’s reach to new audiences worldwide.</p>\n\n\n\n<p>The Sponsor Hall remained lively between sessions — with attendees meeting companies, testing demos, and swapping ideas that extended far beyond the conference halls. They also shared moments together at the arcade built for the event and added smiles, hugs, and laughter, which underscored the atmosphere: WordCamp US was as much about connection as code.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Together Into the Future</h2>\n\n\n\n<p>As the event drew to a close, WordPress Cofounder Matt Mullenweg took the stage to share the current state of WordPress and a vision for its future. He highlighted the growth in social media for WordPress with 124,726 new followers since last WCUS — and the WordPress.org website growing over 10% in users along with almost 20% in new users. </p>\n\n\n\n<p>Matt also spotlighted community initiatives shaping the future of open source education and diversity: WordPress Campus Connect, which has already reached 570 students across 11 events. Combined with the growth in overall events (77) which is a 32.76% increase over 2024. Each effort reinforced the message that WordPress is more than software; it is a global movement driven by people.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordCamp US 2025 - Ma.tt Mullenweg &quot;Keynote Address &amp; Q&amp;A&quot;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/45HRzzc0waU?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>He concluded with a live Q&amp;A, fielding questions from the audience on the direction of WordPress, its role in an AI-driven web, and the importance of keeping the project open, inclusive, and adaptable. The final notes of the keynote carried into a closing party in downtown Portland, where attendees capped off the week with music, conversation, and the unmistakable joy of a community coming together.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Closing</h2>\n\n\n\n<p>WordCamp US 2025 once again demonstrated what makes the WordPress ecosystem extraordinary: a community committed to building tools, resources, and opportunities that empower people everywhere.</p>\n\n\n\n<p>This year also marked the debut of the <a href=\"https://airtable.com/appWF6hdXuEOFQMvV/shrV5RZIv0aJjjU00\">Open Horizons Scholarship</a>, which funded six recipients — two organizers, three volunteers, and one speaker — from five countries. A total of $14,670 supported their journeys to WCUS. The scholarship, which also supports participation at WordCamp Asia and WordCamp Europe, is designed to make flagship events more accessible to contributors worldwide.</p>\n\n\n\n<p>A heartfelt thank you goes to the organizers, volunteers, sponsors, and speakers who brought the Portland edition to life — and to every attendee who joined us in person or followed along online. We hope you leave with fresh ideas, meaningful connections, and renewed energy to help shape the future of the open web.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8c414&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8c414\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"577\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19112\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948.jpg?resize=1024%2C577&#038;ssl=1\" alt=\"\" class=\"wp-image-19112\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8c6c7&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8c6c7\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19124\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19124\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8c998&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8c998\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19122\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19122\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8cc74&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8cc74\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"577\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19107\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752.jpg?resize=1024%2C577&#038;ssl=1\" alt=\"\" class=\"wp-image-19107\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1024%2C577&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=1536%2C865&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752-scaled.jpg?resize=2048%2C1153&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8cf1c&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8cf1c\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"675\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19108\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&#038;ssl=1\" alt=\"\" class=\"wp-image-19108\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=300%2C198&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=768%2C506&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1536%2C1012&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?w=1764&amp;ssl=1 1764w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8d20d&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8d20d\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19113\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076.jpeg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19113\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076-scaled.jpeg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8d4fa&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8d4fa\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"433\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19106\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809.jpeg?resize=1024%2C433&#038;ssl=1\" alt=\"\" class=\"wp-image-19106\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1024%2C433&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=300%2C127&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=768%2C325&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=1536%2C650&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809-scaled.jpeg?resize=2048%2C866&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8d7ad&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8d7ad\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19110\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-19110\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8da51&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8da51\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19119\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19119\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827-scaled.jpeg?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238d8dd00&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238d8dd00\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"19133\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19133\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>Be sure to mark your calendars for the next global gatherings: <a href=\"https://asia.wordcamp.org/2026/\">WordCamp Asia 2026</a>&nbsp; in Mumbai, India, <a href=\"https://europe.wordcamp.org/2026/\">WordCamp Europe 2026</a>&nbsp; in Kraków, Poland, and WordCamp US 2026 in Phoenix, Arizona. We can’t wait to see you at the next chapter of the WordPress story.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19074\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"Portland, Are You Ready? The WCUS 2025 Schedule Has Arrived!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wordpress.org/news/2025/08/portland-are-you-ready-the-wcus-2025-schedule-has-arrived/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Aug 2025 20:03:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:4:\"WCUS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:9:\"WordCamps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19004\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:402:\"We’re excited to announce that the full schedule for WordCamp US 2025 has been published! From August 26–29 in Portland, Oregon, join web creators, innovators, and community leaders for four days of learning, collaboration, and inspiration. This year’s lineup brings together sessions on everything from cutting-edge AI to hands-on workshops, performance, accessibility, design, and the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5698:\"\n<p>We’re excited to announce that the full schedule for WordCamp US 2025 has been published! From August 26–29 in Portland, Oregon, join web creators, innovators, and community leaders for four days of learning, collaboration, and inspiration. This year’s lineup brings together sessions on everything from cutting-edge AI to hands-on workshops, performance, accessibility, design, and the future of WordPress.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader.png?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-19026\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/08/ScheduleHeader-scaled.png?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p class=\"has-text-align-center\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><strong>Check out the full schedule and start planning your WordCamp experience.</strong></p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link has-blue-1-background-color has-background wp-element-button\" href=\"https://us.wordcamp.org/2025/schedule/\">View The Schedule</a></div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day — Connect, Collaborate, and Give Back</h2>\n\n\n\n<p>Kicking off the week on Tuesday, August 26 is Contributor Day, it is your chance to roll up your sleeves and make a direct impact on WordPress. Whether you’re a seasoned developer, creative designer, translator, marketer, or simply passionate about open source, there’s a place for you to get involved. Join WordPress teams working on real projects, share your skills, and connect with people across the global community. Contributor Day is also a fantastic place for hiring managers or business owners to meet emerging talent and see contributors in action. Lunch is provided, and both in-person and select remote participation options are available. If you’ve ever wanted to help shape the future of WordPress, this is your moment!<br></p>\n\n\n\n<p>Read more: <a href=\"https://us.wordcamp.org/2025/schedule/#contributor-day\">Start planning your Contributor Day activities &gt;&gt;</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Showcase Day — See WordPress in Action</h2>\n\n\n\n<p>Showcase Day on Wednesday, August 27, shines a spotlight on what&#8217;s possible with WordPress. Get inspired by live demos, case studies, and actionable presentations from experts and innovators using WordPress in creative and impactful ways. You’ll see how changemakers, nonprofits, publishers, and agencies use WordPress to solve real-world problems, build new products, and drive the web forward. Highlights include hands-on workshops, technical talks, and practical sessions covering everything from design systems to modern AI. It’s a full day dedicated to celebrating the talent, creativity, and innovation of the WordPress community.</p>\n\n\n\n<p>Read more: <a href=\"https://us.wordcamp.org/2025/schedule/#showcase-day\">See where these inspirational showcases take you &gt;&gt;</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Conference Days — Learn, Connect, and Level Up</h2>\n\n\n\n<p>The main event days for Thursday and Friday, August 28-29, feature a robust mix of technical deep-dives, product masterclasses, and sessions designed for all experience levels. Whether you’re a developer, designer, business owner, or just starting out, you’ll find plenty to explore—from future-focused discussions on AI and performance to hands-on workshops and networking events that bring the community together.</p>\n\n\n\n<p><strong>Keynote Highlights:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Amy Sample Ward, CEO of NTEN:</strong> The Tech That Comes Next: How Changemakers, Philanthropists, and Technologists Can Build an Equitable World. Featured Wednesday, August 27.</li>\n\n\n\n<li><strong>Danny Sullivan, from Google Search</strong>: Industry leader, featured Thursday, August 28.</li>\n\n\n\n<li><strong>Matt Mullenweg, Co-founder of WordPress:</strong> Featured Friday, August 29.</li>\n\n\n\n<li>More keynotes announcing soon!</li>\n</ul>\n\n\n\n<p>With dozens of sessions across multiple tracks, plus workshops and networking opportunities, WordCamp US is set to be an unforgettable experience. Don’t miss your chance to connect, share ideas, and help shape the future of the web.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center\"><strong>Check out the full schedule and start planning your WordCamp experience.</strong></p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link has-blue-1-background-color has-background wp-element-button\" href=\"https://us.wordcamp.org/2025/schedule/\">View The Schedule</a></div>\n</div>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"19004\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Maintenance Releases for WordPress branches 4.7 to 6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wordpress.org/news/2025/08/maintenance-releases-for-wordpress-branches-4-7-to-6-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 05 Aug 2025 19:11:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"minor-releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18997\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:374:\"Following on from the WordPress 6.8.2 maintenance release last month, the included update to the root security certificate bundle has been backported to all branches back to 4.7. This ensures that when your site performs server-side HTTP requests, the most up-to-date information about trusted security certificates is used. Further information can be found on the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2119:\"\n<p>Following on from <a href=\"https://wordpress.org/news/2025/07/wordpress-6-8-2-maintenance-release/\">the WordPress 6.8.2 maintenance release last month</a>, the included update to the root security certificate bundle has been backported to all branches back to 4.7. This ensures that when your site performs server-side HTTP requests, the most up-to-date information about trusted security certificates is used. Further information can be found on <a href=\"https://core.trac.wordpress.org/ticket/62811\">the Core Trac ticket</a>.</p>\n\n\n\n<p>A new maintenance release for each branch from 4.7 to 6.7 is now available. If you have sites on these branches and they support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>The latest and only supported version of WordPress remains as 6.8.2. This is being done as a courtesy for sites still running older versions of WordPress. You can <a href=\"https://wordpress.org/wordpress-6.8.2.zip\">download WordPress 6.8.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>Special thanks to <a href=\'https://profiles.wordpress.org/desrosj/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>desrosj</a>, <a href=\'https://profiles.wordpress.org/ocean90/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ocean90</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/peterwilsoncc/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>peterwilsoncc</a>, <a href=\'https://profiles.wordpress.org/jorbin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jorbin</a>, <a href=\'https://profiles.wordpress.org/estelaris/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>estelaris</a>, and <a href=\'https://profiles.wordpress.org/johnbillion/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>johnbillion</a> for backporting and releasing this update.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18997\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.8.2 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2025/07/wordpress-6-8-2-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Jul 2025 15:41:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"minor-releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18903\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:357:\"WordPress 6.8.2 is now available! This minor release includes fixes for 20 Core tickets and 15 Block Editor issues. For a full list of bug fixes, please refer to the release candidate announcement. WordPress 6.8.2 is a short-cycle maintenance release. More maintenance releases may be made available throughout 2025. If you have sites that support [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10720:\"\n<h2 class=\"wp-block-heading\">WordPress 6.8.2 is now available!</h2>\n\n\n\n<p>This minor release includes fixes for <a href=\"https://core.trac.wordpress.org/query?resolution=fixed&amp;milestone=6.8.2&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">20 Core tickets</a> and <a href=\"https://github.com/WordPress/gutenberg/pull/70557\">15 Block Editor issues</a>. For a full list of bug fixes, please refer to the <a href=\"https://make.wordpress.org/core/2025/07/08/wordpress-6-8-2-rc1-is-now-available/\">release candidate announcement.</a></p>\n\n\n\n<p>WordPress 6.8.2 is a short-cycle maintenance release. More maintenance releases may be made available throughout 2025.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.8.2.zip\">download WordPress 6.8.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. For more information on this release, please <a href=\"https://wordpress.org/support/wordpress-version/version-6-8-2\">visit the HelpHub version page</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Dropping security updates for WordPress versions 4.1 through 4.6</h2>\n\n\n\n<p>This is not directly related to the 6.8.2 maintenance release, but <a href=\"https://wordpress.org/news/2025/06/dropping-security-updates-for-wordpress-versions-4-1-through-4-6/\">branches 4.1 to 4.6 had their final release today</a>. These branches won&#8217;t receive any security update anymore.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>WordPress 6.8.2 was led by <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>,&nbsp;<a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>&nbsp;and&nbsp;<a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a>.</p>\n\n\n\n<p>Special thanks to <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, <a href=\'https://profiles.wordpress.org/sergeybiryukov/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sergeybiryukov</a>, <a href=\'https://profiles.wordpress.org/mamaduka/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mamaduka</a>, <a href=\'https://profiles.wordpress.org/wildworks/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wildworks</a> and <a href=\'https://profiles.wordpress.org/jorbin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jorbin</a> for their help on specific release tasks.</p>\n\n\n\n<p>WordPress 6.8.2 would not have been possible without the contributions of the following 96 people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p class=\"is-style-wporg-props-medium has-white-color has-midnight-gradient-background has-text-color has-background has-link-color has-normal-font-size wp-elements-2ad7deb15a87fd29427f001e4c18a1ac\"><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/zieladam\">Adam Zieliński</a>, <a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/alexstine\">Alex Stine</a>, <a href=\"https://profiles.wordpress.org/anatolbroder\">Anatol Broder</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/ankitkumarshah\">Ankit Kumar Shah</a>, <a href=\"https://profiles.wordpress.org/annezazu\">annezazu</a>, <a href=\"https://profiles.wordpress.org/azharderaiya\">Azhar Deraiya</a>, <a href=\"https://profiles.wordpress.org/benjamingosset\">Benjamin Gosset</a>, <a href=\"https://profiles.wordpress.org/bhubbard\">Brandon Hubbard</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/brhodes\">brhodes</a>, <a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/czarate\">Chris Zarate</a>, <a href=\"https://profiles.wordpress.org/courane01\">Courtney Robertson</a>, <a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/darshitrajyaguru97\">Darshit Rajyaguru</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>, <a href=\"https://profiles.wordpress.org/dhruvang21\">Dhruvang21</a>, <a href=\"https://profiles.wordpress.org/dilipbheda\">Dilip Bheda</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/divinenephron\">divinenephron</a>, <a href=\"https://profiles.wordpress.org/dustintechsmith\">dustintechsmith</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/im3dabasia1\">Eshaan Dabasiya</a>, <a href=\"https://profiles.wordpress.org/estelaris\">Estela Rueda</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy\">Fabian Kägy</a>, <a href=\"https://profiles.wordpress.org/faisalahammad\">Faisal Ahammad</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/guddu1315\">Gaurang Dabhi</a>, <a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/gernberg\">gernberg</a>, <a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/harshgajipara\">Harsh Gajipara</a>, <a href=\"https://profiles.wordpress.org/helgatheviking\">HelgaTheViking</a>, <a href=\"https://profiles.wordpress.org/abcd95\">Himanshu Pathak</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/JeffPaul\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/luminuu\">Jessica Lyschik</a>, <a href=\"https://profiles.wordpress.org/jigarpanchal\">Jigar Panchal</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/mindctrl\">John Parris</a>, <a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/kausaralm\">Kausar Alam</a>, <a href=\"https://profiles.wordpress.org/kishanjasani\">Kishan Jasani</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/pfefferle\">Matthias Pfefferle</a>, <a href=\"https://profiles.wordpress.org/megane9988\">megane9988</a>, <a href=\"https://profiles.wordpress.org/mosescursor\">Moses Cursor Ssebunya</a>, <a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/mwillman1991\">mwillman1991</a>, <a href=\"https://profiles.wordpress.org/bugnumber9\">Nazar Hotsa</a>, <a href=\"https://profiles.wordpress.org/nidhidhandhukiya\">nidhidhandhukiya</a>, <a href=\"https://profiles.wordpress.org/nikunj8866\">Nikunj Hatkar</a>, <a href=\"https://profiles.wordpress.org/oferlaor\">oferlaor</a>, <a href=\"https://profiles.wordpress.org/oglekler\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/paulstanos\">paulstanos</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/puggan\">puggan</a>, <a href=\"https://profiles.wordpress.org/ravigadhiyawp\">Ravi Gadhiya</a>, <a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rollybueno\">Rolly Bueno</a>, <a href=\"https://profiles.wordpress.org/room34\">room34</a>, <a href=\"https://profiles.wordpress.org/sainathpoojary\">Sainath Poojary</a>, <a href=\"https://profiles.wordpress.org/sajjad67\">Sajjad Hossain Sagor</a>, <a href=\"https://profiles.wordpress.org/Sam_a\">sam_a</a>, <a href=\"https://profiles.wordpress.org/sandeepdahiya\">Sandeep Dahiya</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shanemuir\">Shane Muirhead</a>, <a href=\"https://profiles.wordpress.org/siliconforks\">siliconforks</a>, <a href=\"https://profiles.wordpress.org/sirlouen\">SirLouen</a>, <a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/sukhendu2002\">Sukhendu Sekhar Guria</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/TobiasBg\">Tobias Bäthge</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/ugyensupport\">Ugyen Dorji</a>, <a href=\"https://profiles.wordpress.org/uxl\">uxl</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/whaze\">whaze</a>, <a href=\"https://profiles.wordpress.org/getsyash\">Yash B</a>, <a href=\"https://profiles.wordpress.org/yogeshbhutkar\">Yogesh Bhutkar</a>, and <a href=\"https://profiles.wordpress.org/zunaid321\">Zunaid Amin</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation on Slack, in the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> and <a href=\"https://wordpress.slack.com/archives/C080HLPP2Q6\">#6-8-release-leads</a> channels. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Thanks to <a href=\'https://profiles.wordpress.org/estelaris/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>estelaris</a> and <a href=\'https://profiles.wordpress.org/zunaid321/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>zunaid321</a> for proofreading.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18903\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Celebrating Kim Parsell: 2025 WordCamp US Scholarship Applications Open\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://wordpress.org/news/2025/07/kim-parsell-2025-wcus-scholarship-applications-open/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 14 Jul 2025 18:57:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18911\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"The WordPress Foundation is pleased to announce the return of the Kim Parsell Memorial Scholarship for WordCamp US 2025. Applications are being accepted until July 25, 2025. Remembering Kim Parsell Kim Parsell was a dedicated contributor and a beloved member of the WordPress community. Her passion for open source and her welcoming spirit inspired many, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6224:\"\n<p>The WordPress Foundation is pleased to announce the return of the <strong>Kim Parsell Memorial Scholarship</strong> for WordCamp US 2025. Applications are being accepted until <strong>July 25, 2025</strong>.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"604\" height=\"370\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/07/wpdocs-team-1.webp?resize=604%2C370&#038;ssl=1\" alt=\"\" class=\"wp-image-18912\" style=\"border-width:25px;border-radius:40px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/07/wpdocs-team-1.webp?w=604&amp;ssl=1 604w, https://i0.wp.com/wordpress.org/news/files/2025/07/wpdocs-team-1.webp?resize=300%2C184&amp;ssl=1 300w\" sizes=\"auto, (max-width: 604px) 100vw, 604px\" /></figure>\n\n\n\n<div class=\"wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-6cbf45de wp-block-group-is-layout-constrained\" style=\"margin-top:48px;margin-bottom:48px;padding-top:24px;padding-bottom:24px\">\n<div class=\"wp-block-columns is-not-stacked-on-mobile is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:2%\"></div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:96%\">\n<h2 class=\"wp-block-heading\">Remembering Kim Parsell</h2>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:40%\">\n<figure class=\"wp-block-image size-full\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"400\" height=\"400\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?resize=400%2C400&#038;ssl=1\" alt=\"\" class=\"wp-image-18956\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?w=400&amp;ssl=1 400w, https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/07/Kim-parsell-twitter-image-2.jpeg?resize=150%2C150&amp;ssl=1 150w\" sizes=\"auto, (max-width: 400px) 100vw, 400px\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:60%\">\n<p>Kim Parsell was a dedicated contributor and a beloved member of the WordPress community. Her passion for open source and her welcoming spirit inspired many, both online and in person. Each year at WordCamp US, the WordPress Foundation celebrates Kim’s legacy by supporting contributors who share her commitment and enthusiasm. The Kim Parsell Memorial Scholarship aims to make it easier for deserving community members to attend WordCamp US, reflecting Kim’s belief in making WordPress accessible and inclusive for all.</p>\n</div>\n</div>\n\n\n\n<p style=\"padding-top:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10)\">If you’re unfamiliar with Kim’s story or her invaluable role in the community, we encourage you to <a href=\"https://us.wordcamp.org/2019/memories-of-kim-parsell/\">read these heartfelt tributes</a> collected from friends and colleagues.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:2%\"></div>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Scholarship Eligibility</h2>\n\n\n\n<p>This year, a single scholarship will be awarded. To qualify, applicants must:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Identify as a woman</li>\n\n\n\n<li>Be actively involved as a contributor to WordPress</li>\n\n\n\n<li>Have never attended WordCamp US before</li>\n\n\n\n<li>Demonstrate a need for financial support to attend the event</li>\n</ul>\n\n\n\n<p>If you meet these qualifications, we invite you to apply before the July 25 deadline. All applicants will be notified of the decision by August 7, 2025.</p>\n\n\n\n<p>For additional information, visit the <a href=\"https://wordpressfoundation.org/projects/kim-parsell-memorial-scholarship/\">Kim Parsell Memorial Scholarship page</a> hosted by the WordPress Foundation.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-2-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><strong>Ready to Apply?</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://wordcampcentral.survey.fm/wcus-2025-kim-parsell-scholarship-application\">Submit Your Application Today</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"333\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/07/kim-jose.jpeg?resize=500%2C333&#038;ssl=1\" alt=\"\" class=\"wp-image-18917\" style=\"border-width:25px;border-radius:40px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/07/kim-jose.jpeg?w=500&amp;ssl=1 500w, https://i0.wp.com/wordpress.org/news/files/2025/07/kim-jose.jpeg?resize=300%2C200&amp;ssl=1 300w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Join the Celebration</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Tickets for WordCamp US 2025 are now available—secure yours soon!</li>\n\n\n\n<li>Volunteer applications are open until July 11, 2025</li>\n\n\n\n<li>Interested in supporting the event? Explore our <a>sponsorship opportunities</a></li>\n</ul>\n\n\n\n<p>Help us spread the word about this opportunity and make WordCamp US 2025 even more special.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18911\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Introducing WordPress Credits: A New Contribution Internship Program for University Students\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Jul 2025 16:56:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:17:\"WordPress Credits\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18913\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:393:\"The WordPress Foundation is proud to launch WordPress Credits, a contribution-focused internship program that brings university students into the heart of the WordPress open source project. While WordPress thrives on contributions from a global volunteer community, many students and newcomers face barriers to entry, such as a lack of structured guidance or real-world experience in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Isotta Peira\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4712:\"\n<p>The WordPress Foundation is proud to launch WordPress Credits, a contribution-focused internship program that brings university students into the heart of the WordPress open source project. While WordPress thrives on contributions from a global volunteer community, many students and newcomers face barriers to entry, such as a lack of structured guidance or real-world experience in open source projects. This new program is designed to bridge that gap, nurturing future contributors and ensuring WordPress remains innovative, inclusive, and sustainable for years to come.</p>\n\n\n\n<p>The <a href=\"https://gamma.app/docs/EN-WordPress-Credits-vz0k2vr1ulg91qq?mode=doc\">pilot program</a>, developed in partnership with the University of Pisa, was announced on stage at WordCamp Europe 2025 by Matt Mullenweg and Mary Hubbard. Since then, it has attracted interest from students across various fields of study, including humanities, computer science, and communication. Companies in the WordPress ecosystem have also expressed support and interest in contributing to the project. In response to the growing interest from both community members and academic institutions, we are now inviting more universities to join the initiative.</p>\n\n\n\n<p>Open to students from all fields of study, the program blends structured onboarding with a personalized contribution project. Activities are adapted to each student’s degree program and familiarity with WordPress, aiming to develop transferable skills, academic-related competencies, and active participation in the WordPress community. Internship durations may vary depending on the university or educational institution. Some may align with academic semesters (typically 3–4 months), while others, like the University of Pisa, allow students to sign up year-round with a requirement to complete a set number of contribution hours (e.g. 150 hours). Flexible arrangements can be discussed to meet the specific requirements of each institution.</p>\n\n\n\n<p>Foundational Training includes:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>An introduction to open source principles and the WordPress Foundation</li>\n\n\n\n<li>Getting familiar with community tools (Slack, Make blogs, Learn platform, GitHub)</li>\n\n\n\n<li>Setting up a personal WordPress site and publishing content</li>\n</ul>\n\n\n\n<p>Each student will choose a contribution area and design their own personal project within that area. Examples of possible projects include:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Translating interfaces or documentation</li>\n\n\n\n<li>Creating multilingual subtitles for educational videos</li>\n\n\n\n<li>Contributing code or performing testing</li>\n\n\n\n<li>Supporting product development or design</li>\n\n\n\n<li>Writing or editing content</li>\n\n\n\n<li>Assisting with community event organization</li>\n\n\n\n<li>Developing training materials for Learn WordPress</li>\n\n\n\n<li>Creating open source tools</li>\n\n\n\n<li>And much more…<br></li>\n</ul>\n\n\n\n<p>Interns are guided by an experienced mentor specific to their chosen area and supported by a dedicated WordPress Foundation contact person throughout the program. All student contributions, whether code, translations, documentation, or educational materials, will be publicly visible and integrated into official WordPress projects and resources, directly benefiting the wider community.</p>\n\n\n\n<p><strong>Interested universities and educational institutions</strong> interested in participating can reach out by filling <a href=\"https://airtable.com/appIzQKfwTn5dyPVp/shrYvY0CDNIkILIre\">the interest form</a>.</p>\n\n\n\n<p>We also invite companies in the WordPress ecosystem to support this initiative by sponsoring mentors who will guide and empower the next generation of contributors, or by providing tools and resources that help students succeed in their contribution journey.&nbsp;</p>\n\n\n\n<p><strong>If your company is interested in getting involved</strong>, please visit the <a href=\"https://make.wordpress.org/handbook/wordpress-credits-contribution-internship-program/get-involved-company-guide/\">Company Guide</a> to learn more and <a href=\"https://airtable.com/appIzQKfwTn5dyPVp/shrKDkjeUdw8Fof34\">fill out the form</a> to join the program.</p>\n\n\n\n<p><em>By welcoming students, mentors, sponsors, and volunteers into this initiative, we are building a stronger and more connected WordPress community. Each person who takes part, whether they guide a student, share their experiences, provide sponsorship, or simply help spread the word, helps ensure that open source remains vibrant and accessible for all. Together, we are not just supporting individual contributors; we are shaping the future of WordPress and open source itself.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18913\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WordCamp US 2025: See You in Portland, Oregon!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wordpress.org/news/2025/06/wordcamp-us-2025-see-you-in-portland-oregon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 Jun 2025 18:14:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"WCUS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18884\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:383:\"WordCamp US 2025 is heading to vibrant Portland, Oregon, from August 26–29, 2025! Join fellow open source enthusiasts, developers, designers, and WordPress professionals from across the United States and around the world for four days of learning, networking, and collaboration at the Oregon Convention Center. Nestled in the Pacific Northwest, Portland is famous for its [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8274:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-18885\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us-2025-portland.png?w=1200&amp;ssl=1 1200w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>WordCamp US 2025 is heading to vibrant Portland, Oregon, from August 26–29, 2025! Join fellow open source enthusiasts, developers, designers, and WordPress professionals from across the United States and around the world for four days of learning, networking, and collaboration at the Oregon Convention Center.</p>\n\n\n\n<p>Nestled in the Pacific Northwest, Portland is famous for its creative spirit, lush green spaces, and riverside trails, making it an inspiring backdrop for this year’s WordCamp. Whether building your first site or leading a digital agency, WordCamp US offers something for everyone, all set against the city’s stunning natural scenery.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Tickets are limited—secure yours today!</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://us.wordcamp.org/2025/tickets/\">Get your ticket now</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">What to Expect</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Contributor Day: August 26</h3>\n\n\n\n<p>Kick off your WordCamp US experience by giving back. Contributor Day welcomes all skill levels to collaborate on teams that help make WordPress better, from code to community to documentation. You can make a difference to the project, and build new friendships or rekindle old ones, perhaps even while enjoying views of Portland’s skyline and tree-lined streets.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Main Conference: August 27–29</h3>\n\n\n\n<h4 class=\"wp-block-heading\">Showcase Day &#8211; August 27</h4>\n\n\n\n<p>As part of the main conference, day one will give us a look at project showcases, discover innovative uses of WordPress, see how people push the platform’s boundaries, and get inspired to try something new.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Session Days + Expo Hall &#8211; August 28-29</h4>\n\n\n\n<p>Experience another two days filled with inspiring keynotes, practical sessions, and deep dives into the latest trends in web development, design, content, accessibility, and more. Hear from some of the brightest minds in the WordPress ecosystem and explore topics that get to the heart of what makes WordPress unique. Also, take some time to explore the main floors of WCUS, like the Sponsors Hall.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Networking and Community</h3>\n\n\n\n<p>Meet WordPress friends new and old, exchange ideas with community leaders, and collaborate with people who share your passion for open source. Enjoy daily lunches and a memorable social event, all included with your ticket. Stroll along the Willamette River or explore nearby parks in between sessions.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Venue &amp; Accommodations</h3>\n\n\n\n<p>This year, we’re gathering at the Oregon Convention Center in the heart of Portland—a city known for its vibrant neighborhoods and abundant green spaces. We’ve secured a special hotel block right across the street at the Hyatt Regency Portland for convenient, comfortable lodging during your stay.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f3e2.png\" alt=\"🏢\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></strong> <strong>Oregon Convention Center<br></strong>777 NE Martin Luther King Jr Blvd<br>Portland, OR 97232<br></li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f6cf.png\" alt=\"🛏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Hyatt Regency Portland</strong><br>375 NE Holladay Street<br>Portland, OR 97232<br><a href=\"https://www.hyatt.com/en-US/group-booking/PDXRP/G-CAMP\">Book your room!</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Registration and Tickets</h2>\n\n\n\n<p>Registration officially kicked off last month. Secure your spot early; tickets are selling quickly.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Tickets are limited—secure yours today!</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://us.wordcamp.org/2025/tickets/\">Get your ticket now</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Ready to Plan Your WordCamp US Experience?</h2>\n\n\n\n<p>Keep checking the <a href=\"https://us.wordcamp.org/2025/\">WordCamp US site</a> for travel tips, to book accommodations, and to watch for the whole event schedule—coming soon! While here, why not plan to take in some of Portland’s scenic hiking trails, bike-friendly streets, or local food scene?</p>\n\n\n\n<p>Stay tuned for updates and announcements on <a href=\"https://make.wordpress.org/marketing/handbook/social-media/\">WordPress social media channels</a>, and join the conversation.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Help Us Spread the Word!</h3>\n\n\n\n<p>Whether attending in person or following along online, share your experience and help welcome others to the WordPress community. Use the #WCUS and #WordPress hashtags and tell your story on social!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18898\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/wordcamp-us.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Portland is calling—see you at WordCamp US 2025! <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f332.png\" alt=\"🌲\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18884\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"Dropping security updates for WordPress versions 4.1 through 4.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://wordpress.org/news/2025/06/dropping-security-updates-for-wordpress-versions-4-1-through-4-6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jun 2025 15:26:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18872\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:331:\"As of July 2025, the WordPress Security Team will no longer provide security updates for WordPress versions 4.1 through 4.6. These versions were first released nine or more years ago and over 99% of WordPress installations run a more recent version. The chances this will affect your site, or sites, is very small. If you [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"John Blackbourn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3132:\"\n<p>As of July 2025, the WordPress Security Team will no longer provide security updates for WordPress versions 4.1 through 4.6.</p>\n\n\n\n<p>These versions were first released nine or more years ago and over 99% of WordPress installations run a more recent version. The chances this will affect your site, or sites, is very small.</p>\n\n\n\n<p>If you are unsure if you are running an up-to-date version of WordPress, please log in to your site’s dashboard. Out of date versions will display a notice that looks like this:</p>\n\n\n\n<figure class=\"wp-block-image size-full has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1048\" height=\"122\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=1048%2C122&#038;ssl=1\" alt=\"Dashboard notice: &quot;WordPress 6.8.1 is available! Please update now.&quot;\" class=\"has-border-color has-luminous-vivid-amber-border-color wp-image-18873\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?w=1048&amp;ssl=1 1048w, https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=300%2C35&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=1024%2C119&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/09/WordPress-681-update-notice.png?resize=768%2C89&amp;ssl=1 768w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>The version you are running is displayed in the bottom of the “At a Glance” section of the dashboard.</p>\n\n\n\n<figure class=\"wp-block-image size-large has-custom-border\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"281\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=1024%2C281&#038;ssl=1\" alt=\"At a glance widget showing a site running WordPress 4.1.41\" class=\"has-border-color has-cyan-bluish-gray-border-color wp-image-18875\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=1024%2C281&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=300%2C82&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=768%2C211&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?resize=1536%2C421&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2022/09/at-a-glance-wp-4141.png?w=1798&amp;ssl=1 1798w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>As a reminder, the only <em>actively</em> supported version of WordPress is the most recent one. Security updates are only backported to older branches as a courtesy.</p>\n\n\n\n<p>The Make WordPress Security blog has further details about <a href=\"https://make.wordpress.org/security/2025/06/18/security-updates-will-cease-for-wordpress-versions-4-1-through-4-6/\" data-type=\"link\" data-id=\"https://make.wordpress.org/security/2025/06/18/security-updates-will-cease-for-wordpress-versions-4-1-through-4-6/\">the process to end support</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18872\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WCEU 2025: A Community Celebration in the Swiss Sun\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wordpress.org/news/2025/06/wceu-2025-a-community-celebration-in-the-swiss-sun/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Jun 2025 19:19:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"WCEU\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18776\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:362:\"Over 1,723 attendees from 84 countries gathered at the Messe and Congress Center Basel in Switzerland, and 20,353 more joined online for WordCamp Europe 2025. I’m personally very excited&#8230; There’s so much I want to do. I think there’s a clear pathway to 7.0 and beyond. Matt Mullenweg, WordPress Cofounder The flagship WordPress event kicked [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:61400:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18837\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0151-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><figcaption class=\"wp-element-caption\"><em>Photo by Nilo Velez</em></figcaption></figure>\n\n\n\n<p>Over 1,723 attendees from 84 countries gathered at the Messe and Congress Center Basel in Switzerland, and 20,353 more joined online for WordCamp Europe 2025.</p>\n\n\n\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-6c531013 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-pullquote\"><blockquote><p>I’m personally very excited&#8230; There’s so much I want to do. I think there’s a clear pathway to 7.0 and beyond.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>The flagship WordPress event kicked off in Basel, Switzerland, with a dedicated Contributor Day. It was followed by two days of engaging talks, panels, hands-on workshops, and vibrant community connections. WordPress Cofounder Matt Mullenweg and Executive Director Mary Hubbard joined a diverse lineup of speakers and panelists, sharing insights in the heart of one of Europe’s most charming cities.</p>\n\n\n\n<p>Set against the backdrop of Basel’s historic streets and Rhine-side views, the sponsor hall buzzed with activity as companies from across the WordPress ecosystem showcased their latest innovations, offered live demos, and connected with attendees. Each day, participants refueled with a range of local and international cuisine — from Swiss specialties to global favorites — making mealtime a lively space for networking, collaboration, and sparking new ideas.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Global Gathering in Basel</h2>\n\n\n\n<p>WordCamp Europe has long been one of the most anticipated WordPress events of the year — a space where community, creativity, and collaboration thrive. This year in Basel, the conference delivered an exciting and diverse program that reached every corner of the WordPress ecosystem.</p>\n\n\n\n<p>Here’s what attendees experienced:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Engaging Sessions Across Tracks</strong> &#8211; Across two full days, the conference featured informative talks, captivating keynotes, and dynamic discussions exploring WordPress and the broader web.</li>\n\n\n\n<li><strong>A Global Speaker Lineup</strong> &#8211; The stage welcomed 52 speakers from 23 countries across five continents, each bringing unique insights and global perspectives.</li>\n\n\n\n<li><strong>Wide-Ranging Topics</strong> &#8211; The schedule included 45 sessions and four hands-on workshops across three tracks, covering:\n<ul class=\"wp-block-list\">\n<li>Accessibility and key policy updates like the European Accessibility Act and the Cyber Resilience Act</li>\n\n\n\n<li>The evolving role of Artificial Intelligence in the open web</li>\n\n\n\n<li>Cutting-edge web design, development best practices, SEO, and content strategy</li>\n\n\n\n<li>Real-world case studies and showcases from across the community</li>\n</ul>\n</li>\n\n\n\n<li><strong>Hands-On Learning Opportunities</strong> &#8211; Interactive workshops allowed attendees to roll up their sleeves and develop practical skills in a collaborative setting.</li>\n\n\n\n<li><strong>A Community Built on Collaboration</strong> &#8211; Whether developer, designer, content creator, or entrepreneur, every attendee found space to connect, learn, and grow within a vibrant and welcoming community.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day</h2>\n\n\n\n<p>WordCamp Europe began with a vibrant Contributor Day that brought together 640 contributors—including many first-timers—to collaborate, share knowledge, and support the WordPress project. Guided by 33 dedicated table leads, with 21 teams, attendees of all experience levels came together to exchange ideas, solve real challenges, and make meaningful contributions to open source. From accessibility improvements to theme development and translation efforts, every table played a part in moving WordPress forward.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-3 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px;border-radius:2px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238da91e9&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238da91e9\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18798\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18798\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568125707_c7f1d5c4a2_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238da94e2&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238da94e2\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18799\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18799\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568126032_465e58f52e_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Jeroen Rotty</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238da9786&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238da9786\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18800\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18800\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568127677_4608e6c2e5_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238da9a40&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238da9a40\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18801\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18801\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568995131_a2b3103540_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Roan de Vries</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238da9cba&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238da9cba\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18802\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-18802\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54568997316_388cdfd4e5_k-1.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238da9f86&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238da9f86\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18803\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18803\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219743_6bc7238ce1_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Nilo Velez</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238daa264&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238daa264\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18804\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18804\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569219883_c2df21a0cb_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238daa4fb&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238daa4fb\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18805\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18805\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220458_b2cc7018a6_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Levente András Tóth</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238daa7ca&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238daa7ca\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18806\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18806\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569220633_32194e94d5_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Jeroen Rotty</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238daaa62&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238daaa62\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18807\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18807\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320070_03f700e2a1_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Levente András Tóth</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238daad90&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238daad90\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18808\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18808\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569320480_cc49061ebc_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Sebastián Echeverri Jaramillo</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238dab0bb&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238dab0bb\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18809\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18809\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569323570_dfb78eb42f_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238dab36f&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238dab36f\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18810\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18810\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250605-WA0137-1-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Nilo Velez</figcaption></figure>\n</figure>\n\n\n\n<p>Contributor Day at WordCamp Europe 2025 brought together a mix of first-time and returning contributors across a wide range of teams, from Core and Accessibility to Polyglots, Training, and Community. Attendees tackled everything from onboarding and ticket triage to translating strings, improving documentation, and enhancing tools and workflows. Development-focused teams explored performance and testing improvements and worked through live coding exercises. Meanwhile, accessibility testers, support volunteers, and photo moderators contributed to efforts that directly impact users around the world.</p>\n\n\n\n<p>In parallel, teams like Marketing, Meta, Hosting, and Sustainability focused on future-facing initiatives—from promoting WordPress through the Showcase and social media campaigns to refining infrastructure, increasing accessibility, and preparing for long-term project growth. Whether contributing to plugins, themes, documentation, or new contributor experiences, participants reinforced the values that power the WordPress project: collaboration, inclusivity, and openness. The day served as a reminder that WordPress is not just software—it’s a community built by and for everyone.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Tomorrow Starts with WordPress</h2>\n\n\n\n<p>The first full day of WordCamp Europe 2025 brought the community together to celebrate the power of open source collaboration and innovation. Opening remarks from both global and local event leads reflected on the journey of WordCamp Europe—from its beginnings in 2013 in Leiden, Netherlands, to the vibrant event in Basel today. This full-circle moment underscored the growth of the WordPress community, united by a shared commitment to an open web.</p>\n\n\n\n<p>The day launched into an inspiring program with the keynote session, <em>WordPress Without Borders – The Fight for Digital Freedom</em>, delivered by Noel Tock. Drawing from his experiences—including time on the frontlines in Ukraine—Tock illustrated how open source supports global resilience and serves as a digital human right. His message called on contributors to see their work as part of something greater, offering a compelling and forward-looking vision to energize and unify the WordPress community.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"WordPress without Borders — The Fight for Digital Freedom | Noel Tock\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/tb_A-ABehnY?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>From there, the program unfolded across multiple tracks—each one sparking new conversations and insights. One standout session highlighted social entrepreneurship in Bulgaria, where WordPress is helping grassroots organizations drive change in education, journalism, and social justice. Petya Raykovska shared how nonprofits like Teenovator and the Bulgarian Fund for Women are using WordPress to amplify their work and strengthen their communities.</p>\n\n\n\n<p>Designers and developers explored ways to improve workflows and collaboration. In <em>Bridging Design and Development</em>, attendees learned how Figma Design Systems can connect design and development through shared structures mapped to block themes. Real-world examples, like the Novus Media Newspaper Design System, demonstrated how scalable, consistent design can power multi-brand platforms.</p>\n\n\n\n<p>Workshops played a key role throughout the day, including the interactive <em>Block Developer Cookbook: WCEU 2025 Edition</em>, where attendees worked through community-voted code recipes featuring the latest WordPress APIs. Sessions also dove into emerging technologies, such as <em>Automating WordPress Setup with Modern AI Tools</em>, which showcased how WP-CLI, scripting, and AI can accelerate project setup and reduce repetitive tasks.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18817\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048139_5009fd3c2b_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><figcaption class=\"wp-element-caption\"><em>Photo by Marc Wieland</em></figcaption></figure>\n\n\n\n<p>Day Two of WordCamp Europe 2025 opened with a focus on the evolving role of the WordPress community in a rapidly changing digital world. Sessions explored how contributors—from local meetup organizers to global advocates—play a vital part in shaping WordPress’s future. Talks on inclusivity, such as <em>Over the Rainbow</em>, encouraged attendees to consider how individual actions can help build a more welcoming, representative open source ecosystem. Throughout the morning, the spirit of collaboration and shared purpose remained front and center.</p>\n\n\n\n<p>As the day progressed, attention turned to the tools and technologies pushing WordPress forward. From sessions on scaling multilingual sites and managing observability to hands-on workshops, developers explored new ways to streamline workflows and enhance performance. Highlights included <em>WordPress Gems for Devs</em>, which introduced the Interactivity API through live coding, and <em>Client-side Web AI Agents</em>, a look at cutting-edge browser-based AI that unlocks new possibilities for web experiences. These talks reflected the platform’s growing capacity to adapt to emerging trends while staying true to its open foundations.</p>\n\n\n\n<p>The afternoon brought a blend of practical guidance and inspiring stories across tracks. A case study on accessibility from Switzerland showed how thoughtful design can benefit all users, while a session on brand-building for women entrepreneurs highlighted the creative and economic opportunities WordPress enables. With topics spanning content strategy, business growth, regulatory readiness, and more, the second day of WCEU 2025 affirmed the strength of the WordPress ecosystem—not only as a technology platform, but as a global movement fueled by people, purpose, and possibility.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Fireside Chat</h2>\n\n\n\n<p>As the final day drew to a close, Matt and Mary shared some thoughts on EU regulation (Open Web Alliance), AI, and the introduction of the WordPress AI team, and then answered questions from the audience.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"Fireside chat with Q&amp;A | Mary Hubbard and Matt Mullenweg\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/mzJwYejWUbY?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Closing</h2>\n\n\n\n<p>A heartfelt thank you to the dedicated organizers who brought WordCamp Europe 2025 to life in Basel, the speakers who shared their insights, the attendees who joined us in person, and those who followed along from afar. We hope you leave with fresh ideas, meaningful connections, and renewed energy to help shape the future of the open web.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-4 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width:20px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238daba84&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238daba84\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18827\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18827\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571099103_b61e92651c_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Jeroen Rotty</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238dabd13&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238dabd13\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18825\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18825\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570002952_63c3ced847_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Chris Clarke</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238dabfb2&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238dabfb2\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18824\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18824\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54569999382_839ad34def_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238dac241&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238dac241\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18823\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18823\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571194430_99b40d9280_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Thanh Nguyen</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238dac4ab&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238dac4ab\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"684\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18822\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?resize=1024%2C684&#038;ssl=1\" alt=\"\" class=\"wp-image-18822\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?resize=1024%2C684&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?resize=768%2C513&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571195715_0e2dbb778c_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Maksym Kaharlytskyi</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238dac719&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238dac719\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"799\" height=\"533\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18821\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571048019_d36c78cc86_c.jpg?resize=799%2C533&#038;ssl=1\" alt=\"\" class=\"wp-image-18821\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54571048019_d36c78cc86_c.jpg?w=799&amp;ssl=1 799w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048019_d36c78cc86_c.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54571048019_d36c78cc86_c.jpg?resize=768%2C512&amp;ssl=1 768w\" sizes=\"auto, (max-width: 799px) 100vw, 799px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Chris Clarke</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238dac98a&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238dac98a\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18820\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18820\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570870476_a8bef84c32_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Atsushi Ando</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238dacc1c&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238dacc1c\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18819\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18819\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570001717_fa54bba4e1_k.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Nilo Velez</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238daceaa&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238daceaa\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18829\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18829\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/54570869816_7de53cc2f1_k-1.jpg?w=2048&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Jeroen Rotty</figcaption></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;68c1238dad1b3&quot;}\" data-wp-interactive=\"core/image\" data-wp-key=\"68c1238dad1b3\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"682\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18859\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?resize=1024%2C682&#038;ssl=1\" alt=\"\" class=\"wp-image-18859\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?resize=1024%2C682&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?resize=1536%2C1023&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/06/IMG-20250607-WA0337.jpg?w=1600&amp;ssl=1 1600w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Nilo Velez</figcaption></figure>\n</figure>\n\n\n\n<p>Be sure to mark your calendars for the final major WordPress events in 2025: <a href=\"https://us.wordcamp.org/2025/\">WordCamp US</a> (Portland, Oregon, USA). Then join us in <a href=\"https://europe.wordcamp.org/2026/\">Kraków, Poland for WordCamp Europe 2026</a>! Also, if you want to get involved with WCEU, the call for organisers is already open for 2026. </p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18776\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Announcing the Formation of the WordPress AI Team\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wordpress.org/news/2025/05/announcing-the-formation-of-the-wordpress-ai-team/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 May 2025 16:28:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18769\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:397:\"Today, I’m pleased to announce the formation of a new WordPress AI Team, a dedicated group focused on accelerating and coordinating artificial intelligence projects across the WordPress ecosystem. AI is already transforming how people create and manage content online. As this technology evolves, it’s essential that WordPress remains at the forefront, ensuring innovation happens in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mary Hubbard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2961:\"\n<p>Today, I’m pleased to announce the formation of a new <strong>WordPress AI Team,</strong> a dedicated group focused on accelerating and coordinating artificial intelligence projects across the WordPress ecosystem.</p>\n\n\n\n<p>AI is already transforming how people create and manage content online. As this technology evolves, it’s essential that WordPress remains at the forefront, ensuring innovation happens in the open, guided by community values, and built to core standards.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Why This Matters</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Strategic focus</strong>: A unified team stewards AI development thoughtfully, avoids fragmentation, and ensures alignment with the long-term goals of WordPress. </li>\n\n\n\n<li><strong>Shared innovation</strong>: Contributors and companies are actively exploring AI across the ecosystem. This team provides a central place to collaborate, share ideas, and build together.</li>\n\n\n\n<li><strong>Rapid iteration</strong>: Like the Performance Team, we’ll take a plugin-first approach. <a href=\"https://make.wordpress.org/core/2022/09/11/canonical-plugins-revisited/\">Canonical Plugins</a> will allow us to move quickly, gather feedback, and deliver real value without waiting on the Core release cycle.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">What to Expect</h2>\n\n\n\n<p>The AI Team will:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Coordinate cross-team efforts to explore AI-powered features responsibly and inclusively.</li>\n\n\n\n<li>Publish and maintain a public roadmap of AI initiatives and Canonical Plugins.</li>\n\n\n\n<li>Collaborate closely with Core, Design, Accessibility, and other teams to ensure strong integration and shared standards.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Meet the Team</h2>\n\n\n\n<p>The WordPress AI Team brings deep experience in open-source, performance, and product development and a strong commitment to building AI features the WordPress way. The team will launch with the following team contributors:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>James LePage</strong> – Automattic</li>\n\n\n\n<li><strong>Felix Arntz</strong> – Google</li>\n\n\n\n<li><strong>Pascal Birchler</strong> – Google</li>\n\n\n\n<li><strong>Jeff Paul</strong> – 10up</li>\n</ul>\n\n\n\n<p>To help get things started, James and Felix will serve as the initial <a href=\"https://make.wordpress.org/updates/team-reps/\">Team Reps</a> in supporting team organization, communication, and coordination with other Make WordPress teams.</p>\n\n\n\n<p>This is an exciting and important step in WordPress’s evolution. I look forward to seeing what we’ll create together and in the open.</p>\n\n\n\n<p>If you’re interested in contributing or following along, please join the conversations in <a href=\"https://wordpress.slack.com/archives/C08TJ8BPULS\">#core-ai</a> and watch for upcoming meeting announcements on <a href=\"https://make.wordpress.org/ai/\">https://make.wordpress.org/ai/</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18769\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 10 Sep 2025 07:08:37 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:25:\"strict-transport-security\";s:12:\"max-age=3600\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 02 Sep 2025 18:14:36 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";i:1727751020;s:21:\"cache_expiration_time\";i:1757531318;s:23:\"__cache_expiration_time\";i:1757531318;}", "off");
INSERT INTO `wpvv_options` VALUES("3862", "_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1757531321", "off");
INSERT INTO `wpvv_options` VALUES("3863", "_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1757488121", "off");
INSERT INTO `wpvv_options` VALUES("3864", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1757531324", "off");
INSERT INTO `wpvv_options` VALUES("3865", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:112:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Matt: Techmeme 20\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=149734\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://ma.tt/2025/09/techmeme-20/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:616:\"<p>It&#8217;s New Apple Stuff day, so the headlines are being dominated by that, but it&#8217;s worth taking a step back and paying homage to the site that has been the front page of tech news for two decades now, <a href=\"https://techmeme.com/\">Techmeme</a>. I&#8217;ve been a daily visitor since it started, and I appreciate how they pair the algorithm with a light human touch to provide a wide overview. (WordPress-powered!) <a href=\"https://crazystupidtech.com/2025/09/08/at-20-techmeme-has-never-been-hotter/\">Fred Vogelstein at Crazy Stupid Tech has a great review of how Techmeme started and evolved</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 09 Sep 2025 20:24:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Open Channels FM: Lessons From Building and Managing Multiple WordPress Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=108988\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://openchannels.fm/lessons-from-building-and-managing-multiple-wordpress-plugins/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:188:\"Here are some lessons learned in building a WordPress plugin business, emphasizing experimentation, market understanding, customer support, and community engagement for sustainable growth.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 09 Sep 2025 09:53:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"Open Channels FM: The Founders of Podcaster Plus Share Product Development Experiences and Community Insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=108599\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"https://openchannels.fm/the-founders-of-podcaster-plus-share-product-development-experiences-and-community-insights/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:215:\"In this WP Behind the Builds episode, Mark Westguard discusses the upcoming Podcaster Plus plugin with founders Nathan and Dan, emphasizing its features like customizable audio players and automation for podcasters.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 09 Sep 2025 08:16:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Matt: Assorted Links\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=149725\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://ma.tt/2025/09/links/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1682:\"<p>A few interesting reads or listens:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://www.wired.com/story/multiple-chemical-sensitivity-tilt-claudia-miller/\">The Next Thing You Smell Could Ruin Your Life</a>, a deep dive into chemical sensitivity and toxicant-induced loss of tolerance, or TILT, by <a href=\"https://lexipandell.com/\">Lexi Pandell</a> (WordPress!) at Wired.</li>\n\n\n\n<li><a href=\"https://www.newyorker.com/culture/infinite-scroll/irl-brain-rot-and-the-lure-of-the-labubu\">IRL Brain Rot and the Lure of the Labubu</a>, by <a href=\"https://www.kylechayka.com/\">Kyle Chayka</a> at New Yorker.</li>\n\n\n\n<li><a href=\"https://simonwillison.net/2025/Aug/9/bay-area-ai/\">Simon Willison&#8217;s Lethal Trifecta talk</a>, on the myriad security issues that arise when combining LLMs, prompt injection, MCPs, and more.</li>\n\n\n\n<li><span style=\"margin: 0px; padding: 0px;\">Daniel Stenberg, a lead developer of the open source utility Curl, <a href=\"https://www.youtube.com/watch?v=6n2eDcRjSsk\" target=\"_blank\">talks at FrOSCon about how AI reports are gumming up their security workflows</a>.</span> (YouTube, 53 minutes.) </li>\n\n\n\n<li><a href=\"https://daniel.haxx.se/blog/2025/08/15/car-brands-running-curl/\">Daniel again (on his WordPress-powered blog) discusses a version of their maker/taker problem</a>, specifically the 47 car brands that use Curl but none that sponsor it.</li>\n\n\n\n<li>Fernando Borretti&#8217;s <a href=\"https://borretti.me/article/notes-on-managing-adhd\">Notes on Managing ADHD</a>.</li>\n\n\n\n<li>Good Taste Is More Important Than Ever, by <a href=\"https://www.theatlantic.com/author/nitin-nohria/\">Nitin Nohria</a> in The Atlantic.<br /></li>\n</ul>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 08 Sep 2025 23:20:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Matt: Maker Taker\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=149704\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://ma.tt/2025/09/maker-taker/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2543:\"<p>My sister <a href=\"https://charleen.blog/\">Charleen</a> sent me this meme with the note &#8220;Someone needs to draw you in there with your arm up <img alt=\"🤣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f923.png\" style=\"height: 1em;\" /><img alt=\"🤣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f923.png\" style=\"height: 1em;\" /><img alt=\"🤣\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f923.png\" style=\"height: 1em;\" />&#8221; It&#8217;s a nice ode to the <a href=\"https://dri.es/solving-the-maker-taker-problem\">Dries essay on Maker/Taker problems</a>.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"\" class=\"wp-image-149705\" height=\"509\" src=\"https://i0.wp.com/ma.tt/files/2025/09/IMG_3812.jpeg?resize=604%2C509&#038;quality=89&#038;ssl=1\" width=\"604\" /></figure>\n\n\n\n<p>Well, thanks to the magic of AI, I asked the <a href=\"https://aistudio.google.com/\">Nano Banana AI Studio</a> to &#8220;make it so on the bottom one person raises their hand,&#8221; and it didn&#8217;t work at first. So, I tried a few other variations, and then, voilà!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-149706\" height=\"500\" src=\"https://i0.wp.com/ma.tt/files/2025/09/Generated-Image-September-06-2025-7_32PM-1024x848.jpeg?resize=604%2C500&#038;quality=89&#038;ssl=1\" width=\"604\" /></figure>\n\n\n\n<p>Technology is amazing. And now we have a counter to the meme. Be that one hand that raises.</p>\n\n\n\n<p>Although this is a joke, I&#8217;m going to give humanity a high-five because, compared to when I started in technology, <a href=\"https://en.wikipedia.org/wiki/Halloween_documents\">which was more the Microsoft Halloween memo era, to where we are today</a>, I&#8217;m <strong>so impressed</strong> that so many makers, creators, designers, engineers, and leaders have adopted the moral framework of open source being part of their calling. Businesses, too! I used to get laughed out of the room or had spears thrown at the security of open source, but that is no longer a blocker, and the conversation has really elevated. It doesn&#8217;t feel like one person raising their hand anymore; it&#8217;s grown into a truly special movement, a lens through which you can view almost anything.</p>\n\n\n\n<p>Open source is the best way we have to set the foundation for future generations to build upon, ensuring the light cone of humanity&#8217;s technological expansion becomes something that belongs to all of us, not just a few.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 07 Sep 2025 19:08:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Matt: Breaking Ribs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=149695\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://ma.tt/2025/09/breaking-ribs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1959:\"<p><span style=\"margin: 0px; padding: 0px;\"><a href=\"https://chrisyoungcooks.com/\" target=\"_blank\">Chris Young</a>, who is otherwise famous for being a <a href=\"https://modernistcuisine.com/books/modernist-cuisine/\" target=\"_blank\">co-author of the 2,438-page cookbook Modernist Cuisine</a> or <a href=\"https://www.youtube.com/shorts/s8OcZYCBaOo\" target=\"_blank\">centrifuging steaks and drinking them</a>, is one of the friends who, over the years, has told me I have to watch <a href=\"https://en.wikipedia.org/wiki/Breaking_Bad\" target=\"_blank\">Breaking Bad</a>, the TV show.</span> When I was in Marrakech for a few weeks earlier this year, and it was a million degrees outside, I cracked and started watching, and I see why people say it&#8217;s one of the best shows ever. I&#8217;m only up to S2E4, and I see why everyone loves it, including that it is sometimes unintentionally hilarious,  but I had to stop because it was getting a bit too dark and bumming me out before I went to bed.</p>\n\n\n\n<p>However, I&#8217;m glad I made it through that season and a half of Breaking Bad, because it has given me the ability to appreciate this homage Chris has done, attempting to use science and chemistry to cook ribs in an apartment oven just as well as you could with a smoker. If you live at the intersection of Breaking Bad, BBQ, science, chemistry, and cooking, this is the video for you. And now, this makes me want to order some <a href=\"https://thepitroombbq.com/\">Pit Room</a> in Houston. (WordPress-powered!)</p>\n\n\n\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>And if you haven&#8217;t yet, you should <a href=\"https://combustion.inc/\">buy one of Chris&#8217; Combustion Predictive Thermometers</a> (<a href=\"https://www.amazon.com/dp/B0DNKJ8FQB/?tag=photomatt08-20\">here on Amazon</a>). </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 06 Sep 2025 20:33:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Gutenberg Times: Gutenberg Changelog 120—WordCamp US, Automattic Telex, Gutenberg 21.4 and 21.5, and the need for more blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=41792\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-120-wordcamp-us-telex-gutenberg-21-4-and-21-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:48635:\"<p>Birgit Pauli-Haack and Sarah Norris discussed WordCamp US, Automattic Telex, Gutenberg 21.4 and 21.5, and the need for more blocks.</p>\n\n\n\n<p>This episode dives into the ongoing evolution of Gutenberg, from AI-driven tools for easier block creation to the expansion of core blocks and enhancements stemming from vibrant community input. There’s a strong focus on practical improvements for developers and better experiences for end users, all while staying plugged into the latest WordCamp happenings and the broader future of site editing in WordPress. </p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/https://gutenbergtimes.com/podcast/gutenberg-changelog-120-wordcamp-us-telex-gutenberg-21-4-and-21-5/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/https://gutenbergtimes.com/podcast/gutenberg-changelog-120-wordcamp-us-telex-gutenberg-21-4-and-21-5/#transcript\">Transcript</a></p>\n\n\n\n<p></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Editor: <a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo: <a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production: <a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Special Guest: <strong>Sarah Norris</strong></h2>\n\n\n\n<p>JavaScript Developer / Core team rep</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://profiles.wordpress.org/mikachan/\">WordPress Profile @mikachan</a></li>\n\n\n\n<li><a href=\"https://sekai.co.uk/\">Personal website: sekai.co.uk</a></li>\n\n\n\n<li><a href=\"https://twitter.com/mikachan_\">Twitter: @mikachan_</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">WordCamp US </h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://telex.automattic.ai/projects/new\">Automattic Telex </a>build block from plain-english prompts</li>\n\n\n\n<li>Adam Silverstein’s talk, <a href=\"https://wordpress.tv/2025/09/03/unlock-developer-superpowers-with-ai/\">Unlock Developer Superpowers with AI</a></li>\n\n\n\n<li>John Maeda’s talk,<a href=\"https://wordpress.tv/2025/09/03/cozy-ai-cooking-wordcamp-edition/\"> Cozy AI Cooking: WordCamp Edition</a></li>\n\n\n\n<li>Prof. Adam Gazzaley’s talk, <a href=\"https://wordpress.tv/2025/09/03/a-new-era-of-experiential-medicine-ai-and-the-brain/\">A New Era of Experiential Medicine—AI and the Brain</a></li>\n\n\n\n<li>Michelle Hunt’s <a href=\"https://wordpress.tv/2025/09/03/building-experiences-design-systems-user-experience-and-full-site-editing/\">Building Experiences: Design Systems, User Experience, and Full Site Editing</a></li>\n\n\n\n<li>Mary Ann Aschenbrenner’s talk, <a href=\"https://wordpress.tv/2025/09/03/moving-a-website-from-classic-to-a-block-theme/\">Moving a Website from Classic to a Block Theme</a></li>\n\n\n\n<li><a href=\"https://wordpress.tv/2025/09/03/block-composability-the-past-and-the-future/\">Block Composability: The Past and The Future</a> with Seth Rubenstein and Max Schmeling. </li>\n\n\n\n<li><a href=\"https://wordpress.tv/event/wordcamp-us-2025/\">Full list of talks is available on WordPress TV here.</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress Developer Blog</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://developer.wordpress.org/news/2025/08/whats-new-for-developers-august-2025/\">What’s new for developers? (August 2025)</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2025/07/you-dont-need-theme-json-for-block-theme-styles/\">You don’t need theme.json for block theme styles</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2025/08/registering-custom-social-icons-in-wordpress-6-9/\">Registering custom social icons in WordPress 6.9</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2025/08/refactoring-the-multi-block-plugin-build-smarter-register-cleaner-scale-easier/\">Refactoring the Multi-Block Plugin: Build Smarter, Register Cleaner, Scale Easier</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2025/09/implementing-namespaces-and-coding-standards-in-wordpress-plugin-development/\">Implementing Namespaces and Coding Standards in WordPress Plugin Development</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/subscribe/\">Subscribe to the blog</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Gutenberg releases and work in progress</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/08/14/whats-new-in-gutenberg-21-4-13-august/\">What’s new in Gutenberg 21.4? (13 August)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/08/28/whats-new-in-gutenberg-21-5/\">What’s new in Gutenberg 21.5? (27 August)</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/71026\">New Block additions for the Block Library</a></li>\n\n\n\n<li><a href=\"https://gutenbergtimes.com/why-wordpress-core-needs-more-blocks/\">Why WordPress Core needs more blocks</a><br /></li>\n</ul>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<ul class=\"wp-block-list\">\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on X (formerly known as Twitter) or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Hello, and welcome to our 120th episode of the Gutenberg Changelog Podcast. In today&#8217;s episode we will talk about WordCamp US, Telex, Gutenberg 21.4 and 5 and also we will discuss that we need more blocks. Maybe. I&#8217;m your host Birgit Pauli-Haack, curator at the Gutenberg Times and WordPress developer advocate and full-time core contributor for the WordPress open source project sponsored by Automattic. </p>\n\n\n\n<p>And after a long break, Sarah Norris joins me again. Yay. She is a co-core team rep, a core contributor to the Goodwill Project, and developer and designer working for Automattic. Thank you so much for taking the time and coming onto the show again. Sarah, how are you today? And maybe you can briefly outline what you have been working on for what might be coming to WordPress 6.9.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah, sure. Yeah. Hello. It has been a really long time. It&#8217;s good to be back. Yeah, I&#8217;m good. I&#8217;m looking forward to autumn, my favorite time of year. So for 6.9 I&#8217;ve mostly been working on new blocks. Yes, all the new blocks. I&#8217;ve been working on the Accordion block, which was called Accordions but is now called Accordion Singular. Also I&#8217;ve been looking over the new tabs block. There&#8217;s a PR going for that that I&#8217;m really interested in, looking at maybe getting the table of contents block stabilized as well. I think there&#8217;s a lot of work to do there, but I think it&#8217;s, it&#8217;s quite well rounded, well outlined so we can get stuck in there. And then I&#8217;ve also been working on a new terms query block as well. So that&#8217;s it&#8217;s like the query loop block but for taxonomies.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Wow, it sounds exciting. Awesome. Awesome. So you&#8217;re the right person to talk about. We need more blocks later on so we&#8217;re coming to the announcements. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Announcements</h3>\n\n\n\n<h3 class=\"wp-block-heading\">Automattic Telex</h3>\n\n\n\n<p>So at his keynote at WordCamp US, Matt Mullenweg, you probably heard it all already, dear listeners announced experimental AI tool called Telex, and it can be used to build new blocks with a plain English language prompt so you don&#8217;t have to speak code. So try it out. I&#8217;ll share the links in the show notes. And Ray Mori from the repository has quite done a good rundown of all the reactions for Telex on Twitter and all that. So I&#8217;m going to share this with you. But it&#8217;s a really exciting tool and it&#8217;s also experimental, so it might not have the outcome that you want, but you might get new ideas from it. So have you tried it out, Sarah?</p>\n\n\n\n<p><em>Sarah Norris:</em> Yes. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>Sarah Norris: </em>I&#8217;ve been following the development closely and trying it out. It&#8217;s amazing. It&#8217;s so much fun to use. Yeah. Definitely recommend people try it out. You might not get what you expect, but I don&#8217;t know if you ever do with AI, it&#8217;s all about what you put into it, isn&#8217;t it? And see what you get. Especially for new blocks. People should try it to build new blocks.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So did you build a new block?</p>\n\n\n\n<p><em>Sarah Norris: </em>I built a few ideas, like a few silly things. I haven&#8217;t tried it on any new core blocks yet. Maybe that&#8217;s the. The next step. Maybe I should try it on all these new core blocks we&#8217;ve got coming up.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Well, but I&#8217;m more interested in the silly things than the crazy things or in the quirky things. But did you try?</p>\n\n\n\n<p><em>Sarah Norris: </em>What did I try? I&#8217;ve tried like some random image generators, just like some random color stuff as well. Trying like different colors, different patterns.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Sarah Norris:</em> Maybe I should add some to the new live tool so we can get them in the library.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>There&#8217;s a library maybe coming up. Okay, well, it&#8217;s the next current step. Yeah. Kind of thinking about, okay, if so many people build blocks and we want to kind of showcase all those ideas, if they&#8217;re ready enough so other people can use them, then you probably want to have a site for that. That&#8217;s totally true. Yeah, true. </p>\n\n\n\n<h3 class=\"wp-block-heading\">WordCamp US</h3>\n\n\n\n<p>Anyway, so speaking of WordCamp viewers, the talks are almost all uploaded to WordPress TV, so the team is really amazing. And there were fantastic talks at the showcase day as well as the other days. And we had about a dozen talks about AI in all kinds of flavors. And I only want to kind of point out three of them. One was for developers. Adam Silverstein’s talk Unlock Developer Superpowers with AI is definitely worth a look on the rerun as he tested quite a few new tools and also gave a great rundown on his approach and how he works with it. </p>\n\n\n\n<p>So Adam is a former Googler and he is a core committer on the WordPress project. So yeah, he&#8217;s definitely out there ahead of, well, at least me. I don&#8217;t know about Sarah, but definitely ahead of me, so. And for nondevelopers, John Maeda’s talk was a fantastic introduction in how to think about AI in his cozy AI cooking talk as a keynote on the third day. And then if you want to be amazed of what&#8217;s happening in other areas outside of development, but in other areas of science, I highly recommend Professor Adam Gazzaley’s talk on the new era of experimental medicine, AI and the brain. And he talks about how his lab at the University of San Francisco did a lot of brain testing and figured out a way to replicate and have a feedback loop, a close feedback loop to reactions on certain things. So and what they actually did was they created a video game to help people with ADHD. And that&#8217;s for prescription, but also available for adults who are kind of having a bit of a cognitive decline in the later years and want to kind of keep a stop to that or at least delay it. So it&#8217;s really an interesting talk. Totally not related to WordPress at all. So yeah, have you watched any of those talks?</p>\n\n\n\n<p><em>Sarah Norris: </em>I haven&#8217;t this week. I&#8217;ve been concentrating on basically building the terms query block. But all three of these I really want to watch. They sound really good, especially that last one that sounds super interesting.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah, the resources that he mentions in his slide deck and all that, you can really kind of go down that rabbit hole on a Sunday afternoon and kind of learn more about that. And then for block and block related talks, there were so many and each covering a different angle. I have a list in my Weekend Edition 38 that I would kind of where I said I would want to watch it and even if I&#8217;m not getting into the talk, I will keep a list of that for the reruns. But if I wanted also three of them is one is Michelle Hunt’s Building Experiences, Design systems, User experience and full site editing. And she really brings it home in talking about Atomic Design, which was a topic two years ago in San Diego or three years ago even, and then applying it to WordPress and themes and blocks and also creating a design system as well as guardrails for users. That&#8217;s her user experience piece that if you have too many options you confuse users and they don&#8217;t need them, but you can build guardrails around it and curate the experience quite well. </p>\n\n\n\n<p>Mary Ann Aschenbrenner is from a small agency and she talked about how she moved websites from classic theme to a block theme and what the steps were involved. And yeah, some decision making process there, really good. And then Block Composability the Past and the Future with Seth Rubenstein and Max Schmeling, and they talked about the remote data block coming out of WordPress VIP and they open sourced it, and that is how you can connect the Gutenberg editor with an outside data source like Google Spreadsheets or Airtable and bring that data in live. So when it changed the data on the other sites. Yeah, it&#8217;s updated the website and use block bindings and interactivity API to pull it all into a page and blocks that you can put on a page. So it&#8217;s really interesting what comes out of that this year in WordCamp US. So have you looked at the remote data block yet?</p>\n\n\n\n<p><em>Sarah Norris: </em>No, I haven&#8217;t, but that sounds amazing. It almost sounds like zapier but. But for. For the editor. Yeah, that sounds really cool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, that was the idea about it, that you don&#8217;t have to create blocks for that. You kind of use that one block. Yeah, that has a lot of tools in there and then you can pull them in. It&#8217;s really interesting. So yeah, but of course everyone is at a different stage in their blocks journey, and it&#8217;s difficult to recommend a talk without knowing more about the needs but so I will share in the notes the link to all the talks of WordCamp US. I think right now they have two or three pages already uploaded so you can kind of look at them but don&#8217;t forget it and let times go past. It might also be something to put on your list for Christmas vacation days or Thanksgiving days instead of other things maybe. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Community Contributions</h3>\n\n\n\n<p>So what&#8217;s community contributions? It seems there&#8217;s more new Momentum at the WordPress Developer Blog because apart from the What&#8217;s New for Developers by Justin Tadlock, there were four more articles published since we had our last Gutenberg Changelog recording, and two of them are by Justin Tadlock. </p>\n\n\n\n<p>One is a little controversial as a stated title, you don&#8217;t need Theme JSON for block theme styles. When you want to need or step away from using theme JSON for styling themes, this guide will walk you through the best practices of using style sheets instead. You will also learn from the article that Justin actually really likes theme JSON, but he wants to pick you up where you are and if you don&#8217;t don&#8217;t have a real good handle on it yet, you have alternatives and options. And the second one is in view of what&#8217;s coming to WordPress 6.9 is registering custom social icons for Gutenberg, and it&#8217;s a new filter hook that&#8217;s coming to the next release, and it&#8217;s learn how to use it to register your own services for social icons block. So his example is IMDb, that&#8217;s the movie database or Ko Fi, that&#8217;s buy me some coffee kind of donation place. I used it for my next edition of the Gutenberg Times theme where I want to have an archive page for my podcast, and I needed the icons for all the podcast directories where you can find the Gutenberg Changelog because only Spotify was on there, and there are so many others that are there, so. And Pocket Cast is already in there, but all the others are not. So I built them with that new tool for my new plugin. So it&#8217;s really interesting. So if you have other needs, you can do it yourself. You don&#8217;t need to wait for Core to put them in. </p>\n\n\n\n<p>And Troy Chaplin also he published a series on refactoring a multiblock plugin to build smarter register cleaner and scale easier. So if you have a multi block plugin, it&#8217;s kind of gives it a cleaner structure, support all block types and also a smarter registration and bundling of your assets. I think it&#8217;s a very good tutorial for the next stage of your plugins. And he also has a second post in the same realm is about implementing namespaces and coding standards in WordPress plugin development. This post got a lot of comments and suggestions from other people, co-developers and others. So it&#8217;s definitely worth looking into because namespacing, auto loading and linting for your multi block plugin is definitely something you want to find out or how to do this. So shout out for both authors for taking the time to put those tutorials together for other WordPress developers. And dear listeners, make sure you never miss another post of the developer block again. Subscribe to the blog. Anyway, I&#8217;m not asking you, I&#8217;m not putting on the spot when you&#8217;re gonna write for the developer blog. But yeah, think about it. We&#8217;re open to ideas.</p>\n\n\n\n<p><em>Sarah Norris: </em>I&#8217;ll have a think.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Say again?</p>\n\n\n\n<p><em>Sarah Norris:</em> I&#8217;ll have a think.</p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s Released &#8211; Gutenberg 21.4</h3>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, have a think. So, which brings us dear listeners to the Gutenberg releases in the last four weeks. We are starting with Gutenberg 21.4. Do you want to get us started, Sarah?</p>\n\n\n\n<p><em>Sarah Norris: </em>Yes. Yeah. Okay. Okay. What we&#8217;ve got first for 21.4. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p>So in enhancements we&#8217;ve got a new server side render hook.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. And I&#8217;ve put some question marks on it because I need you to explain it to me a bit.</p>\n\n\n\n<p><em>Sarah Norris: </em>I mean, I&#8217;m not sure I can do that. So I think this is a. It&#8217;s a really nice refactoring job. So we had. Well, we still do have some data fetching logic in a server side render function and this has been refactored into a hook called useserverside Render, and it basically gives consumers more control over the block content when they&#8217;re using the server side rendering technique. I think we did have this functionality before, but this makes it much easier and more flexible for consumers to absorb the block content.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>All right, so when you say consumers, you mean extenders who use it in their block plugin, right?</p>\n\n\n\n<p><em>Sarah Norris: </em>Yes, yeah, that&#8217;s right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. It&#8217;s not me as a consumer of Nutella or something.</p>\n\n\n\n<p><em>Sarah Norris: </em>Nutella Hook though, would be amazing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>That&#8217;s a new blog.</p>\n\n\n\n<p><em>Sarah Norris: </em>Use Nutella.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Use the Teleservice. No. Oh, what a mess. So we have quite a few things that are concerning the data views. It gets a real good polish now and some great features in there. So the first thing is that there is a control command plus click for multiselection in the table layout. When you have data views in a table. So you can click all the rows that you want to use for bulk edits or something like that, which is really cool. It&#8217;s also a feature that is in the old WP admin. The second one is the data form select box to have custom empty options. This is actually really cool because then you have a no selection and it doesn&#8217;t disrupt anything of the workflow. Yeah, I got this all my life of web development and forms that when you have a dropdown you need an empty one. So if it&#8217;s not a required field. So they can unselect things.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah, Very easily forgotten because how often do you actually build dropdowns as well? So every time you build one it&#8217;s good. Oh yeah, I need an empty option.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. It&#8217;s now built in to have a custom empty option if you want it. You want to do the next.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah. What&#8217;s the next one? So I&#8217;ve got support group by in the table layout. So this, this is adding support for the table to be grouped by field, isn&#8217;t it? So it means that when you&#8217;re viewing a table, it can be grouped into separate sections and each section will have a heading. Yeah. But I guess depending on the content, it makes it much easier to consume that content and then. Yeah, each section has a table row with a heading. Yeah, that helps separate it out. Nice and neat.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, it makes it a little bit easier to find all the stuff that you need. The next one is that it&#8217;s now use responsive images for the dataview grid layout. So if you&#8217;re on a tablet, the images are smaller so you get more things on the screen as well as the mobile. You can use that in mobile as well.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah, yeah. I didn&#8217;t know about this PR actually. It&#8217;s very, very cool because it&#8217;s. It allows you to to pass a maximum width to the images in the grid view. Because I think previously it was using the largest image or one of the largest image sizes. But that means like if there were a lot of images, this is saving like literal megabytes on every grid view. So that&#8217;s. It&#8217;s really, really cool. Good, Good pr. Good performance. PP.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, absolutely. Yeah.</p>\n\n\n\n<p><em>Sarah Norris: </em>Next one is allow data views empty state to be customized. Oh yeah. So this is if. So if you&#8217;re like loading a data views component, if there were no results previously, I think it just would render just a white screen basically, which is an empty data view component. But this allows you to pass in like a default empty state. So if you&#8217;re listing pages and no pages are part of the search results, then you can add something like a no pages found message. But it&#8217;ll be styled nicely and be centered and will look much better UX than a blank screen, basically.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Then nothing.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah, yeah, then nothing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. And I also like the. The last one is a data form is now a bootstrap validation for required and type checks on the input. And that&#8217;s right now for text input, email, integer and boolean field types. Boolean. Yeah, I never knows how to pronounce it. How do you pronounce it?</p>\n\n\n\n<p><em>Sarah Norris: </em>Boolean.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Boolean. Boolean. Boolean. Yeah. Other people say boolean. Anyway. Yeah, I really like that. So now you can have your data forms automatically kind of validated and at least for those types I think more is coming there as well. So yeah, if you use the data views for your plugins, you can actually have now good user input handling as well.</p>\n\n\n\n<p><em>Sarah Norris: </em>Next is the block library section and then we have the cover video block Add drag and drop support for poster uploads. So this is so for videos you can add a poster image for HTML videos. And this basically just allows drag and drop functionality. So we can drag these images into the poster section when you&#8217;re editing the cover video block basically makes it much easier to add a poster.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah. Drag and drop is always fun most of the time. Yeah. And it&#8217;s not only for the video block, but it&#8217;s also for the cover block that has that video that&#8217;s also then pulled in. If there is not enough bandwidth on the page to show a poster instead of the video, and only when you click on it, the video kind of plays. And then we have updates to the file block. Two of them. One is to use the mime type to determine if a file is a PDF and the other one is have the nature of Feature detection for PDF support. So that would also give the PDF support means have it embedded on the page as an option or also have thumbnails and all that kind of thing. So yeah, those are kind of great enhancements.</p>\n\n\n\n<p><em>Sarah Norris:</em> Next up is the block editor section. So we have the list add keyboard shortcuts to indent, outdate, outdent. So this adds a keyboard shortcut to the tooltips. Why can&#8217;t I say tooltips? All these words that you don&#8217;t have to say out loud. And then you&#8217;re forcing me to say. When you hover over the block toolbar for the list block, you&#8217;ll now get some helpful tool tips that tell you about the indent and tab keyboard shortcuts. Basically.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, yeah, it&#8217;s been a while that it actually is the tab to indent on the list block. But it wasn&#8217;t really that widely known because it took a while to get it in there and now you can. On a single list item you can use the tab to indent it. But now you also know it by hovering over the tooltips or getting some tooltips. When you hover over the block toolbar, there is the icon to indent and outdent. And now it also has the tooltip for use the tab dummy kind of thing. All right. Oh, the write mode is also has quite some updates in the last few Gutenberg releases. This one also only has one that it adds the shuffle style to the write mode toolbar on a container block. So if you have a block, if there is a style variations for that particular block, you can you get this little color drop to select those style variations that is actually coming out of the zoom out mode that was already in 6.8.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah, it&#8217;s very cool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>It&#8217;s totally cool.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah, it makes it really easy to. I know that&#8217;s the whole point of it, but it makes it very easy to switch between the styles. I think it&#8217;s something that we don&#8217;t really think about, especially when you&#8217;re building for the editor as well. But as soon as you see it in action, it&#8217;s just like, oh, this is unlocks loads of functionality just in one click. It&#8217;s very cool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Sarah Norris: </em>Next up is the component section. Got one in here as well. So this is the text control improve theming support. I think this is a little PR for making the border and placeholder colors themable for the text control component specifically. So it means that if you switch the theme, the border and the placeholder colors will also change as well as the other colors related to text control.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. And then there&#8217;s a block binding update on the date block. It now allows block binding, so yay. Now you can have the date block. There&#8217;s a date block or post date, for instance. Yeah, you can. Yeah, okay.</p>\n\n\n\n<p><em>Sarah Norris:</em> Exactly.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, you can. Or recording date. Yeah, or something like that. You can connect it to a block binding and make it all follow all the date things in WordPress like location and localized formatting and all that. Block bindings also gets a little bit more wider usage. Opens up for wider usage during 6.9. I have not yet put a whole good research in there, but I&#8217;ve done some testing and it works really, really well also to. To add it to an audio block and all that.</p>\n\n\n\n<p><em>Sarah Norris: </em>I can tell you one thing, although it will probably be for Gutenberg changelog 21.6 or 121, but I&#8217;ve been using block bindings. I&#8217;ve been using block bindings for the terms query block as well. And it was unbelievably easy to implement. Just like so much kudos to the people who&#8217;ve been working on block bindings. So I&#8217;ve used it to expose term data so we can absorb that in the new blocks for the terms. And it&#8217;s just. I don&#8217;t know, I&#8217;m just blown away by it really. It just makes so much sense. Makes everything so much more flexible.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, I use the block bindings too. I registered a separate source for the block bindings for my podcast archive page. Yeah. Because I wanted recording date and stuff, the podcast description and the logo as well as for every episode recording date and the download link just in there in the query loop. And it really worked. Yeah. The audio blog. I&#8217;m still debugging it because of course it&#8217;s all my fault. But it really works well and I&#8217;m so happy that I don&#8217;t have to write new blocks. And I can use a plugin that creates all those fields and has their own template, but the templates are not for block themes. So I can create my own template and add all those blocks bindings and put it into a plugin. So it&#8217;s really cool.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> So many more options opening up with block bindings.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah. What&#8217;s our next section now?</p>\n\n\n\n<h3 class=\"wp-block-heading\">Documentation</h3>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So I scroll down to the documentation section of the changelog and I just wanted to point out two things. One is that the Playground CLI is now preferred over the WP now when you use it on any of your projects for playground to have a local development. So it&#8217;s really cool if you&#8217;re developing a plugin, but not in the realm of a website, just on a separate folder. And then you can do playground CLI and then it opens up a WordPress instance right from that and knows it&#8217;s coming from a plugin. So it puts all the stuff from right in there into the playground. It installs it and activates it. And really fast development. Now that was previous was WP now and now it&#8217;s the Playground CLI and it&#8217;s documented. And the second one was the document guidelines on how to get new social icons into Core and have the link to the developer blog article by Justin Tadlock on how to do it yourself. What else? I think that I have the feeling we are now at the end of Gutenberg 21.4.</p>\n\n\n\n<p><em>Sarah Norris: </em></p>\n\n\n\n<p>Yes, success.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>And we are coming to Gutenberg 21.5. Do you want to start again?</p>\n\n\n\n<h3 class=\"wp-block-heading\">Gutenberg 21.5</h3>\n\n\n\n<p><em>Sarah Norris: </em>Yes, I can do. Yeah. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p>Starting at enhancements again. So first up is Data Form. Panel layout can open as dropdown or modal. So I think this is adding the. The modal panel type to the data form. And yeah, it basically means that a panel can be opened as a modal, making the data form more flexible.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yes, indeed. Yeah. And then the data views also get an additional enhancement as the option is now added to allow Infinite Scroll. On Data Views, you can decide between pagination or infinite scroll like we have in the media library. There&#8217;s an Infinite Scroll Infinite scroll kind of way. So yeah, it kind of opens up a lot more possibilities for Core or plugin developers to use that.</p>\n\n\n\n<p><em>Sarah Norris: </em>Next up is the block library section. First up is the query title, adding a post type label variation. So this adds a post type label to the query title block, which displays the singular name of the query post type.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So you know, when you look at it, oh, this is a recipe or this is a post or this is a page. When it kind of comes into the query loop, that&#8217;s definitely helpful, kind of prevents confusion. Definitely, yeah. And then of course we come to your accordion block.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Is it still experimental or has it been removed? Experimental.</p>\n\n\n\n<p><em>Sarah Norris: </em>It&#8217;s still experimental at the moment. So it&#8217;s only just been merged. Yeah. So we&#8217;re still testing. So the best thing about blocks being experimental is that we can make breaking changes, essentially. So I think it will be experimental until hopefully not the last minute. But, you know, the last minute being the last few weeks, probably before 6.9. But I think I&#8217;m feeling really confident about the block in general. So hopefully just after a few rounds of testing, maybe some tweaks being made. There&#8217;s already been a bunch of. A bunch of PRs opened for some small tweaks as well, which is really nice to see. So, yeah, hopefully it&#8217;ll be. It&#8217;ll be stabilized by 6.9. That&#8217;d be great.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. Yeah, I hope, I hope so very much though. Yeah. So the accordion block is. It&#8217;s implementing the HTML standard kind of way and then how it kind of works with blocks and you have a whole panel and then you have additional accordion. You have an accordions. It&#8217;s not a accordions block, but it&#8217;s a whole accordion. And then the accordion items, and then you have inner blocks that can house any content in the accordion item panels, right?</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah, that&#8217;s right. I think that&#8217;s where I got stuck as well, because I was like, this is multiple accordions. No, it&#8217;s one accordion and then the accordion is made up of multiple sections. Yeah. And then we have to have accordion content and then the accordion header and accordion panel. And within the panel you can add. I think it&#8217;s. I think it&#8217;s all blocks. I should know, shouldn&#8217;t I? But yeah, you can add any, any content within that panel. It just makes it a little bit more flexible than the details block. But I know that the accordion and the details block are very, very similar also at the moment. I think the details block will be surfaced if you search for accordion as well in the block editor. My plan, in my head at the moment, I probably need to write this down somewhere, is that once the accordion block, the new block is stabilized, then we could remove that accordion keyword from the details block. So both of those are two very obvious distinct blocks. </p>\n\n\n\n<p>Hopefully reduce some confusion. I think the main issue is with the details uses a summary element and I don&#8217;t think it&#8217;s semantically correct to add headings, but maybe a bunch of other stuff as well. Basically you can only really technically add text content, which doesn&#8217;t make it very flexible. And then the accordion block will have, at the moment only has an option for one type of icon. But the idea is that we&#8217;re going to add a lot more customization to the icon and making the header content itself more flexible. So yeah, hopefully this accordion block is much more flexible and just it&#8217;s kind of like an advanced block compared to the details. And I think, I think they can both exist fine. They&#8217;re both, they&#8217;re both HTML paradigms. They can both exist as blocks as well. And you know, more blocks. We need more blocks.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>More blocks, yes, definitely. Yeah, yeah. There were also some you you weren&#8217;t able in the details block, you were also not able to. To style the summary separately from the details. So if you put a border around you, it almost was on the same on the whole thing and not on the single. On the details. Yeah, or if you want to have a text styling on the summary, it also would bleed through the details. So yeah, but that&#8217;s wanted I think the details and summary that comes also from Markdown which so you could use it on GitHub and all that and there it really can have additional styling. So the accordion block is definitely for much richer styling and designs available. So are you thinking about handling transforms from details to accordions?</p>\n\n\n\n<p><em>Sarah Norris: </em>I haven&#8217;t thought of that yet, but that makes perfect sense because I imagine. Well, this is only a guess, but I imagine some people have. Users have been using the details block for probably what they would have wanted to use an accordion block for like if they wanted additional styling or for like more advanced FAQ sections and stuff like that. So yes, I imagine that will be a want transforming from a details block to the accordion. So yeah, I&#8217;ll add it to the list.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Write it down. All right, the next one is again it&#8217;s on the component section and there are a few in there. But I just wanted to point out the forms component that it also now supports an async validation. It means that you can also do server side validation and supports that with a. It&#8217;s a breaking change for this. It&#8217;s a private component so we shouldn&#8217;t even talk about that. Okay, so I didn&#8217;t see that but it&#8217;s. Yeah, it has an async story. So you can have an async validation. Yes, maybe sooner or later we get the public, but yeah, we&#8217;ll see.</p>\n\n\n\n<p><em>Sarah Norris: </em>For themes, there is additional support for providing the border radius presets. So yeah, if you&#8217;re familiar with other presets that you can have in theme JSON for styling, this is one for Border Radius allows you to set border radius presets and then they&#8217;re available in the different controls and it also uses the spacing sizes is like a modal for the way the presets use as well.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, if you are a themer, you definitely want to control the border radius and have users use just the certain numbers for it. Yeah, so if you use a smaller one then it&#8217;s always 15, and it&#8217;s not one is 12 and the other one is 17 or something like that. And then if you want a bigger radius for 25 or something like you don&#8217;t want to kind of that users put in all above 20, so to speak. So you have. You have a more consistent design on your site. And even if you kind of let the users use Border Radius for certain things for designing the next one is. Well, I think. Well, just want to say that the presets for Border Radius is definitely a big thing for theme developers. Yeah, I really get that. </p>\n\n\n\n<p>The next one is actually a really big thing for anybody who uses WordPress because the command palette comes to the admin dashboard. So you can actually be anywhere in your WordPress admin and then say open Site editor or add page or open style book or something like that. So you don&#8217;t have to find the menu. Click 15 times through the menu to find that particular piece there. Or say add CSS. I don&#8217;t know if that&#8217;s a command yet, but it definitely should be. So it&#8217;s a much easier way. And a lot of people might actually appreciate that they can do shortcuts pretty much to get to wherever they need to do. For the power users, it&#8217;s definitely an improvement. And I also can see there is. In the roadmap, there was also. That&#8217;s actually part of the roadmap that the command palette is available for the admin dashboard. But it&#8217;s also a foundational piece to get also AI using some of the commands and also to add. To have plugin use add commands to it that are not connected to the site editor. So plugin developers actually can streamline their processes as well for their users. Yeah, it&#8217;s nice. Yeah, it&#8217;s cool. Yeah. And I think now we have. Yeah, there&#8217;s a media for you. Do you want to go.</p>\n\n\n\n<p><em>Sarah Norris: </em>I can do for the block library, the median text block. So this is retain use featured image hook value during transformations. So I think this is a bug fix that fixes the media and text transformations to and from a cover block. Basically ensures that the use featured image value is retained during the transformation, which is very important. Don&#8217;t want to be resetting.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: It&#8217;s very important. And kind of adds. Removes an additional step people have to think about. So I already did this. Why do I have to do it again?</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah, exactly.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>After they migrated. We are at the end of Gutenberg 21.5. Yes, we did it, Sarah. </p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s in Active Development or Discussed</h3>\n\n\n\n<p>Now we have one section left in our podcast that&#8217;s the what&#8217;s in active development or discussed. And as I said in the intro we need more blocks. </p>\n\n\n\n<h3 class=\"wp-block-heading\">More Blocks</h3>\n\n\n\n<p>Matias Ventura, lead architect of Gutenberg and the whole revamping of the admin design, he posted an issue called New Blocks Editions for the Block Library. And there&#8217;s a lot of discussions that we would need there if we need them or not need them. But he comes from a point where he says, okay, for theme to have a good create a good experience for their users, it would be helpful to have these kinds of blocks or some, some of them or all of them in there. So there is no doubt that when a theme styles a block or uses it in patterns or in template parts or something like that, that it&#8217;s not going to be there. And that&#8217;s the experience now that if users use some other block, a theme that assumes there are blocks in there, they get a very confusing message there that so and so block wasn&#8217;t installed if they want to install it or something like that. And I think that&#8217;s for any new user of the WordPress could work inside editor are not very helpful. And so there are some suggested blocks there. Amongst them, the icons block, the playlist block, the slider, slider or carousel block, a stretchy text block, tabs block, accordion block. We have that Mega menus, math ML block, marquee block, table of content, time to read breadcrumbs and dialogue block. That&#8217;s kind of the list. I think it can go on and on and on, but I think it&#8217;s a good list there. I felt I&#8217;m a little bit okay, the marquee block. Didn&#8217;t we outphase that in the, in the 90s already? But I think it comes in handy when you have a news sticker across the top or something like that. MathML I think it&#8217;s a good block for educational sites, especially in math education. So I don&#8217;t know if that needs to be in the core or it can still be a plugin. Actually, Adam Silverstein created a plugin with the MathML block or the breadcrumbs block. Definitely important because that&#8217;s so important that we can help people find their way back. So a lot of people chime in. Aaron Jorban, Mike McAllister, Jeff Paul, Rich Tabor, Joe Dalston, Hendrik Larsen, Jeff Chandler yeah, a lot of people kind of join me in.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah, it&#8217;s great to see.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> What do you think?</p>\n\n\n\n<p><em>Sarah Norris:</em> It&#8217;s great to see so much interaction and conversation about new blocks. I think generally most people think that we should have more blocks, but I think the contention comes down to per block and which one should be added. And I think that&#8217;s fine. I think that it&#8217;s fine to have a discussion per block about that. But at the moment I think the lack of blocks just limits the flexibility and design opportunities in the editor. So that&#8217;s where maybe the decision process is a little bit easier for things like the accordion block, because it&#8217;s such an obvious design choice and option to have. Similar to the tabs block, probably the carousel block icons. But then there&#8217;s others like you mentioned about MathML maybe would have less users, but that doesn&#8217;t mean it shouldn&#8217;t be in core. It&#8217;s probably just a longer conversation or maybe it doesn&#8217;t make it into core. I&#8217;m not sure how I feel about the marquee block because I think it&#8217;d be really fun to have a marquee block. But I also understand that maybe, you know, not. Not everyone would want to use it. So maybe it doesn&#8217;t warrant going in. But then it&#8217;s fun, isn&#8217;t it?</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>So, yeah, there&#8217;s fun.</p>\n\n\n\n<p><em>Sarah Norris: </em>I don&#8217;t know.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>I have also seen that there&#8217;s a developers and user usability. People don&#8217;t like sliders and carousels.</p>\n\n\n\n<p><em>Sarah Norris: </em>Right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>But users or site owners like them very much. Yeah, exactly. So I talked with a few and at WordCamp US I talked with a few agency owners, said, yeah, that&#8217;s one of the blocks that we built ourselves because we need it on every single project that we are doing. Yeah. I can&#8217;t keep them kind of say, okay, there are alternatives when they want it. You know, our customers want them and so we build them.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And they&#8217;re pretty good to. They&#8217;re pretty navigational things, so interactive things. So if the site has no activity at all, this is actually getting you back.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah, exactly. And so many of these blocks listed in this issue that Matias opened, so many of them already have so much work. They already have a PR or. And they&#8217;ve probably just stalled the same question of how do we do this? Why should we do this? Do we need this block? So I think it&#8217;s just a case of going through each block and having that conversation. Because the accordion block, I only picked it up and finished it. Jeff had done. Already done so much good work on that and that&#8217;s why it was able to be landed so quickly and yeah. In a similar position with many of the others. So, yeah, I&#8217;m looking forward to that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. I think the table of contents has received quite a few iterations.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And just a few pieces missing that would make it a little bit more a little easier to handle, but we all kind of found our ways around it. But for that, we always have to install Gutenbergs to have the blocks there. And not everyone wants to use Gutenberg in production. Yeah, still. </p>\n\n\n\n<p>All right. Okay. So we are coming to the end of our Gutenberg Changelog podcast. As always, the show notes will be published on GutenbergTimes.com podcast and if you have questions, suggestions, or news that you want us to include, send them to <a href=\"http://changelogutenbergtimes.com\">changelogutenbergtimes.com</a> that&#8217;s <a href=\"http://changelogutenburgtimes.com\">changelogutenburgtimes.com</a> Thank you so much, Sarah, for being here, and thank you to all the listeners for listening. And if you want to review our podcast on several of those directories, like on Apple or on Spotify, please do, as it helps other people to discover it. So thank you for listening, and goodbye and see you at the next one.</p>\n\n\n\n<p><em>Sarah Norris:</em> Bye.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Bye.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 06 Sep 2025 12:03:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Gutenberg Changelog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Gutenberg Times: Accordion Block, Automattic Telex, Playground CLI and more—Weekend Edition #339\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=41640\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://gutenbergtimes.com/accordion-block-automattic-telex-playground-cli-and-more-weekend-edition-339/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:31681:\"<p>Hi,</p>\n\n\n\n<p>WordCamp US was a blast, although a four-day WordCamp felt weird. And after day four I was exhausted. I am almost done dealing with jet lag coming back from the nine-hour time difference. Interestingly enough, I saw way more talks than at previous WordCamps and I enjoyed learning new things. I also caught up with many long-time WordPress friends, most of whom I haven&#8217;t seen since the pandemic. My heart is full. <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f495.png\" style=\"height: 1em;\" /> </p>\n\n\n\n<p>More on WordCamp US below.</p>\n\n\n\n<p>I also caught up on a lot of stuff from the rest of the WordPress world, so this weekend edition is really packed.</p>\n\n\n\n<p>Wishing you a fantastic weekend. </p>\n\n\n\n<p>Yours, <img alt=\"💕\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f495.png\" style=\"height: 1em;\" /><br /><em>Birgit</em></p>\n\n\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\"></div>\n\n\n<h2 class=\"wp-block-heading\" id=\"wordcamp-us-2025\">WordCamp US 2025</h2>\n\n\n\n<p>For this week, I just link some recaps post and collect the WordPress TV links of the talks. More to come over the next weeks or so. </p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"recap-posts\">Recap posts</h3>\n\n\n\n<p>There are already quite a few recap posts about WordPress US published. Here is a selection:</p>\n\n\n\n<p><strong>Brett McSherry</strong> published a recap: <a href=\"https://wordpress.org/news/2025/08/portland-welcomes-wcus-2025/\"><strong>Portland Welcomes WordCamp US 2025: A Community Gathering</strong></a></p>\n\n\n\n<p>So did <strong>Rae Morey</strong> at The Repository <a href=\"https://www.therepository.email/wordcamp-us-2025-wraps-in-portland-ai-demos-student-programs-and-whats-next-for-wordpress\" rel=\"noreferrer noopener\" target=\"_blank\"><strong>WordCamp US 2025 Wraps in Portland: AI Demos, Student Programs, and What’s Next for WordPress</strong></a></p>\n\n\n\n<p><strong>Andy Fragen</strong> shared his photo album: <a href=\"https://thefragens.com/wcus-2025-in-pictures/\"><strong>WCUS 2025 in Pictures.</strong></a></p>\n\n\n\n<p>Communications Lead at DreamHost, <strong>Annette Irwin</strong>, reported extensively from each day in Portland, OR:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://www.dreamhost.com/news/announcements/inside-wordcamp-us-2025-contributor-day/\">Inside WordCamp US 2025 Contributor Day</a></li>\n\n\n\n<li><a href=\"https://www.dreamhost.com/news/announcements/wordcamp-us-2025-showcase-day-where-wordpress-comes-to-life/\">WordCamp US 2025: Showcase Day — Where WordPress Comes to Life</a></li>\n\n\n\n<li><a href=\"https://www.dreamhost.com/news/announcements/wordcamp-us-2025-day-3-recap-innovation-energy-and-community/\">WordCamp US 2025: Day 3 Recap— Innovation, Energy, and Community</a></li>\n\n\n\n<li><a href=\"https://www.dreamhost.com/news/announcements/wordcamp-us-2025-day-4-ai-insights-and-a-fond-farewell/\">WordCamp US 2025 Day 4: AI Insights and a Fond Farewell</a></li>\n</ul>\n\n\n\n<p><a href=\"https://wordpress.com/blog/2025/09/05/wordcamp-us-2025-recap/\"><strong>The 5 Best Things About WordCamp US 2025</strong></a> by Tess Needham, WordPress.com</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"recordings\">Recordings </h3>\n\n\n\n<p>The WordCamp US Livestream recordings are <a href=\"https://youtube.com/playlist?list=PL1pJFUVKQ7ERiUTP1Mt_yhRDOzESEoodI\">available on YouTube</a>. The AV team is in the process of <a href=\"https://wordpress.tv/event/wordcamp-us-2025/\">uploading single talks to WordPressTV</a></p>\n\n\n\n<p>Here is the list of talks I shared in <a href=\"https://gutenbergtimes.com/wordcamp-us-more-blocks-a-new-book-gutenberg-21-4-and-wordpress-6-9-weekend-edition-338/\">Weekend Edition 338</a>, now with the links to the recordings on WordPress TV</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Joeleen Kennedy</strong>: <a href=\"https://wordpress.tv/2025/09/03/modernizing-at-scale-how-fse-supports-wikimedias-evolving-ux/\">Modernizing at Scale: How FSE Supports Wikimedia’s Evolving UX</a></li>\n\n\n\n<li><strong>Josh Bryant</strong>: <a href=\"https://wordpress.tv/2025/09/03/reimagining-wordpress-editing-how-we-embedded-gutenberg-into-our-product-ecosystem/\">Reimagining WordPress Editing: How We Embedded Gutenberg Into Our Product Ecosystem</a></li>\n\n\n\n<li><strong>Seth Rubenstein</strong>: <a href=\"https://wordpress.tv/2025/09/03/block-composability-the-past-and-the-future/\">Block Composability: The Past and The Future</a></li>\n\n\n\n<li><strong>Stephanie Stelzer</strong>: <a href=\"https://wordpress.tv/2025/09/03/coding-the-magic-a-developers-journey-through-aloha/\">Coding the Magic: A Developer’s Journey Through Aloha</a></li>\n\n\n\n<li><strong>Mary Ann Aschenbrenner</strong>: <a href=\"https://wordpress.tv/2025/09/03/moving-a-website-from-classic-to-a-block-theme/\">Moving a Website from Classic to a Block Theme</a></li>\n\n\n\n<li><strong>Anton Plauch</strong>e: <a href=\"https://wordpress.tv/2025/09/03/building-resilient-interfaces-by-embracing-fluid-design/\">Building Resilient Interfaces by Embracing Fluid Design</a></li>\n\n\n\n<li><strong>Jemima Abu</strong>: <a href=\"https://wordpress.tv/2025/09/03/a-php-developers-guide-to-reactjs/\">A PHP Developer’s Guide to ReactJS</a></li>\n\n\n\n<li><strong>Michelle Schlup Hunt</strong>: <a href=\"https://wordpress.tv/2025/09/03/building-experiences-design-systems-user-experience-and-full-site-editing/\">Building Experiences: Design Systems, User Experience, and Full Site Editing</a></li>\n\n\n\n<li><strong>Tammie Lister</strong>: <a href=\"https://wordpress.tv/2025/09/03/the-system-is-the-strategy/\">The System is the Strategy</a><br /></li>\n</ul>\n\n\n\n<p>AI was a big topic at WCUS 2025 with about a dozen talks from various angles. My recommendations are: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>For developers, check out <strong>Adam Silverstein</strong>’s talk, <a href=\"https://wordpress.tv/2025/09/03/unlock-developer-superpowers-with-ai/\">Unlock Developer Superpowers with AI,</a> as he has tested quite a few tools and can give a great rundown about his approach. </li>\n\n\n\n<li>For non-developers, if you need an introduction on how to think about AI, watch <strong>John Maeda</strong>’s talk <a href=\"https://wordpress.tv/2025/09/03/cozy-ai-cooking-wordcamp-edition/\">Cozy AI Cooking: WordCamp Edition</a></li>\n\n\n\n<li>If you want to be amazed by what’s happening in other areas of science, I highly recommend <strong>Prof. Adam Gazzaley</strong>&#8216;s talk, <a href=\"https://wordpress.tv/2025/09/03/a-new-era-of-experiential-medicine-ai-and-the-brain/\">A New Era of Experiential Medicine – AI and the Brain</a> </li>\n</ul>\n\n\n\n<p>The <a href=\"https://wordpress.tv/event/wordcamp-us-2025/\">full list of talks is available on WordPress TV here.</a></p>\n\n\n\n<p>The recordings of the workshops are not yet available. I&#8217;ll share them in a future Weekend Edition. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"major-wordpress-events-in-2026\">Major WordPress events in 2026 </h2>\n\n\n\n<p>2026 is still many months away, but you can&#8217;t plan soon enough. Save the dates! </p>\n\n\n\n<figure class=\"wp-block-table is-style-stripes\"><table class=\"has-fixed-layout\"><thead><tr><th>Dates</th><th>Name of the Event</th><th>Location</th></tr></thead><tbody><tr><td>January 23-24, 2026</td><td><a href=\"https://nepal.wordcamp.org/2026/\">WordCamp Nepal</a></td><td>Butwal, Nepal</td></tr><tr><td>April 8-11, 2026</td><td><a href=\"https://pressconf.events/\">PressConf</a></td><td>Phoenix, Arizona, USA</td></tr><tr><td>April 9–11, 2026</td><td><a href=\"https://asia.wordcamp.org/2026/\">WordCamp Asia </a></td><td>Mumbai, India </td></tr><tr><td>April 23-24, 2026</td><td><a href=\"https://checkoutsummit.com/\">Checkout Summit</a></td><td>Palermo, Italy</td></tr><tr><td>June 4-6, 2026</td><td><a href=\"https://europe.wordcamp.org/2026/\">WordCamp Europe</a></td><td>Krakow, Poland</td></tr><tr><td>August 16-19, 2026</td><td>WordCamp US</td><td>Phoenix, Arizona, USA</td></tr></tbody></table></figure>\n\n\n\n<p>Many more WordCamps are in the early stages. You can check out the <a href=\"https://central.wordcamp.org/schedule/\">schedule on WordCamp.org</a> and also review the WordCamps planned for the rest of 2025. </p>\n\n\n\n<p>For the remainder of 2025, I just booked my flight to Gdansk to attend <a href=\"https://gdynia.wordcamp.org/2025/\"><strong>WordCamp Gdynia</strong></a>, September 26 &#8211; 28, the first bilingual WordCamp in Poland. And I am contemplating attending <a href=\"https://pisa.wordcamp.org/2025/\"><strong>WordCamp Pisa</strong></a> in November.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><strong>Anne McCarthy</strong> and I joined <strong>Nathan Wrigley</strong> on the <strong><a href=\"https://wpbuilds.com/2025/09/04/435-at-the-core-with-birgit-pauli-haack-and-anne-mccarthy-episode-4/\">4th episode of the &#8220;At the Core&#8221; podcast</a></strong> series of WPBuilds. We talked about the Admins design and AI building blocks, the Roadmap for 6.9, the command line for WPAdmin, and Speculative loading. It was a fun, fast-paced conversation.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://wpbuilds.com/2025/09/04/435-at-the-core-with-birgit-pauli-haack-and-anne-mccarthy-episode-4/\"><img alt=\"\" class=\"wp-image-41742\" height=\"343\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/09/WP-Builds-Podcast-Episode-435.webp?resize=652%2C343&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Aki Hamano</strong> released Gutenberg 21.5 and highlighted in his post <a href=\"https://make.wordpress.org/core/2025/08/28/whats-new-in-gutenberg-21-5/\">What’s new in Gutenberg 21.5? (27 August)</a> </p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2025/08/28/whats-new-in-gutenberg-21-5/#introducing-accordion-block\">Introducing Accordion block</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/08/28/whats-new-in-gutenberg-21-5/#command-palette-in-admin-dashboard\">Command Palette in admin dashboard</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2025/08/28/whats-new-in-gutenberg-21-5/#support-border-radius-presets\">Support border radius presets</a></li>\n</ol>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-41725\" height=\"368\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/09/accordion-block.png?resize=652%2C368&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p><img alt=\"🎙\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f399.png\" style=\"height: 1em;\" /> The latest episode is <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-119-wordpress-6-8-2-and-6-9-gutenberg-21-1-21-2-and-21-3-releases/\">Gutenberg Changelog 119—WordPress 6.8.2 and 6.9, Gutenberg 21.1, 21.2, and 21.3 Releases</a> with Tammie Lister. </p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><img alt=\"Tammie Lister and Birgit Pauli-Haack recording Gutenberg Changelog 119\" class=\"wp-image-40972\" height=\"184\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/07/Screenshot-2025-07-25-at-10.53.45.png?resize=652%2C184&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p class=\"has-small-font-size\"><em>If you are listening via Spotify, please leave a comment. If you listen via other podcast apps, please leave a review. It&#8217;ll help with the distribution.</em></p>\n</div></div>\n\n\n\n<p><strong>Sarah Norris </strong>and I recorded the next episode of the Gutenberg Changelog (#120) and we chatted about WordCamp US, Developer Blog updates, Gutenberg 21.4 and 21.5, and also the discussion on needing more blocks in the editor. <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-120-wordcamp-us-telex-gutenberg-21-4-and-21-5/\">The episode will land </a>over the weekend at your favorite podcast app.</p>\n\n\n\n<figure class=\"wp-block-image size-full is-style-no-vertical-margin\"><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-120-wordcamp-us-telex-gutenberg-21-4-and-21-5/\"><img alt=\"\" class=\"wp-image-41771\" height=\"207\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/09/Screenshot-2025-09-05-at-14.12.23-edited.png?resize=652%2C207&#038;ssl=1\" width=\"652\" /></a></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p>In her post on the WooCommerce Developer Blog, <strong>Stephanie Pi</strong> walks you through the <a href=\"https://developer.woocommerce.com/2025/09/01/woocommerce-10-2-pre-release-updates/\"><strong>updates coming to WooCommerce 10.2</strong></a>. Get ready for the Product Collection Carousel and Bloc, simplified templates, a faster Cart Block, improved taxonomy filters, and so much more. Beta 2 is scheduled for September 8th, and the final release drops on September 16th, 2025.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Product Carousel coming to WooCommerce 10.2 on September 16, 2025\" class=\"wp-image-41746\" height=\"317\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/09/Screenshot-2025-09-04-at-16.13.10.png?resize=652%2C317&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Wes Theron</strong> explains in this video <a href=\"https://www.youtube.com/watch?v=JO-bn9jwarQ\"><strong>how to work with WordPress templates</strong></a>. You&#8217;ll learn the difference between pages and templates in WordPress and how templates control the layout and structure of your pages—including headers, footers, and content—without affecting the content itself. Theron explored how editing templates impacts all pages using them, and showed practical examples using the Pages Template, Single Posts Template, All Archives Template, 404 Template, and your homepage.</p>\n\n\n<div class=\"wp-block-newsletterglue-showhide ng-block\" width=\"100%\">\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ajit Bohra</strong>, Lubus, <a href=\"https://x.com/ajitbohra/status/1962503463046365553\">announced</a> that their open-source <strong><a href=\"https://wordpress.org/plugins/blablablocks-tabs-block/\">Tabs Block</a></strong> is now available in the WordPress repository. Users can create horizontal or vertical tabs directly inside the WordPress Block Editor. Documentation can be found <a href=\"https://github.com/lubusIN/blablablocks-tabs-block/wiki\">on GitHub Wiki</a></p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Tabs Block screenshot by Lubus.in\" class=\"wp-image-41722\" height=\"343\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/09/Tabs-Block-LubusIN.png?resize=652%2C343&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Kevin Batdorf </strong>published the <a href=\"https://wordpress.org/plugins/fit-to-width/\"><strong>Fit To Width block</strong></a> in the WordPress repository. The block is used for displaying each line of text at full width, no matter the length of the text.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"screenshot of an example of the Fit-to-Width block by Kevin Batdorf\" class=\"wp-image-41729\" height=\"458\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/09/screenshot-1.jpg?resize=652%2C458&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ryan Welcher</strong> released v4.3.0v of his <a href=\"https://wordpress.org/plugins/advanced-query-loop/\"><strong>Advanced Query Loop block</strong></a> in the WordPress repository. The update introduces a new post exclusion tool, a completely overhauled Post Meta Queries UI, and a new option for Meta Type.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p><strong>Justin Tadlock</strong> posted his take on the overall question: <strong><a href=\"https://gutenbergtimes.com/why-wordpress-core-needs-more-blocks/\">Why WordPress Core needs more blocks</a>.</strong> He used to support keeping WordPress lean, but block themes changed everything. Now theme builders have way fewer tools compared to before—you can&#8217;t just include breadcrumbs, accordions, or icons without finding specific blocks for them. When users don&#8217;t have the right blocks installed, they get ugly error messages. He wants WordPress to include more core blocks like tabs, icons, and accordions so theme creators can actually build what they envision without hitting brick walls. What do you think? <a href=\"https://gutenbergtimes.com/why-wordpress-core-needs-more-blocks/#comments\">Leave a comment</a> on Tadlock&#8217;s post or on the GitHub issue: <a href=\"https://github.com/WordPress/gutenberg/issues/71026\">New Block additions for the Block Library</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In January, <a href=\"https://wordpress.tv/speakers/arun-r-shenoy/\"><strong>Arun R Shenoy</strong></a> held a talk at WordCamp Kolhapur with the title <strong><a href=\"https://wordpress.tv/2025/08/19/crafting-attractive-block-themes-using-the-block-editor-alone/\">Crafting Attractive Block Themes Using the Block Editor Alone</a></strong>. The recording is now online on WordPressTV. Shenoy explored &#8220;minimalist design and the capabilities of the Block Editor. No coding or complex tools—just the editor and your creative vision.&#8221; He explained the basics for those who haven&#8217;t used the Site Editor yet and want to learn more. The <a href=\"https://kolhapur.wordcamp.org/2025/files/2024/12/WordCamp-Kolhapur-2025-Arun-R-Shenoy.pdf\">slidedeck</a> is also available online.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"Screenshot of Arun Shenoy\'s Talk at WordCamp Kolhapur\" class=\"wp-image-41734\" height=\"361\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/09/Screenshot-2025-09-04-at-14.02.52.png?resize=652%2C361&#038;ssl=1\" width=\"652\" /></figure>\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #f9f9e5; border-radius: 22px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f9f9e5;\">\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" rel=\"noreferrer noopener\" target=\"_blank\">&#8220;Keeping up with Gutenberg &#8211; Index 2025&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong> | <strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong> | <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2024/\"><strong>2024</strong></a></p>\n</section>\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p>The head of engineering at The Code Company, <strong><a href=\"https://x.com/zachickson\">Zac Hickson</a></strong> took a look at the question: <a href=\"https://thecode.co/wordpress-interactivity-api-enterprise-ready/\"><strong>Is The WordPress Interactivity API Enterprise-Ready?</strong></a> After a year of testing, they found it’s good to go since WordPress 6.5, making things easier by cutting down technical debt and boosting performance while sticking to the WordPress ecosystem. It handles standard interactive bits pretty well, but you’ll want to plan carefully for those trickier apps. It’s perfect for teams that live and breathe WordPress and want a simpler front-end setup. </p>\n\n\n\n<p>The article takes a look at the WordPress Interactivity API by testing it out in real-life client projects. It dives into how ready it is technically, compares its performance against React, Vue, Alpine.js, and jQuery, and shares some cool case studies, like multi-site subscription systems and interactive camera demos. Plus, it gives some tips on how to implement it and some advice on when to pick this API over the others. The whole analysis is all about figuring out how doable this is for organizations that are all about WordPress.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Author <strong>Paulo Carvajal</strong>&#8216;s new guide, <a href=\"https://wp-block-editor.com/mastering-complex-attributes-in-wordpress-blocks-handling-objects-arrays-and-nested-data/\"><strong>Mastering Complex Attributes in WordPress Blocks: Handling Objects, Arrays, and Nested Data</strong></a>, teaches developers how to work with complex data in block attributes beyond simple text and toggles. It covers arrays for repeatable content like galleries, objects for grouped settings, and nested data structures. The tutorial shows code examples for managing state properly, validating data, and handling performance issues. It explains how to create sophisticated blocks like testimonial sliders while keeping the editing experience user-friendly and avoiding common pitfalls with state management.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"wordpress-developer-blog\">WordPress Developer Blog</h3>\n\n\n\n<p><strong>Troy Chaplin</strong> continues sharing his experience, his workflow and plugin setup on the <em>WordPress Developer Blog</em> with two articles: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://developer.wordpress.org/news/2025/08/refactoring-the-multi-block-plugin-build-smarter-register-cleaner-scale-easier/\"><strong>Refactoring the Multi-Block Plugin: Build Smarter, Register Cleaner, Scale Easier</strong></a><br />Refactor your multi-block plugin with a cleaner structure, support for all block types, and smarter registration, bundling, and asset handling.</li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2025/09/implementing-namespaces-and-coding-standards-in-wordpress-plugin-development/\"><strong>Implementing Namespaces and Coding Standards in WordPress Plugin Development</strong></a><br />Add namespacing, autoloading, and linting to your multi-block plugin for clean, scalable WordPress development.</li>\n</ul>\n\n\n\n<p><strong>Don&#8217;t miss a new article ever again. <a href=\"https://developer.wordpress.org/news/subscribe/\">Subscribe to the WordPress Developer Blog!</a></strong></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Justin Tadlock</strong> and <strong>Abar Thakor</strong> discussed <a href=\"https://openchannels.fm/how-to-start-contributing-to-the-wordpress-developer-blog-even-if-youre-new/\"><strong>How to Start Contributing to the WordPress Developer Blog (Even If You’re New)</strong></a> in an episode on the OpenChannels network. Don&#8217;t wait to be an expert before contributing to the WordPress Developer Blog. Even beginners can share small solutions, guides, or case studies they&#8217;ve built. Start by browsing existing posts for inspiration, then share your idea on the <a href=\"https://github.com/WordPress/developer-blog-content/discussions/categories/topic-ideas\">GitHub discussion panel.</a> The editorial team is super helpful and will work with you to polish your writing. Your beginner perspective might be exactly what other new developers need to see.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"artificial-intelligence-ai-and-wordpress\">Artificial intelligence (AI) and WordPress</h2>\n\n\n\n<p>A new AI Tool, <a href=\"https://telex.automattic.ai/projects/new\"><strong>Automattic Telex</strong></a>, makes it easier to build Blocks for the block editor. <strong>Matt Mullenweg</strong> announced it in his keynote. </p>\n\n\n\n<p><strong>Rae Morey</strong>, The Repository, reports on the reception around the Interwebs. <a href=\"https://www.therepository.email/automattic-debuts-telex-bringing-ai-powered-vibe-coding-to-gutenberg-blocks\">Automattic Debuts Telex, Bringing AI-Powered “Vibe Coding” to Gutenberg Blocks</a>. </p>\n\n\n\n<p><strong>Sarah Perez</strong> at <em>TechCrunch</em> also picked up the story: <a href=\"https://techcrunch.com/2025/09/02/wordpress-shows-off-telex-its-experimental-ai-development-tool/\">WordPress shows off Telex, its experimental AI development tool</a></p>\n\n\n\n<p><a href=\"https://telex.automattic.ai/projects/new\">Don&#8217;t be shy, give it a whirl,</a> share your feedback, and leave a comment. <br /></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Grzegorz Ziółkowski</strong> <a href=\"https://github.com/WordPress/abilities-api/releases/tag/v0.1.0\">released</a> the <strong>Composer package <code>wordpress/abilities-api</code>.</strong> WordPress developers can now test the Abilities API before it officially launches in WordPress 6.9. The Abilities API creates a common language for all WordPress components to define their functionalities, making it easier for both humans and machines to understand. By using this shared language, plugins, and themes can help AI solutions find, interpret, and use capabilities across the WordPress ecosystem. You can learn more about this new feature on the <a href=\"https://make.wordpress.org/ai/2025/07/17/abilities-api/\">Make blog of the AI Team</a>. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"what-s-new-for-wordpress-playground\">What&#8217;s new for WordPress Playground</h2>\n\n\n\n<p>In this episode on the OpenChannels <a href=\"https://openchannels.fm/learn-how-wordpress-playground-revolutionizes-local-development-testing-and-learning/\">Learn How WordPress Playground Revolutionizes Local Development Testing and Learning</a> <strong>Abha Thakor</strong> and <strong>Fellyph Cintra</strong> discuss WordPress Playground, its features, accessibility, and impact on developers and users. One new feature is the Playground Command line interface (CLI). You can use the playground CLI to spin up a WordPress instance directly from your plugin or theme folder by using with the  <code>--auto-mount</code> flag with the command. This gives you a complete development environment in seconds.</p>\n\n\n\n<p class=\"has-light-background-background-color has-background\"><code>npx @wp-playground/cli server --auto-mount</code></p>\n\n\n\n<p>Recent updates also added a demo content for the plan Playground site, when accessing <a href=\"https://playground.wordpress.net\">playground.wordpress.net</a></p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-41731\" height=\"363\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/09/Screenshot-2025-09-04-at-13.37.00.png?resize=652%2C363&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-callout undefined not-color-set\" style=\"border-color: #eeeeee; border-radius: 26px; border-style: solid; border-width: 0; padding-top: 20px; padding-bottom: 20px; padding-left: 20px; padding-right: 20px; text-align: left; margin-left: 0; margin-right: 0; margin-top: 0px; margin-bottom: 0px; background-color: #f3efe9;\">\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n</section>\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n<section class=\"wp-block-newsletterglue-group\" style=\"padding-top: 10px; padding-bottom: 10px; padding-left: 20px; padding-right: 20px; margin-top: 0px; margin-bottom: 0px;\">\n<p>Featured Image: Photo by Peter Nguyen on Unsplash</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form action=\"https://gutenbergtimes.com/feed/\" autocomplete=\"on\" class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\" style=\"margin-bottom: 25px;\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input autocomplete=\"email\" class=\"ngl-form-input-text\" id=\"ngl_email\" name=\"ngl_email\" required=\"required\" style=\"border-radius: 21px;\" type=\"email\" /></div></div><button class=\"ngl-form-button\" style=\"background-color: #005075; border-color: #005075; border-width: 1px; border-style: solid; color: #ffffff; border-radius: 21px;\" type=\"submit\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"><svg fill=\"none\" height=\"24\" stroke=\"#fff\" stroke-width=\"2\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><polyline points=\"20 6 9 17 4 12\"></polyline></svg></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input id=\"ngl_list_id\" name=\"ngl_list_id\" type=\"hidden\" value=\"26f81bd8ae\" /><input id=\"ngl_double_optin\" name=\"ngl_double_optin\" type=\"hidden\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n</section>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 06 Sep 2025 04:23:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Matt: Happy Birthday Anil\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=149659\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://ma.tt/2025/09/anil-50/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1031:\"<p>If my calendar is correct, one of the OG bloggers <a href=\"https://www.anildash.com/\">Anil Dash</a> is turning 50 today! His blog, which I <span style=\"margin: 0px; padding: 0px;\">believe has been active since 1999, inspired me with how he</span> effortlessly transitioned between his top-tier fandom of Prince and his thoughtful commentary on the nuances and second-order effects of what we were doing with blogging, micro-blogging, web standards, interoperability, and much more. His writing is incisive and insightful. I see a core flame of empowering independents throughout his career that very much aligns with the philosophies I aspire to. Please follow him if you don&#8217;t already, and <strong>happy birthday Anil</strong>! It appears that I have linked to him 15 times on my blog before this post, and he has commented 17+ times, the first in 2005, so we have some history! Since I started drafting this he <a href=\"https://dashes.com/2025/09/05/five-for-fifty/\">published his Five for Fifty birthday post</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 05 Sep 2025 18:46:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"Open Channels FM: Expanding WordPress Capabilities with Angie and the Power of Multi-Agentic AI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=109343\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://openchannels.fm/expanding-wordpress-capabilities-with-angie-and-the-power-of-multi-agentic-ai/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:339:\"In this episode of the Dev Pulse, Expand the Stack series, host Zach Stepek broadcasts straight from the show floor at WordCamp US 2025, where he dives into the latest innovations shaking up the WordPress community. Zach catches up with Shilo Eish Yemini and Miriam Schwab from the Elementor team in their unmistakably pink booth [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 05 Sep 2025 08:22:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Matt: Simon Says\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=149349\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://ma.tt/2025/09/simon-says/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:237:\"<p>Simon Willison <a href=\"https://simonwillison.net/2025/Sep/4/highlighted-tools/\">has vibe-coded 124 useful tools</a>. Also check out <a href=\"https://simonwillison.net/2025/Aug/9/bay-area-ai/\">his Lethal Trifecta presentation</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 05 Sep 2025 01:31:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"Open Channels FM: Bridging WordPress and the Cloud Industry at CloudFest USA in Miami\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=108596\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://openchannels.fm/bridging-wordpress-and-the-cloud-industry-at-cloudfest-usa-in-miami/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:212:\"In this episode, Adam Weeks and Jonathan Wold discuss CloudFest USA, connecting WordPress and cloud industries. Wold highlights networking opportunities, his upcoming chat with Mary Hubbard, and event uniqueness.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 04 Sep 2025 13:15:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"Open Channels FM: The Power of Teaching as a Beginner: How Fresh Learners Make Great Instructors\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=105423\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://openchannels.fm/the-power-of-teaching-as-a-beginner-how-fresh-learners-make-great-instructors/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:324:\"When we picture great teachers, many of us imagine experts with decades of experience. But what if some of the most impactful educators are those who just learned the ropes themselves? In a recent episode of Open Channels FM, guest Nyasha Green and host Carl Alexander dove deep into this idea and what they shared [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 04 Sep 2025 10:28:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Matt: God &amp;amp; Devil Debate HI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=149303\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://ma.tt/2025/09/en-passant/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1358:\"<p>There are many levels to the <a href=\"https://www.astralcodexten.com/p/what-is-man-that-thou-art-mindful\">excellent Scott Alexander satire of God, Iblis (Islamic word for devil), and Dwarkesh Patel, one of the best new podcasters of this era</a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>There are people who have gone their whole lives without realizing that Twinkle Twinkle Little Star, Baa Baa Black Sheep, and the ABC Song are all the same tune [&#8230;]</p>\n\n\n\n<p>If they’re used to stories about surgeons getting completed with the string “man”, then that’s the direction their thoughts will always go… Also, how come God can’t make humans speak normally? Everything they say is full of these um dashes!</p>\n</blockquote>\n\n\n\n<p>Which leads to a hat tip to <a href=\"https://briangardner.com/\">Brian Gardner</a> on the incredible <a href=\"https://www.mcsweeneys.net/articles/the-em-dash-responds-to-the-ai-allegations\">McSweeney&#8217;s Em dash responding to the the AI allegations</a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>So next time you read something and think, “AI wrote this—it has a lot of em dashes,” ask yourself: Is it AI? Or is it just a poet trying to give you vertigo in four lines or fewer?<br /></p>\n</blockquote>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Sep 2025 23:04:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:17:\"\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"HeroPress: HeroPress at WordCamp US 2025!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://heropress.com/?p=8186\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"https://heropress.com/heropress-at-wordcamp-us-2025/#utm_source=rss&utm_medium=rss&utm_campaign=heropress-at-wordcamp-us-2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10885:\"<img alt=\"A stage with giant letters spelling #WCUS on it.\" class=\"attachment-large size-large wp-post-image\" height=\"512\" src=\"https://heropress.com/wp-content/uploads/2025/09/IMG_6810.webp\" width=\"1024\" /><p>I wasn&#8217;t sure I was going to make it to WordCamp US this year, but at almost the last minute, <a href=\"https://wordpress.com\">WordPress.com</a> helped me out with travel and accommodations! <a href=\"https://heropress.com/feed/#support\">More on that below</a>.</p>\n\n\n\n<h1 class=\"kt-adv-heading8186_232186-5e wp-block-kadence-advancedheading\">Contributor Day</h1>\n\n\n\n<p>The first day was contributor day and I was a table lead. I think we had more people this year than any other year before. I started the day showing 4 or 5 people how to become contributors, and they each uploaded 20 photos or so.  All told we moderated about 160 photos during the day, and pushed the total over 26,000. I also made some great new friends!</p>\n\n\n\n<h2 class=\"kt-adv-heading8186_fc24a0-77 wp-block-kadence-advancedheading\">Photography</h2>\n\n\n\n<p>For the first time ever I was on the WordCamp Photography team. I feel like it&#8217;s a great honor because don&#8217;t really think of myself as a photographer, and I don&#8217;t even own a &#8220;real&#8221; camera, I just use my iPhone.  I do have some lenses from Moment.io which are cool, but they&#8217;re not a patch on some of the big crazy lenses I saw around.  I took several hundred pictures over the week, here are just a few:</p>\n\n\n\n<div class=\"wp-block-jetpack-tiled-gallery aligncenter is-style-rectangular\"><div class=\"\"><div class=\"tiled-gallery__gallery\"><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\"><figure class=\"tiled-gallery__item\"><img alt=\"\" src=\"https://i0.wp.com/heropress.com/wp-content/uploads/3025/09/IMG_6793-1024x576.webp?ssl=1\" /></figure></div><div class=\"tiled-gallery__col\"><figure class=\"tiled-gallery__item\"><img alt=\"\" src=\"https://i0.wp.com/heropress.com/wp-content/uploads/3025/09/IMG_6784-1024x433.webp?ssl=1\" /></figure></div></div><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\"><figure class=\"tiled-gallery__item\"><img alt=\"\" src=\"https://i0.wp.com/heropress.com/wp-content/uploads/3025/09/IMG_6794-1024x576.webp?ssl=1\" /></figure></div><div class=\"tiled-gallery__col\"><figure class=\"tiled-gallery__item\"><img alt=\"\" src=\"https://i0.wp.com/heropress.com/wp-content/uploads/3025/09/IMG_6825-1024x433.webp?ssl=1\" /></figure></div></div><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\"><figure class=\"tiled-gallery__item\"><img alt=\"\" src=\"https://i0.wp.com/heropress.com/wp-content/uploads/3025/09/IMG_6884-1024x576.webp?ssl=1\" /></figure></div><div class=\"tiled-gallery__col\"><figure class=\"tiled-gallery__item\"><img alt=\"\" src=\"https://i0.wp.com/heropress.com/wp-content/uploads/3025/09/IMG_6887-1024x576.webp?ssl=1\" /></figure></div></div><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\"><figure class=\"tiled-gallery__item\"><img alt=\"\" src=\"https://i0.wp.com/heropress.com/wp-content/uploads/3025/09/IMG_6947-1024x433.webp?ssl=1\" /></figure></div></div><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\"><figure class=\"tiled-gallery__item\"><img alt=\"\" src=\"https://i0.wp.com/heropress.com/wp-content/uploads/3025/09/IMG_7013-1024x576.webp?ssl=1\" /></figure><figure class=\"tiled-gallery__item\"><img alt=\"\" src=\"https://i0.wp.com/heropress.com/wp-content/uploads/3025/09/IMG_7015-1024x576.webp?ssl=1\" /></figure><figure class=\"tiled-gallery__item\"><img alt=\"\" src=\"https://i0.wp.com/heropress.com/wp-content/uploads/3025/09/IMG_7016-1024x576.webp?ssl=1\" /></figure></div><div class=\"tiled-gallery__col\"><figure class=\"tiled-gallery__item\"><img alt=\"\" src=\"https://i0.wp.com/heropress.com/wp-content/uploads/3025/09/IMG_7057-576x1024.webp?ssl=1\" /></figure></div></div></div></div></div>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"kt-adv-heading8186_e06675-2d wp-block-kadence-advancedheading\">The Mural</h2>\n\n\n\n<p>In addition to the regular photos, I got a series of <a href=\"https://www.jaxko.com/\">Jax Ko</a> making a WordCamp mural. They painted for 2 straight days, and I took a photo about every 2 hours.  Here&#8217;s the progression in slideshow format:</p>\n\n\n\n<div class=\"wp-block-jetpack-slideshow aligncenter\"><div class=\"wp-block-jetpack-slideshow_container swiper\"><ul class=\"wp-block-jetpack-slideshow_swiper-wrapper swiper-wrapper\"><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-8223\" height=\"576\" src=\"https://heropress.com/wp-content/uploads/3025/09/IMG_6997-1024x576.webp\" width=\"1024\" /></figure></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-8224\" height=\"576\" src=\"https://heropress.com/wp-content/uploads/3025/09/IMG_6998-1024x576.webp\" width=\"1024\" /></figure></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-8225\" height=\"576\" src=\"https://heropress.com/wp-content/uploads/3025/09/IMG_7007-1024x576.webp\" width=\"1024\" /></figure></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-8226\" height=\"576\" src=\"https://heropress.com/wp-content/uploads/3025/09/IMG_7008-1024x576.webp\" width=\"1024\" /></figure></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-8227\" height=\"576\" src=\"https://heropress.com/wp-content/uploads/3025/09/IMG_7028-1024x576.webp\" width=\"1024\" /></figure></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-8228\" height=\"576\" src=\"https://heropress.com/wp-content/uploads/3025/09/IMG_7053-1024x576.webp\" width=\"1024\" /></figure></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-8229\" height=\"576\" src=\"https://heropress.com/wp-content/uploads/3025/09/IMG_7099-1024x576.webp\" width=\"1024\" /></figure></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-8230\" height=\"576\" src=\"https://heropress.com/wp-content/uploads/3025/09/IMG_7113-1024x576.webp\" width=\"1024\" /></figure></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-8231\" height=\"576\" src=\"https://heropress.com/wp-content/uploads/3025/09/IMG_7116-1024x576.webp\" width=\"1024\" /></figure></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-8232\" height=\"576\" src=\"https://heropress.com/wp-content/uploads/3025/09/IMG_7123-1024x576.webp\" width=\"1024\" /></figure></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-8233\" height=\"576\" src=\"https://heropress.com/wp-content/uploads/3025/09/IMG_7136-1024x576.webp\" width=\"1024\" /></figure></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-8234\" height=\"576\" src=\"https://heropress.com/wp-content/uploads/3025/09/IMG_7158-1024x576.webp\" width=\"1024\" /></figure></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-8235\" height=\"576\" src=\"https://heropress.com/wp-content/uploads/3025/09/IMG_7181-1024x576.webp\" width=\"1024\" /></figure></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-8236\" height=\"576\" src=\"https://heropress.com/wp-content/uploads/3025/09/IMG_7207-1024x576.webp\" width=\"1024\" /></figure></li></ul><a class=\"wp-block-jetpack-slideshow_button-prev swiper-button-prev swiper-button-white\"></a><a class=\"wp-block-jetpack-slideshow_button-next swiper-button-next swiper-button-white\"></a><a class=\"wp-block-jetpack-slideshow_button-pause\"></a><div class=\"wp-block-jetpack-slideshow_pagination swiper-pagination swiper-pagination-white\"></div></div></div>\n\n\n\n<h2 class=\"kt-adv-heading8186_977d34-52 wp-block-kadence-advancedheading\" id=\"support\">How I Got There</h2>\n\n\n\n<figure class=\"wp-block-kadence-image kb-image8186_46dcfe-55 size-large\"><img alt=\"\" class=\"kb-img wp-image-8202\" height=\"576\" src=\"https://heropress.com/wp-content/uploads/3025/09/IMG_7190-1024x576.webp\" width=\"1024\" /></figure>\n\n\n\n<p>As I mentioned at the top, WordPress.com was my sponsor to get to WordCamp US this year. I really wanted to attend, I&#8217;ve never missed one! They very generously offered to help me get there and cover my hotel. More than that though, folks from .com at WordCamp sought me out and told me how glad they were that I was there.  It was a very welcoming gesture.</p>\n\n\n\n<p>If you haven&#8217;t looked at WordPress.com for hosting in a while, you should check it out. There have been some substantial changes in the last few years, there are some great new features.</p>\n\n\n\n<div class=\"wp-block-kadence-image kb-image8186_9641eb-32\"><figure class=\"alignright size-large\"><a class=\"kb-advanced-image-link\" href=\"https://developer.wordpress.com/studio/\"><img alt=\"WordPress.com Studio\" class=\"kb-img wp-image-8243\" height=\"649\" src=\"https://heropress.com/wp-content/uploads/3025/09/wp_studio-1024x649.webp\" width=\"1024\" /></a></figure></div>\n\n\n\n<p>While many people may have thought of <a href=\"http://wordpress.com/\" rel=\"noreferrer noopener\" target=\"_blank\">WordPress.com</a> as a “free blog” platform only, <a href=\"http://wordpress.com/\" rel=\"noreferrer noopener\" target=\"_blank\">WordPress.com</a> has been a full-featured host for years. At the business and commerce plan level the plugin library is available for both free and paid plugins, which is great, and for more advanced users and developers they offer features like <a href=\"https://wordpress.com/hosting/#extensibility\">staging servers, SSH access, WP-CLI, github deployments</a>, and a <a href=\"https://developer.wordpress.com/studio/\">local development environment</a>. That local dev environment allows you to copy sites from production to local and then push back to either staging or production. This lets you to work on your site without disrupting your visitors’ experiences.</p>\n\n\n\n<p>Even if you don&#8217;t have hosting needs at the moment, you can still get involved! They have a great affiliate program, <a href=\"https://wordpress.com/affiliates/\">check it out here</a>. </p>\n<p>The post <a href=\"https://heropress.com/heropress-at-wordcamp-us-2025/\">HeroPress at WordCamp US 2025!</a> appeared first on <a href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Sep 2025 18:52:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Open Channels FM: Open Channels FM Joins as a Media Partner for CloudFest USA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=106125\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://openchannels.fm/open-channels-fm-joins-as-a-media-partner-for-cloudfest-usa/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:167:\"Open Channels FM partners with CloudFest USA in Miami on November 5-6, highlighting keynotes, panels, and networking opportunities for cloud and hosting professionals.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Sep 2025 16:36:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:140:\"WPTavern: #183 – Destiny Kanno, Isotta Peira and Anand Upadhyay on how WordPress is shaping the future of education for students worldwide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=199013\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:153:\"https://wptavern.com/podcast/183-destiny-kanno-isotta-peira-and-anand-upadhyay-on-how-wordpress-is-shaping-the-future-of-education-for-students-worldwide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:75449:\"<details>Transcript<div>\n<p>[00:00:19] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress, the people, the events, the plugins, the blocks, the themes, and in this case, how WordPress is shaping the future of education for students worldwide.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Destiny Kanno, Isotta Peira, and Anand Upadhyay.</p>\n\n\n\n<p>Destiny is the Head of Community Education at Automattic. Isotta is the leader of the WordPress Credits Initiative for students, and Anand is the founder of WordPress Campus Connect.</p>\n\n\n\n<p>This episode is all about how WordPress is not only powering websites, but also empowering the next generation of learners and creators. You&#8217;ll hear about the growing movement of education focused WordPress events happening worldwide, from hands-on workshops on university campuses in India, to student clubs designed to keep the momentum going after introductory events.</p>\n\n\n\n<p>Anand shares how WP Campus Connect is bringing WordPress directly to students, reducing barriers to entry, and helping bridge the gap between academic learning and real world tech skills. We also explore the challenges of organizing these events, from convincing institutions of the value of open source, to fostering genuine community involvement among both students and educators.</p>\n\n\n\n<p>Isotta then introduces us to the WordPress Credits Program, an initiative that lets students turn their contributions to the WordPress ecosystem into recognized academic credits at universities like, Pisa in Italy. It&#8217;s a win-win. Students gain practical resume worthy experience, while educational institutions get a transferable, skills focused, program that prepares learners for the jobs of the future.</p>\n\n\n\n<p>Whether you&#8217;re an educator, a WordPress enthusiast, or just someone who cares about open source and community, this episode is packed with actionable insights. The guests share how flexible and resilient these education initiatives are, how you can get involved, and why engaging the next generation is not just important, but essential for the continued growth and sustainability of the WordPress community.</p>\n\n\n\n<p>It&#8217;s a truly inspiring episode, and is at the intersection of so many areas of profound importance.</p>\n\n\n\n<p>If you&#8217;re curious about how to bring WordPress into your local school, university, or community, or if you just want to hear how WordPress is making a difference far beyond the web, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Destiny Kanno, Isotta Peira and Anand Upadhyay.</p>\n\n\n\n<p>I am joined on the podcast by Destiny Kanno, by Isotta Peira, and also by Anand Upadhyay. Welcome all three of you. Thanks for joining me today.</p>\n\n\n\n<p>Now just before we begin this podcast, we&#8217;re going to be talking about education, the education landscape, and how WordPress combines with that. I hope during the course of this conversation, you will get an impression that this is something which is very dear to my heart. We don&#8217;t need to go into that, but this is about the most profoundly purposeful use of a CMS that I can actually imagine. I mean, I&#8217;m sure there&#8217;s other scenarios for other people, but for me, this is the perfect sweet spot. Education, WordPress, open source software. It doesn&#8217;t basically get better than that for me.</p>\n\n\n\n<p>So with that out of the way, I think it would be good to go round the houses one at a time and just give a little short biography of who you are, where you work, what your history is with WordPress, something like that. You can make it as long or as short as you like, but if we keep it under a minute, maybe something like that, that would be good. So let&#8217;s go to Destiny first.</p>\n\n\n\n<p>[00:04:46] <strong>Destiny Kanno:</strong> Yes. Hi there, I&#8217;m Destiny. I&#8217;m currently head of community education at Automattic. I&#8217;m a sponsored contributor in the .org space. And yes, before working on the exciting new initiatives we&#8217;re going to chat through today, I was working alongside the training team, two years as a training team rep, helping build out content, like online workshops and courses and learning pathways. And I was part of the group of folks that brought that new relaunch live last year. So yeah, exciting stuff, and that&#8217;s what I&#8217;m up to right now.</p>\n\n\n\n<p>[00:05:23] <strong>Nathan Wrigley:</strong> Okay, that&#8217;s great. Thank you so much. We have some context there, that&#8217;s lovely. And okay, let&#8217;s go to Isotta. Do you want to give us your bio next?</p>\n\n\n\n<p>[00:05:30] <strong>Isotta Peira:</strong> Sure. Thanks a lot Nathan for inviting us and, yeah. I&#8217;m Isotta, I&#8217;ve been around the community since, WordPress community since 2022 when I joined Automattic, and I&#8217;ve been a sponsored contributor since then. For the past year, three years, four years, I&#8217;ve been contributing full time to the community team. And recently this year I switched on to the educational initiative, and I&#8217;m currently leading the WordPress Credits program for students.</p>\n\n\n\n<p>[00:06:01] <strong>Nathan Wrigley:</strong> Okay, thank you very much. And finally, Anand.</p>\n\n\n\n<p>[00:06:04] <strong>Anand Upadhyay:</strong> Hi, my name is Anand, and I am running a WordPress plugin development company WPVibes. I am a user of WordPress from the last 15 years, since 2010 I&#8217;m using WordPress for various purposes.</p>\n\n\n\n<p>I have been contributing to WordPress through much multiple channels like Core, docs, polyglots, jumping from one team to another. And from the last year, I have found like my new passion. Just like you, I am also passionate about education and teaching. So from the last year, I found this idea of WordPress Campus Connect, and currently I&#8217;m very much involved in trying to bring it to the broader community.</p>\n\n\n\n<p>[00:06:39] <strong>Nathan Wrigley:</strong> Thank you so much. So I think we&#8217;ve established that the panelists today, there&#8217;s a lot of really meaningful contributions in all of your past, especially around WordPress and education. So let&#8217;s dig into that a little bit. As I said at the top of this show, I can&#8217;t see a more meaningful use of WordPress, frankly.</p>\n\n\n\n<p>I mean, I don&#8217;t know what it&#8217;s like in the places where you live, but in the UK where I live, education is one of those things where we like to talk about it being a priority, but the finances kind of don&#8217;t really match up to that aspiration. And so things like ICT, websites, coding, all of that, it&#8217;s a nice thing to have, but I think often it gets left in the background a little bit.</p>\n\n\n\n<p>And because of that, things like open source platforms, I feel there&#8217;s a really great use of that, not only from the educator&#8217;s point of view, you know, people that can use those platforms to help with their class education, maybe set up a community website, maybe set up a school website or something like that. But also from the point of view of learners, people who wish to get a leg up in life, and figure that maybe learning technology and learning how to build on the web is a credible place for them to start.</p>\n\n\n\n<p>So let&#8217;s just go through, where is WordPress at the moment in the educational landscape? I know that&#8217;s incredibly broad because we haven&#8217;t sort of pinned it down to any of the projects. Where are we at? What are the initiatives that are going on at the moment? So, again, anybody that wants to jump in, if we do a bit of crosstalking, so be it. But anybody that wants to jump in, just go for it.</p>\n\n\n\n<p>[00:08:13] <strong>Destiny Kanno:</strong> I&#8217;ll start from like what I&#8217;ve observed a little bit. I&#8217;m pretty new to the Community Team itself and this event space, but I have seen that there have been a few education related events happening throughout the years, regardless of WordPress Campus Connect.</p>\n\n\n\n<p>Like in Africa, they recently had their, I think it&#8217;s annual event, I believe in Uganda. And that has been going on for a while. It just hasn&#8217;t been under like the name WordPress Campus Connect.</p>\n\n\n\n<p>And then I believe as well, and correct me if I&#8217;m wrong, there was, with Sebastian in Poland, this like WordPress Academy, like they&#8217;re also doing like education type events and initiatives. But when it comes to now this WordPress Campus Connect, it&#8217;s an official event series, like do_action. It has like more intention around that. And I think because when you go in and you, you know, apply to organise, and now there&#8217;s this way to do it through WordPress Campus Connect, it&#8217;s just going to bring those initiatives that are already happening into like a more streamlined funnel of people seeing that it&#8217;s happening, I think, in a more, how do I say it?</p>\n\n\n\n<p>[00:09:21] <strong>Nathan Wrigley:</strong> Cohesive would be the word.</p>\n\n\n\n<p>[00:09:22] <strong>Destiny Kanno:</strong> Yeah, cohesive way. Thank you.</p>\n\n\n\n<p>[00:09:24] <strong>Nathan Wrigley:</strong> Yeah, so I guess what you&#8217;re saying there is that there&#8217;s a lot of people out there in the WordPress community, many of whom might be educators or, you know, working in a school or what have you, and that they&#8217;ve rolled their own thing like we all have with WordPress. And that&#8217;s great. That&#8217;s one of the benefits of having open source software. You download it, roll your own, what have you.</p>\n\n\n\n<p>But it&#8217;s also, it&#8217;s nice, it&#8217;s meaningful, it&#8217;s impactful if everybody can see, oh, there&#8217;s a bigger, kind of more organised piece somewhere. And it may not fit exactly what I&#8217;m doing, but at least I can see that it can be deployed this way. Maybe I can talk to those people, get some intuitions and ideas from those people and what have you, yeah.</p>\n\n\n\n<p>[00:10:01] <strong>Isotta Peira:</strong> I wanted to jump in and connect with what Destiny was saying because this is exactly what happened from the community perspective. So talking about events, a few years ago we were seeing the Training Team doing a lot of great progress around education and the Community Team around events. But we weren&#8217;t that connected between contribution teams. And we&#8217;ve also, as like project wise, we were seeing also the need to bring a different type of audience to the WordPress events.</p>\n\n\n\n<p>And we weren&#8217;t exploring at all the education field. With all the students around the world, we weren&#8217;t like taking care of them in our programs. So from the Community Team, they kind of encourage organisers all over the world to come up with new diverse format for events. And in 2023 it was launched this, it was called at the time next generation of WordPress events.</p>\n\n\n\n<p>And one of the formats that stood out was exactly the Campus Connect brought up by Anand and the community. And other events like the Website challenge, and the others that&#8217;s been mentioned. And as he was saying, then we have had the time now to come back, connect the pieces between different contribution teams, and be able to offer something recognisable, standardised, something not as overwhelming as sometimes open source programs are.</p>\n\n\n\n<p>And so we hope not just to reach a wider audience of students, but also to empower more teachers, more trainings, and anybody else in the community into bringing WordPress in any different type of education at different levels. With the support of course of the community.</p>\n\n\n\n<p>[00:11:47] <strong>Nathan Wrigley:</strong> We will get into the bits that WP Campus Connect do in a moment, but just coming back to something that you said there, it feels to me, if I browse around in the WordPress landscape, and trust me, I browse around in the WordPress landscape rather a lot. It always feels to me as if, how to describe this, initiatives where companies sell WordPress on, they build things and there&#8217;s a fee involved. You know, so you&#8217;re a web agency or what have you, you build the thing and you sell it on.</p>\n\n\n\n<p>That seems to dominate the conversation. And the more philanthropic side of things, the education piece, the bit where you&#8217;re just, you&#8217;re doing the work because it&#8217;s meaningful, and perhaps you are not getting remunerated for it. That bit somehow gets, well, it gets ignored. It somehow is the silent relation of the for-profit things. You know, you hang out in Facebook groups and you hang out on Twitter, X, whatever, online, it&#8217;s always the for-profit bit, which seems to be making the noise, you know, the plugins, the themes, and rah, rah, rah.</p>\n\n\n\n<p>And this kind of stuff seems to get left. And I don&#8217;t know why that is, but it&#8217;s, hopefully this podcast is addressing some of that.</p>\n\n\n\n<p>Anyway, sorry Anand, I think it&#8217;s your turn to have a little bit of a chat with us. Tell us about, yeah, the same question really, your experience in the education space and where you think WordPress is at at the moment.</p>\n\n\n\n<p>[00:13:02] <strong>Anand Upadhyay:</strong> Yeah, so just as you explained about the state of education in the UK, so the same is in our region, India as well. So students in the academic life are slightly disconnected with the, what is happening in the industry? So there is like a gap between the academics and the industry. So through these kind of events, we are empowering the students to come closer to what really happening in there.</p>\n\n\n\n<p>And we are also helping them to make aware about the various carrier opportunities that WordPress ecosystem can bring to them. It&#8217;s not like about just one thing, it&#8217;s also about if someone is interested in programming, someone is interested in designing, SEO, content. So there is something for everyone, right?</p>\n\n\n\n<p>So with this program, we are trying to connect the students with the various career opportunities, and also trying to bring some fresh energy to the WordPress ecosystem. They can become the contributors, they can bring their own fresh perspective. Because I have read somewhere the WordPress community in many areas is aging. We need that new fresh energy. So this kind of program can also address that problem.</p>\n\n\n\n<p>It&#8217;s always good to have more people getting involved in the contribution, like sort of just started with the WP Credit, which is bringing actually students to the contribution. And the Campus program is trying to introduce them to the WordPress. So all these kind of programmers combined with working towards getting more and more people getting involved in the WordPress ecosystem, and trying to make the project more sustainable in the long run.</p>\n\n\n\n<p>[00:14:28] <strong>Nathan Wrigley:</strong> It&#8217;s kind of interesting, I attend quite a lot of WordPress events, and particularly the flagship events so, you know, the WordCamp Asia&#8217;s and Europe&#8217;s and US and what have you. And, I think you&#8217;re right about the demographic. The demographic definitely skews older. It&#8217;s hard to see anything above, I would imagine 10% of the crowd that would be under the age of 20. I have no data to back any of that up. I&#8217;m kind of putting my finger in the air a little bit.</p>\n\n\n\n<p>But it feels like that. It feels like the demographic is, I don&#8217;t know, 30, 35, 40 and above. And if that were the only reason that you were doing WP Campus Connect, that in itself would be a credible reason, you know? But obviously there&#8217;s a lot more to it than that. But just that alone would be significant and important.</p>\n\n\n\n<p>And I think also, in a world dominated by proprietary platforms where everything is siloed, you don&#8217;t own your own data, the experience is exciting because there&#8217;s some kind of algorithm trying to hook into your brainstem, then we need to get these young people. And because we don&#8217;t have the marketing budgets of a Facebook or a TikTok or what have you, then we have to do it in different ways. And attaching an event to a campus, to a university, to an educational institution is a great way I think of doing this.</p>\n\n\n\n<p>So firstly, bravo, for getting this thing off the ground. Perhaps this one is for Anand again. I don&#8217;t know if he wants to take this question, but can you just describe what WP Campus Connect is? What&#8217;s involved in that? What&#8217;s the age group? Where are you doing it predominantly? How long has it been going? As much or as little as you like. And depending on what you give back to us, we can take it from there.</p>\n\n\n\n<p>[00:16:09] <strong>Anand Upadhyay:</strong> Yeah, so WordPress Campus Connect, there is no like fixed criteria on to whom you are going to deliver this. So the only thing is we are going to the students, we are going to their campus. We are not creating a kind of WordCamp kind of thing, or centralised workshop where everybody is coming to our venue and we are delivering them the knowledge, but it&#8217;s about going to their campus. And because this will reduce the friction, like if we are going to organise an event, centralised event, we are inviting everyone to join, then there will be a friction. A lot of people might not going to join. Maybe there were some valid reasons as well.</p>\n\n\n\n<p>So with Campus Connect, we are going to their campus and delivering the WordPress knowledge to them. And so far we have done this in the universities, postgraduate colleges, undergraduate students. And we are helping them to understand the WordPress, how WordPress can be a career choice for them, and how WordPress can be useful for whatever their interest is.</p>\n\n\n\n<p>Because as I already said, that there is students, if we are going to a college or university, that every student might have different kind of interests. Maybe they are enrolled in the same course, but still they have, might have some different kind of interests.</p>\n\n\n\n<p>So we are trying to explain them that they are with various career opportunities available so you can jump in. And we are doing it through the hands-on workshops. It&#8217;s not like that we are just doing a kind of seminar or lecture kind of thing. We are doing it in form of a kind of a hands-on workshop, like five to six hour workshop where we will help them to build their first website.</p>\n\n\n\n<p>And it&#8217;s not about like we want to make them expert in six hours. It&#8217;s not possible. So what we want to do is, we want to give them a feeling of accomplishment. This is something that is something interesting and this is something that we can use and build something.</p>\n\n\n\n<p>So this way, if they get some, after six hour workshop or five hours workshop, if they&#8217;re coming out with kind of feeling of accomplishment that this is interesting, we should explore it further, we should explore it more. So that&#8217;s our win.</p>\n\n\n\n<p>[00:18:05] <strong>Nathan Wrigley:</strong> Can I ask, in the part of the world where you are, is there a real hunger for this? Is there a real appetite for this? Because with the best will in the world, I think there might be a geographical divide in terms of interest and hunger for things like WordPress. And again, there&#8217;s no heuristics behind this, this is me supposing from what I&#8217;ve heard and conversations that I have had.</p>\n\n\n\n<p>It feels like in your part of the world, and you only have to look at plugin contributions, contributions to Core, events that are taking place in your neck of the woods. It seems like there&#8217;s a real appetite for it, that there may not be quite in the part of the world where I am from. So first of all, can we speak to that? Is that the case? Is it like, you know, you put this stuff on and people show up? You build it and they come?</p>\n\n\n\n<p>[00:18:56] <strong>Anand Upadhyay:</strong> Yeah, so there is a quite hunger. India is like a kind of a very large country and if you count the number of WordCamps that happening in India every year, it&#8217;s quite big. Right now, these are like two, three months where we don&#8217;t have any WordCamps because it&#8217;s mostly the rainy season in everywhere. Otherwise every month you will have one or two WordCamps. And the communities that are organising WordCamps struggle to find a date that is not conflicting with another WordCamp in the same country. So that&#8217;s how the things happen.</p>\n\n\n\n<p>If you talk about the beginning of this year, first three weekends have WordCamps in India, and all were very successful. So there is a kind of WordPress community is very engaging in India, and so the way everywhere.</p>\n\n\n\n<p>And also if you talk about the hunger in the students, so it can vary about what they are learning, what their background is, where they&#8217;re located. But, yeah, students from what we have interacted, because we interacted with the students who doesn&#8217;t have any knowledge. We got a very good response. We saw them talking about like, oh, this is great. We can do something amazing with this. We have a lot of ideas already. This is something that we can use to implement those ideas.</p>\n\n\n\n<p>So there is surely a hunger, but we just need to give them a path like, this is the path, and you can follow this. And we need to ensure them, there&#8217;s big opportunities, big market opportunities are also waiting for them if they excellent with some skills in this segment.</p>\n\n\n\n<p>[00:20:20] <strong>Nathan Wrigley:</strong> Yeah, I think it&#8217;s true to say that more or less every young person, let&#8217;s go, child or young adult or what have you, has some sort of insatiable appetite to learn. But given the education that they&#8217;re presented with, given the opportunities that are put in front of them, their experience of life later on will be very different. And so if WordPress never comes on the menu for them, if nobody ever suggests, well, have a look at this thing, then they&#8217;ll never know about this thing. This whole wonderful world of online publishing and all of the myriad things that you can do around the WordPress ecosystem. And so WP Campus Connect, I guess is facilitating that.</p>\n\n\n\n<p>Now, curiously though, you said that you go to where the educational institution is. How does that work? How do you connect, so again, this doesn&#8217;t have to go to Anand, this can go to anybody. How do you connect the educator, let&#8217;s say, or the institution that wishes to put something on because, you know, their students might like it. How do you connect the educational institution with the people who then go in and provide this WordPress workshop and training? How does that work? How does that get paid for? Is it all voluntary? There&#8217;s a lot in there to unpack, but I hope you get the thrust of my question. How do all those jigsaw pieces fit together?</p>\n\n\n\n<p>[00:21:37] <strong>Anand Upadhyay:</strong> The first thing is it&#8217;s all voluntary. So just like in a WordCamp, we have an organising team, a team of organisers and speakers. Nobody&#8217;s getting paid for this. We are also doing it voluntary. We have a team of organisers, not specifically to me, every WordCamp has a team of organisers, have a team of volunteers, workshop facilitators who are organising the workshops. So it&#8217;s all voluntary, nobody&#8217;s getting paid.</p>\n\n\n\n<p>And also it&#8217;s free for students as well. There is no charge for students from the WordPress Campus team. So it&#8217;s not like we are putting a kind of a ticket to them. It&#8217;s completely free. Going to your question about getting the institutes convinced for letting us do the workshop in their campus, so it&#8217;s kind of a tricky thing.</p>\n\n\n\n<p>The first time we reached out to the institute, so it was very tricky. I get to the college with a pitch deck. So I pitched the complete idea, complete presentation to show them what is WordPress, what are the kind of community thing? Because every institute has this question like, why you are doing this? What are your benefit?</p>\n\n\n\n<p>And It&#8217;s the same thing that you said, we have to pass that bureaucracy before getting to the better benefit of the student. We have to go to the bureaucracy. And it&#8217;s a genuine question in their mind as well, because, not a lot of such communities exist that are doing these kind of free things voluntarily. For the students. So the first question we were asked is, why are you doing this? What are your benefits? And don&#8217;t expect anything from us.</p>\n\n\n\n<p>[00:22:58] <strong>Nathan Wrigley:</strong> It rings so bizarre in the world in which we live. Everything about that screams, hang on. Wait, where&#8217;s the catch? Where&#8217;s the sales pitch? What&#8217;s going to happen after the fact?</p>\n\n\n\n<p>[00:23:10] <strong>Anand Upadhyay:</strong> We have to work on with this way and we have to explain like complete things. We showed them that these are the big events that in the WordCamp ecosystem happens, and we are trying to create a unique initiative for students and we&#8217;ll be delivering everything free to them. And we were not going to charge, we just need you to provide the students and the required infrastructure.</p>\n\n\n\n<p>So the pitch is really tough. In some institutes we got very understanding people who understood what we are saying. Within the next 15 minutes, we got them convinced. In some places we have to discuss a lot of questions. But yeah, it was again, interesting experience as well. We got some general feedback from them as, because last time it was the very first time we were doing this kind of thing. We don&#8217;t have any reference, like we just have an idea like we are going through this thing. So we also brainstorm with them like, what are the expectation of your students? They also gave us some suggestions.</p>\n\n\n\n<p>So because in every institute you&#8217;ll find different kind of students, you have to plan your workshops, you have to plan your workflow according to the interest of the students. So that&#8217;s how we approached, yeah, to convince the institute is the most tricky part. Because other than that, if you have to do workshop, we have our facilitators who are already working in WordPress. So it&#8217;s not difficult for them to deliver the same knowledge to adults. The only barrier that we have is to convince the college and universities to join and become a partner.</p>\n\n\n\n<p>[00:24:32] <strong>Nathan Wrigley:</strong> And has that journey, that, I guess bridge that you&#8217;ve got to cross, has that now become more straightforward? In that, you&#8217;ve got a history of things that you&#8217;ve done. So it&#8217;s now more a case of, look, here&#8217;s the testimonials. Here&#8217;s the things that have happened. We have credibility, we&#8217;ve done it before. This is not brand new. Has that become an easier journey? In other words, the door is more open than it was the first few times around.</p>\n\n\n\n<p>[00:24:54] <strong>Anand Upadhyay:</strong> Yeah, so the last year it was very tough. We have to reach up to them, take appointment, go there and spend some time there. And this year in the institute where we have done this last year, I just sent them a message like, we are doing it again, and if you want to be a part, just fill this form and we will discuss further.</p>\n\n\n\n<p>It works. So it&#8217;s much easier. And to those who are not a partner last year, but they have seen our post on the social media after the event, and they reached out to us like somehow we missed it, this time connect with us whenever you are doing it again. So once you have done this thing, you have a credibility and you can just showcase them.</p>\n\n\n\n<p>After that event, we have got a lot of the students joining our meetup. Before that, I&#8217;m running our city meetup from 2017, and we barely get 10 to 12 members in every meetup. Right now we are doing the meetups of 40 to 50 members. And it&#8217;s a kind of amazing thing. And it&#8217;s not only about having a lot of the students only. After seeing the students joining in, after seeing our pictures and the sort of local community going on, some professionals are also jumping in to join the meetups.</p>\n\n\n\n<p>Because they see that there is something valuable going on. So they&#8217;re also joining. So this is something amazing, because this is a byproduct. You&#8217;ll be able to grow your local community. You&#8217;ll be able to strengthen your local community more.</p>\n\n\n\n<p>[00:26:10] <strong>Nathan Wrigley:</strong> I have such profound respect for what you are doing. It is almost bringing tears to my eyes. It&#8217;s incredible. Everything that you say there is just so philanthropic. It&#8217;s just philanthropy all the way down. College students probably don&#8217;t have a great deal of money to throw around. They would want to consume education, which will make their life prospects better. They would like that to be as affordable as possible.</p>\n\n\n\n<p>And you show up, like here&#8217;s a bunch of stuff and it&#8217;s completely free. Okay, that&#8217;s great. And then there&#8217;s this virtuous cycle of, okay, we do it each year. That becomes easier, because the testimonials work, and presumably you can spread out and the ripples will move around where you live. And then hopefully maybe hop through jurisdictions and borders and international, who knows? We can get to that.</p>\n\n\n\n<p>But then also this knock on effect, which was maybe unexpected, a consequence that was unexpected of the WordPress community, the meetups that you offer, the swelling there and swelling in the, we talked about the demographics earlier, it&#8217;s skewing younger. And if you can attract a percentage of those, and keep them sticking around in the community, they can then take on these roles in the future.</p>\n\n\n\n<p>And the whole thing kind of propels itself. What it needed was the prime mover, which was you, which is pretty incredible. So I don&#8217;t know if Destiny or Isotta want to add anything. I&#8217;m almost speechless.</p>\n\n\n\n<p>[00:27:31] <strong>Destiny Kanno:</strong> I did have like a few points I wanted to add to what everyone&#8217;s saying. Reducing barriers has been a huge factor of setting this up. Originally we were using like the previous event organisation form and were like, actually there&#8217;s a lot of stuff in here. It doesn&#8217;t make sense for this use case. So we really paid a lot of attention to just thinking differently for this, and treating it differently. We don&#8217;t have to use the same things as we had before.</p>\n\n\n\n<p>And Isotta said before, like it&#8217;s standardised in a way, but it&#8217;s flexible too. So even though we have this framework that people can come to, we don&#8217;t say, you can only do the event in this way. You can have a one day event, you could do a half day event, you could have event series over a couple weeks like Anand is doing, and that is totally cool. Like, however you want to run this, we are open to that, and we&#8217;re also here to mentor you and support you in that.</p>\n\n\n\n<p>And then I, a thought came to my mind as Anand was talking, and you Nathan as well about like, you know, what&#8217;s in it for the volunteers? And I&#8217;m like, I think it&#8217;s an opportunity for volunteers just as much as it is the students, because they&#8217;re also getting exposure to these universities. And I don&#8217;t know, maybe someone has an ambition to teach at university someday, or like at least teach about WordPress at a university. So, you know, as you go into these, yes, there&#8217;s a hundred percent the philanthropic aspect, but it&#8217;s also like a learning experience for you as well as a volunteer to be in that space with the students too.</p>\n\n\n\n<p>And then lastly, I wanted to say as well, like going a little bit back about the current climate and how it feels like we are kind of like aging, I&#8217;ve also noticed in my experience it&#8217;s like, we are all also just, this is probably very like, duh, but we&#8217;re all professionals, right? So we&#8217;re not really looking to talk to students most of the time. We&#8217;re looking to sell something or network or like talk to other professionals. So I do think that this is a great way to bring in that new batch of folks that are going to become professionals, hopefully in the WordPress space. But yeah, it&#8217;s just that renewal instead of like just trying to sell or buy from whoever&#8217;s there based off of whatever you&#8217;re currently working on in the WordPress space.</p>\n\n\n\n<p>[00:29:46] <strong>Nathan Wrigley:</strong> Thank you. Isotta, anything you want to throw in at this point?</p>\n\n\n\n<p>[00:29:49] <strong>Isotta Peira:</strong> Of course. I want to add one point about the aging discussion that we were having, because also, in my opinion, it is true what you, Nathan, said at the beginning that just only the fact of reaching younger people is a way to make the project more sustainable, long term. But also I would love everyone to think about the other way around, because what is WordPress giving to all these younger generations?</p>\n\n\n\n<p>Because wins are much, I mean, for how I see it, I see like a winning opportunity everywhere. Because it&#8217;s not just about reducing the age of the people involved in the project. If we reduce the age, but people are not engaged. If they&#8217;re not getting what they need, learning opportunities, networking opportunities, even just opportunities to understand that they have a whole world around them, they didn&#8217;t even know that it existed, which happened to me before I learned about WordPress community and WordPress, this is huge.</p>\n\n\n\n<p>So this is a real, like all this initiative are core of the service that will be giving to millions of students. For now, we are at thousands of students already, but, this would be available for any students worldwide. And this is a pretty big deal, I believe, for younger generation and their futures.</p>\n\n\n\n<p>[00:31:12] <strong>Nathan Wrigley:</strong> I think it&#8217;s, on every level this is just so remarkably interesting, and the growth of it hopefully we&#8217;ll get into the millions. Right now you say you&#8217;re in the thousands. It&#8217;s still remarkable.</p>\n\n\n\n<p>I want to sort of drill into it a little bit. So it feels like there&#8217;s this sort of double fronted marketplace aspect to it where WP Campus Connect kind of sits in the middle, and so you&#8217;ve got WP Campus Connect in the center, and then on the one side you&#8217;ve got the students and the institutions that those students attend. And then on the other side, you&#8217;ve got the educators who will come into that institution and WP Campus Connect is sort of like the fulcrum, the center, the spokes all lead into WP Campus Connect, and they do all the connecting and what have you.</p>\n\n\n\n<p>Let&#8217;s talk about the educator side. So this is people who already are familiar with WordPress. Are there any constraints on who you would welcome into WP Campus Connect there? Like, is there any level of expertise that you&#8217;ve got to have, or any kind of proof that you&#8217;ve got to go through that you, yourself would be a credible educator? I don&#8217;t know, so that&#8217;s open to anybody. Is there any kind of barrier to entry if you are an existing WordPresser and want to be involved?</p>\n\n\n\n<p>[00:32:20] <strong>Anand Upadhyay:</strong> Yeah, so far we have not planned any kind of a specific requirements or the limitations or criteria. So far we have picked from the local community members, like we just opened the call for facilitators, and all those who are interested in teaching. And they responded to it and we just picked them.</p>\n\n\n\n<p>We are doing a kind of a series of event to, I think five to six colleges in this time and going every weekend to one college. So we have a pool of four workshop facilitators and we&#8217;ll be rotating them to multiple colleges. So this is how it is working. So there is no kind of barrier kind of thing.</p>\n\n\n\n<p>We are just thinking about if they are ready for the community work, because there may be many educators, but there may not be everyone who will be doing it for free because we are not going to pay them anything. So if they have the community feeling, they have the community vibes and they can come forward for this. So that&#8217;s the only criteria we have. You have the WordPress knowledge, you have the love for community. Just come forward and join us for the event.</p>\n\n\n\n<p>[00:33:19] <strong>Nathan Wrigley:</strong> Okay, that&#8217;s great. Great to hear. So staying on that side of things then, I remember my forays in education, one of the things that was kind of drummed into me was, failing to plan is planning to fail. And so there was always this aspect of, if you&#8217;re going to stand up in front of a bunch of people, you have to be ready. You can&#8217;t necessarily, I mean you can, right? A workshop environment maybe maps to that pretty well, where you stand up and it&#8217;s led by what the audience, the students in this case, would like to hear.</p>\n\n\n\n<p>I&#8217;m wondering if there&#8217;s a curriculum which you have planned or do plan, or if somebody can kind of like drop in and just pick up the pieces of paper if you like and say, okay, here&#8217;s the lesson plan, if you like. WP Campus Connect has put these plans together, and we&#8217;re going to go and show these students how to do this.</p>\n\n\n\n<p>So that is my ignorance. I don&#8217;t know if that&#8217;s the kind of thing that you do. Do you provide materials for wannabe educators to deliver, or is it very much you create your own curriculum on the fly or however you wish to do that?</p>\n\n\n\n<p>[00:34:16] <strong>Anand Upadhyay:</strong> So we just meet together and just plan, just think about like how we can go on ahead, like what are the things that we to teach? And we just brainstorm it together. It&#8217;s not like we are giving the, because there is not much different between the organiser and workshop facilitators here. So we are all the community members, so we have just divided the roles, but we are all, they&#8217;re working towards the same goal.</p>\n\n\n\n<p>So we just all sit together, brainstorm the ideas, like what should we give to the students? So for example, last year we helped them to build a kind of a business website. So all the educators plan together. So we will follow this workflow, we will follow this approach. And we went to one college, we tried to do the same thing. We came back and then we again said what went wrong? What was difficult for the students to follow? How we can overcome them in the next college? We repeat, we improvise and deliver the same thing.</p>\n\n\n\n<p>This year we, again, we are planning, so we again sit together. And then we thought about, last year we helped them to create a kind of a simple business website, but we found that students were not connected with that. They built the same thing, but they didn&#8217;t utilise it later because it was not connected to them. So this year we are planning to help them to build their personal portfolio website, a kind of a resume, where they can showcase their projects, they can showcase their resume, they can showcase their work or learning what they have done. So we are planning that kind of website.</p>\n\n\n\n<p>So again, our workshop facilitators are working together, all those educators, and working together to create a kind of a reference website. And then we will guide them to recreate this, the same thing, adding their own touch because this will be more personalised thing. They will get attached to this, and maybe we can have some of the students to put their websites live. So it&#8217;ll be, again, a good chance.</p>\n\n\n\n<p>And we are also getting some support from the hosting companies who are offering some pre-hosting accounts so we can do kind of a competition kind of thing, or someone who has done incredible work during the workshops and post workshop, we can provide them those free hostings and they can get the chance to put their website live.</p>\n\n\n\n<p>[00:36:21] <strong>Nathan Wrigley:</strong> Okay, so it&#8217;s a real kind of project based education then. So you walk into the room, you interact with the educators, you ask questions, I&#8217;m struggling with this thing, I can&#8217;t make this work, and they come and step in. So you described it as a workshop and maybe the audience, I don&#8217;t know if you&#8217;re familiar with that kind of setup, but education often felt like to me, person at the front with some kind of display, whiteboard, blackboard, whatever. They talk, I listen, I fall asleep.</p>\n\n\n\n<p>But this is not that. This is, okay, we have a project, we&#8217;re going to design a business website, a personal portfolio, resume kind of website. And the idea is that you interact with that and by the time you&#8217;ve left, you&#8217;ve got some useful knowledge. You&#8217;ve done a thing, not just listen to somebody talking about possibly doing a thing hands on. Okay, that&#8217;s brilliant.</p>\n\n\n\n<p>Is there any kind of age restriction? Because obviously if I was to bring along a 3-year-old to this, we would question the utility of that. You kept talking about colleges and I think you mentioned universities a couple of times. So it feels to me as if we&#8217;re 18 or something is kind of where this goes, yeah?</p>\n\n\n\n<p>[00:37:28] <strong>Anand Upadhyay:</strong> Yeah, most of the students we interacted with are around mostly 17 plus we can say, 17 or 18 plus. So that&#8217;s the age group. And this year we have got a student, we have got a request from one of the high school as well. So they want to, their approach was very nice. They want to give the students kind of exposure to what they are going to face after completing their high school. So they&#8217;re running kind of a program so they&#8217;re also interested in if we can just go to their school and give their students some kind of a short introduction about any skill that is relevant for them. So we&#8217;re also getting that kind of request as well.</p>\n\n\n\n<p>[00:38:04] <strong>Nathan Wrigley:</strong> Yeah, and that&#8217;s such an interesting age as well, because you haven&#8217;t yet kind of formulated your path. And I think maybe by the time you get to 16, 17, 18, you&#8217;re more funneled. You&#8217;ve made decisions which have led you in a certain direction. You know, I&#8217;m going to be a, I&#8217;m into agriculture, I want to do whatever it may be.</p>\n\n\n\n<p>But if the high school level, everything&#8217;s wide open still, isn&#8217;t it? And if you can get them and expose somebody that&#8217;s never been on a computer even, and, oh look, I put something and people nowhere in me can suddenly see it, that may open up a completely new pathway.</p>\n\n\n\n<p>But what you&#8217;ve got going at the moment, what do these students get in return? Is there like a quid pro quo? Is there some, sort of leading question here really. Is there some credit that you might get on the other end of this? Do students get to walk away with, apart from obviously the knowledge, which is now in their head for life, do they get to walk away with some kind of accreditation to say, I did this, here&#8217;s my certificate, or whatever it may be?</p>\n\n\n\n<p>[00:38:59] <strong>Anand Upadhyay:</strong> Yeah. So we are again providing them certificates for the completion of attending the workshop. And, yes, obviously they are getting some amazing knowledge, amazing exposure to the community. Yeah, but as a proof of thing that they have done something, we are providing them certificates.</p>\n\n\n\n<p>[00:39:14] <strong>Nathan Wrigley:</strong> Okay. And obviously, you know, if they then continue that participation in the meetups and what have you, you get the bit which is way more important than the certificate, which is the actual exposure to the people out there in the real world who can give you that leg up or point you in the right direction for the person that you need to help you on that first career step.</p>\n\n\n\n<p>So I&#8217;m just going to the panel, I&#8217;m just going to say. Did you want to add anything to that? So I was talking about this sort of double fronted marketplace, you know, students, one side, educators on the other. Anything to add?</p>\n\n\n\n<p>[00:39:43] <strong>Destiny Kanno:</strong> Well, I did want to add in general that we&#8217;ve been very careful to say in all of the handbooks and landing pages, educational institutions. So that could be colleges, that could be high schools, that could be technical schools or different business schools, boot camps, wherever you&#8217;re getting educated on something that WordPress can maybe be hand in hand with.</p>\n\n\n\n<p>We would love you to run a WordPress Campus Connect event, so I wanted to like make sure we clarify that. And then also, anyone could put this on. A request to organise could come from like a teacher, for example, or a student even. We&#8217;re not like limiting it to local community organisers or anything like that. So if there is direct interest as well from a campus, then that&#8217;s even better because, you know, they&#8217;re going to have a venue and all they really need is like mentorship and maybe some facilitators.</p>\n\n\n\n<p>And then to plug in just a bit, you were like, what kind of curriculum do they have? Don&#8217;t forget, there&#8217;s Learn WordPress, you know, .org as well where folks can definitely use the materials there to craft their own curriculum or a series of workshops or whatever they&#8217;re going to put on as well. So I do want to ensure folks know that there are resources available that are free to help you with that part of the programming too.</p>\n\n\n\n<p>[00:41:00] <strong>Nathan Wrigley:</strong> I&#8217;m just going to read this into the record. If you are, I don&#8217;t know how podcasts are consumed, I just know that they&#8217;re consumed in a wide variety of ways. If you are driving the car or you are walking somewhere and you think, I&#8217;ll get to this later, stop. If you know an educator somewhere, make a point to mention this to them at some point. You know, tomorrow, get home, phone them up. They&#8217;ve probably never heard of this. They&#8217;re probably not in the WordPress space. They probably don&#8217;t have the slightest intuition that this freely available stuff could step into their institution, with what sounds like minimal work required on their part.</p>\n\n\n\n<p>But it&#8217;s unlikely that they&#8217;re WordPressers in the same way that you are because you&#8217;re listening to this podcast. So that&#8217;s my request to you, that&#8217;s your philanthropic request of the day. Go and mention it to the people that you know, who work in these places and have connections with these places, because it won&#8217;t happen without those kind of things happening. So, sorry, Isotta, I didn&#8217;t allow you a chance to speak. I got all carried away.</p>\n\n\n\n<p>[00:42:00] <strong>Isotta Peira:</strong> Don&#8217;t worry at all, Nathan. I believe that we&#8217;ve been saying a lot already, and there is just a good amount of information around for everyone who&#8217;s listening about how this program works, how to connect with us, and how to just launch their Campus Connect series events in their cities.</p>\n\n\n\n<p>[00:42:18] <strong>Nathan Wrigley:</strong> So we&#8217;ve spent a long time thinking about WP Campus Connect, but something that was dropped into the show notes, and I confess, I don&#8217;t really have a great deal of background on this, so you&#8217;re going to have to explain it in full. WordPress Credits. The name I guess suggests something, but I don&#8217;t really know what that something is. So, Isotta, if you fancy just running with that, tell us about WordPress Credits.</p>\n\n\n\n<p>[00:42:39] <strong>Isotta Peira:</strong> Of course. Big pleasure for me to share more about it. WordPress Credits, in simple words, is a contribution based practice programs by the WordPress foundation open to students to just to bridge them in the Core of WordPress. Regardless of what they&#8217;re studying, their fields, their interests, what we want to do is take one step from the WordPress skills education and show them how they can enhance, train, and gain new skills using the WordPress ecosystems, regardless their interests.</p>\n\n\n\n<p>And the word credits, as you said, yes, it&#8217;s just something because we want to partner with educational institutions, universities, schools, that will recognise the practice program into their students&#8217; curriculum.</p>\n\n\n\n<p>A clear example, we&#8217;ve just launched a pilot with the University of Pisa in Italy for the Department of Translation and Communication. And for them, we are offering 150 hours of practice for the students. They will be connected with mentors. They&#8217;re going to have their virtual classrooms, and they&#8217;ll be guided since the beginning until the end. At the end, they&#8217;re going to build their website of WordPress, we teach them how to do it. You are going to use the Learn platform to guide them through the whole process. And they&#8217;re going to be involved in practical work within the community.</p>\n\n\n\n<p>They get to pitch what they want to work on. So this is open for designer, translators, developers, whoever wants to practice their own skills and position themself already into the job environment. Because we noticed, I felt like livid on my skin when I was studying translation at the University of Pisa, that I had to do countless hours of practice translating things that nobody ever read, used. It was very good for me. For me it was perfect to have things to practice on, and so I could become a great translator, but I worked on stuff that nobody ever used.</p>\n\n\n\n<p>And the moment I joined the WordPress community in 2022 and I found out about the Polyglots team, I start thinking, hey, I could have been translating WordPress for five years and getting real life experience, exposure to a global community of professionals in the field that I&#8217;m interested, and also connection with companies with other fields that I couldn&#8217;t even imagine it existed for me as a translator.</p>\n\n\n\n<p>So the goal of this program is exactly to enable students around the world, regardless what they&#8217;re studying, to become, to shape their future through practice. And we, when I say we, I mean all the volunteers and contributors who are participating into this project. We have designed a path for each student where they not only get to practice the skills that are more relevant to the fields of study, but also transferable skills.</p>\n\n\n\n<p>Like, for example, organising, working independently in a remote and async environment while keeping stakeholders updated. How to design a project, because they will have to finish the program, presenting a project that they would&#8217;ve designed, developed, and worked on. Public speaking because they would have also exposure to presenting the work to the WordPress community.</p>\n\n\n\n<p>And at the end of the mentorship, of course, from experienced contributors in our community, and at the end, at the wrap up, they will receive a certificate from the WordPress Foundation, certifying the hours of contribution within the program. And at that point, the educational institution they&#8217;re studying, they&#8217;re going to recognise these as a part of their curriculum.</p>\n\n\n\n<p>For some universities and schools, it translates into credits. For example, for Pisa, 150 hours of contribution translating into six credits. So students can decide to skip a traditional exam and do this practice. And for other institution might look different. But the requirement for an institution to join this program is that they have to recognise this work into the students curriculum.</p>\n\n\n\n<p>[00:47:08] <strong>Nathan Wrigley:</strong> Okay so, dear listener, you may have noticed we shifted gears. We went from talking about WP Campus Connect to WordPress Credits, and we&#8217;ve now moved into a very different arena.</p>\n\n\n\n<p>And so now, I&#8217;ve never been to the University of Pisa, but I&#8217;m going to guess that, just the name itself, it&#8217;s an utterly credible institution, you know, with a long history of taking in students and requiring them to work hard in order that they get some kind of qualification at the end.</p>\n\n\n\n<p>So this is very different. We are now talking about doing WordPressy things, and at the end of it, it&#8217;s equal to a proportion of the stuff that they would be doing at that university already. Now that then, I guess, implies that this is a more structured thing, that there needs to be more inspection of what&#8217;s going on, that there needs to be kind of hoops to jump through that you need to be able to credibly say, we know that this person did this. We can prove it. There&#8217;s a paper trail, and at the end of it you get, with the University of Pisa, six credits, which equals whatever that equals.</p>\n\n\n\n<p>So presumably there&#8217;s more backwards and forwards. Rather than the WP Campus Connect, which is more philanthropic and, you know, more community based, presumably you&#8217;ve had to have fairly lengthy conversations and dialogue with the University of Pisa so that they know that you are not giving away six credits for nothing. What&#8217;s that been like?</p>\n\n\n\n<p>[00:48:39] <strong>Isotta Peira:</strong> Yes, you are absolutely right, and this is the case, and it is understandably, because we need to show them what is the potential, and what the students will gain. For me, it&#8217;s been a wonderful experience. And now I&#8217;m also in conversation with other universities and other schools. And having myself lived, like felt this gap between, oh, I&#8217;m doing practice, but it feels like it&#8217;s just useful to me, but it&#8217;s not applied in the real world.</p>\n\n\n\n<p>And seeing, hey, this could bring, just basically push all these students into creating something that not only they own, because I believe the ownership is very important because most of cases, studies are a little bit passive. So as you were saying before, we have a teacher, we sit, we listen and we do what we&#8217;re asked to do.</p>\n\n\n\n<p>In this case is the other way around. It&#8217;s, hey, this is a playground of learning opportunities for you. We show you everything that you can play with, and then you get to design the project. You get to experiment all this exposure to real life that usually you don&#8217;t get at university or another, let&#8217;s say, formal institutions. And for the universities, this is going to be, basically a certificate for institutional excellence for them, because right now, only the University of Pisa is offering this. In a few weeks, also the universities Fidélitas in Costa Rica will start offering this.</p>\n\n\n\n<p>So just, hey, to institutions worldwide, this is something that the university, once they understand what it is, they will want to jump on it. And so as you say, it&#8217;s a lot of back and forth. It&#8217;s always a very interesting conversation because every university has some similar and some different needs for their students. And for me it&#8217;s a huge learning curve because I&#8217;m getting to learn a lot about other institutions. But at the end, everyone who I&#8217;ve been talking to so far, they are like over the moon with the idea of offering this option, this possibility to their students.</p>\n\n\n\n<p>What I&#8217;m doing right now is starting connecting with teachers, schools, universities, institution that I personally, I&#8217;m already personally connected with, like the case in Pisa. And the WordPress community is key because also, in this community, there&#8217;s plenty of teachers. Everywhere you look, there is, oh, okay, I teach WordPress, I teach this other WordPress related theme. Oh, I teach at this school, I teach at this universities. Or, hey, in my kids&#8217; school, they were looking for something like this, and it turns out that maybe you&#8217;re not a teacher, but you have kids and they&#8217;re at schools.</p>\n\n\n\n<p>So it&#8217;s been key, the connection with the community. And it&#8217;s actually one of the biggest needs that we have right now. Right now, there are three, including myself, contributors focusing on this project. We need more help, also to create this connection, to get into the institution and to have them understand the offer that we&#8217;re giving to them.</p>\n\n\n\n<p>[00:51:59] <strong>Nathan Wrigley:</strong> So I&#8217;m going to read into the record a recycled version of the comment that I made a moment ago about WP Campus Connect. And that is that if you know anybody who could fit into this part of the jigsaw, you know, an educator or somebody that works in a university, whatever capacity that may be, I guess you are looking for that door to be slightly pushed ajar so that you&#8217;ve got these contacts wherever they may be. Obviously you&#8217;ve got Pisa, Costa Rica and what have you. But it would be nice to spread this a little bit further.</p>\n\n\n\n<p>Okay. Okay, so that bit is now done. The bit that I want to ask with this is with the university students going through the WordPress Credit system, is this kind of a distributed thing? Is it something that they can do in their own time? Or do they need to, I don&#8217;t know, attend, be in a particular lecture hall at a particular time in order to prove that they&#8217;ve done a particular thing? Or is it entirely remote with, well, basically it&#8217;s a very open-ended question. How does it work from a student point of view? How do they achieve this?</p>\n\n\n\n<p>[00:52:59] <strong>Isotta Peira:</strong> This is a great question actually. The values behind this program is to keep the open source experience as real as possible. So it is a hundred percent remote. We have built the virtual classroom for each student on the Learn platform, and they will be able to self onboard themself, go through the all the steps, but at the same time, they will be paired with the mentors.</p>\n\n\n\n<p>So we strongly recommend, and for this first, let&#8217;s say, round of program, we are making strong suggestion to meet with their mentor once per week, so they can learn more about each other, the mentor can help them guiding their way, but they have to complete the hours. We want to, not just respect the principle of the WordPress ecosystems, but also put students in this real life environment that they will find in their job.</p>\n\n\n\n<p>Because most of the roles in different type of companies, you just don&#8217;t have to like stay there and show that they&#8217;re doing the things. You work at your pace. You have your project. You have to share updates, of course, and show that you are progressing. And for WordPress credits, if students want to work on weekends, during night, this is up to them. They just have to complete the WordPress site and the hours assigned.</p>\n\n\n\n<p>And there are couple of steps that will have them syncing at a specific moment with other parts of the community. For example, participating to a discussion on Slack, or a discussion on a blog post. Because also they&#8217;re experimenting different tool and different communication styles. And if there is a meetup, local meetup active in their cities, one of the step would also be participate to one of them. Or if there is no meetup, local meetup happening, to join an online meetup.</p>\n\n\n\n<p>So in this way the success of this program would reach the most, the highest point, if they have not only completed the work they decided to do, but if they also have experienced all the different parts of the ecosystem. So this way they work out the program, and they have the new world possibility open. They can decide to stay, they can decide to just focus more on one particular thing and they would&#8217;ve learned how to upload and work on WordPress, TV. How to use tools like Slack, GitHub, WordPress, the Learn platform, everything. So this is what they will get.</p>\n\n\n\n<p>[00:55:32] <strong>Nathan Wrigley:</strong> Yeah, it&#8217;s pretty amazing. I mean, set aside the fact that when I was at university, the internet just didn&#8217;t exist because I&#8217;m of a certain age, but I would&#8217;ve loved something like this. The capacity to just sort of do things in my own time, you know, fit it around, cherry pick the bits that I want to pick. For me it was much more, you pick a course, you show up to the course, you imbibe the content, you sit and exam and so it goes. And that was what was on offer. But this is so great.</p>\n\n\n\n<p>And also, I don&#8217;t know if this is something that you do do but it just came into my head, the capacity for this to be an accreditation prior to gaining access to a university. So at the minute in the UK, all of the results are coming out for the examinations which children, well, young adults require in order to get to their place at university. And then when they&#8217;re at the university, they obviously get these credits and get the degree or what have you. But something like WordPress credits, it&#8217;d be kind of fun if it could count towards that onboarding process, you know, to get you in the door of a university to show up and say, I did the WordPress thing. I did something a little bit above and beyond what everybody else is doing. I mean, I don&#8217;t know if there&#8217;s any plans for that, but that struck me as a curious option.</p>\n\n\n\n<p>[00:56:45] <strong>Isotta Peira:</strong> That would be the dream. Having WordPress credits embedded into like mandatory curriculum to get to a specific level of education, or to be able to end, to graduate from a specific level of education. This is going to be the dream. Now we&#8217;ve taken the first steps, so now we&#8217;ve built up the program, we are going to gather feedback, improve it, adjust it with all these first new batch of students that are coming. And also from the sponsors, the universities, and the mentors feedback. And then little by little, this is where we want to go. Ready to bring WordPress contributions everywhere.</p>\n\n\n\n<p>[00:57:22] <strong>Nathan Wrigley:</strong> Yeah, I mean, gosh, what an episode this has been. I thoroughly enjoyed this. However, I don&#8217;t know if we&#8217;re done yet because on the show notes that I had, we had three points that we were to mention. One was WP Campus Connect, which we did at the beginning, and then we&#8217;ve just spent a few moments talking about WordPress Credits. But there&#8217;s this other curious bit that I don&#8217;t know much about, and I don&#8217;t know if this is something we want to delve into, WordPress Student Clubs. What&#8217;s that?</p>\n\n\n\n<p>[00:57:47] <strong>Destiny Kanno:</strong> Yeah, so that is, you don&#8217;t have to have a WordPress Campus Connect event to request a WordPress Student Club on your campus. But it essentially was birthed out of this idea from Anand of like, hey, you know, now that we&#8217;ve got this captive audience of students, like where do they go to continue the WordPress activities after we&#8217;re gone? And so the, yeah, WordPress Student Clubs were born.</p>\n\n\n\n<p>You can now request a site created for your Student Club when you request to organise a WordPress Campus Connect event, or you can just reach out to us directly. And right now, I believe Anand is working with the Sophia Girls College right now in Ajmer to set up their WordPress Student Club. I think they&#8217;re the first actually to have one.</p>\n\n\n\n<p>And the goal is that they can continue on campus, their WordPress activities. They can connect still with the local community, potentially like invite them to their student club events. It&#8217;s just like a extracurricular circle or club that now is WordPress themed that will, I think, help them continue.</p>\n\n\n\n<p>And also, sorry, I just wanted bring in like the Credits portion too. Like you might have folks from different majors, right, that are using WordPress in different ways. So it&#8217;s a way for also the students to intermingle amongst different majors within their campus as well.</p>\n\n\n\n<p>[00:59:08] <strong>Nathan Wrigley:</strong> It&#8217;s kind of a way to keep the conversation going, isn&#8217;t it, in a sense? It&#8217;s more opportunities to kind of keep people interested and give them opportunities. And all of that is just so necessary. We talked at the beginning about the age demographic of WordPress and how all of this stuff is just such a real credible way of trying to tackle that.</p>\n\n\n\n<p>And I think if you were to put somebody that went through, let&#8217;s say, WP Campus Connect. If you were to drop them straight into a meetup, maybe that&#8217;s too much, because it can get fairly technical. You know, the presentations are often about some fairly technical things, and so this feels like a really nice bridge. It keeps it more based around the students, so they&#8217;re familiar with each other. They&#8217;re in the same institution, presumably. It&#8217;s kind of like a club. We call them afterschool clubs in the UK. It feels a little bit more like that. So it&#8217;s much more based around where they already are and that kind of thing.</p>\n\n\n\n<p>[00:59:59] <strong>Destiny Kanno:</strong> It gives them a sense of ownership as well, because it&#8217;s as you said, it&#8217;s a students&#8217; club, so, you know, there&#8217;s going to be someone that&#8217;s leading it, and maybe a co-lead as well, and a faculty member who will also be there to advise or assist.</p>\n\n\n\n<p>[01:00:13] <strong>Anand Upadhyay:</strong> It&#8217;s kind of an in campus meetup group, that kind of thing. So they can, just like you said, taking them to the local community meetup will be a little bit overwhelming from them, because whatever the sessions, whatever the topics that are planned in the meetups stuff, catering to the wider audience. So in the campus club they can decide their own kind of topics. What are the topics they are interested in? And they can learn, it&#8217;s kind of a group learning as well. Someone from them is learning one topic and delivering this knowledge to the other club members. So it&#8217;s a way to keep the momentum going on that is started with WordPress Campus Connect program.</p>\n\n\n\n<p>[01:00:51] <strong>Nathan Wrigley:</strong> Yeah, it&#8217;s absolutely wonderful. I&#8217;m going to make sure, before we finally finish this call, although we&#8217;ll end the podcast recording in a moment, I&#8217;ll make sure that I ask these panelists to send me any links that may assist you. And so what I&#8217;m going to say is if you head to the wptavern.com website, and if you search for this episode, you could probably search for WP Campus Connect or WordPress Credits or what have you, certainly it&#8217;ll be there available in search.</p>\n\n\n\n<p>Head to that, look at the show notes and the links. There&#8217;ll be a transcript of this and there&#8217;ll be some show notes where I just sort of summarise what&#8217;s going on. But right at the bottom, a little way down the page will be all of the links for everything that we have discussed. Maybe some additional ones as well for things that we didn&#8217;t have.</p>\n\n\n\n<p>And when I attend WordPress events, there&#8217;s always a sense of this, there&#8217;s always a sense of look around, the community&#8217;s not getting any younger. We&#8217;ve got to do something about it. Complaining is the wrong word. People are not doing that, they&#8217;re just curious about that. Well, here, you&#8217;ve been spoonfed the solution. You now know what it is that you could do to skew the demographic younger. If the WordPress project is something that you believe in, and you would like to carry on, the only way to do that is to have a funnel of younger people who will become the older people, who will then teach the younger people. And so the cycle continues.</p>\n\n\n\n<p>If you want that to happen and you don&#8217;t know how to make that happen, well, now you do. You&#8217;ve got these people to reach out to. You&#8217;ve got these projects that you know about. You can get involved in any of this, at any level.</p>\n\n\n\n<p>And all that it remains for me to do is to say, wow, thank you to all three of you for being interested in this. Not just interested, being active and making the effort to get these things started, to get them off the ground, which is the hardest bit, I think. And hopefully now that they have got off the ground, they will fly with wings of their own. That would be really nice. So, Destiny, Isotta and Anand, thank you so much for chatting to me today. What an episode that was.</p>\n\n\n\n<p>[01:02:55] <strong>Destiny Kanno:</strong> Thank you so much, Nathan.</p>\n\n\n\n<p>[01:02:57] <strong>Isotta Peira:</strong> Thank you. It&#8217;s been a huge pleasure.</p>\n\n\n\n<p>[01:02:59] <strong>Anand Upadhyay:</strong> And thank you for giving us a platform to share all these initiatives.</p>\n</div></details>\n\n\n\n<p>On the podcast today we have <a href=\"https://profiles.wordpress.org/piyopiyofox/\">Destiny Kanno</a>, <a href=\"https://profiles.wordpress.org/peiraisotta/\">Isotta Peira</a> and <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a>.</p>\n\n\n\n<p>Destiny is the head of Community Education at Automattic. Isotta is the leader of the WordPress credits initiative for students. Anand is the founder of WordPress Campus Connect.</p>\n\n\n\n<p>This episode is all about how WordPress is not only powering websites but also empowering the next generation of learners and creators. You’ll hear about the growing movement of education-focused WordPress events happening worldwide, from hands-on workshops on university campuses in India, to student clubs designed to keep the momentum going after introductory events.</p>\n\n\n\n<p>Anand shares how WP Campus Connect is bringing WordPress directly to students, reducing barriers to entry and helping bridge the gap between academic learning and real-world tech skills. We also explore the challenges of organising these events, from convincing institutions of the value of open source, to fostering genuine community involvement among both students and educators.</p>\n\n\n\n<p>Isotta then introduces us to the WordPress Credits program, an initiative that lets students turn their contributions to the WordPress ecosystem into recognised academic credit at universities like Pisa in Italy. It’s a win-win: students gain practical, resume-worthy experience, while educational institutions get a transferable, skills-focused, program that prepares learners for the jobs of the future.</p>\n\n\n\n<p>Whether you’re an educator, a WordPress enthusiast, or just someone who cares about open source and community, this episode is packed with actionable insights. The guests share how flexible and resilient these education initiatives are, how you can get involved, and why engaging the next generation is not just important, but essential for the continued growth and sustainability of the WordPress community.</p>\n\n\n\n<p>It’s a truly inspiring episode, and is at the intersection of so many areas of profound importance.</p>\n\n\n\n<p>If you’re curious about how to bring WordPress into your local school, university, or community, or if you just want to hear how WordPress is making a difference far beyond the web, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/handbook/wordpress-credits-contribution-internship-program/\">WordPress Credits Program</a></p>\n\n\n\n<p><a href=\"https://gamma.app/docs/WordPress-Credits-2ul3dmv61tpover?mode=present#card-qc1u5yvi4tt7he1\">WordPress Credits: A bridge to open-source technology</a></p>\n\n\n\n<p><a href=\"https://events.wordpress.org/campusconnect/\">WordPress Campus Connect</a></p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/community/handbook/community-deputy/other-event-formats/wordpress-campus-connect/#wordpress-campus-connect-student-clubs\">WordPress Student Clubs</a></p>\n\n\n\n<p><a href=\"https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/\">Introducing WordPress Credits: A New Contribution Internship Program for University Students</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Biographies</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Destiny Kanno</h3>\n\n\n\n<p>Destiny Fox Kanno, sponsored contributor at Automattic with a focus on education within the WordPress community. Currently focusing on growing, enabling and amplifying the WordPress Campus Connect and Student Club initiatives.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Isotta Peira</h3>\n\n\n\n<p>Isotta joined the WordPress Community in 2022 as a full-time contributor to the Community Team, sponsored by Automattic. With a background in translation, sales, training, and community management, she also ran a culinary events business. She values making informed decisions by integrating data analysis into her work and believes sharing knowledge is key to fighting inequality. Isotta is currently leading the WordPress Credits program, an initiative that connects open-source contributions with academic curricula worldwide.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Anand Upadhyay</h3>\n\n\n\n<p>Anand Upadhyay is the founder of WPVibes, a WordPress plugin development company. He has been working with WordPress since 2010 and contributes to several Make WordPress teams, including Core, Docs, Polyglots, and Community. He also serves as an organizer for WordCamp Asia, one of the flagship events in the WordPress ecosystem.<br />In addition to building plugins, Anand is deeply passionate about teaching and education. He co-organizes the Ajmer WordPress Meetup and is currently contributing to the global expansion of WordPress Campus Connect, a program he initiated as a pilot in 2024 to introduce students to WordPress and open source. Through these efforts, he focuses on helping new learners and contributors discover opportunities to learn, grow, and find their place in the WordPress community.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Sep 2025 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"Open Channels FM: How WordPress Handles Backwards Compatibility: Lessons from Real-World Challenges\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=105983\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://openchannels.fm/how-wordpress-handles-backwards-compatibility-lessons-from-real-world-challenges/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:241:\"The discussion on backwards compatibility highlights its importance in WordPress, ensuring seamless functionality during updates. Experts emphasize careful support for older versions, enabling a smoother user experience across diverse sites.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Sep 2025 10:22:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"Open Channels FM: Building a Resilient Web with Arweave’s Vision for Decentralized Long-Term Content Storage\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=108589\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"https://openchannels.fm/building-a-resilient-web-with-arweaves-vision-for-decentralized-long-term-content-storage/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:201:\"The episode features Dave Lockie having a conversation with Sam Williams about Arweave, a decentralized storage network addressing digital impermanence and promoting permanent information preservation.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 03 Sep 2025 09:45:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Matt: Are you a WordPresser?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=149276\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://ma.tt/2025/09/wordpresser/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2020:\"<p>You might be a WordPresser if&#8230;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>You like to have freedom and control over all your software.</li>\n\n\n\n<li>You don’t mind taking a bit more time to invest in tools that give you agency.</li>\n\n\n\n<li>You like inserting little opportunities for joy in everyday interfaces.</li>\n\n\n\n<li>You want future generations to grow up with a free and open web.</li>\n\n\n\n<li>You like to tinker, hack, mod, customize, and share what you learn.</li>\n\n\n\n<li>You are impeccable with your word.</li>\n\n\n\n<li>You think software should have a little soul in it.</li>\n\n\n\n<li>You love giving other people superpowers, teaching them not to need you anymore.</li>\n\n\n\n<li>You appreciate a good plan but want to be able to color outside the lines, or completely reimagine the canvas altogether.</li>\n\n\n\n<li>You think technology is best when it brings people together.</li>\n\n\n\n<li>You get excited by updates.</li>\n\n\n\n<li>You want your corner of the web to truly be yours, not generic or commoditized slop.</li>\n\n\n\n<li>Your friends come to you to learn about new stuff.</li>\n\n\n\n<li>You leave things better than you find them.</li>\n\n\n\n<li>You fix things as you find them, it’s never someone else’s problem.</li>\n\n\n\n<li>You know a single comment can light up someone’s day.</li>\n\n\n\n<li>You’ve gotten out of the house to meet other people into WordPress.</li>\n\n\n\n<li>There’s a Wapuu item or sticker somewhere in your life.</li>\n\n\n\n<li>You “view source.”</li>\n\n\n\n<li>You know the difference between owning your content and being a digital sharecropper.</li>\n\n\n\n<li>You’ve drunkenly registered a domain, and have more domains than websites.</li>\n\n\n\n<li>You’ve snuck an easter egg in a slug.</li>\n\n\n\n<li>You have a Gravatar, and it’s also a museum of all your email identities over the years.</li>\n\n\n\n<li>You think code can be poetry.</li>\n</ul>\n\n\n\n<p>If you identified with two or more of these statements, I am afraid to inform you might be classified as a WordPresser. What did I miss?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Sep 2025 21:50:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"Gutenberg Times: Why WordPress Core needs more blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=41679\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://gutenbergtimes.com/why-wordpress-core-needs-more-blocks/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11441:\"<p>Over the years, I have been an ardent supporter of keeping WordPress lean and letting plugins and themes do all the fun, custom stuff. But the block paradigm shifted everything. And moreso, it shifted everything about building WordPress themes.</p>\n\n\n\n<p>Today, my perspective has changed, and I’ve nestled into the camp of those calling for more blocks in WordPress.</p>\n\n\n\n<p>Let me explain why.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A journey</h2>\n\n\n\n<p>Let’s jump back in time for a moment. Three and a half years ago, just before the release of WordPress 5.9, themers were in complete control of the front-end output of WordPress sites. </p>\n\n\n\n<p>Well, that’s a bit of a stretch. They were actually in control of everything but the content. Of that, they mostly had styling control. It was much like the previous 18 years where you would have the freedom and flexibility to build whatever you wanted. </p>\n\n\n\n<p>But in the few years leading up to that point, the landscape had begun changing. Themes had to be compatible with new types of output beyond the basic paragraphs, headings, lists, and media. The Block Editor had been on the scene for a while before WordPress 5.9, but theme authors still exercised almost all the control they had in the past.</p>\n\n\n\n<p>Once you started building block themes, suddenly what was possible shrank very, very quickly.</p>\n\n\n\n<p><em>Want to include breadcrumbs?</em> You need to add support for a <a href=\"https://wordpress.org/plugins/x3p0-breadcrumbs/\">breadcrumbs block</a>, but which one?</p>\n\n\n\n<p><em>Need an accordion?</em> Maybe you could manipulate the Details block, but that may not be <a href=\"https://core.trac.wordpress.org/ticket/60335\">an accessible approach</a>.</p>\n\n\n\n<p><em>How about including SVG icons?</em> You guessed it; you need an <a href=\"https://wordpress.org/plugins/icon-block/\">icon block</a> for that.</p>\n\n\n\n<p>And have you ever experienced what the UI looks like when a user doesn’t have a supported block installed?</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"WordPress post editor that shows a Table of Contents block that is not installed. It includes a message that the site doesn\'t support the block.\" class=\"wp-image-41680\" height=\"340\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/09/toc-no-block.webp?resize=652%2C340&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p><em>Eeeek!</em></p>\n\n\n\n<div class=\"wp-block-genesis-blocks-gb-notice gb-font-size-18 gb-block-notice\" style=\"color: #32373c; background-color: #3373dc;\"><div class=\"gb-notice-text\" style=\"border-color: #3373dc;\">\n<p>I’d also like to take this moment to point out that you are not allowed to bundle custom blocks in themes submitted to the official WordPress theme directory. There are <em>very</em> good reasons for this that I won’t dive into. I’m including this side note merely for context.</p>\n</div></div>\n\n\n\n<p>Gone were the days where you could just include anything and everything. It’s like painting on a canvas with a limited color palette and set of brushes when you previously had every tool at your disposal.</p>\n\n\n\n<p>Now, truly great artists can make magic happen regardless of the tools. Things like the <a href=\"https://developer.wordpress.org/news/tag/block-bindings/\">Block Bindings API</a> can fill in some of the gaps. But some features are just darn hard without a dedicated block.</p>\n\n\n\n<p>Before block themes, theme authors enjoyed loads of new features over the years, but how and what you could build mostly remained static, the only limitation being the technology of the day. Block themes created the potential for more people to take that first step into the world of theming without knowing any code whatsoever. And they introduced the standards that so many of the inner community had called on for so long, created better interoperability with plugins, and brought contemporary technologies to WordPress.</p>\n\n\n\n<p>But the cost was a limited toolset that required new ways of thinking from us old timers who’d been merrily doing our own thing for so long.</p>\n\n\n\n<p>It’s an exciting world, but it could be more exciting in the next stage of this journey.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The case for more Core blocks</h2>\n\n\n\n<p>I am a developer. I love tinkering with anything and everything. I even dabble in creating custom plugins, but my true passion is creating WordPress themes. I’ve probably written just as much on the subject as anyone over the years. It’s safe to say that I know the technical limitations of block theming as much as anyone can reasonably be expected to (though I’m still learning new things all the time).</p>\n\n\n\n<p>So when Matías Ventura, the Project Architect of Gutenberg, opened a <a href=\"https://github.com/WordPress/gutenberg/issues/71026\">ticket calling for more niche blocks</a> in WordPress, it piqued my interest. The list of potential blocks were:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/16484\">Icons</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/805\">Playlist</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/43369\">Slider/Carousel</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/71017\">Stretchy Text</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/34079\">Tabs</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/21584\">Accordion</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/23745\">Mega Menus</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/47198\">MathML</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/41730\">Marquee</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/42229\">Table of Contents</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/53776\">Time to Read</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/21943\">Breadcrumbs</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/61297\">Dialog</a></li>\n</ul>\n\n\n\n<p>Admittedly, I chuckled at the thought of a Stretchy Text block actually being included in Core. But the more I dug into what it takes to actually implement the design, I could see the case for it. I certainly don’t see a good way of using it in a theme design pattern without a dedicated block.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"WordPress post editor that displays a green gradient background in the content canvas. Across the top is demo text that stretches from the far left to far right of the screen, creating a stretchy text effect.\" class=\"wp-image-41682\" height=\"340\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/09/stretchy-text.webp?resize=652%2C340&#038;ssl=1\" width=\"652\" /><figcaption class=\"wp-element-caption\">The <a href=\"https://specialprojects.automattic.com/tools/stretchy-type/\">Stretchy Type block</a> from the Automattic Special Projects team.</figcaption></figure>\n\n\n\n<p>And marquees? Were they not relegated to a long dead era when Geocities ruled the blogosphere? I miss the old days of the wild and wacky web. <em>Could be fun.</em> <img alt=\"🤔\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f914.png\" style=\"height: 1em;\" /></p>\n\n\n\n<p>It’s easy to get tangled up in the weeds, using the most niche blocks as arguments against components like accordions, tabs, dialogs, and table of contents, which are standard pieces of the web as we know it today.</p>\n\n\n\n<p>If you recall, I said earlier that I was a longtime supporter of keeping Core lean. The old WordPress was very much a development framework. But as a theme author in the block theme era, I’ve moved much closer to the thoughts that Ventura espoused:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>I think not having these blocks in the core library severely limits the expressiveness that theme builders (and users) can depend upon to build great designs and it can fracture the overall experience.</p>\n</blockquote>\n\n\n\n<p>There have been many moments in the last three years where I’d have 95% of the work done, speeding toward the finish line of a block theme project. Then I’d smash into a brick wall. Quite often that wall was a missing design component. </p>\n\n\n\n<p>I’ve been in the development game long enough to find workarounds, but it’s been at the expense of untold hours of development time that could’ve been better spent elsewhere.</p>\n\n\n\n<p>And if I’m at the top of my game, what hope is there for newcomers who have bright ideas and big dreams? Will they be able to build that unique design they have in mind? Or will they switch to another platform?</p>\n\n\n\n<p><em>So…I want more blocks. </em></p>\n\n\n\n<p>I want more possibilities. </p>\n\n\n\n<p>I want to make ideas come to life without spending a week figuring out how to pigeonhole some feature into a place it doesn’t belong just to make things work.</p>\n\n\n\n<h2 class=\"wp-block-heading\">To include or not include</h2>\n\n\n\n<p>I hope that you at least agree on one point: For block theming to progress, WordPress needs a mechanism for theme authors to fully express their ideas. </p>\n\n\n\n<p>Everything beyond that is implementation details. Ventura’s <a href=\"https://github.com/WordPress/gutenberg/issues/71026\">proposal for additional blocks</a> has garnered a lot of discussion over the past month both in the ticket and elsewhere around the community. There’s wide agreement and disagreement on some or all points.</p>\n\n\n\n<p>Chiefly, whether the more niche blocks should be bundled is of concern. Things like future compatibility, potential legacy baggage, and bundle size are worth discussing. There’s also the potential for <a href=\"https://github.com/WordPress/gutenberg/issues/58773\">Core/Canonical blocks</a> that Ventura proposed in 2024, a set of blocks built and maintained by WordPress contributors but not shipped with the platform itself. I’d even be happy with a method of auto-installing supported blocks when a user activates a theme.</p>\n\n\n\n<p>Frankly, I don’t much care how we get there—just that we do. And I hope that god-forsaken “your site doesn’t include support for the [name] block” message never graces the screen of one of my theme’s users.</p>\n\n\n\n<p>Let me bundle patterns with icons that users can swap out as needed:</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"WordPress post editor that displays a three-column grid design with an SVG image placeholder, heading, and text.\" class=\"wp-image-41683\" height=\"340\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/09/icon-block.webp?resize=652%2C340&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p>Let me create accessible accordions without manipulating the Details block:</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img alt=\"WordPress post editor that shows multiple Details block in an accordion-like design.\" class=\"wp-image-41684\" height=\"340\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2025/09/details-accordion.webp?resize=652%2C340&#038;ssl=1\" width=\"652\" /></figure>\n\n\n\n<p>Just let me create something beautiful.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to Birgit Pauli-Haack, Anne McCarthy, and Héctor Prieto for feedback on this article before publishing.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Sep 2025 14:34:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Justin Tadlock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Open Channels FM: Why Companies Should Sponsor WordPress Contributors (And How To Start)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=105257\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://openchannels.fm/why-companies-should-sponsor-wordpress-contributors-and-how-to-start/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:189:\"WordPress is powered by a passionate community. Companies should sponsor contributors for goodwill, ecosystem health, and industry connections. Starting small is key to making a difference.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Sep 2025 09:53:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"Open Channels FM: Learn How WordPress Playground Revolutionizes Local Development Testing and Learning\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=108586\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://openchannels.fm/learn-how-wordpress-playground-revolutionizes-local-development-testing-and-learning/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:163:\"In this episode of The WordPress Way, Abha Thakor and Fellyph Cintra discuss WordPress Playground, its features, accessibility, and impact on developers and users.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Sep 2025 09:08:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Matt: Fact Checkers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=149253\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://ma.tt/2025/09/fact-checkers/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:765:\"<p>The New Yorker is always good, but they&#8217;re having a bit of a victory lap as they celebrate their centennial. <a href=\"https://www.newyorker.com/magazine/2025/09/01/the-history-of-the-new-yorkers-vaunted-fact-checking-department\">This article on the vaunted fact-checkers is such a delight</a>, with so many in-jokes and back references it&#8217;s hard to keep track. </p>\n\n\n\n<p>When I started WordPress, I wrote down five publications that I hoped someday we&#8217;d make software so good they&#8217;d adopt it. The New Yorker is one of them. If you enjoy words that make your brain tingle, make sure to also follow Automattic&#8217;s publications, <a href=\"https://longreads.com/\">Longreads</a> and <a href=\"https://magazine.atavist.com/\">Atavist</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 01 Sep 2025 21:10:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Aaron Jorbin: WP Book Club Week 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://aaron.jorb.in/?p=239215\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://aaron.jorb.in/wp-book-club-week-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2807:\"<p><em>If you signed up on the <a href=\"https://aaron.jorb.in/a-wordpress-book-club/\">original post</a>, you will also receive this info in an email.</em></p>\n\n\n\n<p>For week one of a <a href=\"https://aaron.jorb.in/a-wordpress-book-club/\">WordPress Book Club</a>, we will be discussing the <a href=\"https://producingoss.com/en/preface.html\">Preface</a> and <a href=\"https://producingoss.com/en/introduction.html\">Chapter 1. Introduction</a>. </p>\n\n\n\n<p>To start the club, we are going to do introductions. I&#8217;ll ask everyone to share their name and how long they have been involved in open source. We&#8217;ll do this <a href=\"https://www.facilitator.school/glossary/popcorn-style\">popcorn style</a>.</p>\n\n\n\n<p>Next I&#8217;ll quickly review some norms for this club:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Make Space </strong>for each other — Be conscious of how much you are speaking and encourage others to speak as well. While <a href=\"https://www.nytimes.com/2021/09/25/opinion/interrupting-cooperative-overlapping.html?searchResultPosition=1\">cooperative overlapping</a> is a conversation style that is natural to some, it&#8217;s one we should avoid in this context. </li>\n\n\n\n<li>Approach this club with <strong>enthusiastic collaboration </strong>— This is a phrase that I stole from the preface and is one of the ways that the author describes the unique culture of open source. In this context the phrase means to me that everyone is coming with a positive attitude and a desire to share and learn. We will all assume good intent since everyone is approaching this with good intent. </li>\n\n\n\n<li><strong>Camera On by default</strong>, no questions asked if camera is off — It&#8217;s easier and more engaging if we can see each other, so I want to encourage you to have your camera on, but there are also a multitude of reasons that you may want it off. You don&#8217;t need to explain why your camera is off, but if you can, please turn it on. </li>\n</ul>\n\n\n\n<p>After that we will get to the meat of the session, and discuss these two sections. I&#8217;ll bring a few questions to help get the discussion flowing, but I would also love if folks brought their own as well. Since the majority of participants don&#8217;t work in open source day in and day out, I expect some questions to be about ways to apply our learnings outside open source.</p>\n\n\n\n<p>Finally, I am going to encourage everyone to spend some time blogging their thoughts after the discussion. This can be a reaction to something you read or something discussed. It can be notes you took while reading, but I would like to encourage blogging. </p>\n<p>The post <a href=\"https://aaron.jorb.in/wp-book-club-week-1/\">WP Book Club Week 1</a> appeared first on <a href=\"https://aaron.jorb.in\">Aaron Jorbin</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 01 Sep 2025 18:51:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"jorbin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Matt: Summer WordPress Update\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=149189\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://ma.tt/2025/08/wcus-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1610:\"<p>I&#8217;m still buzzing from an incredible WordCamp US this week, from contributor day to the closing party the vibes were right and it was amazing to connect with fellow travelers in the journey towards creating a more free and open source internet.</p>\n\n\n\n<p>Before our open town hall Q&amp;A I was able to make some fun announcements:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Traffic to WordPress.org is up, and we&#8217;ve brought the plugin queue from months to basically a few days.</li>\n\n\n\n<li>Previewed Block Comments and the upcoming Command Palette feature in 6.9.</li>\n\n\n\n<li>Shared some fun AI experiments, including <a href=\"https://github.com/felixarntz/wp-ai-sdk-chatbot-demo\">Felix&#8217;s AI chatbot demo</a>, <a href=\"https://telex.automattic.ai/\">Automattic&#8217;s new Telex block creator</a>, and more.</li>\n\n\n\n<li>Got to announce details for the next two flagships:\n<ul class=\"wp-block-list\">\n<li><strong>WordCamp Asia 2026</strong>: Mumbai, India, from April 9<sup>th</sup> to 11<sup>th</sup>.</li>\n\n\n\n<li><strong>WordCamp Europe 2026</strong>: Kraków, Poland. June 4<sup>th</sup> to 6<sup>th</sup>  2026.</li>\n\n\n\n<li><strong>WordCamp US 2026</strong>: Phoenix, Arizona, from August 16<sup>th</sup> to 19<sup>th</sup>. <img alt=\"😅\" class=\"wp-smiley\" src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f605.png\" style=\"height: 1em;\" /></li>\n</ul>\n</li>\n</ul>\n\n\n\n<p>Give it a watch!</p>\n\n\n\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 31 Aug 2025 03:25:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WordPress.org blog: Portland Welcomes WordCamp US 2025: A Community Gathering\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=19074\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/news/2025/08/portland-welcomes-wcus-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:33664:\"<p>A full house of attendees gathered in Portland, Oregon, for WordCamp US 2025, with thousands more tuning in online. Over four days, the flagship WordPress event brought together contributors, innovators, and community members for collaboration, inspiration, and discovery.</p>\n\n\n\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-6c531013 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-pullquote\"><blockquote><p>WordPress is so unique because we&#8217;re not just a product; we&#8217;re a movement.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>The WordPress event began with a dedicated Contributor Day and continued with a Showcase Day and two days of sessions filled with talks, panels, workshops, and community celebrations. WordPress Cofounder Matt Mullenweg joined a diverse lineup of speakers, panelists, and workshop leaders who brought fresh perspectives to the open web from across the globe.</p>\n\n\n\n<p>Set against the vibrant backdrop of Portland — with its iconic bridges, coffee culture, and creative energy — the Sponsor Hall buzzed as companies across the WordPress ecosystem demoed new products, shared insights, and connected with attendees. Each day offered opportunities to refuel with local flavors and international favorites, turning mealtimes into lively hubs of networking and idea-sharing.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Global Gathering in Portland</h2>\n\n\n\n<p>WordCamp US is the annual gathering point for the WordPress community — where collaboration, creativity, and innovation intersect. This year in Portland, the event delivered an expansive program that reached every corner of the ecosystem.</p>\n\n\n\n<p>Here’s what attendees experienced:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Engaging Sessions Across Tracks</strong> – Keynotes, presentations, and discussions explored the evolving web and the role of open source in shaping it.</li>\n\n\n\n<li><strong>A Global Speaker Lineup</strong> – Voices from across continents brought local stories and global visions to the stage.</li>\n\n\n\n<li><strong>Wide-Ranging Topics</strong> – From AI in WordPress development to accessibility, design systems, content strategy, education, and case studies of WordPress at scale.</li>\n\n\n\n<li><strong>Hands-On Learning Opportunities</strong> – Workshops provided practical takeaways, empowering attendees to apply new skills immediately.</li>\n\n\n\n<li><strong>A Community Built on Collaboration</strong> – Whether contributing code, exploring business strategies, or sharing creative projects, attendees found space to learn, grow, and celebrate open source together.</li>\n</ul>\n\n\n\n<p>New contributors took their first steps into open source, seasoned developers explored cutting-edge AI integrations, and agencies and product teams shared strategies for scaling WordPress to meet modern needs. Beyond the technical, conversations around inclusivity, sustainability, and education underscored WordPress’s role as a tool for empowerment and positive change.</p>\n\n\n\n<p>In hallways, coffee lines, and evening meetups, attendees found the “hallway track” alive and well, spontaneous moments of connection that often became the most memorable part of the experience. Whether reconnecting with longtime collaborators or meeting someone new, these small interactions reinforced the heart of WordCamp US: a community that thrives on openness, generosity, and shared purpose.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day: Collaboration at the Core</h2>\n\n\n\n<p>The conference opened on Tuesday, August 26, with a vibrant Contributor Day. Nearly 300 contributors filled the space, including more than 120 first-time participants who were onboarded across 19 teams. Developers, designers, translators, marketers, and community organizers worked side by side, representing WordPress expertise.</p>\n\n\n\n<p>Throughout the day, contributors tackled everything from improving accessibility and performance to refining documentation to enhancing translation tools. Beyond technical contributions, teams like Marketing and Community focused on outreach, mentoring, and shaping future-facing initiatives. Remote participants joined via dedicated channels, reinforcing the inclusive nature of WordPress’s global community. By day’s end, the collective energy was clear: WordPress continues to be built by and for everyone.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width: 20px; border-radius: 2px;\">\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19080\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5641.jpg?resize=1024%2C683&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19081\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5630.jpg?resize=1024%2C683&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19087\" height=\"2560\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8717-2-scaled.jpg?fit=683%2C1024&amp;ssl=1\" width=\"1707\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19084\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633022.jpg?resize=1024%2C683&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19082\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_5634.jpg?resize=1024%2C683&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19085\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z632926.jpg?resize=1024%2C683&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19086\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633226-1.jpg?resize=1024%2C683&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19090\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Z633121.jpg?resize=1024%2C683&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19089\" height=\"1707\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8723-scaled.jpg?fit=1024%2C683&amp;ssl=1\" width=\"2560\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19092\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8841.jpg?resize=1024%2C683&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19088\" height=\"1707\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8753-1-scaled.jpg?fit=1024%2C683&amp;ssl=1\" width=\"2560\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19091\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8827.jpg?resize=1024%2C683&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19083\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC8887-2.jpg?resize=1024%2C683&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>The mix of experience in the room made this year especially notable. First-time contributors were paired with seasoned table leads who guided them through their first steps into open source contribution. Longtime contributors reconnected with their teams and advanced ongoing initiatives, while new voices added fresh perspectives and momentum. The spirit of mentorship was woven throughout, ensuring that Contributor Day was productive and welcoming.</p>\n\n\n\n<p>The results spoke for themselves:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Polyglots</strong> translated more than 12,000 strings, expanding WordPress’s accessibility worldwide.</li>\n\n\n\n<li>The <strong>Community team</strong> celebrated the approval of two brand-new local meetups.</li>\n\n\n\n<li>The <strong>Training team</strong> achieved its objective of updating outdated course thumbnails.</li>\n\n\n\n<li>The <strong>Core team</strong> worked through a live bug scrub, with 9 committers and 16 contributors collaborating on improvements.</li>\n\n\n\n<li>The <strong>Documentation team</strong> completed numerous content updates to keep resources fresh and reliable.</li>\n</ul>\n\n\n\n<p>Momentum carried through every table, with participants reporting measurable progress and a renewed sense of shared purpose. Contributor Day once again highlighted the unique power of collaboration in shaping the open web, proving that every contribution matters through code, translations, training, or community building.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Showcase Day: WordPress in Action</h2>\n\n\n\n<p>Wednesday, August 27, was the popular Showcase Day, spotlighting real-world innovation in WordPress. Initially expected to draw about 250 participants, Showcase Day welcomed more than 800 attendees — a powerful sign of how much energy and curiosity the community brought to Portland. The sessions demonstrated how WordPress powers meaningful work across industries from nonprofits to newsrooms, agencies to global enterprises, while staying true to open source values.</p>\n\n\n\n<p>The day opened with a keynote by Amy Sample Ward: <em>The Tech That Comes Next</em>. Drawing from their co-authored book with Afua Bruce, Amy highlighted the inequities embedded in today’s technologies — from dataset bias to accessibility gaps — and challenged attendees to rethink how tools are funded, built, and deployed. Their talk invited technologists, funders, and community leaders to imagine a more equitable digital future, rooted in collaboration and shared responsibility.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>From there, <a href=\"https://youtu.be/PGvh7fCOUk0\">Joeleen Kennedy</a> of Human Made shared how Full Site Editing (FSE) shapes the refresh of Wikimedia’s ongoing user experience. Her session <em>Modernizing at Scale</em> detailed how FSE is simplifying workflows, improving accessibility, and making the multilingual platform more sustainable for the long term. Attendees gained a behind-the-scenes look at how one of the world’s largest open knowledge platforms is leveraging WordPress innovation.</p>\n\n\n\n<p><a href=\"https://youtu.be/F4NEPcwGRCI\">Josh Bryant</a> took the stage to explore what happens when Gutenberg leaves the WP-Admin dashboard. His talk, <em>Reimagining WordPress Editing</em>, walked through embedding the block editor into a standalone React application to support Dow Jones’s newsroom workflows. From decoupling Gutenberg to managing custom data stores, the session showcased advanced techniques for scaling editorial tools while maintaining the flexibility of the WordPress ecosystem.</p>\n\n\n\n<p>Hands-on learning was a hallmark of Showcase Day, with Jamie Marsland’s workshop leading participants through building and launching their own professional portfolio sites — no coding required. Attendees left with a fully functioning site, demonstrating WordPress’s continued ability to empower anyone, anywhere, to publish online.</p>\n\n\n\n<p>In the afternoon, Jeffrey Paul’s session <em>Scalable, Ethical AI</em> addressed one of the most pressing topics in today’s digital world: how to integrate AI without sacrificing ownership, privacy, or open standards. Walking participants through practical use cases with ClassifAI and local LLMs, Paul emphasized how WordPress can help content creators harness AI while maintaining autonomy over their data.</p>\n\n\n\n<p>The day closed with a forward-looking community highlight: <a href=\"https://events.wordpress.org/campusconnect/\">WordPress Campus Connect</a>. Panelists <a href=\"https://youtu.be/ARqM9U0ESvo\">Destiny Kanno, Andrés Parra, Javier Montes de Blas, Mauricio Barrantes, and Elineth Morera Campos</a> shared how this initiative brings WordPress into classrooms and universities worldwide. Student Andrés Parra received a scholarship to attend WordCamp. During the panel, Elineth also announced that Fidélitas University will begin offering its students a <a href=\"https://wordpress.org/news/2025/07/introducing-wordpress-credits-a-new-contribution-internship-program-for-university-students/\">WordPress Credits</a> program starting in October 2025, making it a mandatory addition sometime in 2026, enabling them to contribute directly to WordPress as part of their studies.</p>\n\n\n\n<p>By connecting students and educators with the open web, Campus Connect is building the next generation of contributors and innovators, ensuring that WordPress remains both a learning tool and a pathway to opportunity.</p>\n\n\n\n<p>Taken together, Showcase Day affirmed that WordPress is more than just a CMS — it is a platform for equitable technology, global collaboration, cutting-edge enterprise solutions, and the future of digital education. WordPress has the power to be both a platform and a community tool for education, equity, and innovation.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Presentation Days: Learning, Inspiration, and Connection</h2>\n\n\n\n<p>The first full day of sessions at WordCamp US 2025 opened with warm remarks from the organizing team, who reminded attendees: <em>“The most important thanks goes to all of you. The mix of new energy and veteran experience is what makes WordCamp so special, so thank you for being here.”</em> That spirit of gratitude and community carried throughout the event.</p>\n\n\n\n<p>The Sponsor Hall became a hub of activity, complete with raffles, the return of Career Corner, and even a Voodoo Donut Truck parked outside. Attendees lined up to test their luck at a claw machine stuffed with plush Wapuus, while others sought guidance at the Happiness Bar — a hands-on help desk for WordPress questions big and small. Between these activities, the steady buzz of conversations made it clear: the “hallway track” remained one of WordCamp’s most valuable experiences.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>The program itself set a high bar. Danny Sullivan’s keynote shed light on how search has evolved to meet the needs of new generations, from 24/7 demand and mobile expectations to short-form video and AI. His session gave attendees a deeper understanding of how search intersects with publishing today and sparked conversations about how WordPress can continue adapting in an era where AI shapes discovery and content.</p>\n\n\n\n<p>From there, the schedule unfolded across multiple tracks. The Core AI panel — featuring <a href=\"https://youtu.be/v_0O6dQ4Q4E\">James LePage, Felix Arntz, and Jeffrey Paul</a> — offered a look into how AI tools are woven into WordPress core. Emphasizing ethics, transparency, and user empowerment, the panel painted a roadmap for how WordPress can adopt new technologies without compromising its open-source values.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img alt=\"\" class=\"wp-image-19103\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/Programming-Day-1-2.jpg?resize=1024%2C576&#038;ssl=1\" width=\"1024\" /></figure>\n\n\n\n<p>Hands-on learning played a significant role throughout the conference. Ryan Welcher’s interactive <em>Block Developer Cookbook</em> drew a packed room as participants worked through community-selected code recipes built on the latest WordPress APIs. By the end, attendees left with working examples and practical strategies they could bring back to their projects.</p>\n\n\n\n<p>The program also highlighted diverse technical perspectives. <a href=\"https://youtu.be/vBjNqdacbh4\">Jemima Abu’s</a> session, <em>A PHP Developer’s Guide to ReactJS</em>, bridged the gap between classic and modern web development. At the same time, Adam Gazzaley’s keynote, <em>A New Era of Experiential Medicine – AI and the Brain</em>, invited attendees to consider the human side of technology, exploring how digital tools can advance health and well-being.</p>\n\n\n\n<p>The second day of presentations, Friday, August 29, opened with creativity and imagination. <a href=\"https://youtu.be/O7FPiFpRI3o\">John Maeda’s</a> keynote, <em>Cozy AI Cooking: WordCamp Edition</em>, used the metaphor of a kitchen to demystify AI, blending storytelling with technical insight to show how curiosity and care can guide builders in integrating AI into their work.</p>\n\n\n\n<p>Later in the day, <a href=\"https://youtu.be/ORnJTpjA-4w\">Tammie Lister’s</a> <em>The System is the Strategy</em> illustrated how design systems provide structure and scalability for growing WordPress projects. At the same time, Adam Silverstein’s Unlock Developer Superpowers with AI showcased new ways developers can use emerging tools to speed up workflows and problem-solving.</p>\n\n\n\n<p>Community stories also took center stage. In Creators around a Campfire, Anne McCarthy, Jamie Marsland, Christian Taylor, Mark Szymanski, and Michael Cunningham reflected on how YouTubers and content creators shape the WordPress ecosystem. Their session highlighted the role of storytelling and education in expanding WordPress’s reach to new audiences worldwide.</p>\n\n\n\n<p>The Sponsor Hall remained lively between sessions — with attendees meeting companies, testing demos, and swapping ideas that extended far beyond the conference halls. They also shared moments together at the arcade built for the event and added smiles, hugs, and laughter, which underscored the atmosphere: WordCamp US was as much about connection as code.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Together Into the Future</h2>\n\n\n\n<p>As the event drew to a close, WordPress Cofounder Matt Mullenweg took the stage to share the current state of WordPress and a vision for its future. He highlighted the growth in social media for WordPress with 124,726 new followers since last WCUS — and the WordPress.org website growing over 10% in users along with almost 20% in new users. </p>\n\n\n\n<p>Matt also spotlighted community initiatives shaping the future of open source education and diversity: WordPress Campus Connect, which has already reached 570 students across 11 events. Combined with the growth in overall events (77) which is a 32.76% increase over 2024. Each effort reinforced the message that WordPress is more than software; it is a global movement driven by people.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>He concluded with a live Q&amp;A, fielding questions from the audience on the direction of WordPress, its role in an AI-driven web, and the importance of keeping the project open, inclusive, and adaptable. The final notes of the keynote carried into a closing party in downtown Portland, where attendees capped off the week with music, conversation, and the unmistakable joy of a community coming together.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Closing</h2>\n\n\n\n<p>WordCamp US 2025 once again demonstrated what makes the WordPress ecosystem extraordinary: a community committed to building tools, resources, and opportunities that empower people everywhere.</p>\n\n\n\n<p>This year also marked the debut of the <a href=\"https://airtable.com/appWF6hdXuEOFQMvV/shrV5RZIv0aJjjU00\">Open Horizons Scholarship</a>, which funded six recipients — two organizers, three volunteers, and one speaker — from five countries. A total of $14,670 supported their journeys to WCUS. The scholarship, which also supports participation at WordCamp Asia and WordCamp Europe, is designed to make flagship events more accessible to contributors worldwide.</p>\n\n\n\n<p>A heartfelt thank you goes to the organizers, volunteers, sponsors, and speakers who brought the Portland edition to life — and to every attendee who joined us in person or followed along online. We hope you leave with fresh ideas, meaningful connections, and renewed energy to help shape the future of the open web.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-black-background-color has-background wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-width: 20px;\">\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19112\" height=\"577\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_215948.jpg?resize=1024%2C577&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19124\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6997.jpeg?resize=1024%2C576&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19122\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_7014.jpeg?resize=1024%2C576&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19107\" height=\"577\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250826_101752.jpg?resize=1024%2C577&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19108\" height=\"675\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/20250825_113602.jpg?resize=1024%2C675&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Gale Wallace</figcaption></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19113\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC9076.jpeg?resize=1024%2C683&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19106\" height=\"433\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6809.jpeg?resize=1024%2C433&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19110\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/DSC04553.jpg?resize=1024%2C683&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19119\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG_6827.jpeg?resize=1024%2C576&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Topher DeRosia</figcaption></figure>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-19133\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/08/IMG-20250829-WA0024.jpg?resize=1024%2C576&#038;ssl=1\" width=\"1024\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>Be sure to mark your calendars for the next global gatherings: <a href=\"https://asia.wordcamp.org/2026/\">WordCamp Asia 2026</a>  in Mumbai, India, <a href=\"https://europe.wordcamp.org/2026/\">WordCamp Europe 2026</a>  in Kraków, Poland, and WordCamp US 2026 in Phoenix, Arizona. We can’t wait to see you at the next chapter of the WordPress story.</p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Aug 2025 03:03:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"Open Channels FM: WordCamp Gdynia 2025 Is Speaking More Than One Language\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=108652\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://openchannels.fm/wordcamp-gdynia-2025-is-speaking-more-than-one-language/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:370:\"Something exciting is happening at WordCamp Gdynia 2025 on September 26–28, 2025 and it’s bigger than the coffee breaks and after-party combined. For the first time, the event will feature sessions in both Polish and English. Last year, the organizers noticed something interesting. In the hallways, at the sponsor tables, even over lunch, people naturally [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 29 Aug 2025 08:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Matt: Think Different\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=149110\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://ma.tt/2025/08/think-different/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2050:\"<p>Pretty heads down at WordCamp US, which has had amazing energy and talks so far. I wanted to take a moment to note two things, first being <a href=\"http://scripting.com/2025/08/28/140604.html?title=thinkDifferentAboutWordpress\">a great essay from Dave Winer asking people to Think Different about WordPress</a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>I&#8217;ve done this before &#8212; asked people to think differently about things, like public writing, with blogging. In the 90s I was running around the Vallley trying to explain to everyone that blogging was going to change everything, all I got was blank stares from people who said &#8220;we don&#8217;t do that.&#8221; They of course eventually did do it. But at first the ideas seemed foreign, unreasonable.</p>\n</blockquote>\n\n\n\n<p>And in light of the <a href=\"https://arstechnica.com/gadgets/2025/08/one-time-wordpress-competitor-typepad-ends-its-slide-into-obscurity-by-shutting-down/\">news of Typepad shutting down</a>, <a href=\"https://developer.wordpress.org/advanced-administration/wordpress/import/#movable-type-and-typepad\">note that WordPress has a Typepad importer</a>. A big advantage of putting your content into an open source platform like WordPress with an active community, vs just static pages or something custom, is that you&#8217;re getting constant upgrades &#8220;for free&#8221; as we maintain and iterate on the software, enabling new APIs or things like allowing your AI to talk to your site. </p>\n\n\n\n<p>WordPress is built by a community of people deeply passionate about backwards and forward compatibility, radical openness so it&#8217;s easy to get things in and out of it, and relentless iteration building for the long term. Despite literally billions of dollars spent trying to kill or crush WordPress, and frequent proclamations of its death, we keep trucking along and doing our darndest to make the web a bit more open and free every day. It&#8217;s a life mission of many people, including myself.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Aug 2025 20:08:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"Open Channels FM: Closing the Black Friday Prep Gap: Woo’s 2025 Survey Insights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://openchannels.fm/?p=108571\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://openchannels.fm/closing-the-black-friday-prep-gap-woos-2025-survey-insights/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:422:\"Woo’s latest merchant survey uncovers a growing “preparation gap” for Black Friday and Cyber Monday (BFCM). Larger merchants, especially those earning over $1M annually, are prioritizing website performance optimization over inventory management and preparing months ahead, while many smaller merchants still rely on traditional, last-minute tactics. The findings reveal key shifts shaping the 2025 holiday [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Aug 2025 14:26:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:21:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"Weston Ruter: The Site Speed Frontier with Performance Lab and Beyond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://weston.ruter.net/?p=35813\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:122953:\"<p>At WordCamp US 2025 this year, I&#8217;m presenting a talk called “<a href=\"https://us.wordcamp.org/2025/session/the-site-speed-frontier-with-performance-lab-and-beyond/\">The Site Speed Frontier with Performance Lab and Beyond</a>” with the following description:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>The Core Performance team has been incubating enhancements for WordPress through the Performance Lab plugin. These have been available for a few years now; some have been merged into core (e.g. Speculative Loading) while others are more experimental and remain in testing (e.g. Optimization Detective). This talk will look at how these performance plugins impact the speed of a stock WordPress site running the Twenty Twenty-Five default theme, using Core Web Vitals benchmarks and Lighthouse scores. It will also look at how the theme&#8217;s performance can be further tuned, including the use of core patches proposed for the next major release (also available in plugin form to leverage today) to further accelerate the loading of pages to improve the user experience of site visitors.</p>\n</blockquote>\n\n\n\n<p>Here&#8217;s my talk <a href=\"https://youtu.be/VHy_mRe1pek?si=UYzEccemyk4UXNOS\">from the WordPress YouTube channel</a> (also <a href=\"https://wordpress.tv/2025/09/03/the-site-speed-frontier-with-performance-lab-and-beyond/\">available on WordPress.tv</a>):</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n\n</div></figure>\n\n\n\n<p>And here are my <a href=\"https://docs.google.com/presentation/d/1KMnm49qF6F9AIkH7J4iyiiPbXGXZ-iq5fK2MYqLT_YU/edit?usp=sharing\">slides</a> as well:</p>\n\n\n\n<p></p>\n\n\n\n<p>And what follows is my talk in blog post form, greatly expanded with a lot more details than I had time to share during my talk.</p>\n\n\n\n<p>Table of contents:</p>\n\n\n\n<nav class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#performance-lab\">Performance Lab</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#case-study-twenty-twenty-five\">Case Study: Twenty Twenty-Five</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#performance-testing-methodology\">Performance Testing Methodology</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#largest-contentful-paint\">Largest Contentful Paint</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#benchmarking\">Benchmarking</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#analyzing-optimization-impact-on-lcp\">Analyzing Optimization Impact on LCP</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#image-placeholders\">Image Placeholders</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#modern-image-formats\">Modern Image Formats</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#enhanced-responsive-images\">Enhanced Responsive Images</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#image-prioritizer\">Image Prioritizer</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#responsive-image-prioritization\">Responsive Image Prioritization</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#background-image-prioritization\">Background Image Prioritization</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#speculative-loading\">Speculative Loading</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#view-transitions\">View Transitions</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#nocache-bfcache\">No-cache BFCache</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#script-module-deprioritization\">Script Module Deprioritization</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#minified-css-inlining\">Minified CSS Inlining</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://weston.ruter.net/2025/08/27/the-site-speed-frontier-with-performance-lab-and-beyond/#whats-next\">What&#8217;s Next</a></li></ol></nav>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance-lab\">Performance Lab</h2>\n\n\n\n<p>I&#8217;ve been a WordPress <a href=\"https://make.wordpress.org/core/handbook/about/organization/#committers\">core committer</a> for <a href=\"https://weston.ruter.net/2025/05/14/a-decade-as-a-core-committer-my-wordpress-contribution-history/\">over 10 years</a>, and since Spring 2023 I&#8217;ve been heavily involved on the <a href=\"https://make.wordpress.org/performance/handbook/about-the-team/\">Core Performance Team</a>. In addition to contributing patches directly to the WordPress core codebase, we also develop new performance optimizations in the form of feature plugins. We use our <a href=\"https://wordpress.org/plugins/performance-lab/\">Performance Lab</a> plugin as a way to collect the feature plugins we&#8217;re currently working on to facilitate discovery:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-plugin-directory wp-block-embed-plugin-directory\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://wordpress.org/plugins/performance-lab/\">Performance Lab</a></blockquote>\n</div></figure>\n\n\n\n<p>Most of these performance feature plugins are developed in the <a href=\"https://github.com/wordpress/performance\">WordPress/performance</a> monorepo on GitHub. In the same way as the Gutenberg plugin serves as a way to develop new editor features, the Performance Lab plugin is a way we incubate new performance features. It allows us to get feedback from users and test the impact prior to being proposed for merging into a new release of WordPress core when it gets rolled out to <a href=\"https://w3techs.com/technologies/overview/content_management\">~43%</a> of the web.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"case-study-twenty-twenty-five\">Case Study: Twenty Twenty-Five</h2>\n\n\n\n<p>The default theme for the current version of WordPress is <a href=\"https://wordpress.org/themes/twentytwentyfive/\">Twenty Twenty- Five</a>. Default themes in core basically encapsulate the latest and greatest in what WordPress has to offer in terms of features and performance. Indeed, <a href=\"https://wordpress.org/documentation/article/block-themes/\">block themes</a> are generally faster than classic themes (especially with page caching) for a few reasons, including:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Scripts and styles are <a href=\"https://make.wordpress.org/core/2021/07/01/block-styles-loading-enhancements-in-wordpress-5-8/\">selectively loaded</a> based on whether their blocks actually used on the page.</li>\n\n\n\n<li>Blocks are more likely to use the <a href=\"https://developer.wordpress.org/block-editor/reference-guides/interactivity-api/\">Interactivity API</a> which involves deferred <a href=\"https://make.wordpress.org/core/2024/03/04/script-modules-in-6-5/\">script modules</a> (which don&#8217;t block rendering) and <a href=\"https://developer.wordpress.org/block-editor/reference-guides/interactivity-api/core-concepts/server-side-rendering/\">server-side rendering</a>.</li>\n</ul>\n\n\n\n<p>So the Twenty Twenty-Five theme should be very fast, and indeed it is. But with Performance Lab features (and beyond), it can be made even faster.</p>\n\n\n\n<p>Your mileage will vary with other themes, either having an even greater impact or a lesser one. Every site is unique (hopefully!) and so the impact of optimizations depends on a page&#8217;s contents, how a theme is built, and which plugins are active. But in this post, I&#8217;ll show the impact of the optimizations in various page layouts of the Twenty Twenty-Five Theme.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance-testing-methodology\">Performance Testing Methodology</h2>\n\n\n\n<p>Perhaps the most popular way to analyze the performance of a webpage is to use <a href=\"https://developer.chrome.com/docs/lighthouse/overview/\">Lighthouse</a>, either <a href=\"https://developer.chrome.com/docs/lighthouse/overview#devtools\">in Chrome DevTools</a> or via the bottom half of <a href=\"https://pagespeed.web.dev/\">PageSpeed Insights</a>. Lighthouse allows you to test pages either as a desktop or mobile device, <a href=\"https://github.com/GoogleChrome/lighthouse#why-is-the-performance-score-so-low-it-looks-fine-to-me\">emulating</a> the viewport, CPU, and connection speed. Lighthouse is an important tool to get a sense of a page&#8217;s performance, but it has limitations. It captures data from a single page load on a simulated device. There is often <a href=\"https://github.com/GoogleChrome/lighthouse?tab=readme-ov-file#why-does-the-performance-score-change-so-much\">variability</a> in the results, and it also doesn&#8217;t reflect the experience of real users which is what you&#8217;d get from Real User Monitoring (RUM), such as in the <a href=\"https://developer.chrome.com/docs/crux\">Chrome User Experience Report</a> (CrUX)—shown in the first section of PageSpeed Insights. Lighthouse provides simulated <a href=\"https://web.dev/articles/lab-and-field-data-differences#lab_data\">lab data</a> whereas CrUX provides real <a href=\"https://web.dev/articles/lab-and-field-data-differences#field_data\">field data</a>, which is more accurate. Nevertheless, field data can take a long time to collect and it can be difficult to do A/B tests at scale to capture the before/after performance impacts. That said, CrUX is definitely used to track the performance of new WordPress releases overall, as <a href=\"https://felix-arntz.me/\">Felix Arntz</a> shared the <a href=\"https://make.wordpress.org/core/2023/12/19/wordpress-performance-impact-on-core-web-vitals-in-2023/\">WordPress performance impact on Core Web Vitals in 2023</a>. Felix also wrote up how to <a href=\"https://make.wordpress.org/core/2024/04/05/conducting-wordpress-performance-research-in-the-field/\">conduct WordPress performance research in the field</a>.</p>\n\n\n\n<p>For the purposes of measuring the impact of performance optimizations here, lab data will be more practical because the results are available in real time, without having to wait for real users to provide field data. And I&#8217;m interested in relative performance impacts, not necessarily absolute ones. </p>\n\n\n\n<p>Running a Lighthouse audit before and after a Performance Lab feature plugin is active is a way to measure the impact of the optimization. However, given variability in the results, it can be difficult to be certain of the improvement. A Lighthouse audit may no longer flag an area for improvement, but the overall Lighthouse score may be unchanged. Indeed, even a Lighthouse score of 100 doesn&#8217;t mean the page performance is “perfect”. As <a href=\"https://discuss.httparchive.org/t/lighthouse-scores-as-predictors-of-page-level-crux-data/2232#:~:text=Of%20the%20pages%20that%20got%20a%2090%2B%20in%20Lighthouse%20in%20September%2C%2043%25%20didn%E2%80%99t%20meet%20one%20or%20more%20CWV%20threshold.\">found</a> by Brendan Kenny:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Of the pages that got a 90+ in Lighthouse in September [2021], 43% didn’t meet one or more CWV threshold.</p>\n</blockquote>\n\n\n\n<figure class=\"wp-block-image aligncenter size-medium wp-lightbox-container\"><img alt=\"Lighthouse performance score of 100\" class=\"wp-image-36044 not-transparent\" height=\"236\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/lighthouse-performance-score-100.png?resize=300%2C236&#038;ssl=1\" width=\"300\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p>A great score—even 100—doesn&#8217;t mean there still isn&#8217;t a lot of room for improvement!</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"largest-contentful-paint\">Largest Contentful Paint</h3>\n\n\n\n<p>One of the main components in <a href=\"https://developer.chrome.com/docs/lighthouse/performance/performance-scoring\">calculating</a> Lighthouse&#8217;s Performance score is the <a href=\"https://web.dev/articles/lcp\">Largest Contentful Paint</a> (LCP) metric of <a href=\"https://web.dev/articles/vitals#core-web-vitals\">Core Web Vitals</a> (CWV). LCP metric is <a href=\"https://developer.chrome.com/docs/lighthouse/performance/performance-scoring\">weighted</a> at 25% of the total Lighthouse score. As noted in how <a href=\"https://developer.chrome.com/docs/lighthouse/performance/performance-scoring\">how Lighthouse scores are determined</a>:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>The metric value for LCP represents the time duration between the user initiating the page load and the page rendering its primary content. Based on real website data, top-performing sites render LCP in about 1,220ms, so that metric value is mapped to a score of 99.</p>\n</blockquote>\n\n\n\n<p>A 1.2 second LCP is 12 times slower than a 100 ms LCP, where 100 ms is a <a href=\"https://www.nngroup.com/articles/response-times-3-important-limits/#:~:text=0.1%20second%20is%20about%20the%20limit%20for%20having%20the%20user%20feel%20that%20the%20system%20is%20reacting%20instantaneously%2C%20meaning%20that%20no%20special%20feedback%20is%20necessary%20except%20to%20display%20the%20result.\">proposed</a> threshold for the user to perceive a reaction as being instantaneous. Nevertheless, a “good” LCP value is 2.5 seconds and below:</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full is-resized\"><img alt=\"LCP (Largest Contentful Paint). Graph showing Good, Needs Improvement, and Poor divided by 800 ms and 1800 ms thresholds.\" class=\"wp-image-35844\" height=\"192\" src=\"https://weston.ruter.net/wp-content/uploads/2025/08/good-lcp-values.svg\" style=\"width: 645px; height: auto;\" width=\"768\" /><figcaption class=\"wp-element-caption\">A good LCP value is 2.5 seconds or less. (Courtesy <a href=\"https://web.dev/articles/lcp\">web.dev</a>)</figcaption></figure>\n\n\n\n<p>The LCP metric can be further subdivided, with the first part represented by the <a href=\"https://web.dev/articles/ttfb\">Time To First Byte</a> (TTFB) metric. The longer it takes the server to respond with the generated HTML document, the more this will hurt the LCP metric. A slow TTFB means you are less likely to have a good LCP. If a site has a 1.5-second TTFB which needs improvement, then this leaves only 1 second for the LCP element to be rendered to get a good LCP metric. A good TTFB is considered to be about half that, at 800 ms and below:</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img alt=\"TTFB (Time To First Byte). Graph showing Good, Needs Improvement, and Poor divided by 800 ms and 1800 ms thresholds.\" class=\"wp-image-35845\" height=\"192\" src=\"https://weston.ruter.net/wp-content/uploads/2025/08/good-ttfb-values.svg\" style=\"width: 645px; height: auto;\" width=\"768\" /><figcaption class=\"wp-element-caption\">Good TTFB values are 0.8 seconds or less, and poor values are greater than 1.8 seconds. (Courtesy <a href=\"https://web.dev/articles/ttfb\">web.dev</a>)</figcaption></figure>\n\n\n\n<p>Unfortunately, in looking at HTTP Archive&#8217;s <a href=\"https://httparchive.org/reports/techreport/landing\">Tech Report</a>, as of July 2025, only <a href=\"https://httparchive.org/reports/techreport/tech?tech=ALL%2CWordPress&amp;geo=ALL&amp;rank=ALL&amp;good-cwv-over-time=TTFB&amp;client=desktop#comparison-good-cwvs\">31% of desktop clients</a> visiting WordPress sites experience a good TTFB, whereas it&#8217;s just <a href=\"https://httparchive.org/reports/techreport/tech?tech=ALL%2CWordPress&amp;geo=ALL&amp;rank=ALL&amp;good-cwv-over-time=TTFB&amp;client=mobile#comparison-good-cwvs\">24% for mobile clients</a>. This means it is all too likely that a 1.5-second TTFB is the norm for WordPress sites. This is in part what contributes to WordPress lagging behind most other CMSes for the LCP metric <a href=\"https://lookerstudio.google.com/s/k9MqdchHqw4\">on mobile</a> and <a href=\"https://lookerstudio.google.com/s/j4AmmUaraQM\">on desktop</a>, even about 10% below the average on all measured sites.</p>\n\n\n\n<p>In comparison with the other CWV metrics—<a href=\"https://web.dev/articles/cls\">Cumulative Layout Shift</a> (CLS) and <a href=\"https://web.dev/articles/inp\">Interaction to Next Paint</a> (INP)—WordPress is doing worse in terms of LCP, as evident in the metric passing rates from the following <a href=\"https://httparchive.org/reports/techreport/landing\">reports</a> on HTTP Archive:</p>\n\n\n\n<figure class=\"wp-block-table is-style-regular\"><table><thead><tr><th class=\"has-text-align-right\">Device</th><th class=\"has-text-align-center\">LCP</th><th class=\"has-text-align-center\">CLS</th><th class=\"has-text-align-center\">INP</th></tr></thead><tbody><tr><td class=\"has-text-align-right\"><a href=\"https://httparchive.org/reports/techreport/tech?client=mobile&amp;tech=WordPress&amp;geo=ALL&amp;rank=ALL&amp;page=1#good-cwvs\">Mobile</a></td><td class=\"has-text-align-center\">53%</td><td class=\"has-text-align-center\">83%</td><td class=\"has-text-align-center\">86%</td></tr><tr><td class=\"has-text-align-right\"><a href=\"https://httparchive.org/reports/techreport/tech?client=desktop&amp;tech=WordPress&amp;geo=ALL&amp;rank=ALL&amp;page=1#good-cwvs\">Desktop</a></td><td class=\"has-text-align-center\">64%</td><td class=\"has-text-align-center\">71%</td><td class=\"has-text-align-center\">98%</td></tr></tbody></table></figure>\n\n\n\n<p>Therefore, improving LCP remains the most important focus for performance optimizations in WordPress. So in this post I&#8217;ll focus on the LCP impact for the plugins featured in Performance Lab and some other changes proposed for WordPress 6.9.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"benchmarking\">Benchmarking</h3>\n\n\n\n<p>Because the Lighthouse score is variable and a 100 score merely reflects a “good” LCP, evaluating the performance benefit of an optimization requires measuring the LCP metric itself. Due to the variability in the metric, it&#8217;s important to obtain the median value of the LCP over many measurements. By capturing the median LCP value before and after an optimization is applied, the relative impact on performance can be measured.</p>\n\n\n\n<p>The tool I use for benchmarking LCP is in the <a href=\"https://github.com/GoogleChromeLabs/wpp-research\">GoogleChromeLabs/​wpp-research</a> repo, which my team developed when I was at Google. Specifically, I use the <code><a href=\"https://github.com/GoogleChromeLabs/wpp-research/tree/main/cli#benchmark-web-vitals\">benchmark-web-vitals</a></code> command which includes the ability to emulate mobile and desktop devices, network connections, and CPU speeds.</p>\n\n\n\n<p>Here&#8217;s an example command I use to benchmark two URLs emulating a mobile device on a Fast 4G connection, and compare their results:</p>\n\n\n<pre class=\"wp-block-code\"><span><code class=\"hljs language-javascript\">npm run research -- benchmark-web-vitals \\\n	--url=<span class=\"hljs-string\">\"http://localhost/?enable_plugins=none\"</span> \\\n	--url=<span class=\"hljs-string\">\"http://localhost/?enable_plugins=foo\"</span> \\\n	--number=<span class=\"hljs-number\">50</span> \\\n	--network-conditions=<span class=\"hljs-string\">\"Fast 4G\"</span> \\\n	--emulate-device=<span class=\"hljs-string\">\"Moto G4\"</span> \\\n	--diff \\\n	--output=md</code></span></pre>\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Helper mu-plugin to override active plugins via query vars\n<p>I threw this together to help me with benchmarking so that I didn&#8217;t have to manually activate/deactivate plugins constantly.</p>\n\n\n<pre class=\"wp-block-code\"><span><code class=\"hljs language-php\"><span class=\"hljs-meta\">&lt;?php</span>\n<span class=\"hljs-comment\">/**\n * Plugin Name: Active Plugins Override\n */</span>\n\n<span class=\"hljs-keyword\">namespace</span> <span class=\"hljs-title\">ActivePluginsOverride</span>;\n\n<span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> <span class=\"hljs-title\">get_always_active_plugins</span><span class=\"hljs-params\">()</span>: <span class=\"hljs-title\">array</span> </span>{\n	<span class=\"hljs-keyword\">return</span> <span class=\"hljs-keyword\">array</span>(\n		<span class=\"hljs-string\">\'user-switching/user-switching.php\'</span>\n	);\n}\n\nadd_filter(\n	<span class=\"hljs-string\">\'option_active_plugins\'</span>,\n	<span class=\"hljs-keyword\">static</span> <span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> <span class=\"hljs-params\">( $plugins )</span> </span>{\n		<span class=\"hljs-keyword\">return</span> array_unique( array_merge( $plugins, get_always_active_plugins() ) );\n	},\n	<span class=\"hljs-number\">100</span>\n);\n\n<span class=\"hljs-keyword\">if</span> ( <span class=\"hljs-keyword\">isset</span>( $_GET&#91;<span class=\"hljs-string\">\'disable_all_plugins\'</span>] ) || ( <span class=\"hljs-keyword\">isset</span>( $_GET&#91;<span class=\"hljs-string\">\'enable_plugins\'</span>] ) &amp;&amp; $_GET&#91;<span class=\"hljs-string\">\'enable_plugins\'</span>] === <span class=\"hljs-string\">\'none\'</span> ) ) {\n	add_filter( <span class=\"hljs-string\">\'option_active_plugins\'</span>, <span class=\"hljs-string\">\'__return_empty_array\'</span> );\n}\n\n<span class=\"hljs-keyword\">if</span> ( <span class=\"hljs-keyword\">isset</span>( $_GET&#91;<span class=\"hljs-string\">\'disable_plugins\'</span>] ) ) {\n	<span class=\"hljs-keyword\">if</span> ( is_array( $_GET&#91;<span class=\"hljs-string\">\'disable_plugins\'</span>] ) ) {\n		$disable_plugins = $_GET&#91;<span class=\"hljs-string\">\'disable_plugins\'</span>];\n	} <span class=\"hljs-keyword\">else</span> {\n		$disable_plugins = explode( <span class=\"hljs-string\">\',\'</span>, $_GET&#91;<span class=\"hljs-string\">\'disable_plugins\'</span>] );\n	}\n\n	add_filter(\n		<span class=\"hljs-string\">\'option_active_plugins\'</span>,\n		<span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> <span class=\"hljs-params\">( $active_plugins )</span> <span class=\"hljs-title\">use</span> <span class=\"hljs-params\">( $disable_plugins )</span> </span>{\n			<span class=\"hljs-keyword\">return</span> array_merge(\n				array_filter(\n					$active_plugins,\n					<span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> <span class=\"hljs-params\">( $active_plugin )</span> <span class=\"hljs-title\">use</span> <span class=\"hljs-params\">( $disable_plugins )</span> </span>{\n						$slug = strtok( $active_plugin, <span class=\"hljs-string\">\'/\'</span> );\n						<span class=\"hljs-keyword\">return</span> ! in_array( $slug, $disable_plugins );\n					}\n				),\n				get_always_active_plugins()\n			);\n		}\n	);\n}\n\n<span class=\"hljs-keyword\">if</span> ( <span class=\"hljs-keyword\">isset</span>( $_GET&#91;<span class=\"hljs-string\">\'enable_plugins\'</span>] ) ) {\n	<span class=\"hljs-keyword\">if</span> ( is_array( $_GET&#91;<span class=\"hljs-string\">\'enable_plugins\'</span>] ) ) {\n		$enable_plugins = $_GET&#91;<span class=\"hljs-string\">\'enable_plugins\'</span>];\n	} <span class=\"hljs-keyword\">else</span> {\n		$enable_plugins = explode( <span class=\"hljs-string\">\',\'</span>, $_GET&#91;<span class=\"hljs-string\">\'enable_plugins\'</span>] );\n	}\n\n	<span class=\"hljs-keyword\">if</span> ( count( array_intersect( $enable_plugins, <span class=\"hljs-keyword\">array</span>( <span class=\"hljs-string\">\'embed-optimizer\'</span>, <span class=\"hljs-string\">\'image-prioritizer\'</span> ) ) ) &gt; <span class=\"hljs-number\">0</span> ) {\n		$enable_plugins&#91;] = <span class=\"hljs-string\">\'optimization-detective\'</span>;\n		$enable_plugins&#91;] = <span class=\"hljs-string\">\'od-admin-ui\'</span>;\n	}\n\n	add_filter(\n		<span class=\"hljs-string\">\'option_active_plugins\'</span>,\n		<span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> <span class=\"hljs-params\">( $active_plugins )</span> <span class=\"hljs-title\">use</span> <span class=\"hljs-params\">( $enable_plugins )</span> </span>{\n			<span class=\"hljs-keyword\">return</span> array_filter(\n				$active_plugins,\n				<span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> <span class=\"hljs-params\">( $active_plugin )</span> <span class=\"hljs-title\">use</span> <span class=\"hljs-params\">( $enable_plugins )</span> </span>{\n					$slug = strtok( $active_plugin, <span class=\"hljs-string\">\'/\'</span> );\n					<span class=\"hljs-keyword\">return</span> in_array( $slug, $enable_plugins );\n				}\n			);\n		}\n	);\n}</code></span></pre></details>\n\n\n\n<p>This results in a table like the following, showing the median metrics for the number of requests to both URLs:</p>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals\"><table><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>436.1</td><td>438.6</td><td>+2.5</td><td>+0.6%</td></tr><tr><td>LCP</td><td>915.3</td><td>690.9</td><td>-224.4</td><td>-24.5%</td></tr><tr><td>TTFB</td><td>50.8</td><td>50.6</td><td>-0.2</td><td>-0.3%</td></tr><tr><td>LCP-TTFB</td><td>865.6</td><td>638.3</td><td>-227.3</td><td>-26.3%</td></tr></tbody></table></figure>\n\n\n\n<p>In this example, the LCP improved by ~25% by enabling the “foo” plugin, which is exactly the kind of performance improvement we&#8217;re looking for on the Core Performance Team. Note this “LCP-TTFB” metric is simply the LCP metric minus the TTFB metric; this allows for measuring the client-side contributions to LCP by discounting any server-side variability in generating the response. The LCP-TTFB metric is important considering the lack of page caching on a local environment, and that certain optimizations may increase TTFB when page caching is not involved. For WordPress to scale, it&#8217;s important to have some <a href=\"https://developer.wordpress.org/advanced-administration/performance/cache/\">page caching layer</a> in place.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"analyzing-optimization-impact-on-lcp\">Analyzing Optimization Impact on LCP</h2>\n\n\n\n<p>I&#8217;m going to analyze the impact of the following feature plugins featured in Performance Lab:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://weston.ruter.net/category/wordpress/feed/#image-placeholders\">Image Placeholders</a></li>\n\n\n\n<li><a href=\"https://weston.ruter.net/category/wordpress/feed/#modern-image-formats\">Modern Image Formats</a></li>\n\n\n\n<li><a href=\"https://weston.ruter.net/category/wordpress/feed/#enhanced-responsive-images\">Enhanced Responsive Images</a></li>\n\n\n\n<li><a href=\"https://weston.ruter.net/category/wordpress/feed/#image-prioritizer\">Image Prioritizer</a></li>\n\n\n\n<li><a href=\"https://weston.ruter.net/category/wordpress/feed/#speculative-loading\">Speculative Loading</a></li>\n\n\n\n<li id=\"view-transitions\"><a href=\"https://weston.ruter.net/category/wordpress/feed/#view-transitions\">View Transitions</a></li>\n</ul>\n\n\n\n<p>I&#8217;m not covering <a href=\"https://wordpress.org/plugins/performant-translations/\">Performant Translations</a> since it was mostly <a href=\"https://make.wordpress.org/core/2023/11/08/merging-performant-translations-into-core/\">merged</a> into core as of 6.5. I&#8217;m also not covering <a href=\"https://wordpress.org/plugins/embed-optimizer/\">Embed Optimizer</a> since it primarily helps with <abbr title=\"Interaction to Next Paint\">INP</abbr> by lazy-loading and <abbr title=\"Cumulative Layout Shfit\">CLS</abbr> by reserving space for resizing embeds; the LCP improvement is difficult to measure for embeds that appear in the initial viewport given their cross-origin nature. Lastly, I&#8217;m not covering <a href=\"https://wordpress.org/plugins/web-worker-offloading/\">Web Worker Offloading</a> since it is quite experimental and it is only related to <abbr title=\"Interaction to Next Paint\">INP</abbr>. However, I am going to cover enhancements beyond Performance Lab being targeted for WordPress 6.9:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://weston.ruter.net/category/wordpress/feed/#nocache-bfcache\">No-cache BFCache</a> (actually, brand new to Performance Lab)</li>\n\n\n\n<li><a href=\"https://weston.ruter.net/category/wordpress/feed/#script-module-deprioritization\">Script Module Deprioritization</a></li>\n\n\n\n<li><a href=\"https://weston.ruter.net/category/wordpress/feed/#minified-css-inlining\">Minified CSS Inlining</a></li>\n</ul>\n\n\n\n<p>The first four Performance Lab feature plugins are all related to images. In focusing on improving the LCP metric, this makes sense because images are the LCP element 73.3% of the time on mobile and 83.3% of the time on desktop, <a href=\"https://almanac.httparchive.org/en/2024/performance#lcp-content-types\">according</a> to Web Almanac 2024:</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large wp-lightbox-container\"><img alt=\"Bar chart showing the top LCP content types for desktop and mobile in 2024. For desktop, 83.3% of pages have images as the LCP content type, while 73.3% of mobile pages have images as their LCP content. Text accounts for 16.3% of LCP content on desktop and 26.3% on mobile. Inline images are rare, making up 0.3% of LCP content on desktop and 0.4% on mobile.\" class=\"wp-image-36050 not-transparent\" height=\"433\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/largest-contentful-paint-top-content-types.png?resize=700%2C433&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Top three LCP content types segmented by device.</figcaption></figure>\n\n\n\n<div class=\"wp-block-spacer\" style=\"height: 100px;\"></div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"image-placeholders\">Image Placeholders</h3>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-plugin-directory wp-block-embed-plugin-directory\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://wordpress.org/plugins/dominant-color-images/\">Image Placeholders</a></blockquote>\n</div></figure>\n\n\n\n<p>The <a href=\"https://wordpress.org/plugins/dominant-color-images/\">Image Placeholders</a> plugin, originally called “Dominant Color Images”, adds a non-transparent image&#8217;s dominant color as the background color. This improves the perceived page loading experience by showing <em>something</em> sooner, rather than just a blank spot on the page.</p>\n\n\n\n<p>Instead of this:</p>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-36047 not-transparent\" height=\"381\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/dominan-color-images-before.png?resize=700%2C381&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p>With the plugin active (and the media regenerated), the following is the result:</p>\n\n\n\n<figure class=\"wp-block-image size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-36048 not-transparent\" height=\"381\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/dominan-color-images-after.png?resize=700%2C381&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p>The visual impact that this plugin has on the loading of the page is that there is a brown rectangle serving as a placeholder for where the user can expect an image to load.</p>\n\n\n\n<p>However, when benchmarking the web vitals, there is <em>no improvement</em> in LCP. In fact, there even appears to be a slight regression:</p>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals\"><table><thead><tr><th></th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>437.2</td><td>439.5</td><td>+2.3</td><td>+0.5%</td></tr><tr><td>LCP</td><td>610.8</td><td>613.5</td><td>+2.7</td><td><strong>+0.4%</strong></td></tr><tr><td>TTFB</td><td>44.2</td><td>44.0</td><td>-0.2</td><td>-0.5%</td></tr><tr><td>LCP-TTFB</td><td>566.3</td><td>568.1</td><td>+1.8</td><td>+0.3%</td></tr></tbody></table><figcaption class=\"wp-element-caption\">Benchmark results for 250 requests each, before and after, emulating Moto G4 over Fast 4G connection.</figcaption></figure>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Benchmark command<pre class=\"wp-block-code\"><span><code class=\"hljs language-javascript\">npm run research -- benchmark-web-vitals \\\n	--url=<span class=\"hljs-string\">\"https://wcus-perf-talk-demo.local/2025/07/30/bison-featured-image/?enable_plugins=none\"</span> \\\n	--url=<span class=\"hljs-string\">\"https://wcus-perf-talk-demo.local/2025/07/30/bison-featured-image/?enable_plugins=dominant-color-images\"</span> \\\n	--number=<span class=\"hljs-number\">250</span> \\\n	--network-conditions=<span class=\"hljs-string\">\"Fast 4G\"</span> \\\n	--emulate-device=<span class=\"hljs-string\">\"Moto G4\"</span> \\\n	--diff \\\n	--output=md</code></span></pre></details>\n\n\n\n<p>Moreover, there is <strong>no difference</strong> in the Lighthouse performance score which is already maxed out at 100 (but again, this doesn&#8217;t mean perfection). Nevertheless, just because there is no improvement on the raw performance metric, this doesn&#8217;t mean there isn&#8217;t value in doing it. User-perceived performance is also important, as long as it doesn&#8217;t negatively impact LCP (which should hopefully not conflict). We&#8217;ll revisit this later with <a href=\"https://weston.ruter.net/category/wordpress/feed/#view-transitions\">View Transitions</a>.</p>\n\n\n\n<div class=\"wp-block-spacer\" style=\"height: 100px;\"></div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"modern-image-formats\">Modern Image Formats</h3>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-plugin-directory wp-block-embed-plugin-directory\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://wordpress.org/plugins/webp-uploads/\">Modern Image Formats</a></blockquote>\n</div></figure>\n\n\n\n<p>Modern image formats, like WebP and AVIF, are able to compress much higher compared to older formats like JPEG and PNG. For example, an image compressed with AVIF could be 50% smaller than a JPEG with similar visual quality. It stands to reason that if an image is smaller, then it will take less time to download, and the LCP metric will be improved since the image can render sooner. This also addresses a common audit you encounter in Lighthouse to <a href=\"https://developer.chrome.com/docs/lighthouse/performance/uses-webp-images\">serve images in next-gen formats</a>:</p>\n\n\n\n<figure class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img alt=\"Serve images in next-gen formats — Est savings of 46 KiB\n\nImage formats like WebP and AVIF often provide better compression than PNG or JPEG, which means faster downloads and less data consumption. Learn more about modern image formats. FCP LCP\n\nConsider using the Performance Lab plugin to automatically convert your uploaded JPEG images into WebP, wherever supported.\" class=\"has-border-color has-contrast-border-color wp-image-36137 not-transparent\" height=\"432\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/lighthouse-audit-serve-images-in-next-gen-formats-cropped.png?resize=700%2C432&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p>Note that the audit here estimates that the image in a modern image format would be 54% smaller for this image. (Note also the shameless plug for Performance Lab thanks to the <a href=\"https://github.com/GoogleChrome/lighthouse-stack-packs\">Stack Pack</a> for WordPress.)</p>\n\n\n\n<p>The <a href=\"https://wordpress.org/plugins/webp-uploads/\">Modern Image Formats</a> plugin (originally called “WebP Uploads”) addresses this audit&#8217;s complaint by converting uploaded images into AVIF or WebP, depending on which is available on your server. With the plugin active, the original <a href=\"https://en.wikipedia.org/wiki/File:American_bison_k5680-1.jpg\">Bison <img alt=\"🦬\" class=\"wp-smiley\" src=\"https://weston.ruter.net/wp-content/plugins/local-twemoji/images/emoji/72x72/1f9ac.png?ver=16-0-1\" style=\"height: 1em;\" /> image</a> uploaded as a JPEG is compressed from 356 KB down to 292 KB in AVIF format. This is ~18% smaller, not the hoped-for ~50% reduction in file size. Nevertheless, will this yield a 18% improvement in LCP? Here are the results of testing the same page as when testing Image Placeholders above, a post where the featured image is the LCP element:</p>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals\"><table><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>438.8</td><td>426.8</td><td>-12.1</td><td>-2.7%</td></tr><tr><td>LCP</td><td>613.8</td><td>599.2</td><td>-14.6</td><td><strong>-2.4%</strong></td></tr><tr><td>TTFB</td><td>47.8</td><td>49.2</td><td>+1.4</td><td>+2.8%</td></tr><tr><td>LCP-TTFB</td><td>565.1</td><td>550.6</td><td>-14.5</td><td>-2.6%</td></tr></tbody></table><figcaption class=\"wp-element-caption\">Benchmark results for 50 requests each, before and after, emulating Moto G4 over Fast 4G connection.</figcaption></figure>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Benchmark command<pre class=\"wp-block-code\"><span><code class=\"hljs language-javascript\">npm run research -- benchmark-web-vitals \\\n	--url=<span class=\"hljs-string\">\"https://wcus-perf-talk-demo.local/2025/07/30/bison-featured-image/?enable_plugins=none\"</span> \\\n	--url=<span class=\"hljs-string\">\"https://wcus-perf-talk-demo.local/2025/07/30/bison-featured-image/?enable_plugins=webp-uploads\"</span> \\\n	--number=<span class=\"hljs-number\">50</span> \\\n	--network-conditions=<span class=\"hljs-string\">\"Fast 4G\"</span> \\\n	--emulate-device=<span class=\"hljs-string\">\"Moto G4\"</span> \\\n	--diff \\\n	--output=md</code></span></pre></details>\n\n\n\n<p>So while the image file size was reduced ~20%, the LCP improvement here was only ~2%. </p>\n\n\n\n<p>Brendan Kenny&#8217;s article on <a href=\"https://web.dev/blog/common-misconceptions-lcp#lcp_sub-part_breakdown\">Common Misconceptions About How to Optimize LCP</a> shows that among the LCP sub-parts, the TTFB and “image load delay” contribute much more to the overall time compared with actually downloading the image resource. (Also described in <a href=\"https://almanac.httparchive.org/en/2024/performance#lcp-sub-parts\">Web Almanac</a>.) <a href=\"https://remkusdevries.com/\">Remkus de Vries</a> has likewise emphasized that we should <a href=\"https://remkusdevries.com/stop-obsessing-over-image-optimization/\">Stop Obsessing Over Image Optimization</a>. We absolutely shouldn&#8217;t be serving 10 MB images to visitors, but there are diminishing returns for optimizing LCP with each percentage reduction in an image&#8217;s file size. There are far more impactful ways to improve LCP than to use the most optimal image compression.</p>\n\n\n\n<p><em>Thanks to <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> for championing support for modern image formats both in this plugin and in core!</em></p>\n\n\n\n<div class=\"wp-block-spacer\" style=\"height: 100px;\"></div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"enhanced-responsive-images\">Enhanced Responsive Images</h3>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-plugin-directory wp-block-embed-plugin-directory\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://wordpress.org/plugins/auto-sizes/\">Enhanced Responsive Images</a></blockquote>\n</div></figure>\n\n\n\n<p>The <a href=\"https://wordpress.org/plugins/auto-sizes/\">Enhanced Responsive Images</a> plugin was originally developed as a way to automatically add <code>sizes=auto</code> for images with <code>loading=lazy</code>. This <a href=\"https://github.com/whatwg/html/pull/8008\">new part</a> of the HTML spec lets the browser compute the responsive sizes because lazy-loaded images are loaded after the page has been laid out. This enhancement <a href=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/\">landed</a> in WordPress 6.7. Since then, the scope of the plugin has changed to improve the calculation of the responsive <code>sizes</code> attribute for images which are not lazy-loaded.</p>\n\n\n\n<p>By default, WordPress uses the same formula for constructing the default <code>sizes</code> attribute for all images. For example, if an image is 1024 pixels wide, then the <code>sizes</code> attribute is set to:</p>\n\n\n<pre class=\"wp-block-code\"><span><code class=\"hljs language-plaintext\">(max-width: 1024px) 100vw, 1024px</code></span></pre>\n\n\n<p>This is problematic, however, because if the image takes up half the width of the screen, then the browser will select the image URL from the <code>srcset</code> attribute for the size corresponding to the width of the viewport, not the width of the actual <code>IMG</code> element. This is often fine on mobile when images are more often taking up the full page width, but on desktop viewports it means a much larger image will be downloaded than is appropriate for the container size. For example, consider these images in a Columns block (sourced from Wikipedia, as linked):</p>\n\n\n\n<div class=\"wp-block-columns is-not-stacked-on-mobile is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://en.wikipedia.org/wiki/File:American_bison_k5680-1.jpg\"><img alt=\"A Bison standing among grasses looking toward the camera.\" class=\"wp-image-34617 not-transparent\" height=\"457\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/05/American_bison_k5680-1.jpg?resize=700%2C457&#038;ssl=1\" width=\"700\" /></a></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://commons.wikimedia.org/wiki/File:Bison_bison_Wichita_Mountain_Oklahoma.jpg\"><img alt=\"Bison bison at the Wichita Mountain Wildlife Refuge in Oklahoma.\" class=\"wp-image-36065 not-transparent\" height=\"507\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/Bison_bison_Wichita_Mountain_Oklahoma.jpg?resize=700%2C507&#038;ssl=1\" width=\"700\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://commons.wikimedia.org/wiki/File:The_last_of_the_Canadian_buffaloes_Photo_No_580_(HS85-10-13487).jpg\"><img alt=\"The last of the Canadian buffaloes.\" class=\"wp-image-36066 not-transparent\" height=\"483\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/The_last_of_the_Canadian_buffaloes_Photo_No_580_HS85-10-13487.jpg?resize=700%2C483&#038;ssl=1\" width=\"700\" /></a></figure>\n</div>\n</div>\n\n\n\n<p>These images were all resized to be 1024 pixels wide, and so using the default WordPress scheme, they all have the same <code>sizes</code> attribute (as shown above), in spite of the fact that the first <code>IMG</code> element is twice the width of the second and third, and 1024px itself is about double the entire 645px width of the root Columns block on desktop. </p>\n\n\n\n<p>In Lighthouse, the <a href=\"https://developer.chrome.com/docs/lighthouse/performance/uses-responsive-images\">properly size images</a> audit correctly identifies these images as having inaccurate <code>sizes</code>:</p>\n\n\n\n<figure class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img alt=\"Properly size images — Est savings of 226 KiB\n\nServe images that are appropriately-sized to save cellular data and improve load time. Learn how to size images.\n\nUpload images directly through the media library to ensure that the required image sizes are available, and then insert them from the media library or use the image widget to ensure the optimal image sizes are used (including those for the responsive breakpoints). Avoid using Full Size images unless the dimensions are adequate for their usage.\n\" class=\"has-border-color has-accent-6-border-color wp-image-36138 not-transparent\" height=\"700\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/lighthouse-audit-properly-size-images-full-cropped.png?resize=625%2C700&#038;ssl=1\" width=\"625\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p>On my test page, this Columns block is at the beginning of the content, so none of the <code>IMG</code> tags are lazy-loaded and likewise none are eligible for auto-sizes. This is where the <em>enhanced</em> Enhanced Responsive Sizes plugin comes in. Now that auto-sizes was merged into core, the plugin&#8217;s scope has changed to improve the accuracy of the <code>sizes</code> attribute by using the structured layout information available in <a href=\"https://wordpress.org/documentation/article/block-themes/\">block themes</a> (which is not available in classic themes). With this plugin active, the width in the <code>sizes</code> attribute for the <code>IMG</code> in the first column reduces from 1024px down to 429px:</p>\n\n\n<pre class=\"wp-block-code\"><span><code class=\"hljs language-plaintext\">(max-width: 429px) 100vw, 429px</code></span></pre>\n\n\n<p>And the two smaller <code>IMG</code> tags in the second narrower column get reduced from 1024px down to 134px:</p>\n\n\n<pre class=\"wp-block-code\"><span><code class=\"hljs language-plaintext\">(max-width: 134px) 100vw, 134px</code></span></pre>\n\n\n<p>Here is the performance impact when benchmarking the change:</p>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals\"><table><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>436.1</td><td>438.6</td><td>+2.5</td><td>+0.6%</td></tr><tr><td>LCP</td><td>915.3</td><td>690.9</td><td>-224.4</td><td><strong>-24.5%</strong></td></tr><tr><td>TTFB</td><td>50.8</td><td>50.6</td><td>-0.2</td><td>-0.3%</td></tr><tr><td>LCP-TTFB</td><td>865.6</td><td>638.3</td><td>-227.3</td><td>-26.3%</td></tr></tbody></table><figcaption class=\"wp-element-caption\">Benchmark results for 50 requests each, before and after, emulating Moto G4 over Fast 4G connection.</figcaption></figure>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Benchmark command<pre class=\"wp-block-code\"><span><code class=\"hljs language-javascript\">npm run research -- benchmark-web-vitals \\\n	--url=<span class=\"hljs-string\">\"https://wcus-perf-talk-demo.local/2025/07/31/bison-two-columns/?enable_plugins=none\"</span> \\\n	--url=<span class=\"hljs-string\">\"https://wcus-perf-talk-demo.local/2025/07/31/bison-two-columns/?enable_plugins=auto-sizes\"</span> \\\n	--number=<span class=\"hljs-number\">50</span> \\\n	--network-conditions=<span class=\"hljs-string\">\"Fast 4G\"</span> \\\n	--emulate-device=<span class=\"hljs-string\">\"Moto G4\"</span> \\\n	--diff \\\n	--output=md</code></span></pre></details>\n\n\n\n<p>This has a dramatic <strong>~25% reduction in LCP!</strong></p>\n\n\n\n<p>This also has an improvement in the Lighthouse score for this example page, whereas I did not find an improvement when testing the previous plugins.</p>\n\n\n\n<div class=\"wp-block-columns is-not-stacked-on-mobile is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image aligncenter size-large has-custom-border wp-lightbox-container\"><img alt=\"Lighthouse performance score 96 with an LCP of 2.7 seconds.\" class=\"has-border-color has-accent-6-border-color wp-image-36070 not-transparent\" height=\"473\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/lighthouse-score-before-auto-sizes.png?resize=700%2C473&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Before</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image aligncenter size-large has-custom-border wp-lightbox-container\"><img alt=\"Lighthouse performance score 99 with an LCP of 2.0 seconds.\" class=\"has-border-color has-accent-6-border-color wp-image-36071 not-transparent\" height=\"473\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/lighthouse-score-after-auto-sizes.png?resize=700%2C473&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">After</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>The optimization also greatly improved the properly size images audit, before and after:</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large has-custom-border\"><img alt=\"&#x26a0; Properly size images — Est savings of 225 KiB\" class=\"has-border-color has-accent-6-border-color wp-image-36073 not-transparent\" height=\"99\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/lighthouse-properly-size-images-audit-before-auto-sizes.png?resize=700%2C99&#038;ssl=1\" width=\"700\" /></figure>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large has-custom-border\"><img alt=\"&#x26a0; Properly size images — Est savings of 91 KiB\" class=\"has-border-color has-accent-6-border-color wp-image-36074 not-transparent\" height=\"99\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/lighthouse-properly-size-images-audit-after-auto-sizes.png?resize=700%2C99&#038;ssl=1\" width=\"700\" /></figure>\n\n\n\n<p>Note that this audit is unlikely to ever pass completely unless you generate many more intermediate image sizes to better fit all possible dimensions for your responsive images. This is something that an image CDN could do for you, however. </p>\n\n\n\n<p>The effect of the more accurate <code>sizes</code> can be is evident in which intermediate image size files get downloaded:</p>\n\n\n\n<figure class=\"wp-block-table\"><table><thead><tr><th class=\"has-text-align-right\"></th><th class=\"has-text-align-center\">Before</th><th class=\"has-text-align-center\">After</th><th class=\"has-text-align-right\">Reduction</th></tr></thead><tbody><tr><td class=\"has-text-align-right\"><img alt=\"A Bison standing among grasses looking toward the camera.\" class=\"wp-image-34617 not-transparent\" height=\"33\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/05/American_bison_k5680-1-scaled.jpg?resize=50%2C33&#038;ssl=1\" width=\"50\" /></td><td class=\"has-text-align-center\">2048&#215;1336</td><td class=\"has-text-align-center\">1024&#215;668</td><td class=\"has-text-align-right\">-75%</td></tr><tr><td class=\"has-text-align-right\"><img alt=\"Bison bison at the Wichita Mountain Wildlife Refuge in Oklahoma.\" class=\"wp-image-36065 not-transparent\" height=\"36\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/Bison_bison_Wichita_Mountain_Oklahoma-scaled.jpg?resize=50%2C36&#038;ssl=1\" width=\"50\" /></td><td class=\"has-text-align-center\">2048&#215;1483</td><td class=\"has-text-align-center\">300&#215;217</td><td class=\"has-text-align-right\">-98%</td></tr><tr><td class=\"has-text-align-right\"><img alt=\"The last of the Canadian buffaloes.\" class=\"wp-image-36066 not-transparent\" height=\"35\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/The_last_of_the_Canadian_buffaloes_Photo_No_580_HS85-10-13487-scaled.jpg?resize=50%2C35&#038;ssl=1\" width=\"50\" /></td><td class=\"has-text-align-center\">2048&#215;1413</td><td class=\"has-text-align-center\">300&#215;207</td><td class=\"has-text-align-right\">-98%</td></tr></tbody><tfoot><tr><td class=\"has-text-align-right\">Total:</td><td class=\"has-text-align-center\">8,667,136px</td><td class=\"has-text-align-center\">811,232px</td><td class=\"has-text-align-right\">-91%</td></tr></tfoot></table></figure>\n\n\n\n<p>In this test of images in a Columns block, what follows is the impact of Modern Image Formats with AVIF versus Enhanced Responsive Images with more accurate <code>sizes</code>, and then with them both active together:</p>\n\n\n\n<figure class=\"wp-block-table\"><table><thead><tr><th>Plugins</th><th class=\"has-text-align-right\">Transferred</th><th class=\"has-text-align-right\">Reduction</th></tr></thead><tbody><tr><td>None</td><td class=\"has-text-align-right\">1,595 kB</td><td class=\"has-text-align-right\">—</td></tr><tr><td>Modern Image Formats with AVIF</td><td class=\"has-text-align-right\">1,137 kB</td><td class=\"has-text-align-right\">29%</td></tr><tr><td>Enhanced Responsive Images</td><td class=\"has-text-align-right\">206 kB</td><td class=\"has-text-align-right\">87%</td></tr><tr><td>Both</td><td class=\"has-text-align-right\">175 kB</td><td class=\"has-text-align-right\">89%</td></tr></tbody></table></figure>\n\n\n\n<p>As is evident, the use of a more accurate <code>sizes</code> attribute has three times the reduction in bytes compared with using the AVIF image format (87% vs 29%)! Adding AVIF on top of the better <code>sizes</code> only yields an additional 2% reduction in transferred bytes in this example. It&#8217;s no wonder why Enhanced Responsive Images has a greater impact on LCP compared with Modern Image Formats!</p>\n\n\n\n<p><em>Props to <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> and <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> for <a href=\"https://github.com/WordPress/performance/pulls?q=is%3Apr+label%3A%22%5BPlugin%5D+Enhanced+Responsive+Images%22+is%3Amerged\">their work</a> on this! Joe also first <a href=\"https://joemcgill.net/2025/01/happy-10-yrs-for-default-sizes/\">proposed</a> the original <code>sizes</code> attribute.</em></p>\n\n\n\n<div class=\"wp-block-spacer\" style=\"height: 100px;\"></div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"image-prioritizer\">Image Prioritizer</h3>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-plugin-directory wp-block-embed-plugin-directory\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://wordpress.org/plugins/image-prioritizer/\">Image Prioritizer</a></blockquote>\n</div></figure>\n\n\n\n<p>The last Performance Lab feature plugin which focuses on images is <a href=\"https://wordpress.org/plugins/image-prioritizer/\">Image Prioritizer</a>. As indicated by the name, the plugin optimizes image loading prioritization. For example, it boosts the priority of the detected LCP image with <code>fetchpriority=​high</code> while also deprioritizing the loading of images outside the viewport with lazy-loading. This plugin depends on the <a href=\"https://wordpress.org/plugins/optimization-detective/\">Optimization Detective</a> plugin as its framework for the optimizations it applies. I gave a <a href=\"https://weston.ruter.net/2025/02/21/boosting-performance-with-optimization-detective/\">talk</a> at WordCamp Asia 2025 all about this plugin:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-weston-ruter wp-block-embed-weston-ruter\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://weston.ruter.net/2025/02/21/boosting-performance-with-optimization-detective/\">Boosting Performance with Optimization Detective</a></blockquote>\n</div></figure>\n\n\n\n<p>In that talk, I cover Image Prioritizer in depth; the plugin description also has the <a href=\"https://wordpress.org/plugins/image-prioritizer/#:~:text=The%20current%20optimizations%20include%3A\">full list of optimizations</a>. But I&#8217;ll highlight here a couple of the most impactful optimizations which improve the LCP metric for images.</p>\n\n\n\n<h4 class=\"wp-block-heading\" id=\"responsive-image-prioritization\">Responsive Image Prioritization</h4>\n\n\n\n<p>Take for example this gallery of three images (again, from Wikipedia as linked):</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://commons.wikimedia.org/wiki/File:Bison_with_its_young.jpg\"><img alt=\"\" class=\"wp-image-36117 not-transparent\" height=\"467\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/Bison_with_its_young-2560w.jpg?resize=700%2C467&#038;ssl=1\" width=\"700\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://commons.wikimedia.org/wiki/File:Bison_bison_Wichita_Mountain_Oklahoma.jpg\"><img alt=\"Bison bison at the Wichita Mountain Wildlife Refuge in Oklahoma.\" class=\"wp-image-36065 not-transparent\" height=\"507\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/Bison_bison_Wichita_Mountain_Oklahoma.jpg?resize=700%2C507&#038;ssl=1\" width=\"700\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large has-custom-border\"><a href=\"https://en.wikipedia.org/wiki/File:American_bison_k5680-1.jpg\"><img alt=\"A Bison standing among grasses looking toward the camera.\" class=\"wp-image-34617 not-transparent\" height=\"457\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/05/American_bison_k5680-1.jpg?resize=700%2C457&#038;ssl=1\" width=\"700\" /></a></figure>\n</figure>\n\n\n\n<p>This gallery is configured without the “Crop images to fit” setting enabled. On desktop, the second image is the largest image of the three, and so it is the LCP element. However, on mobile it&#8217;s actually the third image which is the largest (and the LCP element) since it appears on a row by itself:</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image aligncenter size-large has-custom-border wp-lightbox-container\"><img alt=\"\" class=\"has-border-color has-accent-6-border-color wp-image-36126 not-transparent\" height=\"455\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/gallery-block-with-lcp-element-on-desktop.png?resize=700%2C455&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Desktop layout</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image aligncenter size-large has-custom-border wp-lightbox-container\"><img alt=\"\" class=\"has-border-color has-accent-6-border-color wp-image-36127 not-transparent\" height=\"700\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/gallery-block-with-lcp-element-on-mobile.png?resize=394%2C700&#038;ssl=1\" width=\"394\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Mobile layout</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>Nevertheless, WordPress core adds <code>fetchpriority=​high</code> to the <em>first</em> <code>IMG</code>, of the bison and calf, even though it is never the LCP element. WordPress adds the <code>fetchpriority</code> attribute to the first sufficiently-large image it finds on the page, making a best guess as to which is the LCP element. But even when core does add the attribute to the right image on a desktop viewport, it could be wrong for mobile, and vice versa. In <a href=\"https://github.com/GoogleChromeLabs/wpp-research/pull/73\">my research</a>, when WordPress core correctly adds the <code>fetchpriority</code> attribute to the LCP <code>IMG</code> element on desktop or mobile, I found that 37% of those pages have a different <code>IMG</code> which is the LCP element for the other viewport. This means it&#8217;s only safe to use the <code>fetchpriority</code> attribute on <code>IMG</code> tags when they are the LCP element on <em>both</em> desktop and mobile (and tablet too). But WordPress doesn&#8217;t know how the page is laid out (although this is starting to change in the case of block themes, as with Enhanced Responsive Images above). This is where Optimization Detective comes in.</p>\n\n\n\n<p>The Optimization Detective plugin provides a framework to capture measurements from site visitors about what elements are displayed on a page across a variety of device form factors and responsive breakpoints (e.g. desktop, tablet, and mobile). These measurements are stored in “URL Metrics” (a custom post type) which can then be used by extensions, like Image Prioritizer, to apply more accurate optimizations. In this case, Image Prioritizer:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Removes <code>fetchpriority=​high</code> from the first <code>IMG</code> in the Gallery.</li>\n\n\n\n<li>Adds responsive preload <code>LINK</code> tags for the actual LCP element based on media queries.</li>\n</ol>\n\n\n\n<p>For example, the following <code>LINK</code> tags are added to the page:</p>\n\n\n<pre class=\"wp-block-code\"><span><code class=\"hljs language-xml shcb-code-table\"><span class=\"shcb-loc\"><span><span class=\"hljs-tag\">&lt;<span class=\"hljs-name\">link</span></span>\n</span></span><span class=\"shcb-loc\"><span><span class=\"hljs-tag\"> <span class=\"hljs-attr\">rel</span>=<span class=\"hljs-string\">\"preload\"</span> <span class=\"hljs-attr\">as</span>=<span class=\"hljs-string\">\"image\"</span> <span class=\"hljs-attr\">fetchpriority</span>=<span class=\"hljs-string\">\"high\"</span></span>\n</span></span><span><span class=\"hljs-tag\"> <span class=\"hljs-attr\">href</span>=<span class=\"hljs-string\">\".../bison-2.jpg\"</span></span>\n</span><span class=\"shcb-loc\"><span><span class=\"hljs-tag\"> <span class=\"hljs-attr\">imagesrcset</span>=<span class=\"hljs-string\">\"...\"</span> <span class=\"hljs-attr\">imagesizes</span>=<span class=\"hljs-string\">\"...\"</span></span>\n</span></span><span><span class=\"hljs-tag\"> <span class=\"hljs-attr\">media</span>=<span class=\"hljs-string\">\"screen and (width &lt;= 480px)\"</span></span>\n</span><span class=\"shcb-loc\"><span><span class=\"hljs-tag\">&gt;</span>\n</span></span><span class=\"shcb-loc\"><span><span class=\"hljs-tag\">&lt;<span class=\"hljs-name\">link</span></span>\n</span></span><span class=\"shcb-loc\"><span><span class=\"hljs-tag\"> <span class=\"hljs-attr\">rel</span>=<span class=\"hljs-string\">\"preload\"</span> <span class=\"hljs-attr\">as</span>=<span class=\"hljs-string\">\"image\"</span> <span class=\"hljs-attr\">fetchpriority</span>=<span class=\"hljs-string\">\"high\"</span></span>\n</span></span><span><span class=\"hljs-tag\"> <span class=\"hljs-attr\">href</span>=<span class=\"hljs-string\">\".../bison-3.jpg\"</span></span>\n</span><span class=\"shcb-loc\"><span><span class=\"hljs-tag\"> <span class=\"hljs-attr\">imagesrcset</span>=<span class=\"hljs-string\">\"...\"</span> <span class=\"hljs-attr\">imagesizes</span>=<span class=\"hljs-string\">\"...\"</span></span>\n</span></span><span><span class=\"hljs-tag\"> <span class=\"hljs-attr\">media</span>=<span class=\"hljs-string\">\"screen and (782px &lt; width)\"</span></span>\n</span><span class=\"shcb-loc\"><span><span class=\"hljs-tag\">&gt;</span>\n</span></span></code></span></pre>\n\n\n<p>Note how the first <code>LINK</code> preloads the second bison image on mobile, but the second <code>LINK</code> preloads the third bison image on desktop. Here is the performance impact for these changes on mobile:</p>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals\"><table><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>441.9</td><td>449.5</td><td>+7.7</td><td>+1.7%</td></tr><tr><td>LCP</td><td>984.1</td><td>713.2</td><td>-270.9</td><td><strong>-27.5%</strong></td></tr><tr><td>TTFB</td><td>49.4</td><td>53.5</td><td>+4.1</td><td>+8.3%</td></tr><tr><td>LCP-TTFB</td><td>935.1</td><td>659.5</td><td>-275.6</td><td>-29.5%</td></tr></tbody></table><figcaption class=\"wp-element-caption\">Benchmark results for 50 requests each, before and after, emulating Moto G4 over Fast 4G connection.</figcaption></figure>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Benchmark command<pre class=\"wp-block-code\"><span><code class=\"hljs language-javascript\">npm run research -- benchmark-web-vitals \\\n	--url=<span class=\"hljs-string\">\"https://wcus-perf-talk-demo.local/2025/08/04/bison-gallery/?disable_all_plugins\"</span> \\\n	--url=<span class=\"hljs-string\">\"https://wcus-perf-talk-demo.local/2025/08/04/bison-gallery/?enable_plugins=image-prioritizer\"</span> \\\n	--number=<span class=\"hljs-number\">50</span> \\\n	--network-conditions=<span class=\"hljs-string\">\"Fast 4G\"</span> \\\n	--emulate-device=<span class=\"hljs-string\">\"Moto G4\"</span> \\\n	--diff \\\n	--output=md</code></span></pre></details>\n\n\n\n<p>This is the biggest LCP improvement I&#8217;ve yet shown, with a 27.5% reduction compared with the 24.5% improvement in Enhanced Responsive Images. This shows up as an improvement in the Lighthouse performance score, increasing from 95 to 99:</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image aligncenter size-large has-custom-border wp-lightbox-container\"><img alt=\"Lighthouse performance score 95 with 2.9 second LCP.\" class=\"has-border-color has-accent-6-border-color wp-image-36128 not-transparent\" height=\"462\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/lighthouse-gallery-block-without-image-prioritizer-on-mobile.png?resize=700%2C462&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Without Image Prioritizer</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image aligncenter size-large has-custom-border wp-lightbox-container\"><img alt=\"Lighthouse performance score 99 with 2.1 second LCP.\" class=\"has-border-color has-accent-6-border-color wp-image-36129 not-transparent\" height=\"462\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/lighthouse-gallery-block-with-image-prioritizer-on-mobile.png?resize=700%2C462&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">With Image Prioritizer</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>But what becomes truly impressive are the results on desktop:</p>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals\"><table><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>434.9</td><td>436.0</td><td>+1.2</td><td>+0.3%</td></tr><tr><td>LCP</td><td>1020.1</td><td>503.2</td><td>-517.0</td><td><strong>-50.7%</strong></td></tr><tr><td>TTFB</td><td>49.9</td><td>52.4</td><td>+2.6</td><td>+5.1%</td></tr><tr><td>LCP-TTFB</td><td>969.4</td><td>451.3</td><td>-518.2</td><td>-53.5%</td></tr></tbody></table></figure>\n\n\n\n<p>The LCP improvement here on desktop is almost double the improvement on mobile, at an over 50% reduction in LCP! In other words, the LCP metric is cut in half! This shows impressively in the Lighthouse performance score increasing from 93 to 100:</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image aligncenter size-large has-custom-border wp-lightbox-container\"><img alt=\"Lighthouse performance score 93 with 1.7 second LCP.\" class=\"has-border-color has-accent-6-border-color wp-image-36130 not-transparent\" height=\"462\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/lighthouse-gallery-block-without-image-prioritizer-on-desktop.png?resize=700%2C462&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Without Image Prioritizer</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image aligncenter size-large has-custom-border wp-lightbox-container\"><img alt=\"Lighthouse performance score 100 with 0.6 second LCP.\" class=\"has-border-color has-accent-6-border-color wp-image-36131 not-transparent\" height=\"462\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/lighthouse-gallery-block-with-image-prioritizer-on-desktop.png?resize=700%2C462&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">With Image Prioritizer</figcaption></figure>\n</div>\n</div>\n\n\n\n<h4 class=\"wp-block-heading\" id=\"background-image-prioritization\">Background Image Prioritization</h4>\n\n\n\n<p>Related to there being different LCP <code>IMG</code> elements on desktop versus mobile is that the LCP element&#8217;s image may not be an <code>IMG</code> at all, but rather a <code>DIV</code> (or some other element) with a CSS <code>background-image</code>. This is a very common way that imagery is added in page builders. Background images are also present in WordPress core, such as in some classic themes&#8217; header images; background images are also on any WordPress site using the Cover block when using a fixed background or when adding a background image to a Group block. The prevalence of non-<code>IMG</code> LCP images is captured in this <a href=\"https://almanac.httparchive.org/en/2022/performance#lcp-content-types\">data presented</a> in Web Almanac 2022, showing that the <code>DIV</code> (presumably with a background image) is the LCP element ~26% of the time compared with an <code>IMG</code> at 42% of the time:</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large wp-lightbox-container\"><img alt=\"Bar chart showing IMG is the LCP element on 47% of desktop pages and 42% of mobile pages, DIV on 28% and 26% respectively, P on 6% and 9%, H1 on 3% and 5%, undetected on 3% and 3%, SECTION on 3% and 3%, H2 on 1% and 2%, A on 1% and 2%, SPAN on 1% and 1%, H3 on 0% and 1%, HEADER on 1% and 1%, LI on 1% and 1%, RS-SBG on 1% and 1%, TD on 1% and 1%, VIDEO on 0% and 0%, and finally H4 is the LCP element type on 0% of both desktop and mobile pages.\" class=\"wp-image-36141 not-transparent\" height=\"700\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/top-lcp-element-types.png?resize=598%2C700&#038;ssl=1\" width=\"598\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">The percent of pages that have a given element as its LCP.</figcaption></figure>\n\n\n\n<p>The problem with the <code>background-image</code> style is that it is CSS: there is no way for core to attach a <code>fetchpriority=​high</code> HTML attribute as can be done for LCP <code>IMG</code> candidates. Take the following page for example, where there is a parallax Cover block at the beginning of the content, followed by some paragraphs of text, and finally a Gallery block with five images in it. The black rectangle denotes the desktop viewport:</p>\n\n\n\n<figure class=\"wp-block-image alignwide size-large\"><img alt=\"Depicting a desktop viewport with a Cover block at the top of the page, followed by paragraphs of text, and a Gallery block at the bottom of the page outside of desktop viewport.\" class=\"wp-image-36152 not-transparent\" height=\"349\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/parallax-cover-as-lcp-with-gallery-outside-viewport-cropped.png?resize=700%2C349&#038;ssl=1\" width=\"700\" /></figure>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">Cover image courtesy <a href=\"https://www.pexels.com/photo/brown-buffalo-on-green-grass-field-8148551/\">Gintare</a> K. on Pexels. Other previously-unused images courtesy Wikipedia: <a href=\"https://commons.wikimedia.org/wiki/File:American_Bison_AdF.jpg\">1</a>, <a href=\"https://commons.wikimedia.org/wiki/File:Waldbison_Bison_bison_athabascae_Tierpark_Hellabrunn-13.jpg\">2</a>, <a href=\"https://commons.wikimedia.org/wiki/File:Wood_bison_in_the_snow_(52815312269).jpg\">3</a>.</p>\n\n\n\n<p>The <code>DIV</code> in the Cover block with the CSS <code>background-image</code> is the LCP element. Nevertheless, WordPress core is adding <code>fetchpriority=​high</code> to the first <code>IMG</code> in the Gallery block because it is the first sufficiently large image, just in terms of its <code>width</code> and <code>height</code> attributes. Additionally, WordPress core omits <code>loading=lazy</code> from the first three content images (the first three images in the Gallery), but they are not even visible on either the desktop or mobile viewports. The effect here is that the first three images of the Gallery are all loaded first <em>before</em> the all-important background image for the Cover block. Image Prioritizer fixes this by:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Removing <code>fetchpriority=​high</code> from the first <code>IMG</code> in the Gallery, since it is not the LCP element.</li>\n\n\n\n<li>Adding <code>loading=lazy</code> to the first three <code>IMG</code> tags in the Gallery, since none of them are visible in any initial viewport.</li>\n\n\n\n<li>Adding a preload <code>LINK</code> for the CSS <code>background-image</code> so that it is properly prioritized.</li>\n</ol>\n\n\n\n<p>The preload <code>LINK</code> looks like the following:</p>\n\n\n<pre class=\"wp-block-code\"><span><code class=\"hljs language-xml\"><span class=\"hljs-tag\">&lt;<span class=\"hljs-name\">link</span>\n <span class=\"hljs-attr\">rel</span>=<span class=\"hljs-string\">\"preload\"</span>\n <span class=\"hljs-attr\">as</span>=<span class=\"hljs-string\">\"image\"</span>\n <span class=\"hljs-attr\">fetchpriority</span>=<span class=\"hljs-string\">\"high\"</span>\n <span class=\"hljs-attr\">href</span>=<span class=\"hljs-string\">\".../bison.jpg\"</span>\n <span class=\"hljs-attr\">media</span>=<span class=\"hljs-string\">\"screen\"</span>\n&gt;</span></code></span></pre>\n\n\n<p>Unlike with the responsive image prioritization, the Cover block here is the LCP element for both desktop and mobile, so here there is only one <code>LINK</code> and the <code>media</code> attribute doesn&#8217;t need to add any viewport constraints.</p>\n\n\n\n<p>Here is the performance impact:</p>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals\"><table><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>436.5</td><td>433.9</td><td>-2.7</td><td>-0.6%</td></tr><tr><td>LCP</td><td>1042.4</td><td>579.8</td><td>-462.7</td><td><strong>-44.4%</strong></td></tr><tr><td>TTFB</td><td>49.0</td><td>53.1</td><td>+4.1</td><td>+8.4%</td></tr><tr><td>LCP-TTFB</td><td>994.6</td><td>526.9</td><td>-467.7</td><td>-47.0%</td></tr></tbody></table><figcaption class=\"wp-element-caption\">Benchmark results for 50 requests each, before and after, emulating Moto G4 over Fast 4G connection.</figcaption></figure>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Benchmark command<pre class=\"wp-block-code\"><span><code class=\"hljs language-javascript\">npm run research -- benchmark-web-vitals \\\n	--url=https:<span class=\"hljs-comment\">//wcus-perf-talk-demo.local/2025/08/04/cover-block/?disable_all_plugins \\</span>\n	--url=https:<span class=\"hljs-comment\">//wcus-perf-talk-demo.local/2025/08/04/cover-block/?enable_plugins=image-prioritizer \\</span>\n	--number=<span class=\"hljs-number\">50</span> \\\n	--network-conditions=<span class=\"hljs-string\">\"Fast 4G\"</span> \\\n	--emulate-device=<span class=\"hljs-string\">\"Moto G4\"</span> \\\n	--diff \\\n	--output=md</code></span></pre></details>\n\n\n\n<p>This is the second-best improvement to LCP I&#8217;ve shown here in analyzing these plugins. The Lighthouse performance score is also improved from 92 to 99:</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image aligncenter size-large has-custom-border wp-lightbox-container\"><img alt=\"Lighthouse performance score of 92 with 3.3 second LCP\" class=\"has-border-color has-accent-6-border-color wp-image-36154 not-transparent\" height=\"468\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/lighthouse-score-cover-block-without-image-prioritizer.png?resize=700%2C468&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Before</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image aligncenter size-large has-custom-border wp-lightbox-container\"><img alt=\"Lighthouse performance score of 92 with 2.1 second LCP\" class=\"has-border-color has-accent-6-border-color wp-image-36155 not-transparent\" height=\"468\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/lighthouse-score-cover-block-with-image-prioritizer.png?resize=700%2C468&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">After</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>Surely nothing can improve LCP more than what was achieved here with the Image Prioritizer plugin, right? Read on.</p>\n\n\n\n<div class=\"wp-block-spacer\" style=\"height: 100px;\"></div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"speculative-loading\">Speculative Loading</h3>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-plugin-directory wp-block-embed-plugin-directory\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://wordpress.org/plugins/speculation-rules/\">Speculative Loading</a></blockquote>\n</div></figure>\n\n\n\n<p>The <a href=\"https://wordpress.org/plugins/speculation-rules/\">Speculative Loading</a> plugin is the first discussed here not specifically focused on improving LCP for images, although they do benefit. This was a feature plugin actually to bring the <a href=\"https://developer.mozilla.org/en-US/docs/Web/API/Speculation_Rules_API\">Speculation Rules API</a> to WordPress core, which was <a href=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/\">merged</a> in 6.8. This API allows pages to either:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Prefetch a link, reducing TTFB to zero.</li>\n\n\n\n<li>Prerender a link, potentially reducing LCP to zero.</li>\n</ul>\n\n\n\n<p>As such, Speculative Loading is somewhat cheating at performance because you can&#8217;t get any faster at loading something than to have it already loaded.</p>\n\n\n\n<p>The degree by which TTFB and LCP are improved is largely dependent on the “eagerness” of the speculation. There are three main eagerness values for when speculation starts:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Conservative: when you pointer-down on a link.</li>\n\n\n\n<li>Moderate: when you hover over a link (or <a href=\"https://issues.chromium.org/issues/372053392\">soon</a> on mobile when a link is in the viewport).</li>\n\n\n\n<li>Eager: right away without any user interaction. </li>\n</ul>\n\n\n\n<p>For the initial core merge, the default cautious configuration was to use prefetch with conservative eagerness. Conservative eagerness was to avoid unused speculations which can overly tax under-powered servers, and prefetching was to avoid potential compatibility issues with prerendering, such as with analytics or ads.</p>\n\n\n\n<p>Here&#8217;s the impact that the various configurations of Speculative Loading have on LCP:</p>\n\n\n\n<div class=\"wp-block-group is-content-justification-center is-nowrap is-layout-flex wp-container-core-group-is-layout-23441af8 wp-block-group-is-layout-flex block-visibility-hide-small-screen\" id=\"play-all-button-row\">\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><button class=\"wp-block-button__link has-text-align-center wp-element-button\" type=\"button\">Play All</button></div>\n</div>\n</div>\n\n\n\n<noscript>\n  \n</noscript>\n\n\n\n\n<div class=\"wp-block-columns alignwide is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\" id=\"speculative-loading-videos\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-text-align-center\"><strong>No Speculation</strong></p>\n\n\n\n<p class=\"has-text-align-center has-text-color has-link-color has-xx-large-font-size wp-elements-b5fdba613d5f54f529164d484d92f964\" style=\"color: #388e3c;\"><strong>2.17 s</strong></p>\n\n\n\n<figure class=\"wp-block-video aligncenter\"><video controls=\"controls\" height=\"1080\" poster=\"https://weston.ruter.net/wp-content/uploads/2025/08/speculative-loading-0-poster-source.png\" src=\"https://weston.ruter.net/wp-content/uploads/2025/08/speculative-loading-1-none-8s.mp4\" width=\"914\"></video><figcaption class=\"wp-element-caption\">(experience in 6.7)</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-text-align-center\"><strong>Conservative Prefetch</strong></p>\n\n\n\n<p class=\"has-text-align-center has-text-color has-link-color has-xx-large-font-size wp-elements-4d5479e34dcbef7f8a0893f1cf0b6b4e\" style=\"color: #388e3c;\"><strong>2.12 s</strong></p>\n\n\n\n<figure class=\"wp-block-video aligncenter\"><video controls=\"controls\" height=\"1080\" poster=\"https://weston.ruter.net/wp-content/uploads/2025/08/speculative-loading-0-poster-source.png\" src=\"https://weston.ruter.net/wp-content/uploads/2025/08/speculative-loading-2-conservative-prefetch-8s.mp4\" width=\"914\"></video><figcaption class=\"wp-element-caption\">2.3% reduction in LCP<br />(default as of WP 6.8)</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-text-align-center\"><strong>Moderate Prefetch</strong></p>\n\n\n\n<p class=\"has-text-align-center has-text-color has-link-color has-xx-large-font-size wp-elements-12afbcabcb1015bd3dd64bd0c56507e3\" style=\"color: #388e3c;\"><strong>1.04 s</strong></p>\n\n\n\n<figure class=\"wp-block-video aligncenter\"><video controls=\"controls\" height=\"1080\" poster=\"https://weston.ruter.net/wp-content/uploads/2025/08/speculative-loading-0-poster-source.png\" src=\"https://weston.ruter.net/wp-content/uploads/2025/08/speculative-loading-3-moderate-prefetch-8s.mp4\" width=\"914\"></video><figcaption class=\"wp-element-caption\">52.1%% reduction in LCP</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<p class=\"has-text-align-center\"><strong>Moderate Prerender</strong></p>\n\n\n\n<p class=\"has-text-align-center has-text-color has-link-color has-xx-large-font-size wp-elements-878b05b2c5f120b82213be7b98b2888a\" style=\"color: #388e3c;\"><strong>0.04 s</strong></p>\n\n\n\n<figure class=\"wp-block-video aligncenter\"><video controls=\"controls\" height=\"1080\" poster=\"https://weston.ruter.net/wp-content/uploads/2025/08/speculative-loading-0-poster-source.png\" src=\"https://weston.ruter.net/wp-content/uploads/2025/08/speculative-loading-4-moderate-prerender-8s.mp4\" width=\"914\"></video><figcaption class=\"wp-element-caption\">98.2% reduction in LCP</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>Navigation with prerendering results in a practically instantaneous page load with a near zero LCP! In all these cases the LCP is still considered “good” at being less than 2.5 seconds, but just because something is good doesn&#8217;t mean it can&#8217;t be better!</p>\n\n\n\n<p>Note that the test page here adds a 1 second TTFB via <code>sleep(1)</code>. This reflects a fairly typical server response time considering that only a <a href=\"https://httparchive.org/reports/techreport/tech?tech=ALL%2CWordPress&amp;geo=ALL&amp;rank=ALL&amp;good-cwv-over-time=TTFB#comparison-good-cwvs\">quarter</a> of WordPress sites have a good TTFB passing rate, which is 800 ms and faster.</p>\n\n\n\n<p><em>Props to <a href=\"https://felix-arntz.me/\">Felix Arntz</a> for spearheading this feature and landing it in core.</em></p>\n\n\n\n<div class=\"wp-block-spacer\" style=\"height: 100px;\"></div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"view-transitions\">View Transitions</h3>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-plugin-directory wp-block-embed-plugin-directory\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://wordpress.org/plugins/view-transitions/\">View Transitions</a></blockquote>\n</div></figure>\n\n\n\n<p>As described in the previous example, page navigations with Speculative Loading can be nearly instant with prerendering. This is great, but it&#8217;s almost too good. The navigation can feel so instant as to be abrupt. There can also be a white flicker between the page loads. To help in part with having too much of a good thing, the newest plugin to be featured in Performance Lab is <a href=\"https://wordpress.org/plugins/view-transitions/\">View Transitions</a>. There is a new web platform feature for <a href=\"https://developer.chrome.com/docs/web-platform/view-transitions/cross-document\">cross-document view transitions for multi-page applications</a>, and this plugin brings these smooth page navigation animations to WordPress. With Speculative Loading and View Transitions, navigating around a regular multi-page WordPress site can feel as fluid as a single-page app (and without all the implementation complexity).</p>\n\n\n\n<p>Take a look at the impact on the user experience when navigating between the homepage and a blog post:</p>\n\n\n\n<div class=\"wp-block-columns is-not-stacked-on-mobile is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-video aligncenter\"><video controls=\"controls\" height=\"1080\" loop=\"loop\" poster=\"https://weston.ruter.net/wp-content/uploads/2025/08/view-transitions-poster.jpg\" src=\"https://weston.ruter.net/wp-content/uploads/2025/08/view-transitions-disabled-with-navigation-via-links.mp4\" width=\"756\"></video><figcaption class=\"wp-element-caption\">Without View Transitions</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-video aligncenter\"><video controls=\"controls\" height=\"1080\" loop=\"loop\" poster=\"https://weston.ruter.net/wp-content/uploads/2025/08/view-transitions-poster.jpg\" src=\"https://weston.ruter.net/wp-content/uploads/2025/08/view-transitions-enabled-with-navigation-via-links.mp4\" width=\"756\"></video><figcaption class=\"wp-element-caption\">With View Transitions</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>Note that these view transitions apply not only when navigating via links, but they also apply when navigating with the back/forward buttons in the browser:</p>\n\n\n\n<div class=\"wp-block-columns is-not-stacked-on-mobile is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-video aligncenter\"><video controls=\"controls\" height=\"1080\" loop=\"loop\" poster=\"https://weston.ruter.net/wp-content/uploads/2025/08/view-transitions-via-bfcache-poster.jpg\" src=\"https://weston.ruter.net/wp-content/uploads/2025/08/view-transitions-disabled-with-navigation-via-bfcache.mp4\" width=\"722\"></video><figcaption class=\"wp-element-caption\">Without View Transitions</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-video aligncenter\"><video controls=\"controls\" height=\"1080\" loop=\"loop\" poster=\"https://weston.ruter.net/wp-content/uploads/2025/08/view-transitions-via-bfcache-poster.jpg\" src=\"https://weston.ruter.net/wp-content/uploads/2025/08/view-transitions-enabled-with-navigation-via-bfcache.mp4\" width=\"722\"></video><figcaption class=\"wp-element-caption\">With View Transitions</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>Nevertheless, as nice as these cross-document view transitions are, do note that there is no LCP improvement to using them. As referenced previously with Image Placeholders, the View Transitions plugin provides a non-performance user experience improvement. So don&#8217;t expect to find any difference in your Lighthouse scores or LCP passing rates with this plugin.</p>\n\n\n\n<p><em>Props again to <a href=\"https://felix-arntz.me/\">Felix Arntz</a> for spearheading this feature plugin.</em></p>\n\n\n\n<div class=\"wp-block-spacer\" style=\"height: 100px;\"></div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"nocache-bfcache\">No-cache BFCache</h3>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-plugin-directory wp-block-embed-plugin-directory\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://wordpress.org/plugins/nocache-bfcache/\">No-cache BFCache</a></blockquote>\n</div></figure>\n\n\n\n<p>Originally, the <a href=\"https://wordpress.org/plugins/nocache-bfcache/\">No-cache BFCache</a> plugin was part of the “beyond” part of my talk because it wasn&#8217;t among the plugins featured by Performance Lab. However, this is no longer the case since <a href=\"https://github.com/WordPress/performance/releases/tag/2025-08-25\">v4.0.0</a>. In the previous section about Speculative Loading, I showed how prerendering enabled near instant page loads with practically zero LCP. But there is a much older browser technology for instantaneous page navigations: the <a href=\"https://web.dev/articles/bfcache\">back-forward cache</a> (bfcache). This was also depicted above in the back/forward navigation videos with view transitions.</p>\n\n\n\n<p>I wrote up a <a href=\"https://weston.ruter.net/2025/07/23/instant-back-forward-navigations-in-wordpress/\">blog post</a> already all about bfcache and this plugin:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-weston-ruter wp-block-embed-weston-ruter\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://weston.ruter.net/2025/07/23/instant-back-forward-navigations-in-wordpress/\">Instant Back/Forward Navigations in WordPress</a></blockquote>\n</div></figure>\n\n\n\n<p>To recap, webpages are generally not eligible for bfcache when they are served with <code>Cache-Control: no-store</code>. This header is sent when a user is logged-in and often on e-commerce sites for the shopping cart, checkout, and account pages. While it importantly prevents such pages from being cached by proxies, it also prevents the browser from storing pages in bfcache. This plugin removes the <code>no-store</code> directive. In its place, it ensures that the <code>private</code> directive is sent to prevent proxies from caching the response; also, to ensure preserve privacy after logging out, it includes logic to invalidate pages from the bfcache so they cannot be re-accessed.</p>\n\n\n\n<p>What follows is an example of a site running Twenty Twenty-Five with the BuddyPress plugin and Slow 4G network emulation. After entering an activity status update, I navigate from the Personal tab to the Mentions and Favorites tabs. Then I use the back button to go back to the Personal tab. Without bfcache, navigating back from the Favorites tab to the Personal tab is very slow since (1) the browser has to re-fetch the HTML from the server, and (2) the DOM has to be completely reconstructed. Without bfcache, there is also the unfortunate result that the drafted status update is lost, since the form field was re-constructed with JavaScript. In contrast, when bfcache is enabled, navigating to the previous tabs is instant, and the DOM is preserved with each navigation, resulting in the drafted status update being kept intact:</p>\n\n\n\n<div class=\"wp-block-columns is-not-stacked-on-mobile is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-video aligncenter\"><video controls=\"controls\" height=\"1080\" poster=\"https://weston.ruter.net/wp-content/uploads/2025/08/buddypress-poster.jpg\" src=\"https://weston.ruter.net/wp-content/uploads/2025/08/buddypress-sans-bfcache.mp4\" width=\"788\"></video><figcaption class=\"wp-element-caption\">Without bfcache</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-video aligncenter\"><video controls=\"controls\" height=\"1080\" poster=\"https://weston.ruter.net/wp-content/uploads/2025/08/buddypress-poster.jpg\" src=\"https://weston.ruter.net/wp-content/uploads/2025/08/buddypress-with-bfcache.mp4\" width=\"788\"></video><figcaption class=\"wp-element-caption\">With bfcache</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>Without bfcache, the back navigation has an LCP of <strong>1.41 seconds</strong> whereas with bfcache the LCP is <strong>0.02 seconds</strong>: nearly instantaneous. </p>\n\n\n\n<p>There are other <a href=\"https://web.dev/articles/bfcache#optimize\">reasons</a> why pages may be ineligible for bfcache than the <code>no-store</code> directive, but it is one of the most common causes. It&#8217;s very important to try to preserve bfcache eligibility because back/forward navigations are <a href=\"https://web.dev/articles/bfcache#:~:text=Chrome%20usage%20data%20shows%20that%201%20in%2010%20navigations%20on%20desktop%20and%201%20in%205%20on%20mobile%20are%20either%20back%20or%20forward.\">very common</a> on the web:</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Chrome usage data shows that 1 in 10 navigations on desktop and 1 in 5 on mobile are either back or forward.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\" style=\"height: 100px;\"></div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"script-module-deprioritization\">Script Module Deprioritization</h3>\n\n\n\n<p>Moving on from instant page loads with Speculative Loading and bfcache, another way to shave off milliseconds on the LCP metric is to reduce network contention for loading the LCP element resource (e.g. an image). Consider a template with an Image block and a Navigation block, where the Image block has a lightbox and the Navigation block expands on mobile. These blocks use the Interactivity API which involves adding script modules to the page with the necessary logic. As noted previously, one of the key design principles of the Interactivity API is <a href=\"https://developer.wordpress.org/block-editor/reference-guides/interactivity-api/core-concepts/server-side-rendering/\">server-side rendering</a>. This means that by design the Navigation block and the Image block do <em>not</em> need their script modules in the critical rendering path.</p>\n\n\n\n<p>It turns out that these script modules are currently loaded with high priority because the browser doesn&#8217;t know they aren&#8217;t critical. So they compete with the loading of critical resources, like the LCP image, even though script modules aren&#8217;t render blocking.</p>\n\n\n\n<p>I&#8217;ve written a <a href=\"https://weston.ruter.net/2025/05/26/improve-lcp-by-deprioritizing-interactivity-api-script-modules/\">separate post</a> all about this problem and the solution:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-weston-ruter wp-block-embed-weston-ruter\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://weston.ruter.net/2025/05/26/improve-lcp-by-deprioritizing-interactivity-api-script-modules/\">Improve LCP by Deprioritizing  Script Modules from the Interactivity API</a></blockquote>\n</div></figure>\n\n\n\n<p>To summarize, there are two ways to prevent script modules from delaying the loading of critical resources:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Add <code>fetchpriority=​low</code> to the <code>SCRIPT</code> module tags and the <code>modulepreload</code> <code>LINK</code>.</li>\n\n\n\n<li>Move the <code>SCRIPT</code> tags to the end of the <code>BODY</code> (the footer).</li>\n</ol>\n\n\n\n<p>Here are the results of these optimizations on an emulated broadband connection with an <code>IMG</code> as the LCP element:</p>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals\"><table><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>137.0</td><td>137.2</td><td>+0.2</td><td>+0.1%</td></tr><tr><td>LCP</td><td>406.0</td><td>368.8</td><td>-37.2</td><td><strong>-9.2%</strong></td></tr><tr><td>TTFB</td><td>33.7</td><td>33.6</td><td>-0.1</td><td>-0.1%</td></tr><tr><td>LCP-TTFB</td><td>371.7</td><td>336.0</td><td>-35.7</td><td>-9.6%</td></tr></tbody></table></figure>\n\n\n\n<p>This is a healthy LCP improvement, more impactful than using the Modern Image Formats with the AVIF format in my testing above. There are two plugins available on GitHub which implement these optimizations while waiting for them to be available in core:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/westonruter/script-fetchpriority-low\">Script Fetch Priority Low</a> (cf. <a href=\"https://core.trac.wordpress.org/ticket/61734\" title=\"Add the ability to handle &quot;fetchpriority&quot; to ES Modules and Import Maps\">#61734</a>)</li>\n\n\n\n<li><a href=\"https://github.com/westonruter/script-modules-in-footer\">Script Modules in Footer</a> (cf. <a href=\"https://core.trac.wordpress.org/ticket/63486\" title=\"Script modules should support being printed in the footer the same as classic scripts\">#63486</a>)</li>\n</ul>\n\n\n\n<div class=\"wp-block-spacer\" style=\"height: 100px;\"></div>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"minified-css-inlining\">Minified CSS Inlining</h3>\n\n\n\n<p>The final optimization I&#8217;m analyzing is the impact of eliminating render-blocking external stylesheets. With JavaScript, adding <code>defer</code> to a <code>SCRIPT</code> is an easy way to prevent them from blocking rendering (assuming they can be deferred). However, this is not so easy to do with external stylesheets. CSS is always render-blocking because otherwise there is a flash of unstyled content (FOUC). The web platform does not (<a href=\"https://scottjehl.com/posts/async-css-already/\">currently</a>) provide an official way to opt in to <a href=\"https://www.filamentgroup.com/lab/load-css-simpler/\">async CSS</a>. Instead, the best way to handle this is to inline the CSS in <code>STYLE</code> tags (at least for the critical CSS).</p>\n\n\n\n<p>On a vanilla WordPress install when loading the Sample Page, where the LCP element is text, there are two render-blocking stylesheets:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>The Navigation block&#8217;s <code>style.min.css</code></li>\n\n\n\n<li>The Twenty Twenty-Five theme&#8217;s <code>style.css</code></li>\n</ul>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large wp-lightbox-container\"><img alt=\"\" class=\"wp-image-36207 not-transparent\" height=\"243\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/twentytwentyfive-render-blocking-stylesheets.png?resize=700%2C243&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">External stylesheets in the DevTools network panel.</figcaption></figure>\n\n\n\n<p>Despite these render-blocking stylesheets, Lighthouse is giving the page a 100 performance score. But as I&#8217;ve said before, just because you have a 100 score in Lighthouse, this doesn&#8217;t mean you can do more. Even with a perfect Lighthouse score, there is actually an audit that is pointing out the performance problem: <a href=\"https://developer.chrome.com/docs/lighthouse/performance/render-blocking-resources\">Eliminate render-blocking resources</a>.</p>\n\n\n\n<figure class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img alt=\"Eliminate render-blocking resources — Est savings of 0 ms.\n\nResources are blocking the first paint of your page. Consider delivering critical JS/CSS inline and deferring all non-critical JS/styles. Learn how to eliminate render-blocking resources. FCP | LCP\n\nThere are a number of WordPress plugins that can help you inline critical assets or defer less important resources. Beware that optimizations provided by these plugins may break features of your theme or plugins, so you will likely need to make code changes.\" class=\"has-border-color has-accent-6-border-color wp-image-36208 not-transparent\" height=\"372\" src=\"https://i0.wp.com/weston.ruter.net/wp-content/uploads/2025/08/lighthouse-eliminate-render-blocking-resources.png?resize=700%2C372&#038;ssl=1\" width=\"700\" /><button class=\"lightbox-trigger\" type=\"button\">\n			<svg fill=\"none\" height=\"12\" viewBox=\"0 0 12 12\" width=\"12\" xmlns=\"http://www.w3.org/2000/svg\">\n				<path d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" fill=\"#fff\">\n			</svg>\n		</button></figure>\n\n\n\n<p>It&#8217;s strange that this audit has an overall estimated savings of zero milliseconds, but for the theme&#8217;s stylesheet it shows an estimated savings of 150 milliseconds.</p>\n\n\n\n<p>To inline these two stylesheets to prevent them from being render-blocking, what is needed is to:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Opt in to inline the (minified) theme&#8217;s <code>style.css</code>.</li>\n\n\n\n<li>Increase the <code>styles_inline_size_limit</code>.</li>\n</ol>\n\n\n\n<p>To inline Twenty Twenty-Five&#8217;s stylesheet, all that is required is to add the <code>path</code> data for where the registered style is located on the filesystem. This can be done as simply as follows:</p>\n\n\n<pre class=\"wp-block-code\"><span><code class=\"hljs language-php\">add_action(\n	<span class=\"hljs-string\">\'wp_enqueue_scripts\'</span>,\n	<span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> <span class=\"hljs-params\">()</span>: <span class=\"hljs-title\">void</span> </span>{\n		wp_style_add_data(\n			<span class=\"hljs-string\">\'twentytwentyfive-style\'</span>,\n			<span class=\"hljs-string\">\'path\'</span>,\n			get_parent_theme_file_path( <span class=\"hljs-string\">\'style.css\'</span> )\n		);\n	},\n	<span class=\"hljs-number\">20</span>\n);</code></span></pre>\n\n\n<p>However, since the stylesheet is not yet minified (cf. <a href=\"https://core.trac.wordpress.org/ticket/63012\" title=\"Bundled themes: Stylesheets should be minified\">#63012</a>), you can hack in runtime minification using a plugin like <a href=\"https://gist.github.com/westonruter/09e553a7b66d1a2e68cd5a9ed351c59b\">Twenty Twenty-Five Stylesheet Inlining</a>. This plugin is currently just in a Gist since I hope this will land soon in core for 6.9 via <a href=\"https://core.trac.wordpress.org/ticket/63007\" title=\"Bundled themes: Stylesheets for block themes are missing path data for inlining\">#63007</a>.</p>\n\n\n\n<p>To increase the limit for inline CSS, all that is needed is a simple filter. The default limit is 20 KB which seems low considering the inline CSS limit for an AMP page is 75 KB. To increase the limit to 30 KB which allows enough room for the Navigation block&#8217;s relatively stylesheet to be inlined, you can use this PHP code:</p>\n\n\n<pre class=\"wp-block-code\"><span><code class=\"hljs language-php\">add_filter(\n	<span class=\"hljs-string\">\'styles_inline_size_limit\'</span>,\n	<span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> <span class=\"hljs-params\">()</span>: <span class=\"hljs-title\">int</span> </span>{\n		<span class=\"hljs-keyword\">return</span> <span class=\"hljs-number\">30000</span>;\n	}\n);</code></span></pre>\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Plugin used for benchmarking below<pre class=\"wp-block-code\"><span><code class=\"hljs language-php\"><span class=\"hljs-meta\">&lt;?php</span>\n<span class=\"hljs-comment\">/**\n * Plugin Name: Increase Styles Inline Size Limit (styles_inline_size_limit)\n * Author: Weston Ruter\n * Update URI: false\n */</span>\nadd_filter(\n	<span class=\"hljs-string\">\'styles_inline_size_limit\'</span>,\n	<span class=\"hljs-keyword\">static</span> <span class=\"hljs-function\"><span class=\"hljs-keyword\">function</span> <span class=\"hljs-params\">()</span>: <span class=\"hljs-title\">int</span> </span>{\n		$limit = <span class=\"hljs-number\">-1</span>;\n		<span class=\"hljs-keyword\">if</span> ( <span class=\"hljs-keyword\">isset</span>( $_GET&#91;<span class=\"hljs-string\">\'styles_inline_size_limit\'</span>] ) ) {\n			$limit = (int) $_GET&#91;<span class=\"hljs-string\">\'styles_inline_size_limit\'</span>];\n		}\n		<span class=\"hljs-keyword\">if</span> ( $limit &lt; <span class=\"hljs-number\">0</span> ) {\n			$limit = <span class=\"hljs-number\">75000</span>;\n		}\n		<span class=\"hljs-keyword\">return</span> $limit;\n	}\n);</code></span></pre></details>\n\n\n\n<p>Increasing this limit in core is being tracked in <a href=\"https://core.trac.wordpress.org/ticket/63018\" title=\"Increase styles_inline_size_limit from 20,000 bytes\">#63018</a>. We still need to determine the optimal threshold for inlining, weighing against the benefits of serving stylesheets from the browser cache for subsequent page navigations.</p>\n\n\n\n<p>As for the performance impact of inlining these stylesheets, here are the results for the loading Sample Page on an emulated Fast 4G connection:</p>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals\"><table><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>409.1</td><td>228.4</td><td>-180.7</td><td>-44.2%</td></tr><tr><td>LCP</td><td>510.0</td><td>325.4</td><td>-184.6</td><td><strong>-36.2%</strong></td></tr><tr><td>TTFB</td><td>43.3</td><td>43.8</td><td>+0.6</td><td>+1.3%</td></tr><tr><td>LCP-TTFB</td><td>466.5</td><td>281.2</td><td>-185.4</td><td>-39.7%</td></tr></tbody></table></figure>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\">Benchmark command<pre class=\"wp-block-code\"><span><code class=\"hljs language-javascript\">npm run research -- benchmark-web-vitals \\\n	--url=<span class=\"hljs-string\">\"https://wcus-perf-talk-demo.local/sample-page/?enable_plugins=twentytwentyfive-stylesheet-inlining\"</span> \\\n	--url=<span class=\"hljs-string\">\"https://wcus-perf-talk-demo.local/sample-page/?enable_plugins=twentytwentyfive-stylesheet-inlining,increase-styles-inline-size-limit.php&amp;styles_inline_size_limit=30000\"</span> \\\n	--number=<span class=\"hljs-number\">50</span> \\\n	--network-conditions=<span class=\"hljs-string\">\"Fast 4G\"</span> \\\n	--emulate-device=<span class=\"hljs-string\">\"Moto G4\"</span> \\\n	--diff \\\n	--output=md</code></span></pre></details>\n\n\n\n<p>This decreases the LCP by over a third! </p>\n\n\n\n<p>And here are the results when emulating a Slow 3G connection:</p>\n\n\n\n<figure class=\"wp-block-table benchmark-web-vitals\"><table><thead><tr><th>Metric</th><th>Before</th><th>After</th><th>Diff (ms)</th><th>Diff (%)</th></tr></thead><tbody><tr><td>FCP</td><td>4206.5</td><td>2276.0</td><td>-1930.5</td><td>-45.9%</td></tr><tr><td>LCP</td><td>4308.3</td><td>2384.6</td><td>-1923.7</td><td><strong>-44.7%</strong>