<?php get_header(); ?>
<section class="hm_banner innerBanner" id="home">
    <div class="middle_caption">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="innerTxt">
                        <h1><?php the_title(); ?></h1>
                        <ul class="breadCrumb">
                            <li><a href="<?php echo get_site_url(); ?>">Home</a></li>
                            <li>Services</li>
                            <li><?php the_title(); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="stroke_dots one"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke1.png" alt="stroke-line"></div>
    <div class="stroke_dots two"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke2.png" alt="stroke-line"></div>
    <div class="stroke_dots three"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke3.png" alt="stroke-line"></div>
    <div class="stroke_dots four"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke4.png" alt="stroke-line"></div>
</section>
<?php if(get_field('1st_section_content') || get_field('1st_section_image')){ ?>
<section class="tspSec1 defaultPadding">
    <div class="container">
        <div class="row flex-md-row-reverse align-items-md-center">
            <div class="col-md-6">
                <?php $serimgeone = get_field('1st_section_image');
                        if (!empty($serimgeone)) {
                        $alt_text = !empty($serimgeone['alt']) ? $serimgeone['alt'] : $serimgeone['title']; ?>
                <div class="imgRound">
                    <img src="<?php echo esc_url($serimgeone['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                </div>
                <?php } ?>
            </div>
            <div class="col-md-6">
                <?php if(get_field('1st_section_heading')){ ?>
                <h2><?php echo get_field('1st_section_heading'); ?></h2>
                <?php } ?>
                <?php if(get_field('1st_section_content')){ ?>
                <p><?php echo get_field('1st_section_content'); ?></p>
                <?php } ?>
            </div>
        </div>
    </div>
</section>
<?php } ?>
<?php if( have_rows('2nd_section_list_repeater') ): ?>
<section class="hmSec2 tspSec2 defaultPadding80">
    <div class="container">
        <?php if(get_field('2nd_section_heading')){ ?>
            <h2><?php echo get_field('2nd_section_heading'); ?></h2>
        <?php } ?>
        <div class="row">
           <?php while( have_rows('2nd_section_list_repeater') ) : the_row();
            $sersecond_icon = get_sub_field('2nd_section_list_icon'); // assumes it's an Image field in ACF
                $img_url  = '';
                $img_alt  = '';
                
                if ( $sersecond_icon ) {
                    $img_url = esc_url( $sersecond_icon['url'] );
                    // if alt exists, use it, otherwise fallback to title
                    $img_alt = !empty($sersecond_icon['alt']) ? esc_attr($sersecond_icon['alt']) : esc_attr($sersecond_icon['title']);
                } ?>
            <div class="col-md-4">
                <div class="serItem">
                    <div class="serIcon">
                        <img src="<?php echo $img_url; ?>" alt="<?php echo $img_alt; ?>">
                    </div>
                    <h4><?php echo get_sub_field('2nd_section_list_title'); ?></h4>
                    <ul class="tickCircle">
                        <?php if( have_rows('2nd_section_service_details_list') ):
                    while( have_rows('2nd_section_service_details_list') ) : the_row(); ?>
                        <li><?php echo get_sub_field('2nd_section_service_details_text'); ?></li>
                    <?php endwhile; endif; ?>
                    </ul>
                </div>
            </div>
        <?php endwhile; ?>
        </div>
    </div>
</section>
<?php endif; ?>
<?php if(get_field('3rd_section_list') || get_field('3rd_section_image') || get_field('3rd_section_description')){ ?>
<section class="ctpSec3 defaultPadding">
    <div class="container">
        <div class="row align-items-md-center">
            <div class="col-md-6">
                <?php $serimgethree = get_field('3rd_section_image');
                        if (!empty($serimgethree)) {
                        $alt_text = !empty($serimgethree['alt']) ? $serimgethree['alt'] : $serimgethree['title']; ?>
                <div class="imgRound">
                    <img src="<?php echo esc_url($serimgethree['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                </div>
                <?php } ?>
            </div>
            <div class="col-md-6">
                <?php if(get_field('3rd_section_heading')){ ?>
                <h2><?php echo get_field('3rd_section_heading'); ?></h2><?php } ?>
                <?php if(get_field('3rd_section_description')){ ?>
                <p><?php echo get_field('3rd_section_description'); ?></p><?php } ?>
                <?php $whychoose_list = get_field('3rd_section_list'); 
                        if($whychoose_list){ ?>
                <ul class="tickCircle">
                    <?php foreach($whychoose_list as $whychooseitem){ ?>
                    <li><?php echo $whychooseitem['3rd_section_list_text']; ?></li>
                    <?php } ?>
                </ul>
                <?php } ?>
            </div>
        </div>
    </div>
</section>
<?php } ?>
<?php get_footer(); ?>

