<?php /* Template Name: About us */
get_header();
?>


<!-- ! Main ! -->

<section class="hm_banner innerBanner" id="home">
    <div class="middle_caption">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="innerTxt">
                        <h1><?php the_title(); ?></h1>
                        <ul class="breadCrumb">
                            <li><a href="<?php get_site_url(); ?>">Home</a></li>
                            <li><?php the_title(); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="stroke_dots one"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke1.png" alt="stroke-line"></div>
    <div class="stroke_dots two"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke2.png" alt="stroke-line"></div>
    <div class="stroke_dots three"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke3.png" alt="stroke-line"></div>
    <div class="stroke_dots four"><img src="<?php echo get_template_directory_uri(); ?>/images/stroke4.png" alt="stroke-line"></div>
</section>
<?php if( have_rows('about_details_list') ): ?>
<section class="abtSec1 defaultPadding">
    <div class="container">
        <?php $i = 1;
         while( have_rows('about_details_list') ) : the_row();
            if($i%2 == 0){
            $abt_icon = get_sub_field('about_details_image'); // assumes it's an Image field in ACF
                $img_url  = '';
                $img_alt  = '';
                
                if ( $abt_icon ) {
                    $img_url = esc_url( $abt_icon['url'] );
                    // if alt exists, use it, otherwise fallback to title
                    $img_alt = !empty($abt_icon['alt']) ? esc_attr($abt_icon['alt']) : esc_attr($abt_icon['title']);
                } ?>
                <div class="row align-items-md-center otherMag">
            <div class="col-md-6">
                <div class="imgRound">
                    <img src="<?php echo $img_url; ?>" alt="<?php echo $img_alt; ?>">
                </div>
            </div>
            <div class="col-md-6">
                <?php if( have_rows('about_list') ):
                while( have_rows('about_list') ) : the_row(); ?>
                <h2><?php echo get_sub_field('about_list_title'); ?></h2>
                <p><?php echo get_sub_field('about_list_content'); ?></p>
                <?php endwhile; endif; ?>
            </div>
        </div>
    <?php } else {
    $abt_icon = get_sub_field('about_details_image'); // assumes it's an Image field in ACF
                $img_url  = '';
                $img_alt  = '';
                
                if ( $abt_icon ) {
                    $img_url = esc_url( $abt_icon['url'] );
                    // if alt exists, use it, otherwise fallback to title
                    $img_alt = !empty($abt_icon['alt']) ? esc_attr($abt_icon['alt']) : esc_attr($abt_icon['title']);
                } ?>
        <div class="row flex-md-row-reverse align-items-md-center mb100">
            <div class="col-md-6">
                <div class="imgRound">
                    <img src="<?php echo $img_url; ?>" alt="<?php echo $img_alt; ?>">
                </div>
            </div>
            <div class="col-md-6">
                <?php if( have_rows('about_list') ):
                while( have_rows('about_list') ) : the_row(); ?>
                <h2><?php echo get_sub_field('about_list_title'); ?></h2>
                <p><?php echo get_sub_field('about_list_content'); ?></p>
                <?php endwhile; endif; ?>
            </div>
        </div>
        <?php } $i++; endwhile; ?>
    </div>
</section>
<?php endif; ?>
<?php $valueslist = get_field('our_values_list'); 
        if($valueslist){ ?>
<section class="hmSec2 abtSec2 defaultPadding80">
    <div class="container">
        <div class="row">
            <div class="col-md-4">
                <?php if(get_field('our_values_heading')){ ?>
                <h2><?php echo get_field('our_values_heading'); ?></h2>
                 <?php } ?>
                 <?php if(get_field('our_values_content')){ ?>
                <p><?php echo get_field('our_values_content'); ?></p><?php } ?>
            </div>
            <?php foreach ($valueslist as $valuesitem) { ?>
            <div class="col-md-4">
                <div class="serItem numberEach">
                    <div class="serIcon">
                        <span class="counts"></span>
                    </div>
                    <h3><?php echo $valuesitem['our_values_title']; ?></h3>
                    <p><?php echo $valuesitem['our_values_content']; ?></p>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
</section>
<?php } ?>
<?php if(get_field('approach_heading') || get_field('approach_description')){ ?>
<section class="abtSec3 defaultPadding">
    <div class="container">
        <div class="row flex-md-row-reverse align-items-md-center">
            <div class="col-md-6">
                <?php $appimg = get_field('approach_image');
                        if (!empty($appimg)) {
                        $alt_text = !empty($appimg['alt']) ? $appimg['alt'] : $appimg['title']; ?>
                <div class="imgRound">
                    <img src="<?php echo esc_url($appimg['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
                </div>
                <?php } ?>
            </div>
            <div class="col-md-6">
                <?php if(get_field('approach_heading')){ ?>
                <h2><?php echo get_field('approach_heading'); ?></h2>
                 <?php } ?>
                <?php if(get_field('approach_description')){ ?>
                <p><?php echo get_field('approach_description'); ?></p>
                 <?php } ?>
            </div>
        </div>
    </div>
</section>
<?php } ?>

<!-- ! Main end ! -->

<?php get_footer(); ?>