$(document).ready(function () {
  function setAvailableHeight() {
    const header = document.querySelector("header");
    const footer = document.querySelector("footer");

    const headerHeight = header ? header.offsetHeight : 0;
    const footerHeight = footer ? footer.offsetHeight : 0;

    const availableHeight = window.innerHeight - headerHeight - footerHeight;

    document.documentElement.style.setProperty(
      "--available-height",
      `${availableHeight}px`
    );
  }

  setAvailableHeight();
  window.addEventListener("resize", setAvailableHeight);
  window.addEventListener("orientationchange", setAvailableHeight);

  // ------------------------------------------------------------
  // Slimnav jquery start ----------
  $("#navigation nav").slimNav_sk78();
  $("#nav-icon0").click(function () {
    $(this).toggleClass("open");
  });
  // Slimnav jquery end ----------
  // ------------------------------------------------------------

  // ------------------------------------------------------------
  // home sec2 slider start ----------
  $(".owl-carousel.what-we-do").owlCarousel({
    loop: true,
    margin: 30,
    nav: false,
    dots: true,
    responsive: {
      0: {
        items: 1,
      },
      768: {
        items: 2,
      },
      992: {
        items: 3,
      },
    },
  });
  // home sec2 slider end ----------
  // ------------------------------------------------------------

  // ------------------------------------------------------------
  // home sec3 slider start ----------
  $(".owl-carousel.our-impact").owlCarousel({
    loop: true,
    margin: 0,
    nav: true,
    dots: false,
    items: 1,
  });
  // home sec3 slider end ----------
  // ------------------------------------------------------------

  // ------------------------------------------------------------
  //  On scroll counter animation start
  let counted = 0;
  $(window).on("scroll", function () {
    const oTop = $("#counter").offset().top - window.innerHeight;

    if (counted === 0 && $(window).scrollTop() > oTop) {
      $(".count").each(function () {
        const $this = $(this);
        const countTo = $this.attr("data-count");

        $({ countNum: $this.text() }).animate(
          { countNum: countTo },
          {
            duration: 2000,
            easing: "swing",
            step: function () {
              $this.text(Math.floor(this.countNum));
            },
            complete: function () {
              $this.text(this.countNum);
            },
          }
        );
      });
      counted = 1;
    }
  });
  //  On scroll counter animation end
  // ------------------------------------------------------------
});
