<?php

if ( ! isset( $content_width ) )
	$content_width = 604;

function admin_bar(){

  if(is_user_logged_in()){
    add_filter( 'show_admin_bar', '__return_true' , 1000 );
  }
}
add_action('init', 'admin_bar' );

function smtheme_setup() {

	register_nav_menu( 'primary', __( 'Primary Menu', 'smtheme' ) );
    register_nav_menu( 'footer', __( 'Footer Menu', 'smtheme' ) );
	register_nav_menu( 'legal1', __( 'Legal 1 Menu', 'smtheme' ) );
    register_nav_menu( 'legal2', __( 'Legal 2 Menu', 'smtheme' ) );


 	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
    add_image_size( 'team', 356, 341, true );





	//set_post_thumbnail_size( 604, 270, true );
}
add_action( 'after_setup_theme', 'smtheme_setup' );



function smtheme_wp_title( $title, $sep ) {
	global $paged, $page;
	if ( is_feed() )
		return $title;
	$title .= get_bloginfo( 'name', 'display' );
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title = "$title $sep $site_description";
	if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() )
		$title = "$title $sep " . sprintf( __( 'Page %s', 'smtheme_wp_title' ), max( $paged, $page ) );
	return $title;
}
add_filter( 'wp_title', 'smtheme_wp_title', 10, 2 );



function smtheme_scripts_styles() {
  wp_enqueue_style( 'smtheme-style', get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'smtheme-style', get_stylesheet_uri(), array(), '2025-12-08' );
	
}
add_action( 'wp_enqueue_scripts', 'smtheme_scripts_styles' );


function theme_enqueue_styles_scripts() {

    // CSS
    wp_enqueue_style('bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css', array(), '4.6');
    wp_enqueue_style('owl-carousel', get_template_directory_uri() . '/css/owl.carousel.min.css', array(), '2.3.4');
    wp_enqueue_style('owl-theme', get_template_directory_uri() . '/css/owl.theme.default.css', array(), '2.3.4');
    wp_enqueue_style('slimnav', get_template_directory_uri() . '/css/slimNav_sk78.css', array(), '1.0');

    // Font Awesome CDN
    wp_enqueue_style(
        'font-awesome',
        'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css',
        array(),
        '6.5.1'
    );

    wp_enqueue_style('main-style', get_template_directory_uri() . '/css/style.css', array(), '1.0');
    wp_enqueue_style('responsive', get_template_directory_uri() . '/css/responsive.css', array(), '1.0');

    // JS
    wp_enqueue_script('jquery'); // WordPress default jQuery

    wp_enqueue_script('bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'), '4.6', true);
    wp_enqueue_script('slimnav-js', get_template_directory_uri() . '/js/jquery.slimNav_sk78.min.js', array('jquery'), '1.0', true);
    wp_enqueue_script('owl-carousel-js', get_template_directory_uri() . '/js/owl.carousel.js', array('jquery'), '2.3.4', true);
    wp_enqueue_script('custom-js', get_template_directory_uri() . '/js/script.js', array('jquery'), '1.0', true);
}
add_action('wp_enqueue_scripts', 'theme_enqueue_styles_scripts');





function custom_excerpt_length($length) {
    return 30;
}
add_filter('excerpt_length', 'custom_excerpt_length');




//Upload SVG images
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {
    $filetype = wp_check_filetype( $filename, $mimes );
    return [
        'ext'             => $filetype['ext'],
        'type'            => $filetype['type'],
        'proper_filename' => $data['proper_filename']
    ];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  
  function fix_svg() {
    echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
  }
  add_action( 'admin_head', 'fix_svg' );


  // Remove <p> and <br/> from Contact Form 7
add_filter('wpcf7_autop_or_not', '__return_false');

