<?php /* Template Name: Home */
get_header();
 ?>
 <?php if(get_field('banner_video') || get_field('banner_subheading') || get_field('banner_button_1') || get_field('banner_button_2')){ ?>
<section class="home-banner">
    <div class="video-wraper">
        <?php if(get_field('banner_video')){ ?>
        <video src="<?php echo get_field('banner_video'); ?>" autoplay loop muted></video>
        <?php } ?>
    </div>
    <div class="content-wraper">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <?php if(get_field('banner_heading')){ ?>
                    <h1><?php echo get_field('banner_heading'); ?></h1>
                    <?php } ?>
                    <?php if(get_field('banner_subheading')){ ?>
                    <p><?php echo get_field('banner_subheading'); ?></p>
                    <?php } ?>
                    <div class="btn-wraper">
                        <?php $banner_button_1 = get_field('banner_button_1');
                        if ($banner_button_1):
                            $link_url = $banner_button_1['url'];
                            $link_title = $banner_button_1['title'];
                            $link_target = $banner_button_1['target'] ? $banner_button_1['target'] : '_self';
                        ?>
                        <a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="white-btn"><?php echo esc_html($link_title); ?> <img src="<?php echo get_template_directory_uri(); ?>/images/btn-arow-red.svg" alt="btn-arow-red"></a>
                        <?php endif; ?>
                        <?php $banner_button_2 = get_field('banner_button_2');
                        if ($banner_button_2):
                            $link_url = $banner_button_2['url'];
                            $link_title = $banner_button_2['title'];
                            $link_target = $banner_button_2['target'] ? $banner_button_2['target'] : '_self';
                        ?>
                        <a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="border-btn"><?php echo esc_html($link_title); ?> <img src="<?php echo get_template_directory_uri(); ?>/images/btn-arow-white.svg" alt="btn-arow-white"></a>
                    <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php } ?>
<?php if(get_field('about_section_heading') || get_field('about_section_image') || get_field('about_section_subheading') || get_field('about_section_content')){ ?>
<section class="home-sec2">
    <img src="<?php echo get_template_directory_uri(); ?>/images/bg-img.png" alt="bg-img" class="bg-img">
    <div class="container">
        <div class="row align-items-lg-center">
            <div class="col-lg-12">
                <?php if(get_field('about_section_heading')){ ?>
                <h2><?php echo get_field('about_section_heading'); ?></h2>
                <?php } ?>
            </div>
            <div class="col-lg-6">
                <?php $abt_image = get_field('about_section_image');
                if (!empty($abt_image)) {
                    $alt_text = !empty($abt_image['alt']) ? $abt_image['alt'] : $abt_image['title']; ?>
                <img src="<?php echo esc_url($abt_image['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>" class="circle-shape">
            <?php } ?>
            </div>
            <div class="col-lg-6">
                <?php if(get_field('about_section_subheading')){ ?>
                <h3><?php echo get_field('about_section_subheading'); ?></h3>
                <?php } ?>
                <?php if(get_field('about_section_content')){ ?>
                <?php echo get_field('about_section_content'); ?>
                <?php } ?>
                <?php $about_link = get_field('about_link');
                        if ($about_link):
                            $link_url = $about_link['url'];
                            $link_title = $about_link['title'];
                            $link_target = $about_link['target'] ? $about_link['target'] : '_self';
                        ?>
                <a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="red-btn"><?php echo esc_html($link_title); ?> <img src="<?php echo get_template_directory_uri(); ?>/images/btn-arow-white.svg" alt="btn-arow-white"></a>
            <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<div class="shape">
    <img src="<?php echo get_template_directory_uri(); ?>/images/assignments-shape.png" style="
    background: #EEFDFF;
    width: 100%;
">
</div>
<?php } ?>
<?php if(get_field('service_card')){ ?>
<section class="home-sec3">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <?php if(get_field('service_section_heading')){ ?>
                <h2><?php echo get_field('service_section_heading'); ?></h2>
                <?php } ?>
            </div>
            <?php $service_card = get_field('service_card');
                        if ($service_card) {
                            foreach ($service_card as $serviceitem) {
                                // Get the image (assumed to be ACF image field stored as array)
                                $service_icon = $serviceitem['service_image']; // assuming 'icon_image' is your image field
                                if (!empty($service_icon)) {
                                    $service_img_url = $service_icon['url'];
                                    $service_img_alt = $service_icon['alt'] ?: $service_icon['title'];
                                    } else{
                                    // Fallback default image
                                    $service_img_url = get_template_directory_uri() . '/images/s1.png';
                                    $service_img_alt = 'Default Service Image';
                                    } ?>
            <div class="col-lg-4 col-md-6">
                <div class="service-card">
                    <?php $service_link = $serviceitem['service_link'];
                        if ($service_link):
                            $link_url = $service_link['url'];
                            $link_title = $service_link['title'];
                            $link_target = $service_link['target'] ? $service_link['target'] : '_self';
                        ?> 
                    <a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="pabs"></a>
                <?php endif; ?>
                    <img src="<?php echo esc_url($service_img_url); ?>" alt="<?php echo esc_attr($service_img_alt); ?>" class="service-img">
                    <span class="arow"><img src="<?php echo get_template_directory_uri(); ?>/images/btn-arow-red.svg" alt="btn-arow-red"></span>
                    <div class="text-wraper">
                        <h4><?php echo $serviceitem['service_title']; ?></h4>
                        <p><?php echo $serviceitem['service_subtitle']; ?></p>
                    </div>
                </div>
            </div>
        <?php } } ?>
        </div>
    </div>
</section>
<?php } ?>
<section class="home-sec4">
    <div class="container">
        <div class="row">
            <div class="col-lg-7">
                <?php if(get_field('section_four_heading')){ ?>
                <h2><?php echo get_field('section_four_heading'); ?></h2><?php } ?>
                <div class="white-box">
                    <div class="text-wraper">
                        <?php if(get_field('left_side_title')){ ?>
                        <h4><?php echo get_field('left_side_title'); ?></h4>
                        <?php } ?>
                        <?php if(get_field('left_side_content')){ ?>
                        <p><?php echo get_field('left_side_content'); ?></p>
                        <?php } ?>
                    </div>
                   <?php $left_image = get_field('left_side_image'); // assuming 'icon_image' is your image field
                                if (!empty($left_image)) {
                                    $service_img_url = $left_image['url'];
                                    $service_img_alt = $left_image['alt'] ?: $left_image['title'];
                                    } else{
                                    // Fallback default image
                                    $service_img_url = get_template_directory_uri() . '/images/board2.png';
                                    $service_img_alt = 'Default Image';
                                    } ?>
                    <img src="<?php echo esc_url($service_img_url); ?>" alt="<?php echo esc_attr($service_img_alt); ?>" class="board">
                </div>
            </div>
            <div class="col-lg-5">
                <div class="black-box">
                    <div class="text-wraper">
                        <?php if(get_field('right_side_title')){ ?>
                        <h4><?php echo get_field('right_side_title'); ?></h4>
                        <?php } ?>
                        <?php if(get_field('right_side_content')){ ?>
                        <p><?php echo get_field('right_side_content'); ?></p>
                        <?php } ?>
                    </div>
                     <?php $right_image = get_field('right_side_image'); // assuming 'icon_image' is your image field
                                if (!empty($right_image)) {
                                    $service_img_url = $right_image['url'];
                                    $service_img_alt = $right_image['alt'] ?: $right_image['title'];
                                    } else{
                                    // Fallback default image
                                    $service_img_url = get_template_directory_uri() . '/images/board1.png';
                                    $service_img_alt = 'Default Image';
                                    } ?>
                    <img src="<?php echo esc_url($service_img_url); ?>" alt="<?php echo esc_attr($service_img_alt); ?>" class="board">
                </div>
                <?php $link = get_field('four_section_link');
                        if ($link):
                            $link_url = $link['url'];
                            $link_title = $link['title'];
                            $link_target = $link['target'] ? $link['target'] : '_self';
                        ?>
                <a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="red-btn"><?php echo esc_html($link_title); ?> <img src="<?php echo get_template_directory_uri(); ?>/images/btn-arow-white.svg" alt="btn-arow-white"></a>
            <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<section class="home-sec5">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <?php if(get_field('section_five_heading')){ ?>
                        <h2><?php echo get_field('section_five_heading'); ?></h2>
                    <?php } ?>
                    <?php if(get_field('section_five_subheading')){ ?>
                <p><?php echo get_field('section_five_subheading'); ?></p>
                <?php } ?>
            </div>
        </div>
    </div>
    <div class="marquee-container">
        <div class="marquee" id="marquee">
            <div class="marquee-content">
                <?php $logo_img = get_field('marine_surveyor_logo');
                        if ($logo_img) {
                            foreach ($logo_img as $logoimg) {
                                // Get the image (assumed to be ACF image field stored as array)
                                $logo_icon = $logoimg['logo_image']; // assuming 'icon_image' is your image field
                                if (!empty($logo_icon)) {
                                    $alt_text = !empty($logo_icon['alt']) ? $logo_icon['alt'] : $logo_icon['title']; ?>
                <img src="<?php echo esc_url($logo_icon['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>">
            <?php } } } ?>
            </div>
        </div>
    </div>
</section>
<?php $email = get_field('email','option');
$phone = get_field('phone','option'); ?>
<section class="home-sec6">
    <img src="<?php echo get_template_directory_uri(); ?>/images/contact-bg.png" alt="contact-bg" class="bg-img">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <?php if(get_field('form_section_heading','option')){ ?>
                <h2><?php echo get_field('form_section_heading','option'); ?></h2>
                <?php } ?>
                <?php if(get_field('form_section_content','option')){ ?>
                <?php echo get_field('form_section_content','option'); ?>
                <?php } ?>
                <ul>
                    <?php if(get_field('address','option')){ ?>
                    <li>
                        <img src="<?php echo get_template_directory_uri(); ?>/images/mark.svg" alt="mark">
                        <span><?php echo get_field('address','option') ?></span>
                    </li>
                    <?php } ?>
                    <?php if($email){ ?>
                    <li>
                        <img src="<?php echo get_template_directory_uri(); ?>/images/email2.svg" alt="">
                        <a href="mailto:<?php echo $email; ?>"><?php echo $email; ?></a>
                    </li><?php } ?>
                    <?php if($email){ ?>
                    <li>
                        <img src="<?php echo get_template_directory_uri(); ?>/images/phone2.svg" alt="phone-image">
                        <a href="tel:<?php echo $phone; ?>"><?php echo $phone; ?></a>
                        <small>Primary</small>
                    </li><?php } ?>
                    <?php if(get_field('other_phone_number','option')){ ?>
                    <li>
                        <img src="<?php echo get_template_directory_uri(); ?>/images/phone2.svg" alt="phone-image">
                        <a href="tel:<?php echo get_field('other_phone_number','option') ?>"><?php echo get_field('other_phone_number','option') ?></a>
                    </li><?php } ?>
                </ul>
            </div>
            <div class="col-lg-6">
                <div class="white-box-wraper">
                    <h4>Contact Form</h4>
                    <form action="">
                        <div class="flex-box">
                            <div class="fild-wraper">
                                <label for="">First Name<span>*</span></label>
                                <input type="text" placeholder="John">
                            </div>
                            <div class="fild-wraper">
                                <label for="">Last Name<span>*</span></label>
                                <input type="text" placeholder="Doe">
                            </div>
                        </div>
                        <div class="fild-wraper">
                            <label for="">Address<span>*</span></label>
                            <input type="text" placeholder="Enter your address">
                        </div>
                        <div class="flex-box">
                            <div class="fild-wraper">
                                <label for="">City/Town/State<span>*</span></label>
                                <input type="text" placeholder="Town name">
                            </div>
                            <div class="fild-wraper">
                                <label for="">Zip Code<span>*</span></label>
                                <input type="number" placeholder="000000">
                            </div>
                        </div>
                        <div class="flex-box">
                            <div class="fild-wraper">
                                <label for="">Phone<span>*</span></label>
                                <input type="number">
                            </div>
                            <div class="fild-wraper">
                                <label for="">Email<span>*</span></label>
                                <input type="email" placeholder="@gmail.com">
                            </div>
                        </div>
                        <div class="fild-wraper">
                            <label for="">Comments<span>*</span></label>
                            <textarea name="" id="" placeholder="Write your comments here..."></textarea>
                        </div>
                        <div class="red-btn"><span>Submit</span> <img src="<?php echo get_template_directory_uri(); ?>/images/btn-arow-white.svg" alt=""><input type="submit" value=""></div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>




