<?php /* Template Name: Service */
get_header();
 ?>
<?php if(get_field('banner_image') || get_field('banner_title') || get_field('banner_subtitle')){ ?>
 <section class="inner-banner">
 	<?php $banner_image = get_field('banner_image');
                if (!empty($banner_image)) {
                    $alt_text = !empty($banner_image['alt']) ? $banner_image['alt'] : $banner_image['title']; ?>
        <img src="<?php echo esc_url($banner_image['url']); ?>" alt="<?php echo esc_attr($alt_text); ?>" class="inner-bg">
    	<?php } else{ ?>
        <img src="<?php echo get_template_directory_uri(); ?>/images/service-inner.png" alt="service-inner" class="inner-bg">
    	<?php } ?>
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                	<?php if(get_field('banner_title')){ ?>
                    <h1><?php echo get_field('banner_title'); ?></h1>
                	<?php } ?>
                	<?php if(get_field('banner_subtitle')){ ?>
                    <p><?php echo get_field('banner_subtitle'); ?></p>
                	<?php } ?>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
    <section class="service-sec1">
        <div class="container">
            <div class="heading-wraper">
            	<?php if(get_field('2nd_section_heading')){ ?>
                <h2><?php echo get_field('2nd_section_heading'); ?></h2>
            	<?php } ?>
            	<?php if(get_field('2nd_section_content')){ ?>
                <?php echo get_field('2nd_section_content'); ?>
            	<?php } ?>
            </div>
            <div class="row">
                <div class="col-lg-6 col-md-6">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/service1.png" alt="" class="side-img">
                </div>
                <div class="col-lg-6 col-md-6">
                    <h3>Pre-Purchase Condition & Valuation Survey</h3>
                    <h4>Make an informed investment before you buy.</h4>
                    <p>A comprehensive inspection designed to inform prospective buyers of a vessel's current condition, operational integrity, and fair market value. This survey provides the critical insight needed to make an informed investment and avoid costly surprises.</p>
                    <div class="shadow-box">
                        <h5>Your report includes:</h5>
                        <ul>
                            <li>Detailed findings with high-resolution images</li>
                            <li>Recommended repairs and maintenance notes</li>
                            <li>Compliance with ABYC, NFPA, and U.S.C.G. standards</li>
                            <li>Fair market and replacement value estimates</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 col-md-6">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/service2.png" alt="" class="side-img">
                </div>
                <div class="col-lg-6 col-md-6">
                    <h3>Insurance Underwriting & Renewal Survey</h3>
                    <h4>Ensure your vessel meets insurance standards.</h4>
                    <p>Conducted to meet insurer requirements, these surveys assess a vessel’s
                    seaworthiness, safety equipment, and structural condition. The findings help
                    determine insurability and inform policy underwriting or renewal terms.</p>
                    <div class="shadow-box">
                        <h5>Includes:</h5>
                        <ul>
                            <li>Vessel identification and specifications</li>
                            <li>Safety equipment verification (per U.S.C.G. standards)</li>
                            <li>Structural and system integrity review</li>
                            <li>Recommendations for compliance or repair</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 col-md-6">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/service3.png" alt="" class="side-img">
                </div>
                <div class="col-lg-6 col-md-6">
                    <h3>Damage & Loss Assessment Survey</h3>
                    <h4>Accurate documentation when you need it most.</h4>
                    <p>An objective evaluation of damages resulting from accidents, storms, or other
                    marine incidents. This service supports accurate claims processing, repair
                    validation, and negotiation with insurance providers or third parties.</p>
                    <div class="shadow-box">
                        <h5>Covers:</h5>
                        <ul>
                            <li>Post-incident structural and mechanical inspection</li>
                            <li>Damage cause determination</li>
                            <li>Repair estimates and validation</li>
                            <li>Photo documentation for claims</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 col-md-6">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/service4.png" alt="" class="side-img">
                </div>
                <div class="col-lg-6 col-md-6">
                    <h3>Financial & Collateral Evaluation Survey</h3>
                    <h4>Trusted valuations for lenders and institutions.</h4>
                    <p>Often required by lenders, this survey assesses the vessel’s condition and value
                    when used as loan collateral. It provides financial institutions with confidence in
                    the asset’s reliability and market standing</p>
                    <div class="shadow-box">
                        <h5>Includes:</h5>
                        <ul>
                            <li>Full condition report</li>
                            <li>Market valuation analysis</li>
                            <li>Compliance verification (ABYC, NFPA)</li>
                            <li>Certification for financial documentation</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 col-md-6">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/service5.png" alt="" class="side-img">
                </div>
                <div class="col-lg-6 col-md-6">
                    <h3>Fair Market & Replacement Value Appraisal</h3>
                    <h4>Know your vessel’s true worth.</h4>
                    <p>A detailed valuation report reflecting the current market or replacement value of a
                    vessel, based on age, condition, and comparable sales. Ideal for estate planning,
                    financing, or legal matters where precise valuation is essential.</p>
                    <div class="shadow-box">
                        <h5>Includes:</h5>
                        <ul>
                            <li>Comparable sales and market data</li>
                            <li>Current and replacement value assessments</li>
                            <li>Condition-based valuation summary</li>
                            <li>Professional certification for financial or legal use</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 col-md-6">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/service6.png" alt="" class="side-img">
                </div>
                <div class="col-lg-6 col-md-6">
                    <h3>General Condition & Compliance Survey</h3>
                    <h4>Maintain your vessel’s health and safety.</h4>
                    <p>A comprehensive inspection that evaluates the vessel’s overall condition and
                    verifies compliance with applicable safety and regulatory standards-including an
                    assessment of onboard safety equipment as required by U.S. Coast Guard
                    (U.S.C.G.) federal regulations. This survey is particularly valuable for owners
                    aiming to maintain vessel integrity, ensure regulatory readiness, or prepare for
                    upgrades, refits, or changes in use.</p>
                    <div class="shadow-box">
                        <h5>Includes:</h5>
                        <ul>
                            <li>Full vessel inspection and maintenance summary</li>
                            <li>Review of electrical, fuel, plumbing, and mechanical systems</li>
                            <li>Verification of safety and fire protection equipment</li>
                            <li>Compliance with ABYC, NFPA, and U.S.C.G. standards</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="home-sec6">
        <img src="<?php echo get_template_directory_uri(); ?>/images/contact-bg.png" alt="" class="bg-img">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <h2>Have a question or need a quote?</h2>
                    <p>We invite you to complete our <span>contact form</span>, and
                    a qualified marine surveyor will be pleased to assist you in determining the most
                    suitable service based on your vessel and intended use.</p>
                    <p>For an accurate and timely quotation, kindly include the vessel’s year, make, and model,
                    along with its current location.</p>
                    <ul>
                        <li>
                            <img src="<?php echo get_template_directory_uri(); ?>/images/mark.svg" alt="">
                            <span>Scott J. Schiffman <br> 1204 Avenue U Brooklyn, <br> NY 11229</span>
                        </li>
                        <li>
                            <img src="<?php echo get_template_directory_uri(); ?>/images/email2.svg" alt="">
                            <a href="">scottmarinesurveyor1984@gmail.com</a>
                        </li>
                        <li>
                            <img src="<?php echo get_template_directory_uri(); ?>/images/phone2.svg" alt="">
                            <a href="">718-377-6764</a>
                            <small>Primary</small>
                        </li>
                        <li>
                            <img src="<?php echo get_template_directory_uri(); ?>/images/phone2.svg" alt="">
                            <a href="">917-497-7969</a>
                        </li>
                    </ul>
                </div>
                <div class="col-lg-6">
                    <div class="white-box-wraper">
                        <h4>Contact Form</h4>
                        <form action="">
                            <div class="flex-box">
                                <div class="fild-wraper">
                                    <label for="">First Name<span>*</span></label>
                                    <input type="text" placeholder="John">
                                </div>
                                <div class="fild-wraper">
                                    <label for="">Last Name<span>*</span></label>
                                    <input type="text" placeholder="Doe">
                                </div>
                            </div>
                            <div class="fild-wraper">
                                <label for="">Address<span>*</span></label>
                                <input type="text" placeholder="Enter your address">
                            </div>
                            <div class="flex-box">
                                <div class="fild-wraper">
                                    <label for="">City/Town/State<span>*</span></label>
                                    <input type="text" placeholder="Town name">
                                </div>
                                <div class="fild-wraper">
                                    <label for="">Zip Code<span>*</span></label>
                                    <input type="number" placeholder="000000">
                                </div>
                            </div>
                            <div class="flex-box">
                                <div class="fild-wraper">
                                    <label for="">Phone<span>*</span></label>
                                    <input type="number">
                                </div>
                                <div class="fild-wraper">
                                    <label for="">Email<span>*</span></label>
                                    <input type="email" placeholder="@gmail.com">
                                </div>
                            </div>
                            <div class="fild-wraper">
                                <label for="">Comments<span>*</span></label>
                                <textarea name="" id="" placeholder="Write your comments here..."></textarea>
                            </div>
                            <div class="red-btn"><span>Submit</span> <img src="<?php echo get_template_directory_uri(); ?>/images/btn-arow-white.svg" alt=""><input type="submit" value=""></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php get_footer(); ?>