<?php

if ( ! isset( $content_width ) )
	$content_width = 604;

function admin_bar(){

  if(is_user_logged_in()){
    add_filter( 'show_admin_bar', '__return_true' , 1000 );
  }
}
add_action('init', 'admin_bar' );

function smtheme_setup() {

	register_nav_menu( 'primary', __( 'Primary Menu', 'smtheme' ) );
    register_nav_menu( 'footer', __( 'Footer Menu', 'smtheme' ) );
	register_nav_menu( 'legal1', __( 'Legal 1 Menu', 'smtheme' ) );
    register_nav_menu( 'legal2', __( 'Legal 2 Menu', 'smtheme' ) );


 	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
    add_image_size( 'team', 356, 341, true );





	//set_post_thumbnail_size( 604, 270, true );
}
add_action( 'after_setup_theme', 'smtheme_setup' );



function smtheme_wp_title( $title, $sep ) {
	global $paged, $page;
	if ( is_feed() )
		return $title;
	$title .= get_bloginfo( 'name', 'display' );
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title = "$title $sep $site_description";
	if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() )
		$title = "$title $sep " . sprintf( __( 'Page %s', 'smtheme_wp_title' ), max( $paged, $page ) );
	return $title;
}
add_filter( 'wp_title', 'smtheme_wp_title', 10, 2 );



function smtheme_scripts_styles() {
  wp_enqueue_style( 'smtheme-style', get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'smtheme-style', get_stylesheet_uri(), array(), '2024-12-19' );
	
}
add_action( 'wp_enqueue_scripts', 'smtheme_scripts_styles' );




function custom_excerpt_length($length) {
    return 30;
}
add_filter('excerpt_length', 'custom_excerpt_length');




//Upload SVG images
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {
    $filetype = wp_check_filetype( $filename, $mimes );
    return [
        'ext'             => $filetype['ext'],
        'type'            => $filetype['type'],
        'proper_filename' => $data['proper_filename']
    ];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  
  function fix_svg() {
    echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
  }
  add_action( 'admin_head', 'fix_svg' );




/*Create Services Post*/
add_action( 'init', 'register_services' );
function register_services() {
    register_post_type( 'our-service',
        array(
            'labels' => array(
                'name' => _x( 'Services', 'our-service' ),
                'singular_name' => _x( 'Services', 'our-service' ),
                'add_new' => 'Add New Services',
                'add_new_item' => 'Add New Services',
                'all_items'    =>  _x( 'All Services', 'our-service' ),
                'edit_item' => 'Edit Services',
                'new_item' => 'New Services',
                'view_item' => 'View Services',
                'search_items' => 'Search Services',
                'not_found' =>  'Nothing Found',
                'not_found_in_trash' => 'Nothing found in the Trash',
                'parent_item_colon' => ''
            ),
            'public' => true,
            'publicly_queryable' => true,
            'show_ui' => true,
            'query_var' => true,
            'menu_icon' => 'dashicons-insert',
            'rewrite' => true,
            'capability_type' => 'post',
            'hierarchical' => false,
            'menu_position' => null,
            'supports' => array( 'title', 'editor', 'thumbnail' )
        )
    );
}

