<?php

if ( ! isset( $content_width ) )
	$content_width = 604;

function admin_bar(){

  if(is_user_logged_in()){
    add_filter( 'show_admin_bar', '__return_true' , 1000 );
  }
}
add_action('init', 'admin_bar' );

function customtheme_setup() {

    register_nav_menu( 'header', __( 'Header Menu', 'customtheme' ) );


 	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
    add_image_size( 'about', 641, 496, true );
    add_image_size( 'blog', 306, 300, true );
    add_image_size( 'feature_today', 683, 595, true );
    add_image_size( 'latest', 357, 383, true );




	//set_post_thumbnail_size( 604, 270, true );
}
add_action( 'after_setup_theme', 'customtheme_setup' );



function customtheme_wp_title( $title, $sep ) {
	global $paged, $page;
	if ( is_feed() )
		return $title;
	$title .= get_bloginfo( 'name', 'display' );
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title = "$title $sep $site_description";
	if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() )
		$title = "$title $sep " . sprintf( __( 'Page %s', 'customtheme_wp_title' ), max( $paged, $page ) );
	return $title;
}
add_filter( 'wp_title', 'customtheme_wp_title', 10, 2 );



function customtheme_scripts_styles() {
    wp_enqueue_style( 'customtheme-style', get_stylesheet_uri(), array(), '2025-11-05' );


	$theme_uri = get_template_directory_uri();

    // Styles
   wp_enqueue_style('bootstrap', $theme_uri . '/assets/css/bootstrap.min.css');
    wp_enqueue_style('owl-carousel', $theme_uri . '/assets/css/owl.carousel.min.css');
    wp_enqueue_style('owl_theme_default', $theme_uri . '/assets/css/owl.theme.default.css');
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css', array(), null);
    wp_enqueue_style('main-style', $theme_uri . '/assets/css/style.css');
    wp_enqueue_style('responsive', $theme_uri . '/assets/css/responsive.css');


    // Scripts
    wp_enqueue_script('jquery'); // WordPress includes jQuery already
    wp_enqueue_script('bootstrap', $theme_uri . '/assets/js/bootstrap.min.js', array('jquery'), null, true);
    wp_enqueue_script('slimNav_sk78', $theme_uri . '/assets/js/jquery.slimNav_sk78.min.js', array('jquery'), null, true);
    wp_enqueue_script('owl-carousel', $theme_uri . '/assets/js/owl.carousel.js', array('jquery'), null, true);
	wp_enqueue_script('script', $theme_uri . '/assets/js/script.js', array('jquery'), null, true);
}
add_action( 'wp_enqueue_scripts', 'customtheme_scripts_styles' );




function custom_excerpt_length($length) {
    return 30;
}
add_filter('excerpt_length', 'custom_excerpt_length');



add_filter('wpcf7_autop_or_not', '__return_false');
/*
add_filter('wpcf7_form_elements', function($content) {
    $content = preg_replace('/<(span).*?class="\s*(?:.*\s)?wpcf7-form-control-wrap(?:\s[^"]+)?\s*"[^\>]*>(.*)<\/\1>/i', '\2', $content);

    return $content;
});*/



//Upload SVG images
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {
    $filetype = wp_check_filetype( $filename, $mimes );
    return [
        'ext'             => $filetype['ext'],
        'type'            => $filetype['type'],
        'proper_filename' => $data['proper_filename']
    ];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  
  function fix_svg() {
    echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
  }
  add_action( 'admin_head', 'fix_svg' );

// ——— READING TIME (NO WARNINGS) ———
function reading_time() {
    $content    = get_post_field('post_content', get_the_ID());
    $word_count = str_word_count(strip_tags($content));
    $minutes    = (int) floor((float) $word_count / 200);
    return $minutes < 1 ? 1 : $minutes;
}



// AJAX Handler for Search
add_action('wp_ajax_custom_blog_search', 'custom_blog_search_handler');
add_action('wp_ajax_nopriv_custom_blog_search', 'custom_blog_search_handler');

function custom_blog_search_handler() {
    check_ajax_referer('blog_search_nonce', 'nonce');

    $s = sanitize_text_field($_POST['s']);

    $args = array(
        'post_type'      => 'post',
        'post_status'    => 'publish',
        's'              => $s,
        'posts_per_page' => -1,
    );

    $query = new WP_Query($args);

    if (!$query->have_posts()) {
        wp_send_json_success('<p class="no-results">No results found.</p>');
    }

    ob_start();
    while ($query->have_posts()) : $query->the_post();
        $cats = get_the_category();
        $cat_name = !empty($cats) ? esc_html($cats[0]->name) : 'Uncategorized';
        $thumb = get_the_post_thumbnail_url(get_the_ID(), 'latest') ?: 'https://via.placeholder.com/400x250';
    ?>
    <div class="box-wraper">
        <div class="img-wraper">
            <img src="<?php echo esc_url($thumb); ?>" alt="<?php the_title_attribute(); ?>" class="main-img">
            <?php echo do_shortcode('[Sassy_Social_Share]'); ?>
        </div>
        <div class="text-wraper">
            <div class="flex-item">
                <h5><?php echo $cat_name; ?></h5>
                <h6><?php echo reading_time(); ?> min read</h6>
            </div>
            <h3><?php the_title(); ?></h3>
            <p><?php echo wp_trim_words(get_the_content(), 30, '...'); ?></p>
            <a href="<?php the_permalink(); ?>" class="main-btn">Read More</a>
        </div>
    </div>
    <?php
    endwhile;
    wp_reset_postdata();

    $output = ob_get_clean();
    wp_send_json_success($output);
}