<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php wp_title( '|', true, 'right' ); ?></title>
    <link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/assets/images/fav-icon.svg">

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<header>
    <?php $logo = get_field('logo', 'option'); ?>
    <div class="container">
        <div class="header-content-wraper">
            <div class="logo-wraper">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>">

                    <?php if(!empty($logo)){ ?>
                    <img src="<?php echo esc_url($logo['url']); ?>" alt="<?php echo $logo['alt']; ?>">
                    <?php }else{ ?>
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/header-logo.png" alt="Logo">
                    <?php } ?>
                </a>
            </div>
            <div class="menu-wraper">
                <div id="navigation">
                    <nav>
                        <?php wp_nav_menu( array( 'theme_location' => 'header', 'menu_class'=>'', 'container' => '' ) ); ?>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</header>
<?php $facebook = get_field('facebook', 'option');
    $twitter = get_field('twitter', 'option');
    $instagram = get_field('instagram', 'option');
    $bluesky = get_field('bluesky', 'option'); ?>
<ul class="right-fixed-icon">
    <?php if( $facebook ): ?><li><a href="<?php echo $facebook; ?>" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/fixed-icon1.svg" alt=""></a></li><?php endif; ?>
    <?php if( $instagram ): ?><li><a href="<?php echo $instagram; ?>" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/fixed-icon2.svg" alt=""></a></li><?php endif; ?>
    <?php if( $bluesky ): ?><li><a href="<?php echo $bluesky; ?>" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/fixed-icon3.svg" alt=""></a></li><?php endif; ?>
    <?php if( $twitter ): ?><li><a href="<?php echo $twitter; ?>" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/fixed-icon4.svg" alt=""></a></li><?php endif; ?>
</ul>