jQuery(document).ready(function () {
  //-------------------------------------------------------
  // 1. StellarNav Menu
  //-------------------------------------------------------
  jQuery(".stellarnav").stellarNav({
    breakpoint: 991,
    position: "right",
  });

  // Click on play button
  var video = jQuery("#myVideo")[0];

  // Play button click
  jQuery("#playBtn").on("click", function (e) {
    e.preventDefault();
    video.play();
    jQuery(this).hide();
  });

  // Video click (pause & show button)
  jQuery("#myVideo").on("click", function () {
    if (!this.paused) {
      this.pause();
      jQuery("#playBtn").show();
    }
  });

  //-------------------------------------------------------
  // 2. FAQ Toggle on Home Page
  //-------------------------------------------------------
  jQuery(".faq_box").each(function () {
    jQuery(this).on("click", ".acc_trigger", function (e) {
      e.preventDefault();

      const $trigger = jQuery(this);
      const $item = $trigger.closest(".faq_item");
      const $container = $item.find(".acc_container");
      const $box = $trigger.closest(".faq_box");

      if ($container.is(":visible")) {
        $container.slideUp(300);
        $trigger.removeClass("active closed");
        $item.removeClass("main_active");
      } else {
        $box.find(".acc_container").slideUp(300);
        $box.find(".acc_trigger").removeClass("active closed");
        $box.find(".faq_item").removeClass("main_active");

        $container.slideDown(300);
        $trigger.addClass("active closed");
        $item.addClass("main_active");
      }
    });
  });

  //-------------------------------------------------------
  // 3. Password Toggle (Eye Icon)
  //-------------------------------------------------------
  jQuery(".inpt-wrp i").on("click", function () {
    const $icon = jQuery(this);
    const $input = $icon.siblings("input");
    const type = $input.attr("type") === "password" ? "text" : "password";

    $input.attr("type", type);
    $icon.toggleClass("fa-eye fa-eye-slash");
  });
});

//-------------------------------------------------------
// 4. Swiper for Modal
//-------------------------------------------------------
const modalSwiper = new Swiper(".modalSwiper", {
  spaceBetween: 30,
  centeredSlides: true,
  navigation: {
    nextEl: ".swiper-button-next",
    prevEl: ".swiper-button-prev",
  },
});

//-------------------------------------------------------
// 5. Swiper for Clients Section
//-------------------------------------------------------
const clientSwiper = new Swiper(".clientSwiper", {
  spaceBetween: 1,
  slidesPerView: 1,
  centeredSlides: true,
  roundLengths: true,
  loop: true,
  navigation: {
    nextEl: ".otherNext",
    prevEl: ".otherPrev",
  },
  breakpoints: {
    767: {
      slidesPerView: 2.7,
      spaceBetween: 10,
    },
  },
});

//-------------------------------------------------------
// 6. Counter Animation on Scroll
//-------------------------------------------------------
// let counted = 0;
// jQuery(window).on("scroll", function () {
//   const oTop = jQuery("#counter").offset().top - window.innerHeight;

//   if (counted === 0 && jQuery(window).scrollTop() > oTop) {
//     jQuery(".count").each(function () {
//       const $this = jQuery(this);
//       const countTo = $this.attr("data-count");

//       jQuery({ countNum: $this.text() }).animate(
//         { countNum: countTo },
//         {
//           duration: 2000,
//           easing: "swing",
//           step: function () {
//             $this.text(Math.floor(this.countNum));
//           },
//           complete: function () {
//             $this.text(this.countNum);
//           },
//         }
//       );
//     });
//     counted = 1;
//   }
// });

//-------------------------------------------------------
// 6. Counter Animation on Scroll (only if #counter exists)
//-------------------------------------------------------
if (jQuery("#counter").length) {
  let counted = 0;
  jQuery(window).on("scroll", function () {
    const oTop = jQuery("#counter").offset().top - window.innerHeight;

    if (counted === 0 && jQuery(window).scrollTop() > oTop) {
      jQuery(".count").each(function () {
        const $this = jQuery(this);
        const countTo = $this.attr("data-count");

        jQuery({ countNum: $this.text() }).animate(
          { countNum: countTo },
          {
            duration: 2000,
            easing: "swing",
            step: function () {
              $this.text(Math.floor(this.countNum));
            },
            complete: function () {
              $this.text(this.countNum);
            },
          }
        );
      });
      counted = 1;
    }
  });
}

//-------------------------------------------------------
// 7. Masonry Layout after Images Load
//-------------------------------------------------------
document.addEventListener("DOMContentLoaded", function () {
  const grid = document.querySelector(".masonsryGrid");
  imagesLoaded(grid, function () {
    new Masonry(grid, {
      itemSelector: ".col-md-4",
      percentPosition: true,
    });
  });
});

// document.addEventListener("DOMContentLoaded", function () {
//   const video = document.querySelector(".video_play_bx video");
//   const playIcon = document.querySelector(".playClick");
//   const pauseIcon = document.querySelector(".pauseClick");

//   pauseIcon.style.display = "none"; // Hide pause icon initially

//   document.querySelector(".play_icon").addEventListener("click", function () {
//     if (video.paused) {
//       video.play();
//       playIcon.style.display = "none";
//       pauseIcon.style.display = "inline-block";
//     } else {
//       video.pause();
//       playIcon.style.display = "inline-block";
//       pauseIcon.style.display = "none";
//     }
//   });
// });

//-------------------------------------------------------
// 8. Play/Pause Toggle on Video Click
//-------------------------------------------------------

document.addEventListener("DOMContentLoaded", function () {
  const video = document.querySelector(".video_play_bx video");
  const playIcon = document.querySelector(".playClick");
  const pauseIcon = document.querySelector(".pauseClick");
  const videoBox = document.querySelector(".video_play_bx");

  // Autoplay video
  video.play();

  // Initially hide both icons
  playIcon.style.display = "none";
  pauseIcon.style.display = "none";

  // Show pause icon on hover if video is playing
  videoBox.addEventListener("mouseenter", function () {
    if (!video.paused) {
      pauseIcon.style.display = "inline-block";
    }
  });

  videoBox.addEventListener("mouseleave", function () {
    if (!video.paused) {
      pauseIcon.style.display = "none";
    }
  });

  // Pause the video on pause icon click
  pauseIcon.addEventListener("click", function (e) {
    e.stopPropagation();
    video.pause();
    pauseIcon.style.display = "none";
    playIcon.style.display = "inline-block";
  });

  // Play the video on play icon click
  playIcon.addEventListener("click", function (e) {
    e.stopPropagation();
    video.play();
    playIcon.style.display = "none";
    // Pause icon will show again on next hover
  });
});

//-------------------------------------------------------
// 9. splinde slider
//-------------------------------------------------------

// Auto scroll slider
new Splide("#logo-infinite", {
  type: "loop",
  perPage: 5,
  arrows: false,
  pagination: false,
  drag: false,
  autoWidth: true,
  gap: "1.25rem",
  autoScroll: {
    speed: 2, // smooth speed
    pauseOnHover: false,
    pauseOnFocus: false,
  },
  extensions: {
    AutoScroll: window.splide.Extensions.AutoScroll,
  },
}).mount(window.splide.Extensions);

//-------------------------------------------------------
// 10. tabbed content
//-------------------------------------------------------

jQuery(".tab_content").hide();
jQuery(".tab_content:first").show();

/* if in tab mode */
jQuery("ul.tabs li").click(function () {
  jQuery(".tab_content").hide();
  var activeTab = jQuery(this).attr("rel");
  jQuery("#" + activeTab).fadeIn();

  jQuery("ul.tabs li").removeClass("active");
  jQuery(this).addClass("active");

  jQuery(".tab_drawer_heading").removeClass("d_active");
  jQuery(".tab_drawer_heading[rel^='" + activeTab + "']").addClass("d_active");
});
/* if in drawer mode */
jQuery(".tab_drawer_heading").click(function () {
  jQuery(".tab_content").hide();
  var d_activeTab = jQuery(this).attr("rel");
  jQuery("#" + d_activeTab).fadeIn();

  jQuery(".tab_drawer_heading").removeClass("d_active");
  jQuery(this).addClass("d_active");

  jQuery("ul.tabs li").removeClass("active");
  jQuery("ul.tabs li[rel^='" + d_activeTab + "']").addClass("active");
});
