<?php $footer_content = get_field('footer_content', 'option');
$logo = get_field('logo', 'option');
$booking_button = get_field('booking_button', 'option');
$copyright_text = get_field('copyright_text', 'option');
$menu_text_1 = get_field('menu_text_1', 'option');
$menu_text_2 = get_field('menu_text_2', 'option');
$menu_text_3 = get_field('menu_text_3', 'option');
$phone_text = get_field('phone_text', 'option');
$phone = get_field('phone', 'option');
$email_text = get_field('email_text', 'option');
$email = get_field('email', 'option');
$address_text = get_field('address_text', 'option');
$address = get_field('address', 'option');
$facebook = get_field('facebook', 'option');
$instagram = get_field('instagram', 'option'); ?>
<footer>
    <div class="footer-top-part">
        <div class="container">
            <div class="footer-top-part-content-wraper">
                <div class="logo-part">
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="logo">
                        <?php if(!empty($logo)){ ?><img src="<?php echo esc_url($logo['url']); ?>" alt="<?php echo esc_url($logo['alt']); ?>"><?php }else{ ?><img src="<?php echo get_template_directory_uri(); ?>/assets/images/logo.png" alt="Logo"><?php } ?>
                    </a>
                    <?php if(!empty($footer_content)){ echo wpautop($footer_content); } ?>
                    <?php if( $booking_button ):
                    $link_url = $booking_button['url'];
                    $link_title = $booking_button['title'];
                    $link_target = $booking_button['target'] ? $booking_button['target'] : '_self';
                    ?>
                    <a href="<?php echo esc_url($link_url); ?>" class="btn borderBrownBtn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?> <span><i class="fa-solid fa-angle-right"></i></span></a>
                    <?php endif; ?>
                </div>
                <div class="menu-part">
                    <div class="menu-item">
                        <?php if(!empty($menu_text_1)){ ?><h5><?php echo $menu_text_1; ?></h5><?php } ?>
                        <?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class'=>'', 'container' => '' ) ); ?>
                    </div>
                    <div class="menu-item">
                        <?php if(!empty($menu_text_2)){ ?><h5><?php echo $menu_text_2; ?></h5><?php } ?>
                        <?php wp_nav_menu( array( 'theme_location' => 'privacy', 'menu_class'=>'', 'container' => '' ) ); ?>
                    </div>
                </div>
                <div class="contact-part">
                    <?php if(!empty($menu_text_3)){ ?><h5><?php echo $menu_text_3; ?></h5><?php } ?>
                    <ul>
                        <?php if(!empty($phone)){ ?>
                        <li>
                            <figure><img src="<?php echo get_template_directory_uri(); ?>/assets/images/phone-icon.svg" alt=""></figure>
                            <div class="text-wraper">
                                <span><?php echo $phone_text; ?></span>
                                <a href="tel:<?php echo $phone; ?>"><?php echo $phone; ?></a>
                            </div>
                        </li>
                        <?php } ?>
                        <?php if(!empty($email)){ ?>
                        <li>
                            <figure><img src="<?php echo get_template_directory_uri(); ?>/assets/images/email-icon.svg" alt=""></figure>
                            <div class="text-wraper">
                                <span><?php echo $email_text; ?></span>
                                <a href="mailto:<?php echo $email; ?>"><?php echo $email; ?></a>
                            </div>
                        </li>
                        <?php } ?>
                        <?php if(!empty($address)){ ?>
                        <li>
                            <figure><img src="<?php echo get_template_directory_uri(); ?>/assets/images/location-icon2.svg" alt=""></figure>
                            <div class="text-wraper">
                                <span><?php echo $address_text; ?></span>
                                <strong><?php echo $address; ?></strong>
                            </div>
                        </li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-bottom-part">
        <div class="container">
            <div class="footer-bottom-part-content-wraper">
                <?php if(!empty($copyright_text)){ ?><h6>© <?php echo date('Y'); ?> <?php echo $copyright_text; ?></h6><?php } ?>
                <ul>
                    <?php if(!empty($facebook)){ ?><li><a href="<?php echo $facebook; ?>" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/facebook-icon.svg" alt=""></a></li><?php } ?>
                    <?php if(!empty($instagram)){ ?><li><a href="<?php echo $instagram; ?>" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/instagram-icon.svg" alt=""></a></li><?php } ?>
                </ul>
            </div>
        </div>
    </div>
</footer>


<?php $args = array('post_type' => 'our-portfolio', 'posts_per_page' => -1 );
$loop = new WP_Query($args); ?>
<?php if ( $loop->have_posts() ){ ?>
<?php while ($loop->have_posts()) : $loop->the_post();
$images = get_field('images');
$post_id = get_the_ID();  ?>
<!-- Modal -->
<div class="modal fade portfolioModal" id="exampleModal<?php echo $post_id; ?>" tabindex="-1" aria-labelledby="exampleModalLabel">
    <div class="modal-dialog  modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel"><?php the_title(); ?></h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php if (!empty($images)): ?>
                <div class="swiper modalSwiper">
                    <div class="swiper-wrapper">
                        <?php foreach( $images as $image ): ?>
                        <div class="swiper-slide">
                            <div class="gallery_contnt">
                                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>">
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                
                <div class="bottomSwiper_arrow">
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
                <?php else: ?>
                    <h2>No gallery found.</h2>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <?php the_content(); ?>
            </div>
        </div>
    </div>
</div>
<?php  endwhile; ?>
<?php }else{ ?>
    <h2>No porfolio found.</h2>
<?php } ?>
<?php wp_reset_postdata(); ?>



<?php wp_footer(); ?>
<script>
    jQuery(document).ready(function () {
    // When the modal is being shown, remove inert so it's interactive
    jQuery(document).on('show.bs.modal', '.modal', function () {
        jQuery(this).removeAttr('inert');
    });

    // Before hiding the modal, blur any focused element inside the modal
    jQuery(document).on('hide.bs.modal', '.modal', function () {
        if (document.activeElement && jQuery(this).has(document.activeElement).length > 0) {
        document.activeElement.blur(); // remove focus safely
        }
    });

    // After modal is hidden, apply inert to disable interaction and fix screen reader
    jQuery(document).on('hidden.bs.modal', '.modal', function () {
        jQuery(this).attr('inert', '');
    });
    });


    AOS.init({
        duration: 1200,
        easing: 'ease',
        delay: 200,
        once: true,
    });



    jQuery(document).on('submit', '.wpcf7-form', function (e) {
        const $form = jQuery(this);
        const $submitButton = $form.find('[type="submit"]');

        // Disable the submit button to prevent multiple clicks
        $submitButton.prop('disabled', true);

        // Re-enable the button after a delay (e.g., 3 seconds) in case of failure
        setTimeout(function () {
            $submitButton.prop('disabled', false);
        }, 3000);

        // Find the first invalid field
        const $invalidField = $form.find(':invalid').first();

        if ($invalidField.length) {
            e.preventDefault(); // Stop form submission
            $invalidField[0].reportValidity(); // Show validation message for the first invalid field
        }

    });
</script>

</body>

</html>