<?php

if ( ! isset( $content_width ) )
	$content_width = 604;

function admin_bar(){

  if(is_user_logged_in()){
    add_filter( 'show_admin_bar', '__return_true' , 1000 );
  }
}
add_action('init', 'admin_bar' );

function smtheme_setup() {

	register_nav_menu( 'primary', __( 'Primary Menu', 'smtheme' ) );
	register_nav_menu( 'privacy', __( 'Policy Menu', 'smtheme' ) );


 	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
    add_image_size( 'team', 356, 341, true );





	//set_post_thumbnail_size( 604, 270, true );
}
add_action( 'after_setup_theme', 'smtheme_setup' );



function smtheme_wp_title( $title, $sep ) {
	global $paged, $page;
	if ( is_feed() )
		return $title;
	$title .= get_bloginfo( 'name', 'display' );
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title = "$title $sep $site_description";
	if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() )
		$title = "$title $sep " . sprintf( __( 'Page %s', 'smtheme_wp_title' ), max( $paged, $page ) );
	return $title;
}
add_filter( 'wp_title', 'smtheme_wp_title', 10, 2 );



function smtheme_scripts_styles() {

  wp_enqueue_style( 'smtheme-style', get_stylesheet_uri(), array(), '2025-07-23' );


	$theme_uri = get_template_directory_uri();

    // Styles
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css', array(), null);
    wp_enqueue_style('bootstrap', 'https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css', array(), null);
    wp_enqueue_style('swiper', 'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css', array(), null);
    wp_enqueue_style('aos', 'https://unpkg.com/aos@2.3.1/dist/aos.css', array(), null);
    wp_enqueue_style('spile', 'https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.3/dist/css/splide.min.css', array(), null);
    wp_enqueue_style('stellarnav', $theme_uri . '/assets/css/stellarnav.css');
    wp_enqueue_style('lity', $theme_uri . '/assets/css/lity.css');
    wp_enqueue_style('main-style', $theme_uri . '/assets/css/style.css');
    wp_enqueue_style('responsive', $theme_uri . '/assets/css/responsive.css');

    // Scripts
    wp_enqueue_script('jquery'); // WordPress includes jQuery already
    //wp_enqueue_script('jquery-main', 'https://code.jquery.com/jquery-3.6.4.min.js', array('jquery'), null, true);
    //wp_enqueue_script('jquery-migrate', 'https://cdnjs.cloudflare.com/ajax/libs/jquery-migrate/3.4.1/jquery-migrate.min.js', array('jquery'), null, true);
    wp_enqueue_script('bootstrap.bundle', 'https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js', array('jquery'), null, true);
    wp_enqueue_script('swiper-bundle',  'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js', array('jquery'), null, true);
    wp_enqueue_script('aos',  'https://unpkg.com/aos@2.3.1/dist/aos.js', array('jquery'), null, true);
    wp_enqueue_script('masonry',  'https://unpkg.com/masonry-layout@4/dist/masonry.pkgd.min.js', array('jquery'), null, true);
    wp_enqueue_script('imagesloaded',  'https://unpkg.com/imagesloaded@4/imagesloaded.pkgd.min.js', array('jquery'), null, true);
    wp_enqueue_script('splide-min',  'https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.3/dist/js/splide.min.js', array('jquery'), null, true);
    wp_enqueue_script('splide-extension-auto-scroll',  'https://cdn.jsdelivr.net/npm/@splidejs/splide-extension-auto-scroll@0.5.3/dist/js/splide-extension-auto-scroll.min.js', array('jquery'), null, true);
    wp_enqueue_script('stellernav', $theme_uri . '/assets/js/stellernav.js', array('jquery'), null, true);
    wp_enqueue_script('equalheight', $theme_uri . '/assets/js/equalheight.js', array('jquery'), null, true);
    wp_enqueue_script('app', $theme_uri . '/assets/js/app.js', array('jquery'), null, true);

	
}
add_action( 'wp_enqueue_scripts', 'smtheme_scripts_styles' );




function custom_excerpt_length($length) {
    return 30;
}
add_filter('excerpt_length', 'custom_excerpt_length');



add_filter('wpcf7_autop_or_not', '__return_false');

/*add_filter('wpcf7_form_elements', function($content) {
    $content = preg_replace('/<(span).*?class="\s*(?:.*\s)?wpcf7-form-control-wrap(?:\s[^"]+)?\s*"[^\>]*>(.*)<\/\1>/i', '\2', $content);

    return $content;
});*/



//Upload SVG images
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {
    $filetype = wp_check_filetype( $filename, $mimes );
    return [
        'ext'             => $filetype['ext'],
        'type'            => $filetype['type'],
        'proper_filename' => $data['proper_filename']
    ];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  
  function fix_svg() {
    echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
  }
  add_action( 'admin_head', 'fix_svg' );




