<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1,user-scalable=0" />
    <title><?php wp_title( '|', true, 'right' ); ?></title>
    <link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/assets/images/fav.svg">
    <?php wp_head(); ?>
</head>

<body>
<?php $top_bar = get_field('top_bar', 'option');
$logo = get_field('logo', 'option');
$booking_button = get_field('booking_button', 'option'); ?>
    <header class="header_main">
        <?php if(!empty($top_bar)){ ?>
        <div class="top_header">
            <div class="container">
                <p><span><img src="<?php echo get_template_directory_uri(); ?>/assets/images/location-icon.svg" alt="icon"></span> <?php echo $top_bar; ?></p>
            </div>
        </div>
        <?php } ?>
        <div class="hd_adjust">
            <div class="container">
                <div class="d_flex">
                    <div class="logo">
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <?php if(!empty($logo)){ ?><img src="<?php echo esc_url($logo['url']); ?>" alt="<?php echo $logo['alt']; ?>" class="normal"><?php }else{ ?><img src="<?php echo get_template_directory_uri(); ?>/assets/images/logo.png" alt="Logo" class="normal"><?php } ?>
                        </a>
                    </div>
                    <div class="stellarnav">
                        <?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class'=>'', 'container' => '' ) ); ?>
                    </div>
                    <?php if( $booking_button ):
                    $link_url = $booking_button['url'];
                    $link_title = $booking_button['title'];
                    $link_target = $booking_button['target'] ? $booking_button['target'] : '_self';
                    ?>
                    <div class="rig-btn">
                        <a href="<?php echo esc_url($link_url); ?>" class="btn borderBrownBtn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?> <span><i class="fa-solid fa-angle-right"></i></span> <i class="fa-solid fa-calendar-days hide"></i></a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </header>