<?php
/* Template Name: Home */
get_header(); ?>

<!-- ! Main ! -->
<!-- Banner -->
<?php $banner_video = get_field('banner_video');
$banner_small_title = get_field('banner_small_title');
$banner_big_title = get_field('banner_big_title');
$banner_button_1 = get_field('banner_button_1');
$banner_button_2 = get_field('banner_button_2'); ?>
<?php if(!empty($banner_video)){ ?>
<section class="hm_banner" id="home">
    <div class="full_banner">
        <video autoplay="" muted="" loop="" playsinline="">
            <source src="<?php echo $banner_video['url']; ?>" type="video/mp4">
            Your browser does not support the video tag.
        </video>
    </div>
    <div class="middle_caption">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <?php if(!empty($banner_small_title)){ ?><h3><?php echo $banner_small_title; ?></h3><?php } ?>
                    <?php if(!empty($banner_big_title)){ ?><h1><?php echo $banner_big_title; ?></h1><?php } ?>
                    <div class="gp_btn">
                        <?php if( $banner_button_1 ):
                        $link_url = $banner_button_1['url'];
                        $link_title = $banner_button_1['title'];
                        $link_target = $banner_button_1['target'] ? $banner_button_1['target'] : '_self';
                        ?>
                        <a href="<?php echo esc_url($link_url); ?>" class="btn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?> <span><i class="fa-solid fa-angle-right"></i></span></a>
                        <?php endif; ?>
                        <?php if( $banner_button_2 ):
                        $link_url = $banner_button_2['url'];
                        $link_title = $banner_button_2['title'];
                        $link_target = $banner_button_2['target'] ? $banner_button_2['target'] : '_self';
                        ?>
                        <a href="<?php echo esc_url($link_url); ?>" class="btn borderWtnBtn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?> <span><i class="fa-solid fa-angle-right"></i></span></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php } ?>

<!-- Our Work -->
<?php $work_small_title = get_field('work_small_title');
$work_title = get_field('work_title');
$work_info = get_field('work_info'); ?>
<?php if(!empty($work_info)){ ?>
<section class="hmSec1" id="counter">
    <div class="container">
        <div class="headingTxt mb40 text-center">
            <div class="row">
                <div class="col-lg-6 col-md-8 m-auto">
                    <?php if(!empty($work_small_title)){ ?><h3><?php echo $work_small_title; ?></h3><?php } ?>
                    <?php if(!empty($work_title)){ ?><h2><?php echo $work_title; ?></h2><?php } ?>
                </div>
            </div>
        </div>
        <div class="row">
            <?php foreach( $work_info as $info ) { ?>
            <div class="col-md-4">
                <div class="counter-item">
                    <h3><span data-count="<?php echo $info['end_data']; ?>" class="count"><?php echo $info['start_data']; ?></span><?php echo $info['unit']; ?></h3>
                    <h6><?php echo $info['title']; ?></h6>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
</section>
<?php } ?>


<!-- Video Section -->
<?php $video = get_field('video');
$video_small_title = get_field('video_small_title');
$video_big_title = get_field('video_big_title'); ?>
<?php if(!empty($video_small_title)){ ?>
<section class="hmSec2">
    <div class="container">
        <?php if(!empty($video)){ ?>
        <div class="video_play_bx">
            <video loop muted autoplay playsinline>
                <source src="<?php echo $video['url']; ?>" type="video/mp4">
                Your browser does not support the video tag.
            </video>
            <div class="play_icon">
                <a href="javascript:void(0);"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/play-icon.png" alt="play-icon" class="playClick"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/pause.png" alt="pause" class="pauseClick"></a>
            </div>
        </div>
        <?php } ?>
        <h3><?php echo $video_small_title; ?></h3>
        <?php if(!empty($video_big_title)){ ?><h2><?php echo $video_big_title; ?></h2><?php } ?>
    </div>
</section>
<?php } ?>


<!-- Service Section -->
<?php $service_info = get_field('service_info');
$service_button = get_field('service_button'); ?>
<?php if(!empty($service_info)){ ?>
<section class="hmSec3">
    <div class="grid_bx">
        <?php foreach( $service_info as $info ) {
        $link = $info['button']; // Replace with your sub field name
        $url = $link['url'];
        $title = $link['title'];
        $target = $link['target'] ? $link['target'] : '_self';
        $image = $info['image']; ?>
        <div class="col">
            <div class="services_item">
                <img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
                <div class="ser_bx_details">
                    <div class="content_tx">
                        <h2><?php echo $info['title']; ?></h2>
                        <?php echo wpautop( esc_html( $info['content'] ) ); ?>
                    </div>
                </div>
                <div class="ser_bx_hover_effects">
                    <h2><?php echo $info['title']; ?></h2>
                    <?php echo wpautop( esc_html( $info['content'] ) ); ?>
                    <a href="<?php echo $url; ?>" class="btn" target="<?php echo $target; ?>"><?php echo $title; ?> <span><i class="fa-solid fa-angle-right"></i></span></a>
                </div>
            </div>
        </div>
        <?php } ?>
    </div>
    <?php if( $service_button ):
    $link_url = $service_button['url'];
    $link_title = $service_button['title'];
    $link_target = $service_button['target'] ? $service_button['target'] : '_self';
    ?>
    <a href="<?php echo esc_url($link_url); ?>" class="btn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?> <span><i class="fa-solid fa-angle-right"></i></span></a>
    <?php endif; ?>
</section>
<?php } ?>


<!-- Portfolio --> 
<?php $portfolio_title = get_field('portfolio_title');
$portfolio_sub_title = get_field('portfolio_sub_title');
$portfolio_button = get_field('portfolio_button'); 
$portfolio_display = get_field('portfolio_display'); 
if ( $portfolio_display ) : ?>
<section class="hmSec4">
    <div class="container">
        <div class="headingTxt text-center mb40">
            <?php if(!empty($portfolio_title)){ ?><h3><?php echo $portfolio_title; ?> </h3><?php } ?>
            <?php if(!empty($portfolio_sub_title)){ ?><h2><?php echo $portfolio_sub_title; ?></h2><?php } ?>
        </div>
        <div class="row masonsryGrid mb40">
            
            <?php foreach( $portfolio_display as $post ) : 
            setup_postdata( $post );
            $images = get_field('images');
            $post_id = get_the_ID(); ?>
            <div class="col-md-4">
                <div class="each_portfolio">
                    <?php the_post_thumbnail('full'); ?>
                    <div class="zoomBx">
                        <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo $post_id; ?>"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/zoom_icon.png" alt="zoom-icon"></a>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
            <?php wp_reset_postdata(); ?>
        </div>
        <?php if( $portfolio_button ):
        $link_url = $portfolio_button['url'];
        $link_title = $portfolio_button['title'];
        $link_target = $portfolio_button['target'] ? $portfolio_button['target'] : '_self';
        ?>
        <div class="text-center">
           <a href="<?php echo esc_url($link_url); ?>" class="btn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?> <span><i class="fa-solid fa-angle-right"></i></span></a>
        </div>
        <?php endif; ?>
    </div>
</section>
<?php endif; ?>


<!-- Testimonials -->
<?php $testimonial_title = get_field('testimonial_title', 'option');
$testimonial_sub_title = get_field('testimonial_sub_title', 'option'); ?>
<?php $args1 = array('post_type' => 'testimonial', 'posts_per_page' => -1 );
$loop1 = new WP_Query($args1); ?>
<?php if ( $loop1->have_posts() ){ ?>
<section class="hmSec5">
    <div class="container">
        <div class="headingTxt text-center mb40">
            <div class="row">
                <div class="col-lg-6 col-md-8 m-auto">
                    <?php if(!empty($testimonial_title)){ ?><h3><?php echo $testimonial_title; ?> </h3><?php } ?>
                    <?php if(!empty($testimonial_sub_title)){ ?><h2><?php echo $testimonial_sub_title; ?></h2><?php } ?>
                </div>
            </div>
        </div>
    </div>
    <div class="groupSwiper">
        <!-- Swiper -->
        <div class="swiper clientSwiper">
            <div class="swiper-wrapper">
                <?php while ($loop1->have_posts()) : $loop1->the_post();
                $designation = get_field('designation');
                $star_rating = get_field('star_rating');
                $content = get_the_content();
                $content_no_p = str_replace(['<p>', '</p>'], '', $content); ?>
                <div class="swiper-slide">
                    <div class="clientGroup">
                        <div class="user_cicrle">
                            <?php the_post_thumbnail('full'); ?>
                        </div>
                        <?php if ( $star_rating ) {
                            echo '<div class="user_rate_stars">';

                            for ( $i = 1; $i <= 5; $i++ ) {
                                if ( $i <= $star_rating ) {
                                    echo '<span class="fa fa-star checked"></span>';
                                } else {
                                    echo '<span class="fa fa-star"></span>';
                                }
                            }

                            echo '</div>';
                        }
                        ?>
                        <p>"<?php echo $content_no_p; ?>"</p>
                        <h5><?php the_title(); ?></h5>
                        <h6><?php echo $designation; ?></h6>
                    </div>
                </div>
                <?php  endwhile; ?>
            </div>
            
        </div>
        <div class="swiper-button-next otherNext"></div>
        <div class="swiper-button-prev otherPrev"></div>
    </div>
</section>
<?php } ?>
<?php wp_reset_postdata(); ?>


<!-- Award -->
<?php $award_title = get_field('award_title');
$award_content = get_field('award_content');
$award_image = get_field('award_image'); 
$about_2_image = get_field('about_2_image');
$discover_button = get_field('discover_button'); ?>
<section class="award_sec">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="txt">
                    <?php if(!empty($award_title)){ ?><h2><?php echo $award_title; ?></h2><?php } ?>
                    <div class="para">
                        <?php if(!empty($award_content)){ echo wpautop($award_content); } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if(!empty($award_image)){ ?><img src="<?php echo $award_image['url']; ?>" alt="<?php echo $award_image['alt']; ?>" class="img1"><?php } ?>
</section>

<section class="meet-zoe-milan">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 col-md-6">
                <div class="img-wraper">
                    <?php if(!empty($about_2_image)){ ?><img src="<?php echo $about_2_image['url']; ?>" alt="<?php echo $about_2_image['alt']; ?>" class="static-img"><?php } ?>
                    <?php the_post_thumbnail('full', ['class' => 'absolut-img']); ?>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <?php the_content(); ?>
                <?php if( $discover_button ):
                $link_url = $discover_button['url'];
                $link_title = $discover_button['title'];
                $link_target = $discover_button['target'] ? $discover_button['target'] : '_self';
                ?>
                <a href="<?php echo esc_url($link_url); ?>" class="btn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?><span><i class="fa-solid fa-angle-right"></i></span></a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>


<!-- Get In Touch -->
<?php $get_in_touch_title = get_field('get_in_touch_title');
$get_in_touch_content = get_field('get_in_touch_content');
$contact_form_title = get_field('contact_form_title');
$get_in_touch_background = get_field('get_in_touch_background');
$phone_text = get_field('phone_text', 'option');
$phone = get_field('phone', 'option');
$email_text = get_field('email_text', 'option');
$email = get_field('email', 'option');  ?>
<section class="get_touch">
    <?php if(!empty($get_in_touch_background)){ ?><img src="<?php echo $get_in_touch_background['url']; ?>" alt="<?php echo $get_in_touch_background['alt']; ?>" class="bg"><?php } ?>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <?php if(!empty($get_in_touch_title)){ ?><h2><?php echo $get_in_touch_title; ?></h2><?php } ?>
                <?php if(!empty($get_in_touch_content)){ echo wpautop($get_in_touch_content); } ?>
                <ul class="info_dtls">
                    <?php if(!empty($phone)){ ?>
                    <li>
                        <div class="icn">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/call-icon.png" alt="">
                        </div>
                        <span><?php echo $phone_text; ?></span>
                        <a href="tel:<?php echo $phone; ?>"><?php echo $phone; ?></a>
                    </li>
                    <?php } ?>
                    <?php if(!empty($email)){ ?>
                    <li>
                        <div class="icn">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/mail-icon.png" alt="">
                        </div>
                        <span><?php echo $email_text; ?></span>
                        <a href="mailto:<?php echo $email; ?>"><?php echo $email; ?></a>
                    </li>
                    <?php } ?>
                </ul>
            </div>
            <div class="col-lg-6">

                <div class="form_div">
                    <?php if(!empty($contact_form_title)){ ?><h3><?php echo $contact_form_title; ?> </h3><?php } ?>

                    <?php echo do_shortcode('[contact-form-7 id="b6734f4" title="Get in Touch"]'); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- ! Main end ! -->

<?php get_footer();




