<?php
/* Template Name: Portfolio */
get_header(); ?>
<?php $banner_image = get_field('banner_image');
$banner_text = get_field('banner_text'); ?>
<?php if(!empty($banner_image)){ ?>
<section class="inner_banner">
    <img src="<?php echo $banner_image['url']; ?>" alt="<?php echo $banner_image['alt']; ?>" class="bg">
    <div class="top">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <?php if(!empty($banner_text)){ ?><h1><?php echo $banner_text; ?></h1><?php }else{ ?><h1><?php the_title(); ?></h1><?php } ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php } ?>


<?php $portfolio_images = get_field('portfolio_images');
if(!empty($portfolio_images)){ ?>
<section class="portfolio_sec2">
    <div class="full_slide">

        <div id="logo-infinite" class="splide">
            <div class="splide__track">
                <ul class="splide__list">
                    <?php foreach( $portfolio_images as $p_img ) {
                    $image = $p_img['image']; ?>
                    <li class="splide__slide">
                        <img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
                        <h5><?php echo $p_img['title']; ?></h5>
                    </li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
</section>
<?php } ?>

<?php $portfolio_title = get_field('portfolio_title');
$portfolio_sub_title = get_field('portfolio_sub_title'); ?>


<section class="portfolio_sec3">
    <div class="container">
        <div class="headingTxt text-center mb40">
            <div class="row">
                <div class="col-lg-6 col-md-8 m-auto">
                    <?php if(!empty($portfolio_title)){ ?><h3><?php echo $portfolio_title; ?></h3><?php } ?>
                    <?php if(!empty($portfolio_sub_title)){ ?><h2><?php echo $portfolio_sub_title; ?></h2><?php } ?>
                </div>
            </div>
        </div>



        <?php
        // Get all portfolio categories
        $portfolio_categories = get_terms([
            'taxonomy' => 'portfolio-category',
            'hide_empty' => false, // Show even empty categories
        ]);
        ?>

        <div class="row">
            <div class="col-12">
                <div class="tab_full">
                    <!-- Tabs -->
                    <ul class="tabs">
                        <li class="active" rel="tab-all">All</li>
                        <?php foreach ($portfolio_categories as $index => $category): ?>
                            <li rel="tab-<?php echo esc_attr($category->slug); ?>"><?php echo esc_html($category->name); ?></li>
                        <?php endforeach; ?>
                    </ul>

                    <div class="tab_container">
                        <!-- Tab: All -->
                        <div id="tab-all" class="tab_content">
                            <div class="row">
                                <?php
                                $args = [
                                    'post_type' => 'our-portfolio',
                                    'posts_per_page' => -1, // Adjust as needed
                                ];
                                $all_portfolios = new WP_Query($args);

                                if ($all_portfolios->have_posts()):
                                    while ($all_portfolios->have_posts()): $all_portfolios->the_post();
                                        $post_id = get_the_ID();
                                        $sub_title = get_field('sub_title'); ?>
                                        <div class="col-lg-3 col-md-6">
                                            <div class="portfolio_dv">
                                                <div class="img">
                                                    <?php the_post_thumbnail('full'); ?>
                                                    <div class="icon">
                                                        <a href="#"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/zoom_icon.png" alt="Zoom"></a>
                                                    </div>
                                                </div>
                                                <div class="txt">
                                                    <h3><?php the_title(); ?></h3>
                                                    <?php if(!empty($sub_title)){ echo wpautop($sub_title); } ?>
                                                </div>
                                                <a href="#" class="abs" data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo $post_id; ?>"></a>
                                            </div>
                                        </div>
                                    <?php endwhile;
                                    wp_reset_postdata();
                                else: ?>
                                    <p>No portfolio items found.</p>
                                <?php endif; ?>

                            </div>
                        </div>

                        <!-- Dynamic Tabs for Each Category -->
                        <?php foreach ($portfolio_categories as $category): ?>
                            <div id="tab-<?php echo esc_attr($category->slug); ?>" class="tab_content">
                                <div class="row">
                                    <?php
                                    $args = [
                                        'post_type' => 'our-portfolio',
                                        'posts_per_page' => -1,
                                        'tax_query' => [
                                            [
                                                'taxonomy' => 'portfolio-category',
                                                'field' => 'slug',
                                                'terms' => $category->slug,
                                            ],
                                        ],
                                    ];
                                    $portfolio_query = new WP_Query($args);

                                    if ($portfolio_query->have_posts()):
                                        while ($portfolio_query->have_posts()): $portfolio_query->the_post();
                                            $post_id = get_the_ID();
                                            $sub_title = get_field('sub_title'); ?>
                                            <div class="col-lg-3 col-md-6">
                                                <div class="portfolio_dv">
                                                    <div class="img">
                                                        <?php the_post_thumbnail('full'); ?>
                                                        <div class="icon">
                                                            <a href="#"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/zoom_icon.png" alt="Zoom"></a>
                                                        </div>
                                                    </div>
                                                    <div class="txt">
                                                        <h3><?php the_title(); ?></h3>
                                                        <?php if(!empty($sub_title)){ echo wpautop($sub_title); } ?>
                                                    </div>
                                                    <a href="#" class="abs" data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo $post_id; ?>"></a>
                                                </div>
                                            </div>
                                        <?php endwhile;
                                        wp_reset_postdata();
                                    else: ?>
                                        <p>No portfolio items found in this category.</p>
                                    <?php endif; ?>
   
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</section>

<!-- Testimonials -->
<?php $testimonial_title = get_field('testimonial_title', 'option');
$testimonial_sub_title = get_field('testimonial_sub_title', 'option'); ?>
<?php $args1 = array('post_type' => 'testimonial', 'posts_per_page' => -1 );
$loop1 = new WP_Query($args1); ?>
<?php if ( $loop1->have_posts() ){ ?>
<section class="hmSec5">
    <div class="container">
        <div class="headingTxt text-center mb40">
            <div class="row">
                <div class="col-lg-6 col-md-8 m-auto">
                    <?php if(!empty($testimonial_title)){ ?><h3><?php echo $testimonial_title; ?> </h3><?php } ?>
                    <?php if(!empty($testimonial_sub_title)){ ?><h2><?php echo $testimonial_sub_title; ?></h2><?php } ?>
                </div>
            </div>
        </div>
    </div>
    <div class="groupSwiper">
        <!-- Swiper -->
        <div class="swiper clientSwiper">
            <div class="swiper-wrapper">
                <?php while ($loop1->have_posts()) : $loop1->the_post();
                $designation = get_field('designation');
                $star_rating = get_field('star_rating');
                $content = get_the_content();
                $content_no_p = str_replace(['<p>', '</p>'], '', $content); ?>
                <div class="swiper-slide">
                    <div class="clientGroup">
                        <div class="user_cicrle">
                            <?php the_post_thumbnail('full'); ?>
                        </div>
                        <?php if ( $star_rating ) {
                            echo '<div class="user_rate_stars">';

                            for ( $i = 1; $i <= 5; $i++ ) {
                                if ( $i <= $star_rating ) {
                                    echo '<span class="fa fa-star checked"></span>';
                                } else {
                                    echo '<span class="fa fa-star"></span>';
                                }
                            }

                            echo '</div>';
                        }
                        ?>
                        <p>"<?php echo $content_no_p; ?>"</p>
                        <h5><?php the_title(); ?></h5>
                        <h6><?php echo $designation; ?></h6>
                    </div>
                </div>
                <?php  endwhile; ?>
            </div>
            
        </div>
        <div class="swiper-button-next otherNext"></div>
        <div class="swiper-button-prev otherPrev"></div>
    </div>
</section>
<?php } ?>
<?php wp_reset_postdata(); ?>


<?php get_footer();




