<?php
/* Template Name: Service */
get_header(); ?>

<!-- ! Main ! -->
<!-- Banner -->
<?php $banner_image = get_field('banner_image');
$banner_title = get_field('banner_title'); ?>
<?php if(!empty($banner_image)){ ?>
<section class="inner_banner">
    <img src="<?php echo $banner_image['url']; ?>" alt="<?php echo $banner_image['alt']; ?>" class="bg">
    <div class="top">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <?php if(!empty($banner_title)){ ?><h1><?php echo $banner_title; ?></h1><?php }else{ ?><h1><?php the_title(); ?></h1><?php } ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php } ?>

<?php $booking_button = get_field('booking_button');
$service_content = get_field('service_content'); ?>
<section class="servc_sec1">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6">
                <?php the_content(); ?>
                <?php if( $booking_button ):
                $link_url = $booking_button['url'];
                $link_title = $booking_button['title'];
                $link_target = $booking_button['target'] ? $booking_button['target'] : '_self';
                ?>
                <a href="<?php echo esc_url($link_url); ?>" class="btn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?> <span><i class="fa-solid fa-angle-right"></i></span></a>
                <?php endif; ?>
            </div>
            <div class="col-md-6">
                <?php the_post_thumbnail('full'); ?>
            </div>
        </div>
    </div>
</section>
<?php $first_section = get_field('first_section'); 
if ( $first_section ) : ?>
<section class="servc_sec2">
    <div class="container">
        <div class="headingTxt text-center">
            <div class="row">
                <div class="col-12">
                    <?php if(!empty($service_content)){ echo wpautop($service_content); } ?>
                </div>
            </div>
        </div>
        
        <div class="row">
            <?php foreach( $first_section as $post ) : 
                setup_postdata( $post );
                $short_description = get_field('short_description');
                $booking_button = get_field('booking_button'); ?>
            <div class="col-md-6">
                <div class="service_card">
                    <?php the_post_thumbnail('full'); ?>
                    <div class="txt">
                        <h3><?php the_title(); ?></h3>
                        <?php if(!empty($short_description)){ echo wpautop($short_description); } ?>
                        <a href="<?php the_permalink(); ?>" class="knw_link">Know More <i class="fa-solid fa-angle-right"></i></a>
                        <?php if( $booking_button ):
                        $link_url = $booking_button['url'];
                        $link_title = $booking_button['title'];
                        $link_target = $booking_button['target'] ? $booking_button['target'] : '_self';
                        ?>
                        <a href="<?php echo esc_url($link_url); ?>" class="btn borderBrownBtn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?> <span><i class="fa-solid fa-angle-right"></i></span></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
            <?php wp_reset_postdata(); ?>
        </div> 
    </div>
</section>
<?php endif; ?>


<?php $second_section = get_field('second_section'); 
if ( $second_section ) : ?>
<section class="servc_sec3">
    <div class="container">
        <div class="row">
            <?php foreach( $second_section as $post ) : 
            setup_postdata( $post );
            $short_description = get_field('short_description');
            $booking_button = get_field('booking_button'); ?>
            <div class="col-lg-4 col-md-6">
                <div class="service_card">
                    <?php the_post_thumbnail('full'); ?>
                    <div class="txt">
                        <h3><?php the_title(); ?></h3>
                        <?php if(!empty($short_description)){ echo wpautop($short_description); } ?>
                        <a href="<?php the_permalink(); ?>" class="knw_link">Know More <i class="fa-solid fa-angle-right"></i></a>
                        <?php if( $booking_button ):
                        $link_url = $booking_button['url'];
                        $link_title = $booking_button['title'];
                        $link_target = $booking_button['target'] ? $booking_button['target'] : '_self';
                        ?>
                        <a href="<?php echo esc_url($link_url); ?>" class="btn borderBrownBtn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?> <span><i class="fa-solid fa-angle-right"></i></span></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
            <?php wp_reset_postdata(); ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Testimonials -->
<?php $testimonial_title = get_field('testimonial_title', 'option');
$testimonial_sub_title = get_field('testimonial_sub_title', 'option'); ?>
<?php $args1 = array('post_type' => 'testimonial', 'posts_per_page' => -1 );
$loop1 = new WP_Query($args1); ?>
<?php if ( $loop1->have_posts() ){ ?>
<section class="hmSec5">
    <div class="container">
        <div class="headingTxt text-center mb40">
            <div class="row">
                <div class="col-lg-6 col-md-8 m-auto">
                    <?php if(!empty($testimonial_title)){ ?><h3><?php echo $testimonial_title; ?> </h3><?php } ?>
                    <?php if(!empty($testimonial_sub_title)){ ?><h2><?php echo $testimonial_sub_title; ?></h2><?php } ?>
                </div>
            </div>
        </div>
    </div>
    <div class="groupSwiper">
        <!-- Swiper -->
        <div class="swiper clientSwiper">
            <div class="swiper-wrapper">
                <?php while ($loop1->have_posts()) : $loop1->the_post();
                $designation = get_field('designation');
                $star_rating = get_field('star_rating');
                $content = get_the_content();
                $content_no_p = str_replace(['<p>', '</p>'], '', $content); ?>
                <div class="swiper-slide">
                    <div class="clientGroup">
                        <div class="user_cicrle">
                            <?php the_post_thumbnail('full'); ?>
                        </div>
                        <?php if ( $star_rating ) {
                            echo '<div class="user_rate_stars">';

                            for ( $i = 1; $i <= 5; $i++ ) {
                                if ( $i <= $star_rating ) {
                                    echo '<span class="fa fa-star checked"></span>';
                                } else {
                                    echo '<span class="fa fa-star"></span>';
                                }
                            }

                            echo '</div>';
                        }
                        ?>
                        <p>"<?php echo $content_no_p; ?>"</p>
                        <h5><?php the_title(); ?></h5>
                        <h6><?php echo $designation; ?></h6>
                    </div>
                </div>
                <?php  endwhile; ?>
            </div>
            
        </div>
        <div class="swiper-button-next otherNext"></div>
        <div class="swiper-button-prev otherPrev"></div>
    </div>
</section>
<?php } ?>
<?php wp_reset_postdata(); ?>
<!-- ! Main end ! -->

<?php get_footer();




