<?php
/* Template Name: Training */
get_header();
$banner_content = get_field('banner_content');
$video = get_field('video');
$video_poster = get_field('video_poster');
$video_content = get_field('video_content');
$training_content = get_field('training_content');
$training_info = get_field('training_info');
$section_3_content = get_field('section_3_content'); 
$section_3_info = get_field('section_3_info'); 
$sort_description = get_field('sort_description');
$section_4_image = get_field('section_4_image');
$section_4_content = get_field('section_4_content');
$section_4_button_1 = get_field('section_4_button_1');
$section_4_button_2 = get_field('section_4_button_2'); ?>

<?php if(!empty($banner_content)){ ?>
<section class="training_bnnr">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <?php echo wpautop($banner_content); ?>
            </div>
        </div>
    </div>
</section>
<?php } ?>

<?php if(!empty($video)){ ?>
<section class="training_sec2">
    <div class="container">
        <div class="row">
            <div class="col-12">
                
                <div class="video">
                    <video id="myVideo" src="<?php echo $video['url']; ?>"
                        poster="<?php echo $video_poster['url']; ?>"></video>

                    <a href="#!" id="playBtn" class="play_button">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/play_icon2.png" alt="">
                    </a>
                </div>
                
                <?php if(!empty($video_content)){ ?>
                <div class="txt">
                    <?php echo wpautop($video_content); ?>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
</section>
<?php } ?>

<?php if(!empty($training_info)){ ?>
<section class="training_sec3">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <?php if(!empty($training_content)){ echo wpautop($training_content); } ?>
            </div>
            <div class="certificion_divs">

                <?php foreach( $training_info as $info ) {
                $button = $info['button']; // Replace with your sub field name
                $link_url = $button['url'];
                $link_title = $button['title'];
                $link_target = $button['target'] ? $button['target'] : '_self';
                $image = $info['image'];
                $title = $info['title']; 
                $day = $info['day'];
                $price = $info['price'];
                $tag = $info['tag'];
                $content = $info['content'];
                $learn_about_title = $info['learn_about_title'];
                $learn_list = $info['learn_list'];
                $has_features = $info['has_features'];
                $feature_title = $info['feature_title'];
                $features_list = $info['features_list']; 
                $bottom_content = $info['bottom_content'];
                $short_description = $info['short_description']; ?>
                <div class="row">
                    <div class="col-lg-5">
                        <?php if(!empty($image)){ ?><img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>" class="side_img"><?php } ?>
                    </div>
                    <div class="col-lg-7">
                        <?php if(!empty($title)){ ?><h3><?php echo $title; ?></h3><?php } ?>
                        <div class="dtls">
                            <?php if(!empty($day)){ ?><span class="day"><?php echo $day; ?></span><?php } ?>
                            <?php if(!empty($price)){ ?><span class="price"><?php echo $price; ?></span><?php } ?>
                            <?php if(!empty($tag)){ ?><span class="tag"><?php echo $tag; ?></span><?php } ?>
                        </div>
                        <?php if(!empty($content)){ ?>
                        <div class="txt">
                            <?php echo wpautop($content); ?>
                        </div>
                        <?php } ?>
                        <?php if(!empty($learn_list)){ ?>
                        <div class="list">
                            <?php if(!empty($learn_about_title)){ ?><h6><?php echo $learn_about_title; ?></h6><?php } ?>
                            <ul>
                                <?php foreach( $learn_list as $list ) { ?>
                                <li><?php echo $list['list']; ?></li>
                                <?php } ?>
                            </ul>
                        </div>
                        <?php } ?>
                        <?php if(!empty($has_features)){ ?>
                        <div class="list2">
                            <?php if(!empty($feature_title)){ ?><h6><?php echo $feature_title; ?></h6><?php } ?>
                            <?php if(!empty($features_list)){ ?>
                            <ul>
                                <?php foreach( $features_list as $list ) { ?>
                                <li><?php echo $list['list']; ?></li>
                                <?php } ?>
                            </ul>
                            <?php } ?>
                        </div>
                        <?php } ?>
                        <?php if(!empty($bottom_content)){ ?>
                        <div class="txt">
                            <?php echo wpautop($bottom_content);  ?>
                        </div>
                        <?php } ?>
                        <div class="btm_prt">
                            <?php if(!empty($button)){ ?>
                            <a href="<?php echo esc_url($link_url); ?>" class="btn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?><span><i class="fa-solid fa-angle-right"></i></span></a>
                            <?php } ?>
                            <?php if(!empty($short_description)){ ?><span><?php echo $short_description;  ?></span><?php } ?>
                        </div>
                    </div>
                </div>
                <?php } ?>

            </div>
        </div>
    </div>
</section>
<?php } ?>

<section class="training_sec4">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6">
                <?php the_content(); ?>
            </div>
            <div class="col-md-6">
                <?php the_post_thumbnail('full'); ?>
            </div>
        </div>
    </div>
</section>

<?php if(!empty($section_3_info)){ ?>
<section class="training_sec5">
    <div class="container">

        <div class="row">
            <div class="col-12">
                <?php if(!empty($section_3_content)){ ?>
                <div class="top_txt">
                    <?php echo wpautop($section_3_content); ?>
                </div>
                <?php } ?>
                <ul>
                    <?php foreach( $section_3_info as $info ) {
                    $title = $info['title'];
                    $content = $info['content'];
                    $icon = $info['icon']; ?>
                    <li>
                        <?php if(!empty($title)){ ?><span><?php echo $title; ?></span><?php } ?>
                        <?php if(!empty($content)){ echo $content; } ?>
                        <?php if(!empty($icon)){ ?>
                        <div class="icon">
                            <img src="<?php echo $icon['url']; ?>" alt="<?php echo $icon['alt']; ?>">
                        </div>
                        <?php } ?>
                    </li>
                    <?php } ?>
                </ul>
                <?php if(!empty($sort_description)){ ?>
                <span class="highlight"><?php echo $sort_description; ?></span>
                <?php } ?>
            </div>
        </div>
    </div>
</section>
<?php } ?>

<?php if(!empty($section_4_image)){ ?>
<section class="servicrs-detail-sec4 training_sec5">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="content-wraper">
                    <img src="<?php echo $section_4_image['url']; ?>" alt="<?php echo $section_4_image['alt']; ?>" class="bg-img">
                    <div class="text-wraper">
                        <?php if(!empty($section_4_content)){ echo wpautop($section_4_content); } ?>
                        <div class="btn-wraper">
                            <?php if( $section_4_button_1 ):
                            $link_url = $section_4_button_1['url'];
                            $link_title = $section_4_button_1['title'];
                            $link_target = $section_4_button_1['target'] ? $section_4_button_1['target'] : '_self'; ?>
                            <a href="<?php echo esc_url($link_url); ?>" class="btn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?><span><i class="fa-solid fa-angle-right"></i></span></a>
                            <?php endif; ?>
                            <?php if( $section_4_button_2 ):
                            $link_url = $section_4_button_2['url'];
                            $link_title = $section_4_button_2['title'];
                            $link_target = $section_4_button_2['target'] ? $section_4_button_2['target'] : '_self'; ?>
                            <a href="<?php echo esc_url($link_url); ?>" class="btn borderBrownBtn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?> <span><i class="fa-solid fa-angle-right"></i></span></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php } ?>
<?php get_footer();




