<?php
/**
 * The template for displaying all single services
 */
get_header(); ?>
<?php $banner_image = get_field('banner_image');
$parent_page = get_field('parent_page');
$banner_title = get_field('banner_title'); ?>
<section class="inner_banner">
    <?php if(!empty($banner_image)){ ?><img src="<?php echo esc_url($banner_image['url']); ?>" alt="<?php echo esc_url($banner_image['alt']); ?>" class="bg"><?php }else{ ?><img src="<?php echo get_template_directory_uri(); ?>/assets/images/inner-banner1.png" alt="Inner Banner" class="bg"><?php } ?>
    <div class="top">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <ul class="brdcump">
                        <?php if( $parent_page ){
                        $link_url = $parent_page['url'];
                        $link_title = $parent_page['title'];
                        $link_target = $parent_page['target'] ? $parent_page['target'] : '_self';
                        ?>
                        <li><a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?></a></li>
                        <?php }else{ ?>
                        <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>services">Services</a></li>
                        <?php } ?>
                        <?php if(!empty($banner_title)){ ?><li><?php echo $banner_title; ?></li><?php }else{ ?><li><?php the_title(); ?></li><?php } ?>
                    </ul>
                    <?php if(!empty($banner_title)){ ?><h1><?php echo $banner_title; ?></h1><?php }else{ ?><h1><?php the_title(); ?></h1><?php } ?>
                </div>
            </div>
        </div>
    </div>
</section>


<?php $short_description = get_field('short_description');
$content = get_post()->post_content; ?>
<section class="what_is">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <?php if ( !empty( trim( $content ) ) ) { the_content(); }else{  echo wpautop($short_description);  } ?>
            </div>
        </div>
    </div>
</section>


<?php $other_service_text = get_field('other_service_text');
$other_service_sub_text = get_field('other_service_sub_text');
$related_services = get_field('related_services');
$related_services = get_field('related_services'); 
if ( $related_services ) : ?>
<section class="therapies">
    <div class="container">
        <div class="headingTxt mb40 text-center">
            <div class="row">
                <div class="col-md-6 m-auto">
                    <?php if(!empty($other_service_text)){ ?><h3><?php echo $other_service_text; ?> </h3><?php } ?>
                    <?php if(!empty($other_service_sub_text)){ ?><h2><?php echo $other_service_sub_text; ?></h2><?php } ?>
                </div>
            </div>
        </div>

        <div class="row">
            <?php foreach( $related_services as $post ) : 
            setup_postdata( $post );
            $short_description = get_field('short_description');
            $booking_button = get_field('booking_button'); ?>
            <div class="col-lg-4 col-md-6">
                <div class="service_card">
                    <?php the_post_thumbnail('full'); ?>
                    <div class="txt">
                        <h3><?php the_title(); ?></h3>
                        <?php if(!empty($short_description)){ echo wpautop($short_description); } ?>
                        <a href="<?php the_permalink(); ?>" class="knw_link">View Service <i class="fa-solid fa-angle-right"></i></a>
                        <?php if( $booking_button ):
                        $link_url = $booking_button['url'];
                        $link_title = $booking_button['title'];
                        $link_target = $booking_button['target'] ? $booking_button['target'] : '_self';
                        ?>
                        <a href="<?php echo esc_url($link_url); ?>" class="btn borderBrownBtn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?><span><i class="fa-solid fa-angle-right"></i></span></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
            <?php wp_reset_postdata(); ?>
        </div>
    </div>
</section>
<?php endif; ?>


<?php $session_content = get_field('session_content');
$session_image = get_field('session_image');
if(!empty($session_content)){ ?>
<section class="servicrs-detail-sec2">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-5 col-md-6">
                <?php  echo wpautop($session_content); ?>
            </div>
            <?php if(!empty($session_image)){ ?>
            <div class="col-lg-6 col-md-6 ms-auto">
                <img src="<?php echo $session_image['url']; ?>" alt="<?php echo $session_image['alt']; ?>" class="right-img">
            </div>
            <?php } ?>
        </div>
    </div>
</section>
<?php } ?>


<?php $gallery = get_field('gallery');
if( $gallery ): ?>
<section class="servicrs-detail-sec3">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="img-wraper">
                    <?php foreach( $gallery as $image ): ?>
                    <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>">
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>


<?php $last_image = get_field('last_image');
$last_title = get_field('last_title');
$last_button_1 = get_field('last_button_1');
$last_button_2 = get_field('last_button_2'); 
if ( $last_image ) : ?>
<section class="servicrs-detail-sec4">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="content-wraper">
                    <img src="<?php echo $last_image['url']; ?>" alt="<?php echo $last_image['alt']; ?>" class="bg-img">
                    <div class="text-wraper">
                        <?php if(!empty($last_title)){ ?><h3><?php echo $last_title; ?></h3><?php } ?>
                        <div class="btn-wraper">
                            <?php if(!empty($last_button_1)){
                            $link_url = $last_button_1['url'];
                            $link_title = $last_button_1['title'];
                            $link_target = $last_button_1['target'] ? $last_button_1['target'] : '_self'; ?><a href="<?php echo esc_url($link_url); ?>" class="btn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?><span><i class="fa-solid fa-angle-right"></i></span></a><?php } ?>

                            <?php if(!empty($last_button_2)){
                            $link_url = $last_button_2['url'];
                            $link_title = $last_button_2['title'];
                            $link_target = $last_button_2['target'] ? $last_button_2['target'] : '_self'; ?><a href="<?php echo esc_url($link_url); ?>" class="btn borderBrownBtn" target="<?php echo esc_attr($link_target); ?>"><?php echo esc_html($link_title); ?> <span><i class="fa-solid fa-angle-right"></i></span></a><?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>


<?php get_footer();



